import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const FETCH_DETAIL = 'FETCH_DETAIL';
export const FETCH_DETAIL_SUCCESS = 'FETCH_DETAIL_SUCCESS';
export const FETCH_DETAIL_FAILURE = 'FETCH_DETAIL_FAILURE';

export const fetchDetail = createAction(FETCH_DETAIL);
export const fetchDetailSuccess = createAction(FETCH_DETAIL_SUCCESS);
export const fetchDetailFailure = createAction(FETCH_DETAIL_FAILURE);
// 初始state
export const INITIAL_STATE = immutable({
  // pageId: 0,
  // fetching: false,
  // error: null,
  // data: {},
  // itemId: 0
});

export default handleActions({
  [FETCH_DETAIL]: (state, { payload }) => state.merge({ [payload.pageId]: { fetching: true, error: null, itemId: payload.itemId, data: null } }),
  [FETCH_DETAIL_SUCCESS]: (state, { payload }) => {
    if (state[payload.pageId]) {
      return state.set(payload.pageId, state[payload.pageId].merge({ fetching: false, error: null, data: payload.data, itemId: payload.itemId }));
    }
    return state;
  },
  [FETCH_DETAIL_FAILURE]: (state, { payload }) => state.set(payload.pageId, state[payload.pageId].merge({ fetching: false, error: payload.error, itemId: payload.itemId }))
}, INITIAL_STATE);
