// import { createAction, handleActions } from 'redux-actions';
import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const LOGIN = 'LOGIN';
export const LOGIN_SUCCESS = 'LOGIN_SUCCESS';
export const LOGIN_FAILURE = 'LOGIN_FAILURE';
export const LOGIN_UNBIND = 'LOGIN_UNBIND';
export const LOGOUT = 'LOGOUT';

// 请求登录action
export const login = createAction(LOGIN);

// 注销action
export const logout = createAction(LOGOUT);

// 登录成功
export const loginSuccess = createAction(LOGIN_SUCCESS);

// 登录失败
export const loginFailure = createAction(LOGIN_FAILURE);

export const loginUnbind = createAction(LOGIN_UNBIND);

// 初始state
export const INITIAL_STATE = immutable({
  UserId: null,
  error: null,
  fetching: false,
  logining: false,
  unbind: false,
  wxLogined: false
});

export default handleActions({
  [LOGIN]: (state) => state.merge({ fetching: true, logining: true, error: null, unbind: false, UserId: null, wxLogined: false }),
  [LOGOUT]: () =>   INITIAL_STATE,
  [LOGIN_SUCCESS]: (state, action) => state.merge({ unbind: false, fetching: false, error: null, wxLogined: true }).merge(action.payload),
  [LOGIN_FAILURE]: (state, action) => state.merge({ fetching: false, logining: false, error: action.payload }),
  [LOGIN_UNBIND]: (state) => state.merge({ fetching: false, unbind: true, logining: false })
}, INITIAL_STATE);
