import AsyncStorage from '../utils/storage';
import immutableTransform from '../utils/immutable-transform';

// Redux 数据持久化设置
export default {
    storage: AsyncStorage,
    //blacklist: ['login', 'customer', 'PAGE', 'MENU', 'CUSER', 'CATEGORY', 'ELEMENT', 'PATTERN', 'STATUS', 'STATUSMAP'], // 可选，你【不想】存储的Redux store数据key列表
    whitelist: [
        'category',
        'cache',
        'department',
        'pattern',
        'page',
        'menu',
        'cuser',
        'statusMap',
        'often',
        'join',
        'setting',
        'pageConfig',
        'workflow',
        'configuration'
    ], // 可选，你【只想】存储的Redux store数据key列表
    transforms: [ immutableTransform ]
};
