import { formatDate, uuid } from '../utils/utils';

import config from '../config/config';
import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const SIG_MESSAGE = 'SIG_MESSAGE';
export const SIG_SEND_MESSAGE = 'SIG_SEND_MESSAGE';
export const CONNECT_SIG = 'CONNECT_SIG';
export const SIG_USERS = 'SIG_USERS';
export const SIG_FETCH_USERS = 'SIG_FETCH_USERS';
export const PREVIOUS_MESSAGE = 'PREVIOUS_MESSAGE';
export const FETCH_PREVIOUS_MESSAGE = 'FETCH_PREVIOUS_MESSAGE';
export const SIG_USER_OFFLINE = 'SIG_USER_OFFLINE';
export const SIG_USER_ONLINE = 'SIG_USER_ONLINE';
export const CONNECT_SIG_ERROR = 'CONNECT_SIG_ERROR';
export const SIG_ERROR = 'SIG_ERROR';
export const CONNECT_SIG_SUCCESS = 'CONNECT_SIG_SUCCESS';
export const SIG_STATE_CHANGED = 'SIG_STATE_CHANGED';
export const SIG_CURRENT_USER = 'SIG_CURRENT_USER';
export const SIG_CLEAR_UNREAD = 'SIG_CLEAR_UNREAD';

// 初始state
// connecting: 0,
// connected: 1,
// reconnecting: 2,
// disconnected: 4

export const INITIAL_STATE = immutable({
  error: null,
  status: 4,
  users: [],
  messages: {},
  chatWith: '',
  me: '',
  newMessages: 0,
  connectedWhen: ''
});

export const signalrMsg = createAction(SIG_MESSAGE);
export const signalrSendMsg = createAction(SIG_SEND_MESSAGE);
export const connectSignalr = createAction(CONNECT_SIG);
export const connectSignalrError = createAction(CONNECT_SIG_ERROR);
export const connectSignalrSuccess = createAction(CONNECT_SIG_SUCCESS);
export const signalrError = createAction(SIG_ERROR);
export const signalrUsers = createAction(SIG_USERS);
export const signalrFetchUsers = createAction(SIG_FETCH_USERS);
export const signalrPreMsg = createAction(PREVIOUS_MESSAGE);
export const signalrFetchPreMsg = createAction(FETCH_PREVIOUS_MESSAGE);
export const signalrUserOnline = createAction(SIG_USER_ONLINE);
export const signalrUserOffline = createAction(SIG_USER_OFFLINE);
export const signalrStateChanged = createAction(SIG_STATE_CHANGED);
export const signalrCurrentUser = createAction(SIG_CURRENT_USER);
export const signalrClearUnread = createAction(SIG_CLEAR_UNREAD);

export default handleActions({
  [CONNECT_SIG_ERROR]: (state, { payload }) => {
    return state.merge({ error: payload.error });
  },
  [SIG_ERROR]: (state, { payload }) => {
    return state.merge({ error: payload[0] });
  },
  [SIG_STATE_CHANGED]: (state, { payload }) => {
    if (payload[0].newState === 1) {
      state = INITIAL_STATE.merge({ connectedWhen: formatDate(new Date(), 'yyyy-MM-dd hh:mm:ss') });
    }
    return state.merge( { status: payload[0].newState } );
  },
  [SIG_USERS]: (state, { payload }) => {
    return state.merge({ users: payload[0].map(i=>Object.assign({ online: i.IsApproved, newMessages: i.cnt }, i)) || [] });
  },
  [SIG_MESSAGE]: (state, { payload }) => {
    const chatWith = state.chatWith || payload[0].UserId;
    const oldMessage = state.messages[chatWith] || { pageIndex: 0, messages: [] };
    const message = {
      messageId: uuid(),
      messageWhen: formatDate(new Date(), 'yyyy-MM-ddThh:mm:ss'),
      messageContent: payload[1],
      fromUserId: payload[0].UserId,
      toUserId: state.me === payload[0].UserId ? state.chatWith : state.me,
    };
    const newData = { pageIndex: oldMessage.pageIndex, messages: oldMessage.messages.concat([message]) };
    if (oldMessage.messages.length >= config.fetchSize - 1) {
      newData.currentTag = `m${message.messageId}`;
    }
    state = state.setIn(['messages', chatWith], newData);
    const ui = state.users.findIndex(u => u.UserId === chatWith);
    let newMessages = 0;
    if (ui >= 0) {
      newMessages = payload[0].UserId !== state.me && payload[0].UserId !== state.chatWith ? state.users[ui].newMessages + 1 : 0;

      state = state.setIn(['users', ui], Object.assign({}, state.users[ui], { newMessages, messageContent: message.messageContent, messageWhen: message.messageWhen }));
    }
    let totalNew = 0;
    state.users.forEach(u => totalNew += (u.newMessages || 0));
    state = state.set('newMessages', totalNew);
    return state;
  },
  [SIG_CURRENT_USER]: (state, { payload }) => {
    if (payload.chatWith) {
      const oldMessage = state.messages[payload.chatWith] || { pageIndex: 0, messages: [] };
      state = state.setIn(['messages', payload.chatWith], oldMessage);
      const ui = state.users.findIndex(u => u.UserId === payload.chatWith);

      const newData = { noSetTag: oldMessage.messages.length < config.fetchSize };
      if (oldMessage.messages.length >= config.fetchSize) {
        newData.currentTag = `m${oldMessage.messages[oldMessage.messages.length - 1].messageId}`;
      }
      state = state.setIn(['messages', payload.chatWith], Object.assign({}, oldMessage, newData));

      if (ui >= 0) {
        state = state.setIn(['users', ui], Object.assign({}, state.users[ui], { newMessages: 0 }));
        let totalNew = 0;
        state.users.forEach(u => totalNew += (u.newMessages || 0));
        state = state.set('newMessages', totalNew);
      }
    }
    return state.merge(payload);
  },
  [PREVIOUS_MESSAGE]: (state, { payload }) => {
    const oldMessage = state.messages[payload[0]] || { pageIndex: 0, messages: [] };
    if (payload[1].length > 0) {
      payload[1].reverse();

      const newData = { pageIndex: oldMessage.pageIndex + 1, messages: payload[1].concat(oldMessage.messages), noSetTag: false };

      if (oldMessage.noSetTag && oldMessage.messages.length > 0) {
        newData.currentTag = `m${oldMessage.messages[oldMessage.messages.length - 1].messageId}`;
      } else {
        newData.currentTag = `m${payload[1][payload[1].length - 1].messageId}`;
      }

      return state.setIn(['messages', payload[0]], Object.assign({}, oldMessage, newData));
    } else {
      return state.setIn(['messages', payload[0]], Object.assign({}, oldMessage, { fetchedAll: true }));
    }
    return state;
  },
  [SIG_USER_ONLINE]: (state, { payload }) => {
    const index = state.users.findIndex(i => i.UserId = payload[0].UserId);
    if (index >= 0) {
      return state.setIn(['users', index], Object.assign({ online: true }, state.users[index], payload[0]));
    } else {
      return state.set('users', state.users.concat([Object.assign({ online: true }, payload[0])]));
    }
  },
  [SIG_USER_OFFLINE]: (state, { payload }) => {
    const index = state.users.findIndex(i => i.UserId = payload[0].UserId);
    if (index >= 0) {
      return state.setIn(['users', index], Object.assign({ online: false }, state.users[index], payload[0]));
    } else {
      return state.set('users', state.users.concat([Object.assign({ online: false }, payload[0])]));
    }
  }
}, INITIAL_STATE);
