// import { createAction, handleActions } from 'redux-actions';
import createAction from '../lib/redux-actions/lib/createAction';
import handleActions from '../lib/redux-actions/lib/handleActions';
import immutable from '../lib/seamless-immutable/src/seamless-immutable';

export const REFRESH_USER = 'REFRESH_USER';
export const LOAD_USER = 'LOAD_USER';
export const CLEAR_USER = 'CLEAR_USER';

// 初始state
export const INITIAL_STATE = immutable({
  UserId: '',
  XingMing: '',
  companyId: 0,
  cookie: '',
  fileServer: '',
  isAdmin: false,
  key: '',
  uploadKey: '',
  wx: {}
});

export const refreshUser = createAction(REFRESH_USER);
export const loadUser = createAction(LOAD_USER, (user) => (user));
export const clearUser = createAction(CLEAR_USER);

export default handleActions({
  [LOAD_USER]: (state, action) => {
    return state.merge(action.payload);
  }
}, INITIAL_STATE);
