import { call, put, select } from '../lib/redux-saga/lib/internal/io';
import { fetchCacheFailure, fetchCacheSuccess } from '../redux/cache';
import regeneratorRuntime from '../lib/regenerator-runtime/runtime';

import log from '../utils/log';

export default function* cacheSaga(action) {
    const { pageId, jobs } = action.payload;
    try {
        const data = [];
        for (let ii = 0; ii < jobs.length; ii++) {
            const ret = yield jobs[ii]();
            if (ret.data && ret.relatedData) {
                let ii = 0;
                while (ii < ret.data.length) {
                    const related = ret.relatedData[ii];
                    if (related) {
                        ret.data[ii].related = [ related ];
                    } else {
                        ret.data[ii].related = [];
                    }

                    ii += 1;
                }
            }
            data.push(ret.data ? ret.data : ret);
        }

        yield put(
            fetchCacheSuccess({
                pageId,
                data
            })
        );
    } catch (error) {
        log('cacheSaga error', error);
        yield put(fetchCacheFailure({ pageId, error }));
    }
}
