import { CONFIRM_FILTER, INIT_FILTER } from '../redux/filter';
import {
    CONNECT_SIG,
    FETCH_PREVIOUS_MESSAGE,
    SIG_CLEAR_UNREAD,
    SIG_FETCH_USERS,
    SIG_SEND_MESSAGE
} from '../redux/signalr';
import { actionChannel, call, take } from '../lib/redux-saga/lib/internal/io';
import { confirmFilterSaga, initFilterSaga } from './filter';
import signalrSaga, { signalrOpSaga } from './signalr';

import { FETCH_DETAIL } from '../redux/detail';
import { FETCH_LIST } from '../redux/list';
import { LOGIN } from '../redux/login';
import { STARTUP } from '../redux/startup';
import detail from './detail';
import list from './list';
import login from './login';
import startUp from './startup';
import regeneratorRuntime from '../lib/regenerator-runtime/runtime';
import { takeLatest } from '../lib/redux-saga/lib/internal/sagaHelpers';
import { FETCH_CACHE } from '../redux/cache';
import cache from './cache';

function* watcher(pattern, saga, ...args) {
    while (true) {
        const action = yield take(pattern);
        yield call(saga, ...args.concat(action));
    }
}

function* takeOneAtMost(pattern, saga, ...args) {
    const chan = yield actionChannel(pattern);
    while (true) {
        const action = yield take(chan);
        yield call(saga, ...args.concat(action));
    }
}

function* runOne(action) {
    if (action.type === FETCH_LIST) {
        yield* list(action);
    } else if (action.type === FETCH_CACHE) {
        yield* cache(action);
    } else if (action.type === FETCH_DETAIL) {
        yield* detail(action);
    } else if (action.type === INIT_FILTER) {
        yield* initFilterSaga(action);
    } else if (action.type === CONFIRM_FILTER) {
        yield* confirmFilterSaga(action);
    }
}

// 当action触发时，执行特定saga
export default function* root() {
    yield [
        takeLatest(STARTUP, startUp),
        takeLatest(LOGIN, login),
        takeLatest(CONNECT_SIG, signalrSaga),
        takeLatest(SIG_FETCH_USERS, signalrOpSaga),
        takeLatest(SIG_SEND_MESSAGE, signalrOpSaga),
        takeLatest(FETCH_PREVIOUS_MESSAGE, signalrOpSaga),
        takeLatest(SIG_CLEAR_UNREAD, signalrOpSaga),
        takeOneAtMost([ INIT_FILTER, FETCH_LIST, FETCH_CACHE, FETCH_DETAIL, CONFIRM_FILTER ], runOne)
    ];
}
