import { call, fork, put, take, select } from '../lib/redux-saga/lib/internal/io';
import { checkLoginStatus, linkWx2, login, wxLogin } from '../utils/request';
import { logout, loginFailure, loginSuccess, loginUnbind } from '../redux/login';

import config from '../config/config';
import { initPage } from '../redux/allpage';
import { resetFilter } from '../redux/filter';
import { initColumn } from './pageConfigs';
import { loadUser } from '../redux/user';
import log from '../utils/log';
import regeneratorRuntime from '../lib/regenerator-runtime/runtime';
import storage from '../utils/storage';
import { configSetting } from '../redux/setting';

const getState = (state) => ({
    setting: state.setting
});

export default function* loginSaga(action) {
    try {
        const localData = yield select(getState);

       let extra =action.payload&&action.payload.extra?action.payload.extra:{};

       if (extra.logout){
           yield put(
               loadUser({
                 UserId: '',
                 XingMing: '',
                 companyId: 0,
                 cookie: '',
                 fileServer: '',
                 isAdmin: false,
                 key: '',
                 uploadKey: '',
                 wx: {}
               })
           );
            yield put( logout() );
            console.log('logout');
            return;
       }


        let wxRes = yield call(wxLogin);
        // yield put(loginSuccess({}));
        //  let user = yield call(login, 'david', 'ylhy123');
        // let user = yield call(login, '13182968821', '123123');
        //  let user = yield call(login, 'xxxxxx', '123123');
        //



        extra.wxwork = wxRes.wxwork;

        let user = yield call(
            linkWx2,
            wxRes.userInfo.nickName,
            wxRes.userInfo.avatarUrl,
            wxRes.code,
            extra
        );

      //  let user = yield call(login, 'mvcx', 'mvcx');

        if (action.payload && action.payload.checker) {
            const checked = action.payload.checker(user);
            if (typeof checked === 'string' || !checked) {
                yield put(
                    loginFailure({
                        message: typeof checked === 'string' ? checked : ''
                    })
                );
                return;
            }
        }

        const setting = {};
        if (localData.setting.lastUser !== user.UserId) {
            yield call(initColumn);
            yield put(initPage());
            yield put(resetFilter());
            // console.log('清空缓存');

            setting.lastUser = localData.setting.username;
            yield put(configSetting(setting));
        }

        user.wx = wxRes.userInfo;
        getApp().cacheTime = user.cachetime[0].cacheTime;
        yield put(
            loadUser(Object.assign({ server_identity: user.UserId, ID: user.UserId, primaryText: user.XingMing }, user))
        );
        yield put(loginSuccess({ logining: false }));
    } catch (error) {
        log('loginSaga error', error);
        yield put(loginFailure(error));
    }
}
