import { call, put, select } from '../lib/redux-saga/lib/internal/io';
import { parseColumns } from '../utils/utils2';
import globalConfigs, { getCacheTime } from './globalConfigs';
import log, { mark } from '../utils/log';
import storage from '../utils/storage';
import regeneratorRuntime from '../lib/regenerator-runtime/runtime';

let columnKeys = null;
let columnCache = {};

export function initColumn() {
    columnKeys = {};
    return storage.removeItem('columnKeys');
}

const getState = (state) => ({
    page: state.page,
    statusMap: state.statusMap,
    join: state.join,
    column: state.column
});

export default function* pageConfigSaga(action) {
    const { pageId } = action.payload;
    try {
        const configs = yield* globalConfigs();
        if (configs) {
            const { page, statusMap, join } = yield select(getState);

            let cacheTime = yield* getCacheTime();

            if (!columnKeys) {
                try {
                    columnKeys = yield call(storage.getItem, 'columnKeys');
                } catch (error) {
                    columnKeys = {};
                }
            }

            mark('loadColumns');
            const columnKey = `column${pageId}`;
            let column;
            if (!columnCache[pageId]) {
                try {

                    column = yield call(storage.getItem, columnKey);
                } catch (error) {

                    column = {};
                }
                columnCache[pageId] = column;
            } else {

                column = columnCache[pageId];
            }

            mark('loadColumns', 'loadColumnsEnd');

            let localCacheTime = column ? column.cacheTime : '';
            const needFetch = cacheTime !== localCacheTime

            // || !columnKeys[pageId];  ssong  0722



            const columnData = yield call(parseColumns, pageId, {
                allPages: page.data,
                statusMap: statusMap.data,
                join: join.data,
                workflow: configs.workflow.data,
                column: column && column.data,
                needFetch
            });

            log('pageConfigSaga', { pageId, needFetch, columnKeys: JSON.stringify(columnKeys) });
            if (needFetch) {
                columnKeys[pageId] = 1;
                columnCache[pageId] = { cacheTime, data: columnData.columns };
                yield call(storage.setItem, 'columnKeys', columnKeys);
                yield call(storage.setItem, columnKey, columnCache[pageId]);
            }

            return columnData;
        }
    } catch (error) {
        log('pageConfigSaga error', error);
    }
}
