import { initPage } from '../redux/allpage';
import { initColumn } from './pageConfigs';
import storage from '../utils/storage';
import { call, fork, put, take } from '../lib/redux-saga/lib/internal/io';
import regeneratorRuntime from '../lib/regenerator-runtime/runtime';
import config from '../config/config'
import log from '../utils/log';

export default function* startUpSaga() {
  let cacheVersion = '';
  try {
    cacheVersion = yield call(storage.getItem, 'cacheVersion');
  } catch (error) {
    log('cacheVersion', error);
  }
  if (cacheVersion != config.cacheVersion) {
    yield call(storage.setItem, 'cacheVersion', config.cacheVersion);
    yield call(initColumn);
    yield put(initPage());
  }
}
