const mixin = require('../lib/smart-mixin');

import { getObjectClass } from './utils';
import log from './log';
import uniq from '../lib/lodash/uniq';

const mixinAll = mixin({}, {
  unknownFunction: mixin.MANY_RIGHT
});

function mixinClass(weClass, weMixin) {
  const leftClass = getObjectClass(weClass);
  const rightClass = getObjectClass(weMixin);

  weMixin = Object.assign({}, weMixin);

  const mixinProto = mixin({
    onLoad: mixin.MANY_RIGHT,
    onReady: mixin.MANY_RIGHT,
    onShow: mixin.MANY_RIGHT,
    onFirstShow: mixin.MANY_RIGHT,
    onHide: mixin.MANY_RIGHT,
    onUnload: mixin.MANY_RIGHT,
    updateRedux: mixin.MANY_RIGHT,
    methods: (left, right, key) => {
      if (typeof left === 'undefined') {
        return right;
      } else if (typeof right === 'undefined') {
        return left;
      }
      left = Object.assign({}, left);
      for(let key in right) {
        if (left[key]) {
          log(`警告: ${leftClass} ${rightClass} methods中${key}重复，将产生链式调用`);
        } else {
          left[key] = undefined;
        }
      }
      mixinAll(left, right);
      return left;
    }
  }, {
    unknownFunction: mixin.ONCE_WARN,
    nonFunctionProperty: (left, right, key) => {
      if (Array.isArray(left) && Array.isArray(right)) {
        return uniq(left.concat(right));
      }
      if (Array.isArray(right)) {
        return right;
      }
      if (typeof right !== 'undefined' && right !== null) {
        if (typeof right === 'object' && typeof left === 'object') {
          left = Object.assign({}, left);
          for(let key in right) {
            if (left[key]) {
              log(`警告: ${leftClass} ${rightClass} 属性${key}重复，将产生覆盖`);
            }
            left[key] = right[key];
          }
          return left;
        }
        return right;
      }
      return left;
    }
  });

  const prototypeMethods = {};

  Object.keys(weMixin).forEach(function(key){
    if (key === 'mixins' || key === 'statics') {
      return;
    }

    prototypeMethods[key] = weMixin[key];
  });

  mixinProto(weClass.prototype, prototypeMethods);

  // statics is a special case because it merges directly onto the class
  if (weMixin.statics) {
    Object
      .getOwnPropertyNames(weMixin.statics)
      .forEach(function (key) {
        var left = weClass[key];
        var right = weMixin.statics[key];

        if (left !== undefined && right !== undefined) {
          throw new TypeError('Cannot mixin statics because statics.' + key + ' and Component.' + key + ' are defined.');
        }

        weClass[key] = left !== undefined
          ? left
          : right;
      });
  }

  if (weMixin.mixins) {
    weMixin
      .mixins
      .reverse()
      .forEach(mixinClass.bind(null, weClass));
  }

  return weClass;
}

export default function(weClass, weMixins){
  class extendClass extends weClass {

  }
  let result = extendClass;
  weMixins.forEach(function(mixin){
    result = mixinClass(result, mixin);
  });
  return result;
}
