export default {

  /**
   * @param key
   * @param callback
   * @returns {*}
   */
   getItem(key, callback) {
     return new Promise((resolve, reject)=>{
       wx.getStorage({
        key,
        success(res){
          if(callback) callback(null, res.data)
          resolve(res.data)
        },
        fail(error){
          if(callback) callback(error)
          reject(error)
        }
      })
     })
  },
  /**
   * @param key
   * @param data
   * @param callback
   */
  setItem(key, data, callback) {
    return new Promise((resolve, reject)=>{
      wx.setStorage({
        key,
        data,
        success(){
          if(callback) callback(null)
          resolve()
        },
        fail(error){
          if(callback) callback(error)
          reject(error)
        }
      })
    })
  },

  /**
   * @param key
   * @param callback
   */
  removeItem(key, callback) {
    return new Promise((resolve, reject)=>{
      wx.removeStorage({
        key,
        success(){
          if(callback) callback(null)
          resolve()
        },
        fail(error){
          if(callback) callback(error)
          reject(error)
        }
      })
    })
  },

  /**
   * @param callback
   */
  clear() {
    wx.clearStorage();
  },

  /**
   * @param callback
   */
  getAllKeys(callback) {
    return new Promise((resolve, reject)=>{
      wx.getStorageInfo({
        success(res){
          if(callback) callback(null, res.keys)
          resolve(res.keys)
        },
        fail(error){
          if(callback) callback(error)
          reject(error)
        }
      })
    })
  }
};
