import config from '../config/config';
import isString from '../lib/lodash/isString';
import log, {
  mark
} from './log';
import {
  queryPy
} from './pinyin';
import storage from './storage';
import configStatus from '../config/status';
const regeneratorRuntime = require('../lib/regenerator-runtime/runtime');

export function fixedEncodeURIComponent(str) {
  return encodeURIComponent(str).replace(/[!'()*]/g, function (c) {
    return '%' + c.charCodeAt(0).toString(16);
  });
}

export function shouldUpdate(original, append) {
  if (!original) return true;
  if (original === append) return false;
  for (let key in append) {
    let value = append[key];
    if (typeof value === 'object' && value) {
      if (!value.asMutable || original[key] !== value) {
        return true;
      }
    } else if (original[key] !== value) {
      //bool string number null
      return true;
    }
  }
  return false;
}



export function wrapRow(attr)
{
    if ( typeof attr == 'object')
    {
       return attr.__value__;
    }
    else {
       return attr;
    }

}

export function sleep(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}

export default function pageInfoFromUrl(url) {
  const sharpInx = url.indexOf('#/');
  if (sharpInx > -1) {
    url = url.substr(sharpInx + 1);
  }
  const orgUrl = url;
  if (url.startsWith('/')) {
    url = url.substr(1);
  }
  const queryInx = url.indexOf('?');
  let query = null;
  if (queryInx > -1) {
    url = url.substring(0, queryInx);
    query = url.substr(queryInx + 1);
  }
  const arr = url.split('/');
  const parsedInfo = {
    pageDes: arr[0],
    categoryId: parseInt(arr[1]),
    pageId: parseInt(arr[3]),
    params: {},
    url: orgUrl,
    query
  };
  for (let ii = 4; ii < arr.length; ii += 2) {
    parsedInfo.params[arr[ii]] = arr[ii + 1];
  }
  return parsedInfo;
}

export function pageFullInfo(url, pages) {
  const parsedInfo = pageInfoFromUrl(url);
  return Object.assign({}, parsedInfo,
    pageFullInfoFromId(parsedInfo.pageId, pages));
}

export function pageFullInfoFromId(pageId, pages) {
  const parsedInfo = {};
  let page = pages.find((item) => item.ID == pageId);
  if (page) {
    const subPages = pages.filter((item) => item.parentId === page.ID);
    parsedInfo.page = page;
    parsedInfo.subPages = subPages;
    // parsedInfo.subPages = {};
    // subPages.forEach((item) => {
    //   parsedInfo.subPages[item.pageType] = item;
    // });
  }
  return parsedInfo;
}

export function location(options) {
  return new Promise((resolve, reject) => {
    wx.getLocation({
      type: 'gcj02', //返回可以用于wx.openLocation的经纬度//
      success: (result) => {
        resolve({
          address: '',
          city: "",
          latitude: '' + result.latitude,
          longitude: '' + result.longitude
        });
      },
      fail(error) {
        reject(error);
      }
    });
  });
}

export function getPageColumns(columns, element, page) {
  const elementsSet = page.pageProperty.elementsSet ? `,${page.pageProperty.elementsSet},` : null;
  return element.filter(item => item.pageId == page.ID).sort((s1, s2) => {
    return s1.eorder - s2.eorder;
  }).map((el) => {
    const cIndex = columns.findIndex(c => c.ID === el.patternId);
    if (!elementsSet || columns[cIndex].isIndex || elementsSet.indexOf(columns[cIndex].ID) >= 0) {
      return {
        pageId: el.pageId,
        index: cIndex,
        property: tryStrToJson(el.property) || {}
      };
    }
  }).filter(c => c);
}

export function getPatterns(pattern, statusMap, status, join) {
  const columnsAll = pattern.map((item) => {
    const {
      sm,
      ss
    } = getFilterStatus(statusMap, status, item);
    let property = tryStrToJson(item.property) || {};

    let editType = '';
    let jj = null;
    switch (item.pTypeId) {
      case 1:
        editType = 'switch';
        break;
      case 2:
      case 13:
        editType = 'status';
        break;
      case 3:
      case 4:
        editType = 'number';
        break;
      case 5:
        editType = 'input';
        break;
      case 6:
        editType = 'date';
        break;
      case 7:
        editType = 'textarea';
        break;
      case 10:
        editType = 'attachments';
        break;
      case 11:
        editType = 'attachment';
        break;
      case 12:
        editType = 'user';
        break;
      case 19:
        editType = 'users';
        break;
      case 20:
        editType = 'mstatus';
        break;
      case 23:
        editType = 'link';
        jj = join.find(j => j.baseId === item.ID);
        break;
      case 24:
        editType = 'location';
        break;
      case 26:
        editType = 'department';
        break;
      case 17:
        editType = 'tag';
        break;
      default:
    }
    // console.log(item, ss);
    const column = Object.assign({
        eid: '__c' + item.ID,
        primaryText: (config.columns && config.columns[item.ID] && config.columns[item.ID].name) || item.pName,
        statusGroup: sm,
        // statusMap: ss || [],
        filtable: ss != null || editType === 'users' || editType === 'user' || editType === 'department',
        searchable: item.pTypeId === 5 || item.pTypeId === 7,
        multi: editType === 'mstatus' || editType === 'users' || editType === 'attachments',
        editType,
        isIndex: item.pTypeId === 16,
        join: jj
      },
      item, {
        property
      });

    return {
      column,
      statusMap: {
        ID: item.ID,
        statusMap: ss
      }
    };
  });

  const columns = [];
  const ss = {};
  columnsAll.forEach(c => {
    columns.push(c.column);
    c.statusMap.statusMap && c.statusMap.statusMap.length > 0 && (ss[c.statusMap.ID] = c.statusMap.statusMap);
  });
  return {
    columns,
    statusMap: ss
  };
}

function dealStatus(status, column) {
  return status.sort((s1, s2) => s1.statusOrder - s2.statusOrder).map(item => {
    config.statusMaps && config.statusMaps[item.ID] && config.statusMaps[item.ID].name && (item.statusName = config.statusMaps[item.ID].name);
    if (item.data1) {
      const data1 = tryStrToJson(item.data1);
      if (data1) {
        return Object.assign({
          primaryText: item.statusName,
          url: data1.icon,
          imageClass: 'avatar thumb-xs',
          min: data1.min,
          max: data1.max,
          eid: '__c' + column.ID
        }, item);
      }
      return Object.assign({
        primaryText: item.statusName,
        eid: '__c' + column.ID
      }, item);
    }
    return Object.assign({
      primaryText: item.statusName,
      eid: '__c' + column.ID
    }, item);
  });
}

export function getFilterStatus(statusMap, status, column) {
  // if (column.pTypeId === 2 || column.pTypeId === 13 || column.pTypeId === 20) {
  const sm = statusMap.find(item => item.patternId === column.ID);
  if (sm) {
    if (configStatus[sm.groupId]) {
      status = [];
    } else {
      status = status.filter(item => item.groupId === sm.groupId);
    }
    const ss = dealStatus(status, column);

    return {
      sm,
      ss
    };
  } else if (column.pTypeId === 6) {
    return {
      sm: {},
      ss: [{
          ID: 0,
          primaryText: '今天',
          min: formatDate(new Date(), 'yyyy-MM-dd'),
          max: formatDate(getTomorrow(), 'yyyy-MM-dd')
        },
        {
          ID: 1,
          primaryText: '昨天',
          min: formatDate(getDiffDay(-1), 'yyyy-MM-dd'),
          max: formatDate(new Date(), 'yyyy-MM-dd')
        },
        {
          ID: 2,
          primaryText: '三天内',
          min: formatDate(getDiffDay(-2), 'yyyy-MM-dd'),
          max: formatDate(getTomorrow(), 'yyyy-MM-dd')
        },
        {
          ID: 3,
          primaryText: '本周',
          min: formatDate(getWeekStartDate(), 'yyyy-MM-dd'),
          max: formatDate(getDiffDay2(getWeekEndDate(), 1), 'yyyy-MM-dd')
        },
        {
          ID: 4,
          primaryText: '本月',
          min: formatDate(getMonthStartDate(), 'yyyy-MM-dd'),
          max: formatDate(getDiffDay2(getMonthEndDate(), 1), 'yyyy-MM-dd')
        }
      ]
    };
  } else if (column.pTypeId === 1) {
    return {
      sm: {},
      ss: [{
          ID: true,
          primaryText: '是',
        },
        {
          ID: false,
          primaryText: '否',
        }
      ]
    };
  } else if (column.pTypeId === 5 || column.pTypeId === 7) {
    return {
      sm: {},
      ss: []
    };
  }
  // }
  return {
    sm: {},
    ss: null
  };
}

export function getMenuItems(menus) {
  return menus.slice().map((item, index) => {
    return getMenuItem(item, index, menus.length);
  });
}

export function getMenuItem(item, index, length) {
  let property = {};
  if (item.property) {
    property = JSON.parse(item.property);
  }
  return Object.assign(
    item, {
      primaryText: item.pName,
      secondaryText: property.desc,
      icon: property.icon,
      image: property.image,
      index,
      count: length,
      property
    });
}

function fixDate(date) {
  if (isString(date)) {
    date = date.replace(' ', 'T');
    if (date.indexOf(':') >= 0 && date.indexOf('+08:00') < 0) {
      date = date + '+08:00';
    }
    date = new Date(date);
  }
  return date;
}

export function dateStr2(date) {
  if (!date) {
    return '';
  }

  date = fixDate(date);
  let time = new Date().getTime(); // 去掉 js 时间戳后三位，与时间戳保持一致
  time = parseInt((time - date.getTime()) / 1000, 10); // 存储转换值
  let s;
  if (time >= 0 && time < 86400) {
    return formatDate(date, 'hh:mm');
  }

  return formatDate(date, 'yyyy年MM月dd日 hh:mm');
}

export function dateStr(date) { //获取js 时间戳
  if (!date) {
    return '';
  }

  date = fixDate(date);

  let time = new Date().getTime(); // 去掉 js 时间戳后三位，与时间戳保持一致
  time = parseInt((time - date.getTime()) / 1000, 10); // 存储转换值
  let s;
  if (time <= 0) {
    var y = date.getFullYear();
    var m = date.getMonth() + 1;
    var d = date.getDate();
    return y + "-" + m + "-" + d;
  }

  if (time < 600) { //十分钟内
    return '刚刚';
  } else if (time < 3600) { //超过十分钟少于1小时
    s = Math.floor(time / 60);
    return s + "分钟前";
  } else if (time < 86400) {
    //超过1小时少于24小时
    s = Math.floor(time / 60 / 60);
    return s + "小时前";
  } else if (time < 2592000) {
    //超过1天少于30天内
    s = Math.floor(time / 86400);
    return s + "天前";
  } else if (time < 15552000) {
    //超过30天少于180天内
    s = Math.floor(time / 2592000);
    return s + "月前";
  } else {
    //超过3天
    return date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
  }
}

// 对Date的扩展，将 Date 转化为指定格式的String
// 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
// 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
// 例子：
// (new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
// (new Date()).Format("yyyy-M-d h:m:s.S")      ==> 2006-7-2 8:9:4.18
export function formatDate(date, fmt) {
  if (!date) {
    return '';
  }
  date = fixDate(date);

  var o = {
    "M+": date.getMonth() + 1, //月份
    "d+": date.getDate(), //日
    "h+": date.getHours(), //小时
    "m+": date.getMinutes(), //分
    "s+": date.getSeconds(), //秒
    "q+": Math.floor((date.getMonth() + 3) / 3), //季度
    "S": date.getMilliseconds() //毫秒
  };
  if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (date.getFullYear() + "").substr(4 - RegExp.$1.length));
  for (var k in o)
    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
  return fmt;
}

// 获取字段枚举值，参数statusMap是filter中保存的值
export function getStatusMap(column, {
  users,
  departments,
  statusMap
}) {
  let mapValues = [];
  if (column.statusMap) {
    return column.statusMap;
  }
  if (statusMap[column.ID]) {
    return statusMap[column.ID];
  }
  if (column.editType === 'status' || column.editType === 'mstatus') {
    mapValues = fixStatusMap(column);
  } else if (column.editType === 'department') {
    mapValues = departments;
  } else {
    mapValues = users;
  }
  return mapValues || [];
}

function fixArray(value) {
  value || (value = '');
  if (!(value instanceof Array || typeof value === 'string' || typeof value === 'number')) {
    value = [value];
  }
  if (Array.isArray(value) && value.length > 0 && value[0].UserId && !value[0].ID) {
    value = value.map(item => (Object.assign({
      ID: item.UserId,
      primaryText: item.XingMing
    }, item)));
  }
  return value;
}

String.prototype.trim = function () {
  return this.replace(/(^\s*)|(\s*$)/g, "");
}

String.prototype.ltrim = function () {
  return this.replace(/(^\s*)/g, "");
}

String.prototype.rtrim = function () {
  return this.replace(/(\s*$)/g, "");
}

export function removeHtml(value) {
  if (value) {
    value = value ? value.trim().replace(/<\/p>$/g, '').replace(/<\/p>/g, '\n').replace(/<[^>]*?>/g, '') : '';
    value = unescape(value.replace(/\\u/g, '%u'));
    // 再对实体符进行转义
    // 有 x 则表示是16进制，$1 就是匹配是否有 x，$2 就是匹配出的第二个括号捕获到的内容，将 $2 以对应进制表示转换
    value = value.replace(/&#(x)?(\w+);/g, ($, $1, $2) => {
      return String.fromCharCode(parseInt($2, $1 ? 16 : 10));
    });
    value = value.replace(/&[^;]+;/g, '')
  }
  return value || '';
}

export function getColumnDisplay(column, {
  users,
  departments,
  statusMap
}, item, value, dateType) {
  let display = '';
  if (column.editType === 'date') {
    value = value ? value.toString().replace(/T/ig, ' ') : '';
    if (dateType === 'ord') {
      display = formatDate(value, 'yyyy-MM-dd');
    } else {
      display = dateStr(value);
    }
  } else if (column.editType === 'switch') {
    display = value ? '是' : '否';
  } else if (column.editType === 'status' || column.editType === 'mstatus' || column.editType === 'user' || column.editType === 'users' || column.editType === 'department') {
    if (value) {
      value = fixArray(value);
      // 设值
      if (Array.isArray(value)) {
        if (value.length > 0) {
          if (value[0].primaryText) {
            item[column.eid + '___Orgin'] = value;
          } else {
            let mapValues = getStatusMap(column, {
              users,
              departments,
              statusMap
            });
            const valueArr = value;
            item[column.eid + '___Orgin'] = mapValues.filter(item => valueArr.findIndex(aa => aa.ID == item.ID) >= 0);
          }
        } else {
          item[column.eid + '___Orgin'] = [];
        }
        value = value.map(item => item.ID).join(',');
      } else {
        // 从服务器数据加载
        let mapValues = getStatusMap(column, {
          users,
          departments,
          statusMap
        });
        const valueArr = (value + '').split(',');
        item[column.eid + '___Orgin'] = mapValues.filter(item => valueArr.findIndex(aa => aa == item.ID) >= 0);
      }
    } else {
      item[column.eid + '___Orgin'] = [];
    }
    value = value ? value + '' : '';
    display = item[column.eid + '___Orgin'].map(item => item.primaryText).join(',');
  } else if (column.editType === 'attachments' || column.editType === 'attachment') {
    if (value) {
      value = fixArray(value);
      if (Array.isArray(value)) {
        const files = value.filter(item => item.FilePath).map(item => (Object.assign({
          type: 'remote'
        }, item, {
          FilePath: item.FilePath.replace(/\\+/g, '/')
        })));
        item[column.eid + '___Files'] = files;
      }
    }
    if (!item[column.eid + '___Files']) {
      item[column.eid + '___Files'] = [];
    }
  } else if (column.editType === 'link') {
    if (!column.join) {
      log(`没有为link字段${column.eid}配置关联信息`);
      column.join = {};
    }
    const displayCol = `__c${column.join.viewPatternId}`;
    if (value) {
      if (typeof value === 'string') {
        value = {
          server_identity: value,
          [displayCol]: item[displayCol]
        };
      }

      value = fixArray(value);
      if (Array.isArray(value)) {
        item[column.eid + '___Orgin'] = value;
      }
      if (!item[column.eid + '___Orgin']) {
        item[column.eid + '___Orgin'] = [];
      }
      value = item[column.eid + '___Orgin'].map(item => item.server_identity).join(',');
      display = item[column.eid + '___Orgin'].map(item => item[displayCol]).join(',');
    }
  } else if (column.editType === 'location') {
    if (value) {
      if (!(typeof value === 'string')) {
        value = JSON.stringify(value);
      }
      const jsValue = JSON.parse(value);
      display = jsValue.address;
    }
  } else if (column.editType === 'textarea') {
    display = removeHtml(value);
  } else {
    display = value || '';
  }

  if (value && !display) {
    display = value;
    if (display === 'null') display = '';
  }

  item[column.eid] = value;
  item[column.eid + '___Display'] = display;


  // item[column.eid + '___Property'] = column.property;
}

export function updateItemExt(columns, {
  users,
  departments,
  statusMap
}, column, item, value, dateType, parentValue) {

  value === 'null' && (value = null);
  const promises = [];
  if (column.editType === 'link') {
    if (value) {
      if (!column.join) {
        log(`没有为link字段${column.eid}配置关联信息`);
        column.join = {};
      }
      const displayCol = `__c${column.join.viewPatternId}`;
      if (typeof value === 'string') {
        value = {
          server_identity: value,
          [displayCol]: item[displayCol]
        };
      }
      if (config.columns && config.columns[column.ID] && config.columns[column.ID].remember) {
        storage.setItem(column.eid, value);
      }
    } else if (typeof value === 'undefined') {
      if (config.columns && config.columns[column.ID] && config.columns[column.ID].remember) {
        promises.push(storage.getItem(column.eid).then((data) => {
          value = data;
        }).catch((err) => {
          console.log(err);
        }));
      }
    }
  }

  return Promise.all(promises).then(() => {
    if (column.editType === 'user' || column.editType === 'users' || column.editType === 'department') {
      value = fixArray(value);
      // let mapValues = getStatusMapChecked(getStatusMap(column, { users, departments }), value);
      // const selectedIndex = mapValues.findIndex((item) => item.checked === true);
      // item[column.eid + '___SelectedIndex'] = selectedIndex === -1 ? 0 : selectedIndex;
      // item[column.eid + '___StatusMap'] = mapValues;
      getColumnDisplay(column, {
        users,
        departments,
        statusMap
      }, item, value, dateType);
    } else if (column.editType === 'status' || column.editType === 'mstatus') {
      value = fixArray(value);
      // if (column.statusGroup.depth > 0) {
      //   if (!parentValue) {
      //     const parentCol = columns.find((item) => item.ID == column.statusGroup.depth);
      //     parentValue = item[parentCol.eid];
      //   }
      //   parentValue = parentValue ? parentValue + '' : '';
      //   const parentArr = parentValue.split(',');
      //   let mapValues = getStatusMapChecked(parentValue ? column.statusMap.filter((item) => parentArr.findIndex(aa => aa == item.parentId) >= 0) : column.statusMap, value);
      //   const selectedIndex = mapValues.findIndex((item) => item.checked === true);

      //   item[column.eid + '___SelectedIndex'] = selectedIndex === -1 ? 0 : selectedIndex;
      //   item[column.eid + '___StatusMap'] = mapValues;

      //   getColumnDisplay(column, users, item, value, dateType);
      // } else {
      // let mapValues = getStatusMapChecked(getStatusMap(column, { users, departments }), value);
      // const selectedIndex = mapValues.findIndex((item) => item.checked === true);
      // item[column.eid + '___SelectedIndex'] = selectedIndex === -1 ? 0 : selectedIndex;
      // item[column.eid + '___StatusMap'] = mapValues;

      // const childCol = columns.find((item) => {
      //   if (item.statusGroup) {
      //     return item.statusGroup.depth == column.ID;
      //   }
      // });
      getColumnDisplay(column, {
        users,
        departments,
        statusMap
      }, item, value, dateType);
      // if (childCol) {
      //   return updateItemExt(columns, users, childCol, item, item[childCol.eid], dateType, item[column.eid]);
      // }
      // }
    } else {
      getColumnDisplay(column, {
        users,
        departments,
        statusMap
      }, item, value, dateType);
    }
  });
}

export function fixImagePath(path) {
  if (path) {
    if (path.FilePath) {
        path = path.FilePath;
    } else if (path.url) {
        path = path.url;
    }
    return path.replace(/\\/g, '/').replace(/\/100\//gi, '/');
  } else {
      return '';
  }
}

export function getStatusMapChecked(statusMap, value) {
  if (value) {
    value = fixArray(value);
    if (Array.isArray(value)) {
      value = value.map(item => item.ID).join(',');
    }
  }
  value = value ? value + '' : '';
  const valueArr = value.split(',');
  const mp = statusMap.map((item) => {
    return Object.assign({}, item, {
      checked: valueArr.findIndex(aa => aa == item.ID) >= 0
    });
  });
  return mp;
}

export function refreshItemDisplay(columns, {
  users,
  departments,
  statusMap
}, item, dateType, forEdit, options) {
  const promises = [];
  columns || (columns = []);
  users || (users = []);

  for (let index in columns) {
    const column = columns[index];
    if (column.isIndex) {
      item.ID = item[column.eid];
    }
    if (forEdit) {
      promises.push(updateItemExt(columns, {
        users,
        departments,
        statusMap
      }, column, item, item[column.eid], dateType, null).then(() => {
        if (column.editType === 'location') {
          return new Promise((resolve, reject) => {
            // wx.authorize({
            //   scope: 'scope.userInfo',
            //   success() {
            wx.getLocation({
              type: 'gcj02', //返回可以用于wx.openLocation的经纬度//
              success: (res) => {
                item[column.eid] = JSON.stringify({
                  address: "",
                  city: "",
                  latitude: '' + res.latitude,
                  longitude: '' + res.longitude
                });
                getColumnDisplay(column, {
                  users,
                  departments,
                  statusMap
                }, item, item[column.eid], dateType);
                resolve();
              },
              fail(error) {
                reject(error);
              }
            });
            //   },
            //   fail(error) {
            //     reject(error);
            //   }
            // });
          });
        }
      }));
    } else {
      getColumnDisplay(column, {
        users,
        departments,
        statusMap
      }, item, item[column.eid], dateType);
    }

    if (options && options[column.eid]) {
      item[column.eid] = options[column.eid];
      item[column.eid + '___Display'] = options[column.eid + '___Display'];
    }
  }
  return Promise.all(promises);
}

export function tryStrToJson(source) {
  if (source === null || typeof source === 'undefined') {
    return null;
  } else if (typeof source === 'string') {
    if (/^[\[\{]/.test(source)) {
      let des;
      try {
        des = decodeURIComponent(source);
        des = JSON.parse(des);
      } catch (err) {
        // log('tryStrToJson', err);
      }
      return des;
    }
    return null;
  }

  return source;
}

export function toArray(source) {
  if (source === null || typeof source === 'undefined') {
    return null;
  } else if (!Array.isArray(source)) {
    return [source];
  }

  return source;
}

export function fixPre(source, prefix, separator = '.') {
  if (prefix) {
    return `${prefix}${separator}${source}`;
  }
  return source;
}

export function fixSub(source, subfix, separator = '.') {
  if (subfix) {
    return `${source}${separator}${subfix}`;
  }
  return source;
}

export function getObjectClass(obj) {
  if (obj) {
    let des = '';
    if (typeof obj === 'function') {
      des = obj.toString();
    } else if (obj.constructor && obj.constructor.toString) {
      des = obj.constructor.toString();
    }
    const arr = des.match(/function\s*(\w+)/);
    if (arr && arr.length == 2) {
      return arr[1];
    }
  }
  return undefined;
}

export function tryJsonToStr(data) {
  if (typeof data === 'object' || Array.isArray(data)) {
    return JSON.stringify(data);
  }
  return data;
}

export function GetRound(num, len) {
  return Math.round(num * Math.pow(10, len)) / Math.pow(10, len);
}

export function uuid() {
  var s = [];
  var hexDigits = "0123456789abcdef";
  for (var i = 0; i < 36; i++) {
    s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
  }
  s[14] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
  s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
  s[8] = s[13] = s[18] = s[23] = "-";

  var uuid = s.join("");
  return uuid;
}

export function alphaItems(newItems) {
  const tags = ['A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z',
    '#'
  ];

  const textData = tags.map(tag => ({
    tag,
    header: {
      title: tag,
      type: 'header2',
      class: 'bg-light padder-t padder-b-sm justify-between',
      titleClass: 'text-md2'
    },
    items: []
  }));
  for (let i = 0; i < newItems.length; i += 1) {
    const textItem = newItems[i];
    const firstChar = textItem.primaryText.substr(0, 1);
    const tag = queryPy(firstChar)[0].toUpperCase();
    const item = textData.find(item => item.tag === tag || item.tag === '#');
    item.items.push(textItem);
  }
  const result = textData.filter(item => item.items.length > 0);
  const newTags = result.map(item => item.tag);
  return {
    items: result,
    tags: newTags
  };
}

String.prototype.map = function (func) {
  const t = tryStrToJson(this);
  if (Array.isArray(t)) {
    return t.map((t, index) => func(t, index));
  } else {
    return [];
  }
}

var now = new Date(); //当前日期
var nowDayOfWeek = now.getDay(); //今天本周的第几天
var nowDay = now.getDate(); //当前日
var nowMonth = now.getMonth(); //当前月
var nowYear = now.getYear(); //当前年
nowYear += (nowYear < 2000) ? 1900 : 0; //
var lastMonthDate = new Date(); //上月日期
lastMonthDate.setDate(1);
lastMonthDate.setMonth(lastMonthDate.getMonth() - 1);
var lastYear = lastMonthDate.getYear();
var lastMonth = lastMonthDate.getMonth();

// 获得某月的天数
function getMonthDays(myMonth) {
  var monthStartDate = new Date(nowYear, myMonth, 1);
  var monthEndDate = new Date(nowYear, myMonth + 1, 1);
  var days = (monthEndDate - monthStartDate) / (1000 * 60 * 60 * 24);
  return days;
}

// 获得本季度的开端月份
function getQuarterStartMonth() {
  var quarterStartMonth = 0;
  if (nowMonth < 3) {
    quarterStartMonth = 0;
  }
  if (2 < nowMonth && nowMonth < 6) {
    quarterStartMonth = 3;
  }
  if (5 < nowMonth && nowMonth < 9) {
    quarterStartMonth = 6;
  }
  if (nowMonth > 8) {
    quarterStartMonth = 9;
  }
  return quarterStartMonth;
}

// 获得本周的开端日期
export function getWeekStartDate() {
  var weekStartDate = new Date(nowYear, nowMonth, nowDay - nowDayOfWeek);
  return weekStartDate;
}

// 获得本周的停止日期
export function getWeekEndDate() {
  var weekEndDate = new Date(nowYear, nowMonth, nowDay + (6 - nowDayOfWeek));
  return weekEndDate;
}

//当前天数加1
export function getTomorrow() {
  var tomorrow = new Date(nowYear, nowMonth, nowDay + 1);
  return tomorrow;
}

export function getDiffDay2(day, diff) {
  let Day = day.getDate(); //当前日
  let Month = day.getMonth(); //当前月
  let Year = day.getYear(); //当前年
  Year += (Year < 2000) ? 1900 : 0; //
  const diffday = new Date(Year, Month, Day + diff);
  return diffday;
}

export function getDiffDay(diff) {
  var diffday = new Date(nowYear, nowMonth, nowDay + diff);
  return diffday;
}

// 获得本月的开端日期
export function getMonthStartDate() {
  var monthStartDate = new Date(nowYear, nowMonth, 1);
  return monthStartDate;
}

// 获得本月的停止日期
export function getMonthEndDate() {
  var monthEndDate = new Date(nowYear, nowMonth, getMonthDays(nowMonth));
  return monthEndDate;
}

// 获得上月开端时候
export function getLastMonthStartDate() {
  var lastMonthStartDate = new Date(nowYear, lastMonth, 1);
  return lastMonthStartDate;
}

// 获得上月停止时候
export function getLastMonthEndDate() {
  var lastMonthEndDate = new Date(nowYear, lastMonth, getMonthDays(lastMonth));
  return lastMonthEndDate;
}

// 获得本季度的开端日期
export function getQuarterStartDate() {
  var quarterStartDate = new Date(nowYear, getQuarterStartMonth(), 1);
  return quarterStartDate;
}

// 或的本季度的停止日期
export function getQuarterEndDate() {
  var quarterEndMonth = getQuarterStartMonth() + 2;
  var quarterStartDate = new Date(nowYear, quarterEndMonth, getMonthDays(quarterEndMonth));
  return quarterStartDate;
}

export function compareVersion(v1, v2) {
  v1 = v1.split('.')
  v2 = v2.split('.')
  var len = Math.max(v1.length, v2.length)

  while (v1.length < len) {
    v1.push('0')
  }
  while (v2.length < len) {
    v2.push('0')
  }

  for (var i = 0; i < len; i++) {
    var num1 = parseInt(v1[i])
    var num2 = parseInt(v2[i])

    if (num1 > num2) {
      return 1
    } else if (num1 < num2) {
      return -1
    }
  }

  return 0
}

export function parsePageInfo(page, subPages, allPages, pattern, element, statusMap, status, join) {
  const defaultData = {
    columns: [],
    searchable: [],
    filtable: [],
    sortable: [],
    display: [],
    workflow: [],
    listpage: [],
    statusMap: {}
  };
  const columnsAll = getPatterns(pattern, statusMap, status, join);

  //element =element.sort((a, b) => a.eorder -b.eorder );

  defaultData.columns = columnsAll.columns;
  defaultData.statusMap = columnsAll.statusMap;
  let subPage;
  if (page.pageType === 10) {
    subPage = subPages.find(s => s.pageType === 11);
    if (subPage) {
      const columnCount = getPageColumns(defaultData.columns, element, subPage);
      defaultData.searchable = columnCount.filter(item => defaultData.columns[item.index].searchable);
      defaultData.filtable = columnCount.filter(item => defaultData.columns[item.index].filtable);
    }
    subPage = subPages.find(s => s.pageType === 12);
    if (subPage) {
      defaultData.sortable = getPageColumns(defaultData.columns, element, subPage);
    }
    subPage = subPages.find(s => s.pageType === 14);
    if (subPage) {
      defaultData.display = getPageColumns(defaultData.columns, element, subPage);
    }
  } else if (page.pageType === 16) {
    subPage = subPages.find(s => s.pageType === 17);
    if (subPage) {
      const columnCount = getPageColumns(defaultData.columns, element, subPage);
      defaultData.searchable = columnCount.filter(item => defaultData.columns[item.index].searchable);
      defaultData.filtable = columnCount.filter(item => defaultData.columns[item.index].filtable);
    }
  } else {
    defaultData.columns.forEach(column => {
      if (column.editType === 'link' && column.join) {
        column.joinPage = allPages.find(item => item.categoryId === column.join.joinCategoryId && item.pageType === 10);
      }
    });
    defaultData.display = getPageColumns(defaultData.columns, element, page);
    defaultData.listpage = allPages.filter(p => p.pageType == 10 && p.categoryId === page.categoryId);
    if (page.parentId && page.pageType === 22) {
      const parent = allPages.find(p => p.ID === page.parentId);
      defaultData.parent = Object.assign({
        joinColumn: defaultData.columns.find(c => c.joinPage && c.joinPage.categoryId == parent.categoryId)
      }, parent);
    }
  }

  defaultData.columns.forEach((item, i) => {
      const ele2 = element.filter(x=>x.patternId == item.ID );
      ele2.forEach((x, y) => {
          item['eorder_'+x.pageId] = x.eorder;
      });
  });




  return defaultData;
}

// 从配置文件读取枚举值
export function fixStatusMap(column) {
  if (column.statusGroup && column.statusGroup.groupId && configStatus[column.statusGroup.groupId]) {
    return dealStatus(configStatus[column.statusGroup.groupId], column);
  } else {
    return column.statusMap || [];
  }
}

export function parseFilter(pageConfig, data, filter) {
  const payload = {
    pageId: pageConfig.page.ID,
    filtable: []
  };
  if (filter && filter.filtable) {
    payload.filtable.push(...filter.filtable);
    pageConfig.columns.filtable.forEach((item) => {
      const column = pageConfig.columns.columns[item.index];
      const index = payload.filtable.findIndex(f => f.ID === column.ID);
      if (index >= 0) {
        // console.log('0', column.property, item.property)
        const property = Object.assign({}, column.property, item.property);
        let rcolumn;
        // if (column.editType === 'user' || column.editType === 'users') {
        //   rcolumn = Object.assign({}, payload.filtable[index], column, { statusMap: data.cuser, property });
        // } else if (column.editType === 'department' ) {
        //   rcolumn = Object.assign({}, payload.filtable[index], column, { statusMap: data.department, property });
        // } else {
        rcolumn = Object.assign({
          pageId: pageConfig.page.ID
        }, payload.filtable[index], column, {
          property
        });
        // }

        // fixStatusMap(column, rcolumn);

        payload.filtable[index] = rcolumn;
      }
    });
  } else {
    payload.filtable = pageConfig.columns.filtable.map((item) => {
      const column = pageConfig.columns.columns[item.index];
      let rcolumn;
      const property = Object.assign({}, column.property, item.property);
      // if (column.editType === 'user' || column.editType === 'users') {
      //   rcolumn = Object.assign({}, column, { statusMap: data.cuser, property });
      // } else if (column.editType === 'department') {
      //   rcolumn = Object.assign({}, column, { statusMap: data.department, property });
      // } else {
      rcolumn = Object.assign({
        pageId: pageConfig.page.ID
      }, column, {
        property
      });
      // }

      // fixStatusMap(column, rcolumn);

      return rcolumn;
    });
  }

  filter && filter.sortable || (payload.sortable = pageConfig.columns.sortable.map((item) => {
    const column = pageConfig.columns.columns[item.index];

    const property = Object.assign({}, column.property, item.property);
    return Object.assign({
      pageId: pageConfig.page.ID
    }, column, {
      property
    });
  }));

  filter && filter.display || (payload.display = pageConfig.columns.display.map((item) => {
    const column = pageConfig.columns.columns[item.index];

    const property = Object.assign({}, column.property, item.property);
    let rcolumn = Object.assign({
      pageId: pageConfig.page.ID
    }, column, {
      property
    });

    // fixStatusMap(column, rcolumn);

    return rcolumn;
  }));

 

  pageConfig.columns.workflow && (payload.workflow = pageConfig.columns.workflow);
  pageConfig.columns.listpage && (payload.listpage = pageConfig.columns.listpage);
  pageConfig.columns.parent && (payload.parent = pageConfig.columns.parent);

  payload.statusMap = pageConfig.columns.statusMap;
  payload.pageConfig = pageConfig;
  if (typeof data.selected !== 'undefined') {
    payload.selected = data.selected;
  }
  payload.refreshed = true;
  return payload;
}

export function sequenceTasks(tasks) {
  function recordValue(results, value) {
    results.push(value);
    return results;
  }
  var pushValue = recordValue.bind(null, []);
  return tasks.reduce(function (promise, task) {
    return promise.then(task).then(pushValue);
  }, Promise.resolve());
}

export function nul(s) {
  if (!s) return '';
  return s;
}

export function setPageParams(pageId, item) {
  if (!getAPP().pageParams) {
    getAPP().pageParams = {};
  }
  getAPP().pageParams[pageId] = item;
}

export function getPageParams(pageId) {
  if (getAPP().pageParams)
    return getAPP().pageParams[pageId];
  return {};
}


export function nuld(s) {
  if (!s) return '0';
  return s;
}
