﻿using System;
using System.Web;
using System.Data;
using System.Collections.Generic;
using System.Web.Helpers;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using System.Linq;
using System.Web.Mvc;

using CooWork.WcfCommon.DTO;

namespace CooWorkWeb.Page
{
    public class XPAGE  
    {
        public static List<dynamic> categoryList(DataTable dt, string filter)
        {
            return categoryList(  dt , filter , "");
        }
        

        public static string f(decimal? d)
        {
            if (!d.HasValue) return "￥0";
            return d.Value.ToString("C").Replace(".00", "");
        }


        public static string t(string d)
        {

           if (string.IsNullOrWhiteSpace(d)) return string.Empty;
           return  Convert.ToDateTime(d).ToString("MM-dd hh:mm");
        }


        /// <summary>
        /// d1,productDt; d2,categoryDt
        /// </summary>
        /// <param name="productDt"></param>
        /// <param name="categoryDt"></param>
        /// <param name="itemId"></param>
        /// <returns></returns>
        public static int? productCategoryId(DataTable productDt,DataTable categoryDt, int? itemId)
        {
            if (!productDt.Columns.Contains("__c268") || !categoryDt.Columns.Contains("ID"))
                return -1;

            var items = (from c in productDt.AsEnumerable()
                         where c.Field<int?>("ID") == itemId
                         select c.Field<Guid?>("__c268")).ToList();

            if (items.Count == 0) return -2;

            var cates = (from c in categoryDt.AsEnumerable()
                         where c.Field<Guid?>("server_identity") == items[0]
                         select c.Field<int?>("ID")).ToList();

            if (cates.Count > 0) return cates[0];
            return -3;
        }


        /// <summary>
        /// dt 
        /// </summary>
        /// <param name="dt"></param>
        /// <param name="pageId"></param>
        /// <param name="itemId"></param>
        /// <param name="categoryId"></param>
        /// <param name="p"></param>
        /// <returns></returns>
        public static List<ComboBoxPairs> breadcrumb(DataTable dt,int? pageId ,int? itemId,int? categoryId,string p)
        {
            var ret = new List<ComboBoxPairs>();
            if (pageId == 194 || !pageId.HasValue)
            {
                return new List<ComboBoxPairs>();
            }

            if (!dt.Columns.Contains("__c260"))
            {
                return new List<ComboBoxPairs>();
            }
            var list = (from c in dt.AsEnumerable()
                        select new
                        {
                            ID = c.Field<int?>("ID"),
                            title = c.Field<string>("__c255"),
                            parentId = c.Field<int?>("__c260")
                        }).ToList();
            


            switch(pageId)
            {
                case 185:

                    var row = list.FirstOrDefault(x => x.ID == categoryId);

                    var k = 0;
                    while(row!=null && k<5)
                    {
                        ret.Add(new ComboBoxPairs(row.title, "/catalog-p185-c" + row.ID + "/"));
                        k++;
                        if (!row.parentId.HasValue)
                        {

                            break;
                        }
                        else
                        {
                            row = list.FirstOrDefault(x => x.ID == row.parentId);
                        }
                    }
                    ret.Add(new ComboBoxPairs("首页", "/"));
                    ret.Reverse();


                    break;
                case 202:

                     ret.Add(new ComboBoxPairs(p, "/catalog-p202/item-i"+itemId+"/"));
                     row = list.FirstOrDefault(x => x.ID == categoryId);

                     k = 0;
                    while(row!=null && k<5)
                    {
                        ret.Add(new ComboBoxPairs(row.title, "/catalog-p185-c" + row.ID + "/"));
                        k++;
                        if (!row.parentId.HasValue)
                        {

                            break;
                        }
                        else
                        {
                            row = list.FirstOrDefault(x => x.ID == row.parentId);
                        }
                    }
                    ret.Add(new ComboBoxPairs("首页", "/"));
                    ret.Reverse();


                    break;
                case 204:
                    ret.Add(new ComboBoxPairs("首页", "/"));
                    ret.Add(new ComboBoxPairs("资讯", "/blog-p204/"));
                    break;
                case 205:
                    ret.Add(new ComboBoxPairs("首页", "/"));
                    ret.Add(new ComboBoxPairs("资讯", "/blog-p205/"));
                    ret.Add(new ComboBoxPairs(p, "/blog-p205/news-i" + itemId + "/"));

                    break;
                case 210:
                    ret.Add(new ComboBoxPairs("首页", "/"));
                    ret.Add(new ComboBoxPairs("收藏", "/default-p210/"));
                    break;
                case 211:
                    ret.Add(new ComboBoxPairs("首页", "/"));
                    ret.Add(new ComboBoxPairs("购物车", "/default-p211/"));

                    break;


            }


            return ret;


        }


        public static string html2Txt(string s)
        {
             if (string.IsNullOrWhiteSpace(s))
             {
                 return string.Empty;
             }
             
             s = Regex.Replace(s, @"(<br[\/\s]*?>|<[\/\s]*?p>)", @"
             ");

             s = Regex.Replace(s, @"<[^<>]*?>", "");

             s = Regex.Replace(s, @"&nbsp;", "");

             return s;
             
             
             
             

        }



        /// <summary>
        /// fenlei:260,order:259;
        /// </summary>
        /// <param name="dt"></param>
        /// <param name="filter"></param>
        /// <param name="sort"></param>
        /// <returns></returns>
        public static List<dynamic> categoryList(DataTable dt,string filter,string sort)
        {
            var ret = new List<dynamic>();
            var dtRows = dt.Select(filter,sort);
            foreach(DataRow dr in dtRows)
            {
                var img = string.Empty;
            
                if (!string.IsNullOrWhiteSpace(dr["__c256"].ToString()))
                {
                    img = Json.Decode(dr["__c256"].ToString()).FilePath;
                }
                dynamic d = new
                {
                    id =  dr.Field<int?>("ID"),
                    desc = dr.Field<string>("__c257"),
                    img = img,
                    title = dr.Field<string>("__c255"),
                    fenlei = dr.Field<int?>("__c260"),
                    order = dr.Field<int?>("__c259"),
                };
                ret.Add(d);
            }
            return ret;  
        }



        public static List<dynamic> navList(DataTable dt ,string filter)
        {
            return  navList(  dt ,  filter, "");

        }


        /// <summary>
        /// fenlei:5,order:4
        /// </summary>
        /// <param name="dt"></param>
        /// <param name="filter"></param>
        /// <param name="sort"></param>
        /// <returns></returns>
        public static List<dynamic> navList(DataTable dt ,string filter,string sort)
        {
             var ret = new List<dynamic>();
            var dtRows = dt.Select(filter,sort);
            foreach(DataRow dr in dtRows)
            {
                var img = string.Empty;
            
                if (!string.IsNullOrWhiteSpace(dr["__c2"].ToString()))
                {
                    img = Json.Decode(dr["__c2"].ToString()).FilePath;
                    if (!string.IsNullOrWhiteSpace(img)) { img = Regex.Replace(img, @"\/100", ""); }
                }
                dynamic d = new
                {
                    id = dr.Field<int?>("ID"),
                    img = img,
                    title = dr.Field<string>("__c6"), 
                    fenlei = dr.Field<int?>("__c5"),
                    subTitle = dr.Field<string>("__c3"),
                    order = dr.Field<int?>("__c4"),
                    router = dr.Field<string>("__c7")
                };
                ret.Add(d);
            }
            return ret;           
        }


        public static List<dynamic> productList(DataTable dt,string filter)
        {
            return productList(dt, filter, "");

        }


        public static List<CooStatusDTO> statList(DataTable dt)
        {
            var list = new List<CooStatusDTO>(); 

            foreach (DataRow dr in dt.Rows)
            {

                list.AddRange(JsonConvert.DeserializeObject<List<CooStatusDTO>>(dr["__c27"].ToString()));
            }


            var ret = new List<CooStatusDTO>();
            foreach(var m in list)
            {
                if (!ret.Any(x => x.ID == m.ID))
                {
                    ret.Add(m);
                }
            }

            return ret;

        }


        public static List<dynamic> filterByTag(DataTable dt,int? tagId)
        {
            var ret = new List<dynamic>();
            var drs = new List<DataRow>();
            var ndt = new DataTable();

            foreach (DataRow dr in dt.Rows)
            {
                var slist = JsonConvert.DeserializeObject<List<CooStatusDTO>>(dr["__c27"].ToString());

                if (slist.Any(x => x.ID == tagId))
                {
                    drs.Add(dr);
                }
            }
            ndt = drs.CopyToDataTable();

            return productList(ndt, "", "");
        }

 


        /// <summary>
        /// order:19,hot:23,_new:24,feature:25
        /// </summary>
        /// <param name="dt"></param>
        /// <param name="filter"></param>
        /// <param name="sort"></param>
        /// <returns></returns>
        public static List<dynamic> productList(DataTable dt,string filter,string sort)
        {
            var ret = new List<dynamic>();
            var dtRows = dt.Select(filter,sort);
            foreach(DataRow dr in dtRows)
            {

                var img = string.Empty;
                var img2 = string.Empty;
                var imgList = new List<string>();
                var tags = new List<CooStatusDTO>();
                var hangye = new List<CooStatusDTO>();
                Guid? cart_identity = Guid.Empty;
                int? pingfen = 0;
                var sku = string.Empty;
                if (!string.IsNullOrWhiteSpace(dr["__c17"].ToString()))
                {
                    img = Json.Decode(dr["__c17"].ToString()).FilePath;
                }
                if (!string.IsNullOrWhiteSpace(dr["__c22"].ToString()))
                {
                    if (dr["__c22"].ToString() != "[]")
                    {
                        var olist = Json.Decode(dr["__c22"].ToString());
                        img2 = olist[0].FilePath;
                        foreach(var x in olist)
                        {
                            imgList.Add(x.FilePath);
                        }
                    }
                }
                 if (!string.IsNullOrWhiteSpace(dr["__c27"].ToString())){
                     tags = JsonConvert.DeserializeObject<List<CooStatusDTO>>(dr["__c27"].ToString());
                 }
                 if (dt.Columns.Contains("__c26") &&  dr["__c26"]!=DBNull.Value &&!string.IsNullOrWhiteSpace(dr["__c26"].ToString()))
                 {
                     hangye = JsonConvert.DeserializeObject<List<CooStatusDTO>>(dr["__c26"].ToString());
                 }

                 if (dt.Columns.Contains("__c29") && dr["__c29"] != DBNull.Value && !string.IsNullOrWhiteSpace(dr["__c29"].ToString()))
                 {
                     pingfen = dr.Field<int?>("__c29");
                 }

                 if (dt.Columns.Contains("__c14") && dr["__c14"] != DBNull.Value && !string.IsNullOrWhiteSpace(dr["__c14"].ToString()))
                 {
                     sku = dr.Field<string>("__c14");
                 }


                 if (dt.Columns.Contains("cart_identity") && dr["cart_identity"] != DBNull.Value && !string.IsNullOrWhiteSpace(dr["cart_identity"].ToString()))
                 {
                     cart_identity = dr.Field<Guid?>("cart_identity");
                 }

                 var count = 0;
                if (dt.Columns.Contains("__c89") &&  dr["__c89"]!=DBNull.Value && !string.IsNullOrWhiteSpace(dr["__c89"].ToString()))
                {
                    count = Convert.ToInt32(dr["__c89"]);
                }

                dynamic d = new
                {
                    id = dr.Field<int?>("ID"),
                    img = img,
                    title = dr.Field<string>("__c13"),
                    price1 = dr.Field<decimal?>("__c16"),
                    price2 = dr.Field<int?>("__c28"),
                    hot = dr.Field<bool?>("__c23"),
                    _new = dr.Field<bool?>("__c24"),
                    feature = dr.Field<bool?>("__c25"),
                    img2 = img2,
                    order = dr.Field<int?>("__c19"),
                    imgList = imgList,
                    desc = dr.Field<string>("__c15"),
                    tags = tags,
                    hangye = hangye,
                    pingfen = pingfen,
                    server_identity = dr.Field<Guid?>("server_identity"),
                    count = count,
                    sku = sku,
                    cart_identity = cart_identity

                };
                ret.Add(d);
            }
            return ret;            
        }



         


        public static List<dynamic> commentList(DataTable dt, string filter )
        {
            return commentList(dt, filter, "__c108 DESC");

        }

        public static List<dynamic> commentList(DataTable dt, string filter, string sort)
        {
            var ret = new List<dynamic>();
            var dtRows = dt.Select(filter, sort);
            foreach (DataRow dr in dtRows)
            {

                var img = string.Empty;
                var name = string.Empty;
                var imgList = new List<string>();

                if (!string.IsNullOrWhiteSpace(dr["__c112"].ToString()))
                {
                    if (dr["__c112"].ToString() != "[]")
                    {
                        var olist=  Json.Decode(dr["__c112"].ToString());
                       foreach(var x in olist)
                       {
                           imgList.Add(x.FilePath);
                       }
                    }
                }

                if (!string.IsNullOrWhiteSpace(dr["__c106"].ToString()))
                {
                    name = Json.Decode(dr["__c106"].ToString()).XingMing;
                }

                dynamic d = new
                {
                    
                    title = dr.Field<string>("__c107"),
                    time = dr.Field<DateTime?>("__c108"),
                    productId = dr.Field<Guid?>("__c111"),
                    replyId = dr.Field<Guid?>("__c115"),
                    star  = dr.Field<int?>("__c114"),
                    name = name,
                    imgList = imgList

                };
                ret.Add(d);
            }
            return ret;

        }




        public static List<dynamic> blogList(DataTable dt, string filter)
        {
            return blogList(dt, filter, "ID DESC");

        }


        /// <summary>
        /// fenlei:123,
        /// </summary>
        /// <param name="dt"></param>
        /// <param name="filter"></param>
        /// <param name="sort"></param>
        /// <returns></returns>
        public static List<dynamic> blogList(DataTable dt, string filter,string sort)
        {
            var ret = new List<dynamic>();
            var dtRows = dt.Select(filter,sort);
            foreach (DataRow dr in dtRows)
            {

                var img = string.Empty;
                var name = string.Empty;
            
                if (!string.IsNullOrWhiteSpace(dr["__c118"].ToString()))
                {
                    if (dr["__c118"].ToString() != "[]")
                    {
                        img = Json.Decode(dr["__c118"].ToString())[0].FilePath;
                    }  
                }

                if (!string.IsNullOrWhiteSpace(dr["__c117"].ToString()) && dr["__c117"].ToString().ToLower()!="null")
                {               
                        name = Json.Decode(dr["__c117"].ToString()).XingMing;                 
                }
                var desc = string.Empty; ;
                var fullTxt = string.Empty;
                if (!string.IsNullOrWhiteSpace(dr.Field<string>("__c122")))
                { 
                    fullTxt =dr.Field<string>("__c122");
                    desc = string.Join(string.Empty, Regex.Replace(fullTxt, @"<[^>]+>", "").Take(100));  
                }


                 dynamic d = new
                 {
                     id = dr.Field<int?>("ID"),
                     img = img,
                     title = dr.Field<string>("__c243"),
                     time = dr.Field<DateTime?>("__c121"),
                     name = name,
                     desc = desc,
                     fullTxt = fullTxt

                 };
                 ret.Add(d);
            }
            return ret;
        }







      
    }
}
