﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;



using System.Web.Profile;
using CooWorkWeb.Models;


using System.Reflection;
using log4net;

using SimpleInjector;
using SimpleInjector.Extensions;
using SimpleInjector.Integration.Web;
using SimpleInjector.Integration.Web.Mvc;

using CooWorkWeb.FTask;
using CooWorkWeb.Core;

using CooWorkWeb.Infrastructure;
using CooWorkWeb.Services;
using CooWorkWeb.Core.Caching;

using CooWork.WcfServer.ServerCore;
using CooWork.WcfServer;
using CooWork.WcfCommon;
using CooWork.WcfCommon.DTO;
using CooWork.Data.Mapping;

using System.Data.Entity;
using System.Web.Security;

using System.Text.RegularExpressions;

using System.Diagnostics;
using System.Web.Configuration;
using CooWork.Core;

using System.Management;
using System.IO;

using System.Text;

using System.Configuration;
 
 

namespace CooWorkWeb
{
    // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
    // visit http://go.microsoft.com/?LinkId=9394801

    public class MvcApplication : System.Web.HttpApplication
    {

        private Regex rfiles = new Regex(@"(\.css|\.jpg|\.png|\.gif|\.bmp|\.css|\.jpeg|\.swf|\.js)", RegexOptions.Compiled | RegexOptions.IgnoreCase);

 


     //   private static IWindsorContainer container;
        //private static Container Container;
        //public static T GetInstance<T>() where T : class
        //{
        //    return Container.GetInstance<T>();
        //}
        private static void BootstrapContainer()
        {
            //container = new WindsorContainer()
            //    .Install(FromAssembly.This());
            //var controllerFactory = new WindsorControllerFactory(container.Kernel);
            //ControllerBuilder.Current.SetControllerFactory(controllerFactory);
            var container = new Container();

            InitializeContainer(container);
            container.RegisterMvcControllers(Assembly.GetExecutingAssembly());
            container.Verify();

         //   Container = container;

            DependencyResolver.SetResolver(new SimpleInjectorDependencyResolver(container));
        }

        private static void InitializeContainer(Container container)
        {
//#error Register your services here (remove this line).

            // For instance:
            // container.Register<IUserRepository, SqlUserRepository>();


            log4net.Config.XmlConfigurator.Configure();

            container.Register<ILog>(() => log4net.LogManager.GetLogger(typeof(MvcApplication)));

                 

          

            var webLifestyle = new WebRequestLifestyle();

            container.Register<IBusinessDefine, BusinessDefine>(webLifestyle);   

            container.Register<IWorkContext, WebWorkContext>(webLifestyle);

            container.Register<IRenderService, RenderService>(webLifestyle);

     //       container.Register<ICooItemService, CooItemService>(webLifestyle);

         //   container.Register<ICooFileService, CooFileService>(webLifestyle);

            container.Register<IDataService, DataService>(webLifestyle);

            container.Register<IJSContext, JSContext>(webLifestyle);

            container.Register<ICacheManager, MemoryCacheManager>(Lifestyle.Singleton);

            container.Register<CooWorkEntities, CooWorkEntities>(webLifestyle);

            container.Register<CommonService, CommonService>(webLifestyle);

            container.Register<ISaasService, SaasService>(webLifestyle);

            container.Register<IExportService, ExportService>(webLifestyle);

            container.Register<IImportService, ImportService>(webLifestyle);




           
        }

 





        public static void RegisterGlobalFilters(GlobalFilterCollection filters)
        {
            filters.Add(new HandleErrorAttribute());
        }

        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            routes.IgnoreRoute("talk/{*.pathInfo}");
            routes.IgnoreRoute("pay/{*.pathInfo}");
            routes.IgnoreRoute("");

          

           routes.MapRoute("pview", "{cid}/pv/{cateId}/p/{pageId}/i/{itemId}",
           new { Controller = "pview", action = "Index", cid = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional, itemId = UrlParameter.Optional });


           //routes.MapRoute("custom", "{companyId}/custom/p/{pageId}",
           // new { Controller = "Custom", action = "Index" }
           // );


           routes.MapRoute("menu", "{companyId}/menu/{cateId}/p/{pageId}",
               new { Controller = "menu", action = "context" }
               );


           routes.MapRoute("c", "{companyId}/center",
               new { Controller = "c", action = "Index", companyId = UrlParameter.Optional }
               );


            routes.MapRoute("exportData", "{cid}/ed/{cateId}/p/{pageId}",
            new { Controller = "exportdata", action = "Index", cid = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional });


            routes.MapRoute("report", "{companyId}/report/{cateId}/p/{pageId}",
                 new { Controller = "Report", action = "Index", companyId = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional });




            routes.MapRoute("bulkEdit", "{cid}/be/{cateId}/p/{pageId}",
            new { Controller = "bulkedit", action = "Index", cid = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional });




            routes.MapRoute("bulkCreate", "{companyId}/bc/{cateId}/p/{pageId}",
            new { Controller = "bulkcreate", action = "Index", companyId = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional });


            routes.MapRoute("workflowLog", "{cid}/wl/{cateId}/i/{itemId}",
              new { Controller = "workflowlog", action = "Index", cid = UrlParameter.Optional, cateId = UrlParameter.Optional, itemId = UrlParameter.Optional });



            routes.MapRoute("dataLog", "{cid}/dl/{cateId}/i/{itemId}",
                new { Controller = "datalog", action = "Index", cid = UrlParameter.Optional, cateId = UrlParameter.Optional, itemId = UrlParameter.Optional });



            routes.MapRoute("messageCreate", "{cid}/m/{cateId}/i/{itemId}",
                    new  { Controller ="message",action = "Index",cid=UrlParameter.Optional,cateId=UrlParameter.Optional,itemId=UrlParameter.Optional  });


            routes.MapRoute("createPage","{companyId}/c/{cateId}/p/{pageId}",
                   new { Controller = "create", action = "Index", companyId = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional});

            routes.MapRoute("ComplexPage", "{companyId}/complex/{cateId}/p/{pageId}",
                 new { Controller = "Complex", action = "Index", companyId = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional });


            routes.MapRoute("ComplexUpdatePage", "{companyId}/complexupdate/{cateId}/p/{pageId}/i/{itemId}",
                 new { Controller = "Complex", action = "Update", companyId = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional });


            routes.MapRoute("adminadapter", "admin/{companyId}/adapter",
                new { Controller ="Admin" ,action ="adapter" });

            routes.MapRoute("admintestTrigger", "admin/{companyId}/testTrigger",
              new { Controller = "Admin", action = "testTrigger" });

            routes.MapRoute("admintestEvent", "admin/{companyId}/testEvent",
              new { Controller = "Admin", action = "testEvent" });

            routes.MapRoute("adminRebuildScript", "admin/{companyId}/rebuildscript",
            new { Controller = "Admin", action = "rebuildscript" });

            routes.MapRoute("adminadapterstring", "admin/{companyId}/adapterstring",
               new { Controller = "Admin", action = "adapterString" });

            routes.MapRoute("adminpattern", "admin/{companyId}/adapterpattern",
             new { Controller = "Admin", action = "adapterPatternExt" });

            routes.MapRoute("adminlist", "admin/{companyId}/list",
                new { Controller ="Admin" ,action="list" });


            routes.MapRoute("admin", "admin/{companyId}/center",
                new { Controller = "Admin", action = "Index", companyId = UrlParameter.Optional });

            routes.MapRoute("adminUsers", "admin/{companyId}/users",
            new { Controller = "Admin", action = "Users", companyId = UrlParameter.Optional  });

            routes.MapRoute("adminEditUser", "admin/{companyId}/edituser",
            new { Controller = "Admin", action = "EditUser", companyId = UrlParameter.Optional });

            routes.MapRoute("adminAddUser", "admin/{companyId}/adduser",
            new { Controller = "Admin", action = "AddUser", companyId = UrlParameter.Optional });

            routes.MapRoute("adminCache", "admin/{companyId}/cachelist",
            new { Controller = "Admin", action = "cachelist", companyId = UrlParameter.Optional });


            routes.MapRoute("editPage", "{companyId}/e/{cateId}/p/{pageId}/i/{itemId}",
                  new { Controller = "edit", action = "Index", companyId = UrlParameter.Optional, cateId = UrlParameter.Optional, pageId = UrlParameter.Optional,itemId=UrlParameter.Optional });

            routes.MapRoute("detail2", "detail/ajx2",
           new { controller = "edit", action = "detail2" });

            routes.MapRoute("detail", "detail/ajx",
                new { controller="edit",action = "detail" });

            routes.MapRoute("detail/api", "detail/api",
               new { controller = "edit", action = "api" });

            routes.MapRoute("editPageUpdate", "e/editupdate",
             new { Controller = "edit", action = "EditUpdate" });            


            routes.MapRoute("complexUpdate", "e/complexupdate",
               new { Controller = "Complex", action = "ComplexUpdate" });

            routes.MapRoute("bulkCreatePost", "e/bulkcreate",
                new { Controller = "create", action = "bulkCreate" });


            routes.MapRoute("createPageUpdate", "e/createupdate",
             new { Controller = "create", action = "CreateUpdate" });

            routes.MapRoute("write/api", "write/api",
            new { Controller = "create",action = "api" });

            routes.MapRoute("fileUpdate", "file/jcreate",
                new { Controller ="File" ,action= "JCreate" }
                );

            routes.MapRoute("fileTemplateUpdate", "file/tcreate",
            new { Controller = "File", action = "TCreate" }
            );


            routes.MapRoute("log", "log/data",
               new { Controller = "datalog", action = "data" }
               );

            routes.MapRoute("workflow", "log/workflow",
              new { Controller = "workflowlog", action = "workflow" }
              );


            routes.MapRoute("fakedel", "list/fakedel",
            new { Controller = "List", action = "FakeDel"  }
            );

            routes.MapRoute("admindel", "list/admindel",
             new { Controller = "List", action = "AdminDel" }
             );

            routes.MapRoute("listPage",
                 "{companyId}/list/{cid}/p/{id}",
                 new { Controller = "list", action = "Index", cid = UrlParameter.Optional, id = UrlParameter.Optional });


            routes.MapRoute("ajxlistPage",
                "list/ajxlist",
                new { Controller = "list", action = "ajxlist" });



            routes.MapRoute("UpdateWorkFlow",
                "list/updateworkflow", new { Controller = "list", action = "UpdateWorkFlow" });

            routes.MapRoute("UpdateStatus", "list/updatestatus", new { Controller = "list", action = "updatestatus" });
                

            routes.MapRoute("companyPage",
                 "{cid}/page/{id}",
                 new { Controller ="page",action = "Index",cid=UrlParameter.Optional,id=UrlParameter.Optional });


            routes.MapRoute(
                "customPage", // Route name
                "default-p{pageId}/", // URL with parameters
                new { controller = "Home", action = "Index", pageId = UrlParameter.Optional} // Parameter defaults
            );


            routes.MapRoute(
                   "customPageItem", // Route name
                   "default-p{pageId}/item-i{itemId}/", // URL with parameters
                   new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
               );


            routes.MapRoute(
                       "Seo", // Route name
                       "p/{pageId}/i/{itemId}", // URL with parameters
                       new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
                   );



            routes.MapRoute(
                       "Seo2x", // Route name
                       "p/{pageId}/i/{itemId}", // URL with parameters
                       new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
                   );

            routes.MapRoute(
                     "Seo2", // Route name
                     "p/{pageId}/q/{q}", // URL with parameters
                     new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, q = UrlParameter.Optional } // Parameter defaults
                 );

            //routes.MapRoute(
            //         "Seo3", // Route name
            //         "catalog-p{pageId}-c{itemId}/", // URL with parameters
            //         new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId= UrlParameter.Optional } // Parameter defaults
            //     );


            var customRouteSeo1 = ConfigurationManager.AppSettings["customRouteSeo1"];
            if (!string.IsNullOrWhiteSpace(customRouteSeo1))
            {
                routes.MapRoute(
                 "customRouteSeo1", // Route name
                  customRouteSeo1, // URL with parameters
                 new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
             );

            }


            var customRouteSeo5 = ConfigurationManager.AppSettings["customRouteSeo5"];
            if (!string.IsNullOrWhiteSpace(customRouteSeo5))
            {
                routes.MapRoute(
                 "customRouteSeo5", // Route name
                  customRouteSeo5, // URL with parameters
                 new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
             );

            }



            var customRouteSeo2 = ConfigurationManager.AppSettings["customRouteSeo2"];
            if (!string.IsNullOrWhiteSpace(customRouteSeo2))
            {
                routes.MapRoute(
                 "customRouteSeo2", // Route name
                  customRouteSeo2, // URL with parameters
                 new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
             );

            }


            var customRouteSeo3 = ConfigurationManager.AppSettings["customRouteSeo3"];
            if (!string.IsNullOrWhiteSpace(customRouteSeo3))
            {
                routes.MapRoute(
                 "customRouteSeo3", // Route name
                  customRouteSeo3, // URL with parameters
                 new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
             );

            }


            var customRouteSeo4 = ConfigurationManager.AppSettings["customRouteSeo4"];
            if (!string.IsNullOrWhiteSpace(customRouteSeo4))
            {
                routes.MapRoute(
                 "customRouteSeo4", // Route name
                  customRouteSeo4, // URL with parameters
                 new { controller = "Home", action = "Index", pageId = UrlParameter.Optional, itemId = UrlParameter.Optional } // Parameter defaults
             );

            }
           




            routes.MapRoute(
                "Default", // Route name
                "{controller}/{action}/{id}", // URL with parameters
                new { controller = "Home", action = "Index", id = UrlParameter.Optional } // Parameter defaults
            );


            //routes.MapRoute(
            //"cache", // Route name
            //"cache/", // URL with parameters
            //new { controller = "Home", action = "Cache"  } // Parameter defaults
            //);





            routes.IgnoreRoute("{*favicon}", new { favicon = @"(.*/)?favicon.ico(/.*)?" });

        }



        //string arg filled with the value of "varyByCustom" in your web.config
        public override string GetVaryByCustomString(HttpContext context, string arg)
        {
            if (arg == "roles")
            {

                //if (context.User != null & context.User.Identity.Name != null && context.User.Identity.Name.Contains(":"))
                //{
                //    var cusr = context.User.Identity.Name;
                //    var connectionString = CacheStatic.databaseString(Convert.ToInt32(cusr.Substring(0, cusr.IndexOf(':'))));    
                //    var profileField = ProfileManager.Provider.GetType().BaseType.GetField("_sqlConnectionString", BindingFlags.Instance | BindingFlags.NonPublic);
                //    if (profileField != null)
                //        profileField.SetValue(ProfileManager.Provider, connectionString);

                //    var pf = ProfileCommon.Create(context.User.Identity.Name, true) as ProfileCommon;
              
                //    if (pf != null && !string.IsNullOrEmpty(pf.RoleIds))
                //        return pf.RoleIds;
                //}

                

            }

            return base.GetVaryByCustomString(context, arg);
        }





        private void SetProvider()
        {
            var p = HttpContext.Current.Request.Url.ToString();

            if (rfiles.IsMatch(p)) return;


            var connectionString = string.Empty;

            if (HttpContext.Current != null && HttpContext.Current.User != null && HttpContext.Current.User.Identity.Name != null && HttpContext.Current.User.Identity.Name.Contains(":"))
            {
                var cusr = HttpContext.Current.User.Identity.Name;
                connectionString = CacheStatic.databaseString(Convert.ToInt32(cusr.Substring(0, cusr.IndexOf(':'))));
                //connectionStringField.SetValue(this, CacheStatic.databaseString(Convert.ToInt32(cusr.Substring(0, cusr.IndexOf(':')))));

                // Set private property of Membership, Role and Profile providers. Do not try this at home!!
                var connectionStringField = Membership.Provider.GetType().BaseType.GetField("_sqlConnectionString", BindingFlags.Instance | BindingFlags.NonPublic);
                if (connectionStringField != null)
                    connectionStringField.SetValue(Membership.Provider, connectionString);

                var roleField = Roles.Provider.GetType().BaseType.GetField("_sqlConnectionString", BindingFlags.Instance | BindingFlags.NonPublic);
                if (roleField != null)
                    roleField.SetValue(Roles.Provider, connectionString);

                var profileField = ProfileManager.Provider.GetType().BaseType.GetField("_sqlConnectionString", BindingFlags.Instance | BindingFlags.NonPublic);
                if (profileField != null)
                    profileField.SetValue(ProfileManager.Provider, connectionString);
            }
        
        }


        protected void Application_PreRequestHandlerExecute(object sender,EventArgs e)
        {
           //   SetProvider();
        }

        protected void Application_BeginRequest(Object sender, EventArgs e)
        {
            HttpApplication app = (HttpApplication)sender;


            var cookieName = WebConfigurationManager.AppSettings["cookieName"];


            for (int i = 0; i < HttpContext.Current.Request.Cookies.Count;i++ )
            {
                var cook = HttpContext.Current.Request.Cookies[i];
                if (cook.Name == cookieName) return;
            }


            var userSettingKey = WebConfigurationManager.AppSettings["anonymousUser"];
            var companyId = WebConfigurationManager.AppSettings["companyId"];
            if (userSettingKey == "true" && !string.IsNullOrWhiteSpace(companyId) && companyId.IsInt())
            {
                FormsAuthentication.SetAuthCookie(companyId + ":user", true);
            }
            else
            {

                var request = HttpContext.Current.Request;
                var key = request.QueryString["key"];
                if (request.HttpMethod.ToLower() == "post")
                {

                    var bytes = new byte[request.InputStream.Length];
                    request.InputStream.Read(bytes, 0, bytes.Length);
                    request.InputStream.Position = 0;
                    string json = Encoding.ASCII.GetString(bytes);
                    key = Regex.Match(json, @"(?<=key""?\s*?:\s*?[""'])[^""']+").Value;
                }

                if (!string.IsNullOrWhiteSpace(key))
                {

                    key = key.Replace("_", "+");
                    key = Uri.UnescapeDataString(key);
                    var result = CooWork.WcfServer.ServerCore.StringCipher.Decrypt(key, WebConfigurationManager.AppSettings["enc"]);


                 //   CacheStatic.LogTxt(result);


                    var ccid = result.Split('|')[0];
                    var userName = result.Split('|')[1].ToLower();
                    var password = result.Split('|')[2];
                    var t = result.Split('|')[3];

                    FormsAuthentication.SignOut();
                    if (!string.IsNullOrWhiteSpace(ccid) && !string.IsNullOrWhiteSpace(userName) && !string.IsNullOrWhiteSpace(password) )
                    {
                    //    CacheStatic.LogTxt(companyId + ":" + userName + " set cookie;");
                        FormsAuthentication.SetAuthCookie(companyId + ":" + userName , true);
                   
                    }

                }




            }








        }


        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {
            if (!HttpContext.Current.Request.IsAuthenticated)
            {
                var userSettingKey = WebConfigurationManager.AppSettings["anonymousUser"];
                var companyId = WebConfigurationManager.AppSettings["companyId"];
                if (userSettingKey == "true" && !string.IsNullOrWhiteSpace(companyId) && companyId.IsInt())
                {
                    FormsAuthentication.SetAuthCookie(companyId + ":user", true);
                }
            }

        }



        //internal static bool validateLicenseFile(string s1)
        //{
        //    try
        //    {


        //          var path = WebConfigurationManager.AppSettings["serverPath"] + @"\asm\";
        //            var f = Directory.GetFiles(path, "*.key");
        //            if (f.Length > 0)
        //            {
        //                CooWork.Core.License license = CooWork.Core.License.Load(f[0]);
        //                String publicKey = Resources.Resource1.String1;
        //                if (license != null)
        //                {
                          
        //                    var ls =  LicenseAuthorization.GetValidTerms(license, publicKey);
        //                    if (ls.UserName==s1)                       
        //                    return true;
        //                }
        //                else
        //                {
        //                    // no license file...                
        //                    return false;
        //                }
        //            }
        //    }
        //    catch (Exception se)
        //    {
                 
        //        var f = se.InnerException;           
               
        //    }

        //    // return false...invalid license.
        //    return false;
        //}



 



        protected void Application_Start()
        {
          


            //var TableName = "Processor";
            //var MethodName = "ProcessorId";
            //fGotLicense = false;


            //ManagementObjectSearcher MOS = new ManagementObjectSearcher("Select * from Win32_" + TableName);
            //foreach (ManagementObject MO in MOS.Get())
            //{
            //    try
            //    {
            //        var s1 = MO[MethodName].ToString();

            //        if (validateLicenseFile(s1))
            //            fGotLicense = true;          
            //    }
            //    catch (Exception ee)
            //    {
            //        fGotLicense = false;
            //    }
            //}



        
            
      



            AreaRegistration.RegisterAllAreas();
           // TaskManager.Instance().Start();

        

           

            RegisterGlobalFilters(GlobalFilters.Filters);
            RegisterRoutes(RouteTable.Routes);
            BootstrapContainer();
            ViewEngines.Engines.Clear();
            ViewEngines.Engines.Add(new RazorViewEngine());
            BrokerService.clearCache();
            BrokerService.startDependency();            

          //  ViewEngines.Engines.RemoveAt(0);
        //    System.Web.Hosting.HostingEnvironment.RegisterVirtualPathProvider(new AssemblyResourceProvider());
        }


        protected void Application_End()
        {
            BrokerService.stopDependency();
        // Container.Dispose();
        }
    }
}