﻿CooWorkApp.directive('datepick', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element

        element.datePicker({ startDate: '1996-01-01' });
        element.addClass('text_88');
    }
}]);


CooWorkApp.directive('ngRightClick', function($parse) {
    return function(scope, element, attrs) {
        var fn = $parse(attrs.ngRightClick);
        element.bind('contextmenu', function(event) {
            scope.$apply(function() {
                event.preventDefault();
                fn(scope, {$event:event});
            });
        });
    };
});

CooWorkApp.directive('myEnter', function () {
    return function (scope, element, attrs) {
        element.bind("keydown keypress", function (event) {

           console.log(event.which);
            if(event.which === 13) {
                scope.$apply(function (){
                    scope.$eval(attrs.myEnter);
                });

                event.preventDefault();
            }
        });
    };
});


CooWorkApp.value('uiTinymceConfig', {
  fontsize_formats: "8pt 9pt 10pt 11pt 12pt 26pt 36pt",
  plugins: "textcolor preview importcss code",
  toolbar: "forecolor backcolor preview  fontselect  fontsizeselect",
  textcolor_rows: "4",
  language: 'zh_CN',
  readonly :   0

});


CooWorkApp.directive('tinymce', ['uiTinymceConfig', function (uiTinymceConfig) {
    uiTinymceConfig = uiTinymceConfig || {};
    var generatedIds = 0;
    return {
        priority: 10,
        require: 'ngModel',
        link: function (scope, elm, attrs, ngModel) {
            var expression, options, tinyInstance,
              updateView = function () {
                  ngModel.$setViewValue(elm.val());
                  if (!scope.$root || !scope.$root.$$phase) {
                      scope.$apply();
                  }
              };



            if (!attrs.id) {
                attrs.$set('id', 'uiTinymce' + generatedIds++);
            }

            if (attrs.uiTinymce) {
                expression = scope.$eval(attrs.uiTinymce);
            } else {
                expression = {};
            }


            if (expression.setup) {
                var configSetup = expression.setup;
                delete expression.setup;
            }

            options = {
                // Update model when calling setContent (such as from the source editor popup)
                setup: function (ed) {
                    var args;
                    ed.on('init', function(args) {
                        ngModel.$render();
                        ngModel.$setPristine();
                    });
                    // Update model on button click
                    ed.on('ExecCommand', function (e) {
                        ed.save();
                        updateView();
                    });
                    // Update model on keypress
                    ed.on('KeyUp', function (e) {
                        ed.save();
                        updateView();
                    });
                    // Update model on change, i.e. copy/pasted text, plugins altering content
                    ed.on('SetContent', function (e) {
                        if (!e.initial && ngModel.$viewValue !== e.content) {
                            ed.save();
                            updateView();
                        }
                    });
                    ed.on('focus', function(e) {

                        $(elm[0]).attr('v','e');
                        //console.log(elm[0].id);
                        elm.focus();
                    });


                    ed.on('blur', function(e) {

                        elm.blur();
                    });
                    // Update model when an object has been resized (table, image)
                    ed.on('ObjectResized', function (e) {
                        ed.save();
                        updateView();
                    });
                    if (configSetup) {
                        configSetup(ed);
                    }
                },
                mode: 'exact',
                elements: attrs.id
            };
            // extend options with initial uiTinymceConfig and options from directive attribute value
            angular.extend(options, uiTinymceConfig, expression);
            setTimeout(function () {

                tinymce.init(options);
            });



            ngModel.$render = function() {
              if (!tinyInstance) {
                  tinyInstance = tinymce.get(attrs.id);
              }
              if (tinyInstance) {
                tinyInstance.setContent(ngModel.$viewValue || '');
              }
            };

            scope.$on('$destroy', function() {
              if (!tinyInstance) { tinyInstance = tinymce.get(attrs.id); }
              if (tinyInstance) {
                tinyInstance.remove();
                tinyInstance = null;
              }
            });

        }
    };
}]);





CooWorkApp.directive('editorc', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element
        element.jqte();

    }
}]);



CooWorkApp.directive('dfnscript', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element
        console.log(attributes);
        var evt = _.filter(cooConfig.allevent, function (n) { return n.pageId == parseInt(attributes.pageid) });
        if (evt.length > 0) {
            console.log(evt);
            //  var eSource = "$(document.body).on('click', 'input' ,function(){ $(this).val('123');  });   $('#__c15515').val('222');   ";
            g.dfnScript(evt[0].eventSource);
        }


     //   element.replaceWith("<div class=\"script\"><script type=\"text/javascript\"> console.log('fff');  $(document.body).on('click', 'input' ,function(){ $(this).val('123');  });    </script></div>");

    }
}]);





CooWorkApp.directive('editor', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {

            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {

                element = $(element[0]);
              //  element.jqte();
             //    element.jqteVal(modelValue);
             //   console.log(modelValue);

             tinymce.init({
                        selector: '.editor',
                        fontsize_formats: "8pt 9pt 10pt 11pt 12pt 26pt 36pt",
                        plugins: "textcolor preview importcss code",
                        toolbar: "forecolor backcolor preview  fontselect  fontsizeselect",
                        textcolor_rows: "4",
                        language: 'zh_CN',
                        readonly :   0
                   });

            });
        }
    }
}]);



CooWorkApp.directive('attachment', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {

            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {
                element = $(element[0]);

                g.dragFile(modelValue.p.ID, scope.indexId, modelValue.p.categoryId);
            });
        }
    }
}]);


CooWorkApp.directive('attachmentdata', ['cooConfig', 'g','rest', function (cooConfig, g,rest) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element

        var fs = require('fs');
        var rq = require('request');

        var pageId = attributes.pageid;
        var categoryId = attributes.categoryid;


        var holder = element[0];// document.getElementById("__img0");
        holder.ondragover = function () { $("#__img0").addClass("draghover"); return false; };
        holder.ondragend = function () { $("#__img0").removeClass("draghover"); return false; };
        holder.ondrop = function (e) {
            e.preventDefault();

            var cElements = g.userPatternFilterByPage(pageId);

            if (cElements.length == 0) cElements = g.patternFilterByPage(pageId);


            if (e.dataTransfer.files.length > 0) {
                var formData = {
                    // Pass a simple key-value pair
                    key: cooConfig.configObj.uploadKey,
                    itemId: 0,
                    cateId: categoryId,
                    // Pass data via Streams
                    my_file: fs.createReadStream(e.dataTransfer.files[0].path)
                    // Pass multiple values /w an Array
                };





                $.when(g.postFile(formData)).done(function (obj) {

                    console.log(obj);
                    var etor = {
                        cateId: categoryId,
                        pageId: pageId,
                        aid: obj.ID
                    };

                    $.when(rest.import(etor)).done(function (data) {

                        console.log(data);
                        $("#importb tr:nth-child(n+2)").remove();

                        $(data).each(function (i, item) {
                            var tr = '<tr>';
                            tr += '<td> <input  type="checkbox"  name="mainCheckBox"></td>';
                            $(cElements).each(function (j, p) {

                                var v = item['__c' + p.ID] == undefined ? "" : item['__c' + p.ID];

                                tr += '<td ><div contenteditable="true" name="__c' + p.ID + '" >' + v + '</div></td>';

                            });

                            tr += '</tr>';
                            $("#importb").append(tr);
                        });


                        scope.$apply();
                    });
                });
            }
        };



    }
}]);




CooWorkApp.directive('attachments', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {
            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {
                element = $(element[0]);

                g.multiDragFile(modelValue.p.ID, scope.indexId, modelValue.p.categoryId);
            });
        }
    }
}]);







CooWorkApp.directive('multiselectdropdown', ['cooConfig', 'g','rest', function (cooConfig, g,rest) {
    return function (scope, element, attributes) {

        element = $(element[0]); // Get the element as a jQuery element

        // Below setup the dropdown:

        var source = [];
        var sls = [];
        var tid = attributes.name;
        var type = attributes.type;



        switch (type)
        {
            case '_sys_group':
                var gid = attributes.pageid;
                var gpat = g.patternFilterByPage(gid);
                $.each(gpat, function (index, item) {
                    var o = { label: '请选择', value: '' };

                    var o1 = { label: '请选择', value: '' };
                    var o2 = { label: '请选择', value: '' };
                    var o3 = { label: '请选择', value: '' };
                    var o4 = { label: '请选择', value: '' };
                    var o5 = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 2:
                        case 5:
                        case 12:
                        case 13:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                        case 6:
                            o1.label = item.pName + '(年)';
                            o1.value = item.ID + '_1';
                            sls.push(o1);
                            o2.label = item.pName + '(季)';
                            o2.value = item.ID + '_2';
                            sls.push(o2);
                            o3.label = item.pName + '(月)';
                            o3.value = item.ID + '_3';
                            sls.push(o3);
                            o4.label = item.pName + '(周)';
                            o4.value = item.ID + '_4';
                            sls.push(o4);
                            o5.label = item.pName + '(日)';
                            o5.value = item.ID + '_5';
                            sls.push(o5);
                            break;

                    }
                });
                break;

            case '_sys_order':
                var oid = attributes.pageid;
                var opat = g.patternFilterByPage(oid);
                sls.push({ label: '请选择', value: '' });
                $.each(opat, function (index, item) {
                    var o = { label: '请选择', value: '' };
                    var o1 = { label: '请选择', value: '' };
                    var o2 = { label: '请选择', value: '' };
                    var o3 = { label: '请选择', value: '' };
                    var o4 = { label: '请选择', value: '' };
                    var o5 = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                        case 12:
                        case 13:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                        case 6:
                            o1.label = item.pName + '(年)';
                            o1.value = item.ID + '_1';
                            sls.push(o1);
                            o2.label = item.pName + '(季)';
                            o2.value = item.ID + '_2';
                            sls.push(o2);
                            o3.label = item.pName + '(月)';
                            o3.value = item.ID + '_3';
                            sls.push(o3);
                            o4.label = item.pName + '(周)';
                            o4.value = item.ID + '_4';
                            sls.push(o4);
                            o5.label = item.pName + '(日)';
                            o5.value = item.ID + '_5';
                            sls.push(o5);
                            break;

                    }
                });
                break;
            case '_sys_calculate':
                var cid = attributes.pageid;
                var cpat = g.patternFilterByPage(cid);
                $.each(cpat, function (index, item) {
                    var o = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 3:
                        case 4:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                    }
                });
                break;
            case 'order':
                var pageId = attributes.pageid;
                var p12 = g.pageFilter(12, pageId);
                if (p12.length > 0) {
                    var patternSort = g.patternFilterByPage(p12[0].ID);

                    var o = { label: '请选择', value: '' };
                    sls.push(o);

                    $(patternSort).each(function (j, m) {

                        var op = { label: '↑ ' + m.pName, value: '__c' + m.ID + 'x1' };
                        var op2 = { label: '↓ ' + m.pName, value: '__c' + m.ID + 'x2' };
                        sls.push(op);
                        sls.push(op2);
                    });
                }
                break;
            case 'user':

                tid = tid.replace(/\D/ig, '');
                source = g.statusFilterByPattern(tid);
                var users = cooConfig.alluser;
                if (source.length > 0) {
                      users = g.userFilterByRoleId(source[0].statusName);
                 }

                    var otherusers = _.filter(users,function(n){ return n.departmentId==null || n.departmentId==0; });

                    var orow = { label:"未分部门",children:[]  };
                    orow.children.push({label:'未选择',value:'00000000-0000-0000-0000-000000000000'});
                    $(otherusers).each(function(i,f){
                      orow.children.push({label:f.XingMing,value:f.UserId});
                    });




                    $(cooConfig.alldepartment).each(function(i,d){

                                var row ={ label:d.departmentName,children:[] };
                                var subusers = _.filter(users,function(n){ return n.departmentId==d.ID; });
                                $(subusers).each(function(i,f){
                                  row.children.push({label:f.XingMing,value:f.UserId});
                                });

                       sls.push(row);
                    })


                    sls.push(orow);


                //    $(users).each(function (i, item) {
                //        var op = { label: item.XingMing, value: item.UserId };
              //          sls.push(op);
              //      });


                break;
            case 'data':
                tid = tid.replace(/\D/ig, '');
                source = g.statusFilterByPattern(tid);

                var smp= _.find(cooConfig.allstatusmap,function(n){ return n.patternId.toString() == tid});
              //  console.log(smp);
                if (smp&&smp.init)
                {
                    $(source).each(function (i, item) {
                        var op = { label: item.statusName, value: item.ID };
                        sls.push(op);
                    });
                }

            case 'element':
                tid = tid.replace(/\D/ig, '');
                source = g.userPatternFilterByPage(tid);
                $(source).each(function (i, item) {
                    var op = { label: item.pName, value: item.ID };
                    sls.push(op);
                });

                break;
            case 'element2':
                tid = tid.replace(/\D/ig, '');
                source = g.patternFilterByPage(tid);
                $(source).each(function (i, item) {
                    var op = { label: item.pName, value: item.ID };
                    sls.push(op);
                });

                break;

        } ;



        element.multiselect({
            enableClickableOptGroups: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            onDropdownShown: function(event) {

              //   $(".create_all .ui.table").append('<tr class="plugin" style="height:400px;" ></tr>')
             },
             onDropdownHidden: function(event) {
            //   $(".create_all .ui.table .plugin").remove();
             },
            onChange: function(option, checked) {

             var v1 = $('#__c'+tid).val();
             if (v1 && v1.length>0)
             {
                 var s1 = v1[0];
                 if (s1 && parseInt(s1)>0)
                 {
                        var ss =_.filter(cooConfig.allstatus,function(n){ return n.parentId == parseInt(s1)});
                        var smp= _.find(cooConfig.allstatusmap,function(n){ return n.patternId.toString() == tid});
                        if (ss.length>0 && smp)
                        {
                          var ssp = [];
                          $(ss).each(function(i,item){
                            ssp.push({ label: item.statusName, value: item.ID });
                          });

                          var childElement =_.find(cooConfig.allstatusmap,function(n){ return n.groupId==ss[0].groupId &&n.categoryId==smp.categoryId });

                          if (childElement)
                          {
                            $('[name="__c'+childElement.patternId+'"]').multiselect('dataprovider', ssp);
                          }
                        }
                   }
              }
            }
        });

         var opts={ enableClickableOptGroups: true};

        if (sls.length>0)   element.multiselect('dataprovider', sls);

        if (attributes.val)
        {
            var vv = attributes.val.split(',');
      //      console.log(vv);
            element.multiselect('select', vv);
        }



                  // element.multiselect('setOptions', opts);
    }

}]);
