module.exports = function(grunt) {

    // Project configuration.   /<\!--apps-->[\s\S]*?<\!--appe-->/ig,
  grunt.initConfig({
      pkg: '<json:package.json>',

	ngAnnotate: {
        options: {
            singleQuotes: true,
        },
        demo: {
            files: {
                'src/app.js': ['../../../../../bizweb/NodeWeb/js/app.js'],
     			'src/directives.js': ['../../../../../bizweb/NodeWeb/js/directive/directives.js'],
				'src/routes.js': ['../../../../../bizweb/NodeWeb/js/route/routes.js'],
                'src/cooConfig.js': ['../../../../../bizweb/NodeWeb/js/service/cooConfig.js'],
				'src/locdbServices.js': ['../../../../../bizweb/NodeWeb/js/service/locdbServices.js'],
                'src/rest.js': ['../../../../../bizweb/NodeWeb/js/service/rest.js'],
				'src/g.js': ['../../../../../bizweb/NodeWeb/js/service/g.js'],
				'src/login.js': ['../../../../../bizweb/NodeWeb/js/service/login.js'],
				'src/basecontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/basecontrollers.js'],



        'src/customcontrollers.js': ['../../../../../bizweb/NodeWeb/custom/2024/customcontrollers.js'],
        'src/global.js': ['../../../../../bizweb/NodeWeb/js/service/global.js'],



				'src/createcontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/createcontrollers.js'],
				'src/bulkcreatecontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/bulkcreatecontrollers.js'],
				'src/editcontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/editcontrollers.js'],
				'src/viewcontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/viewcontrollers.js'],
				'src/reportcontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/reportcontrollers.js'],
					'src/listcontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/listcontrollers.js'],
					'src/admincontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/admincontrollers.js'],
					'src/complexcontrollers.js': ['../../../../../bizweb/NodeWeb/js/controller/complexcontrollers.js'],

            }

        }
    },
	uglify: {
        demo1: {
            files: {
                'src/min/app.min.js': ['src/app.js'],
     			'src/min/directives.min.js': ['src/directives.js'],
				'src/min/routes.min.js': ['src/routes.js'],
                'src/min/cooConfig.min.js': ['src/cooConfig.js'],
				'src/min/locdbServices.min.js': ['src/locdbServices.js'],
                'src/min/rest.min.js': ['src/rest.js'],
				'src/min/g.min.js': ['src/g.js'],
				'src/min/login.min.js': ['src/login.js'],
                'src/min/basecontrollers.min.js': ['src/basecontrollers.js'],

'src/min/customcontrollers.min.js': ['src/customcontrollers.js'],
'src/min/global.min.js': ['src/global.js'],

					  'src/min/createcontrollers.min.js': ['src/createcontrollers.js'],
					  'src/min/bulkcreatecontrollers.min.js': ['src/bulkcreatecontrollers.js'],
					  'src/min/editcontrollers.min.js': ['src/editcontrollers.js'],
					  'src/min/viewcontrollers.min.js': ['src/viewcontrollers.js'],
					  'src/min/reportcontrollers.min.js': ['src/reportcontrollers.js'],
					  'src/min/listcontrollers.min.js': ['src/listcontrollers.js'],
					  'src/min/admincontrollers.min.js': ['src/admincontrollers.js'],
					  'src/min/complexcontrollers.min.js': ['src/complexcontrollers.js'],




            }
        }
    },

    concat: {
        options: {
            separator: grunt.util.linefeed + ';' + grunt.util.linefeed,
            stripBanners: true

        },
       js: {
           src: [
                '../../../../../bizweb/NodeWeb/js/lib/jquery.min.js',
                '../../../../../bizweb/NodeWeb/js/lib/amplify.store.min.js',
                '../../../../../bizweb/NodeWeb/js/lib/angular.1.3.8.js',
			   '../../../../../bizweb/NodeWeb/js/lib/angular-resource.min.js',
			   '../../../../../bizweb/NodeWeb/js/lib/angular-route.min.js',
			   '../../../../../bizweb/NodeWeb/js/lib/angular-file-upload.min.js',
			      '../../../../../bizweb/NodeWeb/js/lib/date.js',
			      '../../../../../bizweb/NodeWeb/js/lib/jquery.datePicker.js',
			   	      '../../../../../bizweb/NodeWeb/js/lib/bootstrap.min.js',
			   	      '../../../../../bizweb/NodeWeb/js/lib/bootstrap-multiselect.js',
			      	      '../../../../../bizweb/NodeWeb/dist/semantic.min.js',
			    '../../../../../bizweb/NodeWeb/js/lib/underscore.js',
			    '../../../../../bizweb/NodeWeb/js/lib/ngDialog.js',

'../../../../../bizweb/NodeWeb/js/lib/tinymce/tinymce.min.js',
'../../../../../bizweb/NodeWeb/js/lib/echarts.min.js',
'../../../../../bizweb/NodeWeb/js/lib/echarts-ng.js',




          //
			    // '../../../../../bizweb/NodeWeb/js/lib/jqplot/jquery.jqplot.min.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.dateAxisRenderer.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.logAxisRenderer.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.canvasTextRenderer.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.canvasAxisTickRenderer.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.highlighter.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.barRenderer.min.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.categoryAxisRenderer.min.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.pointLabels.min.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.pieRenderer.min.js',
			    // '../../../../bizweb/NodeWeb/js/lib/jqplot/jqplot.donutRenderer.min.js',





               //'js/lib/signalr-hub.min.js',



                 'src/min/app.min.js',
                  'src/min/directives.min.js',
                     'src/min/routes.min.js',
                        'src/min/cooConfig.min.js',
                          'src/min/locdbServices.min.js',
                              'src/min/rest.min.js',
                                 'src/min/g.min.js',
                                 'src/min/login.min.js',
                                 'src/min/basecontrollers.min.js',
					  'src/min/createcontrollers.min.js',
					  'src/min/bulkcreatecontrollers.min.js',
					  'src/min/editcontrollers.min.js',
					  'src/min/viewcontrollers.min.js',
					  'src/min/reportcontrollers.min.js',
					  'src/min/listcontrollers.min.js',
					  'src/min/admincontrollers.min.js',
					  'src/min/complexcontrollers.min.js',

            'src/min/customcontrollers.min.js',
            'src/min/global.min.js' ,

           ],
           dest: '../../../../../project/2024/greensun.20161202.js'
       } ,
	    css :
		{
			  src:[
				   '../../../../../bizweb/NodeWeb/dist/semantic.min.css',
				 '../../../../../bizweb/NodeWeb/css/bootstrap.min.css',
				   '../../../../../bizweb/NodeWeb/css/bootstrap-multiselect.css',
				   '../../../../../bizweb/NodeWeb/css/ngDialog.css',
				   '../../../../../bizweb/NodeWeb/css/ngDialog-theme-default.css',
				   '../../../../../bizweb/NodeWeb/css/ngDialog-theme-plain.css',
				   '../../../../../bizweb/NodeWeb/css/ngDialog-theme-default-dialog.css',
				   '../../../../../bizweb/NodeWeb/css/datePicker.css',
    // '../../../../../bizweb/NodeWeb/css/CooWorkNode.css',
				  // '../../../../../bizweb/NodeWeb/css/app.css',


			  ],
			  dest:"../../../../../project/2024/greensun.20161202.css"


		},
		css3 :
		{
			  src:[
				   '../../../../../bizweb/dist/button.css',
				 '../../../../../bizweb/dist/container.css',
				   '../../../../../bizweb/dist/divider.css',
				   '../../../../../bizweb/dist/form.css',
				   '../../../../../bizweb/dist/grid.css',
				   '../../../../../bizweb/dist/header.css',
				   '../../../../../bizweb/dist/icon.css',
				   '../../../../../bizweb/dist/image.css',
				   '../../../../../bizweb/dist/input.css',
				   '../../../../../bizweb/dist/list.css' ,
				  		   '../../../../../bizweb/dist/menu.css'   	,
				  		   '../../../../../bizweb/dist/message.css'   	,
				  		   '../../../../../bizweb/dist/reset.css'   	,
				  	   '../../../../../bizweb/dist/segment.css'   		,
				  	   '../../../../../bizweb/dist/site.css'

			  ],
			  dest:'css/axon.logon.css'

		}

    },
	cssmin: {
		  css:{
		      src: '../../../../../project/2024/greensun.20161202.css',
		      dest: "../../../../../project/2024/greensun.20161202.min.css"
		  },


		    },
    jshint: {
      options: {
        curly: true,
        eqeqeq: true,
        immed: true,
        latedef: true,
        newcap: true,
        noarg: true,
        sub: true,
        undef: true,
        boss: true,
        eqnull: true,
        node: true
      },
      all: ['dest/js/*.js'],
      globals: {
        exports: true,
        module: false
      }
    }

  });


//  grunt.loadNpmTasks('grunt-string-replace');
  grunt.loadNpmTasks('grunt-contrib-uglify');
  grunt.loadNpmTasks('grunt-contrib-jshint');
  grunt.loadNpmTasks('grunt-contrib-concat');
  grunt.loadNpmTasks('grunt-contrib-cssmin');
  grunt.loadNpmTasks('grunt-ng-annotate');

  // Default task.
  grunt.registerTask('default', [  'ngAnnotate', 'uglify', 'concat', 'cssmin']); //'concat',, 'jshint' 'string-replace',

};
