﻿
CooWorkApp.controller('mobile_listController', function ($rootScope, $scope, $location, $routeParams, $sce, locdbServices, userSetting, cooConfig, g, rest, _, ngDialog) {

    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    var openConfirm = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/confirm.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };






    Date.firstDayOfWeek = 0;
    Date.format = 'yyyy-mm-dd';

   // var fs = require('fs');


    var categoryId = $routeParams.categoryId;
    var pageId = $routeParams.pageId;
      

    var currentPage = g.pageFilterById(pageId)[0];
    $rootScope.title = currentPage.UIname + ' - 列表';



    var p11 = g.pageFilter(11, pageId);
    var p14 = g.pageFilter(14, pageId);

    var rec = [];
    $scope.sElements = [];
    $scope.vElements = [];
    var lsc = [];
    var stat = [];

    $scope.searchConfigElements = [];
    $scope.listConfigElements = [];

    //menu
    $scope.workfls = [];
    $scope.editpages = [];
    $scope.stateditpages = [];
    $scope.bulkcreatepages = [];
    $scope.exportpages = [];
    $scope.isadmin = cooConfig.configObj.isAdmin;
    $scope.viewdetailpages = [];
    //menu


    var osElements = g.patternFilterByPage(p11[0].ID);
    var ovElements = g.patternFilterByPage(p14[0].ID);

    var indexPattern = g.patternFilterByIndexId(categoryId);


    $scope.s = '2';
    $scope.vdata = [];
    $scope.paging = {};
    $scope.startIndex = 1;
    $scope.pageSize = 15;
    $scope.resultData = [];

    $scope.pages = [{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 15, Title: '15' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];






    var renderList = function () {

        $("#ajax").html("<img src='css/ajax1.gif' />");
        $.when(rest.search(categoryId, pageId, lsc, $scope.startIndex, $scope.pageSize)).done(function (result) {

            //todo server
            var r = /pageNumber\((\d+)\)/ig;
            var matches = [], found;
            while (found = r.exec(result.p)) {
                matches.push(parseInt(found[1]));
            }
            var total = 1;
            if (matches.length > 0) total = Math.max.apply(Math, matches);
            //todo

            $scope.paging = g.getPaging(total, $scope.startIndex);
            //  console.log(result.data);

            if (result.s != undefined) $scope.s = result.s.replace(/<[^>]+>/ig, '');

            $scope.s = $scope.s.replace(/(\.\d\d)(\d+)/ig, '$1');

            var pIndex = g.patternFilterByIndexId(categoryId);
            var vdata = [];
            $(result.data).each(function (j, val) {

                var row = [];
                for (var k = 0; k < rec.length; k++) {

                    var v = g.prepareVal(val, rec[k]);

                    var ctor = { ID: rec[k].ID, pTypeId: rec[k].pTypeId, val: v, pName: rec[k].pName};

                    row.push(ctor);
                    row['index'] = val['__c' + pIndex[0].ID];
                    row['depth'] = val.depth;
                };

                vdata.push(row);

            });
            $scope.vdata = vdata;
            $scope.resultData = result.data;

            var qlink = '<div class="qlink"></div>';  //todo
            //if (p2.length > 0) {
            //    qlink += '<div><a title="' + p2[0].UIname + '" onclick="editPopi(' + categoryId + ',' + p2[0].ID + ',' + val['__c' + pIndex[0].ID] + ')">' + p2[0].UIname.substring(0, 2) + '</a></div>';
            //}
            //if (p8.length > 0) {
            //    qlink += '<div><li><a title="' + p8[0].UIname + '" onclick="pviewPopi(' + categoryId + ',' + p8[0].ID + ',' + val['__c' + pIndex[0].ID] + ')">' + p8[0].UIname.substring(0, 2) + '</a></div>';
            //}
            //qlink += '</div>';
            $("#ajax").html("");
            $('.mobile_search_top').hide();
            $scope.$apply();


        });
    };


    var getChecked = function () {
        var checkboxes = document.getElementsByName("mainCheckBox");
        var vals = "";
        for (var i = 0, n = checkboxes.length; i < n; i++) {
            if (checkboxes[i].checked)
                vals += "," + checkboxes[i].id.replace("checkbox_", "");
        }
        vals = vals.length > 0 ? vals.substring(1) : "";
        return vals;
    }




    $.when(userSetting.getSettingElementByPage(p11[0].ID), userSetting.getSettingElementByPage(p14[0].ID)).done(function (a, b) {




        $scope.vElements = b;

        $(a).each(function (i, o) {
            if (o.pTypeId != 10 && o.pTypeId != 11) {
                $scope.sElements.push(o);
            }
        });




        //config
        var eleStr = ',';
        $($scope.sElements).each(function (i, item) {
            eleStr += item.ID + ',';
        });

        var veleStr = ',';
        $($scope.vElements).each(function (i, item) {
            veleStr += item.ID + ',';
        });


        $(ovElements).each(function (i, o) {
            if (veleStr.indexOf(',' + o.ID.toString() + ',') > -1) {
                $scope.listConfigElements.push({ item: o, select: true });
            }
            else {
                $scope.listConfigElements.push({ item: o, select: false });
            }
        });


        $(osElements).each(function (j, obj) {

            if (obj.pTypeId != 10 && obj.pTypeId != 11) {

                if (eleStr.indexOf(',' + obj.ID.toString() + ',') > -1) {
                    $scope.searchConfigElements.push({ item: obj, select: true });
                }
                else {
                    $scope.searchConfigElements.push({ item: obj, select: false });
                }
            }
        });
        //config;




        //menu
        var workfls = g.workFlowFilterByCategory(categoryId);



        var p9 = g.pageFilterByCategoryType(categoryId, 9);
        var pattern13 = g.patternFilterByType(categoryId, 13);

        g.initButton();
        if (workfls.length > 0 && p9.length > 0 && pattern13.length > 0) {
            var ids = [];
            $(workfls).each(function (k, w) {
                ids.push(w.tagId2);
            });
            $scope.workfls = g.statusFilterByIds(ids, pattern13[0].ID);
        }




        var p2 = g.pageFilterByCategoryType(categoryId, 2);
        var p100 = g.pageFilterByCategoryType(categoryId, 100);
        $(p2).each(function (i, o) {
            $scope.editpages.push(o);
        });

        $(p100).each(function (i, o) {
            $scope.editpages.push(o);
        });


        var p3 = g.pageFilterByCategoryType(categoryId, 3);
        $(p3).each(function (i, p) {

            var ele = g.elementFilterByPage(p.ID);
            if (ele.length > 0) {
                var stat = [];
                var ppp = _.find(cooConfig.allpattern, function (p) { return p.ID == ele[0].patternId });
                if (ppp.pTypeId == 2 || ppp.pTypeId == 20) {
                    stat = g.statusFilterByPattern(ele[0].patternId);
                }
                else if (ppp.pTypeId == 12 || ppp.pTypeId == 19) {
                    var srole = _.find(cooConfig.allstatus, function (s) { return s.patternId == ele[0].patternId && s.categoryId == categoryId });
                    var susers = _.filter(cooConfig.alluser, function (u) { return u.RoleIds.toLowerCase().indexOf(srole.statusName.toLowerCase()) > -1; });

                    $(susers).each(function (i, u) {
                        stat.push({ ID: u.UserId, statusName: u.XingMing });
                    });

                }




                $scope.stateditpages.push({ page: p, source: stat });
            }
        });


        $scope.joinpages = [];

        var anyj = _.filter(cooConfig.alljoin, function (j) { return j.categoryId == categoryId && (j.nRelation == 1 || j.nRelation == 2) });

        if (anyj.length > 0) {
            var allc = [];

            $(anyj).each(function (i, o) {
                var subj = _.filter(cooConfig.alljoin, function (j) { return j.categoryId == o.joinCategoryId && (j.nRelation == 1 || j.nRelation == 3) && j.joinCategoryId == categoryId });
                if (subj.length > 0) allc.push(o.joinCategoryId);
            });


            //   var allc = _.pluck(anyj, 'joinCategoryId');           

            $scope.joinpages = _.filter(cooConfig.allpage, function (p) { return _.contains(allc, p.categoryId) && p.pageType == 15; });

        }





        $scope.createpages = g.pageFilterByCategoryType(categoryId, 15);
        $scope.hasParentPage = _.filter(cooConfig.allpattern, function (p) { return p.categoryId == categoryId && p.pTypeId == 18; });

        $scope.bulkcreatepages = g.pageFilterByCategoryType(categoryId, 5);

        $scope.exportpages = g.pageFilterByCategoryType(categoryId, 7);

        $scope.viewdetailpages = g.pageFilterByCategoryType(categoryId, 8);

        $scope.viewdetailpages = _.union($scope.viewdetailpages, g.pageFilterByCategoryType(categoryId, 101));
        //menu

        var iSearchConditions = 0;
        var stat = [];



        var r = 0;
        for (; r < $scope.vElements.length; r++) {
            if (r >= cooConfig.maxListColumns) break;
            rec.push($scope.vElements[r]);
        }

        //   $scope.vElements = rec;     
        $scope.pageId = pageId;

        renderList();


        $scope.dosearch = function () {
            lsc = g.getSearchCondition('', $scope.sElements);
            $scope.startIndex = 0;
            renderList();
        };

        $scope.pageSizeChange = function (p) {
            $scope.startIndex = 0;
            renderList();
        };


        $scope.searchClear = function () {
            //   openAlert('ok!');
            window.location.href = window.location.href + '/';

        };


        $scope.clearListConfig = function () {
            $('.ovc').prop('checked', false);
        };


        $scope.clearSearchConfig = function () {
            $('.osc').prop('checked', false);
        };


        $scope.rowHasAttach = function (row) {

            var t = false;
            $(row).each(function (i, j) {
                if (j.pTypeId==10||j.pTypeId==11)
                {
                    t = true;
                    return false;
                }
            });
            return t;
        };



        $scope.dosm = function () {
            $('#saomadiv').show();
        };

        $scope.saomacancel = function () {
            $('#saomadiv').hide();
        };

        $scope.saomasubmit = function () {
            var val = $("#idlist").val();
            var r = /[0-9]+/g;
            var matches = [], found;
            while (found = r.exec(val)) {
                matches.push(found[0]);
            }

            var tt = matches.toString();
            if (tt == "") tt = "0";


            $('#__c' + indexPattern[0].ID).val(tt);
            $('#__c' + indexPattern[0].ID + '_o').val(5);

            lsc = g.getSearchCondition('', $scope.sElements);
            $scope.startIndex = 0;
            renderList();

            $("#saomadiv").hide();
        };



        $scope.pageNumber = function (i) {
            $scope.startIndex = i;
            renderList();
        };


        $scope.closeConfirm = function (id, flag) {
            ngDialog.close(id);
            if (flag) {
                var vals = getChecked();
                if (vals == "") return openAlert('未选中！');

                var etor = {
                    ids: vals,
                    categoryId: categoryId
                };

                $.when(rest.adminDel(etor)).done(function (f) {
                    if (f) { renderList(); } else { openAlert('删除失败！'); };
                });
            }
        }


        $scope.adminDel = function (h) {

            openConfirm("确认删除?");

        };

        $scope.fakeDel = function (h) {
            var vals = getChecked();
            if (vals == "") return openAlert('未选中！');

            var etor = {
                ids: vals,
                categoryId: categoryId,
                del: h
            };

            $.when(rest.fakeDel(etor)).done(function (f) {
                if (f) { renderList(); } else { openAlert('删除失败！'); };
            });
        };




        $scope.updateWorkFlow = function (statusId) {
            var vals = getChecked();
            if (vals == '') {
                return openAlert('未选中！');
            };

            var p9 = g.pageFilterByCategoryType(categoryId, 9);
            var etor = {
                ids: vals,
                cateId: categoryId,
                listPageId: pageId,
                pageId: p9[0].ID,
                statusId: statusId
            };
            $.when(rest.updateWorkFlow(etor)).done(function (f) {
                if (f) { renderList(); } else { openAlert('权限未开或更新失败！'); };
            });

        };


        $scope.selectAll = function () {
            if ($("#selectAll").prop("checked") != true) {
                $(".ctltable tr td").find('input[type=checkbox]').prop("checked", false);
            } else {
                $(".ctltable tr td").find('input[type=checkbox]').prop("checked", true);
            }
        };


        $scope.createPop = function (pid) {

            var vals = getChecked();
            if (vals == '') {
                return openAlert('未选中！');
            };
            var itemId = vals.split(',')[0];

            $scope.createPageId = pid;
            $scope.itemId = itemId;
            $scope.categoryId = categoryId;


            var url = 'tmpl/create';
            var ctlor = 'subCreateController';


            var pageIds = [];
            pageIds.push(pid);
            $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                if (customPages.length>0 && customPages[0].Value == true) {
                    url = 'custom/' + cooConfig.configObj.companyId + '/create_' + pid + '';
                    ctlor = 'subCreate_' + pid + '_Controller';
                }
                ngDialog.open({
                    template: url.toString() + '.html',
                    controller: ctlor,
                    scope: $scope
                });

            });





          
          

        };


        $scope.createPop2 = function (indexId) {

            if ($scope.createpages.length > 0) {

                var pid = $scope.createpages[0].ID;

                $scope.createPageId = $scope.createpages[0].ID;
                $scope.itemId = indexId;
                $scope.categoryId = categoryId;


                var url = 'tmpl/create';
                var ctlor = 'subCreateController';



                var pageIds = [];
                pageIds.push(pid);
                $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                    if (customPages.length > 0 && customPages[0].Value == true) {
                        url = 'custom/' + cooConfig.configObj.companyId + '/create_' + pid + '';
                        ctlor = 'subCreate_' + pid + '_Controller';
                    }

                    ngDialog.open({
                        template: url.toString() + '.html',
                        controller: ctlor,
                        scope: $scope
                    });
                });
               
            }
        };










        $scope.joinPop = function (pid) {

            var vals = getChecked();
            if (vals == '') {
                return openAlert('未选中！');
            };
            var itemId = vals.split(',')[0];

            $scope.joinPageId = pid;
            $scope.itemId = itemId;
            $scope.categoryId = categoryId;



            $scope.currentRow = _.find($scope.resultData, function (n) { return n['__c' + indexPattern[0].ID] == itemId; });
     



            var url = 'tmpl/create';
            var ctlor = 'joinCreateController';




            var pageIds = [];
            pageIds.push(pid);
            $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                if (customPages.length > 0 && customPages[0].Value == true) {
                    url = 'custom/' + cooConfig.configObj.companyId + '/create_' + pid + '';
                    ctlor = 'joinCreate_' + pid + '_Controller';
                }

                ngDialog.open({
                    template: url.toString() + '.html',
                    controller: ctlor,
                    scope: $scope
                });
            });
 

        };

        $scope.joinPop2 = function (indexId) {

            if ($scope.joinpages.length > 0) {

                var pid = $scope.joinpages[0].ID;
                $scope.joinPageId = pid;
                $scope.itemId = indexId;
                $scope.categoryId = categoryId;



                var url = 'tmpl/create';
                var ctlor = 'joinCreateController';


                var pageIds = [];
                pageIds.push(pid);
                $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                    if (customPages.length > 0 && customPages[0].Value == true) {
                        url = 'custom/' + cooConfig.configObj.companyId + '/create_' + pid + '';
                        ctlor = 'joinCreate_' + pid + '_Controller';
                    }

                    ngDialog.open({
                        template: url.toString() + '.html',
                        controller: ctlor,
                        scope: $scope
                    });
                });

                 
            }

        };




        $scope.editPop2 = function (indexId) {

            if ($scope.editpages.length > 0) {
                $scope.editPageId = $scope.editpages[0].ID;
                $scope.itemId = indexId;
                $scope.categoryId = categoryId;
                var pid = $scope.editPageId;

                var url = 'tmpl/edit';
                var ctlor = 'editController';


                var pageIds = [];
                pageIds.push(pid);
                $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                    if (customPages.length > 0 && customPages[0].Value == true) {
                        url = 'custom/' + cooConfig.configObj.companyId + '/edit_' + $scope.editPageId + '';
                        ctlor = 'edit_' + $scope.editPageId + '_Controller';
                    }

                    ngDialog.open({
                        template: url.toString() + '.html',
                        controller: ctlor,
                        scope: $scope
                    });
                });



 
            }
        };



        //todo
        $scope.editPop = function (pid) {
            var vals = getChecked();
            if (vals == '') {
                return openAlert('未选中！');
            };
            var itemId = vals.split(',')[0];

            $scope.editPageId = pid;
            $scope.itemId = itemId;
            $scope.categoryId = categoryId;


            var url = 'tmpl/mobile/edit';
            var ctlor = 'mobile_editController';



            var pageIds = [];
            pageIds.push(pid);
            $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                if (customPages.length > 0 && customPages[0].Value == true) {
                    url = 'custom/' + cooConfig.configObj.companyId + '/edit_' + pid + '';
                    ctlor = 'edit_' + pid + '_Controller';
                }
                ngDialog.open({
                    template: url.toString() + '.html',
                    controller: ctlor,
                    scope: $scope
                });
            });
 

        };


        $scope.complexEdit = function (pid) {
            var vals = getChecked();
            if (vals == '') return openAlert('未选中！');
            var itemId = vals.split(',')[0];

            $scope.editPageId = pid;
            $scope.itemId = itemId;
            $scope.categoryId = categoryId;

            console.log(pid);

            var url = 'tmpl/complexedit';
            var ctlor = 'complexeditController';


            var pageIds = [];
            pageIds.push(pid);
            $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                console.log(customPages);

                if (customPages.length > 0 && customPages[0].Value == true) {
                    url = 'custom/' + cooConfig.configObj.companyId + '/complexedit_' + pid + '';
                    ctlor = 'complexedit_' + pid + '_Controller';
                }
                ngDialog.open({
                    template: url.toString() + '.html',
                    controller: ctlor,
                    scope: $scope
                });
            });         

        };




        $scope.closeDialog = function () {

            ngDialog.closeAll();
        };



        $scope.pviewPop2 = function (indexId) {

            if ($scope.viewdetailpages.length > 0) {

                var pid = $scope.viewdetailpages[0].ID;

                $scope.viewPageId = pid;
                $scope.itemId = indexId;
                $scope.categoryId = categoryId;


                var cpage = _.find(cooConfig.allpage, function (p) { return p.ID == $scope.viewdetailpages[0].ID });

                if (cpage != null && cpage.pageType == 8) {
                    ngDialog.open({
                        template: 'tmpl/view.html?pageId=' + pid,
                        controller: 'viewController',
                        scope: $scope
                    });
                }


                if (cpage != null && cpage.pageType == 101) {
                    ngDialog.open({
                        template: 'tmpl/complexview.html?pageId=' + pid,
                        controller: 'complexviewController',
                        scope: $scope
                    });
                }
            }
        };





        $scope.pviewPop = function (pid) {

            var cpage = _.find(cooConfig.allpage, function (p) { return p.ID == pid });


            var vals = getChecked();
            if (vals == '') return openAlert('未选中！');
            var itemId = vals.split(',')[0];

            $scope.viewPageId = pid;
            $scope.itemId = itemId;
            $scope.categoryId = categoryId;


            var url = 'tmpl/mobile/view';
            var ctlor = 'mobile_viewController';



            var pageIds = [];
            pageIds.push(pid);
            $.when(rest.existsSync({ pageIds: pageIds })).done(function (customPages) {

                if (cpage != null && cpage.pageType == 8) {

                    if (customPages.length > 0 && customPages[0].Value == true) {
                        url = 'custom/' + cooConfig.configObj.companyId + '/view_' + pid + '';
                        ctlor = 'view_' + pid + '_Controller';
                    }
                    ngDialog.open({
                        template: url.toString() + '.html?pageId=' + pid,
                        controller: ctlor,
                        scope: $scope
                    });
                }

                if (cpage != null && cpage.pageType == 101) {

                    ngDialog.open({
                        template: 'tmpl/complexview.html?pageId=' + pid,
                        controller: 'complexviewController',
                        scope: $scope
                    });
                }

            });



        };

        $scope.datalogPop = function () {
            var vals = getChecked();
            if (vals == '') return openAlert('未选中！');
            var itemId = vals.split(',')[0];
            $scope.categoryId = categoryId;
            $scope.itemId = itemId;


            ngDialog.open({
                template: 'tmpl/datalog.html',
                controller: 'datalogController',
                scope: $scope
            });

        };


        $scope.export = function (pid) {

            $scope.listPageId = pageId;
            $scope.exportPageId = pid;
            $scope.categoryId = categoryId;
            $scope.lsc = lsc;

            ngDialog.open({
                template: 'tmpl/export.html',
                controller: 'exportController',
                scope: $scope
            });
        };




        $scope.workflowlogPop = function () {
            var vals = getChecked();
            if (vals == '') return openAlert('未选中！');
            var itemId = vals.split(',')[0];
            $scope.categoryId = categoryId;
            $scope.itemId = itemId;

            ngDialog.open({
                template: 'tmpl/workflowlog.html',
                controller: 'workflowlogController',
                scope: $scope
            });
        };

        $scope.updateStatus = function (pid, sid) {

            var vals = getChecked();
            if (vals == '') return openAlert('未选中！');

            var ele = g.elementFilterByPage(pid);

            var etor = {
                ids: vals,
                cateId: categoryId,
                listPageId: pageId,
                pageId: pid,
                patternId: ele[0].patternId,
                statusId: sid
            };

            $.when(rest.updateStatus(etor)).done(function (f) {
                if (f) { renderList(); } else { openAlert('更新失败！'); };
            });

        };


        $scope.bulkCreate = function (pid) {

            $scope.importPageId = pid;
            $scope.categoryId = categoryId;

            ngDialog.open({
                template: 'tmpl/import.html',
                controller: 'importController',
                className: 'ngdialog-theme-plain',
                scope: $scope
            });
        };


        $scope.searchConfig = function () {
            if (!$("#mobile_searchConfig").is(":visible")) {
                $("#mobile_searchConfig").show();
            } else {
                $("#mobile_searchConfig").hide();

                $.when(userSetting.pageConfig($scope.sElements, 'os', p11[0].ID)).done(function (f) {
                    if (f) {

                        $.when(locdbServices.fetchAllUserElements()).done(function (result) {
                            cooConfig.alluserelement = result;
                            console.log('redirect');
                            $location.path('/mobile_list/' + categoryId + '/page/' + pageId + '/');
                            $scope.$apply();
                        });
                    }
                });
            }
        };

        $scope.viewConfig = function () {
            if (!$("#mobile_viewConfig").is(":visible")) {
                $("#mobile_viewConfig").show();
            } else {
                $("#mobile_viewConfig").hide();

                $.when(userSetting.pageConfig($scope.vElements, 'ov', p14[0].ID)).done(function (f) {
                    if (f) {

                        $.when(locdbServices.fetchAllUserElements()).done(function (result) {
                            cooConfig.alluserelement = result;
                            console.log('redirect');
                            $location.path('/mobile_list/' + categoryId + '/page/' + pageId + '/');
                            $scope.$apply();

                        });
                    }
                });
            }
        };


        $scope.mobileCondition = function()
        {

            if($('.mobile_search_top').is(":visible"))
            {
                $('.mobile_search_top').hide();
            }
            else
            {
                $('.mobile_search_top').show();
            }
        }



        $scope.checkClick =function($event)
        {
            var vcheck = $($event.target).is(':checked');
            if (vcheck) {
                $('.menu_lev3').addClass('shrink');
            }
            else
            {
                $('.menu_lev3').removeClass('shrink');
            }



        }






    });

});




CooWorkApp.controller('mobile_viewController', function ($scope, $location, $routeParams, $sce, _, locdbServices, userSetting, cooConfig, g, rest, ngDialog) {


    var categoryId = $scope.categoryId;
    var pageId = $scope.viewPageId;
    var itemId = $scope.itemId;
    var currentPage = g.pageFilterById(pageId)[0];
    $scope.title = currentPage.UIname + '  ';

    var pattern = g.patternFilterByIndexId(categoryId);

    $scope.elements = [];
    $scope.options = [];
    $scope.indexId = 0;
    var source = [];


    $scope.print = function () {

        var etor = { pageId: pageId, itemId: itemId };


        $.when(rest.print(etor)).done(function (a) {
            if (a != null && a != '') {
                window.open(a);
                //window.location.href = a;
                //  $scope.$apply();
                ngDialog.closeAll();
                //  window.open(a);
            }
            console.log(a);
        });
    };


    var imgReg = /\.(jpg|jpeg|png|gif|bmp)$/i;



    $.when(userSetting.getSettingElementByPage(pageId)).done(function (a) {

        $.when(rest.detail(pageId, itemId)).done(function (result) {

            // console.log(result);

            $scope.indexId = result.data['__c' + pattern[0].ID];
            //result.data ,.join,.related
            $(a).each(function (i, o) {
                source = g.makeSource(o);
                var val = result.data['__c' + o.ID];



                switch (o.pTypeId) {
                    case 2:
                    case 13:
                    case 20:
                        if (val != undefined) {
                            var vv = ',' + val.toString() + ',';
                            var source = _.filter(cooConfig.allstatus, function (item) {
                                return vv.indexOf(item.ID.toString()) != -1 && item.patternId == o.ID;
                            });
                            val = _.pluck(source, 'statusName').join(',');
                        }

                        break;
                    case 19:
                        if (val != undefined) {
                            source = g.userFilterByUserIds(val);
                            val = source;
                        }
                        break;
                    case 6:
                        val = g.dateFormat(val);
                        break;
                    case 7:
                        val = $sce.trustAsHtml(val);


                        break;
                    case 11:
                        if (val != undefined && val.FilePath != undefined) val.FilePath = val.FilePath.replace('/100', '');
                        break;
                    case 10:
                        $(val).each(function (p, k) {
                            k.RawFilePath = k.FilePath.replace('/100', '');
                            if (imgReg.test(k.FilePath)) {
                                k.isImg = true;
                            }
                            else {
                                k.isImg = false;
                            }
                        });
                        break;
                    default:
                        break;
                }

                $scope.elements.push({ p: o, v: val, s: source });
            });

            $scope.$apply();
        });
    });

});





CooWorkApp.controller('mobile_createController', function ($rootScope, $scope, $location, $routeParams, $timeout, $sce, locdbServices, userSetting, cooConfig, g, rest, ngDialog, $upload, _) {

    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };


    window.ondragover = function (e) { e.preventDefault(); return false };
    window.ondrop = function (e) { e.preventDefault(); return false };


    var categoryId = $routeParams.categoryId;
    $scope.categoryId = categoryId;
    var pageId = $routeParams.pageId;
    var currentPage = g.pageFilterById(pageId)[0];
    $rootScope.title = currentPage.UIname + ' - 创建';


    var pattern = g.patternFilterByIndexId(categoryId);

    $scope.elements = [];
    $scope.options = [];
    $scope.indexId = 0;
    var source = [];
    var prefix = '.createTable ';

    $scope.createConfigElements = [];
    var ocElements = g.patternFilterByPage(pageId);



    $scope.upload = function (files, p) {
        g.uploadFiles(files, p, categoryId, 0);
    };

    $scope.optionChange = function (element, v) {

        g.optionChange(element, v, '');
        $scope.$$phase || $scope.$apply();
    };


    $scope.clearCreateConfig = function () {
        $('.occ').prop('checked', false);
    };


    $scope.$on('$viewContentLoaded', function (event) {
        $timeout(function () {

            var evt = _.filter(cooConfig.allevent, function (n) { return n.pageId == pageId });
            if (evt.length > 0) {
                console.log(evt);
                //  var eSource = "$(document.body).on('click', 'input' ,function(){ $(this).val('123');  });   $('#__c15515').val('222');   ";
                g.dfnScript(evt[0].eventSource);
            }


        }, 0);
    });


    $.when(userSetting.getSettingElementByPage(pageId)).done(function (a) {


        //config
        var eleStr = ',';
        $(a).each(function (i, item) {
            eleStr += item.ID + ',';
        });

        $(ocElements).each(function (i, o) {
            if (eleStr.indexOf(',' + o.ID.toString() + ',') > -1) {
                $scope.createConfigElements.push({ item: o, select: true });
            }
            else {
                $scope.createConfigElements.push({ item: o, select: false });
            }
        });
        //config

        //result.data ,.join,.related
        $(a).each(function (i, o) {
            source = g.makeSource(o);
            var vv = '';
            switch (o.pTypeId) {
                case 2:
                case 13:
                case 20:
                    vv = '0';
                    break;
                case 12:
                case 19:
                    vv = '00000000-0000-0000-0000-000000000000';
                    break;

                default: break;
            }


            $scope.elements.push({ p: o, s: source, v: vv });
        });


        $scope.$$phase || $scope.$apply();
        g.jqueryInit(prefix, $scope.indexId);

        $scope.createConfig = function () {
            if (!$("#createConfig").is(":visible")) {
                $("#createConfig").show();
            } else {
                $("#createConfig").hide();

                $.when(userSetting.pageConfig(a, 'oc', pageId)).done(function (f) {
                    if (f) {

                        $.when(locdbServices.fetchAllUserElements()).done(function (result) {
                            cooConfig.alluserelement = result;
                            console.log('redirect');
                            $location.path('/create/' + categoryId + '/page/' + pageId + '/');
                            $scope.$apply();
                        });
                    }
                });
            }
        };

    });

    $scope.checkValid = function (p) {
        g.checkValid('', p, $scope.indexId);
        //openAlert(v);
    };

    $scope.fileSelect = function ($id) {
        $('#file_' + $id).trigger('click');
    };

    $scope.openSelect = function (element) {

        $scope.element = element;
        $scope.preConditions = [];

        if (typeof udf_preConditions != 'undefined') {
            $scope.preConditions = udf_preConditions(element);
        }



        var dlg1 = ngDialog.open({
            template: 'tmpl/select.html',
            controller: 'selectController',
            scope: $scope
        });

        $scope.currentDlg = dlg1.id;

    };


    $scope.rowSelect = function (index, name, row) {

        $('#view__j' + $scope.element.ID).val(name).trigger('change');
        $('#__j' + $scope.element.ID).val(index).trigger('change');
        $('#__j' + $scope.element.ID).attr('v', 'e');

        $('#__c' + $scope.element.ID).val(index).trigger('change');
        $('#__c' + $scope.element.ID).attr('v', 'e');



        if (typeof udf_rowSelect != 'undefined') {
            udf_rowSelect($scope.element, row);
        }




        ngDialog.close($scope.currentDlg);
    };




    $scope.doSubmit = function () {

        var check = true;
        var reqCheck = true;
        var uniCheck = true;
        var msg = '';
        $(".createTable [tag='edit']").each(function (i) {

            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '') {
                var regStr = $(this).attr("vad");
                if (regStr.indexOf('%') > -1) regStr = decodeURIComponent(regStr);
                if (regStr.indexOf('%') > -1) regStr = decodeURIComponent(regStr);

                var regx = new RegExp(regStr);
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    check = false;
                    msg = $(this).parent('div').find('span').text() + " 格式不对";
                    //   openAlert($(this).parent('div').find('span').text() + " 格式不对");                
                    return false;
                }
            }
        });


        $(".createTable [req='true']").each(function () {
            if ($(this).val() == '') {
                reqCheck = false;
                msg = "必填项未填!" + $(this).parent('div').find('span').text();
                //   openAlert();
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });




        $(".createTable [unq='true']").each(function (i) {

            if ($(this).val() != '') {
                var cid = $scope.indexId;

                var etor = {
                    val: $(this).val(),
                    name: $(this).attr('id'),
                    itemId: cid
                };

                $.when(rest.uniqueCheck(etor)).done(function (data) {
                    var rd = /\d/ig;
                    if (data != '' && rd.test(data)) {
                        $('.createTable #' + etor.name).addClass("fieldInvalid");
                        uniCheck = false;
                        msg = "已存在," + data;
                        //openAlert("已存在," + data);


                    }
                });
            }

        });






        if (check && reqCheck && uniCheck) {
            var RetArray = [];
            $(".createTable [v='e']").each(function (i) {

                var tempV = $.trim($(this).val());
                if ($(this).is("div"))
                    tempV = $.trim($(this).html());

                if ($(this).is(':checkbox'))
                    tempV = $(this).is(":checked");

                var o = { _Key: $(this).attr('id'), _Value: tempV };
                RetArray.push(o);
            });

            $(".createTable .jqtxt").each(function (i) {
                var tempj = $.trim($(this).val());

                var o = { _Key: $(this).attr('id'), _Value: tempj };

                RetArray.push(o);

            });

            $(".createTable [multiple='multiple']").each(function (i) {
                var tempV = $("#" + $(this).attr("id")).val();

                if (tempV != undefined && tempV.length > 0) {
                    var tempStr = tempV.join(',');
                    var o = { _Key: $(this).attr('id'), _Value: tempStr };
                    RetArray.push(o);
                }
            });



            var RArray = [];
            $(".createTable .childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (i, tr) {
                    var erow = [];
                    $(tr).find("input[tag='redit']").each(function (i) {
                        var o = { _Key: $(this).attr('name'), _Value: $.trim($(this).val()) };
                        erow.push(o);
                    });
                    if (erow.length > 0) {
                        RArray.push({
                            key: $(t).attr("id"),
                            value: erow
                        });
                    }
                });
            });

            var d1 = JSON.stringify(RetArray);
            var d2 = JSON.stringify(RArray);


            var iid = $scope.indexId;

            var etor = {
                jsonStr: d1,
                relatedSTR: d2,
                pageId: pageId,
                itemId: iid
            };



            $.when(rest.create(etor)).done(function (data) {

                openAlert("ok!");

                g.resetUserInput(prefix);
                $scope.$apply();
            });

        }
        else {
            openAlert(msg);
        }

    };




});




CooWorkApp.controller('mobile_editController', function ($scope, $location, $routeParams, $sce, $timeout, locdbServices, userSetting, cooConfig, g, rest, ngDialog, $upload) {

    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };


    window.ondragover = function (e) { e.preventDefault(); return false };
    window.ondrop = function (e) { e.preventDefault(); return false };

    var categoryId = $scope.categoryId;
    $scope.categoryId = categoryId;
    var pageId = $scope.editPageId;
    var currentPage = g.pageFilterById(pageId)[0];
    $scope.title = currentPage.UIname + ' - 编辑';


    var itemId = $scope.itemId;
    var pattern = g.patternFilterByIndexId(categoryId);

    $scope.elements = [];
    $scope.options = [];
    $scope.indexId = 0;
    var source = [];
    var prefix = '.createTable ';

    $scope.editConfigElements = [];
    var oeElements = g.patternFilterByPage(pageId);

    $scope.upload = function (files, p) {
        g.uploadFiles(files, p, categoryId, itemId);
    };

    $scope.optionChange = function (element, v) {
        g.optionChange(element, v, '.createTable ');
        $scope.$$phase || $scope.$apply();
    };

    $scope.clearCreateConfig = function () {
        $('.oec').prop('checked', false);
    };



    $timeout(function () {

        var evt = _.filter(cooConfig.allevent, function (n) { return n.pageId == pageId });
        if (evt.length > 0) {
            console.log(evt);
            //  var eSource = "$(document.body).on('click', 'input' ,function(){ $(this).val('123');  });   $('#__c15515').val('222');   ";
            g.dfnScript(evt[0].eventSource);
        }


    }, 0);






    $.when(userSetting.getSettingElementByPage(pageId)).done(function (a) {
        //config
        var eleStr = ',';
        $(a).each(function (i, item) {
            eleStr += item.ID + ',';
        });

        $(oeElements).each(function (i, o) {
            if (eleStr.indexOf(',' + o.ID.toString() + ',') > -1) {
                $scope.editConfigElements.push({ item: o, select: true });
            }
            else {
                $scope.editConfigElements.push({ item: o, select: false });
            }
        });
        //config


        $.when(rest.detail(pageId, itemId)).done(function (result) {
            console.log(result);
            $scope.indexId = result.data['__c' + pattern[0].ID];
            var iid = result.data['__c' + pattern[0].ID];
            //result.data ,.join,.related
            $(a).each(function (i, o) {
                source = g.makeSource2(o, result.data);
                var vv = result.data['__c' + o.ID];




                switch (o.pTypeId) {
                    case 10:
                        var imgReg = /\.(bmp|jpg|jpeg|png|gif)"?$/i;
                        $(vv).each(function (j, k) {
                            k['isImage'] = imgReg.test(k.Filename);
                        });
                        break;
                    case 6:
                        vv = g.dateFormat(vv);
                        break;
                    case 12:
                    case 19:
                        if (vv == undefined || vv == '') vv = '00000000-0000-0000-0000-000000000000';
                        break;
                    case 2:
                    case 13:
                    case 20:
                        if (vv == undefined || vv == '') vv = '0';
                        break;
                    default: break;
                }






                $scope.elements.push({ p: o, v: vv, s: source });
            });

            $scope.editable = result.editable;

            $scope.$apply();
            g.jqueryInit(prefix, iid);
            if (!result.editable) {
                g.disable(prefix);
            }
        });



        $scope.fileSelect = function ($id) {
            $('#file_' + $id).trigger('click');

        };



        $scope.checkValid = function (p) {
            g.checkValid(prefix, p, $scope.indexId);
        };




        $scope.openSelect = function (element) {
            $scope.element = element;
            $scope.preConditions = [];

            if (typeof udf_preConditions != 'undefined') {
                $scope.preConditions = udf_preConditions(element);
            }


            var dlg1 = ngDialog.open({
                template: 'tmpl/select.html',
                controller: 'selectController',
                scope: $scope
            });

            $scope.currentDlg = dlg1.id;
        };


        $scope.rowSelect = function (index, name, row) {
            $(prefix + '#view__j' + $scope.element.ID).val(name);
            $(prefix + '#__j' + $scope.element.ID).val(index);
            $(prefix + '#__j' + $scope.element.ID).attr('v', 'e');
            $(prefix + '#__c' + $scope.element.ID).val(index);
            $(prefix + '#__c' + $scope.element.ID).attr('v', 'e');

            if (typeof udf_rowSelect != 'undefined') {
                udf_rowSelect($scope.element, row);
            }


            ngDialog.close($scope.currentDlg);
        };





        $scope.doSubmit = function () {

            var check = true;
            var authCheck = true;
            var parentCheck = true;
            var reqCheck = true;
            var uniCheck = true;
            $(".createTable [tag='edit']").each(function (i) {

                if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '') {


                    var regStr = $(this).attr("vad");
                    if (regStr.indexOf('%') > -1) regStr = decodeURIComponent(regStr);
                    if (regStr.indexOf('%') > -1) regStr = decodeURIComponent(regStr);


                    var regx = new RegExp(regStr);
                    if (!regx.test($.trim($(this).val()))) {
                        $(this).addClass("fieldInvalid");
                        openAlert($(this).parent('div').find('span').text() + " 格式不对");
                        check = false;
                        return false;
                    }
                }
            });


            $(".createTable [req='true']").each(function () {
                if ($(this).val() == '') {
                    reqCheck = false;
                    openAlert("必填项未填!" + $(this).parent('div').find('span').text());
                    //    window.external.MessageBox("必填项未填!");
                    return false;
                }
            });




            $(".createTable [unq='true']").each(function (i) {

                if ($(this).val() != '') {
                    var cid = $scope.indexId;

                    var etor = {
                        val: $(this).val(),
                        name: $(this).attr('id'),
                        itemId: cid
                    };

                    $.when(rest.uniqueCheck(etor)).done(function (data) {
                        var rtxt = /\d+/ig;
                        if (rtxt.test(data)) {
                            $('.createTable #' + etor.name).addClass("fieldInvalid");
                            openAlert("已存在," + data);
                            uniCheck = false;
                            return false;
                        }
                    });
                }
            });




            if (check && reqCheck && uniCheck) {
                var RetArray = [];
                $(".createTable [v='e']").each(function (i) {



                    var tempV = $.trim($(this).val());
                    if ($(this).is("div"))
                        tempV = $.trim($(this).html());

                    if ($(this).is(':checkbox'))
                        tempV = $(this).is(":checked");



                    if ($(this).attr('multiple') == undefined) {
                        var o = { _Key: $(this).attr('id'), _Value: tempV };
                        RetArray.push(o);
                    }
                });

                $(".createTable .jqtxt").each(function (i) {
                    var tempj = $.trim($(this).val());

                    var o = { _Key: $(this).attr('id'), _Value: tempj };

                    RetArray.push(o);

                });

                $(".createTable [multiple='multiple'][v='e']").each(function (i) {
                    var tempV = $(".createTable #" + $(this).attr("id")).val();



                    if (tempV != undefined && tempV.length > 0) {
                        var tempStr = tempV.join(',');
                        var o = { _Key: $(this).attr('id'), _Value: tempStr };
                        RetArray.push(o);
                    }
                });



                var RArray = [];
                $(".createTable .childTable").each(function (i, t) {
                    $rows = $(t).find("tr");
                    $rows.each(function (i, tr) {
                        var erow = [];
                        $(tr).find("input[tag='redit']").each(function (i) {
                            var o = { _Key: $(this).attr('name'), _Value: $.trim($(this).val()) };
                            erow.push(o);
                        });
                        if (erow.length > 0) {
                            RArray.push({
                                key: $(t).attr("id"),
                                value: erow
                            });
                        }
                    });
                });

                var d1 = JSON.stringify(RetArray);
                var d2 = JSON.stringify(RArray);


                var iid = $scope.indexId;

                var etor = {
                    jsonStr: d1,
                    relatedSTR: d2,
                    pageId: pageId,
                    itemId: iid
                };


                console.log(etor);



                $.when(rest.edit(etor)).done(function (data) {

                    g.resetUserInput(prefix);
                    $scope.pageNumber($scope.startIndex);
                    $scope.closeDialog();
                    $scope.$apply();
                });

            }

        };




        $scope.editConfig = function () {
            if (!$("#editConfig").is(":visible")) {
                $("#editConfig").show();
            } else {
                $("#editConfig").hide();

                $.when(userSetting.pageConfig(a, 'oe', pageId)).done(function (f) {
                    if (f) {

                        $.when(locdbServices.fetchAllUserElements()).done(function (result) {
                            cooConfig.alluserelement = result;
                            $scope.closeDialog();
                            $scope.$apply();
                        });
                    }
                });
            }
        };

    });
});
