﻿CooWorkApp.controller('reportController', function ($rootScope, $scope, $location, $routeParams, $sce, locdbServices, userSetting, cooConfig, g, rest) {


    $scope.jqplotType="bar2";

    g.menu3($rootScope.fullMenu);

    var reportPageId = $routeParams.pageId;
    var pageId =reportPageId;

    var currentPage = g.pageFilterById(reportPageId)[0];
    $rootScope.title = currentPage.UIname + ' - 报表分析';

    var categoryId = $routeParams.categoryId;
    var p17 = g.pageFilter(17, reportPageId);
    var p18 = g.pageFilter(18, reportPageId);
    var lsc = [];
    $scope.rElements = [];
    $scope.vElements = [];
    $scope.vData = [];
    $scope.pageId = p18[0].ID;

    var nv =_.find($rootScope.breadcrumb,function(n){ return n.url=='#/report/'+categoryId +'/page/'+pageId });
    if (nv)
    {
      $($rootScope.breadcrumb).each(function(i,j){
           j.active = j.url==nv.url?true:false;
      });
    }
    else {
      $($rootScope.breadcrumb).each(function(i,j){
        j.active =false;
      });
      $rootScope.breadcrumb.push({name:currentPage.UIname,url:'#/report/'+categoryId +'/page/'+pageId,active:true});
    }

    $scope.searchConfigElements = [];
    var osElements = g.patternFilterByPage(p17[0].ID);

    var getIntv = function() {
        var dateType = '0';
        var r = new RegExp(/_(\d+)/ig);
        var matches =  r.exec(JSON.stringify(lsc));
        if (matches && matches.length>1)
         {
           dateType = matches[1];
         }
         else {
            return "";
         }
        var intv ="1 year";
        switch (dateType) {
          case "5":
               intv = "1 day";
              break;
          case "1":
                intv ="1 year";
              break;
          case "2":
                intv = "3 month";
              break;
          case "3":
                intv = "1 month";
              break;
          case "4":
                intv = "7 day";
              break;
          default:
              break;
          }
          return intv;
    };



    $scope.clearSearchConfig = function () {
        $('.osc').prop('checked', false);
    };



    $scope.shortCut =function()
    {
        var name = $('#shortCutName').val();

      if (name&&name!='')
       {

         var o ={};
         o.ID = pageId;
         o.lscStr = JSON.stringify(lsc);
         o.lsc = [];
         o.name = name;
         o.jqplotType = $('#jqplotType').val();
         o.UTC = Date.now();
         o.intv = getIntv();
         locdbServices.addShortCut(o);
         $('#shortCutName').val('');

       }
         $('.shortCutDiv').hide();
    };


    var threeD = function (queryString, result) {


        var rfilter = function (list, v1, v2) {
            return list.filter(function (v) {
                return v.v1 == v1 && v.v2 == v2;
            });

        };

        var rfilter23 = function (list, v2, v3) {
            return list.filter(function (v) {
                return v.v2 == v2 && v.v3 == v3;
            });
        }



        var qobj = g.parseUrl(queryString);
        var icount = qobj._sys_thtitle.match(/th>/ig).length;
        var caculateCount = (qobj._sys_calculate == undefined || qobj._sys_calculate == "") ? 0 : qobj._sys_calculate.split(',').length;
        var groupCount = (qobj._sys_group == "" || qobj._sys_group == undefined) ? 0 : qobj._sys_group.split(',').length;


        var ticks = [];
        var s3data = [];
        var slabel = [];

        // console.log(icount + caculateCount);

        if (icount == 6 && caculateCount == 0) {

            var flags = [], flagsv1 = [], output = [], l = result.length, i;

            for (i = 0; i < l; i++) {

                if (!flagsv1[result[i].v1]) {
                    ticks.push(result[i].v1);
                    flagsv1[result[i].v1] = true;
                }
                if (!flags[result[i].v2]) {
                    flags[result[i].v2] = true;
                    output.push(result[i].v2);
                }
            }

            ticks.sort(function (a, b) {
                if (a < b) return -1;
                if (a > b) return 1;
                return 0;
            });


            $(output).each(function (i, a) {

                var subData = [];
                $(ticks).each(function (j, b) {

                    var rec = rfilter(result, b, a);
                    if (rec.length > 0) {
                        subData.push(rec[0].v0);
                    }
                    else {
                        subData.push(0);
                    }
                });
                s3data.push(subData);
            });

            $(output).each(function (i, item) {

                var o = { label: item };
                slabel.push(o);
            });

        }
        else if (icount == 8 && caculateCount == 1) {
            var flags = [], flagsv1 = [], output = [], l = result.length, i;

            for (i = 0; i < l; i++) {

                if (!flagsv1[result[i].v2]) {
                    ticks.push(result[i].v2);
                    flagsv1[result[i].v2] = true;
                }
                if (!flags[result[i].v3]) {
                    flags[result[i].v3] = true;
                    output.push(result[i].v3);
                }
            }

            ticks.sort(function (a, b) {
                if (a < b) return -1;
                if (a > b) return 1;
                return 0;
            });



            $(output).each(function (i, a) {

                var subData = [];
                $(ticks).each(function (j, b) {

                    var rec = rfilter23(result, b, a);
                    if (rec.length > 0) {
                        subData.push(rec[0].v1);
                    }
                    else {
                        subData.push(0);
                    }
                });
                s3data.push(subData);
            });


            $(output).each(function (i, item) {

                var o = { label: item };
                slabel.push(o);
            });

        }

        var plot1 = $.jqplot('chart1', s3data, {
            // The "seriesDefaults" option is an options object that will
            // be applied to all series in the chart.
            seriesDefaults: {
                renderer: $.jqplot.BarRenderer,
                rendererOptions: { fillToZero: true },
                pointLabels: { show: true, location: 'e', edgeTolerance: -15 },
            },
            // Custom labels for the series are specified with the "label"
            // option on the series option.  Here a series option object
            // is specified for each series.
            series: slabel,
            // Show the legend and put it outside the grid, but inside the
            // plot container, shrinking the grid to accomodate the legend.
            // A value of "outside" would not shrink the grid and allow
            // the legend to overflow the container.
            legend: {
                show: true,
                placement: 'outsideGrid'
            },
            axes: {
                // Use a category axis on the x axis and use our custom ticks.
                xaxis: {
                    renderer: $.jqplot.CategoryAxisRenderer,
                    ticks: ticks
                },
                // Pad the y axis just a little so bars can get close to, but
                // not touch, the grid boundaries.  1.2 is the default padding.
                yaxis: {
                    pad: 1.05,
                    tickOptions: { formatString: '$%d' }
                }
            }
        });
    };
    //jqplot








    $.when(userSetting.getSettingElementByPage(p17[0].ID)).done(function (a) {

        $scope.rElements = a;
        $.each($scope.rElements, function (index, item) {
            if (item.validator != undefined)
                item.validator = encodeURIComponent(item.validator);
        });


        //config
        var eleStr = ',';
        $($scope.rElements).each(function (i, item) {
            eleStr += item.ID + ',';
        });



        $(osElements).each(function (j, obj) {
            if (eleStr.indexOf(',' + obj.ID.toString() + ',') > -1) {
                $scope.searchConfigElements.push({ item: obj, select: true });
            }
            else {
                $scope.searchConfigElements.push({ item: obj, select: false });
            }
        });
        //config;



        $scope.$$phase || $scope.$apply();


        $scope.searchClear = function () {
            window.location.href = window.location.href + '/';

        };



        $scope.dosearch = function () {
            $scope.vData = [];
            lsc = [];
            $("[tag='edit']").each(function (i, tb) {
                var val = $.trim($(this).val());
                if ($(this).is(':checkbox'))
                    val = $(this).is(":checked");


                if (val) {
                    var sc = {
                        _Key: $(this).attr("id"),
                        _Value: val
                    };
                    lsc.push(sc);
                }
            });

            var etor =
                {
                    companyId: cooConfig.configObj.companyId,
                    cateId: categoryId,
                    pageId: reportPageId,
                    lscStr: JSON.stringify(lsc)
                };




            $.when(rest.report(etor)).done(function (result) {

        //      console.log(result);
              var  reportData = JSON.parse(result.data);
              console.log(reportData);


                var rdate = /\d+-\d+(T|\s)\d+/i;

                $(result.data).each(function (i, o) {
                    if (rdate.test(o.v0)) o.v0 = g.dateFormat(o.v0,{});
                    if (rdate.test(o.v1)) o.v1 = g.dateFormat(o.v1,{});
                    if (rdate.test(o.v2)) o.v2 = g.dateFormat(o.v2,{});
                    if (rdate.test(o.v3)) o.v3 = g.dateFormat(o.v3,{});
                    if (rdate.test(o.v4)) o.v4 = g.dateFormat(o.v4,{});

                });


                $scope.vData = result.data;


                var qs = result.queryString.toString();
                var paging = qs;
                qs = qs.replace(/.+=/ig, '');
                qs = qs.replace(/<\/th><th>/ig, ',').replace(/<\/?th>/ig, '');
                //      $scope.vElements = [];
                $scope.vElements = qs.split(',');

                var len = $scope.vElements.length;


                for (var k = 0; k < 5 - len ; k++) {
                    $scope.vElements.push('[' + k + ']');
                }

                //   console.log($scope.vElements);


                $("#chart1").html("");
                $("#chart1").attr('style', '');
                $("#chart2").html("");
                $("#chart2").attr('style', '');

                var qobj = g.parseUrl(paging);


                if (qobj._sys_thtitle == undefined) return;
                var icount = qobj._sys_thtitle.match(/th>/ig).length;
                var caculateCount = (qobj._sys_calculate == undefined || qobj._sys_calculate == "") ? 0 : qobj._sys_calculate.split(',').length;


                 switch($scope.jqplotType)
                 {
                    case 'pie1':
                        g.twoD("chart1",paging, result.data);
                       break;
                    case 'dateLineM':
                       var iv =getIntv();
                        g.chart_fillDateLineM("chart1",paging, result.data,iv,false,'label');
                       break;
                    case 'dateLine2':
                        var iv =getIntv();
                        g.chart_fillDateLine2("chart1",paging, result.data,iv,false,'label');
                       break;
                    case 'fillDateLine2':
                        var iv =getIntv();
                        g.chart_fillDateLine2("chart1",paging, result.data,iv,true,'label');
                        break;
                    case 'bar2':
                        g.chart_bar('chart1',paging,result.data,'bar2');
                        break;
                    case 'bar3':
                        console.log('bar3');
                        g.chart_bar('chart1',paging,result.data,'bar3');
                        break;
                    default:
                        $("#chart1").hide();
                        $("#chart2").hide();
                    break;
                 }



                // if (icount == 4 || (icount == 6 && caculateCount == 1)) {
                //
                //     console.log("2d");
                //
                //     g.twoD("chart1",paging, result.data);
                // }
                // else if (icount == 8 || (icount == 6 && caculateCount == 0)) {
                //
                //     threeD(paging, result.data);
                // }
                // else {
                //     $("#chart1").hide();
                //     $("#chart2").hide();
                // }

                $scope.$apply();
            });

        };



        $scope.searchConfig = function () {
            if (!$("#searchConfig").is(":visible")) {
                $("#searchConfig").show();
            } else {
                $("#searchConfig").hide();

                $.when(userSetting.pageConfig($scope.rElements, 'os', p17[0].ID)).done(function (f) {
                    if (f) {

                        $.when(locdbServices.fetchAllUserElements()).done(function (result) {
                            cooConfig.alluserelement = result;
                            console.log('redirect');
                            $location.path('/report/' + categoryId + '/page/' + reportPageId + '/');
                            $scope.$apply();
                        });
                    }
                });
            }
        };

    });
});


CooWorkApp.controller('biController', function ($rootScope,$timeout, $scope, $location, $routeParams, $sce, locdbServices, userSetting, cooConfig, g, rest ) {

  $('#ajax').hide();

     g.menu3($rootScope.fullMenu);


      var reportPageId = $routeParams.pageId;
      var pageId =reportPageId;

      var currentPage = g.pageFilterById(reportPageId)[0];
      $rootScope.title = currentPage.UIname + ' - 报表分析';

      var categoryId = $routeParams.categoryId;
      var p17 = g.pageFilter(17, reportPageId);
      var p18 = g.pageFilter(18, reportPageId);
      var lsc = [];
      $scope.rElements = [];
      $scope.vElements = [];
      $scope.vData = [];
      $scope.pageId = p18[0].ID;

      var nv =_.find($rootScope.breadcrumb,function(n){ return n.url=='#/bi/'+categoryId +'/page/'+pageId });
      if (nv)
      {
        $($rootScope.breadcrumb).each(function(i,j){
             j.active = j.url==nv.url?true:false;
        });
      }
      else {
        $($rootScope.breadcrumb).each(function(i,j){
          j.active =false;
        });
        $rootScope.breadcrumb.push({name:currentPage.UIname,url:'#/bi/'+categoryId +'/page/'+pageId,active:true});
      }

      $scope.searchConfigElements = [];
      var osElements = g.patternFilterByPage(p17[0].ID);

      $scope.clearSearchConfig = function () {
          $('.osc').prop('checked', false);
      };

      $scope.searchClear = function () {
          window.location.href = window.location.href + '/';

      };


      $scope.searchConfig = function () {
          if (!$("#searchConfig").is(":visible")) {
              $("#searchConfig").show();
          } else {
              $("#searchConfig").hide();

              $.when(userSetting.pageConfig($scope.rElements, 'os', p17[0].ID)).done(function (f) {
                  if (f) {

                      $.when(locdbServices.fetchAllUserElements()).done(function (result) {
                          cooConfig.alluserelement = result;
                          console.log('redirect');
                          $location.path('/report/' + categoryId + '/page/' + reportPageId + '/');
                          $scope.$apply();
                      });
                  }
              });
          }
      };


      $scope.$on('$viewContentLoaded', function (event) {
          $timeout(function () {

              var evt = _.filter(cooConfig.allevent, function (n) { return n.pageId == pageId });
              if (evt.length > 0) {
                   console.log(evt);
                   g.dfnScript(evt[0].eventSource);
              }


          }, 0);
      });


      $.when(userSetting.getSettingElementByPage(p17[0].ID)).done(function (a) {

          $scope.rElements = [];
          $(a).each(function (i, o) {
              if (o.pTypeId != 10 && o.pTypeId != 11) {
                  o.sName = g.nameL(o.pName,6);
                  $scope.rElements.push(o);
              }
          });


          $.each($scope.rElements, function (index, item) {
              if (item.validator != undefined)
                  item.validator = encodeURIComponent(item.validator);
          });


           //search condition
           var autoW =parseInt(screen.width/300);
           //create two row table with 6elements
            if ($scope.rElements.length<autoW*2)
            {
              for(var i=0;i<autoW*2-$scope.rElements.length;i++)
              {
                $scope.rElements.push({});
              }
            }


           $scope.rElementsTable=[];
           var row1 = [];

           for(var z=0;z<autoW;z++)
           {
               row1.push($scope.rElements[z]);
           }
           row1.push({pTypeId:-1});

            var row2 = [];
            for(var z=autoW;z<autoW*2;z++)
            {
                row2.push($scope.rElements[z]);
            }
            row2.push({pTypeId:-2});
            $scope.rElementsTable.push(row1);
            $scope.rElementsTable.push(row2);
         //search condition




          //config
          var eleStr = ',';
          $($scope.rElements).each(function (i, item) {
              eleStr += item.ID + ',';
          });



          $(osElements).each(function (j, obj) {
              if (eleStr.indexOf(',' + obj.ID.toString() + ',') > -1) {
                  $scope.searchConfigElements.push({ item: obj, select: true });
              }
              else {
                  $scope.searchConfigElements.push({ item: obj, select: false });
              }
          });
          //config;



          $scope.$$phase || $scope.$apply();
        });
                    　

});
