angular
.module('lvl.services',[])
.factory('uuid', function() {
    var svc = {
        new: function() {
            function _p8(s) {
                var p = (Math.random().toString(16)+"000000000").substr(2,8);
                return s ? "-" + p.substr(0,4) + "-" + p.substr(4,4) : p ;
            }
            return _p8() + _p8(true) + _p8(true) + _p8();
        },

        empty: function() {
          return '00000000-0000-0000-0000-000000000000';
        }
    };

    return svc;
});

CooWorkApp.directive('datepick', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element

        element.datePicker({ startDate: '1996-01-01' });
        element.addClass('text_88');
    }
}]);


CooWorkApp.directive('lvlDraggable', ['$rootScope','cooConfig', 'g','uuid', function ($rootScope,cooConfig, g,uuid) {
    return       {
            restrict: 'A',
            link: function(scope, el, attrs, controller) {
                angular.element(el).attr("draggable", "true");

                var id = angular.element(el).attr("id");
                if (!id) {
                   id = uuid.new();
                   angular.element(el).attr("id", id);
               }

                console.log(id);


                el.bind("dragstart", function(e) {
                    e.dataTransfer.setData('text', id);
                    $rootScope.start_x= e.originalEvent.screenX;
                    $rootScope.$emit("LVL-DRAG-START");
                });

                el.bind("dragend", function(e) {

                    var distance = e.originalEvent.screenX -$rootScope.start_x;
                    var col_id ='col_' + $(el).attr('tag');
                    var w1 =$('.'+col_id).css('width');
                    var wi = parseInt(w1.replace(/\D/ig,''));
                    var wend = wi +distance;
                    if (wend<=50) wend=50;
                    var wend_str = wend.toString() + 'px';
                    $('.'+col_id).css('width',wend_str).css('max-width',wend_str);

                    $rootScope.$emit("LVL-DRAG-END");
                });
            }
        }

}]);



CooWorkApp.directive('lvlDropTarget', ['$rootScope','cooConfig', 'g','uuid', function ($rootScope,cooConfig, g,uuid) {
    return       {
            restrict: 'A',
            scope: {
                 onDrop: '&'
             },
            link: function(scope, el, attrs, controller) {

              var id = angular.element(el).attr("id");
              if (!id) {
                 id = uuid.new();
                 angular.element(el).attr("id", id);
             }

                el.bind("dragover", function(e) {
                    if (e.preventDefault) {
                      e.preventDefault(); // Necessary. Allows us to drop.
                  }

                  if(e.stopPropagation) {
                    e.stopPropagation();
                  }

                  e.dataTransfer.dropEffect = 'move';
                  return false;
                });

                el.bind("dragenter", function(e) {
                  angular.element(e.target).addClass('lvl-over');
                });

                el.bind("dragleave", function(e) {
                  angular.element(e.target).removeClass('lvl-over');  // this / e.target is previous target element.
                });

                el.bind("drop", function(e) {
                  if (e.preventDefault) {
                    e.preventDefault(); // Necessary. Allows us to drop.
                  }

                  if (e.stopPropogation) {
                    e.stopPropogation(); // Necessary. Allows us to drop.
                  }

                  var data = e.dataTransfer.getData("text");
                  var dest = document.getElementById(id);
                  var src = document.getElementById(data);








                  // scope.onDrop({dragEl: src, dropEl: dest});
                  // return true;
                  });

                  $rootScope.$on("LVL-DRAG-START", function(e) {
                    var el = document.getElementById(id);

                    angular.element(el).addClass("lvl-target");
                  });

                  $rootScope.$on("LVL-DRAG-END", function( ) {
                    var el = document.getElementById(id);



                    angular.element(el).removeClass("lvl-target");
                    angular.element(el).removeClass("lvl-over");
                  });




            }
        }

}]);






CooWorkApp.directive('ngRightClick', function($parse) {
    return function(scope, element, attrs) {
        var fn = $parse(attrs.ngRightClick);
        element.bind('contextmenu', function(event) {
            scope.$apply(function() {
                event.preventDefault();
                fn(scope, {$event:event});
            });
        });
    };
});



  CooWorkApp.directive('myHint', [ '$compile','cooConfig' , 'g' , 'rest', function ($compile,cooConfig, g,rest) {
    return function (scope, element, attrs    ) {
        element.bind("keyup", function (event) {

          var v = $(element).val();


          var pid = $(element).attr("name").replace(/\D/ig,'');




          var elex = _.find(cooConfig.allpattern,function(n){ return n.ID.toString()==pid  });

          var baseId = $(element).attr("baseId");
          var sub =$(element).attr("sub");
          var indexId = _.find(cooConfig.allpattern,function(n){ return n.categoryId==elex.categoryId && n.pTypeId==16});

          var lsc=[];
          var sc= {patternId: elex.ID, val1: v, pTypeId: 5, operation: 6};
          var pg = _.find(cooConfig.allpage,function(n){return n.categoryId== elex.categoryId && n.pageType==10 });


        //  lsc.push(sc);
          if (pg)
          {
            var pps = _.find(cooConfig.allpage,function(n){ return n.parentId==pg.ID &&n.pageType==11 });
            var pps_elements = g.patternFilterByPage(pps.ID);
            $(pps_elements).each(function(x,y){
              if (y.pTypeId==5)
              {
                var op=16;
                if (y.ID==elex.ID) op=6;
                var sc1 = {patternId: y.ID, val1: v, pTypeId: 5, operation: op};
                lsc.push(sc1);
              }
            });




               var ppg = _.find(cooConfig.allpage,function(n){ return n.parentId==pg.ID &&n.pageType==14 });
               var ppg_elements = g.patternFilterByPage(ppg.ID);


              var $p =  $(element).parent('div');
              var tr_index = $p.parent('td').parent('tr').index();

              if (typeof udf_lsc != 'undefined') {
                    lsc= udf_lsc(lsc,pid,tr_index);
               }
               var searchPageId =pg.ID;
                if (typeof udf_pageId != 'undefined') {
                  searchPageId = udf_pageId(pg.ID,elex,pg.categoryId);
                }
               $.when(rest.search(elex.categoryId, searchPageId, lsc, 0, 10)).done(function(result){
                  $(".joinPopup").remove();


                  var rows ="";
                  $(result.data).each(function(j,k){
                       var kk=k;
                       var pindex=0;
                       var ks ="";
                       var z =0;
                       $(ppg_elements).each(function(x,y){
                            if (y.pTypeId ==7 || y.pTypeId==12 || y.pTypeId==10 || y.pTypeId==11 || y.pTypeId==19)
                            {
                              kk['__c'+y.ID] = '';
                            }
                            if (y.pTypeId==5 && z<4)
                            {
                              z++;
                              ks+= "<td style='word-wrap:break-word;' ><div style='width:130px;overflow:hidden;white-space:nowrap; ' >" + k['__c'+y.ID] +"</div></td>";
                           }
                            if (y.pTypeId==16)
                            {
                              pindex= k['__c'+y.ID];
                            }
                       });

                       var jcstr = "joinSelect";
                       if (sub=="1") jcstr = "joinSelect2";
                      // ks=ks.replace(/,$/ig,'');
                       rows+='<tr  style="cursor:pointer;" id="obj_'+pindex+'" data=\''+JSON.stringify(kk)+'\'  ng-click="'+ jcstr +'('+pindex+','+tr_index+','+elex.categoryId+','+elex.ID+','+baseId+','+indexId.ID+')" >'+ks+'</tr> ';


                  });
                  rows='<table class="ui selectable celled table joinPopup" style="width:600px !important;position:absolute;top:25px;left:95px;right:auto;width:auto; table-layout:fixed;   z-index: 10;">' +rows +'</table>';
                  var ng_rows = angular.element(rows);
                  var t = angular.element($(element).parent('div'));
                  t.append(ng_rows);
                  $compile(ng_rows)(scope);
                //  $p.append(rows);



              //   $p.append('<div class="ui flowing popup joinPopup" style="top:auto;right:auto;min-width:10rem;min-height:8rem;"> '+
              //         + rows +' </div>');
                 $(".joinPopup").show();

               });
          }





           console.log(event.which);
            if(event.which === 13) {
                scope.$apply(function (){
                    scope.$eval(attrs.myHint);
                });

                event.preventDefault();
            }
        });
    };
  }]);



CooWorkApp.directive('myEnter', function () {
    return function (scope, element, attrs) {
        element.bind("keydown keypress", function (event) {

           console.log(event.which);
            if(event.which === 13) {
                scope.$apply(function (){
                    scope.$eval(attrs.myEnter);
                });

                event.preventDefault();
            }
        });
    };
});


CooWorkApp.value('uiTinymceConfig', {
  fontsize_formats: "8pt 9pt 10pt 11pt 12pt 26pt 36pt",
  plugins: "textcolor preview importcss code",
  toolbar: "forecolor backcolor preview  fontselect  fontsizeselect",
  textcolor_rows: "4",
  language: 'zh_CN',
  readonly :   0

});


CooWorkApp.directive('tinymce', ['uiTinymceConfig', function (uiTinymceConfig) {
    uiTinymceConfig = uiTinymceConfig || {};
    var generatedIds = 0;
    return {
        priority: 10,
        require: 'ngModel',
        link: function (scope, elm, attrs, ngModel) {
            var expression, options, tinyInstance,
              updateView = function () {
                  ngModel.$setViewValue(elm.val());
                  if (!scope.$root || !scope.$root.$$phase) {
                      scope.$apply();
                  }
              };



            if (!attrs.id) {
                attrs.$set('id', 'uiTinymce' + generatedIds++);
            }

            if (attrs.uiTinymce) {
                expression = scope.$eval(attrs.uiTinymce);
            } else {
                expression = {};
            }


            if (expression.setup) {
                var configSetup = expression.setup;
                delete expression.setup;
            }

            options = {
                // Update model when calling setContent (such as from the source editor popup)
                setup: function (ed) {
                    var args;
                    ed.on('init', function(args) {
                        ngModel.$render();
                        ngModel.$setPristine();
                    });
                    // Update model on button click
                    ed.on('ExecCommand', function (e) {
                        ed.save();
                        updateView();
                    });
                    // Update model on keypress
                    ed.on('KeyUp', function (e) {
                        ed.save();
                        updateView();
                    });
                    // Update model on change, i.e. copy/pasted text, plugins altering content
                    ed.on('SetContent', function (e) {
                        if (!e.initial && ngModel.$viewValue !== e.content) {
                            ed.save();
                            updateView();
                        }
                    });
                    ed.on('focus', function(e) {


                      var  ele = _.find(scope.elements,function(n){ return '__c'+n.p.ID.toString() == attrs.id });
                      if (ele) ele['e'] ="e";

                        $(elm[0]).attr('v','e');
                        //console.log(elm[0].id);
                        elm.focus();
                    });


                    ed.on('blur', function(e) {

                        elm.blur();
                    });
                    // Update model when an object has been resized (table, image)
                    ed.on('ObjectResized', function (e) {
                        ed.save();
                        updateView();
                    });
                    if (configSetup) {
                        configSetup(ed);
                    }
                },
                mode: 'exact',
                elements: attrs.id
            };
            // extend options with initial uiTinymceConfig and options from directive attribute value
            angular.extend(options, uiTinymceConfig, expression);
            setTimeout(function () {

                tinymce.init(options);
            });



            ngModel.$render = function() {
              if (!tinyInstance) {
                  tinyInstance = tinymce.get(attrs.id);
              }
              if (tinyInstance) {
                tinyInstance.setContent(ngModel.$viewValue || '');
              }
            };

            scope.$on('$destroy', function() {
              if (!tinyInstance) { tinyInstance = tinymce.get(attrs.id); }
              if (tinyInstance) {
                tinyInstance.remove();
                tinyInstance = null;
              }
            });

        }
    };
}]);





CooWorkApp.directive('editorc', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element
        element.jqte();

    }
}]);



CooWorkApp.directive('dfnscript', ['cooConfig', 'g', function (cooConfig, g) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element
        console.log(attributes);
        var evt = _.filter(cooConfig.allevent, function (n) { return n.pageId == parseInt(attributes.pageid) });
        if (evt.length > 0) {
            console.log(evt);
            //  var eSource = "$(document.body).on('click', 'input' ,function(){ $(this).val('123');  });   $('#__c15515').val('222');   ";
            g.dfnScript(evt[0].eventSource);
        }


     //   element.replaceWith("<div class=\"script\"><script type=\"text/javascript\"> console.log('fff');  $(document.body).on('click', 'input' ,function(){ $(this).val('123');  });    </script></div>");

    }
}]);





CooWorkApp.directive('editor', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {

            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {

                element = $(element[0]);
              //  element.jqte();
             //    element.jqteVal(modelValue);
             //   console.log(modelValue);

             tinymce.init({
                        selector: '.editor',
                        fontsize_formats: "8pt 9pt 10pt 11pt 12pt 26pt 36pt",
                        plugins: "textcolor preview importcss code",
                        toolbar: "forecolor backcolor preview  fontselect  fontsizeselect",
                        textcolor_rows: "4",
                        language: 'zh_CN',
                        readonly :   0
                   });

            });
        }
    }
}]);



CooWorkApp.directive('attachment', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {

            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {
                element = $(element[0]);

                g.dragFile(modelValue.p.ID, scope.indexId, modelValue.p.categoryId);
            });
        }
    }
}]);


CooWorkApp.directive('attachmentdata', ['cooConfig', 'g','rest', function (cooConfig, g,rest) {
    return function (scope, element, attributes) {
        element = $(element[0]); // Get the element as a jQuery element

        var fs = require('fs');
        var rq = require('request');

        var pageId = attributes.pageid;
        var categoryId = attributes.categoryid;


        var holder = element[0];// document.getElementById("__img0");
        holder.ondragover = function () { $("#__img0").addClass("draghover"); return false; };
        holder.ondragend = function () { $("#__img0").removeClass("draghover"); return false; };
        holder.ondrop = function (e) {
            e.preventDefault();

            var cElements = g.userPatternFilterByPage(pageId);

            if (cElements.length == 0) cElements = g.patternFilterByPage(pageId);


            if (e.dataTransfer.files.length > 0) {
                var formData = {
                    // Pass a simple key-value pair
                    key: cooConfig.configObj.uploadKey,
                    itemId: 0,
                    cateId: categoryId,
                    // Pass data via Streams
                    my_file: fs.createReadStream(e.dataTransfer.files[0].path)
                    // Pass multiple values /w an Array
                };





                $.when(g.postFile(formData)).done(function (obj) {

                    console.log(obj);
                    var etor = {
                        cateId: categoryId,
                        pageId: pageId,
                        aid: obj.ID
                    };

                    $.when(rest.import(etor)).done(function (data) {

                        console.log(data);
                        $("#importb tr:nth-child(n+2)").remove();

                        $(data).each(function (i, item) {
                            var tr = '<tr>';
                            tr += '<td> <input  type="checkbox"  name="mainCheckBox"></td>';
                            $(cElements).each(function (j, p) {

                                var v = item['__c' + p.ID] == undefined ? "" : item['__c' + p.ID];

                                tr += '<td ><div contenteditable="true" name="__c' + p.ID + '" >' + v + '</div></td>';

                            });

                            tr += '</tr>';
                            $("#importb").append(tr);
                        });


                        scope.$apply();
                    });
                });
            }
        };



    }
}]);




CooWorkApp.directive('attachments', ['cooConfig', 'g', function (cooConfig, g) {
    return {
        require: "ngModel",
        link: function (scope, element, attr, ngModel) {
            scope.$watch(function () {
                return ngModel.$modelValue;
            }, function (modelValue) {
                element = $(element[0]);

                g.multiDragFile(modelValue.p.ID, scope.indexId, modelValue.p.categoryId);
            });
        }
    }
}]);







CooWorkApp.directive('multiselectdropdown', ['cooConfig', 'g','rest', function (cooConfig, g,rest) {
    return function (scope, element, attributes) {

        element = $(element[0]); // Get the element as a jQuery element

        // Below setup the dropdown:

        var source = [];
        var sls = [];
        var tid = attributes.name;
        var type = attributes.type;



        switch (type)
        {
            case '_sys_group':
                var gid = attributes.pageid;
                var gpat = g.patternFilterByPage(gid);
                $.each(gpat, function (index, item) {
                    var o = { label: '请选择', value: '' };

                    var o1 = { label: '请选择', value: '' };
                    var o2 = { label: '请选择', value: '' };
                    var o3 = { label: '请选择', value: '' };
                    var o4 = { label: '请选择', value: '' };
                    var o5 = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 2:
                        case 5:
                        case 12:
                        case 13:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                        case 6:
                            o1.label = item.pName + '(年)';
                            o1.value = item.ID + '_1';
                            sls.push(o1);
                            o2.label = item.pName + '(季)';
                            o2.value = item.ID + '_2';
                            sls.push(o2);
                            o3.label = item.pName + '(月)';
                            o3.value = item.ID + '_3';
                            sls.push(o3);
                            o4.label = item.pName + '(周)';
                            o4.value = item.ID + '_4';
                            sls.push(o4);
                            o5.label = item.pName + '(日)';
                            o5.value = item.ID + '_5';
                            sls.push(o5);
                            break;

                    }
                });
                break;

            case '_sys_order':
                var oid = attributes.pageid;
                var opat = g.patternFilterByPage(oid);
                sls.push({ label: '请选择', value: '' });
                $.each(opat, function (index, item) {
                    var o = { label: '请选择', value: '' };
                    var o1 = { label: '请选择', value: '' };
                    var o2 = { label: '请选择', value: '' };
                    var o3 = { label: '请选择', value: '' };
                    var o4 = { label: '请选择', value: '' };
                    var o5 = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                        case 12:
                        case 13:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                        case 6:
                            o1.label = item.pName + '(年)';
                            o1.value = item.ID + '_1';
                            sls.push(o1);
                            o2.label = item.pName + '(季)';
                            o2.value = item.ID + '_2';
                            sls.push(o2);
                            o3.label = item.pName + '(月)';
                            o3.value = item.ID + '_3';
                            sls.push(o3);
                            o4.label = item.pName + '(周)';
                            o4.value = item.ID + '_4';
                            sls.push(o4);
                            o5.label = item.pName + '(日)';
                            o5.value = item.ID + '_5';
                            sls.push(o5);
                            break;

                    }
                });
                break;
            case '_sys_calculate':
                var cid = attributes.pageid;
                var cpat = g.patternFilterByPage(cid);
                $.each(cpat, function (index, item) {
                    var o = { label: '请选择', value: '' };
                    switch (item.pTypeId) {
                        case 3:
                        case 4:
                            o.label = item.pName;
                            o.value = item.ID;
                            sls.push(o);
                            break;
                    }
                });
                break;
            case 'order':
                var pageId = attributes.pageid;
                var p12 = g.pageFilter(12, pageId);
                if (p12.length > 0) {
                    var patternSort = g.patternFilterByPage(p12[0].ID);

                    var o = { label: '请选择', value: '' };
                    sls.push(o);

                    $(patternSort).each(function (j, m) {

                        var op = { label: '↑ ' + m.pName, value: '__c' + m.ID + 'x1' };
                        var op2 = { label: '↓ ' + m.pName, value: '__c' + m.ID + 'x2' };
                        sls.push(op);
                        sls.push(op2);
                    });
                }
                break;
            case 'user':

                tid = tid.replace(/\D/ig, '');
                source = g.statusFilterByPattern(tid);
                var users = cooConfig.alluser;
                if (source.length > 0) {
                      users = g.userFilterByRoleId(source[0].statusName);
                 }

                    var otherusers = _.filter(users,function(n){ return n.departmentId==null || n.departmentId==0; });

                    var orow = { label:"未分部门",children:[]  };
                    orow.children.push({label:'未选择',value:'00000000-0000-0000-0000-000000000000'});
                    $(otherusers).each(function(i,f){
                      orow.children.push({label:f.XingMing,value:f.UserId});
                    });




                    $(cooConfig.alldepartment).each(function(i,d){

                                var row ={ label:d.departmentName,children:[] };
                                var subusers = _.filter(users,function(n){ return n.departmentId==d.ID; });
                                $(subusers).each(function(i,f){
                                  row.children.push({label:f.XingMing,value:f.UserId});
                                });

                       sls.push(row);
                    })


                    sls.push(orow);


                //    $(users).each(function (i, item) {
                //        var op = { label: item.XingMing, value: item.UserId };
              //          sls.push(op);
              //      });


                break;
            case 'data':
                tid = tid.replace(/\D/ig, '');
                source = g.statusFilterByPattern(tid);

                var smp= _.find(cooConfig.allstatusmap,function(n){ return n.patternId.toString() == tid});
              //  console.log(smp);
                if (smp&&smp.init)
                {
                    $(source).each(function (i, item) {
                        var op = { label: item.statusName, value: item.ID };
                        sls.push(op);
                    });
                }

            case 'element':
                tid = tid.replace(/\D/ig, '');
                source = g.userPatternFilterByPage(tid);
                $(source).each(function (i, item) {
                    var op = { label: item.pName, value: item.ID };
                    sls.push(op);
                });

                break;
            case 'element2':
                tid = tid.replace(/\D/ig, '');
                source = g.patternFilterByPage(tid);
                $(source).each(function (i, item) {
                    var op = { label: item.pName, value: item.ID };
                    sls.push(op);
                });

                break;

        } ;



        element.multiselect({
            enableClickableOptGroups: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            onDropdownShown: function(event) {

              //   $(".create_all .ui.table").append('<tr class="plugin" style="height:400px;" ></tr>')
             },
             onDropdownHidden: function(event) {
            //   $(".create_all .ui.table .plugin").remove();
             },
            onChange: function(option, checked) {

             var  ele = _.find(scope.elements,function(n){ return n.p.ID.toString() == tid });
            if (ele) ele['e'] ="e";

             var v1 = $('#__c'+tid).val();
             if (v1 && v1.length>0)
             {
                 var s1 = v1[0];
                 if (s1 && parseInt(s1)>0)
                 {
                        var ss =_.filter(cooConfig.allstatus,function(n){ return n.parentId == parseInt(s1)});
                        var smp= _.find(cooConfig.allstatusmap,function(n){ return n.patternId.toString() == tid});
                        if (ss.length>0 && smp)
                        {
                          var ssp = [];
                          $(ss).each(function(i,item){
                            ssp.push({ label: item.statusName, value: item.ID });
                          });

                          var childElement =_.find(cooConfig.allstatusmap,function(n){ return n.groupId==ss[0].groupId &&n.categoryId==smp.categoryId });

                          if (childElement)
                          {
                            $('[name="__c'+childElement.patternId+'"]').multiselect('dataprovider', ssp);
                          }
                        }
                   }
              }
            }
        });

         var opts={ enableClickableOptGroups: true};

        if (sls.length>0)   element.multiselect('dataprovider', sls);

        if (attributes.val)
        {
            var vv = attributes.val.split(',');
      //      console.log(vv);
            element.multiselect('select', vv);
        }



                  // element.multiselect('setOptions', opts);
    }

}]);
