﻿CooWorkApp.factory('locdbServices', function (cooConfig, login,  _) {


    var fileObject = {};
    var locdb = {};


    var tableNames = [];

    tableNames.push(cooConfig.WORKFLOWTABLENAME);
    tableNames.push(cooConfig.JOINTABLENAME);
    tableNames.push(cooConfig.CATEGORYTABLENAME);
    tableNames.push(cooConfig.DEPARTMENTTABLENAME);
    tableNames.push(cooConfig.TAGTABLENAME);
    tableNames.push(cooConfig.COOITEMPATTERNTABLENAME);
    tableNames.push(cooConfig.ELEMENTTABLENAME);
    tableNames.push(cooConfig.PAGETABLENAME);
    tableNames.push(cooConfig.STATUSTABLENAME);
    tableNames.push(cooConfig.USERELEMENTTABLENAME);
    tableNames.push(cooConfig.CACHETABLENAME);
    tableNames.push(cooConfig.EVENTTABLENAME);
    tableNames.push(cooConfig.TEMPLATETABLENAME);
    tableNames.push(cooConfig.CUSERTABLENAME);
    tableNames.push(cooConfig.MENUTABLENAME);
    tableNames.push(cooConfig.GROUPTABLENAME);
    tableNames.push(cooConfig.CONFIGURATIONTABLENAME);





    var isMobile = false;


    var localDatabase = {};
    var dbName = "CooWorkDb";
    var records = [];

    var a = navigator.userAgent;
    if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
        isMobile = true;
        cooConfig.isMobile = true;
    } else {
        isMobile = false;
        cooConfig.isMobile = false;
    }





    locdb.openDatabase = function () {
        console.log("Started database open - " + dbName);
        var openRequest = localDatabase.indexedDB.open(dbName, 1);

        openRequest.onerror = function (e) {
            console.log("Database opened error: " + event.target.error);
        };
        openRequest.onsuccess = function (event) {
            localDatabase.db = openRequest.result;
            console.log("Finished database open " + localDatabase.db.name);
        };
    }


    locdb.closeDatabase = function () {
        console.log("Started database close");
        localDatabase.db.close();
        console.log("Finished database close");
    }


    locdb.deleteDatabase = function () {
        try {
            console.log('Started database delete');
            //    localDatabase.db.close();
            var deleteDbRequest = localDatabase.indexedDB.deleteDatabase(dbName);

            deleteDbRequest.onsuccess = function (event) {
                console.log('Finished database delete');

                deleteDbRequest.onerror = function (e) {
                    console.log("Database error: " + e.target.errorCode);
                };
            };
        }
        catch (e) {
            console.log(e.message);
        }
    }



    function writeFile(tablename, str) {
        var dtd = $.Deferred();

        var filename = cooConfig.configObj.companyId + "." + tablename;

        console.log('write' + tablename + ' - ' + str.length);

        //   localStorage.setItem(filename, str);

        amplify.store(filename, str);


        dtd.resolve();

        return dtd.promise();
    }


    function CheckBrowser() {
        if ('localStorage' in window && window['localStorage'] !== null) {
            // we can use localStorage object to store data
            return true;
        } else {
            return false;
        }
    }



    //cordova

    function readFile(tablename) {
        var dtd = $.Deferred();


        var ret = "";
        var filename = cooConfig.configObj.companyId + "." + tablename;


        if (CheckBrowser()) {
            //var ret = localStorage.getItem(filename);
            var ret = amplify.store(filename);

            dtd.resolve(ret);
        }

        return dtd.promise();
    }
    //cordova


    function fail(error) {
        console.log(error.code);
    }


    function writeLog(logger, str) {
        if (!logger) return;
        logger.createWriter(function (fileWriter) {
            fileWriter.write(str);
        }, fail);
    }

    function fail(error) {
        console.log(error.code);
    }



    function initDatabase() {
        var dtd = $.Deferred();
        dtd.resolve();
        return dtd.promise();
    }


    function remoteData(key, time) {

        var dtd = $.Deferred();

        var etor = {
            cachekey: key,
            ttt: time
        };

        var t = '?t=' + Math.random();
        $.ajax({
            url: cooConfig.configObj.url + 'cache/list' + t,
            type: "post",
            data: JSON.stringify(etor),
            dataType: "json",
            contentType: "application/json;charset=utf-8",
            async: false,
            success: function (data) {
                //   ddt = data;
                //   console.log(data);
                dtd.resolve(data);

            },
            error: function (jqXHR, exception) {
                console.log(exception);
            }
        });

        return dtd.promise();
    };



    locdb.bulkDeleteByPatternId = function (TABLENAME, ids, pageId) {


        var dtd = $.Deferred();

        $.when(fetch(TABLENAME)).done(function (s) {

            var t = typeof s ;
            var objs = t=="object"?s:JSON.parse(s);

           //console.log(objs);

            var newObjs = _.filter(objs, function (n) { return (jQuery.inArray(n.patternId, ids) == -1 && n.pageId == pageId) || n.pageId != pageId; });

            //console.log(newObjs);

            $.when(writeFile(TABLENAME, JSON.stringify(newObjs))).done(function () {
                dtd.resolve();
            });


        });
        return dtd.promise();
    };


    locdb.addShortCut = function(o)
    {
        var dtd = $.Deferred();
        var tbname ='shortCut';
        $.when(fetch(tbname)).done(function(s){
          var t = typeof s ;
          var objs = t=="object"?s:JSON.parse(s);

        //  if (!_.any(objs,function(n){
        //   return n.ID==o.ID && JSON.stringify(n.lsc).toLowerCase()==JSON.stringify(o.lsc).toLowerCase() && n.lscStr ==o.lscStr ;
        //  }))
          objs.push(o);
          $.when(writeFile(tbname, JSON.stringify(objs))).done(function () {
              dtd.resolve();
          });
        });
          return dtd.promise();
    };

    locdb.removeShortCut = function(o)
    {
        var dtd = $.Deferred();
        var tbname ='shortCut';
        $.when(fetch(tbname)).done(function(s){
          var t = typeof s ;
          var objs = t=="object"?s:JSON.parse(s);
          var newObjs = _.filter(objs, function(n) { return o.UTC!=n.UTC  });
          $.when(writeFile(tbname, JSON.stringify(newObjs))).done(function () {
              dtd.resolve();
          });
        });
          return dtd.promise();
    };

    locdb.listShortCut =function()
    {
        var dtd = $.Deferred();
        var tbname ='shortCut';
        $.when(fetch(tbname)).done(function(s){
          var t = typeof s ;
          var objs = t=="object"?s:JSON.parse(s);
          dtd.resolve(objs);
        });
       return dtd.promise();
    };


    locdb.pushTable = function (osTableName, jsonData) {


        var dtd = $.Deferred();

        $.when(fetch(osTableName)).done(function (s) {
            var objs = [];
            if ((typeof s)=="object") {
              objs =s;
            }
            else {
               objs = JSON.parse(s);
            }


            $(jsonData).each(function (u, k) {
                objs.push(k);
            });
            //    var newObjs = _.filter(objs, function (n) { return (jQuery.inArray(n.patternId, ids) != -1 && n.pageId == pageId) || n.pageId != pageId; });

            $.when(writeFile(osTableName, JSON.stringify(objs))).done(function () {
                dtd.resolve();
            });


        });
        return dtd.promise();
    }



    function clear(TABLENAME) {

        try {

            var keyIndex = 'ID';
            switch (TABLENAME) {
                case 'cuser':
                    keyIndex = 'UserId';
                    break;
                default: break;
            }

            var dtd = $.Deferred();



            if (!isMobile) {

                console.log(localDatabase.db != null);
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(TABLENAME, "readwrite").objectStore(TABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) {
                                store.delete(ipattern[keyIndex]);
                            }
                            cursor.continue();
                        }
                        else {

                            dtd.resolve();
                        }
                    };
                }
            }
            else {
                //mobile todo
                if (TABLENAME == "join") TABLENAME = "jjoin";

                var deleteStatement = "DELETE FROM " + TABLENAME + " WHERE companyId=?";
                localDatabase.mobileDb.transaction(function (tx) {
                    tx.executeSql(deleteStatement, [cooConfig.configObj.companyId], function () {
                        dtd.resolve();
                    }, function (tx, error) { console.log(error.message); });
                });

            }
            return dtd.promise();
        }
        catch (e) {
            console.log(e.message);
        }
    }




    function addData(txn, store, records, i, commitT) {
        try {
            if (i < records.length) {
                var rec = records[i];
                var req = store.add(rec);
                req.onsuccess = function (ev) {
                    i++;
                    addData(txn, store, records, i, commitT);
                }
                req.onerror = function (ev) {
                    console.log("Failed to add record." + "  Error: " + ev.message + JSON.stringify(records));
                }
            }
            else if (i == records.length) {
                console.log('Finished adding ' + records.length + " records");
            }
        }
        catch (e) {
            console.log(e.message);
        }
    }







    function checkSchema2(osTableName, local, remote) {

    //      console.log(local);
    //      console.log(remote);
  //       console.log(osTableName);
        var dtd = $.Deferred();
        var c1 = cacheNameCompare(local, osTableName);
        var c2 = cacheNameCompare(remote, osTableName);
        var t = '2013-01-01';
        var updateFlag = false;


        if (osTableName == cooConfig.STATUSMAPTABLENAME) {
            c1 = cacheNameCompare(local, cooConfig.STATUSTABLENAME);
            c2 = cacheNameCompare(remote, cooConfig.STATUSTABLENAME);
        }


      //  console.log(c1);
      //  console.log(c2);
      //  console.log(osTableName);


        if (c1.length == 0) { updateFlag = true; }
        else { if (c2.length > 0 && Date.parse(c1[0].cacheTime) != Date.parse(c2[0].cacheTime)) { updateFlag = true; } }









        if (updateFlag) {
            $.when(remoteData(osTableName, t)).done(function (data) {

                console.log(osTableName);
                  console.log(data.add.length);

                if (data.add.length > 0) {

                    switch (osTableName) {
                        case 'cuser':
                            $(data.add).each(function (i, o) {
                                o['companyId'] = parseInt(o.UserName.replace(/:.+$/ig, ''));
                            });
                            break;

                    }

                    $.when(writeFile(osTableName, JSON.stringify(data.add))).done(function () {
                        dtd.resolve(true);
                    });

                } else {
                    dtd.resolve(false);
                }
            });


        }
        else {
            dtd.resolve(false);
        }

        return dtd.promise();
    }









    function cacheCompare($caches, $item) {
        return $caches.filter(function (v) {
            return v.cacheName.toLowerCase() == $item.cacheName.toLowerCase();
        });
    }

    function cacheNameCompare($list, $name) {
      //   console.log($list);
    //     console.log($name);
        return $list.filter(function (v) {
            return v.cacheName.toLowerCase() == $name.toLowerCase();
        });
    }


    function initData2() {

    //   console.log(cooConfig);

        var dtd = $.Deferred();
        $.when(remoteData('cacheTime', '2013-01-01')).done(function (ret) {


      //      console.log(ret);

            $.when(fetch(cooConfig.CACHETABLENAME)).done(function (caches) {




                //todo
                var result = ret.add;
                if (caches == null || caches.length == 0) caches = [];
                if (result == null || result.length == 0) result = [];
                $.when(checkSchema2(cooConfig.CATEGORYTABLENAME, caches, result),
                    checkSchema2(cooConfig.WORKFLOWTABLENAME, caches, result),
                    checkSchema2(cooConfig.JOINTABLENAME, caches, result),
                    checkSchema2(cooConfig.DEPARTMENTTABLENAME, caches, result),
                    checkSchema2(cooConfig.TAGTABLENAME, caches, result),
                    checkSchema2(cooConfig.PAGETABLENAME, caches, result),
                    checkSchema2(cooConfig.ELEMENTTABLENAME, caches, result),
                    checkSchema2(cooConfig.COOITEMPATTERNTABLENAME, caches, result),
                    checkSchema2(cooConfig.STATUSTABLENAME, caches, result),
                    checkSchema2(cooConfig.CUSERTABLENAME, caches, result),
                    checkSchema2(cooConfig.EVENTTABLENAME, caches, result),
                    checkSchema2(cooConfig.TEMPLATETABLENAME, caches, result),
                    checkSchema2(cooConfig.STATUSMAPTABLENAME, caches, result),
                    checkSchema2(cooConfig.NAVIGATETABLENAME, caches, result),
                    checkSchema2(cooConfig.MENUTABLENAME,caches,result),
                    checkSchema2(cooConfig.GROUPTABLENAME,caches,result),
                    checkSchema2(cooConfig.CONFIGURATIONTABLENAME,caches,result)
                  ).done(function (a, b, c, d, e, f, g, h, i, j, k, l, m, n,o,p,q) {

                        if (a || b || c || d || e || f || g || h || i || j || k || l || m || n || o || p||q) {

                            writeFile(cooConfig.CACHETABLENAME, JSON.stringify(result));
                        }

                        dtd.resolve();


                    });

            });

        });

        return dtd.promise();
    };





    function maxDateTime(osTableName) {

        //todo


        var dtd = $.Deferred();

        if (localDatabase != null && localDatabase.db != null) {
            var transaction = localDatabase.db.transaction(osTableName);
            if (transaction) {
                transaction.oncomplete = function () {
                }
                transaction.onabort = function () {
                    console.log("transaction aborted.");
                    localDatabase.db.close();
                }
                transaction.ontimeout = function () {
                    console.log("transaction timeout.");
                    localDatabase.db.close();
                }
                var store = transaction.objectStore(osTableName);
                if (store) {
                    var keyRange = IDBKeyRange.lowerBound(0);
                    var cursorRequest = store.openCursor(keyRange);
                    var t = '2011-04-11';

                    cursorRequest.onsuccess = function (e) { // success called for each cursor action
                        var result = e.target.result;
                        if (result) {
                            if (result.value.t != undefined && Date.parse(result.value.t) > Date.parse(t)) t = result.value.t;
                            result.continue();
                        }
                        else {
                            //  console.log(osTableName + ':' + t);
                            dtd.resolve(t);
                        }
                    };
                }
            }
            return dtd.promise();
        }
        else {
            console.log("Database needs to be created first");
        }

    };





    locdb.countRecords = function (osTableName) {

        var dtd = $.Deferred();

        if (localDatabase != null && localDatabase.db != null) {
            console.log("Starting count");
            var transaction = localDatabase.db.transaction(osTableName);
            if (transaction) {
                transaction.oncomplete = function () {
                }
                transaction.onabort = function () {
                    console.log("transaction aborted.");
                    localDatabase.db.close();
                }
                transaction.ontimeout = function () {
                    console.log("transaction timeout.");
                    localDatabase.db.close();
                }
                var store = transaction.objectStore(osTableName);
                if (store) {
                    var keyRange = IDBKeyRange.lowerBound(0);
                    var cursorRequest = store.openCursor(keyRange);
                    var count = 0;

                    cursorRequest.onsuccess = function (e) { // success called for each cursor action
                        var result = e.target.result;
                        if (result) {
                            ++count && result.continue();
                        }
                        else {
                            console.log(osTableName + ':' + count);
                            dtd.resolve(count);
                        }
                    };
                }
            }
            return dtd.promise();
        }
        else {
            console.log("Database needs to be created first");
        }
    };


    function fetch(osTableName) {
        var dtd = $.Deferred();
        var ret = [];

        $.when(readFile(osTableName)).done(function (str) {
            if (str != undefined && str != "") {
                ret = JSON.parse(str);
            }
            dtd.resolve(ret);
        });
        return dtd.promise();
    }


    locdb.fetchAllUserElements = function () {

        var dtd = $.Deferred();
        var ret = [];

        $.when(fetch(cooConfig.USERELEMENTTABLENAME)).done(function (r) {
            ret = r;
            dtd.resolve(ret);
        });
        return dtd.promise();
    }


    locdb.start = function () {
        var dtd = $.Deferred();
        if (cooConfig.configObj.isStart) {
            console.log('starting');

            dtd.resolve(true);
        }
        else {

          console.log('data-1');
            $.when(login.autoLogin()).done(function (isAuto) {
            console.log('data0');

                if (isAuto) {
                    $.when(initDatabase()).done(function () {
                               console.log('data1');
                        $.when(initData2()).done(function () {
                              console.log('data2');

                            $.when(fetch(cooConfig.COOITEMPATTERNTABLENAME), fetch(cooConfig.PAGETABLENAME), fetch(cooConfig.ELEMENTTABLENAME), fetch(cooConfig.STATUSTABLENAME), fetch(cooConfig.CUSERTABLENAME), fetch(cooConfig.USERELEMENTTABLENAME), fetch(cooConfig.CATEGORYTABLENAME), fetch(cooConfig.DEPARTMENTTABLENAME), fetch(cooConfig.TAGTABLENAME), fetch(cooConfig.JOINTABLENAME), fetch(cooConfig.WORKFLOWTABLENAME),
                            fetch(cooConfig.EVENTTABLENAME), fetch(cooConfig.STATUSMAPTABLENAME), fetch(cooConfig.NAVIGATETABLENAME),fetch(cooConfig.MENUTABLENAME),fetch(cooConfig.GROUPTABLENAME),fetch(cooConfig.CONFIGURATIONTABLENAME)
                          ).done(function (a, b, c, d, e, f, g, h, i, j, k, l, m, n,o,p,q) {



                                cooConfig.allpattern = a;
                                cooConfig.allpage = b;
                                cooConfig.allelement = c;
                                cooConfig.allstatus = d;
                                cooConfig.alluser = e;
                                cooConfig.alluserelement = f;
                                cooConfig.allcategory = g;
                                cooConfig.alldepartment = h;
                                cooConfig.alltag = i;
                                cooConfig.alljoin = j;
                                cooConfig.allworkflow = k;
                                cooConfig.allevent = l;
                                cooConfig.allstatusmap = m;
                                cooConfig.allnavigate = n;
                                cooConfig.allmenu = o;
                                cooConfig.allgroup = p;
                                cooConfig.allconfiguration = q;
                                //     console.log('init');
                                cooConfig.configObj.isStart = true;

                                console.log('finish init');

                                dtd.resolve(true);
                            });

                        });
                    });
                }
                else {

                    dtd.resolve(false);
                }
            });
        }
        return dtd.promise();
    }

    return locdb;
});
