﻿CooWorkApp.factory('locdbServices', function (cooConfig,login) {

    var locdb = {};

    var isMobile = false;


    var localDatabase = {};
    var dbName = "CooWorkDb";
    var records = [];

    var a = navigator.userAgent;
    if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) {
        isMobile = true;
        cooConfig.isMobile = true;
    } else {
        isMobile = false;
        cooConfig.isMobile = false;
    }

  //  isMobile = true;
  //   cooConfig.isMobile = true;
    console.log(isMobile);

    if (!isMobile) {

        localDatabase.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;

        localDatabase.IDBKeyRange = window.IDBKeyRange || window.webkitIDBKeyRange;

        localDatabase.IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction;

        if (!window.indexedDB) {

            $('#support').show();

            console.log("Your browser doesn't support a stable version of IndexedDB. Such and such feature will not be available.");
        }
    }
    else
    {


        try {

            if (window.openDatabase == undefined)  // Check browser is supported SQLite or not.
            {
                alert('Databases are not supported in this browser.');

            }
            else {
                localDatabase.mobileDb = openDatabase(dbName, "1.0", dbName, 5 * 1000 * 1000);
            }

        }

        catch (e) {

            if (e == 2) {
                console.log("Invalid database version.");

            } else {
                console.log("Unknown error " + e + ".");
            }
            return;
        }


    }



    if (!isMobile) {
        localDatabase.indexedDB.onerror = function (e) {
            console.log("Database error  " + e.target.errorCode);
        };

        localDatabase.indexedDB.onsuccess = function (e) {
            console.log("Database success  " + e.target.errorCode);
        };
    }


    locdb.openDatabase = function () {
        console.log("Started database open - " + dbName);
        var openRequest = localDatabase.indexedDB.open(dbName, 1);

        openRequest.onerror = function (e) {
            console.log("Database opened error: " + event.target.error);
        };
        openRequest.onsuccess = function (event) {
            localDatabase.db = openRequest.result;
            console.log("Finished database open " + localDatabase.db.name);
        };
    }


    locdb.closeDatabase = function () {
        console.log("Started database close");
        localDatabase.db.close();
        console.log("Finished database close");
    }


    locdb.deleteDatabase =  function () {
        try {
            console.log('Started database delete');
            //    localDatabase.db.close();
            var deleteDbRequest = localDatabase.indexedDB.deleteDatabase(dbName);

            deleteDbRequest.onsuccess = function (event) {
                console.log('Finished database delete');

                deleteDbRequest.onerror = function (e) {
                    console.log("Database error: " + e.target.errorCode);
                };
            };
        }
        catch (e) {
            console.log(e.message);
        }
    }


    function initDatabaseMobileSuccess()
    {
        //todo
    }

    function initDatabaseMobileOnError() {
        console.log('initTable error!');
        //todo
    }


    function dropTable()
    {
        var dropStatement0 = "DROP TABLE " + cooConfig.WORKFLOWTABLENAME;


        var dropStatement1 = "DROP TABLE j" + cooConfig.JOINTABLENAME;


        var dropStatement2 = "DROP TABLE " + cooConfig.CATEGORYTABLENAME;


        var dropStatement3 = "DROP TABLE " + cooConfig.DEPARTMENTTABLENAME;

        var dropStatement4 = "DROP TABLE " + cooConfig.TAGTABLENAME;

        var dropStatement5 = "DROP TABLE " + cooConfig.COOITEMPATTERNTABLENAME;

        var dropStatement6 = "DROP TABLE " + cooConfig.ELEMENTTABLENAME;

        var dropStatement7 = "DROP TABLE " + cooConfig.PAGETABLENAME;

        var dropStatement8 = "DROP TABLE " + cooConfig.STATUSTABLENAME;

        var dropStatement9 = "DROP TABLE " + cooConfig.USERELEMENTTABLENAME;

        var dropStatement10 = "DROP TABLE " + cooConfig.CACHETABLENAME;

        var dropStatement11 = "DROP TABLE " + cooConfig.EVENTTABLENAME;

        var dropStatement12 = "DROP TABLE " + cooConfig.TEMPLATETABLENAME;

        var dropStatement13 = "DROP TABLE " + cooConfig.CUSERTABLENAME;



        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement0, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement1, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement2, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement3, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement4, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement5, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement6, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement7, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement8, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement9, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement10, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement11, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement12, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(dropStatement13, [], function () { }, initDatabaseMobileOnError); });







    }




    function initDatabaseMobile()
    {

        var dtd = $.Deferred();

    //    dropTable();


        var createStatement1 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.WORKFLOWTABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER, categoryId INTEGER,tagId1 INTEGER, tagId2 INTEGER,patternId INTEGER,roleId TEXT,t TEXT)' ;

        var createStatement2 = 'CREATE TABLE IF NOT EXISTS j' + cooConfig.JOINTABLENAME + ' (ID INTEGER PRIMARY KEY , companyId INTEGER, categoryId INTEGER,joinPatternId INTEGER, joinCategoryId INTEGER,nRelation INTEGER,t TEXT)' ;

        var createStatement3 = 'CREATE TABLE IF NOT EXISTS ' + cooConfig.CATEGORYTABLENAME + ' (ID INTEGER PRIMARY KEY , companyId INTEGER, categoryName TEXT,cOrder INTEGER, status INTEGER,eName TEXT, parentId INTEGER, appId INTEGER,t TEXT)';

        var createStatement4 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.DEPARTMENTTABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER, departmentName TEXT,departmentDesc TEXT, leader TEXT,parentId INTEGER,t TEXT)' ;

        var createStatement5 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.TAGTABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER, tagName TEXT,tagCount INTEGER, tagNote TEXT,categoryId INTEGER,t TEXT)' ;

        var createStatement6 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.COOITEMPATTERNTABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER,categoryId INTEGER,pName TEXT,pTypeId INTEGER, pOrder INTEGER,eName TEXT ,validator TEXT, required INTEGER,   disabled  INTEGER,isUnique INTEGER , isSortStatistic INTEGER, t TEXT)';

        var createStatement7 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.ELEMENTTABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER,categoryId INTEGER,isRelated  INTEGER,patternId INTEGER, pageId INTEGER,eorder INTEGER,t TEXT)' ;

        var createStatement8 =  'CREATE TABLE IF NOT EXISTS '+cooConfig.PAGETABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER,categoryId INTEGER,pageName TEXT,pageType INTEGER, pageProperty TEXT,UIname TEXT,isEditable INTEGER, parentId INTEGER,pageOrder INTEGER, t TEXT)' ;

        var createStatement9 =  'CREATE TABLE IF NOT EXISTS '+cooConfig.STATUSTABLENAME+' (ID_Pattern TEXT PRIMARY KEY , ID INTEGER, companyId INTEGER,categoryId INTEGER,statusName TEXT,statusOrder INTEGER, patternId INTEGER, parentId INTEGER,stype INTEGER, t TEXT)';

        var createStatement10 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.USERELEMENTTABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER,categoryId INTEGER,isRelated  INTEGER,patternId INTEGER, pageId INTEGER,eorder INTEGER,t TEXT)' ;

        var createStatement11 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.CACHETABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER,cacheName TEXT, cacheTime TEXT)' ;

        var createStatement12 = 'CREATE TABLE IF NOT EXISTS ' + cooConfig.EVENTTABLENAME + ' (ID INTEGER PRIMARY KEY , companyId INTEGER,eventSource TEXT, pageId INTEGER, eventType INTEGER ,t TEXT)';

        var createStatement13 = 'CREATE TABLE IF NOT EXISTS '+cooConfig.TEMPLATETABLENAME+' (ID INTEGER PRIMARY KEY , companyId INTEGER,filename TEXT,checkSum TEXT,updateTime TEXT,ContentSize INTEGER, t TEXT)';

        var createStatement14 = 'CREATE TABLE IF NOT EXISTS ' + cooConfig.CUSERTABLENAME + ' (UserId TEXT PRIMARY KEY , companyId INTEGER,PassWord TEXT,family TEXT,UserName TEXT,RoleIds TEXT,XingMing TEXT,departmentId INTEGER,IsApproved INTEGER, t TEXT)';


        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement1, [], function () {   }, initDatabaseMobileOnError);});
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement2, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement3, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement4, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement5, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement6, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement7, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement8, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement9, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement10, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement11, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement12, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement13, [], function () { }, initDatabaseMobileOnError); });
        localDatabase.mobileDb.transaction(function (tx) { tx.executeSql(createStatement14, [], function () { }, initDatabaseMobileOnError); });


        dtd.resolve();

        //localDatabase.mobileDb.transaction(function (tx) {
        //    tx.executeSql(createStatement, [], function () {
        //        dtd.resolve();
        //    }, initDatabaseMobileOnError);
        //});

        return dtd.promise();

    }



    function initDatabase() {
       // locdb.deleteDatabase();


        var dtd = $.Deferred();



        if (!isMobile) {
            //  var updateFlag = false;
            try {
                var openRequest = localDatabase.indexedDB.open(dbName, 1); //version used

                openRequest.onerror = function (e) {
                    console.log("Database error: " + e.target.errorCode);
                };
                openRequest.onsuccess = function (event) {
                    console.log('Finished database create - ' + dbName);
                    localDatabase.db = openRequest.result;
                    //   callOnce(updateFlag);

                    dtd.resolve();
                };
                openRequest.onupgradeneeded = function (evt) {

                    //  updateFlag = true;


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.WORKFLOWTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.WORKFLOWTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.WORKFLOWTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false });
                        itemPatternStore.createIndex("tagId1Index", "tagId1", { unique: false });
                        itemPatternStore.createIndex("tagId2Index", "tagId2", { unique: false });
                        itemPatternStore.createIndex("patternIdIndex", "patternId", { unique: false });
                        itemPatternStore.createIndex("roleIdIndex", "roleId", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.WORKFLOWTABLENAME); // onupgradeneeded called first
                    }





                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.JOINTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.JOINTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.JOINTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false });
                        itemPatternStore.createIndex("joinPatternIdIndex", "joinPatternId", { unique: false });
                        itemPatternStore.createIndex("joinCategoryIdIndex", "joinCategoryId", { unique: false });
                        itemPatternStore.createIndex("nRelationIndex", "nRelation", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.JOINTABLENAME); // onupgradeneeded called first
                    }



                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.CATEGORYTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.CATEGORYTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.CATEGORYTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryNameIndex", "categoryName", { unique: false });
                        itemPatternStore.createIndex("cOrderIndex", "cOrder", { unique: false });
                        itemPatternStore.createIndex("statusIndex", "status", { unique: false });
                        itemPatternStore.createIndex("eNameIndex", "eName", { unique: false });
                        itemPatternStore.createIndex("parentIdIndex", "parentId", { unique: false });
                        itemPatternStore.createIndex("appIdIndex", "appId", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.CATEGORYTABLENAME); // onupgradeneeded called first
                    }


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.DEPARTMENTTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.DEPARTMENTTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.DEPARTMENTTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("departmentNameIndex", "departmentName", { unique: false });
                        itemPatternStore.createIndex("departmentDescIndex", "departmentDesc", { unique: false });
                        itemPatternStore.createIndex("leaderIndex", "leader", { unique: false });
                        itemPatternStore.createIndex("parentIdIndex", "parentId", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.DEPARTMENTTABLENAME); // onupgradeneeded called first
                    }



                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.TAGTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.TAGTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.TAGTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("tagNameIndex", "tagName", { unique: false });
                        itemPatternStore.createIndex("tagCountIndex", "tagCount", { unique: false });
                        itemPatternStore.createIndex("tagNoteIndex", "tagNote", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.TAGTABLENAME); // onupgradeneeded called first
                    }








                    // check if OS\table not already added
                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.COOITEMPATTERNTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.COOITEMPATTERNTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.COOITEMPATTERNTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false }); // email has to be unique (a constraint)
                        itemPatternStore.createIndex("pNameIndex", "pName", { unique: false });
                        itemPatternStore.createIndex("pTypeIdIndex", "pTypeId", { unique: false });
                        itemPatternStore.createIndex("pOrderIndex", "pOrder", { unique: false });
                        itemPatternStore.createIndex("eNameIndex", "eName", { unique: false });
                        itemPatternStore.createIndex("validatorIndex", "validator", { unique: false });
                        itemPatternStore.createIndex("requiredIndex", "required", { unique: false });
                        itemPatternStore.createIndex("disabledIndex", "disabled", { unique: false });
                        itemPatternStore.createIndex("isUniqueIndex", "isUnique", { unique: false });
                        itemPatternStore.createIndex("isSortStatisticIndex", "isSortStatistic", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });


                        console.log("Finished creating object-store - '" + cooConfig.COOITEMPATTERNTABLENAME); // onupgradeneeded called first
                    }



                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.ELEMENTTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.ELEMENTTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.ELEMENTTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false }); // email has to be unique (a constraint)
                        itemPatternStore.createIndex("isRelatedIndex", "isRelated", { unique: false });
                        itemPatternStore.createIndex("patternIdIndex", "patternId", { unique: false });
                        itemPatternStore.createIndex("pageIdIndex", "pageId", { unique: false });
                        itemPatternStore.createIndex("eorderIndex", "eorder", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.ELEMENTTABLENAME); // onupgradeneeded called first
                    }



                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.PAGETABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.PAGETABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.PAGETABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false }); // email has to be unique (a constraint)
                        itemPatternStore.createIndex("pageNameIndex", "pageName", { unique: false });
                        itemPatternStore.createIndex("pageTypeIndex", "pageType", { unique: false });
                        itemPatternStore.createIndex("pagePropertyIndex", "pageProperty", { unique: false });
                        itemPatternStore.createIndex("UInameIndex", "UIname", { unique: false });
                        itemPatternStore.createIndex("isEditableIndex", "isEditable", { unique: false });
                        itemPatternStore.createIndex("parentIdIndex", "parentId", { unique: false });
                        itemPatternStore.createIndex("pageOrderIndex", "pageOrder", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });






                        console.log("Finished creating object-store - '" + cooConfig.PAGETABLENAME); // onupgradeneeded called first
                    }


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.STATUSTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.STATUSTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.STATUSTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false }); // email has to be unique (a constraint)
                        itemPatternStore.createIndex("statusNameIndex", "statusName", { unique: false });
                        itemPatternStore.createIndex("statusOrderIndex", "statusOrder", { unique: false });
                        itemPatternStore.createIndex("groupIdIndex", "groupId", { unique: false });
                        itemPatternStore.createIndex("parentIdIndex", "parentId", { unique: false });
                        itemPatternStore.createIndex("stypeIndex", "stype", { unique: false });
                        itemPatternStore.createIndex("data1Index", "data1", { unique: false });
                        itemPatternStore.createIndex("data2IdIndex", "data2", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });




                        console.log("Finished creating object-store - '" + cooConfig.STATUSTABLENAME); // onupgradeneeded called first
                    }


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.CUSERTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.CUSERTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.CUSERTABLENAME, { keyPath: "UserId" }); // key id ID

                        itemPatternStore.createIndex("UserNameIndex", "UserName", { unique: false });
                        itemPatternStore.createIndex("PassWordIndex", "PassWord", { unique: false }); // email has to be unique (a constraint)
                        itemPatternStore.createIndex("RoleIdsIndex", "RoleIds", { unique: false });
                        itemPatternStore.createIndex("XingMingIndex", "XingMing", { unique: false });
                        itemPatternStore.createIndex("departmentIdIndex", "departmentId", { unique: false });
                        itemPatternStore.createIndex("IsApprovedIndex", "IsApproved", { unique: false });
                        itemPatternStore.createIndex("familyIndex", "family", { unique: false });
                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });



                        console.log("Finished creating object-store - '" + cooConfig.CUSERTABLENAME); // onupgradeneeded called first
                    }


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.USERELEMENTTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.USERELEMENTTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.USERELEMENTTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("categoryIdIndex", "categoryId", { unique: false });
                        itemPatternStore.createIndex("isRelatedIndex", "isRelated", { unique: false });
                        itemPatternStore.createIndex("patternIdIndex", "patternId", { unique: false });
                        itemPatternStore.createIndex("pageIdIndex", "pageId", { unique: false });
                        itemPatternStore.createIndex("eorderIndex", "eorder", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });





                        console.log("Finished creating object-store - '" + cooConfig.USERELEMENTTABLENAME); // onupgradeneeded called first
                    }


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.CACHETABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.CACHETABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.CACHETABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("cacheNameIndex", "cacheName", { unique: false });
                        itemPatternStore.createIndex("cacheTimeIndex", "cacheTime", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.CACHETABLENAME); // onupgradeneeded called first
                    }


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.EVENTTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.EVENTTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.EVENTTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("eventSourceIndex", "eventSource", { unique: false });
                        itemPatternStore.createIndex("pageIdIndex", "pageId", { unique: false });
                        itemPatternStore.createIndex("eventTypeIndex", "eventType", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.EVENTTABLENAME); // onupgradeneeded called first
                    }


                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.TEMPLATETABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.TEMPLATETABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.TEMPLATETABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("filenameIndex", "filename", { unique: false });
                        itemPatternStore.createIndex("checkSumIndex", "checkSum", { unique: false });
                        itemPatternStore.createIndex("updateTimeIndex", "updateTime", { unique: false });
                        itemPatternStore.createIndex("ContentSizeIndex", "ContentSize", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.TEMPLATETABLENAME); // onupgradeneeded called first
                    }



                    if (!evt.currentTarget.result.objectStoreNames.contains(cooConfig.STATUSMAPTABLENAME)) {
                        console.log("Started creating object-store - '" + cooConfig.STATUSMAPTABLENAME);
                        var itemPatternStore = evt.currentTarget.result.createObjectStore(cooConfig.STATUSMAPTABLENAME, { keyPath: "ID" }); // key id ID

                        itemPatternStore.createIndex("patternIdIndex", "patternId", { unique: false });
                        itemPatternStore.createIndex("categoryIndex", "categoryId", { unique: false });
                        itemPatternStore.createIndex("companyIdIndex", "companyId", { unique: false });
                        itemPatternStore.createIndex("groupIdIndex", "groupId", { unique: false });
                        itemPatternStore.createIndex("depthIndex", "depth", { unique: false });
                        itemPatternStore.createIndex("initIndex", "init", { unique: false });
                        itemPatternStore.createIndex("tIndex", "t", { unique: false });

                        console.log("Finished creating object-store - '" + cooConfig.STATUSMAPTABLENAME); // onupgradeneeded called first
                    }




                };

                return dtd.promise();
            }
            catch (e) {
                console.log(e.message);
            }
        }
        else
        {

            $.when(initDatabaseMobile()).done(function () {
                dtd.resolve();
            });
            return dtd.promise();
        }

    }


    function remoteData(key,time) {

        var dtd = $.Deferred();

        var etor = {
            cachekey: key,
            ttt :time
        };

        $.ajax({
            url: cooConfig.configObj.url + 'cache/list',
            type: "post",
            data: JSON.stringify(etor),
            dataType: "json",
            contentType: "application/json;charset=utf-8",
            async: false,
            success: function (data) {
                //   ddt = data;
             //   console.log(data);
                dtd.resolve(data);

            },
            error: function (jqXHR, exception) {
                console.log(exception);
            }
        });

        return dtd.promise();
    };

    function populateDatabase(osTableName, jsonData) {

        var dtd = $.Deferred();

      //  console.log(osTableName);
      //  console.log(jsonData);

        if (!isMobile) {

            try {
                console.log(localDatabase.db != null);
                if (localDatabase != null && localDatabase.db != null) {
                    console.log('Started adding records');

                    var transaction = localDatabase.db.transaction(osTableName, "readwrite");
                    if (transaction) {
                        transaction.oncomplete = function () {

                            dtd.resolve();
                            //localDatabase.db.close();
                        }
                        transaction.onabort = function () {
                            console.log("transaction aborted.");
                            //    localDatabase.db.close();
                        }
                        transaction.ontimeout = function () {
                            console.log("transaction timeout.");
                            //  localDatabase.db.close();
                        }
                        var store = transaction.objectStore(osTableName);
                        if (store)
                            addData(transaction, store, jsonData, 0, true);
                    }


                    console.log('Finished adding records');
                }

                return dtd.promise();
            }
            catch (e) {
                console.log(e.message);
            }
        }
        else
        {
            //todo
            var insertStatement = "";
            var parameters = [];
            var bulkParameters = [];
            switch(osTableName)
            {
                case cooConfig.WORKFLOWTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.WORKFLOWTABLENAME + "(ID,companyId,categoryId,tagId1,tagId2,patternId,roleId,t) VALUES (?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].tagId1);
                        c.push(jsonData[i].tagId2);
                        c.push(jsonData[i].patternId);
                        c.push(jsonData[i].roleId);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.CATEGORYTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.CATEGORYTABLENAME + "(ID,companyId,categoryName,cOrder,status,eName,parentId,t,appId) VALUES (?,?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryName);
                        c.push(jsonData[i].cOrder);
                        c.push(jsonData[i].status == true ? 1 : 0);
                        c.push(jsonData[i].eName);
                        c.push(jsonData[i].parentId);
                        c.push(jsonData[i].t);
                        c.push(jsonData[i].appId);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.JOINTABLENAME:

                    insertStatement = "INSERT INTO j"  + cooConfig.JOINTABLENAME + "(ID,companyId,categoryId,joinPatternId,joinCategoryId,nRelation,t) VALUES (?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].joinPatternId);
                        c.push(jsonData[i].joinCategoryId);
                        c.push(jsonData[i].nRelation);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }

                    break;
                case cooConfig.DEPARTMENTTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.DEPARTMENTTABLENAME + "(ID,companyId,departmentName,departmentDesc,leader,parentId,t) VALUES (?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].departmentName);
                        c.push(jsonData[i].departmentDesc);
                        c.push(jsonData[i].leader);
                        c.push(jsonData[i].parentId);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.TAGTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.TAGTABLENAME + "(ID,companyId,tagName,tagCount,tagNote,categoryId,t) VALUES (?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].tagName);
                        c.push(jsonData[i].tagCount);
                        c.push(jsonData[i].tagNote);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.COOITEMPATTERNTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.COOITEMPATTERNTABLENAME + "(ID,companyId,categoryId,pName,pTypeId,pOrder,eName,validator,required,disabled,isUnique,isSortStatistic,t) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].pName);
                        c.push(jsonData[i].pTypeId);
                        c.push(jsonData[i].pOrder);
                        c.push(jsonData[i].eName);
                        c.push(jsonData[i].validator);
                        c.push(jsonData[i].required == true ? 1 : 0);
                        c.push(jsonData[i].disabled == true ? 1 : 0);
                        c.push(jsonData[i].isUnique == true ? 1 : 0);
                        c.push(jsonData[i].isSortStatistic == true ? 1 : 0);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.ELEMENTTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.ELEMENTTABLENAME + "(ID,companyId,categoryId,isRelated,patternId,pageId,eorder,t) VALUES (?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].isRelated == true ? 1 : 0);
                        c.push(jsonData[i].patternId);
                        c.push(jsonData[i].pageId);
                        c.push(jsonData[i].eorder);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.PAGETABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.PAGETABLENAME + "(ID,companyId,categoryId,pageName,pageType, pageProperty,UIname,isEditable,parentId,pageOrder,t) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].pageName);
                        c.push(jsonData[i].pageType);
                        c.push(jsonData[i].pageProperty);
                        c.push(jsonData[i].UIname);
                        c.push(jsonData[i].isEditable == true ? 1 : 0);
                        c.push(jsonData[i].parentId);
                        c.push(jsonData[i].pageOrder);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.STATUSTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.STATUSTABLENAME + "(ID_Pattern,ID,companyId,categoryId,statusName,statusOrder, patternId,parentId,stype,t) VALUES (?,?,?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID.toString() + '_' + jsonData[i].patternId);
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].statusName);
                        c.push(jsonData[i].statusOrder);
                        c.push(jsonData[i].patternId);
                        c.push(jsonData[i].parentId);
                        c.push(jsonData[i].stype);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.USERELEMENTTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.USERELEMENTTABLENAME + "(ID,companyId,categoryId,isRelated,patternId,pageId,eorder,t) VALUES (?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].categoryId);
                        c.push(jsonData[i].isRelated == true ? 1 : 0);
                        c.push(jsonData[i].patternId);
                        c.push(jsonData[i].pageId);
                        c.push(jsonData[i].eorder);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.CACHETABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.CACHETABLENAME + "(ID,companyId, cacheName ,cacheTime ) VALUES (?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].cacheName);
                        c.push(jsonData[i].cacheTime);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.EVENTTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.EVENTTABLENAME + "(ID,companyId, eventSource ,pageId ,eventType,t) VALUES (?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].eventSource);
                        c.push(jsonData[i].pageId);
                        c.push(jsonData[i].eventType);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.TEMPLATETABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.TEMPLATETABLENAME + "(ID,companyId, filename ,checkSum ,updateTime,ContentSize,t) VALUES (?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].ID);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].filename);
                        c.push(jsonData[i].checkSum);
                        c.push(jsonData[i].updateTime);
                        c.push(jsonData[i].ContentSize);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                case cooConfig.CUSERTABLENAME:
                    insertStatement = "INSERT INTO " + cooConfig.CUSERTABLENAME + "(UserId,companyId,PassWord ,family ,UserName,RoleIds,XingMing,departmentId,IsApproved,t) VALUES (?,?,?,?,?,?,?,?,?,?)";
                    for (var i in jsonData) {
                        var c = [];
                        c.push(jsonData[i].UserId);
                        c.push(jsonData[i].companyId);
                        c.push(jsonData[i].PassWord);
                        c.push(jsonData[i].family);
                        c.push(jsonData[i].UserName);
                        c.push(jsonData[i].RoleIds);
                        c.push(jsonData[i].XingMing);
                        c.push(jsonData[i].departmentId);
                        c.push(jsonData[i].IsApproved == true ? 1 : 0);
                        c.push(jsonData[i].t);
                        bulkParameters.push(c);
                    }
                    break;
                default: break;
            }

          //  insertStatement = "INSERT INTO " + cooConfig.CATEGORYTABLENAME + "(ID,companyId,categoryName,cOrder,status,eName,parentId,t,appId) VALUES (?,?,?,?,?,?,?,?,?)";

            $(bulkParameters).each(function (i, para) {
                localDatabase.mobileDb.transaction(function (tx) {
                    tx.executeSql(insertStatement, para, function () {
                    }, function (transaction, error) { console.log(osTableName + error.message + ' error!!'); });
                });
            });

            dtd.resolve();



            return dtd.promise();
        }




    }


    locdb.bulkDeleteByPatternId = function (TABLENAME, ids, pageId) {


        try {

            console.log(localDatabase.db != null);
            console.log(isMobile);

            var dtd = $.Deferred();


            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(TABLENAME, "readwrite").objectStore(TABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;

                            if (jQuery.inArray(ipattern.patternId, ids) != -1 && ipattern.pageId == pageId) {

                                store.delete(ipattern.ID);
                                //   console.log("remove id" + ipattern.ID + " pid" + ipattern.patternId);
                            }
                            cursor.continue();
                        }
                        else {

                            dtd.resolve();
                        }
                    };
                }
            }
            else
            {

                var idstr = ids.join(',');
                var deleteStatement = "DELETE FROM " + TABLENAME + " WHERE companyId=? and pageId=? and patternId in ("+idstr+")";
                console.log(idstr);
                localDatabase.mobileDb.transaction(function (tx) {
                    tx.executeSql(deleteStatement, [cooConfig.configObj.companyId, pageId], function () {
                        dtd.resolve();
                    }, function (tx, error) { console.log(error.message); });
                });

            }




            return dtd.promise();
        }
        catch (e) {
            console.log(e.message);
        }


    };




      locdb.pushTable = function(osTableName, jsonData) {

        var dtd = $.Deferred();

        console.log(osTableName);
        console.log(jsonData);

        try {
            console.log(localDatabase.db != null);


            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {
                    console.log('Started adding records');

                    var transaction = localDatabase.db.transaction(osTableName, "readwrite");
                    if (transaction) {
                        transaction.oncomplete = function () {

                            dtd.resolve();
                            //localDatabase.db.close();
                        }
                        transaction.onabort = function () {
                            console.log("transaction aborted.");
                            localDatabase.db.close();
                        }
                        transaction.ontimeout = function () {
                            console.log("transaction timeout.");
                            localDatabase.db.close();
                        }
                        var store = transaction.objectStore(osTableName);
                        if (store)
                            addData(transaction, store, jsonData, 0, true);
                    }
                    console.log('Finished adding records');
                }
            }
            else
            {
                console.log(osTableName);
                console.log(jsonData);
                $.when(populateDatabase(osTableName, jsonData)).done(function () {
                    dtd.resolve();
                });
            }


            return dtd.promise();
        }
        catch (e) {
            console.log(e.message);
        }
    }



      function clear(TABLENAME) {

          try {

              var keyIndex = 'ID';
              switch (TABLENAME) {
                  case 'cuser':
                      keyIndex = 'UserId';
                      break;
                  default: break;
              }

              var dtd = $.Deferred();


              if (!isMobile) {

                  console.log(localDatabase.db != null);
                  if (localDatabase != null && localDatabase.db != null) {

                      var store = localDatabase.db.transaction(TABLENAME, "readwrite").objectStore(TABLENAME);

                      store.openCursor().onsuccess = function (evt) {
                          var cursor = evt.target.result;
                          if (cursor) {
                              var ipattern = cursor.value;
                              if (ipattern.companyId == cooConfig.configObj.companyId) {
                                  store.delete(ipattern[keyIndex]);
                              }
                              cursor.continue();
                          }
                          else {

                              dtd.resolve();
                          }
                      };
                  }
              }
              else
              {
                  //mobile todo
                  if (TABLENAME == "join") TABLENAME = "jjoin";

                  var deleteStatement = "DELETE FROM " + TABLENAME + " WHERE companyId=?";
                  localDatabase.mobileDb.transaction(function (tx) {
                      tx.executeSql(deleteStatement, [cooConfig.configObj.companyId], function () {
                          dtd.resolve();
                      }, function (tx, error) { console.log(error.message); });
                  });



              }
              return dtd.promise();
          }
          catch (e) {
              console.log(e.message);
          }
      }




    function addData(txn, store, records, i, commitT) {
        try {
            if (i < records.length) {
                var rec = records[i];
                var req = store.add(rec);
                req.onsuccess = function (ev) {
                    i++;
                    addData(txn, store, records, i, commitT);
                }
                req.onerror = function (ev) {
                    console.log("Failed to add record." + "  Error: " + ev.message + JSON.stringify(records));
                }
            }
            else if (i == records.length) {
                console.log('Finished adding ' + records.length + " records");
            }
        }
        catch (e) {
            console.log(e.message);
        }
    }







    function checkSchema2(osTableName,local,remote)
    {



        var dtd = $.Deferred();
        var c1 = cacheNameCompare(local, osTableName);
        var c2 = cacheNameCompare(remote, osTableName);

        if (osTableName == cooConfig.STATUSMAPTABLENAME)
        {
            c1 = cacheNameCompare(local, cooConfig.STATUSTABLENAME);
            c2 = cacheNameCompare(remote, cooConfig.STATUSTABLENAME);
        }

        var t = '2013-01-01';
        var updateFlag = false;
        if (c1.length == 0) { updateFlag = true; }
        else { if (c2.length > 0 && Date.parse(c1[0].cacheTime) != Date.parse(c2[0].cacheTime)) { updateFlag = true;  } }

        if (updateFlag)
        {
            $.when(remoteData(osTableName, t)).done(function (data) {



                if (data.add.length > 0) {

                    switch(osTableName)
                    {
                        case cooConfig.CUSERTABLENAME:
                            $(data.add).each(function (i, o) {
                                o['companyId'] = parseInt(o.UserName.replace(/:.+$/ig, ''));
                            });
                            break;
                    }


                    $.when(clear(osTableName)).done(function () {
                        $.when(populateDatabase(osTableName, data.add)).done(function () {

                            dtd.resolve(true);
                        });
                    });
                } else {
                    dtd.resolve(false);
                }
            });


        }
        else {
            dtd.resolve(false);
        }

        return dtd.promise();
    }




    function checkSchema(osTableName) {

        var dtd = $.Deferred();
        $.when(maxDateTime(osTableName)).done(function (t) {

            if (osTableName == 'cuser') {
                dtd.resolve();
                return;
            }
            else {
                $.when(remoteData(osTableName, t)).done(function (data) {

                    if (data.add.length > 0) {
                        $.when(populateDatabase(osTableName, data.add)).done(function () {
                            dtd.resolve();
                        });

                    } else {
                        dtd.resolve();
                    }
                });
            }
        });

        return dtd.promise();

    };



    function initData () {

        var dtd = $.Deferred();

        $.when(checkSchema(cooConfig.CUSERTABLENAME), checkSchema(cooConfig.STATUSTABLENAME), checkSchema(cooConfig.COOITEMPATTERNTABLENAME), checkSchema(cooConfig.ELEMENTTABLENAME), checkSchema(cooConfig.PAGETABLENAME), checkSchema(cooConfig.TAGTABLENAME), checkSchema(cooConfig.DEPARTMENTTABLENAME), checkSchema(cooConfig.CATEGORYTABLENAME),
             checkSchema(cooConfig.JOINTABLENAME), checkSchema(cooConfig.WORKFLOWTABLENAME) ).done(function () {

            console.log('schema sync');

            dtd.resolve();
        });
        return dtd.promise();
    };



    function cacheCompare($caches,$item)
    {
        return $caches.filter(function (v) {
            return v.cacheName.toLowerCase() == $item.cacheName.toLowerCase();
        });
    }

    function cacheNameCompare($list, $name)
    {
        return $list.filter(function (v) {
            return v.cacheName.toLowerCase() == $name.toLowerCase();
        });
    }


    function initData2()
    {

        var dtd = $.Deferred();
        $.when(remoteData('cacheTime', '2013-01-01')).done(function (ret) {

            $.when(fetchAllCache()).done(function (caches) {



                //todo
                var result = ret.add;
                console.log(result);
                if (caches == null || caches.length == 0) caches = [];
                if (result == null || result.length == 0) result = [];
                $.when(checkSchema2(cooConfig.CATEGORYTABLENAME, caches, result),
                    checkSchema2(cooConfig.WORKFLOWTABLENAME, caches, result),
                    checkSchema2(cooConfig.JOINTABLENAME, caches, result),
                    checkSchema2(cooConfig.DEPARTMENTTABLENAME, caches, result),
                    checkSchema2(cooConfig.TAGTABLENAME, caches, result),
                    checkSchema2(cooConfig.PAGETABLENAME, caches, result),
                    checkSchema2(cooConfig.ELEMENTTABLENAME, caches, result),
                    checkSchema2(cooConfig.COOITEMPATTERNTABLENAME, caches, result),
                    checkSchema2(cooConfig.STATUSTABLENAME, caches, result),
                    checkSchema2(cooConfig.CUSERTABLENAME, caches, result),
                    checkSchema2(cooConfig.EVENTTABLENAME, caches, result),
                    checkSchema2(cooConfig.TEMPLATETABLENAME, caches, result),
                    checkSchema2(cooConfig.STATUSMAPTABLENAME, caches, result)
                    ).done(function (a, b, c, d, e, f, g, h, i, j, k, l,m) {

                        if (a || b || c || d || e || f || g || h || i || j || k || l || m) {
                            $.when(clear(cooConfig.CACHETABLENAME)).done(function () {
                                populateDatabase(cooConfig.CACHETABLENAME, result);
                            });
                        }

                        dtd.resolve();


                });

            });

        });

        return dtd.promise();
    };





    function maxDateTime (osTableName) {

        //todo


        var dtd = $.Deferred();

        if (localDatabase != null && localDatabase.db != null) {
            var transaction = localDatabase.db.transaction(osTableName);
            if (transaction) {
                transaction.oncomplete = function () {
                }
                transaction.onabort = function () {
                    console.log("transaction aborted.");
                    localDatabase.db.close();
                }
                transaction.ontimeout = function () {
                    console.log("transaction timeout.");
                    localDatabase.db.close();
                }
                var store = transaction.objectStore(osTableName);
                if (store) {
                    var keyRange = IDBKeyRange.lowerBound(0);
                    var cursorRequest = store.openCursor(keyRange);
                    var t = '2011-04-11';

                    cursorRequest.onsuccess = function (e) { // success called for each cursor action
                        var result = e.target.result;
                        if (result) {
                            if (result.value.t!=undefined && Date.parse(result.value.t) > Date.parse(t)) t = result.value.t;
                            result.continue();
                        }
                        else {
                          //  console.log(osTableName + ':' + t);
                            dtd.resolve(t);
                        }
                    };
                }
            }
            return dtd.promise();
        }
        else {
            console.log("Database needs to be created first");
        }

    };





    locdb.countRecords = function (osTableName) {

        var dtd = $.Deferred();

        if (localDatabase != null && localDatabase.db != null) {
            console.log("Starting count");
            var transaction = localDatabase.db.transaction(osTableName);
            if (transaction) {
                transaction.oncomplete = function () {
                }
                transaction.onabort = function () {
                    console.log("transaction aborted.");
                    localDatabase.db.close();
                }
                transaction.ontimeout = function () {
                    console.log("transaction timeout.");
                    localDatabase.db.close();
                }
                var store = transaction.objectStore(osTableName);
                if (store) {
                    var keyRange = IDBKeyRange.lowerBound(0);
                    var cursorRequest = store.openCursor(keyRange);
                    var count = 0;

                    cursorRequest.onsuccess = function (e) { // success called for each cursor action
                        var result = e.target.result;
                        if (result) {
                            ++count && result.continue();
                        }
                        else {
                            console.log(osTableName + ':' + count);
                            dtd.resolve(count);
                        }
                    };
                }
            }
            return dtd.promise();
        }
        else {
            console.log("Database needs to be created first");
        }
    };







    function fetchAllWorkFlows() {
        try {
            var dtd = $.Deferred();
            var ret = [];


            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.WORKFLOWTABLENAME).objectStore(cooConfig.WORKFLOWTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.WORKFLOWTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }




    function fetchAllCategories() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.CATEGORYTABLENAME).objectStore(cooConfig.CATEGORYTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.CATEGORYTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    function fetchAllDepartments() {
        try {
            var dtd = $.Deferred();
            var ret = [];


            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.DEPARTMENTTABLENAME).objectStore(cooConfig.DEPARTMENTTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.DEPARTMENTTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    function fetchAllTags() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.TAGTABLENAME).objectStore(cooConfig.TAGTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.TAGTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }



    function fetchAllJoins() {
        try {
            var dtd = $.Deferred();
            var ret = [];


            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.JOINTABLENAME).objectStore(cooConfig.JOINTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM j" + cooConfig.JOINTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }
                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }



    function fetchAllPatterns() {
        try {
            var dtd = $.Deferred();
            var ret = [];


            if (!isMobile) {

                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.COOITEMPATTERNTABLENAME).objectStore(cooConfig.COOITEMPATTERNTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else
            {
                var selectStatement = "SELECT * FROM " + cooConfig.COOITEMPATTERNTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                       var  dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }


                        return dtd.resolve(ret);
                    });

                });
            }



            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    function fetchAllPages() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {

                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.PAGETABLENAME).objectStore(cooConfig.PAGETABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.PAGETABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }



            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    function fetchAllElements() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.ELEMENTTABLENAME).objectStore(cooConfig.ELEMENTTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.ELEMENTTABLENAME+ " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }





            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    function fetchAllStatus() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.STATUSTABLENAME).objectStore(cooConfig.STATUSTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.STATUSTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }



    function fetchAllUsers() {
        try {
            var dtd = $.Deferred();
            var ret = [];


            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.CUSERTABLENAME).objectStore(cooConfig.CUSERTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.CUSERTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    function fetchAllCache() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile)
            {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.CACHETABLENAME).objectStore(cooConfig.CACHETABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else
            {
                var selectCacheStatement = "SELECT * FROM "+ cooConfig.CACHETABLENAME + " where companyId = ?";
                var dataset;
                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectCacheStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {

                            item = dataset.item(i);
                            ret.push(item);
                        }
                        dtd.resolve(ret);
                    });
                });

            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    };








    function fetchAllStatusMap()
    {
        try {
            var dtd = $.Deferred();
            var ret = [];


                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.STATUSMAPTABLENAME).objectStore(cooConfig.STATUSMAPTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }

            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }



    }







    function fetchAllEvent() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.EVENTTABLENAME).objectStore(cooConfig.EVENTTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.EVENTTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    };



    function fetchAllUserElements() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {

                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.USERELEMENTTABLENAME).objectStore(cooConfig.USERELEMENTTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            if (ipattern.companyId == cooConfig.configObj.companyId) ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.USERELEMENTTABLENAME+ " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    locdb.fetchAllUserElements= function() {
        try {
            var dtd = $.Deferred();
            var ret = [];

            if (!isMobile) {
                if (localDatabase != null && localDatabase.db != null) {

                    var store = localDatabase.db.transaction(cooConfig.USERELEMENTTABLENAME).objectStore(cooConfig.USERELEMENTTABLENAME);

                    store.openCursor().onsuccess = function (evt) {
                        var cursor = evt.target.result;
                        if (cursor) {
                            var ipattern = cursor.value;
                            ret.push(ipattern);
                            cursor.continue();
                        }
                        else {
                            dtd.resolve(ret);
                        }
                    };
                }
            }
            else {
                var selectStatement = "SELECT * FROM " + cooConfig.USERELEMENTTABLENAME + " WHERE companyId=?";

                localDatabase.mobileDb.transaction(function (tx) {

                    tx.executeSql(selectStatement, [cooConfig.configObj.companyId], function (tx, result) {

                        var dataset = result.rows;

                        for (var i = 0, item = null; i < dataset.length; i++) {
                            item = dataset.item(i);
                            ret.push(item);
                        }

                        return dtd.resolve(ret);
                    });

                });
            }
            return dtd.promise();

        }
        catch (e) {
            console.log(e.message);
        }
    }


    locdb.start = function () {

        var dtd = $.Deferred();



        if (cooConfig.configObj.isStart) {
            console.log('starting');
            dtd.resolve(true);
        }
        else {
             g.showAjax();

            $.when(login.autoLogin()).done(function (isAuto) {

                if (isAuto) {



                    $.when(initDatabase()).done(function () {

                        $.when(initData2()).done(function () {




                            $.when(fetchAllPatterns(), fetchAllPages(), fetchAllElements(), fetchAllStatus(), fetchAllUsers(), fetchAllUserElements(), fetchAllCategories(), fetchAllDepartments(), fetchAllTags(), fetchAllJoins(), fetchAllWorkFlows(), fetchAllEvent(),fetchAllStatusMap()).done(function (a, b, c, d, e, f, g, h, i, j, k, l,m) {


                                cooConfig.allpattern = a;
                                cooConfig.allpage = b;
                                cooConfig.allelement = c;
                                cooConfig.allstatus = d;
                                cooConfig.alluser = e;
                                cooConfig.alluserelement = f;
                                cooConfig.allcategory = g;
                                cooConfig.alldepartment = h;
                                cooConfig.alltag = i;
                                cooConfig.alljoin = j;
                                cooConfig.allworkflow = k;
                                cooConfig.allevent = l;
                                cooConfig.allstatusmap = m;
                                //     console.log('init');
                                cooConfig.configObj.isStart = true;

                                console.log('finish init');
                               g.hideAjax();
                                dtd.resolve(true);
                            });

                        });
                    });
                }
                else
                {
                    g.hideAjax();
                    dtd.resolve(false);
                }
            });
        }
        return dtd.promise();


    }






    locdb.sayHello = function () {

        console.log('helo');

    };


    return locdb;

});
