app.controller('folderModalInstanceCtrl', ['$scope', '$modalInstance', 'items', function($scope, $modalInstance, items) {


        $scope.ok = function () {
          $modalInstance.close($scope.folderName);
        };

        $scope.cancel = function () {
          $modalInstance.dismiss('cancel');
        };
}])
;

app.controller('FileCtrl', ['$scope', '$http','$sce','$stateParams','$state','$upload' ,'$modal','rest','g','cooConfig', function($scope, $http,$sce, $stateParams,$state ,$upload ,$modal ,rest,g,cooConfig) {

       $scope.note ={ title:'北极光文件管理 ',content:'',filename:''};
       $scope.isFolder = 0;


       console.log($scope.app);

       $scope.editorOptions = {
         lineNumbers: true,
         matchBrackets: true,
         styleActiveLine: true,
         theme:"ambiance",
         mode:    "text/javascript",
         extraKeys: {"Ctrl-Q": function(cm){ cm.foldCode(cm.getCursor()); }},
         foldGutter: true,
         gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"]

      };


      $scope.codemirrorLoaded = function(_editor){
           $scope._editor = _editor;

           _editor.on('cursorActivity', function() {
                var doc =_editor.getDoc();
                var A1 = _editor.getCursor();
           });
      };

      var  upload_promise= function(file)
      {
          var dtd = $.Deferred();

        var vs = JSON.stringify(file);
        console.log(vs);


          $upload.upload({
              url: cooConfig.configObj.url + 'file/jcreateevent',
              fields: {
                  key: cooConfig.configObj.uploadKey,
                  itemId: 0,
                  cateId: 0,
                  eventKey: $scope.currentNode.fileKey,
                  pathType :$scope.currentNode.pathType,
                  relativePath :$scope.currentNode.path
              },
              file: file
          }).progress(function (evt) {
              var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
              console.log('progress: ' + progressPercentage + '% ' + evt.config.file.name);
          }).success(function (data, status, headers, config) {

                  dtd.resolve(data);

           });
           return dtd.promise();



      };



        $scope.xupload = function (files) {

          //  console.log(files);

              if (files.length>0){

                  g.show_ajax();

                  var promises= [];
                  for (var i = 0; i < files.length; i++) {
                      var file = files[i];
                       promises.push(upload_promise(file));
                  };


                  $.when.apply($, promises).done(function() {
                      console.log(arguments);
                      g.hide_ajax();
                      $scope.initData();
                      g.modal1("已保存")

                  });


              }
        };



 $scope.viewDoc = function(itemId){



   $.when(rest.detail(372,itemId)).done(function(ret){

        $scope.note  =  { title: ret.data.__c454, date: ret.data.__c458  ,content : $sce.trustAsHtml(ret.data.__c455) };
        $scope.$$phase || $scope.$apply();

   });
 }


 $scope.langChange = function(){
     $scope.initData();
 }

  $scope.parseTemplate = function(){

       var etor = { data :'33333'};
        g.show_ajax();
        $.when(rest.remote_data(etor,'gateway/parseTemplate')).done(function(ret){
               g.hide_ajax();
               g.modal1("已更新");
               $scope.initData();
               $scope.$$phase || $scope.$apply();

        });
  }

  $scope.createFolder = function(){




      var modalInstance = $modal.open({
        templateUrl: 'folderModalContent.html',
        controller: 'folderModalInstanceCtrl',
        size:'sm',
        resolve: {
          items: function () {
            return $scope.items;
          }
        }
      });

      modalInstance.result.then(function (fname) {

              var rx =/^[_a-zA-Z0-9]+$/ig;
              if (fname &&  rx.test(fname)){

                var etor  =$scope.currentNode;
                etor.name = fname;
                g.show_ajax();

                $.when(rest.remote_data(etor,'gateway/createfile')).done(function(ret){
                       g.hide_ajax();
                       g.modal1(ret.message);
                       $scope.initData();
                       $scope.$$phase || $scope.$apply();

                });
              }




      }, function () {
        $log.info('Modal dismissed at: ' + new Date());
      });







  }

  $scope.codeSave = function(){



          var etor  =$scope.currentNode;
          etor.data = $scope.code;
          g.show_ajax();

          $.when(rest.remote_data(etor,'gateway/savefile')).done(function(ret){

                g.hide_ajax();
                g.modal1(ret.message);


                 $scope.$$phase || $scope.$apply();


          });



  }


  $scope.select_node = function(node, selected, event) {



     console.log(selected.selected);

  //   $scope.viewDoc(selected.selected[0]);

     var cnode = _.find($scope.rawData ,function(n){ return n.path==selected.selected});
     console.log(cnode);
      $scope.note.filename = cnode.name;
      $scope.currentNode = cnode;

      if ($scope.currentNode.path.indexOf(".js")>0 || $scope.currentNode.path.indexOf(".html")>0 || $scope.currentNode.path.indexOf(".css")>0 )
      {
          $scope.isFolder = 1;
          $.when(rest.remote_data(cnode,'gateway/fileinfo')).done(function(ret){

                 $scope.code = ret.data;
                 $scope.$$phase || $scope.$apply();


          });
      }
      else{
          $scope.isFolder = 2;
          $scope.$$phase || $scope.$apply();
      }










 };




 $scope.initData = function(){

          var etor = { key : '33333'};
             $scope.treeDatax = [] ;
                g.show_ajax();

          $.when(rest.remote_data(etor,'gateway/myfiles')).done(function(ret){
            $scope.rawData =ret;

            $(ret).each(function(i,j){


                  var t1 =  j.fileKey.split('.');
                   t1.splice(t1.length-1, 1);

                  var parentText = t1.join('.');
                  var parentNode =null;
                  var isLeaf =  j.name.indexOf('.')>=0;
                  if (!isLeaf){
                    parentNode = _.find(ret,function(n) { return n.fileKey== parentText && n.name.indexOf('.')<0 } );
                  } else{
                    parentNode = _.find(ret,function(n) { return n.fileKey== j.fileKey && n.name.indexOf('.')<0 } );
                  }

                  var parentId =   parentNode? parentNode.path:'#' ;
                  var opened = t1.length==0 ?true:false;
                  var fileType= isLeaf?"css":"";

                  var depth = (t1.length +1) * 2 ;
                  depth += (isLeaf?1:-2);
                  $scope.treeDatax.push({
                      "id": j.path,
                      "parent": parentId.toString(),
                      "text":  j.name,
                      "state": {
                          "opened": opened
                      },
                      "type": fileType,
                      "__uiNodeId": j.path,
                      "depth": depth

                  });



            });



            $scope.treeDatax =  _.sortBy($scope.treeDatax,'depth');
            $scope.treeData =   $scope.treeDatax;

            console.log(  $scope.treeData );



            $scope.treeInstance.jstree(true).settings.core.data = $scope.treeData;
            $scope.treeInstance.jstree(true).refresh();
    });







         g.hide_ajax();





 }

 $scope.initData();



  $scope.treeConfig = {
      'plugins' : [ 'types', 'dnd' ],
      'types' : {
          'default' : {
              'icon' : 'fa fa-folder'
          },
          'html' : {
              'icon' : 'fa fa-file-code-o'
          },
          'svg' : {
              'icon' : 'fa fa-file-picture-o'
          },
          'css' : {
              'icon' : 'fa fa-file-code-o'
          },
          'img' : {
              'icon' : 'fa fa-file-image-o'
          },
          'js' : {
              'icon' : 'fa fa-file-text-o'
          }

      },
       version : 1
  };





  $scope.colors = ['primary', 'info', 'success', 'warning', 'danger', 'dark'];

  $scope.createNote = function(){
    var note = {
      content: 'New note',
      color: $scope.colors[Math.floor((Math.random()*3))],
      date: Date.now()
    };
    $scope.notes.push(note);
    $scope.selectNote(note);
  }

  $scope.deleteNote = function(note){
    $scope.notes.splice($scope.notes.indexOf(note), 1);
    if(note.selected){
      $scope.note = $scope.notes[0];
      $scope.notes.length && ($scope.notes[0].selected = true);
    }
  }

  $scope.selectNote = function(note){
    angular.forEach($scope.notes, function(note) {
      note.selected = false;
    });
    $scope.note = note;
    $scope.note.selected = true;
  }

}]);
