app.controller('MailCtrl', ['$scope', function($scope) {
  $scope.folds = [
    {name: '所有未读', filter:'unread',class:'glyphicon glyphicon-folder-close'},
    {name: '收件箱', filter:'',class:'glyphicon glyphicon-inbox'},
    {name: '星号消息', filter:'starred' ,class:'glyphicon glyphicon-star-empty'},
    {name: '已发送', filter:'sent' ,class:'glyphicon glyphicon-send'},
    {name: '草稿', filter:'draft' ,class:'fa fa-file-text-o'},
    {name: '回收站', filter:'trash' ,class:'fa fa-trash-o'}
  ];

  $scope.labels = [
    {name: '订单消息', filter:'570', color:'#23b7e5'},
    {name: '加好友消息', filter:'596', color:'#7266ba'},
    {name: '系统消息', filter:'597', color:'#fad733'},
    {name: '其他消息', filter:'598', color:'#27c24c'}
  ];

  $scope.addLabel = function(){
    $scope.labels.push(
      {
        name: $scope.newLabel.name,
        filter: angular.lowercase($scope.newLabel.name),
        color: '#ccc'
      }
    );
    $scope.newLabel.name = '';
  }

  $scope.labelClass = function(label) {

    return {
      'b-l-info':  label  === 570,
      'b-l-primary': label  === 596,
      'b-l-warning': label  === 597,
      'b-l-success': label  === 598,
    };
  };

}]);

app.controller('MailListCtrl', ['$rootScope','$scope', 'mails', '$stateParams','rest','g', function($rootScope,$scope, mails, $stateParams,rest,g) {
  $scope.fold = $stateParams.fold;

  console.log($stateParams.fold);

  var lsc = [];
  switch ($stateParams.fold) {
    case 'unread':
         lsc.push({patternId: 242, val1: false, pTypeId: 1, operation: 1});
      break;
      case 'starred':
         lsc.push({patternId: 237, val1: true, pTypeId: 1, operation: 1});
      break;
      case 'sent':
         lsc.push({patternId: 238, val1: "560", pTypeId: 2, operation: 5});
      break;
      case 'draft':
         lsc.push({patternId: 238, val1: "562", pTypeId: 2, operation: 5});
      break;
      case 'trash':
         lsc.push({patternId: 238, val1: "563", pTypeId: 2, operation: 5});
      break;
      case '570':
           lsc.push({patternId: 212, val1: "570", pTypeId: 2, operation: 5});
      break;
      case '596':
           lsc.push({patternId: 212, val1: "596", pTypeId: 2, operation: 5});
      break;
      case '597':
           lsc.push({patternId: 212, val1: "597", pTypeId: 2, operation: 5});
      break;
      case '598':
           lsc.push({patternId: 212, val1: "598", pTypeId: 2, operation: 5});
      break;

    default:

  }

   $scope.startIndex =1;
   $scope.total_pages=1;


    $scope.agree = function(mail)
    {
      console.log(mail);

        var RetArray =[];
        RetArray.push({_Key:'__c203',_Value:mail.__c126});

        var etor = {
             itemId:0,
             pageId:193,
             jsonStr:JSON.stringify(RetArray),
             relatedSTR:"[]"
        };

        $.when(rest.create(etor)).done(function(ret){
                $scope.renderList();
        });
    }


    $scope.deny =function(mail)
    {
          var RetArray =[];
          RetArray.push({_Key:'__c124',_Value:602 });

          var etor = {
               itemId:mail.__c118,
               pageId:85,
               jsonStr:JSON.stringify(RetArray),
               relatedSTR:"[]"
          };

          $.when(rest.create(etor)).done(function(ret){
                  $scope.renderList();
          });
    }

   $scope.read = function(mail){
       var RetArray= [];
       RetArray.push({_Key:"__c240",_Value:mail.server_identity});
       RetArray.push({_Key:"__c242",_Value:true});
       var etor = {
           jsonStr: JSON.stringify(RetArray),
           relatedSTR: "[]",
           pageId: 224,
           itemId: 0
       };

       g.show_ajax();
       $.when(rest.create(etor)).done(function(){
            $scope.renderList();
       });
   }

   $scope.star = function(mail){
       var new_value = mail.__c237?false:true;
       var RetArray= [];
       RetArray.push({_Key:"__c240",_Value:mail.server_identity});
       RetArray.push({_Key:"__c237",_Value:new_value});
       var etor = {
           jsonStr: JSON.stringify(RetArray),
           relatedSTR: "[]",
           pageId: 224,
           itemId: 0
       };
       g.show_ajax();
       $.when(rest.create(etor)).done(function(){
            $scope.renderList();
       });
   }


   $scope.del = function(mail){

       var RetArray= [];
       RetArray.push({_Key:"__c240",_Value:mail.server_identity});
       RetArray.push({_Key:"__c238",_Value:563});
       var etor = {
           jsonStr: JSON.stringify(RetArray),
           relatedSTR: "[]",
           pageId: 224,
           itemId: 0
       };
       g.show_ajax();
       $.when(rest.create(etor)).done(function(){
            $scope.renderList();
       });
   }

  $scope.page = function(add){

    if (add==-1)
    {
       if ($scope.startIndex>1) $scope.startIndex-=1;
    }

    if (add==1){
       if ($scope.startIndex<$scope.total_pages)
          $scope.startIndex+=1;
    }

    $scope.renderList();


  }


   $scope.renderList = function()
   {

     var pageId = 86;
     var sc =_.find(lsc,function(n){ return n.patternId==238 });
     if (sc) pageId =231;

     g.show_ajax();
     $.when(rest.search(13,pageId,lsc,$scope.startIndex,15)).done(function(ret){

          g.hide_ajax();
          $scope.vdata2 =ret.data;

          var total =parseInt(ret.s.replace(/\D/ig,''));
           $scope.total_pages = total/ 15 ;
           $scope.total =total;

           if ($stateParams.fold=='unread'){
               $rootScope.message_count = total;
           }


          $($scope.vdata2).each(function(i,j){
            if (j.__c122)
             j.__c122 = j.__c122.replace(/<[^>]+>/ig,'');
          });

          $scope.$$phase || $scope.$apply();
     });
   }

      $scope.renderList();


}]);

app.controller('MailDetailCtrl', ['$scope', 'mails', '$stateParams','rest','$sce', function($scope, mails, $stateParams,rest,$sce) {


     $.when(rest.detail2( 236, $stateParams.mailId )).done(function(ret){
          $scope.mail =ret.data;
          $scope.mail.__c122 = $sce.trustAsHtml($scope.mail.__c122);

          if ($scope.mail.__c206)
          {
             $($scope.mail.__c206).each(function(i,j){
                  j.RawFilePath =   j.FilePath.replace(/\/100/ig,'');
                  var rx =/jpg|jpeg|bmp|png/ig;
                  if (rx.test(j.FilePath))  j.is_image =true;
             });
          }

          $scope.$$phase || $scope.$apply();

     });


}]);

app.controller('MailNewCtrl', [ '$scope','$stateParams','$timeout','g_write','rest','g', function( $scope,$stateParams,$timeout,g_write,rest,g) {


    $scope.pageId = 84;
    $scope.categoryId = 13;
    $scope.itemId = 0;

    $scope.tolist =[];

    $scope.name = $stateParams.name;
    $scope.email = $stateParams.email;

    $scope.udf_after_render = function(){

              if (!$scope.name)
              {
                g.show_ajax();
                $.when(rest.bi({pageId:235,lscStr:"[]"})).done(function(ret){

                     console.log(ret.data);
                      $scope.tolist=[];
                      $(ret.data).each(function(i,j){
                         $scope.tolist.push({name:j.c41,email:j.c120});
                      });
                      $scope.$$phase || $scope.$apply();
                      g.hide_ajax();
                      $("#__c120").trigger("chosen:updated");

                });
              }
              else {
                $scope.tolist=[{name:$scope.name,email:$scope.email}];
                var element = _.find($scope.elements,function(n){ return n.p.ID==120});
                element.val = $scope.email;
                element['e']  ="e";
                $scope.$$phase || $scope.$apply();

                $timeout(function(){
                    $("#__c120").val($scope.email);
                    $("#__c120").trigger("chosen:updated");
                }, 300);
              }

    }


    $scope.udf_format = function(RetArray)
    {
          var row = _.find(RetArray,function(n){ return n._Key=='__c120'}) ;
          if (row)
          {
            row._Value = row._Value[0];
          }
          return RetArray;

    }


    $scope.select_recieve = function(element)
    {
            console.log("ss1");
    }

    $scope.save = function()
    {
      console.log($scope.elements);
    }

    g_write.init_write($scope);


    console.log($scope.elements);



  $scope.mail = {
    to: '',
    subject: '',
    content: ''
  }

}]);

angular.module('app').directive('labelColor', function(){
  return function(scope, $el, attrs){
    $el.css({'color': attrs.color});
  }
});
