'use strict';

/**
 * Config for the router
 */
angular.module('app')
  .run(
    [          '$rootScope', '$state', '$stateParams',
      function ($rootScope,   $state,   $stateParams) {
          $rootScope.$state = $state;
          $rootScope.$stateParams = $stateParams;
      }
    ]
  )
  .config(
    [          '$stateProvider', '$urlRouterProvider', 'JQ_CONFIG', 'MODULE_CONFIG',
    'cooConfig' ,
      function ($stateProvider,   $urlRouterProvider, JQ_CONFIG, MODULE_CONFIG ,cooConfig  ) {

         var version = cooConfig.configObj.version;

         var appVersion = cooConfig.configObj.edition;
         var otherRouter = '/app/dashboard-v3';
         if (cooConfig.app.otherRouter){
            otherRouter = cooConfig.app.otherRouter;
         }

          var layout = "tpl/app.html?"+version;
          if(appVersion && appVersion.length){
            layout = "tpl/app.v2.html?"+version;
            $urlRouterProvider
              .otherwise(otherRouter);
          }else{
            $urlRouterProvider
              .otherwise(otherRouter);
          }


          var  fetch3 = function(osTableName){
              var ret = [];
              var filename = cooConfig.configObj.companyId + "." + osTableName;
              var str = amplify.store(filename);
              if (str != undefined && str != "") {
                  ret = JSON.parse(str);
              }
              return ret;
          };

         var remote_data=function(etor,url)
          {
            var dtd = $.Deferred();
            $.ajax({
                url: cooConfig.configObj.url + url,
                type: "post",
                data: JSON.stringify(etor),
                dataType: "json",
                contentType: "application/json;charset=utf-8",
                success: function (data) {
                    dtd.resolve(data);
                },
                error: function (jqXHR, exception) {
                    console.log(exception);
                }
            });
            return dtd.promise();
          }



          var xx=" var a=1 ; var b =2 ; console.log(a+b);";

          var states = [
{ name: 'app.main', url: '/main', templateUrl: 'tpl/app_dashboard_v1.html?'+version,
  resolve: load(['js/controllers/chart.js?'+version],function(){ eval(xx); })
 }
];



         var customState1 = false;




        if (!cooConfig.allroute||cooConfig.allroute.length==0)
        {
           var rt = fetch3(cooConfig.ROUTETABLENAME);
           if (!rt||rt.length==0)
           {
               var etor ={      cachekey: 'page',      ttt: '2013-01-01'  ,pc : true   };
               $.when(remote_data(etor,'cache/list2')).done(function(ret){


                   angular.forEach(ret.route, function (state) {
                           var _obj = JSON.parse(state.panelProperty);
                           var resolve_args =_obj.resolve.replace(/\s/ig,'').split(',');
                           var new_args =[];
                           $(resolve_args).each(function(x,y){
                                y =y.replace(/(\.js|\.html)/ig,'$1?'+version);
                                new_args.push(y);
                           });


                           var _func = _obj.func?_obj.func:'';
                           var state_obj = {
                             name: state.panelName, url: _obj.url, templateUrl: _obj.templateUrl +'?'+version,
                             resolve: load(new_args,function(){ eval(_func); })
                            }

                            console.log(state.panelName);

                            if (state.panelName=='app.dashboard-v1') customState1 =true;
                            $stateProvider.state(state.panelName, state_obj);
                      });

                      if (!customState1){
                            $stateProvider.state('app.dashboard-v1', {
                              url: '/dashboard-v1',
                              templateUrl: 'tpl/app_dashboard_v1.html?'+version,
                              resolve: load(['js/controllers/chart.js?'+version,'moment'])
                          });
                      }
               });
           }
           else {




             angular.forEach(rt, function (state) {
                   var _obj = JSON.parse(state.panelProperty);
                   var _func = _obj.func?_obj.func:'';
                   var resolve_args =_obj.resolve.replace(/\s/ig,'').split(',');
                   var new_args =[];
                   $(resolve_args).each(function(x,y){
                        y =y.replace(/(\.js|\.html)/ig,'$1?'+version);
                        new_args.push(y);
                   });



                   var state_obj = {
                       name: state.panelName, url: _obj.url, templateUrl: _obj.templateUrl+'?'+version,
                       resolve: load(new_args,function(){ eval(_func); })
                    }

                    console.log(state_obj);
                    if (state.panelName=='app.dashboard-v1') customState1 =true;
                    $stateProvider.state(state.panelName, state_obj);
               });

               if (!customState1){
                     $stateProvider.state('app.dashboard-v1', {
                       url: '/dashboard-v1',
                       templateUrl: 'tpl/app_dashboard_v1.html?'+version,
                       resolve: load(['js/controllers/chart.js?'+version,'moment'])
                   });
               }
           }
        }


       if (cooConfig.configObj.design.login==true)
       {
         $stateProvider.state('access.signin', {
             url: '/signin',
             templateUrl: 'design/'+cooConfig.configObj.companyId+'/tmpl/page_signin.html?'+version,
             resolve: load( ['design/'+cooConfig.configObj.companyId+'/js/signin.js?'+version] )
         });

       }
       else {

         $stateProvider.state('access.signin', {
             url: '/signin?{version}',
             templateUrl: 'design/tpl/page_signin.html?'+version,
             resolve: load( ['design/js/controllers/signin.js?'+version] )
         });

       }

        // console.log(cooConfig.allroute);

        $stateProvider.state('access.signin2', {
            url: '/signin2',
            templateUrl: 'tpl/page_signin.html?'+version,
            resolve: load( ['design/js/controllers/signin.js?'+version] )
        });









          $stateProvider
              .state('design', {
                  // abstract: true,
                  url: '/design',
                  templateUrl: layout
              })
              .state('app', {
                  abstract: true,
                  url: '/app',
                  templateUrl: layout,
                  resolve:load([ '../libs/jquery/bootstrap-tour/driver.min.js', '../libs/jquery/bootstrap-tour/driver.min.css']),
              })
              .state('app.v2', {
                  url: '/v2',
                  templateUrl: 'Static_Full_Version/dashboard_2.html?'+version,
                  resolve: load(['js/controllers/chart.js?'+version,'moment'])
              })
              .state('app.file2', {
                  url: '/file2',
                  templateUrl: 'Static_Full_Version/file_manager.html?'+version,
                  resolve: load(['js/controllers/chart.js?'+version,'moment'])
              })
              .state('app.pin2', {
                  url: '/pin2',
                  templateUrl: 'Static_Full_Version/pin_board.html?'+version,
                  resolve: load(['js/controllers/chart.js?'+version,'moment'])
              })
              .state('app.forum2', {
                  url: '/forum2',
                  templateUrl: 'Static_Full_Version/forum_main.html?'+version,
                  resolve: load(['js/controllers/chart.js?'+version,'moment'])
              })
              .state('app.ecd2', {
                  url: '/ecd2',
                  templateUrl: 'Static_Full_Version/ecommerce_product_detail.html?'+version,
                  resolve: load(['js/controllers/chart.js?'+version,'moment'])
              })
              .state('app.cart2', {
                  url: '/cart2',
                  templateUrl: 'Static_Full_Version/ecommerce-cart.html?'+version,
                  resolve: load(['js/controllers/chart.js?'+version,'moment'])
              })
              .state('app.excel', {
                  url: '/excel',
                  templateUrl: 'design/tpl/excelist.html?'+version,
                  resolve: load(['design/js/controllers/excelist.js?'+version,'moment'])
              })
              .state('excelsdetail', {
                  url: '/excelsdetail/{templateId}/p/{pageId}/i/{itemId}',
                  templateUrl: 'design/tpl/exceldetail.html?'+version,
                  resolve: load(['design/js/controllers/excelist.js?'+version,'moment'])
              })
              .state('pagexlist', {
                  url: '/pagexlist/{categoryId}/list/{pageId}',
                  templateUrl: 'tpl/list.html?'+version,
                  controller: 'pagex_list_ctrl',
                  resolve: load([ 'js/functions.js?'+version , 'js/controllers/list.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css'])
              })
              //forum_main.html
              // .state('app.dashboard-v1', {
              //     url: '/dashboard-v1',
              //     templateUrl: 'tpl/app_dashboard_v1.html?'+version,
              //     resolve: load(['js/controllers/chart.js?'+version,'moment'],
              //        function(){
              //
              //          $.when(cooConfig.L()).done(function(ret){
              //               var url_new =window.location.href.replace(/#.+$/ig,'');
              //               url_new+="#/access/signin";
              //               console.log(url_new);
              //               if (!ret)
              //               {
              //                window.location.href =url_new;
              //               }
              //               else
              //               {
              //                   cooConfig.F();
              //               }
              //                 //cooConfig.F();
              //          });
              //        }
              //    )
              // })
              // .state('app.dashboard-v1', {
              //     url: '/dashboard-v1',
              //     templateUrl: 'design/'+cooConfig.configObj.companyId+'/tmpl/app_dashboard_v1.html?'+version,
              //     resolve: load( ['design/'+cooConfig.configObj.companyId+'/js/chart.js?'+version,'moment'] )
              //
              // })
              .state('app.dashboard-v2', {
                  url: '/dashboard-v2',
                  templateUrl: 'tpl/app_dashboard_v2.html?'+version,
                  resolve: load(['js/controllers/chart.js?'+version,'moment'])
              })
              .state('app.dashboard-v3', {
                  url: '/dashboard-v3',
                  templateUrl: 'design/'+cooConfig.configObj.companyId+'/tmpl/home.html?'+version,
                  resolve: load(['design/'+cooConfig.configObj.companyId+'/js/home.js?'+version,'moment'])
              })
              .state('app.dashboard', {
                  url: '/dashboard/{pageId}',
                  templateUrl: 'tpl/app_dashboard.html?'+version,
                  controller: 'pagex_dashboard_ctrl',
                  resolve: load([ '../libs/jquery/bootstrap-tour/driver.min.js', '../libs/jquery/bootstrap-tour/driver.min.css','js/controllers/dashboard.js?'+version,'moment'])
              })
              // .state('app.dashboard-v1', {
              //     url: '/dashboard-v1',
              //     templateUrl: 'tpl/app_dashboard_v1.html?'+version,
              //     resolve: load(['js/controllers/chart.js?'+version,'moment'])
              // })
              .state('app.ui', {
                  url: '/ui',
                  template: '<div ui-view class="fade-in-up"></div>'
              })
              .state('app.ui.buttons', {
                  url: '/buttons',
                  templateUrl: 'tpl/ui_buttons.html?'+version
              })
              .state('app.ui.icons', {
                  url: '/icons',
                  templateUrl: 'tpl/ui_icons.html?'+version
              })
              .state('app.ui.grid', {
                  url: '/grid',
                  templateUrl: 'tpl/ui_grid.html?'+version
              })
              .state('app.ui.widgets', {
                  url: '/widgets',
                  templateUrl: 'tpl/ui_widgets.html?'+version
              })
              .state('app.ui.bootstrap', {
                  url: '/bootstrap',
                  templateUrl: 'tpl/ui_bootstrap.html?'+version
              })
              .state('app.ui.sortable', {
                  url: '/sortable',
                  templateUrl: 'tpl/ui_sortable.html?'+version
              })
              .state('app.ui.scroll', {
                  url: '/scroll',
                  templateUrl: 'tpl/ui_scroll.html?'+version,
                  resolve: load('js/controllers/scroll.js?'+version)
              })
              .state('app.ui.portlet', {
                  url: '/portlet',
                  templateUrl: 'tpl/ui_portlet.html?'+version
              })
              .state('app.ui.timeline', {
                  url: '/timeline',
                  templateUrl: 'tpl/ui_timeline.html?'+version
              })
              .state('app.ui.tree', {
                  url: '/tree',
                  templateUrl: 'tpl/ui_tree.html?'+version,
                  resolve: load(['angularBootstrapNavTree', 'js/controllers/tree.js?'+version])
              })
              .state('app.ui.toaster', {
                  url: '/toaster',
                  templateUrl: 'tpl/ui_toaster.html?'+version,
                  resolve: load(['toaster', 'js/controllers/toaster.js?'+version])
              })
              .state('app.ui.jvectormap', {
                  url: '/jvectormap',
                  templateUrl: 'tpl/ui_jvectormap.html?'+version,
                  resolve: load('js/controllers/vectormap.js?'+version)
              })
              .state('app.ui.googlemap', {
                  url: '/googlemap',
                  templateUrl: 'tpl/ui_googlemap.html?'+version,
                  resolve: load(['js/app/map/load-google-maps.js?'+version, 'js/app/map/ui-map.js?'+version, 'js/app/map/map.js?'+version], function(){ return loadGoogleMaps(); })
              })
              .state('app.chart', {
                  url: '/chart',
                  templateUrl: 'tpl/ui_chart.html?'+version,
                  resolve: load('js/controllers/chart.js?'+version)
              })
              .state('app.test', {
                  url: '/test',
                  templateUrl: 'tpl/page_test.html?'+version,
                  resolve: load('js/controllers/test.js?'+version)
              })
              .state('app.action', {
                  url: '/action/{pageId}',
                  templateUrl: 'tpl/page_action.html?'+version,
                  resolve: load('js/controllers/action.js?'+version)
              })
              .state('test2', {
                  url: '/test2',
                  templateUrl: 'tpl/page_test2.html?'+version,
                  resolve: load('js/controllers/test2.js?'+version)
              })
              .state('app.print', {
                  url: '/print/{pageId}/i/{itemId}',
                  templateUrl: 'tpl/page_print.html?'+version,
                  resolve: load('js/controllers/print.js?'+version)
              })
              .state('app.create_full_column_one', {
                  url: '/{categoryId}/create_full_column_one/{createPageId}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['ui.grid','summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.create_full_column_one_params', {
                  url: '/{categoryId}/create_full_column_one_params/{createPageId}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('edit_full_column_one', {
                  url: '/{categoryId}/edit_full_column_one/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.edit_full_column_one', {
                  url: '/{categoryId}/edit_full_column_one/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.detail_full_column_one', {
                  url: '/{categoryId}/detail_full_column_one/{detailPageId}/i/{itemId}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.detail_full_column_two', {
                  url: '/{categoryId}/detail_full_column_two/{detailPageId}/i/{itemId}',
                  templateUrl: 'tpl/detail_full_column_two.html?'+version,
                  controller: 'pagex_detail_full_column_two_ctrl',
                  resolve: load(['summernote','ui.grid','js/coowork/g.write.js?'+version     ,'js/controllers/detail_full_column_two.js?'+version])
              })
              .state('app.pagex', {
                  url: '/pagex',
                  template: '<div ui-view ></div>',
                  resolve: load(['../libs/jquery/bootstrap-tour/driver.min.js', '../libs/jquery/bootstrap-tour/driver.min.css']),

              })
              .state('app.pagex.gongzi_new', {
                url: '/gongzi_new',
                templateUrl: 'design/2024/tmpl/gongzi_new.html?'+version,
                resolve: load( ['moment', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav','design/2024/js/gongzi_new.js?'+version ])
            })
            .state('app.pagex.report', {
                  url: '/{categoryId}/report/{pageId}',
                  templateUrl: 'tpl/report.html?'+version,
                  controller: 'pagex_report_ctrl',
                  resolve: load([ 'echarts', 'js/functions.js?'+version , 'js/controllers/report.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css'])
              })
              .state('app.pagex.insight', {
                    url: '/{categoryId}/insight/{pageId}',
                    templateUrl: 'tpl/insight.html?'+version,
                    controller: 'pagex_insight_ctrl',
                    resolve: load([ 'echarts', 'js/functions.js?'+version ,  'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav', 'js/controllers/insight.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                  '../libs/jquery/chosen/bootstrap-chosen.css'])
                })
              .state('app.pagex.group', {
                  url: '/{categoryId}/group/{pageId}',
                  templateUrl: 'tpl/group.html?'+version,
                  controller: 'pagex_group_ctrl',
                  resolve: load([ 'js/functions.js?'+version , 'js/controllers/group.js?'+version
                                ])
              })
              .state('app.pagex.splitscreen', {
                  url: '/{categoryId}/splitscreen/{pageId}',
                  templateUrl: 'tpl/splitscreen.html?'+version,
                  controller: 'pagex_splitscreen_ctrl',
                  resolve: load([ '../libs/jquery/bootstrap-tour/driver.min.js', '../libs/jquery/bootstrap-tour/driver.min.css', 'js/functions.js?'+version , 'js/controllers/splitscreen.js?'+version
                      ])
              })
              .state('app.pagex.splitscreen.detail_split_one', {
                  url: '/detail_split_one/{detailPageId}/i/{itemId}',
                  templateUrl: 'tpl/splitscreen.html?'+version,
                  controller: 'pagex_splitscreen_ctrl',
                  resolve: load([ 'js/functions.js?'+version , 'js/controllers/splitscreen.js?'+version
                                ])
              })
              //
              .state('app.pagex.excelist', {
                  url: '/{categoryId}/excelist/{pageId}/template/{templateId}',
                  templateUrl: 'tpl/excelist.html?'+version,
                  controller: 'pagex_excelist_ctrl',
                  resolve: load([ 'js/functions.js?'+version , 'js/controllers/excelist.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css'])
              })



              .state('app.pagex.list', {
                  url: '/{categoryId}/list/{pageId}',
                  templateUrl: 'tpl/list.html?'+version,
                  controller: 'pagex_list_ctrl',
                  resolve: load([ 'js/functions.js?'+version , 'js/controllers/list.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css' ,'ui.grid' ])
              })
              .state('app.pagex.listParams', {
                  url: '/{categoryId}/listparams/{pageId}',
                  templateUrl: 'tpl/list.html?'+version,
                  controller: 'pagex_list_ctrl',
                  resolve: load([ 'js/functions.js?'+version , 'js/controllers/list.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css'])
              })
              .state('app.pagex.list.create', {
                  url: '/create/{createPageId}/c/{cols}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote' ,'js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.pagex.list.edit', {
                  url: '/edit/{editPageId}/i/{itemId}/c/{cols}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load([ 'summernote','ui.codemirror','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.pagex.list.detail', {
                  url: '/detail/{detailPageId}/i/{itemId}/c/{cols}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['textAngular','js/controllers/write.js?'+version])
              })
              .state('app.pagex.detail', {
                  url: '/{categoryId}/detail/{pageId}/i/{itemId}',
                  templateUrl: 'tpl/detail.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['js/controllers/write.js?'+version])
              })

              .state('app.pagex.create', {
                  url: '/{categoryId}/create/{pageId}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.pagex.create2', {
                  url: '/{categoryId}/create/{pageId}/c/{cols}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              // .state('app.pagex.sheet', {
              //     url: '/{categoryId}/sheet/{pageId}',
              //     templateUrl: 'tpl/sheet.html?'+version,
              //     resolve: load(['moment','ngHandsontable','js/controllers/sheet.js?'+version   ])
              // })
              .state('app.pagex.excel_complex_create', {
                  url: '/{categoryId}/excel_complex/{createPageId}',
                  templateUrl: 'tpl/excel_complex.html?'+version,
                  resolve: load(['summernote','ckeditor','moment', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav', 'js/controllers/excel.js?'+version   ] )
              })
              .state('app.pagex.excel_complex_edit', {
                  url: '/{categoryId}/excel_complex/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/excel_complex.html?'+version,
                  resolve: load(['moment', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav', 'js/controllers/excel.js?'+version   ] )
              })

              .state('app.pagex.bulk_create', {
                  url: '/{categoryId}/bulk_create/{createPageId}',
                  templateUrl: 'tpl/bulk_write.html?'+version,
                  resolve: load(['summernote','moment', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav','js/coowork/g.bulk_write.js?'+version  , 'js/controllers/bulk.js?'+version   ] )
              })
              .state('app.pagex.bulk_edit', {
                  url: '/{categoryId}/bulk_edit/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/bulk_write.html?'+version,
                  resolve: load(['summernote','moment', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav', 'js/controllers/bulk.js?'+version   ] )
              })

              .state('app.pagex.edit', {
                  url: '/{categoryId}/edit/{pageId}/i/{itemId}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })
              .state('app.pagex.edit2', {
                  url: '/{categoryId}/edit/{pageId}/i/{itemId}/c/{cols}',
                  templateUrl: 'tpl/write.html?'+version,
                  controller: 'pagex_write_ctrl',
                  resolve: load(['summernote','js/coowork/g.write.js?'+version     ,'js/controllers/write.js?'+version])
              })


              // table
              .state('app.table', {
                  url: '/table',
                  template: '<div ui-view></div>'
              })
              .state('app.table.fileupload', {
                  url: '/fileupload',
                  templateUrl: 'tpl/form_fileupload.html?'+version,
                  resolve: load(['js/controllers/supply/file-upload.js?'+version])
              })
              .state('app.table.search', {
                  url: '/search',
                  templateUrl: 'tpl/supply/search.html?'+version,
                  controller: 'table_search_ctrl',
                  resolve: load(['js/controllers/supply/search.js?'+version])
              })
              .state('app.table.search2', {
                  url: '/search2',
                  templateUrl: 'tpl/supply/search2.html?'+version,
                  controller: 'table_search2_ctrl',
                  resolve: load(['js/controllers/supply/search2.js?'+version])
              })
              .state('app.table.static', {
                  url: '/static',
                  templateUrl: 'tpl/table_static.html?'+version
              })
              .state('app.table.goods', {
                  url: '/goods',
                  templateUrl: 'tpl/supply/table_goods.html?'+version,
                  controller: 'table_goods_ctrl',
                  resolve: load(['js/controllers/supply/table_goods.js?'+version])
              })
              .state('app.table.goods_detail', {
                  url: '/goods_detail/{itemId}',
                  templateUrl: 'tpl/supply/table_goods_detail.html?'+version,
                  controller: 'table_goods_detail_ctrl',
                  resolve: load(['js/controllers/supply/table_goods_detail.js?'+version])
              })
              .state('app.table.fr_goods', {
                  url: '/fr_goods/{gid}',
                  templateUrl: 'tpl/supply/table_fr_goods.html?'+version,
                  controller: 'table_fr_goods_ctrl',
                  resolve: load(['js/controllers/supply/table_fr_goods.js?'+version])
              })
              .state('app.table.select_goods', {
                  url: '/select_goods',
                  templateUrl: 'tpl/supply/select_goods.html?'+version,

              })
              .state('app.table.orders', {
                  url: '/orders',
                  templateUrl: 'tpl/supply/table_orders.html?'+version,
                  controller: 'table_orders_ctrl',
                  resolve: load(['js/controllers/supply/table_orders.js?'+version])
              })
              .state('app.table.my_orders', {
                  url: '/my_orders',
                  templateUrl: 'tpl/supply/my/my_orders.html?'+version,
                  controller: 'my_orders_ctrl',
                  resolve: load(['js/controllers/supply/my/my_orders.js?'+version])
              })
              .state('app.table.my_carts', {
                  url: '/my_carts',
                  templateUrl: 'tpl/supply/my/my_carts.html?'+version,
                  controller: 'my_carts_ctrl',
                  resolve: load(['js/controllers/supply/my/my_carts.js?'+version,'moment'])
              })
              .state('app.table.carts', {
                  url: '/carts',
                  templateUrl: 'tpl/supply/table_carts.html?'+version,
                  controller: 'table_carts_ctrl',
                  resolve: load(['js/controllers/supply/table_carts.js?'+version])
              })
              .state('app.table.collections', {
                  url: '/collections',
                  templateUrl: 'tpl/supply/table_collections.html?'+version,
                  controller: 'table_collections_ctrl',
                  resolve: load(['js/controllers/supply/table_collections.js?'+version])
              })
              .state('app.table.my_collections', {
                  url: '/my_collections',
                  templateUrl: 'tpl/supply/my/my_collections.html?'+version,
                  controller: 'my_collections_ctrl',
                  resolve: load(['js/controllers/supply/my/my_collections.js?'+version])
              })
              .state('app.table.cfg', {
                  url: '/cfg',
                  templateUrl: 'tpl/supply/table_depls.html?'+version,
                  controller: 'table_depls_ctrl',
                  resolve: load(['js/controllers/supply/table_depls.js?'+version])
              })
              .state('app.table.stocks', {
                  url: '/stocks',
                  templateUrl: 'tpl/supply/table_stocks.html?'+version,
                  controller: 'table_stocks_ctrl',
                  resolve: load(['js/controllers/supply/table_stocks.js?'+version])
              })
              .state('app.table.stocks_1', {
                  url: '/stocks_1',
                  templateUrl: 'tpl/supply/table_stocks_1.html?'+version,
                  controller: 'table_stocks_1_ctrl',
                  resolve: load(['js/controllers/supply/table_stocks_1.js?'+version])
              })
              .state('app.table.stocks_2', {
                  url: '/stocks_2',
                  templateUrl: 'tpl/supply/table_stocks_2.html?'+version,
                  controller: 'table_stocks_2_ctrl',
                  resolve: load(['js/controllers/supply/table_stocks_2.js?'+version])
              })
              .state('app.table.datatable', {
                  url: '/datatable',
                  templateUrl: 'tpl/table_datatable.html?'+version
              })
              .state('app.table.footable', {
                  url: '/footable',
                  templateUrl: 'tpl/table_footable.html?'+version
              })
              .state('app.table.grid', {
                  url: '/grid',
                  templateUrl: 'tpl/table_grid.html?'+version,
                  resolve: load(['ngGrid','js/controllers/grid.js?'+version])
              })
              .state('app.table.uigrid', {
                  url: '/uigrid',
                  templateUrl: 'tpl/table_uigrid.html?'+version,
                  resolve: load(['ui.grid','js/controllers/uigrid.js?'+version])
              })
              .state('app.table.editable', {
                  url: '/editable',
                  templateUrl: 'tpl/table_editable.html?'+version,
                  controller: 'XeditableCtrl',
                  resolve: load(['xeditable','js/controllers/xeditable.js?'+version])
              })
              .state('app.table.smart', {
                  url: '/smart',
                  templateUrl: 'tpl/table_smart.html?'+version,
                  resolve: load(['smart-table','js/controllers/table.js?'+version])
              })
              .state('app.table.change_password', {
                  url: '/change_password',
                  templateUrl: 'tpl/change_password.html?'+version,
                  resolve: load( ['js/controllers/change_password.js?'+version] )
              })
              // form
              .state('app.form', {
                  url: '/form',
                  template: '<div ui-view class="fade-in"></div>',
                  resolve: load('js/controllers/form.js?'+version)
              })
              .state('app.form.components', {
                  url: '/components',
                  templateUrl: 'tpl/form_components.html?'+version,
                  resolve: load(['ngBootstrap','daterangepicker','js/controllers/form.components.js?'+version])
              })
              .state('app.form.elements', {
                  url: '/elements',
                  templateUrl: 'tpl/form_elements.html?'+version
              })
              .state('app.form.validation', {
                  url: '/validation',
                  templateUrl: 'tpl/form_validation.html?'+version
              })
              .state('app.form.wizard', {
                  url: '/wizard',
                  templateUrl: 'tpl/form_wizard.html?'+version
              })
              .state('app.form.fileupload', {
                  url: '/fileupload',
                  templateUrl: 'tpl/form_fileupload.html?'+version,
                  resolve: load(['angularFileUpload','js/controllers/file-upload.js?'+version])
              })
              .state('app.form.imagecrop', {
                  url: '/imagecrop',
                  templateUrl: 'tpl/form_imagecrop.html?'+version,
                  resolve: load(['ngImgCrop','js/controllers/imgcrop.js?'+version])
              })
              .state('app.form.select', {
                  url: '/select',
                  templateUrl: 'tpl/form_select.html?'+version,
                  controller: 'SelectCtrl',
                  resolve: load(['ui.select','js/controllers/select.js?'+version])
              })
              .state('app.form.slider', {
                  url: '/slider',
                  templateUrl: 'tpl/form_slider.html?'+version,
                  controller: 'SliderCtrl',
                  resolve: load(['vr.directives.slider','js/controllers/slider.js?'+version])
              })
              .state('app.form.editor', {
                  url: '/editor',
                  templateUrl: 'tpl/form_editor.html?'+version,
                  controller: 'EditorCtrl',
                  resolve: load(['textAngular','js/controllers/editor.js?'+version])
              })
              .state('app.form.xeditable', {
                  url: '/xeditable',
                  templateUrl: 'tpl/form_xeditable.html?'+version,
                  controller: 'XeditableCtrl',
                  resolve: load(['xeditable','js/controllers/xeditable.js?'+version])
              })
              // pages
              .state('app.page', {
                  url: '/page',
                  template: '<div ui-view class="fade-in-down"></div>'
              })
              .state('app.page.profile', {
                  url: '/profile',
                  templateUrl: 'tpl/page_profile.html?'+version,
                  resolve: load( ['js/controllers/profile.js?'+version, 'moment' ] )
              })
              .state('app.page.post', {
                  url: '/post',
                  templateUrl: 'tpl/page_post.html?'+version
              })
              .state('app.page.search', {
                  url: '/search',
                  templateUrl: 'tpl/page_search.html?'+version
              })
              .state('app.page.invoice', {
                  url: '/invoice',
                  templateUrl: 'tpl/page_invoice.html?'+version
              })
              .state('app.page.price', {
                  url: '/price',
                  templateUrl: 'tpl/page_price.html?'+version
              })
              .state('app.docs', {
                  url: '/docs',
                  templateUrl: 'tpl/docs.html?'+version,
                  resolve: load( ['js/controllers/docs.js?'+version] )
              })
              .state('app.docs2', {
                  url: '/docs2',
                  templateUrl: 'tpl/docs2.html?'+version
              })
              // others
              .state('lockme', {
                  url: '/lockme',
                  templateUrl: 'tpl/page_lockme.html?'+version
              })
              .state('access', {
                  url: '/access',
                  template: '<div ui-view class="fade-in-right-big smooth"></div>'
              })
              .state('access.signup', {
                  url: '/signup',
                  templateUrl: 'tpl/page_signup.html?'+version,
                  resolve: load( ['js/controllers/signup.js?'+version] )
              })
              .state('access.forgotpwd', {
                  url: '/forgotpwd',
                  templateUrl: 'tpl/page_forgotpwd.html?'+version
              })
              .state('access.404', {
                  url: '/404',
                  templateUrl: 'tpl/page_404.html?'+version
              })

              // fullCalendar
              .state('app.calendar', {
                  url: '/calendar',
                  templateUrl: 'tpl/app_calendar.html?'+version,
                  // use resolve to load other dependences
                  resolve: load(['moment','fullcalendar','ui.calendar','js/app/calendar/calendar.js?'+version])
              })
              .state('app.log', {
                  url: '/log',
                  templateUrl: 'tpl/page_log.html?'+version,
                  // use resolve to load other dependences
                  resolve: load(['js/controllers/write.js?'+version])
              })
              .state('app.pagez', {
                  // abstract: true,
                  url: '/pagez/{listPageId}',
                  templateUrl: 'tpl/supply/pagez.html?'+version,
                  // use resolve to load other dependences
                  resolve: load( [ 'js/functions.js?'+version , 'summernote','js/controllers/supply/pagey.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css', 'moment', 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav','ui.grid.resizeColumns'] )
              })
              .state('app.pagez.write', {
                  url: '/write/{writePageId}/i/{itemId}',
                  templateUrl: 'pages/tpl/write.html?'+version,
                  resolve: load( ['pages/js/write.js?'+version ,'ngJsTree'   ] )

              })
              .state('app.pagez.treewrite', {
                  url: '/treewrite/{writePageId}/i1/{itemId1}/i/{itemId}',
                  templateUrl: 'pages/tpl/treewrite.html?'+version,
                  resolve: load( ['pages/js/treewrite.js?'+version  ,'ngJsTree'   ] )

              })
              .state('app.pagez.edit', {
                  url: '/edit/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                  resolve: load( ['js/coowork/g.excel_complex.js?'+version    ] )

              })
              .state('pagezedit', {
                  url: '/pagezedit/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                  resolve: load( ['js/functions.js?'+version , 'summernote','js/controllers/supply/pagey.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css', 'moment', 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav','js/coowork/g.excel_complex.js?'+version    ] )

              })
              //https://cdn.ckeditor.com/4.13.0/standard-all/ckeditor.js
              .state('app.pagez.editckeditor', {
                  url: '/ckeditor/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                  resolve: load( [ '../libs/jquery/ckeditor/ckeditor.js','js/coowork/g.excel_complex.js?'+version    ] )

              })
              .state('app.pagez.create', {
                  url: '/edit/{createPageId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                  resolve: load( ['js/functions.js?'+version , 'summernote','js/controllers/supply/pagey.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css', 'moment', 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav','js/coowork/g.excel_complex.js?'+version    ] )
                      //standard-all  https://cdn.ckeditor.com/4.13.0/standard-all/ckeditor.js
              })
              .state('pagezcreate', {
                  url: '/pagezcreate/{createPageId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                  resolve: load( ['js/functions.js?'+version , 'summernote','js/controllers/supply/pagey.js?'+version ,'../libs/jquery/chosen/chosen.jquery.min.js',
                                '../libs/jquery/chosen/bootstrap-chosen.css', 'moment', 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js', 'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav','js/coowork/g.excel_complex.js?'+version    ] )

                      //standard-all  https://cdn.ckeditor.com/4.13.0/standard-all/ckeditor.js
              })
              .state('app.pagez.createckeditor', {
                  url: '/ckeditor/{createPageId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                      resolve: load( [ 'https://cdn.ckeditor.com/4.13.0/standard-all/ckeditor.js','js/coowork/g.excel_complex.js?'+version     ] )

                      //standard-all  https://cdn.ckeditor.com/4.13.0/standard-all/ckeditor.js
              })


              .state('app.pagez.detail', {
                  url: '/detail/{detailPageId}/i/{itemId}',
                  templateUrl: 'tpl/supply/pagey.detail.html?'+version
              })

              .state('app.pagey', {
                  // abstract: true,
                  url: '/pagey/{listPageId}',
                  templateUrl: 'tpl/supply/pagey.html?'+version,
                  // use resolve to load other dependences
                  resolve: load( ['js/controllers/supply/pagey.js?'+version, 'moment',  'ui.grid', 'ui.grid.edit', 'ui.grid.rowEdit', 'ui.grid.cellNav'] )
              })
              .state('app.pagey.detail', {
                  url: '/detail/{detailPageId}/i/{itemId}',
                  templateUrl: 'tpl/supply/pagey.detail.html?'+version,

              })
              .state('app.pagey.edit', {
                  url: '/edit/{editPageId}/i/{itemId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                      resolve: load( ['js/coowork/g.excel_complex.js?'+version     ] )
              })
              .state('app.pagey.create', {
                  url: '/edit/{createPageId}',
                  templateUrl: 'tpl/supply/pagey.edit.html?'+version,
                      resolve: load( ['js/coowork/g.excel_complex.js?'+version     ] )
              })








              .state('app.l_d_depl', {
                  // abstract: true,
                  url: '/l_d_depl',
                  templateUrl: 'tpl/supply/l_d_depl.html?'+version,
                  // use resolve to load other dependences
                  resolve: load( ['js/controllers/supply/l_d_depl.js?'+version, 'moment'] )
              })

              .state('app.l_d_depl.detail', {
                  url: '/detail/{itemId}',
                  templateUrl: 'tpl/supply/l_d_depl.detail.html?'+version
              })
              .state('app.l_d_depl.edit', {
                  url: '/edit/{itemId}',
                  templateUrl: 'tpl/supply/l_d_depl.edit.html?'+version
              })


              .state('app.l_d_depl_in', {
                  // abstract: true,
                  url: '/l_d_depl_in',
                  templateUrl: 'tpl/supply/l_d_depl_in.html?'+version,
                  // use resolve to load other dependences
                  resolve: load( ['js/controllers/supply/l_d_depl_in.js?'+version, 'moment'] )
              })

              .state('app.l_d_depl_in.detail', {
                  url: '/detail/{itemId}',
                  templateUrl: 'tpl/supply/l_d_depl_in.detail.html?'+version
              })
              .state('app.l_d_depl_in.edit', {
                  url: '/edit/{itemId}',
                  templateUrl: 'tpl/supply/l_d_depl_in.edit.html?'+version
              })

              .state('app.l_d_myorders', {
                  // abstract: true,
                  url: '/l_d_myorders',
                  templateUrl: 'tpl/supply/l_d_myorders.html?'+version,
                  // use resolve to load other dependences
                  resolve: load( ['js/controllers/supply/l_d_myorders.js?'+version, 'moment'] )
              })

              .state('app.l_d_myorders.detail', {
                  url: '/detail/{itemId}',
                  templateUrl: 'tpl/supply/l_d_myorders.detail.html?'+version
              })
              .state('app.l_d_myorders.edit', {
                  url: '/edit/{itemId}',
                  templateUrl: 'tpl/supply/l_d_myorders.edit.html?'+version
              })


              .state('app.l_d_order', {
                  // abstract: true,
                  url: '/l_d_order',
                  templateUrl: 'tpl/supply/l_d_order.html?'+version,
                  // use resolve to load other dependences
                  resolve: load( ['js/controllers/supply/l_d_order.js?'+version, 'moment'] )
              })

              .state('app.l_d_order.detail', {
                  url: '/detail/{itemId}',
                  templateUrl: 'tpl/supply/l_d_order.detail.html?'+version
              })
              .state('app.l_d_order.edit', {
                  url: '/edit/{itemId}',
                  templateUrl: 'tpl/supply/l_d_order.edit.html?'+version
              })


              // mail
              .state('app.mail', {
                  abstract: true,
                  url: '/mail',
                  templateUrl: 'tpl/mail.html?'+version,
                  // use resolve to load other dependences
                  resolve: load( ['js/app/mail/mail.js?'+version,'js/app/mail/mail-service.js?'+version,'moment'] )
              })
              .state('app.mail.list', {
                  url: '/inbox/{fold}',
                  templateUrl: 'tpl/mail.list.html?'+version
              })
              .state('app.mail.detail', {
                  url: '/{mailId:[0-9]{1,4}}',
                  templateUrl: 'tpl/mail.detail.html?'+version
              })
              .state('app.mail.compose', {
                  url: '/compose',
                  templateUrl: 'tpl/mail.new.html?'+version,
                  resolve: load( ['textAngular'] )
              })
              .state('app.mail.compose2', {
                  url: '/compose/{name}/{email}',
                  templateUrl: 'tpl/mail.new.html?'+version,
                    resolve: load( ['textAngular'] )
              })

              .state('layout', {
                  abstract: true,
                  url: '/layout',
                  templateUrl: 'tpl/layout.html?'+version
              })
              .state('layout.fullwidth', {
                  url: '/fullwidth',
                  views: {
                      '': {
                          templateUrl: 'tpl/layout_fullwidth.html?'+version
                      },
                      'footer': {
                          templateUrl: 'tpl/layout_footer_fullwidth.html?'+version
                      }
                  },
                  resolve: load( ['js/controllers/vectormap.js?'+version] )
              })
              .state('layout.mobile', {
                  url: '/mobile',
                  views: {
                      '': {
                          templateUrl: 'tpl/layout_mobile.html?'+version
                      },
                      'footer': {
                          templateUrl: 'tpl/layout_footer_mobile.html?'+version
                      }
                  }
              })
              .state('layout.app', {
                  url: '/app',
                  views: {
                      '': {
                          templateUrl: 'tpl/layout_app.html?'+version
                      },
                      'footer': {
                          templateUrl: 'tpl/layout_footer_fullwidth.html?'+version
                      }
                  },
                  resolve: load( ['js/controllers/tab.js?'+version] )
              })
              .state('apps', {
                  abstract: true,
                  url: '/apps',
                  templateUrl: 'tpl/layout.html?'+version
              })
              .state('apps.note', {
                  url: '/note',
                  templateUrl: 'tpl/apps_note.html?'+version,
                  resolve: load( ['js/app/note/note.js?'+version,'moment'] )
              })
              .state('apps.doc', {
                  url: '/doc',
                  templateUrl: 'design/1000/tmpl/apps_doc.html?'+version,
                  resolve: load( ['design/1000/js/doc.js?'+version,'moment' ,'ngJsTree'] )
              })
              .state('apps.file', {
                  url: '/file',
                  templateUrl: 'design/tpl/apps_file.html?'+version,
                  resolve: load( [ 'ui.codemirror' ,'../libs/angular/codemirror/addon/fold/foldcode.js','../libs/angular/codemirror/addon/fold/foldgutter.js', '../libs/angular/codemirror/mode/javascript/javascript.js','design/js/controllers/file.js?'+version,'moment' ,'ngJsTree'] )
              })
              .state('apps.localfile', {
                  url: '/localfile',
                  templateUrl: 'design/tpl/apps_localfile.html?'+version,
                  resolve: load( [  'design/js/controllers/localfile.js?'+version,'moment' ,'ngJsTree'] )
              })
              .state('apps.doc2', {
                  url: '/doc2',
                  templateUrl: 'design/1000/tmpl/apps_doc2.html?'+version,
                  resolve: load( ['design/1000/js/doc2.js?'+version,'moment' ,'ngJsTree'] )
              })
              .state('apps.blank', {
                  url: '/blank',
                  templateUrl: 'tpl/blank.html?'+version,
                  resolve: load( ['js/controllers/blankcontrollers.js?'+version,'moment' ,'ngJsTree'] )
              })
              .state('apps.docview', {
                  url: '/doc/{itemId}',
                  templateUrl: 'design/1000/tmpl/apps_doc.html?'+version,
                  resolve: load( ['design/1000/js/doc.js?'+version,'moment' ,'ngJsTree'] )
              })
              .state('apps.contact', {
                  url: '/contact',
                  templateUrl: 'tpl/apps_contact.html?'+version,
                  resolve: load( ['js/app/contact/contact.js?'+version] )
              })
              .state('app.weather', {
                  url: '/weather',
                  templateUrl: 'tpl/apps_weather.html?'+version,
                  resolve: load(['js/app/weather/skycons.js?'+version,'angular-skycons','js/app/weather/ctrl.js?'+version,'moment'])
              })
              .state('app.todo', {
                  url: '/todo',
                  templateUrl: 'tpl/apps_todo.html?'+version,
                  resolve: load(['js/app/todo/todo.js?'+version, 'moment'])
              })
              .state('app.todo.list', {
                  url: '/{fold}'
              })
              .state('app.note', {
                  url: '/note',
                  templateUrl: 'tpl/apps_note_material.html?'+version,
                  resolve: load(['js/app/note/note.js?'+version, 'moment'])
              })
              .state('music', {
                  url: '/music',
                  templateUrl: 'tpl/music.html?'+version,
                  controller: 'MusicCtrl',
                  resolve: load([
                            'com.2fdevs.videogular',
                            'com.2fdevs.videogular.plugins.controls',
                            'com.2fdevs.videogular.plugins.overlayplay',
                            'com.2fdevs.videogular.plugins.poster',
                            'com.2fdevs.videogular.plugins.buffering',
                            'js/app/music/ctrl.js?'+version,
                            'js/app/music/theme.css'
                          ])
              })
                  .state('music.home', {
                      url: '/home',
                      templateUrl: 'tpl/music.home.html?'+version
                  })
                  .state('music.genres', {
                      url: '/genres',
                      templateUrl: 'tpl/music.genres.html?'+version
                  })
                  .state('music.detail', {
                      url: '/detail',
                      templateUrl: 'tpl/music.detail.html?'+version
                  })
                  .state('music.mtv', {
                      url: '/mtv',
                      templateUrl: 'tpl/music.mtv.html?'+version
                  })
                  .state('music.mtvdetail', {
                      url: '/mtvdetail',
                      templateUrl: 'tpl/music.mtv.detail.html?'+version
                  })
                  .state('music.playlist', {
                      url: '/playlist/{fold}',
                      templateUrl: 'tpl/music.playlist.html?'+version
                  })
              .state('app.material', {
                  url: '/material',
                  template: '<div ui-view class="wrapper-md"></div>',
                  resolve: load(['js/controllers/material.js?'+version])
                })
                .state('app.material.button', {
                  url: '/button',
                  templateUrl: 'tpl/material/button.html?'+version
                })
                .state('app.material.color', {
                  url: '/color',
                  templateUrl: 'tpl/material/color.html?'+version
                })
                .state('app.material.icon', {
                  url: '/icon',
                  templateUrl: 'tpl/material/icon.html?'+version
                })
                .state('app.material.card', {
                  url: '/card',
                  templateUrl: 'tpl/material/card.html?'+version
                })
                .state('app.material.form', {
                  url: '/form',
                  templateUrl: 'tpl/material/form.html?'+version
                })
                .state('app.material.list', {
                  url: '/list',
                  templateUrl: 'tpl/material/list.html?'+version
                })
                .state('app.material.ngmaterial', {
                  url: '/ngmaterial',
                  templateUrl: 'tpl/material/ngmaterial.html?'+version
                })
                .state('app.admin', {
                    url: '/admin',
                    template: '<div ui-view  id="page-wrapper" ></div>',
                    resolve: load(['../libs/jquery/bootstrap-tour/driver.min.js', '../libs/jquery/bootstrap-tour/driver.min.css']),
                })
               .state('app.admin.appconfig', {
                    url: '/appconfig',
                    templateUrl: 'tpl/admin/appconfig.html?'+version,
                    controller :'adminappconfig',
                    resolve: load([ 'xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.appconfiguration', {
                     url: '/appconfiguration',
                     templateUrl: 'tpl/admin/appconfiguration.html?'+version,
                     controller :'adminconfiguration',
                     resolve: load([ 'xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                 })
                 .state('app.admin.configv2', {
                      url: '/config.v2',
                      templateUrl: 'tpl/admin/config.v2.html?'+version,
                      controller :'admin.config.v2',
                      resolve: load([ 'ngJsTree' , 'xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.v2.js?'+version])
                  })
                .state('app.admin.settingv2', {
                       url: '/{categoryId}/setting/{pageId}',
                       templateUrl: 'tpl/setting.v2.html?'+version,
                       controller :'admin.setting.v2',
                       resolve: load([ 'ui.grid', 'dataTable','ngJsTree' , 'xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.v2.js?'+version])
                 })

                 .state('app.admin.route', {
                      url: '/route',
                      templateUrl: 'tpl/admin/route.html?'+version,
                      controller :'adminroute',
                      resolve: load([ 'xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                .state('app.admin.func', {
                     url: '/func',
                     templateUrl: 'tpl/admin/func.html?'+version,
                     controller :'adminfunc',
                     resolve: load([ 'xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                 })
                .state('app.admin.approute', {
                     url: '/approute',
                     templateUrl: 'tpl/admin/approute.html?'+version,
                     controller :'adminapproute',
                     resolve: load([ 'xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                 })
                 .state('app.admin.appcomponent', {
                      url: '/appcomponent',
                      templateUrl: 'tpl/admin/appcomponent.html?'+version,
                      controller :'adminappcomponent',
                      resolve: load([  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('app.admin.appcomponent.view', {
                       url: '/view/{detailPageId}/i/{itemId}',
                       templateUrl: 'tpl/admin/component_view.html?'+version,
                       controller :'adminappcomponentview',
                        resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                   })
                 .state('app.admin.apppage', {
                      url: '/apppage',
                      templateUrl: 'tpl/admin/apppage.html?'+version,
                      controller :'adminapppage',
                      resolve: load([  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('app.admin.apppage.view', {
                        url: '/view/{detailPageId}/i/{itemId}',
                        templateUrl: 'tpl/admin/page_view.html?'+version,
                        controller :'adminapppageview',
                         resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                   })

                  .state('pagedetail', {
                      url: '/detail/{fileKey}',
                      templateUrl: 'tpl/admin/apppagedetail.html?'+version,
                      controller :'adminapppagedetail',
                      resolve: load(['ui.select', 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js', 'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('robotdetail', {
                      url: '/robot/{pageId}/i/{itemId}',
                      templateUrl: 'tpl/admin/approbotdetail.html?'+version,
                      controller :'adminapprobotdetail',
                      resolve: load([ '../libs/jquery/bootstrap-tour/driver.min.js', '../libs/jquery/bootstrap-tour/driver.min.css', 'ui.codemirror' ,'../libs/angular/codemirror/addon/fold/foldcode.js','../libs/angular/codemirror/addon/fold/foldgutter.js', '../libs/angular/codemirror/mode/clike/clike.js', 'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])

                  })
                  .state('transactiondetail', {
                      url: '/transaction/{pageId}/i/{itemId}',
                      templateUrl: 'tpl/admin/apptransactiondetail.html?'+version,
                      controller :'adminapptransactiondetail',
                      resolve: load([ '../libs/jquery/bootstrap-tour/driver.min.js', '../libs/jquery/bootstrap-tour/driver.min.css', 'ui.codemirror' ,'../libs/angular/codemirror/addon/fold/foldcode.js','../libs/angular/codemirror/addon/fold/foldgutter.js', '../libs/angular/codemirror/mode/clike/clike.js', 'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])

                  })
                  .state('rowauth', {
                      url: '/rowauth/{categoryId}',
                      templateUrl: 'tpl/admin/apptransactiondetail.html?'+version,
                      controller :'adminapptransactiondetail',
                      resolve: load([ 'ui.codemirror', '../libs/angular/codemirror/mode/clike/clike.js', 'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('systemevent', {
                      url: '/systemevent/{itemId}',
                      templateUrl: 'tpl/admin/apptransactiondetail.html?'+version,
                      controller :'adminapptransactiondetail',
                      resolve: load([ 'ui.codemirror', '../libs/angular/codemirror/mode/clike/clike.js', 'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('customevent', {
                      url: '/customevent/{itemId}',
                      templateUrl: 'tpl/admin/apptransactiondetail.html?'+version,
                      controller :'adminapptransactiondetail',
                      resolve: load([ 'ui.codemirror', '../libs/angular/codemirror/mode/clike/clike.js', 'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                 .state('app.admin.appfunction', {
                      url: '/appfunction',
                      templateUrl: 'tpl/admin/appfunction.html?'+version,
                      controller :'adminappfunction',
                      resolve: load([  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('app.admin.apptransaction', {
                       url: '/apptransaction',
                       templateUrl: 'tpl/admin/apptransaction.html?'+version,
                       controller :'adminapptransaction',
                       resolve: load([  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                   })
                   .state('app.admin.appmarket', {
                        url: '/appmarket',
                        templateUrl: 'tpl/admin/appmarket.html?'+version,
                        controller :'adminappmarket',
                        resolve: load([  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                    })
                  .state('app.admin.appfunction.edit', {
                      url: '/edit/{editPageId}/i/{itemId}',
                      templateUrl: 'tpl/admin/writefunction.html?'+version,
                      controller: 'adminappfunctionedit',
                      resolve: load(['summernote' , 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js',  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('app.admin.appfunction.create', {
                      url: '/edit/{editPageId}',
                      templateUrl: 'tpl/admin/writefunction.html?'+version,
                      controller: 'adminappfunctionedit',
                      resolve: load(['summernote' , 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js',  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('app.admin.appstyle', {
                       url: '/appstyle',
                       templateUrl: 'tpl/admin/appstyle.html?'+version,
                       controller :'adminappstyle',
                       resolve: load([  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                   })
                  .state('app.admin.appstyle.edit', {
                      url: '/edit/{editPageId}/i/{itemId}',
                      templateUrl: 'tpl/admin/writefunction.html?'+version,
                      controller: 'adminappstyleedit',
                      resolve: load(['summernote' , 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js',  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                  .state('app.admin.appstyle.create', {
                      url: '/edit/{editPageId}',
                      templateUrl: 'tpl/admin/writefunction.html?'+version,
                      controller: 'adminappstyleedit',
                      resolve: load(['summernote' , 'ui.codemirror', '../libs/angular/codemirror/mode/javascript/javascript.js',  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                  })
                .state('app.admin.define', {
                    url: '/define',
                    templateUrl: 'tpl/admin/define.html?'+version,
                    controller :'admindefine',
                    resolve: load([ 'sortable','dragable',  'js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.workflow', {
                    url: '/workflow',
                    templateUrl: 'tpl/admin/workflow.html?'+version,
                    controller :'adminworkflow',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.workflow2', {
                    url: '/workflow/{categoryId}',
                    templateUrl: 'tpl/admin/workflow.html?'+version,
                    controller :'adminworkflow',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.transformcolumn', {
                    url: '/transformcolumn',
                    templateUrl: 'tpl/admin/transformcolumn.html?'+version,
                    controller :'admintransformcolumn',
                    resolve: load([ 'xeditable','js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.transformcolumn2', {
                    url: '/transformcolumn/{categoryId}',
                    templateUrl: 'tpl/admin/transformcolumn.html?'+version,
                    controller :'admintransformcolumn',
                    resolve: load([ 'xeditable', 'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.department', {
                    url: '/department',
                    templateUrl: 'tpl/admin/department.html?'+version,
                    controller :'admindepartment',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.role', {
                    url: '/role',
                    templateUrl: 'tpl/admin/role.html?'+version,
                    controller :'adminrole',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.status', {
                    url: '/status',
                    templateUrl: 'tpl/admin/status.html?'+version,
                    controller :'adminstatus',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.status2', {
                    url: '/status/{groupId}/index/{p}',
                    templateUrl: 'tpl/admin/status.html?'+version,
                    controller :'adminstatus',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.category', {
                    url: '/category',
                    templateUrl: 'tpl/admin/category.html?'+version,
                    controller :'admincategory',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.abstract', {
                    url: '/abstract',
                    templateUrl: 'tpl/admin/abstract.html?'+version,
                    controller :'adminabstract',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.abstract2', {
                    url: '/abstract/{p}/{size}',
                    templateUrl: 'tpl/admin/abstract.html?'+version,
                    controller :'adminabstract',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.procedure', {
                    url: '/procedure',
                    templateUrl: 'tpl/admin/procedure.html?'+version,
                    controller :'adminprocedure',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.procedure2', {
                    url: '/procedure/{p}/{size}',
                    templateUrl: 'tpl/admin/procedure.html?'+version,
                    controller :'adminprocedure',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })

                .state('app.admin.page', {
                    url: '/page',
                    templateUrl: 'tpl/admin/page.html?'+version,
                    controller :'adminpage',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.page2', {
                    url: '/page/{categoryId}',
                    templateUrl: 'tpl/admin/page.html?'+version,
                    controller :'adminpage',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.pageauth', {
                    url: '/pageauth',
                    templateUrl: 'tpl/admin/pageauth.html?'+version,
                    controller :'adminpageauth',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.pageauth2', {
                    url: '/pageauth/{categoryId}',
                    templateUrl: 'tpl/admin/pageauth.html?'+version,
                    controller :'adminpageauth',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.element', {
                    url: '/element',
                    templateUrl: 'tpl/admin/element.html?'+version,
                    controller :'adminelement',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.element2', {
                    url: '/element/{categoryId}/{pageId}',
                    templateUrl: 'tpl/admin/element.html?'+version,
                    controller :'adminelement',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })

                .state('app.admin.menu', {
                    url: '/menu',
                    templateUrl: 'tpl/admin/menu.html?'+version,
                    controller :'adminmenu',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.menu2', {
                    url: '/menu/{p}/{size}',
                    templateUrl: 'tpl/admin/menu.html?'+version,
                    controller :'adminmenu',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.join', {
                    url: '/join',
                    templateUrl: 'tpl/admin/join.html?'+version,
                    controller :'adminjoin',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.join2', {
                    url: '/join/{categoryId}',
                    templateUrl: 'tpl/admin/join.html?'+version,
                    controller :'adminjoin',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.columnauth', {
                    url: '/columnauth',
                    templateUrl: 'tpl/admin/columnauth.html?'+version,
                    controller :'admincolumnauth',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.columnauth2', {
                    url: '/columnauth/{categoryId}',
                    templateUrl: 'tpl/admin/columnauth.html?'+version,
                    controller :'admincolumnauth',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.authmenu', {
                    url: '/authmenu',
                    templateUrl: 'tpl/admin/authmenu.html?'+version,
                    controller :'adminauthmenu',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.menuauth', {
                    url: '/menuauth',
                    templateUrl: 'tpl/admin/menuauth.html?'+version,
                    controller :'adminmenuauth',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.menuauth2', {
                    url: '/menuauth/{p}/{size}',
                    templateUrl: 'tpl/admin/menuauth.html?'+version,
                    controller :'adminmenuauth',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.statusmap', {
                    url: '/statusmap',
                    templateUrl: 'tpl/admin/statusmap.html?'+version,
                    controller :'adminstatusmap',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.statusmap2', {
                    url: '/statusmap/{categoryId}/{patternId}',
                    templateUrl: 'tpl/admin/statusmap.html?'+version,
                    controller :'adminstatusmap',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.statusgroup', {
                    url: '/statusgroup',
                    templateUrl: 'tpl/admin/statusgroup.html?'+version,
                    controller :'adminstatusgroup',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.statusgroup2', {
                    url: '/statusgroup/{p}/{size}',
                    templateUrl: 'tpl/admin/statusgroup.html?'+version,
                    controller :'adminstatusgroup',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.common', {
                    url: '/common/{pageId}',
                    templateUrl: 'tpl/admin/common.html?'+version,
                    controller :'admincommon',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.pattern', {
                    url: '/pattern',
                    templateUrl: 'tpl/admin/pattern.html?'+version,
                    controller :'adminpattern',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.pattern2', {
                    url: '/pattern/{categoryId}',
                    templateUrl: 'tpl/admin/pattern.html?'+version,
                    controller :'adminpattern',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.trigger2', {
                    url: '/trigger/{categoryId}',
                    templateUrl: 'tpl/admin/trigger.html?'+version,
                    controller :'admintrigger',
                    resolve: load(['xeditable','js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.user', {
                    url: '/user',
                    templateUrl: 'tpl/admin/user.html?'+version,
                    controller :'adminuser',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.user3', {
                    url: '/user/{UserId}',
                    templateUrl: 'tpl/admin/user.html?'+version,
                    controller :'adminuser',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })
                .state('app.admin.user2', {
                    url: '/user/{p}/{size}',
                    templateUrl: 'tpl/admin/user.html?'+version,
                    controller :'adminuser',
                    resolve: load(['js/coowork/g.app.js?'+version  ,'js/controllers/admincontrollers.js?'+version])
                })



                ;



          function load(srcs, callback) {
            return {
                deps: ['$ocLazyLoad', '$q',
                  function( $ocLazyLoad, $q ){
                    var deferred = $q.defer();
                    var promise  = false;
                    srcs = angular.isArray(srcs) ? srcs : srcs.split(/\s+/);
                    if(!promise){
                      promise = deferred.promise;
                    }
                    angular.forEach(srcs, function(src) {
                      promise = promise.then( function(){
                        if(JQ_CONFIG[src]){
                          return $ocLazyLoad.load(JQ_CONFIG[src]);
                        }
                        angular.forEach(MODULE_CONFIG, function(module) {
                          if( module.name == src){
                            name = module.name;
                          }else{
                            name = src;
                          }
                        });
                        return $ocLazyLoad.load(name);
                      } );
                    });
                    deferred.resolve();
                    return callback ? promise.then(function(){ return callback(); }) : promise;
                }]
            }
          }


      }
    ]
  );
