app.filter('orTypeFilter', function() {
    return function(input, idArray) {
         return _.filter(input,function(n){ return idArray.indexOf(n.pTypeId)>=0 });
    }
});


app.filter('propsFilter', function() {
    return function(items, props) {
        var out = [];

        if (angular.isArray(items)) {
          items.forEach(function(item) {
            var itemMatches = false;

            var keys = Object.keys(props);
            for (var i = 0; i < keys.length; i++) {
              var prop = keys[i];
              var text = props[prop].toLowerCase();
              if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                itemMatches = true;
                break;
              }
            }

            if (itemMatches) {
              out.push(item);
            }
          });
        } else {
          // Let the output be the input untouched
          out = items;
        }

        return out;
    };
});

app.controller('admincategory', function ($rootScope, $scope, $location, $sce, cooConfig, g, rest ) {
    $rootScope.settingMode = true;
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

  if (cooConfig.configObj.adminDisabled) {
       $('button').prop('disabled',true);
  }

  $scope.startIndex =1;
  $scope.pageSize = 10;
  $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
  $scope.categoryStep = cooConfig.configObj.categoryStep;


  $scope.pgClear =function()
  {
      $('.pgpt').hide();
  };

  $scope.sync_id = function()
  {
     $('.hide .index').prop("disabled",false);
  }

   $scope.pgSetting = function()
   {
      g.codeSetting();

   };

   $scope.popv =function($event)
   {
        g.popv($event);
   };







    $scope.renderList = function(){
        $scope.result = [];
        var etor = {
            key:"category",
            pageIndex: $scope.startIndex,
            pageSize:$scope.pageSize
        };
        $.when(rest.adminList2(etor)).done(function (ret) {

            $scope.result = ret.data;
            $("#rowcount").val(ret.data.length);



            $scope.totalItems = ret.cc>0?ret.cc:1000;
            $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;
            $scope.numPages =$scope.maxPages;

            $scope.$$phase || $scope.$apply();


            g.jqueryInit('',0);
        });
    }

    $scope.renderList();




    $scope.adapter = function () {

      $('button').prop("disabled",true);

        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryName: '',
                            cOrder: 0,
                            status: false,
                            eName: '',
                            property:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            var  erow1 = _.find($scope.result,function(n){ return n.ID==parseInt(tid)  });

                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 && !erow['new']) {
                                updateList.push(erow);
                            } else {
                              if ($scope.categoryStep && $scope.categoryStep>0){
                                   erow.cOrder = $scope.categoryStep;
                                }
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'category',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };



            if (!checkdupe()) {
                g.modal1('分类名称(或英文)重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='eName']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
                console.log(o);
            }
        });
        console.log(chk);
        return chk;
    };

    $scope.selectPage  =function(p)
    {
          console.log(p);
          if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
          {
            $scope.startIndex = $scope.startIndex+p;

            console.log(  $scope.startIndex);
             $scope.renderList();
          }
    }


    $scope.pageSizeChange = function (p) {
        $scope.pageSize = p;
        $scope.startIndex = 1;
        $scope.renderList();
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});






app.controller('admintrigger', function ($rootScope, $timeout, $scope, $location, $sce, $stateParams,$filter, $modal,  cooConfig, g, rest , editableOptions, editableThemes ) {


    editableThemes.bs3.inputClass = 'input-sm';
    editableThemes.bs3.buttonsClass = 'btn-sm';
    editableOptions.theme = 'bs3';


   $timeout(function(){
        if (cooConfig.configObj.adminDisabled) {
             $('button').prop('disabled',true);
             $('#updateBtn').prop('disabled',true);
        }
   },300);


   $scope.popTxt =function($event)
   {
       var s = $($event.target).parent('tr').find('input.form-control').val();


        g.popTxt($event);
   };

   $scope.test =function (id) {

        var etor ={ id:id};

         $.when(rest.testTrigger(etor)).done(function(ret){
              g.modal1(ret);
         });

      // body...
    }



   $scope.pgClear =function()
   {
       $('.pgpt').hide();
   };


   $scope.pgSetting = function()
   {
    //  g.textSetting();
        var content =$('.pgpt textarea').val() ;

        var aid = $('.pgpt').parent('div').find('input').val();


        var aRow = _.find($scope.appconfigs,function(n){ return n.ID ==aid });
        if (aRow){
           aRow.triggerSource = content;
           console.log('change');
        }



//        $('.pgpt').parent('div').find('textarea').val(content).attr('v','e');



        $('.pgpt').hide();

   };







  $scope.renderList = function(){

     var etor ={
        key: "trigger"
    };


     g.show_ajax();
     $scope.appconfigs=[];
     $scope.rawData= [];
     $.when(rest.adminList(etor)).done(function(ret){

           $(ret).each(function (j, p) {
                if (p.categoryId== $stateParams.categoryId) {
                    $scope.appconfigs.push(p);
                }
            });

           $scope.rawData = ret;
           $scope.row = ret.length>0?ret[0]:{};
           g.hide_ajax();
           $scope.$$phase || $scope.$apply();

     });
  }








  $scope.cancelRow = function(){
    if ($scope.inserted){
          $scope.appconfigs = _.filter( $scope.appconfigs,function(n){ return n.ID != $scope.inserted.ID });
        console.log($scope.appconfigs);
         $scope.$$phase || $scope.$apply();
    }

  }




  $scope.renderList();

  $scope.row = {
  };





  $scope.checkName = function(col, data) {

  };

  $scope.saveRow = function(data) {





             var itemId =0;
             var exRow = _.find($scope.rawData,function(n){ return n.ID== data.ID});
             var exData = _.find($scope.appconfigs,function(n){ return n.ID== data.ID});


             console.log(data);
             console.log(exRow);
             console.log(exData);




             var insertList =[];
             var updateList =[];


             if (exRow){
               exRow.categoryId = $stateParams.categoryId;

               exRow.triggerBefore = exData.triggerBefore;
               exRow.triggerSource = exData.triggerSource;
               exRow.triggerType = exData.triggerType ;
               updateList.push(exRow);
             }else {
               exData.categoryId = $stateParams.categoryId;
               insertList.push(exData);
             }

              var etor = {
                  key: 'trigger',
                  insertList: JSON.stringify(insertList),
                  updateList: JSON.stringify(updateList),
                  delIds: []
              };

              g.show_ajax();
              console.log(etor);
          //     return false;
              $.when(rest.adminAdapter(etor)).done(function (result) {
                 $scope.renderList();
              });





  };

  // remove user
  $scope.removeRow = function(index,ID) {

        g.modal_confirm("确认删除x？",function(){

          $scope.appconfigs = _.filter($scope.appconfigs,function(n){ return n.ID!= ID });

          var oldRow = _.find($scope.rawData,function(n){ return n.ID == ID });

          if(oldRow){
              var etor = {
                  key: 'trigger',
                  insertList: '[]',
                  updateList: '[]',
                  delIds: [ID]
              };

              g.show_ajax();
              console.log(etor);
           //   return false;
              $.when(rest.adminAdapter(etor)).done(function (result) {
                 $scope.renderList();
              });
          }
        });

  };



  // add user
  $scope.addRow = function() {
    $scope.inserted = {
          triggerBefore: false,
          triggerSource: '' ,
          triggerType:0,
          ID: 0
    };
    $scope.row = $scope.inserted;
    $scope.appconfigs.push($scope.inserted);
  };

});




app.controller('adminroute', function ($rootScope, $timeout, $scope, $location, $sce,$filter, $modal,  cooConfig, g, rest , editableOptions, editableThemes ) {



    editableThemes.bs3.inputClass = 'input-sm';
    editableThemes.bs3.buttonsClass = 'btn-sm';
    editableOptions.theme = 'bs3';

   $scope.rawData =[];
   $scope.startIndex =1;
   $scope.pageSize = 100;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
   $scope.lsc = [];

   $timeout(function(){
        if (cooConfig.configObj.adminDisabled) {
             $('button').prop('disabled',true);
             $('#updateBtn').prop('disabled',true);
        }
   },300);





  $scope.renderList = function(){

     var etor ={
         key:'route',         pageIndex : $scope.startIndex,         pageSize: $scope.pageSize
     }



     g.show_ajax();
     $scope.appconfigs=[];
     $.when(rest.adminList2(etor)).done(function(ret){

           $scope.appconfigs = ret.data;
           $(ret.data).each(function(i,j){
               $scope.rawData.push(j);
           });
           $scope.row = ret.data[0];
           g.hide_ajax();
           $scope.totalItems = ret.cc>0?ret.cc:1;
           $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;
           $scope.numPages =$scope.maxPages;
           $scope.$$phase || $scope.$apply();

     });
  }

  $scope.selectPage  =function(p)
  {
        if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
        {
          $scope.startIndex = $scope.startIndex+p;
           $scope.renderList();
        }
  }

  $scope.select_clear =function(){
    $scope.lsc =[];
      $scope.startIndex =1;
     $scope.text_valuex ='';
     $scope.renderList();

  }

  $scope.pageSizeChange = function (p) {
      $scope.pageSize = p;
      $scope.startIndex = 1;
      $scope.renderList();
  };

  $scope.text_change = function(text_labelx,text_valuex){

       $scope.lsc =[];
       $scope.startIndex =1;
      if (text_valuex){
         $scope.lsc.push({"patternId":text_labelx,"val1":text_valuex,"pTypeId":5,"operation":6});
      }
      if ($scope.scene){
         $scope.lsc.push({"patternId": 469,"val1":$scope.scene,"pTypeId":2,"operation":1});
      }

      $scope.renderList();

  }




  $scope.cancelRow = function(){
    if ($scope.inserted){
          $scope.appconfigs = _.filter( $scope.appconfigs,function(n){ return n.ID != $scope.inserted.ID });
        console.log($scope.appconfigs);
         $scope.$$phase || $scope.$apply();
    }

  }

  $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }
      $($scope.s_pats2).each(function(i,j){
          if ((j.pTypeId==5 || j.pTypeId ==7 ) && j.v ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":5,"operation":6})
          }
          if ((j.pTypeId==2 || j.pTypeId ==3 ) && j.v && j.v !=="0" ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":j.pTypeId,"operation":1})
          }
      });
      $scope.renderList();
  }



  $scope.renderList();

  $scope.row = {
  };





  $scope.checkName = function(col, data) {
    if ( col=='c380' && !data  ) {
      return "配置名称必填";
    }
    if ( col=='c381' && !data  ) {
      return "配置编号必填";
    }
    if ( col=='c382' && !data  ) {
      return "配置内容必填";
    }
    if ( col=='c439' && !data  ) {
      return "配置类型必填";
    }
    if ( col=='c469' && !data  ) {
      return "配置场景必填";
    }
  };

  $scope.saveRow = function(data) {

        console.log(data);
        console.log($scope.rawData);


             var itemId =0;
             var exRow = _.find($scope.rawData,function(n){ return n.ID== data.ID});

             var insertList =[];
             var updateList =[];


             if (exRow){
               exRow.panelName =data.panelName;
               exRow.panelProperty = data.panelProperty;
               exRow.vorder = data.vorder ;
               updateList.push(exRow);
             }else {
               insertList.push(data);
             }

              var etor = {
                  key: 'route',
                  insertList: JSON.stringify(insertList),
                  updateList: JSON.stringify(updateList),
                  delIds: []
              };

              g.show_ajax();
              console.log(etor);
           //   return false;
              $.when(rest.adminAdapter(etor)).done(function (result) {
                 $scope.renderList();
              });





  };

  // remove user
  $scope.removeRow = function(index,ID) {

        g.modal_confirm("确认删除x？",function(){

          $scope.appconfigs = _.filter($scope.appconfigs,function(n){ return n.ID!= ID });

          var oldRow = _.find($scope.rawData,function(n){ return n.ID == ID });

          if(oldRow){
              var etor = {
                  key: 'route',
                  insertList: '[]',
                  updateList: '[]',
                  delIds: [ID]
              };

              g.show_ajax();
              console.log(etor);
           //   return false;
              $.when(rest.adminAdapter(etor)).done(function (result) {
                 $scope.renderList();
              });
          }
        });

  };



  // add user
  $scope.addRow = function() {
    $scope.inserted = {
          panelName:'',
          panelProperty:'',
          vorder:0,
          ID: 0
    };
    $scope.row = $scope.inserted;
    $scope.appconfigs.push($scope.inserted);
  };

});







app.controller('admintransformcolumn', function ($rootScope, $scope, $location, $sce,$filter, $stateParams , $modal,  cooConfig, g, rest , editableOptions, editableThemes ) {

  if (cooConfig.configObj.adminDisabled) {
       $('button').prop('disabled',true);
       $('#updateBtn').prop('disabled',true);
  }


    editableThemes.bs3.inputClass = 'input-sm';
    editableThemes.bs3.buttonsClass = 'btn-sm';
    editableOptions.theme = 'bs3';

   $scope.rawData =[];
   $scope.transformcolumns=[];
   $scope.target_category_id =0;
   $scope.startIndex =1;
   $scope.pageSize = 10;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
   $scope.lsc = [];
   $scope.categoryId = $stateParams.categoryId;



      $scope.s_pats2 =[
        { ID:380,pName:'配置名称' },
        { ID:381,pName:'配置编号' },
        { ID:470,pName:'配置描述' },
      ];


      $scope.text_labelx = "380";

      var etorCate = {
          key: "category"
      };

      $scope.showStatus = function(cfg) {

            var selected = [];
            if(cfg ) {
              selected =  _.filter($scope.statuses,function(n){ return n.value == cfg.source_column_id });
            }
            return selected.length ? selected[0].text : 'Not set';
      };

      $scope.showStatus2 = function(cfg) {
        var selected = [];
        if(cfg  ) {
          selected =  _.filter($scope.statuses2,function(n){ return n.value == cfg.target_column_id });
        }
        return selected.length ? selected[0].text : 'Not set';
      };

      $scope.statuses = [
        {value: 0, text: '请选择'}

      ];

      $scope.statuses2 = [
        {value: 0, text: '请选择'}

      ];

      $scope.status2Change = function( ){

        $scope.statuses2 =[];

            $.when( rest.adminList({key:'pattern',categoryId: $scope.target_category_id })
              ).done(function(ret ){



                $scope.transformcolumns = _.filter($scope.rawTransformcolumns,function(n){
                  return n.target_category_id == $scope.target_category_id
                 });



                $(ret).each(function(i,j){
                    $scope.statuses2.push({value:j.ID ,text:j.pName});
                });
                $scope.$$phase || $scope.$apply();
           });
      }

      $scope.renderList = function(){
            console.log('x333');

           g.show_ajax();
           $.when(rest.adminList(etorCate)).done(function(ret1){

                 $scope.categories = ret1;
                 $scope.categories.push({ID:0,categoryName:'请选择'});
                 $scope.statuses = [{value: 0, text: '请选择'}];

                 if ($scope.categoryId) {

                       $.when(rest.adminList({key:'transformColumn',categoryId: $scope.categoryId }),
                        rest.adminList({key:'pattern',categoryId: $scope.categoryId })
                     ).done(function(ret2,retPattern){

                          if (ret2){
                               $scope.transformcolumns = ret2;
                               $scope.rawTransformcolumns =ret2;
                          }

                           $(retPattern).each(function(i,j){
                               $scope.statuses.push({value:j.ID ,text:j.pName});
                           });

                           $(ret2).each(function(i,j){
                               $scope.rawData.push(j);
                           });
                            $scope.row = ret2[0];
                            console.log(ret1);
                            g.hide_ajax();
                            $scope.$$phase || $scope.$apply();

                      });
                 } else{
                     g.hide_ajax();
                     $scope.$$phase || $scope.$apply();
                 }
           });





      }






    $scope.cancelRow = function(){
      if ($scope.inserted){
            $scope.transformcolumns = _.filter( $scope.transformcolumns,function(n){ return n.ID != $scope.inserted.ID });
            $scope.$$phase || $scope.$apply();
      }
    }





      $scope.renderList();

      $scope.row = {

      };





      $scope.checkName = function(col, data) {
        if ( col=='source_column_id' && !data  ) {
          return "来源字段必填";
        }
        if ( col=='target_column_id' && !data  ) {
          return "目标字段必填";
        }
        if ( col=='c382' && !data  ) {
          return "配置内容必填";
        }
        if ( col=='c439' && !data  ) {
          return "配置类型必填";
        }
        if ( col=='c469' && !data  ) {
          return "配置场景必填";
        }
      };


      $scope.saveAll = function(){

            var insertList =[];
            var updateList =[];

            $('.table').find('tr').each(function(i,j){





                if (i>1){

                  var element_id = $(j).find('[name="ID"]').val();
                  var source_column_id = $(j).find('[name="source_column_id"]').val();
                  var target_column_id = $(j).find('[name="target_column_id"]').val();
                  var pk = $(j).find('[name="pk"]').val();
                  if (source_column_id)  source_column_id = source_column_id.replace(/\D/ig,'');
                  if (target_column_id)  target_column_id = target_column_id.replace(/\D/ig,'');

                  if (element_id==0){

                      insertList.push({
                        ID:0, source_column_id:source_column_id, target_column_id:target_column_id,pk:pk,
                        source_category_id:$scope.categoryId ,target_category_id:$scope.target_category_id
                      });

                  }

                }
            });








             var etor = {
                 key: 'transformColumn',
                 insertList: JSON.stringify(insertList),
                 updateList: JSON.stringify(updateList),
                 delIds: []
             };



             g.show_ajax();
             console.log(etor);
          //   return false;
             $.when(rest.adminAdapter(etor)).done(function (result) {
                $scope.renderList();
             });



      }



      $scope.saveRow = function(data) {


                 var itemId =0;
                 var exRow = _.find($scope.rawData,function(n){ return n.ID== data.ID});

                 var insertList =[];
                 var updateList =[];





                 if (exRow){
                   exRow.target_column_id = data.target_column_id;
                   exRow.source_column_id = data.source_column_id;
                   exRow.pk = data.pk;
                   exRow.source_category_id =  $scope.categoryId;
                   exRow.target_category_id =  $scope.target_category_id;
                   updateList.push(exRow);
                 }else {
                   data.source_category_id =  $scope.categoryId;
                   data.target_category_id =  $scope.target_category_id;
                   insertList.push(data);
                 }

                  var etor = {
                      key: 'transformColumn',
                      insertList: JSON.stringify(insertList),
                      updateList: JSON.stringify(updateList),
                      delIds: []
                  };

                  g.show_ajax();



               //   return false;
                  $.when(rest.adminAdapter(etor)).done(function(result) {
                     $scope.renderList();
                  });





      };

      // remove user
      $scope.removeRow = function(index,ID) {

            g.modal_confirm("确认删除x？",function(){

              $scope.transformcolumns = _.filter($scope.transformcolumns,function(n){ return n.ID!= ID });

              var oldRow = _.find($scope.rawData,function(n){ return n.ID == ID });

              if(oldRow){
                  var etor = {
                      key: 'transformColumn',
                      insertList: '[]',
                      updateList: '[]',
                      delIds: [ID]
                  };

                  g.show_ajax();
                  console.log(etor);
               //   return false;
                  $.when(rest.adminAdapter(etor)).done(function (result) {
                     $scope.renderList();
                  });
              }
            });

      };



      // add user
      $scope.addRow = function() {
        $scope.inserted = {
           target_column_id:0,
           source_column_id:0,
           pk :0,
           source_category_id : 0,
           target_category_id : 0,
           ID: 0
        };
        $scope.row = $scope.inserted;
        $scope.transformcolumns.push($scope.inserted);
      };

});




app.controller('adminconfiguration', function ($rootScope, $scope, $location, $sce,$filter, $modal,  cooConfig, g, rest , editableOptions, editableThemes ) {



    editableThemes.bs3.inputClass = 'input-sm';
    editableThemes.bs3.buttonsClass = 'btn-sm';
    editableOptions.theme = 'bs3';

   $scope.rawData =[];
   $scope.startIndex =1;
   $scope.pageSize = 10;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
   $scope.lsc = [];
   $scope.categoryId = 100039;
   $scope.pageId =100039;


  $scope.s_pats2 =[
    { ID:380,pName:'配置名称' },
    { ID:381,pName:'配置编号' },
    { ID:470,pName:'配置描述' },
  ];


  $scope.text_labelx = "380";


  $scope.renderList = function(){

     var etor ={
         key:'configuration',         pageIndex : $scope.startIndex,         pageSize: $scope.pageSize ,joinId :0
     }

     if (cooConfig.configObj.configuration_group_id)  etor['joinId'] = -1;


     g.show_ajax();
     $scope.appconfigs=[];
     $.when(rest.adminList2(etor)).done(function(ret){

           $scope.appconfigs = ret.data;
           $(ret.data).each(function(i,j){
               $scope.rawData.push(j);
           });
           $scope.row = ret.data[0];
           g.hide_ajax();
           $scope.totalItems = ret.cc>0?ret.cc:1;
           $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;
           $scope.numPages =$scope.maxPages;
           $scope.$$phase || $scope.$apply();

     });
  }

  $scope.selectPage  =function(p)
  {
        if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
        {
          $scope.startIndex = $scope.startIndex+p;
           $scope.renderList();
        }
  }

  $scope.select_clear =function(){
    $scope.lsc =[];
      $scope.startIndex =1;
     $scope.text_valuex ='';
     $scope.renderList();

  }

  $scope.pageSizeChange = function (p) {
      $scope.pageSize = p;
      $scope.startIndex = 1;
      $scope.renderList();
  };

  $scope.text_change = function(text_labelx,text_valuex){

       $scope.lsc =[];
       $scope.startIndex =1;
      if (text_valuex){
         $scope.lsc.push({"patternId":text_labelx,"val1":text_valuex,"pTypeId":5,"operation":6});
      }
      if ($scope.scene){
         $scope.lsc.push({"patternId": 469,"val1":$scope.scene,"pTypeId":2,"operation":1});
      }

      $scope.renderList();

  }




  $scope.cancelRow = function(){
    if ($scope.inserted){
          $scope.appconfigs = _.filter( $scope.appconfigs,function(n){ return n.ID != $scope.inserted.ID });
        console.log($scope.appconfigs);
         $scope.$$phase || $scope.$apply();
    }

  }

  $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }
      $($scope.s_pats2).each(function(i,j){
          if ((j.pTypeId==5 || j.pTypeId ==7 ) && j.v ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":5,"operation":6})
          }
          if ((j.pTypeId==2 || j.pTypeId ==3 ) && j.v && j.v !=="0" ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":j.pTypeId,"operation":1})
          }
      });
      $scope.renderList();
  }



  $scope.renderList();

  $scope.row = {
  };





  $scope.checkName = function(col, data) {
    if ( col=='c380' && !data  ) {
      return "配置名称必填";
    }
    if ( col=='c381' && !data  ) {
      return "配置编号必填";
    }
    if ( col=='c382' && !data  ) {
      return "配置内容必填";
    }
    if ( col=='c439' && !data  ) {
      return "配置类型必填";
    }
    if ( col=='c469' && !data  ) {
      return "配置场景必填";
    }
  };

  $scope.saveRow = function(data) {

        console.log(data);
        console.log($scope.rawData);


             var itemId =0;
             var exRow = _.find($scope.rawData,function(n){ return n.ID== data.ID});

             var insertList =[];
             var updateList =[];


             if (exRow){
               exRow.configuration_title =data.configuration_title;
               exRow.configuration_key = data.configuration_key;
               exRow.configuration_value = data.configuration_value;
               exRow.configuration_description = data.configuration_description;
               exRow.configuration_group_id  =data.configuration_group_id;
               updateList.push(exRow);
             }else {
               insertList.push(data);
             }

              var etor = {
                  key: 'configuration',
                  insertList: JSON.stringify(insertList),
                  updateList: JSON.stringify(updateList),
                  delIds: []
              };

              g.show_ajax();
              console.log(etor);
           //   return false;
              $.when(rest.adminAdapter(etor)).done(function (result) {
                 $scope.renderList();
              });





  };

  // remove user
  $scope.removeRow = function(index,ID) {

        g.modal_confirm("确认删除x？",function(){

          $scope.appconfigs = _.filter($scope.appconfigs,function(n){ return n.ID!= ID });

          var oldRow = _.find($scope.rawData,function(n){ return n.ID == ID });

          if(oldRow){
              var etor = {
                  key: 'configuration',
                  insertList: '[]',
                  updateList: '[]',
                  delIds: [ID]
              };

              g.show_ajax();
              console.log(etor);
           //   return false;
              $.when(rest.adminAdapter(etor)).done(function (result) {
                 $scope.renderList();
              });
          }
        });

  };



  // add user
  $scope.addRow = function() {
    $scope.inserted = {
          configuration_title:'',
          configuration_key:'',
          configuration_value:'',
          configuration_description:'',
          configuration_group_id:0,
          ID: 0
    };
    $scope.row = $scope.inserted;
    $scope.appconfigs.push($scope.inserted);
  };

});








app.controller('admincategoryauth', function ($rootScope, $scope, $location, $sce, cooConfig, g, rest, ngDialog) {
      $rootScope.settingMode = true;
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };




    var etor = {
        key: "categoryAuth"
    };

    var etorRole = {
        key:"roles"
    };

    var etorCate = {
        key: "category"
    };

    $scope.result = [];
    $scope.roles = [];
    $scope.cates = [];

    $.when(rest.adminList(etor), rest.adminList(etorRole), rest.adminList(etorCate)).done(function (result, roles,cates) {








        $(roles).each(function (i,o) {
            o.RoleName = o.RoleName.replace(/^\d+:/ig,'');
        });

        $scope.roles = roles;
        $scope.cates = cates;


        var mycates = [];
        var myroles =[];
        _.each(cates,function(i,j){
              mycates.push({label:i.categoryName,value:i.ID});
        });

       _.each(roles,function(i,j){
             myroles.push({label:i.RoleName.replace(/^\d+:/ig,""),value:i.RoleId});
       });

       $("#role").multiselect({
           enableClickableOptGroups: true,
           enableCaseInsensitiveFiltering: true,
           includeSelectAllOption: true,
           maxHeight: 400,
           dropUp: true
         });


        $("#cate").multiselect({
            enableClickableOptGroups: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            dropUp: true
          });
        var opts={ enableClickableOptGroups: true};

        if (mycates.length>0)   $("#cate").multiselect('dataprovider',mycates);
        if (myroles.length>0)   $("#role").multiselect('dataprovider',myroles);


        $scope.result = result;
        $("#rowcount").val(result.length);
        $scope.$apply();
        g.jqueryInit('',0);
    });

    $scope.bulkadd=function(){

      var $table = $(".excelTable");


      var c1 =$('#cate').val();
      var r1 = $("#role").val();

      _.each(c1,function(p,q){
           _.each(r1,function(s,t){
              var $row = $table.find("tr:nth-child(2)").clone();
              $row.removeClass("hide");
              console.log($row);
              $row.find('[name="categoryId"]').val(p).attr('v','e');
              $row.find('[name="roleId"]').val(s).attr('v','e');
              $table.append($row);
           })
      });

    };


    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId:0,
                            roleId: '00000000-0000-0000-0000-000000000000'
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'categoryAuth',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('分类，角色重复设置');
            }
            else {
               // console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='categoryId']").val();
                var d = $(tr).find("[name='roleId']").val();
                checklist.push(JSON.stringify({ c: c, d: d }));
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o])
            {
                flag[o] = true;
            }
            else
            {
                chk = false;
            }
        });
        return chk;
    };



    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v','e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});



app.controller('adminauth', function ($rootScope, $scope, $location, $sce, $routeParams, cooConfig, g, rest, ngDialog) {
      $rootScope.settingMode = true;
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };



    var etorRole = {
        key: "roles"
    };

    var etorCate = {
        key: "category"
    };


    var categoryId = $routeParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;

    var etor = {
        key: "auth",
        categoryId:categoryId
    };

    var etorPattern = {
        key: "pattern",
        categoryId: categoryId
    };

    $scope.result = [];
    $scope.roles = [];
    $scope.cates = [];
    $scope.patterns = [];

    $scope.patterns.push({ ID: 0, pName: '请选择' });
    $scope.roles.push({ RoleId: '00000000-0000-0000-0000-000000000000', RoleName: '请选择' });

    $.when(rest.adminList(etorCate)).done(function (cates) {

        $scope.cates = cates;
        if (categoryId > 0)
        {
            $scope.category = g.filterListById(cates, categoryId)[0];

            $.when(rest.adminList(etor), rest.adminList(etorRole), rest.adminList(etorPattern)).done(function (result, roles, patterns) {

                $(roles).each(function (i, o) {
                    o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                    $scope.roles.push(o);
                });

                $(patterns).each(function (i, o) {
                    if (o.pTypeId == 12 || o.pTypeId == 19) {
                        $scope.patterns.push(o);
                    }
                });

                console.log(result);

                $scope.result = result;
                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);

            });
        }
        $scope.$apply();
    });

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            RoleId: '00000000-0000-0000-0000-000000000000',
                            userPatternId: 0,
                            isReadable: false,
                            isEditable:false,
                            rowRule:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'auth',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('角色,用户列重复设置');
            }
            else {
                 console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist1 = [];
        var checklist2 = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='RoleId']").val();
                var d = $(tr).find("[name='userPatternId']").val();
                checklist1.push(c);
                checklist2.push(d);
            }
        });
        var flag1 = [];
        $(checklist1).each(function (i, o) {
            if (o != '00000000-0000-0000-0000-000000000000') {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                }
            }
        });

        $(checklist2).each(function (i, o) {
            if (o != 0) {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                }
            }
        });

        return chk;
    };



    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});







app.controller('adminpattern', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig,   g, rest, $timeout) {

    $rootScope.settingMode = true;

    $scope.result = [];
    $scope.categoryResult = [];
    var pTypes = [];

    var categoryId = $stateParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;
    $scope.pTypes = cooConfig.pTypes;
    $scope.categoryStep = cooConfig.configObj.categoryStep;

    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
         $('#updateBtn').prop('disabled',true);
    }



  //  $scope.category = _.find(cooConfig.allcategory, function (c) { return c.ID == categoryId });


    $scope.pgClear =function()
    {
        $('.pgpt').hide();
    };


     $scope.pgSetting = function()
     {
        g.codeSetting();

     };

     $scope.popv =function($event)
     {
          g.popv($event);
     };














    var etor = {
        key: "pattern",
        categoryId:categoryId
    };

    var etorCate = {
        key:"category"
    };


    $.when(rest.adminList(etorCate)).done(function (categoryResult) {

        $scope.categoryResult = categoryResult;



     //   $scope.category = g.filterListById(categoryResult,categoryId)[0];

        if (categoryId != 0) {
            $.when(rest.adminList(etor)).done(function (result) {


                $scope.category = _.find(categoryResult, function (c) { return c.ID == categoryId });
             //   console.log( $scope.category );


                $scope.result = result;
                $scope.result1 = result;
          //      console.log(result);

                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit();
                var pTypes = $scope.pTypes;
                // $("[name='pType']").multiselect({
                //         enableClickableOptGroups: true,
                //         enableCaseInsensitiveFiltering: true,
                //         includeSelectAllOption: true,
                //         maxHeight: 130,
                //         dropUp: true
                //       });
                // $("[name='pType']").multiselect('select',pTypes);
            });
        }

        $scope.$apply();
    });



    $scope.openBase = function () {

        $('#create').attr('disabled',false);
        $('#edit').attr('disabled', false);
        $('#list').attr('disabled', false);
        $('#import').attr('disabled', false);
        $('#export').attr('disabled', false);
        $('#view').attr('disabled', false);
        $('#report').attr('disabled', false);
    };


    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != ''&& !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    console.log($(this).val());
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });




        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            pName: '',
                            pTypeId: 1,
                            eName: '',
                            validator: '',
                            required: false,
                            disabled: false,
                            isUnique: false,
                            isSortStatistic: -1,
                            property:'',
                            pOrder: 0,
                            categoryId: categoryId
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {


                            var  erow1 = _.find($scope.result,function(n){return n.ID ==parseInt(tid)}) ;
                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var  v= $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");

                                if ($(this).attr('name') == 'isSortStatistic') {
                                    if (v) { v = 101 } else { v = -1 };
                                }

                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 &&　!erow['new']) {
                                updateList.push(erow);
                            } else {
                                if ($scope.categoryStep && $scope.categoryStep>0){
                                   erow.pOrder = $scope.categoryStep;
                                }
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }



            var etor = {
                key: 'pattern',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };


            console.log(etor);

        //    return false;

            $('#updateBtn').prop('disabled',true);

            if (insertList.length+updateList.length+delist.length==0)
            {
                g.modal1('无变化！');


            }
            else
            {
                var dic = [];
                if ($('#base').is(':checked'))
                {
                    dic.push('base');
                    if ($('#create').is(':checked')) { dic.push('create'); }
                    if ($('#edit').is(':checked')) { dic.push('edit'); }
                    if ($('#list').is(':checked')) { dic.push('list'); }
                    if ($('#import').is(':checked')) { dic.push('import'); }
                    if ($('#export').is(':checked')) { dic.push('export'); }
                    if ($('#view').is(':checked')) { dic.push('view'); }
                    if ($('#report').is(':checked')) { dic.push('report'); }
                }

                g.show_ajax();


                if (dic.length > 0) {

                    if (cooConfig.configObj.categoryStep &&  cooConfig.configObj.categoryStep>0){
                       dic.push(cooConfig.configObj.categoryStep.toString());
                    }


                    etor['dic'] = dic;

                    console.log(etor);

                    $.when(rest.adminAdapterPattern(etor)).done(function (result) {
                        console.log(result);
                        g.hide_ajax();
                        g.modal1('已更新');
                    });


                } else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.hide_ajax();
                        g.modal1('已更新');
                    });
                }
            }
        }
    };

    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };



    $scope.sync_id = function()
    {
       $('.hide .index').prop("disabled",false);
    }

    $scope.findByType = function () {
      var bool = $("[name='pTypeId']").val();
      var res = $scope.result1;
      $scope.result=_.filter(res,function (n) {
          return n.pTypeId==bool;
         });
     $scope.$$phase || $scope.$apply();


    }
    $scope.findByID = function () {
      var val = $('#sum').val();
      var obj=[];



      var pats = g.fetch2(cooConfig.COOITEMPATTERNTABLENAME);


      obj=_.find(pats,function (n) {
        return n.ID == parseInt(val);
      });

      $rootScope.patternId=obj.categoryId;
      $rootScope.value = val;

      window.location.href = '#/app/admin/pattern/'+obj.categoryId;

    }
});



app.controller('admincolumnauth', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig,   g, rest, $timeout) {

    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
         $('#updateBtn').prop('disabled',true);
    }


    $scope.result = [];
    $scope.result1 = [];
    $scope.cates = [];
    $scope.roles = [];
    $scope.roles1 = [];
    $scope.patterns = [];
    $scope.roles.push({ RoleId: '00000000-0000-0000-0000-000000000000', RoleName: '请选择' });

    var categoryId = $stateParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;
    $scope.pTypes = cooConfig.pTypes;

    var etor = {
        key: "columnAuth",
        categoryId: categoryId
    };

    var etorRole = {
        key: "roles"
    };

    var etorCate = {
        key: "category"
    };

    var etorPattern = {
        key: "pattern",
        categoryId: categoryId
    };


    $.when(rest.adminList(etorCate)).done(function (cates) {

        $scope.cates = cates;
        $scope.category = _.find(cates,function(n){ return n.ID==categoryId});



        if (categoryId != 0) {
            $.when(rest.adminList(etor),rest.adminList(etorRole),rest.adminList(etorPattern)).done(function (result,roles,patterns) {

               console.log(result);

                $(roles).each(function (i, o) {
                    o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                    $scope.roles.push(o);

                });
                $scope.roles1 = $scope.roles;
                $scope.patterns = patterns;
                $scope.result = result;
                $scope.result1 = result;





                        var mypats = [];
                        var myroles =[];

                        _.each(patterns,function(i,j){
                              mypats.push({label:i.pName,value:i.ID});
                        });

                       _.each(roles,function(i,j){
                             myroles.push({label:i.RoleName.replace(/^\d+:/ig,""),value:i.RoleId});
                       });

                       $("#role").multiselect({
                           enableClickableOptGroups: true,
                           enableCaseInsensitiveFiltering: true,
                           includeSelectAllOption: true,
                           maxHeight: 400,
                           dropUp: true
                         });
                         $("#rol").multiselect({
                             enableClickableOptGroups: true,
                             enableCaseInsensitiveFiltering: true,
                             includeSelectAllOption: true,
                             maxHeight: 250,
                             dropUp: true
                           });
                           $("#pat").multiselect({
                               enableClickableOptGroups: true,
                               enableCaseInsensitiveFiltering: true,
                               includeSelectAllOption: true,
                               maxHeight: 250,
                               dropUp: true
                             });
                        $("#column").multiselect({
                            enableClickableOptGroups: true,
                            enableCaseInsensitiveFiltering: true,
                            includeSelectAllOption: true,
                            maxHeight: 400,
                            dropUp: true
                          });

                        var opts={ enableClickableOptGroups: true};

                        if (mypats.length>0)   $("#column").multiselect('dataprovider',mypats);
                        if (myroles.length>0)   $("#role").multiselect('dataprovider',myroles);
                        $("#rol").multiselect('dataprovider',myroles);
                        $("#pat").multiselect('dataprovider',mypats);







                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);
            });
        }

        $scope.$apply();
    });

    $scope.bulkadd=function(){

      var $table = $(".excelTable");


      var c1 =$('#column').val();
      var r1 = $("#role").val();

      _.each(c1,function(p,q){
           _.each(r1,function(s,t){
              var $row = $table.find("tr:nth-child(2)").clone();
              $row.removeClass("hide");
              $row.find('[name="patternId"]').val(p).attr('v','e');
              $row.find('[name="roleId"]').val(s).attr('v','e');
              $row.find('[name="isReadable"]').attr('checked','checked').attr('v','e');
              $row.find('[name="isEditable"]').attr('checked','checked').attr('v','e');
              $table.append($row);
           })
      });

    };


    $scope.adapter = function () {
  $('#updateBtn').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            patternId:0,
                            categoryId: categoryId,
                            roleId: '00000000-0000-0000-0000-000000000000',
                            isReadable: false,
                            isEditable: false
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result,function(n){ return n.ID==parseInt(tid)});
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'columnAuth',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('列+角色重复设置');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='patternId']").val();
                var d = $(tr).find("[name='roleId']").val();
                checklist.push(JSON.stringify({ c: c, d: d }));
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });
        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
    //lllllllllllllllllll
    $scope.findMenu3 = function () {
      var name = $('#pat').val();
      var user = $('#rol').val();
      var roles = [];
      role = $scope.roles1;
      res = $scope.result1;

      if (user!==null && name!==null) {
        res1 = _.filter(res,function (n) {
          return _.any(user,function (m) {
            return _.any(name,function (o) {
              return n.roleId.toLowerCase() == m.toLowerCase() && n.patternId==o;
            });
          })
        });
      }else if (user !== null && name==null) {
        res1 = _.filter(res,function (n) {
          return _.any(user,function (m) {
            return n.roleId.toLowerCase() == m.toLowerCase();
          })
        });
      }else{
        res1 = _.filter(res,function (n) {
          return _.any(name,function (m) {
            return n.patternId==m;
          })
        });
      }
      $scope.result = res1;

      $scope.$$phase || $scope.$apply();
    }

    //llllllllllllllllllll
});




app.controller('adminauthmenu', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest ) {

        var etor ={
             key :"menuAuth"
        };

        var etorMenus = {
            key: "menu"
        };

        var  etorRoles = {
           key:"roles"
        };

          $scope.selectedRole ='00000000-0000-0000-0000-000000000000';

        $scope.roleChange = function(){

          var selectedList = _.filter($scope.result2 ,function(n){ return n.roleId ==$scope.selectedRole});
          var selectedIds = _.pluck(selectedList,"menuId");

           $($scope.menus).each(function(i,j){
               $(j.children).each(function(x,y){
                 y.checked =false;
                 if (selectedIds.indexOf(y.ID)>=0){
                   y.checked =true;
                 }
               })
           });

           console.log($scope.menus);

           $scope.$$phase || $scope.$apply();



        }

        $scope.init = function(){
          $scope.menus = [];

          $scope.roles = [];
          $scope.roles.push({ RoleId: '00000000-0000-0000-0000-000000000000', RoleName: '请选择' });


                g.show_ajax();

                $.when(rest.adminList(etorMenus),rest.adminList(etorRoles)).done(function (result, rs ) {
                  $scope.result1 = result;
                    $scope.roles1 = rs;
                    $.when(rest.adminList(etor)).done(function (aus) {
                      // body...
                          $scope.result2 = aus;
                          var levels = _.filter(result,function(n){ return !n.parentId });
                          levels = _.sortBy(levels,"morder");

                          $(levels).each(function(i,j){
                            var l = { name: j.pName, children:[] };

                             var q =[];
                             q.push(j.ID);
                             l.children.push(j);
                             while(q.length>0){
                                  var dq = q.pop();
                                  var subList = _.filter(result,  function(n){ return n.parentId ==dq} );
                                  $(subList).each(function(x,y){
                                     l.children.push(y);
                                     q.push(y.ID);
                                  });
                             }
                             $scope.menus.push(l);
                          });









                          // $(result).each(function (i,j) {
                          //    $scope.menus.push({ID:j.ID,pName:j.pName});
                          // })

                          $(rs).each(function (i, o) {
                              o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                              $scope.roles.push(o);
                          });


                        if (  $scope.selectedRole !='00000000-0000-0000-0000-000000000000')
                        {

                          var selectedList = _.filter($scope.result2 ,function(n){ return n.roleId ==$scope.selectedRole});
                          var selectedIds = _.pluck(selectedList,"menuId");

                           $($scope.menus).each(function(i,j){
                               $(j.children).each(function(x,y){
                                 y.checked =false;
                                 if (selectedIds.indexOf(y.ID)>=0){
                                   y.checked =true;
                                 }
                               })
                           });


                        }






                    //      $scope.result = aus;
                          g.hide_ajax();
                          $scope.$apply();

                    })



               });

        }

         $scope.init();

      $scope.adapter = function(){

          if ($scope.selectedRole =='00000000-0000-0000-0000-000000000000'){
             g.modal1("请选择角色");
              return false;
          }


          console.log($scope.selectedRole);

            var erow = {
                ID: 0,
                menuId:0,
                roleId:'00000000-0000-0000-0000-000000000000'
            };

            var insertList =[];
            var delist =[];
            var delIds = [];
            var selectedList = _.filter($scope.result2 ,function(n){ return n.roleId ==$scope.selectedRole});
            var selectedIds = _.pluck(selectedList,"menuId");

            console.log(selectedIds);


          $($scope.menus).each(function(i,j){
              $(j.children).each(function(x,y){
                if (y.checked && selectedIds.indexOf(y.ID)<0){
                    insertList.push({
                        ID: 0,
                        menuId:y.ID,
                        roleId: $scope.selectedRole
                    });
                }
                if (!y.checked  ){

                   if (selectedIds.indexOf(y.ID)>=0)
                   {
                          delIds.push(y.ID);
                   }

                }
              })
          });

          console.log(delIds);

          delist =  _.filter($scope.result2,function(n){
            return  delIds.indexOf(n.menuId) >=0
          });


          var etor = {
              key: 'menuAuth',
              insertList: JSON.stringify(insertList),
              updateList:"[]",
              delIds: _.pluck(delist,'ID')
          };

          console.log(etor);



          $.when(rest.adminAdapter(etor)).done(function (result) {
              console.log(result);
              g.modal1('已更新');
              $scope.init();
          });










      }








});




app.controller('adminmenuauth', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };
      $rootScope.settingMode = true;

      if (cooConfig.configObj.adminDisabled) {
           $('button').prop('disabled',true);
           $('#updateBtn').prop('disabled',true);
      }


   //page
     var p= 1;
     var size =12;
     if ($stateParams.p)  p= $stateParams.p;
     if ($stateParams.size) size = $stateParams.size;
     $scope.size =size;
     $scope.pages =[];
     $scope.p = p;



    var roles = [];
    $scope.selectedMenu ='0';
    $scope.selectedRole ='00000000-0000-0000-0000-000000000000';


    var url = window.location.href;
    var r1 =/roleid=([a-z0-9-]+)/ig;
    var r2 = /menuid=([a-z0-9-]+)/ig;
    if (url.indexOf('roleid')>=0)
    {
      $scope.selectedRole = url.match(r1)[0].replace(/roleid=/ig,'');
    }
    if (url.indexOf('menuid')>=0)
    {
      $scope.selectedMenu = url.match(r2)[0].replace(/menuid=/ig,'');
    }

    $scope.param='';
    $scope.result = [];
    $scope.result1 = [];
    $scope.menus = [];
    $scope.menus.push({ID:0,pName:'请选择'});
    $scope.roles = [];
    $scope.roles1 = [];
    $scope.roles.push({ RoleId: '00000000-0000-0000-0000-000000000000', RoleName: '请选择' });
    var roles = $scope.roles;


    var etor ={
         key :"menuAuth"
    };

    var etorMenus = {
        key: "menu"
    };

    var  etorRoles = {
       key:"roles"
    };

    $scope.makeParam = function(){

      var param ='';
      if ($scope.selectedMenu!='0' ||$scope.selectedRole!='00000000-0000-0000-0000-000000000000')
      {
         param +="?";
      }
      if ($scope.selectedMenu!='0' ) {
         param +="&menuid=" + $scope.selectedMenu;
      }
      if ($scope.selectedRole!='00000000-0000-0000-0000-000000000000' ) {
         param +="&roleid=" + $scope.selectedRole;
      }

      $scope.param =param;

    }

    $scope.init = function(){
      $scope.menus = [];
      $scope.menus.push({ID:0,pName:'请选择'});
      $scope.roles = [];
      $scope.roles.push({ RoleId: '00000000-0000-0000-0000-000000000000', RoleName: '请选择' });


            g.show_ajax();
            $scope.makeParam();
            $.when(rest.adminList(etorMenus),rest.adminList(etorRoles)).done(function (result, rs ) {
              $scope.result1 = result;
                $scope.roles1 = rs;
                $.when(rest.adminList(etor)).done(function (aus) {
                  // body...
                  $scope.result2 = aus;
                  $scope.findUser();




                                            var mymenus = [];
                                            var myroles =[];
                                            _.each(result,function(i,j){
                                                  mymenus.push({label:i.pName,value:i.ID});
                                            });

                                           _.each(rs,function(i,j){
                                                 myroles.push({label:i.RoleName.replace(/^\d+:/ig,""),value:i.RoleId});
                                           });

                                           $("#role").multiselect({
                                               enableClickableOptGroups: true,
                                               enableCaseInsensitiveFiltering: true,
                                               includeSelectAllOption: true,
                                               maxHeight: 400,
                                               dropUp: true
                                             });


                                            $("#menu").multiselect({
                                                enableClickableOptGroups: true,
                                                enableCaseInsensitiveFiltering: true,
                                                includeSelectAllOption: true,
                                                maxHeight: 400,
                                                dropUp: true
                                              });
                                            var opts={ enableClickableOptGroups: true};

                                            if (mymenus.length>0)   $("#menu").multiselect('dataprovider',mymenus);
                                            if (myroles.length>0)   $("#role").multiselect('dataprovider',myroles);



                      $(result).each(function (i,j) {
                         $scope.menus.push({ID:j.ID,pName:j.pName});
                      })

                      $(rs).each(function (i, o) {
                          o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                          $scope.roles.push(o);
                      });


                //      $scope.result = aus;
                     g.hide_ajax();
                      $("#rowcount").val(aus.length);
                      $scope.$apply();
                      g.jqueryInit('', 0);
                      $("[name='parent']").multiselect({
                              enableClickableOptGroups: true,
                              enableCaseInsensitiveFiltering: true,
                              includeSelectAllOption: true,
                              maxHeight: 400,
                              dropUp: true
                            });
                      $("[name='parent']").multiselect('select',roles);
                })



           });

    }

     $scope.init();









    //sdfsdfsdf 0109
      $scope.nav = function(){

          var u= window.location.href.replace(/menuauth.*?$/ig,'');

          $scope.makeParam();




          window.location.href= u+"menuauth/1/12" +$scope.param;

             $scope.init();


      }


       $scope.findUser = function () {



         $scope.pages=[];
         $scope.result=[];





         var aus = _.filter($scope.result2, function(n){

            var t1 =true;
            if ($scope.selectedRole && $scope.selectedRole!='00000000-0000-0000-0000-000000000000')
            {
              t1 = t1 && n.roleId==$scope.selectedRole;
            }
            if ($scope.selectedMenu && $scope.selectedMenu!='0')
            {
              t1 = t1 && n.menuId == $scope.selectedMenu;
            }

            return t1;




         });

        console.log(aus);


         var l = (aus.length%$scope.size==0)?parseInt(aus.length/$scope.size) +1:parseInt(aus.length/$scope.size) +2;
         for(var i=1; i<l;i++){
            var v = (i==$scope.p)?"active":"";
           $scope.pages.push({active: v ,page:i});
         }



           $(aus).each(function (i,j) {
               if (($scope.p-1)*$scope.size<=i && i<$scope.p*$scope.size)
               {
                  $scope.result.push(j);
               }
           });














         $scope.$$phase || $scope.$apply();



     //    console.log(res1);
      }


       $scope.bulkadd=function(){

         var $table = $(".excelTable");


         var c1 =$('#menu').val();
         var r1 = $("#role").val();

         _.each(c1,function(p,q){
              _.each(r1,function(s,t){
                 var $row = $table.find("tr:nth-child(2)").clone();
                 $row.removeClass("hide");
                 $row.find('[name="menuId"]').val(p).attr('v','e');
                 $row.find('[name="roleId"]').val(s).attr('v','e');
                 $table.append($row);
              })
         });

       };




    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            menuId:0,
                            roleId:'00000000-0000-0000-0000-000000000000'
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result,function(n){ return n.ID == parseInt(tid) });
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'menuAuth',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('菜单+角色重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist1 = [];
        var checklist2 = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='menuId']").val();
                var d = $(tr).find("[name='roleId']").val().toLowerCase();
                checklist1.push(c +d );

            }
        });
        var flag1 = [];
        $(checklist1).each(function (i, o) {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                }
        });

        // $(checklist2).each(function (i, o) {
        //     if (!flag1[o]) {
        //         flag1[o] = true;
        //     }
        //     else {
        //         chk = false;
        //     }
        // });
        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
//lllllllllllllllllll
    $scope.findMenu1 = function () {
       var name = $('#menuName').val();
       var topName = $("[name='parent']").val();
       var res = [];
       var res1 = [];
       var res2 = [];
       var result1 = [];
       res = $scope.result2;
       res3 = $scope.result1;
       res4 = _.filter(res3,function (n) {
        return (n.pName).indexOf(name)>=0;
      });

      if (!name) name='';
      if (!topName) topName ='';

      console.log(name);
      console.log(topName);


       if (name != '' && topName !== '') {
          console.log('x');
         $scope.result = _.filter(res,function (m) {
           return _.any(res4,function (o) {
             return o.ID == m.menuId && m.roleId == topName;
           });
         });
       }else if (name == '' && topName !== '00000000-0000-0000-0000-000000000000') {

          console.log('x1');

         $scope.result = _.filter(res,function (n) {
           return n.roleId == topName;
         });
       }
       if((!topName || topName == '00000000-0000-0000-0000-000000000000'  )&& name !==''){

            console.log('x2');

         $scope.result = _.filter(res,function (m) {
           return _.any(res4,function (o) {
             return o.ID == m.menuId;
           });
         });

       }
        result = $scope.result;
       for (var i = 0; i < result.length; i++) {
         if (i<20) {
           result1.push(result[i]);
         }
       }
       $scope.result = result1;
       $scope.$$phase || $scope.$apply();

    }
    //llllllllllllllllllllllll
});




app.controller('adminmenu', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };
      $rootScope.settingMode = true;
      if (cooConfig.configObj.adminDisabled) {
           $('button').prop('disabled',true);
           $('#updateBtn').prop('disabled',true);
      }

   //page
      var p= 1;
      var size =12;
      if ($stateParams.p)  p= $stateParams.p;
      if ($stateParams.size) size = $stateParams.size;
      $scope.size =size;
      $scope.pages =[];



    $scope.result = [];
    $scope.result1 = [];
    $scope.menus = [];
    $scope.menus.push({ID:0,pName:'请选择'});
    var menus = $scope.menus;
    var etor = {
        key: "menu"
    };

    $.when(rest.adminList(etor)).done(function (result) {


      var l = (result.length%size==0)?parseInt(result.length/size) +1:parseInt(result.length/size) +2;
      for(var i=1; i<l;i++){
         var v = (i==p)?"active":"";
        $scope.pages.push({active: v ,page:i});
      }



      $(result).each(function (i,j) {
         $scope.menus.push({ID:j.ID,pName:j.pName});
          if ((p-1)*size<=i && i<p*size)
          {
             $scope.result.push(j);
            $scope.result1.push(j);
          }
      });






    //    $scope.result = result;
        $("#rowcount").val(result.length);
        $scope.$apply();
        g.jqueryInit('', 0);

        $("[name='parent']").multiselect({
                enableClickableOptGroups: true,
                enableCaseInsensitiveFiltering: true,
                includeSelectAllOption: true,
                maxHeight: 400,
                dropUp: true
              });
        $("[name='parent']").multiselect('select',menus);
   });

   $scope.pgClear =function()
   {
       $('.pgpt').hide();
   };
    $scope.pgSetting = function()
    {
       g.codeSetting();

    };

    $scope.popv =function($event)
    {
         g.popv($event);
    };


    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            pName:'',
                            eName:'',
                            url:'',
                            icon:'',
                            parentId:null,
                            isMobile:false,
                            morder: 0,
                            property:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result,function(n){ return n.ID ==parseInt(tid)  });

                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'menu',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('名称或英文名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist1 = [];
        var checklist2 = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='pName']").val();
                var d = $(tr).find("[name='eName']").val();
                checklist1.push(c);
                checklist2.push(d);
            }
        });
        console.log(checklist1);
        console.log(checklist2);
        var flag1 = [];
        $(checklist1).each(function (i, o) {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                }
        });

        $(checklist2).each(function (i, o) {
            if (!flag1[o]) {
                flag1[o] = true;
            }
            else {
                chk = false;
            }
        });
        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
    //lllllllllllllllllllllllllll
    $scope.findMenu = function () {
      var name = $('#menuName').val();
      var topName = $("[name='parent']").val();
      var res = [];
      var res1 = [];
      res = cooConfig.allmenu;

      if (!name) name="";
      if (!topName) topName ="";

      if (name !== '' && topName !=='') {
        res1 = _.filter(res,function (n) {
          return (n.pName).indexOf(name)>=0 && n.parentId==topName;
        });
      }else if (name == ''&&topName !== 0) {
        res1 = _.filter(res,function (n) {
          return  n.parentId==topName;
        });
      }
      if (name !== ''&&topName == 0) {
        res1 = _.filter(res,function (n) {
          return (n.pName).indexOf(name)>=0;
        });
      }
      $scope.result = res1;
      console.log(topName);

      $scope.$$phase || $scope.$apply();
    }

//lllllllllllllllllllllllllllllllll
});







app.controller('admingroupset', function ($rootScope, $scope, $location, $sce, $routeParams, cooConfig, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

      $rootScope.settingMode = true;


    $scope.result = [];
    $scope.groups = [];
    $scope.groups.push({groupId:'00000000-0000-0000-0000-000000000000',groupName:'请选择'});



    var etor = {
        key: "groupSet"
    };

    var etorGroup = {
        key: "group"
    };


    $.when(rest.adminList(etorGroup)).done(function (groups) {

        $scope.groups = groups;

        $.when(rest.adminList(etor)).done(function (result) {
                      $scope.result =  result;
                      $("#rowcount").val(result.length);
                      $scope.$apply();
                      g.jqueryInit('', 0);
        });

    });


  $scope.pgSetting=function()
  {


    var json = {};
    $('.pgpt table tr.addrow').each(function(i,j){
         var key =   $(j).find('input.key').val();
         var value  =  $(j).find('input.value').val();
         if (key&&key!='') json[key] = value;
    });
    $('.pgpt').parent('div').find('input.admin_text').val(JSON.stringify(json)).attr('v','e');
    $('.pgpt').hide();
    $scope.$$phase || $scope.$apply();
  };





    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            mainGroup:'00000000-0000-0000-0000-000000000000',
                            subGroup:'00000000-0000-0000-0000-000000000000'
                        };

                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'groupSet',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (false) {  //!checkdupe()
                g.modal1('页面名称或英文名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                      //   g.modal1('已更新');
                         window.location.href = '#/admin/groupset/';
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist1 = [];
        var checklist2 = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='pageName']").val();
                var d = $(tr).find("[name='UIname']").val();
                checklist1.push(c);
                checklist2.push(d);
            }
        });
        var flag1 = [];

        $(checklist1).each(function (i, o) {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                      console.log(o);
                }
        });

        $(checklist2).each(function (i, o) {
            if (!flag1[o]) {
                flag1[o] = true;
            }
            else {
                chk = false;
                console.log(o);
            }
        });
        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});










app.controller('admingroupincategory', function ($rootScope, $scope, $location, $sce, $routeParams, cooConfig, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

      $rootScope.settingMode = true;


    $scope.result = [];
    $scope.cates = [];
    $scope.groups = [];
    $scope.groups.push({groupId:'00000000-0000-0000-0000-000000000000',groupName:'请选择'});
    var categoryId = $routeParams.categoryId;
    $scope.categoryId =categoryId;
    if (categoryId == undefined) categoryId = 0;



    var etor = {
        key: "groupInCategory",
        categoryId: categoryId
    };


    var etorCate = {
        key: "category"
    };

    var etorGroup = {
        key: "group"
    };


    $.when(rest.adminList(etorCate),rest.adminList(etorGroup)).done(function (cates,groups) {

        $scope.cates = cates;
        $scope.groups = groups;


        $scope.category = g.filterListById(cates, categoryId)[0];

        if (categoryId != 0) {
              $.when(rest.adminList(etor)).done(function (result) {

                      $scope.result =  _.filter(result,function(n){ return n.categoryId ==categoryId });
                      $("#rowcount").val(result.length);
                      $scope.$apply();
                      g.jqueryInit('', 0);
                  });
        }
        else {
          $scope.$apply();
          g.jqueryInit('', 0);
        }
    });


  $scope.pgSetting=function()
  {


    var json = {};
    $('.pgpt table tr.addrow').each(function(i,j){
         var key =   $(j).find('input.key').val();
         var value  =  $(j).find('input.value').val();
         if (key&&key!='') json[key] = value;
    });
    $('.pgpt').parent('div').find('input.admin_text').val(JSON.stringify(json)).attr('v','e');
    $('.pgpt').hide();
    $scope.$$phase || $scope.$apply();
  };





    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: null,
                            groupId:'00000000-0000-0000-0000-000000000000'
                        };
                        if (categoryId>0) erow.categoryId=categoryId;

                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'groupInCategory',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (false) {  //!checkdupe()
                g.modal1('页面名称或英文名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                      //   g.modal1('已更新');
                         window.location.href = '#/admin/groupincategory/' + categoryId + '/';
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist1 = [];
        var checklist2 = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='pageName']").val();
                var d = $(tr).find("[name='UIname']").val();
                checklist1.push(c);
                checklist2.push(d);
            }
        });
        var flag1 = [];

        $(checklist1).each(function (i, o) {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                      console.log(o);
                }
        });

        $(checklist2).each(function (i, o) {
            if (!flag1[o]) {
                flag1[o] = true;
            }
            else {
                chk = false;
                console.log(o);
            }
        });
        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});






app.controller('adminpage', function ($rootScope, $scope, $location, $sce, $state,$stateParams, cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };


    $scope.sync_id = function()
    {
       $('.hide .index').prop("disabled",false);
    }



    $rootScope.settingMode = true;
    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
         $('#updateBtn').prop('disabled',true);
    }


    $scope.result = [];
    $scope.cates = [];
    $scope.pages = [];
    $scope.pages.push({ID:0,UIname:'请选择'});

    var categoryId = $stateParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;
    $scope.pageTypes = cooConfig.pageTypes;
    $scope.difs = cooConfig.difs;
    $scope.categoryStep = cooConfig.configObj.categoryStep;

    var etor = {
        key: "page",
        categoryId: categoryId
    };

    var etorMenu ={
        key :"menu",
    }

    var etorCate = {
        key: "category"
    };

    var etorPage = {
        key: "page"
    };


    $.when(rest.adminList(etorCate)).done(function (cates) {

        $scope.cates = cates;
        $scope.category = _.find(cates,function(n){ return n.ID==categoryId});

        if (categoryId != 0) {
            $.when(rest.adminList(etor), rest.adminList(etorPage) ,rest.adminList(etorMenu)).done(function (result, pages,menus) {

                $(pages).each(function (j, p) {
                    if (p.pageType == 2 || p.pageType == 5 ||  p.pageType == 15 || p.pageType == 14 || p.pageType == 10 || p.pageType == 16 || p.pageType == 99 || p.pageType == 100 || p.pageType == 101 || p.pageType == 102 || p.pageType == 103)
                    {




                        $scope.pages.push(p);

                    }
                });



               $(result).each(function (j,p) {
                 var url ="";
                 switch (p.pageType) {
                    case 10:
                       url="/list/"+p.categoryId +"/page/"+p.ID;
                    break;
                    case 15:
                        url="/create/"+p.categoryId +"/page/"+p.ID;
                    break;
                    case 16:
                        url="/report/"+p.categoryId +"/page/"+p.ID;
                    break;
                    case 5:
                        url="/bulkcreate/"+p.categoryId +"/page/"+p.ID;
                    break;
                    case 99:
                        url="/complexcreate/"+p.categoryId +"/page/"+p.ID;
                    break;
                    default:
                    break;
                  }

                  if (_.any(menus,function(n){ return n.url ==url && n.url.length>0}))
                     url="";
                   p.url =url;
                   $scope.result.push(p);

                 // body...
               })



              //  $scope.result = result;
                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);
            });
        }

        $scope.$apply();
    });


  $scope.createMenu =function(row)
  {


    if (row.pageType == 10 ){

     var iRow = '[{"ID":0,"pName":"'+row.UIname+'","eName":"'+row.pageName+'","url":"/app/pagex/list","morder":9,"icon":"fa fa-hacker-news","parentId":"0","isMobile":false, "property":"{ \\"name\\":\\"app.pagex.list({categoryId:' + row.categoryId + ',pageId:' + row.ID + '})\\" }" }]';


      var etor ={
          delIds: [],
          insertList:  iRow,
          key: "menu",
          updateList: "[]"
        };

        $.when(rest.adminAdapter(etor)).done(function (result) {
            console.log(result);
            $state.go('app.admin.page');
            // console.log(result);
        });

    }

  }


  $scope.navTransaction = function(row){

    var etor ={"key":"event","categoryId": row.categoryId};

    $.when(rest.adminList(etor)).done(function(result){



         var eventRow = _.find(result,function(n){ return n.pageId ==row.ID });
         var itemId = eventRow? eventRow.ID:0;

         if (row.pageType !==103){
            $state.go("transactiondetail" ,{ pageId : row.ID ,itemId :itemId });
         }else{
            $state.go("robotdetail" ,{ pageId : row.ID ,itemId :itemId });
         }




    });



  }


  $scope.pgSetting=function()
  {
     g.codeSetting();
  };

  $scope.pgClear=function()
  {
     $('.pgpt').hide();
  };

   $scope.popv =function($event)
   {
      g.popv($event);

   };



    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));




                if (!regx.test($.trim($(this).val()))) {





                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            pageName: '',
                            pageType: 2,
                            pageProperty:'{}',
                            UIname:'',
                            parentId:null,
                            pageOrder: 0,
                            template: '',
                            dif:0
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {

                            var  erow1 = _.find($scope.result,function(n){ return n.ID==parseInt(tid) });

                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 && !erow['new']) {
                                updateList.push(erow);
                            } else {
                                if ($scope.categoryStep && $scope.categoryStep>0){

                                  if (!erow.pageOrder)  erow.pageOrder = 1;

                                   erow.pageOrder =  erow.pageOrder + 10000*$scope.categoryStep;
                                }
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'page',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('页面名称或英文名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        $state.reload();
                        // window.location.href = window.location.href  +  '/';
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist1 = [];
        var checklist2 = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='pageName']").val();
                var d = $(tr).find("[name='UIname']").val();
                checklist1.push(c);
                checklist2.push(d);
            }
        });
        var flag1 = [];

        $(checklist1).each(function (i, o) {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                      console.log(o);
                }
        });

        $(checklist2).each(function (i, o) {
            if (!flag1[o]) {
                flag1[o] = true;
            }
            else {
                chk = false;
                console.log(o);
            }
        });
        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});




app.controller('admin_full_code_modal_instance_ctrl', ['$scope', '$modalInstance','g','rest' ,'$timeout','row','mode',function($scope, $modalInstance,g,rest ,$timeout,row,mode) {



    $scope.editorOptions = {
      lineNumbers: true,
      matchBrackets: true,
      styleActiveLine: true,
      theme:"ambiance",
      mode : mode? "text/x-csharp":'text/javascript'
  };

  $scope._editor ={};


  $scope.codemirrorLoaded = function(_editor){
      $scope._editor = _editor;

  };

  $scope.modal_data="";

  $scope.render = function(){

    $scope.modal_data = row ;
    $scope.$$phase || $scope.$apply();

  }

  $timeout(function () {
    $scope.render();
    $scope.lineTestx();
  },300);


  $scope.lineTestx = function(){
      var k=0;
      var args =[];
      $scope._editor.getDoc().eachLine(function(row){
          if (row.text.indexOf('\/\/\/点击此行')>=0){
              args.push(k);
          }
          k++;
      });
      $(args).each(function(i,j){
        $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'highlight-color' } );
      });
  }



   $scope.modalSave= function(){
      $modalInstance.close($scope.modal_data);
   }

}]);



app.controller('admin_import_page_modal_instance_ctrl', ['$scope', '$modalInstance','g','rest' ,'$timeout','pageId',function($scope, $modalInstance,g,rest ,$timeout,pageId) {

    $scope.pageName ="";

    $scope.create = function(){

       var r =  /^[a-zA-Z0-9_]+$/ig ;
       if (!r.test($scope.pageName)){
          g.modal1("名称格式不对!");
       }
       else {
            $modalInstance.close($scope.pageName);
       }
    }


}]);






app.controller('admin_css_modal_instance_ctrl', ['$scope', '$modalInstance','g','rest' ,'$timeout','pageId',function($scope, $modalInstance,g,rest ,$timeout,pageId) {

  $scope.lsc =[];
  $scope.pageSize = 10;
  $scope.startIndex = 1;
  $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];

  $scope.categoryId =8;
  $scope.pageId =56;
  $scope.descPat = "__c88";
  $scope.appcomponents =[];

  $scope.pageSizeChange = function (p) {
      $scope.pageSize = p;
      $scope.startIndex = 1;
      $scope.modal_render_list();
  };

  $scope.search = function(){
      $scope.lsc =[];
      $scope.startIndex=1;
      if ($scope.__c80){
        $scope.lsc.push({patternId: 80, val1: $scope.__c80, pTypeId: 5, operation: 6})
      }
      if ($scope.__c231){
        $scope.lsc.push({patternId: 231, val1: $scope.__c231, pTypeId: 5, operation: 6})
      }
      if ($scope.__c230){
        $scope.lsc.push({patternId: 230, val1: $scope.__c230, pTypeId: 5, operation: 6})
      }
      if ($scope.__c81){
        $scope.lsc.push({patternId: 81, val1: $scope.__c81, pTypeId: 5, operation: 6})
      }
      if ($scope.__c88){
        $scope.lsc.push({patternId: 88, val1: $scope.__c88, pTypeId: 5, operation: 6})
      }
       $scope.modal_render_list();


  }

  $scope.selectPage  =function(p)
  {
        if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
        {
          $scope.startIndex = $scope.startIndex+p;
           $scope.modal_render_list();
        }
  }

  $scope.modal_render_list = function () {

         g.show_ajax();
         var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
          url : "https://center.mvcx.net/list/ajxlist2"   }   ;

          g.show_ajax();
          $scope.appcsss=[];
          $.when(rest.remote_data(etor,"proxy")).done(function(retx){

              var ex = JSON.parse(retx.data);
              $(ex.data).each(function(i,j){
                  j.__c84 = j.__c84.length>50? j.__c84.substr(0,50):j.__c84;
                  j.__c88 = j.__c88.length>50? j.__c88.substr(0,50):j.__c88;
                  $scope.appcsss.push(j);
              });
              g.hide_ajax();

              $scope.totalItems  = g.list_total(ex);

              $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;

          //    $scope.numPages = $scope.maxPages;

              $scope.$$phase || $scope.$apply();

            });

   };

   $scope.pick = function(row)
   {
      $modalInstance.close(row);
   }

   $scope.modal_render_list();



}]);



app.controller('admin_function_modal_instance_ctrl', ['$scope', '$modalInstance','g','rest' ,'$timeout','pageId','modal_lsc',function($scope, $modalInstance,g,rest ,$timeout,pageId,modal_lsc) {

   $scope.lsc =[];
   $scope.pageSize = 10;
   $scope.startIndex = 1;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];

   $scope.categoryId =7;
   $scope.pageId =49;
   $scope.descPat = "__c76";
   $scope.appfuncxs =[];

   $scope.pageSizeChange = function (p) {
       $scope.pageSize = p;
       $scope.startIndex = 1;
       $scope.modal_render_list();
   };


   $scope.search = function(){
       $scope.lsc =[];
       $scope.startIndex=1;
       if ($scope.__c66){
         $scope.lsc.push({patternId: 66, val1: $scope.__c66, pTypeId: 5, operation: 6})
       }
       if ($scope.__c218){
         $scope.lsc.push({patternId: 218, val1: $scope.__c218, pTypeId: 5, operation: 6})
       }
       if ($scope.__c219){
         $scope.lsc.push({patternId: 219, val1: $scope.__c219, pTypeId: 5, operation: 6})
       }
       if ($scope.__c67){
         $scope.lsc.push({patternId: 67, val1: $scope.__c67, pTypeId: 5, operation: 6})
       }
       if ($scope.__c76){
         $scope.lsc.push({patternId: 76, val1: $scope.__c76, pTypeId: 5, operation: 6})
       }
        $scope.modal_render_list();


   }

   $scope.selectPage  =function(p)
   {
         if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
         {
           $scope.startIndex = $scope.startIndex+p;
            $scope.modal_render_list();
         }
   }

   $scope.modal_render_list = function () {

          g.show_ajax();
          var lsc2 =[];
          $($scope.lsc).each(function(i,j){ lsc2.push(j) });
          $(modal_lsc).each(function(i,j){ lsc2.push(j) });
          var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":lsc2,"iindex":$scope.startIndex,"isize": $scope.pageSize,
           url : "https://center.mvcx.net/list/ajxlist2"   }   ;

           g.show_ajax();
           $scope.appfuncxs=[];
           $.when(rest.remote_data(etor,"proxy")).done(function(retx){

               var ex = JSON.parse(retx.data);
               $(ex.data).each(function(i,j){

                   j.__c76 = j.__c76.length>50? j.__c76.substr(0,50):j.__c76;
                   $scope.appfuncxs.push(j);
               });
               g.hide_ajax();

               $scope.totalItems  = g.list_total(ex);

               $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;

               $scope.$$phase || $scope.$apply();

             });

    };

    $scope.pick = function(row)
    {
       $modalInstance.close(row);
    }

    $scope.modal_render_list();



   console.log('adminfuncx1');

}]);


app.controller('admin_transaction_modal_instance_ctrl', ['$scope', '$modalInstance','g','rest' ,'$timeout','pageId','modal_lsc',function($scope, $modalInstance,g,rest ,$timeout,pageId,modal_lsc) {

   $scope.lsc =[];
   if (!modal_lsc) modal_lsc =[];
   $scope.pageSize = 10;
   $scope.startIndex = 1;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];

   $scope.categoryId =19;
   $scope.pageId =137;
   $scope.descPat = "__c251";
   $scope.apptransactions =[];

   $scope.pageSizeChange = function (p) {
       $scope.pageSize = p;
       $scope.startIndex = 1;
       $scope.modal_render_list();
   };

   $scope.selectPage  =function(p)
   {
         if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
         {
           $scope.startIndex = $scope.startIndex+p;
            $scope.modal_render_list();
         }
   }

   $scope.refresh = function(){

      $scope.__c240 = '';
      $scope.__c241 = '';
      $scope.__c251 = '';
      $scope.__c254 = '';
      $scope.__c255 = '';

      $scope.search();


   }


   $scope.search = function(){

        $scope.lsc =[];
        $scope.startIndex = 1;
        if ($scope.__c240){
           $scope.lsc.push({"patternId":240,"val1":$scope.__c240,"pTypeId":5,"operation":6});
        }
        if ($scope.__c241){
           $scope.lsc.push({"patternId":241,"val1":$scope.__c241,"pTypeId":5,"operation":6});
        }
        if ($scope.__c251){
           $scope.lsc.push({"patternId":251,"val1":$scope.__c251,"pTypeId":5,"operation":6});
        }
        if ($scope.__c254){
           $scope.lsc.push({"patternId":254,"val1":$scope.__c254,"pTypeId":5,"operation":6});
        }
        if ($scope.__c255){
           $scope.lsc.push({"patternId":255,"val1":$scope.__c255,"pTypeId":5,"operation":6});
        }
        $scope.modal_render_list();

   }

   $scope.modal_render_list = function () {


         var lsc2 =[];
         $($scope.lsc).each(function(i,j){ lsc2.push(j) });
         $(modal_lsc).each(function(i,j){ lsc2.push(j) });

          g.show_ajax();
          var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":lsc2,"iindex":$scope.startIndex,"isize": $scope.pageSize,
           url : "https://center.mvcx.net/list/ajxlist2"   }   ;

           g.show_ajax();
           $scope.apptransactions=[];
           $.when(rest.remote_data(etor,"proxy")).done(function(retx){

               var ex = JSON.parse(retx.data);
               $(ex.data).each(function(i,j){
                   if (j.__c251)  j.__c251 = g.removeHtml(j.__c251);
                   $scope.apptransactions.push(j);
               });
               g.hide_ajax();

               $scope.totalItems  = g.list_total(ex);

               $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;

               $scope.$$phase || $scope.$apply();

             });

    };

    $scope.pick = function(row)
    {
       $modalInstance.close(row);
    }

    $scope.modal_render_list();



   console.log('adminmodal1');

}]);




app.controller('admin_variable_modal_ctrl', ['$scope', '$modalInstance','cooConfig','g' ,'gApp','rest' ,'$timeout','subPats','transactionProperties','transIndex' ,'listIndex','code' ,function($scope, $modalInstance,cooConfig,g,gApp,rest ,$timeout,subPats,transactionProperties,transIndex,listIndex,code ) {

   $scope.categoryId = 19;
   $scope.pageId  = 137;
   $scope.startIndex = 1 ;
   $scope.pageSize = 300;
   $scope.lsc =[];
   $scope.code =code;
   $scope.inputBackgroundColor = "gray";
   $scope.variable2 =[];
   $scope.variable3=[];
   $scope.variable4=[];
   var alpha =['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];




   $scope.renderList = function(){

       $scope.initData();
   }

   $scope.initData = function(){


         $scope.variable =  gApp.getVariable($scope);
         if ($scope.transactionProperties[transIndex].class == 'lambda'){
              var ret =  { keyword :'当前表'   , level : 'table' , class:'table' ,source :''    }
              $scope.variable.splice(0,0,ret);
         }
         var formulaTable =[];
         $scope.formulaProperties =[];
         if ($scope.transactionProperties[transIndex].protected){

            return false;

            console.log($scope.transactionProperties[transIndex].protected);
            formulaTable  = JSON.parse($scope.transactionProperties[transIndex].protected);
            console.log(formulaTable);



            for(var i=0;i<formulaTable.length-1;i++)
            {

              var formulaRow = {
                                  keyword:'公式' + alpha[i]  ,
                                  class: 'formulaOperation',
                                  type: 'select',
                                  value:  formulaTable[i][0]  ,
                                  list : [ ]
                              };

                 console.log(formulaTable[i][0]);

              var op = _.find($scope.operationSource,function(n){ return n.value ==  formulaTable[i][0]  });

              console.log(op);
              if (op){
                  var newObject = jQuery.extend(true, [], op.list);
                  formulaRow.list = newObject;
                  formulaRow.stringFormat = op.stringFormat;
                  var k = 0;

                  $(formulaRow.list).each(function(p,q){
                        k++;
                        q.value = formulaTable[i][k].v;
                        q.value1 = formulaTable[i][k].v1;
                        q.value2 = formulaTable[i][k].v2;

                        if (q.value1=='当前表'){

                          var rowV = _.find( $scope.transactionProperties,function(n){ return n.class=='tableParameter' });

                          if (rowV &&rowV.value)
                          {
                                var sData = gApp.getTableStructure($scope.code, rowV.value[0]);

                                console.log(sData);
                                console.log(rowV.value[0]);

                                var sObj = JSON.parse(sData);
                                var sKeys =  _.keys(sObj);
                                var patIds =[];
                                $(sKeys).each(function(i,j){
                                     $(sObj[j]).each(function(p,q){
                                             patIds.push(q);
                                     });
                                });
                                $.when(g.allpattern()).done(function(rx){

                                     var subx = _.filter(cooConfig.allpattern,function(n) {
                                          return       patIds.indexOf(n.ID)>=0;
                                     });

                                      var tableSource = [];
                                      $(subx).each(function(i,j){
                                         tableSource.push({label:j.pName , value: 'c'+j.ID});
                                      });
                                      q.source =  tableSource;
                                      q.stringFormat="[]";

                                      $timeout(function(){
                                          $(".ui-chosen").trigger("chosen:updated");
                                      },300);
                                });
                          }


                        }
                  });

                }

                console.log(formulaRow);

                $scope.formulaProperties.push(formulaRow);
            }
            $scope.compose = formulaTable[formulaTable.length-1];
         }
         else{

             $scope.formulaProperties.push({
                 keyword:'公式A',
                 class: 'formulaOperation',
                 type: 'select',
                 list : [ ]
             });
         }








   }





   $scope.transIndex = transIndex;
   $scope.transactionProperties = transactionProperties;



   $scope.trans2 = function(){



     var newKey =  $scope.formulaProperties[0].keyword.replace(/[A-Z]$/ig,'') + alpha[$scope.formulaProperties.length] ;



      var o =  {
          keyword : newKey,
          class : $scope.formulaProperties[0].class,
          type :  $scope.formulaProperties[0].type,
          list:[]
      };





      $scope.formulaProperties.push(o);
      $scope.$$phase || $scope.$apply();

   }

   $scope.subRowChange = function(c){
      gApp.subRowChange(c) ;
   }

    $scope.level2Change = function(){
       var variable1Row = _.find($scope.variable, function(n){ return n.selectedIndex == $scope.level1Index });
       var variable2Row = _.find($scope.variable2, function(n){ return n.selectedIndex == $scope.level2Index });

       var ret = "";

       if (variable1Row && variable2Row){

         if ( variable2Row.stringFormat){
           ret =  variable2Row.stringFormat.replace(/\{0\}/ig,variable1Row.value);
           ret =  ret.replace(/\{1\}/ig,variable2Row.value);
         }
         else{
           ret = variable1Row.value + '.' + variable2Row.value;
         }


         if (variable2Row.level == $scope.transactionProperties[transIndex].level && variable2Row.typeIndex == $scope.transactionProperties[transIndex].typeIndex  )
         {
             $scope.inputBackgroundColor = "white";
         }



         $scope.level1Value = ret;
         $scope.$$phase || $scope.$apply();




       }
    }

   $scope.level1Change = function(){

       var variableRow = _.find($scope.variable, function(n){ return n.selectedIndex == $scope.level1Index });

       console.log($scope.transactionProperties[transIndex]);
       console.log($scope.variable);

       if (!variableRow) return false;

       if (variableRow.value.indexOf('_35')>=0 || variableRow.value.indexOf('_33')>=0){


           var mkey = variableRow.value.replace(/\.(.+)*?$/ig,'');
           var sData = gApp.getInheritStructure($scope.code, mkey);
           $scope.transactionProperties[transIndex].parentStructure = '{"'+mkey+'":"*"}';






           if (!sData) sData = "{}";
           var rCate = new RegExp('\\d+:','ig');
           sData = sData.replace(rCate,function(match,contents,ss,offset){
                var temp = match.replace(/:/ig,'');
                return '"'+ temp + '":' ;
           });

           console.log(sData);
           var sObj = JSON.parse(sData);
           var sKeys =  _.keys(sObj);
           var patIds =[];
           var categoryIds =[];
           $(sKeys).each(function(i,j){
                 if (sObj[j]=='*'){
                    categoryIds.push(j);
                 }
                 else {
                   $(sObj[j]).each(function(p,q){
                           patIds.push(q);
                   });
                 }

           });

           if (sKeys.length>0 ){
              if (sKeys[0] == 'list'){
                  patIds = _.pluck($scope.subPats,'ID');
              }

              if (sKeys[0] == 'relatedList'){
                  var pageIds = _.pluck($scope.subPages,'ID');
                  var eles = _.filter(cooConfig.allelement,function(n){ return pageIds.indexOf(n.pageId) >=0    });
                  patIds = _.pluck(eles,'patternId');
              }

           }


           $.when(g.allpattern()).done(function(rx){


                var  subx =[];
                if (categoryIds.length==0){
                    subx = _.filter(cooConfig.allpattern,function(n) {
                         return       patIds.indexOf(n.ID)>=0;
                    });
                }
                else{
                  subx = _.filter(cooConfig.allpattern,function(n) {
                       return       categoryIds.indexOf(n.categoryId.toString())>=0;
                  });
                }

                  console.log(categoryIds);
                  console.log(subx);
                  console.log(cooConfig.allpattern.length);


                 var tableSource = [];
                 $(subx).each(function(i,j){
                    tableSource.push( { keyword : j.pName , level : 'cell' , typeIndex: j.pTypeId , stringFormat: gApp.indexStringFormat( j.pTypeId) ,  selectedIndex :  j.ID  ,  value :'c' +j.ID        });
                 });

                 $scope.level1Value = variableRow.value;
                 $scope.variable2 = tableSource;

                 $scope.$$phase || $scope.$apply();


                 $timeout(function(){
                     $(".ui-chosen").trigger("chosen:updated");
                 },300);
           });


       }
       else{


           console.log(variableRow);
           $scope.level1Value = variableRow.value;

           $scope.variable2 = gApp.getVariableAttr(variableRow.level, variableRow.typeIndex) ;

           $scope.$$phase || $scope.$apply();

           $timeout(function(){
               $(".ui-chosen").trigger("chosen:updated");
           },300);

           // c.source1 = c.source;
           // c.source = $scope.groupSource[sRow.source];
           // c.value =  (sRow && sRow.stringFormat) ? sRow.stringFormat.replace(/\{0\}/ig,sRow.value): sRow.value;
           // c.stringFormat = sRow.stringFormat;
           //
           // $timeout(function(){
           //     $(".ui-chosen").trigger("chosen:updated");
           // },300);

       }








   }


   $scope.operationChange = function(c){

      var op = _.find($scope.operationSource,function(n){ return n.value == c.value });

      if (op){

          var newObject = jQuery.extend(true, [], op.list);
          c.list = newObject;

          c.stringFormat = op.stringFormat;





          $scope.$$phase || $scope.$apply();


          $timeout(function(){

              $(".ui-chosen").trigger("chosen:updated");

          },300);

      }
   }





   if ($scope.transactionProperties[transIndex].list){
      $($scope.transactionProperties[transIndex].list).each(function(i,j){

           if (j.source =='pats'||j.source1 =='pats'){
              console.log(subPats);
              j.source = subPats;
           }
      });
   }


   $scope.renderList();




   $scope.save = function(){

     var ret = {};

     var formulaTable =[];

     console.log($scope.formulaProperties);



   $($scope.formulaProperties).each(function(i,j){
              var row = j.stringFormat;
              var formulaRow =[];
              formulaRow.push(j.value);
              $(j.list).each(function(p,q){
                   var se = '<<'+q.keyword+'>>';
                   var re= new RegExp(se,'ig');
                   row =row.replace(re,q.value);
                    formulaRow.push({ v:q.value,v1:q.value1,v2:q.value2});
              });
              formulaTable.push(formulaRow);
              ret[j.keyword.replace(/[^A-Za-z]/ig,'')]= row;
   });


   var r2 = '';
   if ($scope.compose) r2 = $scope.compose;
   formulaTable.push(r2);

   $(_.keys(ret)).each(function(p,q){
         var re = new RegExp(q,'ig');
          r2 =r2.replace(re,'(' +ret[q] + ')');

   });

   console.log(r2);

   if (listIndex<0){
     $scope.transactionProperties[transIndex].value = $scope.level1Value;
     $scope.transactionProperties[transIndex].protected = formulaTable;


     var variable1Row = _.find($scope.variable, function(n){ return n.selectedIndex == $scope.level1Index });
     $scope.transactionProperties[transIndex].typeIndex = variable1Row.typeIndex;

     console.log($scope.transactionProperties[transIndex]);

   }
   else{
     $scope.transactionProperties[transIndex].list[listIndex].value = $scope.level1Value;
     $scope.transactionProperties[transIndex].list[listIndex].protected = formulaTable;
     var variable1Row = _.find($scope.variable, function(n){ return n.selectedIndex == $scope.level1Index });
     $scope.transactionProperties[transIndex].list[listIndex].typeIndex = variable1Row.typeIndex;

   }




   $modalInstance.close( $scope.transactionProperties[transIndex]);





   }

}]);


app.controller('admin_formula_modal_ctrl', ['$scope', '$modalInstance','cooConfig','g' ,'gApp','rest' ,'$timeout','subPats','transactionProperties','transIndex' ,'code' ,function($scope, $modalInstance,cooConfig,g,gApp,rest ,$timeout,subPats,transactionProperties,transIndex,code ) {

   $scope.categoryId = 19;
   $scope.pageId  = 137;
   $scope.startIndex = 1 ;
   $scope.pageSize = 300;
   $scope.lsc =[];
   $scope.code =code;
   var alpha =['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];




   $scope.renderList = function(){

      $scope.operationSource = [];
       $scope.lsc =[];
       $scope.lsc.push({"patternId":254,"val1":"mvcx.transaction.formula","pTypeId":5,"operation":1});

       var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc": $scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
        url : "https://center.mvcx.net/list/ajxlist2"   }   ;

        g.show_ajax();



        var etor2 = {
        "companyId": 1000,
        "cid": 3,
        "id": 21,
        "lsc": [{
         patternId: 22,
         val1: 'variable.',
         pTypeId: 5,
         operation: 6
        }],
        "iindex": 1,
        "isize": 300,
        url: "https://center.mvcx.net/list/ajxlist2"
        };






        $.when(rest.remote_data(etor,"proxy"),rest.remote_data(etor2,"proxy")).done(function(retx ,rety){

            var ex = JSON.parse(retx.data);
            $(ex.data).each(function(i,j){
                    $scope.operationSource.push({
                       class: j.__c241,
                       keyword: j.__c240,
                       value : j.__c239,
                       stringFormat: j.__c244,
                       list : JSON.parse(j.__c248)
                    });
            });

            var ey= JSON.parse(rety.data);
            var transactionList = ey.data ;

            var transGroup = _.groupBy(transactionList,function(n){ return n.__c256 });

            var groupSource ={};

            $(_.keys(transGroup)).each(function(i,j){
                groupSource[j]= [];

                $(transGroup[j]).each(function(p,q){
                    groupSource[j].push({ label: q.__c21, value: q.__c226});
                });

            });

            $scope.groupSource = groupSource;
            $scope.initData();




            g.hide_ajax();

            $timeout(function(){
                $(".ui-chosen").trigger("chosen:updated");
            },300);


            $scope.$$phase || $scope.$apply();

          });
   }

   $scope.initData = function(){



         $scope.variable =  gApp.getVariableUnderRow($scope);
         if ($scope.transactionProperties[transIndex].class == 'lambda'){
              var ret =  { keyword :'当前表'   , level : 'table' , class:'table' ,source :''    }
              $scope.variable.splice(0,0,ret);
         }
         var formulaTable =[];
         $scope.formulaProperties =[];
         if ($scope.transactionProperties[transIndex].protected){
            console.log($scope.transactionProperties[transIndex].protected);
            formulaTable  = JSON.parse($scope.transactionProperties[transIndex].protected);

            console.log(formulaTable);

            for(var i=0;i<formulaTable.length-1;i++)
            {

              var formulaRow = {
                                  keyword:'公式' + alpha[i]  ,
                                  class: 'formulaOperation',
                                  type: 'select',
                                  value:  formulaTable[i][0]  ,
                                  list : [ ]
                              };

                 console.log(formulaTable[i][0]);

              var op = _.find($scope.operationSource,function(n){ return n.value ==  formulaTable[i][0]  });

              console.log(op);
              if (op){
                  var newObject = jQuery.extend(true, [], op.list);
                  formulaRow.list = newObject;
                  formulaRow.stringFormat = op.stringFormat;
                  var k = 0;

                  $(formulaRow.list).each(function(p,q){
                        k++;
                        q.value = formulaTable[i][k].v;
                        q.value1 = formulaTable[i][k].v1;
                        q.value2 = formulaTable[i][k].v2;

                        if (q.value1=='当前表'){

                          var rowV = _.find( $scope.transactionProperties,function(n){ return n.class=='tableParameter' });

                          if (rowV &&rowV.value)
                          {
                                var sData = gApp.getTableStructure($scope.code, rowV.value[0]);

                                console.log(sData);
                                console.log(rowV.value[0]);

                                var sObj = JSON.parse(sData);
                                var sKeys =  _.keys(sObj);
                                var patIds =[];
                                $(sKeys).each(function(i,j){
                                     $(sObj[j]).each(function(p,q){
                                             patIds.push(q);
                                     });
                                });
                                $.when(g.allpattern()).done(function(rx){

                                     var subx = _.filter(cooConfig.allpattern,function(n) {
                                          return       patIds.indexOf(n.ID)>=0;
                                     });

                                      var tableSource = [];
                                      $(subx).each(function(i,j){
                                         tableSource.push({label:j.pName , value: 'c'+j.ID});
                                      });
                                      q.source =  tableSource;
                                      q.stringFormat="[]";

                                      $timeout(function(){
                                          $(".ui-chosen").trigger("chosen:updated");
                                      },300);
                                });
                          }


                        }
                  });

                }

                console.log(formulaRow);

                $scope.formulaProperties.push(formulaRow);
            }
            $scope.compose = formulaTable[formulaTable.length-1];
         }
         else{

             $scope.formulaProperties.push({
                 keyword:'公式A',
                 class: 'formulaOperation',
                 type: 'select',
                 list : [ ]
             });
         }








   }



  console.log(transIndex);
  console.log(transactionProperties);

   $scope.transIndex = transIndex;
   $scope.transactionProperties = transactionProperties;



   $scope.trans2 = function(){



     var newKey =  $scope.formulaProperties[0].keyword.replace(/[A-Z]$/ig,'') + alpha[$scope.formulaProperties.length] ;



      var o =  {
          keyword : newKey,
          class : $scope.formulaProperties[0].class,
          type :  $scope.formulaProperties[0].type,
          list:[]
      };





      $scope.formulaProperties.push(o);
      $scope.$$phase || $scope.$apply();

   }

   $scope.subRowChange = function(c){


      gApp.subRowChange(c) ;





   }

   $scope.underRowChange = function(c){

       gApp.underRowChange($scope,c);

       return false;



       var sRow = _.find($scope.variable, function(n){ return n.keyword == c.value1 });

    console.log(    $scope.transactionProperties[transIndex]);

       if (!sRow) return false;

       if (c.value1=='当前表'){

         var rowV = _.find( $scope.transactionProperties,function(n){ return n.class=='tableParameter' });

         if (rowV &&rowV.value)
         {
               var sData = gApp.getTableStructure($scope.code, rowV.value[0]);

               console.log(sData);
               var sObj = JSON.parse(sData);
               var sKeys =  _.keys(sObj);
               var patIds =[];
               $(sKeys).each(function(i,j){
                    $(sObj[j]).each(function(p,q){
                            patIds.push(q);
                    });
               });
               $.when(g.allpattern()).done(function(rx){

                    var subx = _.filter(cooConfig.allpattern,function(n) {
                         return       patIds.indexOf(n.ID)>=0;
                    });

                     var tableSource = [];
                     $(subx).each(function(i,j){
                        tableSource.push({label:j.pName , value: 'c'+j.ID});
                     });
                     c.source =  tableSource;
                     c.stringFormat="[]";

                     $timeout(function(){
                         $(".ui-chosen").trigger("chosen:updated");
                     },300);
               });
         }

       }else{

           c.source1 = c.source;
           c.source = $scope.groupSource[sRow.source];
           c.value =  (sRow && sRow.stringFormat) ? sRow.stringFormat.replace(/\{0\}/ig,sRow.value): sRow.value;
           c.stringFormat = sRow.stringFormat;

           $timeout(function(){
               $(".ui-chosen").trigger("chosen:updated");
           },300);

       }





       console.log( c.source);



   }


   $scope.operationChange = function(c){

      var op = _.find($scope.operationSource,function(n){ return n.value == c.value });

      if (op){

          var newObject = jQuery.extend(true, [], op.list);
          c.list = newObject;

          c.stringFormat = op.stringFormat;





          $scope.$$phase || $scope.$apply();


          $timeout(function(){

              $(".ui-chosen").trigger("chosen:updated");

          },300);

      }
   }





   if ($scope.transactionProperties[transIndex].list){
      $($scope.transactionProperties[transIndex].list).each(function(i,j){

           if (j.source =='pats'||j.source1 =='pats'){
              console.log(subPats);
              j.source = subPats;
           }
      });
   }


   $scope.renderList();




   $scope.save = function(){

     var ret = {};

     var formulaTable =[];

     console.log($scope.formulaProperties);



   $($scope.formulaProperties).each(function(i,j){
              var row = j.stringFormat;
              var formulaRow =[];
              formulaRow.push(j.value);
              $(j.list).each(function(p,q){
                   var se = '<<'+q.keyword+'>>';
                   var re= new RegExp(se,'ig');
                   row =row.replace(re,q.value);
                    formulaRow.push({ v:q.value,v1:q.value1,v2:q.value2});
              });
              formulaTable.push(formulaRow);
              ret[j.keyword.replace(/[^A-Za-z]/ig,'')]= row;
   });


   var r2 = '';
   if ($scope.compose) r2 = $scope.compose;
   formulaTable.push(r2);

   $(_.keys(ret)).each(function(p,q){
         var re = new RegExp(q,'ig');
          r2 =r2.replace(re,'(' +ret[q] + ')');

   });

   console.log(r2);

   $scope.transactionProperties[transIndex].value =r2;
   $scope.transactionProperties[transIndex].protected = formulaTable;


   $modalInstance.close( $scope.transactionProperties[transIndex]);





   }

}]);





app.controller('admin_role_modal_ctrl', ['$scope', '$modalInstance','cooConfig','g','rest' ,'$timeout','roleIds',function($scope, $modalInstance,cooConfig,g,rest ,$timeout, roleIds) {




   $scope.title = '过程';

   var roles =[];
   $(cooConfig.allrole).each(function(i,j){
       roles.push({label:j.RoleName.replace(/^\d+:/ig,''),value: j.RoleId });
   });

   console.log(roleIds);



   $scope.renderList = function(){

             $timeout(function(){
            $('.role_modal .multi-roles').multiselect({
                enableClickableOptGroups: true,
                enableCaseInsensitiveFiltering: true,
                includeSelectAllOption: true,
                maxHeight: 400,
                buttonWidth: '100%',
                dropUp: true
              });
            $('.role_modal .multi-roles').multiselect('dataprovider',roles);
            var filterRoles =  roleIds.split(',');
            $('.role_modal .multi-roles').multiselect('select', filterRoles );

      },300);


   }


   $scope.renderList();








   $scope.save = function(){

       var v = $('.role_modal .multi-roles').val();

       console.log(v);

       $modalInstance.close(v);

   }

}]);

app.controller('admin_ext_modal_ctrl', ['$scope', '$modalInstance','cooConfig','g','gApp','rest' ,'$timeout','subPats','transactionProperties','transIndex','code','pageElements','subPageElements' ,function($scope, $modalInstance,cooConfig,g,gApp,rest ,$timeout,subPats,transactionProperties,transIndex,code,pageElements,subPageElements ) {


  console.log(transIndex);
  console.log(transactionProperties);

   $scope.transIndex = transIndex;
   $scope.transactionProperties = transactionProperties;
   $scope.code = code;



   $scope.renderList = function(){


        var dtd = $.Deferred();



        g.show_ajax();


        var etor = {
        "companyId": 1000,
        "cid": 3,
        "id": 21,
        "lsc": [{
         patternId: 22,
         val1: 'variable.',
         pTypeId: 5,
         operation: 6
        }],
        "iindex": 1,
        "isize": 300,
        url: "https://center.mvcx.net/list/ajxlist2"
        };




        $.when(rest.remote_data(etor,"proxy")).done(function(rety){


            var ey= JSON.parse(rety.data);
            var transactionList = ey.data ;

            var transGroup = _.groupBy(transactionList,function(n){ return n.__c256 });

            var groupSource ={};

            $(_.keys(transGroup)).each(function(i,j){
                groupSource[j]= [];

                $(transGroup[j]).each(function(p,q){
                    groupSource[j].push({ label: q.__c21, value: q.__c226 ,stringFormat: q.__c474});
                });

            });

            $scope.groupSource = groupSource;
            $scope.initData();


             dtd.resolve();




            g.hide_ajax();







            $scope.$$phase || $scope.$apply();

          });

          return dtd.promise();
   }


   $scope.initData = function(){

         $scope.underRowVariable = _.filter(gApp.getVariable($scope),function(n) { return n.level=='row' || n.level == 'cell' });

         var roles =[];
         $(cooConfig.allrole).each(function(i,j){
             roles.push({label:j.RoleName.replace(/^\d+:/ig,''),value: j.RoleId });
         });


         console.log($scope.transactionProperties);




        if ($scope.transactionProperties[transIndex].list){
             $($scope.transactionProperties[transIndex].list).each(function(i,j){

                  if (j.source =='pats'||j.source1 =='pats'){
                     console.log(subPats);
                     j.source = subPats;
                  }
                  if (j.source =='tableParameter' || j.source1 =='tableParameter'){
                     console.log('jjx');

                     j.source =  gApp.getVariableTable($scope);
                  }
                  if (j.source =='roles' || j.source1 =='roles'){

                     $scope.filterRoles = j.value;
                     console.log(j.value);

                  }



                  if (j.source =='cellParameter' || j.source1 =='cellParameter'){



                  }


                  if (j.source=='pageElements'||j.source1=='pageElements'){
                     j.source = pageElements;
                  }

                  if (j.source=='subPageElements'||j.source1=='subPageElements'){
                     j.source = subPageElements;
                  }
             });
        }

   }


   $scope.baseRowChange = function(c){

        if (c.class=='operation'){
              var op =  _.find($scope.transactionProperties[transIndex].list,function(n){ return n.class=='operation' });


              if (c.source && c.source[0])
              {
                 var selectedOperation =  _.find( c.source[0].children, function(n){ return n.value == c.value });
                 console.log(selectedOperation);
                 if (selectedOperation)     op.stringFormat = selectedOperation.stringFormat;

              }

              console.log($scope.transactionProperties[transIndex]);
        }

        if (c.class == 'pats' || c.class == 'pageElements'){

            var cell =  _.find($scope.transactionProperties[transIndex].list,function(n){ return n.class=='cell' });

             var sp = _.find(cooConfig.allstatusmap,function(n){ return n.patternId == c.value });

             if (cell) {
               cell.source = [];
               cell.value ='';
               cell.hide1 =false;
             }




             if (cell && sp){
                   var etor = {
                       key: "status",
                       categoryId:  sp.groupId
                   };

                   $.when(rest.adminList(etor)).done(function(ret){

                         var source =[];
                         $(ret).each(function(i,j){
                             source.push({label:j.statusName,value:j.ID});
                         });
                         cell.source = source;
                         cell.stringFormat = '{1}';
                         cell.hide1 =true;

                         console.log(cell);
                         console.log(source);


                         $timeout(function(){
                             $(".ui-chosen").trigger("chosen:updated");
                         },300);

                         $scope.$$phase || $scope.$apply();



                   });





             }

        }

   }


   $scope.variableRow = function(listIndex){

       gApp.variableExt($scope,transIndex ,listIndex);
   }


   $scope.subRowChange = function(c){

     gApp.subRowChange(c) ;


   }

   $scope.underRowChange = function(c){

       gApp.underRowChange($scope,c);



   }


     $.when($scope.renderList()).done(function(){

                 $timeout(function(){

                     $(".ext_modal .ui-chosen").trigger("chosen:updated");

                     var source =[];
                      $(cooConfig.allcategory).each(function(i,j){
                         source.push({label:j.categoryName,value: j.ID });
                      });
                     var roles =[];
                     $(cooConfig.allrole).each(function(i,j){
                         roles.push({label:j.RoleName.replace(/^\d+:/ig,''),value: j.RoleId });
                     });

                     console.log(roles);

                      $($scope.transactionProperties).each(function(i,j){
                          if (j.source=='categories' || j.source1=='categories'){
                               j.source = source;
                               j.source1 = 'categories';
                          }
                      });

                      $('.ext_modal .multi-pats').multiselect({
                          enableClickableOptGroups: true,
                          enableCaseInsensitiveFiltering: true,
                          includeSelectAllOption: true,
                          maxHeight: 400,
                          buttonWidth: '100%',
                          dropUp: true
                        });
                      $('.ext_modal .multi-roles').multiselect({
                          enableClickableOptGroups: true,
                          enableCaseInsensitiveFiltering: true,
                          includeSelectAllOption: true,
                          maxHeight: 400,
                          buttonWidth: '100%',
                          dropUp: true
                        });

                      $('.ext_modal .multi-roles').multiselect('dataprovider',roles);
                      $('.ext_modal .multi-roles').multiselect('select', $scope.filterRoles );


                      $('.ext_modal .multi-categories').multiselect({
                          enableClickableOptGroups: true,
                          enableCaseInsensitiveFiltering: true,
                          includeSelectAllOption: true,
                          maxHeight: 400,
                          buttonWidth: '100%',
                          dropUp: true,
                          onChange: function(option, checked) {
                                var t =    $('.ext_modal .multi-categories').val();

                                if (!t) {
                                  $('.ext_modal .multi-pats').multiselect('dataprovider',[]);
                                  return false;
                                }

                               $.when(g.allpattern()).done(function(rx){
                                    var subRx = _.filter(rx,function(n){ return  t.indexOf(n.c.toString())>=0  });


                                    $scope.subPats = subRx;
                                    $('.ext_modal .multi-pats').multiselect('dataprovider',subRx);


                                  });
                          }
                        });


                      $('.ext_modal .multi-categories').multiselect('dataprovider',source);
                      $('.ext_modal .multi-categories').multiselect('select', $scope.filterCategories );
                      console.log($scope.filterCategories);


                      if ($scope.filterPats && $scope.filterCategories){
                        $.when(g.allpattern()).done(function(rx){
                             var subRx = _.filter(rx,function(n){ return  $scope.filterCategories.indexOf(n.c.toString())>=0  });

                             $scope.subPats = subRx;
                             $('.ext_modal .multi-pats').multiselect('dataprovider',subRx);
                             $('.ext_modal .multi-pats').multiselect('select', $scope.filterPats );

                           });
                      }

                     $scope.$$phase || $scope.$apply();
                     $(".ext_modal .ui-chosen").trigger("chosen:updated");



                 },300);

     });






   $scope.save = function(){

       var values =[];

       $($scope.transactionProperties[transIndex].list).each(function(i,j){
             values.push(j.value);
       });

       $scope.transactionProperties[transIndex].value = values;

       $modalInstance.close( $scope.transactionProperties[transIndex]);





   }

}]);







//

app.controller('admin_page_start_instance_ctrl', ['$scope', '$modalInstance','cooConfig','g','rest' ,'$timeout','currentPages','pageId' ,function($scope, $modalInstance,cooConfig,g,rest ,$timeout,currentPages,pageId ) {

   console.log(currentPages);
    $scope.hint="需要配置页面类型";
   $(currentPages).each(function(i,j){
      $scope.hint += "("+j.pageType+");";
   });

   console.log('adminmodal2');

   $timeout(function(){
            var source =[];
           if (cooConfig.allcategory.length>0){
               $(cooConfig.allcategory).each(function(i,j){
                  source.push({label:j.categoryName,value: j.ID });
               });
               var pgs1 = g.allpage();
               var categories =[];
               var pages =[];



              $(currentPages).each(function(i,j){
                 if (j.ID>0){
                      var pgx = _.find(cooConfig.allpage,function(n){ return n.ID==j.ID});
                      console.log(pgx);
                      categories.push(pgx.categoryId);
                      pages.push(j.ID);
                 }
              });



               $('.multi-category').multiselect('dataprovider',source);
               $('.multi-category').multiselect('select', categories );


               console.log(categories);



               var subPages = _.filter(pgs1,function(n){ return categories.indexOf(n.c)>=0 });

               console.log(subPages);

               $('.multi-page').multiselect('dataprovider',subPages);
               $('.multi-page').multiselect('select', pages );

           }

           $scope.$$phase || $scope.$apply();
   },300)



   $scope.save = function(){

      var v =$('.multi-page').val();
      console.log(v);


      var pgs = _.filter(cooConfig.allpage,function(n) { return v.indexOf(n.ID.toString())>=0 });


      $modalInstance.close( pgs);



   }

}]);


//admin_system_group_modal_instance_ctrl

app.controller('admin_system_group_modal_instance_ctrl', ['$scope', '$modalInstance','$sce','g','rest' ,'$timeout' ,'modal_lsc',function($scope, $modalInstance , $sce ,g,rest ,$timeout ,modal_lsc) {

   $scope.lsc =[];
   if (!modal_lsc) modal_lsc =[];
   $scope.pageSize = 10;
   $scope.startIndex = 1;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];

   $scope.categoryId =3;
   $scope.pageId =21;
   $scope.descPat = "__c23";
   $scope.appConfigs =[];


   $scope.modal_search_pats = []   ;

   $scope.pageSizeChange = function (p) {
       $scope.pageSize = p;
       $scope.startIndex = 1;
       $scope.modal_render_list();
   };

   $scope.selectPage  =function(p)
   {
         if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
         {
           $scope.startIndex = $scope.startIndex+p;
            $scope.modal_render_list();
         }
   }

   $scope.search = function(){
      $scope.lsc =[];
      console.log($scope.modal_search_pats);
      $($scope.modal_search_pats).each(function(i,j){
         if (j.v){
           $scope.lsc.push( {patternId: j.ID, val1: j.v, pTypeId: 5, operation: 6});
         }
      });
      $scope.startIndex =1;
      $scope.modal_render_list();
   }

   $scope.modal_render_list = function () {

          g.show_ajax();
          var lsc2 =[];
          $($scope.lsc).each(function(i,j){ lsc2.push(j) });
          $(modal_lsc).each(function(i,j){ lsc2.push(j) });
          var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc": lsc2,"iindex":$scope.startIndex,"isize": $scope.pageSize,
           url : "https://center.mvcx.net/list/ajxlist2"   }   ;

           g.show_ajax();
           $scope.appConfigs=[];
           $.when(rest.remote_data(etor,"proxy")).done(function(retx){


               var ex = JSON.parse(retx.data);
               $(ex.data).each(function(i,j){
                //   j.desc =  $sce.trustAsHtml(j.__c23);
                   $scope.appConfigs.push(j);
               });
               g.hide_ajax();

               $scope.totalItems  = g.list_total(ex);

               $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;

               $scope.$$phase || $scope.$apply();

             });

    };

    $scope.pick = function(row)
    {
       $modalInstance.close(row);
    }

    $scope.modal_render_list();



   console.log('adminmodal1');

}]);

//admin_config_modal_instance_ctrl

app.controller('admin_config_modal_instance_ctrl', ['$scope', '$modalInstance','$sce','g','rest' ,'$timeout','pageId','modal_lsc',function($scope, $modalInstance , $sce ,g,rest ,$timeout,pageId,modal_lsc) {

   $scope.lsc =[];
   if (!modal_lsc) modal_lsc =[];
   $scope.pageSize = 10;
   $scope.startIndex = 1;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];

   $scope.categoryId =39;
   $scope.pageId =277;
   $scope.descPat = "__c470";
   $scope.appConfigs =[];


   $scope.modal_search_pats = [{"ID":380,"companyId":1000,"categoryId":39,"pName":"配置名称","pTypeId":5,"pOrder":1,"eName":"peizhimingcheng","validator":"","required":true,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2019-02-14T10:26:40.52","property":{},"element_property":{"modal":1},"property_278":{"modal":1},"property_281":{"modal":1},"s_checked":true,"source":[],"new_order":1,"checked":true},{"ID":381,"companyId":1000,"categoryId":39,"pName":"配置编号","pTypeId":5,"pOrder":1,"eName":"peizhibianhao","validator":"","required":true,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2019-02-14T10:26:40.527","property":{},"element_property":{"modal":1},"property_278":{},"property_281":{"modal":1},"s_checked":true,"source":[],"new_order":2,"checked":true},{"ID":469,"companyId":1000,"categoryId":39,"pName":"配置场景","pTypeId":2,"pOrder":1,"eName":"peizhichangjing","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2019-02-14T10:26:40.427","property":{},"element_property":{"modal":1},"property_278":{"modal":1},"property_281":{"modal":1},"s_checked":true,"source":[{"label":"请选择","value":0},{"label":"APP资源文件","value":134},{"label":"服务端后台","value":129},{"label":"服务端web","value":130},{"label":"APP基础配置","value":131},{"label":"APP扩展配置","value":132}],"v":"0","new_order":5,"checked":true}]   ;

   $scope.pageSizeChange = function (p) {
       $scope.pageSize = p;
       $scope.startIndex = 1;
       $scope.modal_render_list();
   };

   $scope.selectPage  =function(p)
   {
         if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
         {
           $scope.startIndex = $scope.startIndex+p;
            $scope.modal_render_list();
         }
   }

   $scope.search = function(){
      $scope.lsc =[];
      console.log($scope.modal_search_pats);
      $($scope.modal_search_pats).each(function(i,j){
         if (j.v){
           $scope.lsc.push( {patternId: j.ID, val1: j.v, pTypeId: 5, operation: 6});
         }
      });
      $scope.startIndex =1;
      $scope.modal_render_list();
   }

   $scope.modal_render_list = function () {

          g.show_ajax();
          var lsc2 =[];
          $($scope.lsc).each(function(i,j){ lsc2.push(j) });
          $(modal_lsc).each(function(i,j){ lsc2.push(j) });
          var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc": lsc2,"iindex":$scope.startIndex,"isize": $scope.pageSize,
           url : "https://center.mvcx.net/list/ajxlist2"   }   ;

           g.show_ajax();
           $scope.appConfigs=[];
           $.when(rest.remote_data(etor,"proxy")).done(function(retx){

               var ex = JSON.parse(retx.data);
               $(ex.data).each(function(i,j){
                   j.desc =  $sce.trustAsHtml(j.__c470);
                   $scope.appConfigs.push(j);
               });
               g.hide_ajax();

               $scope.totalItems  = g.list_total(ex);

               $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;

               $scope.$$phase || $scope.$apply();

             });

    };

    $scope.pick = function(row)
    {
       $modalInstance.close(row);
    }

    $scope.modal_render_list();



   console.log('adminmodal1');

}]);


app.controller('admin_component_modal_instance_ctrl', ['$scope', '$modalInstance','g','rest' ,'$timeout','pageId','modal_lsc',function($scope, $modalInstance,g,rest ,$timeout,pageId,modal_lsc) {

   $scope.lsc =[];
   if (!modal_lsc) modal_lsc =[];
   $scope.pageSize = 10;
   $scope.startIndex = 1;
   $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];

   $scope.categoryId =6;
   $scope.pageId =42;
   $scope.descPat = "__c62";
   $scope.appcomponents =[];

   $scope.pageSizeChange = function (p) {
       $scope.pageSize = p;
       $scope.startIndex = 1;
       $scope.modal_render_list();
   };

   $scope.selectPage  =function(p)
   {
         if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
         {
           $scope.startIndex = $scope.startIndex+p;
            $scope.modal_render_list();
         }
   }

   $scope.modal_render_list = function () {

          g.show_ajax();
          var lsc2 =[];
          $($scope.lsc).each(function(i,j){ lsc2.push(j) });
          $(modal_lsc).each(function(i,j){ lsc2.push(j) });
          var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc": lsc2,"iindex":$scope.startIndex,"isize": $scope.pageSize,
           url : "https://center.mvcx.net/list/ajxlist2"   }   ;

           g.show_ajax();
           $scope.appcomponents=[];
           $.when(rest.remote_data(etor,"proxy")).done(function(retx){

               var ex = JSON.parse(retx.data);
               $(ex.data).each(function(i,j){
                   $scope.appcomponents.push(j);
               });
               g.hide_ajax();

               $scope.totalItems  = g.list_total(ex);

               $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;

               $scope.$$phase || $scope.$apply();

             });

    };

    $scope.pick = function(row)
    {
       $modalInstance.close(row);
    }

    $scope.modal_render_list();



   console.log('adminmodal1');

}]);





app.controller('adminapprobotdetail', function ($rootScope,$timeout,$interval,$state, $scope, $location,$stateParams, $sce,$filter, $modal, cooConfig, g, rest ,gApp  ) {


      if (cooConfig.configObj.adminDisabled) {
           $('button').prop('disabled',true);
      }




      $scope.editorOptions = {
        lineNumbers: true,
        matchBrackets: true,
        styleActiveLine: true,
        theme:"ambiance",
        mode:    "text/x-csharp",
        extraKeys: {"Ctrl-Q": function(cm){ cm.foldCode(cm.getCursor()); }},
        foldGutter: true,
        gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"]

    };

    $scope.codemirrorLoaded = function(_editor){
        $scope._editor = _editor;

        _editor.on('cursorActivity', function() {
             var doc =_editor.getDoc();
             var A1 = _editor.getCursor();


             var lineContent1 = doc.getLine(A1.line);
             if (lineContent1.indexOf("\/\/\/点击此行替换")>=0){
                    $scope.addTransaction = false;
             }

             gApp.setTransactionModal($scope);

             if (lineContent1.indexOf("\/\/\/<cname")>=0)
             {
                var transactionRange =   gApp.foldCode($scope);

                console.log(transactionRange);

                $scope._editor.foldCodeTransaction(CodeMirror.Pos(transactionRange.startLine +2, 0),CodeMirror.Pos( transactionRange.endLine -1 ,100) , null, 'fold');

             }




             if (lineContent1.indexOf("\/\/\/点击此行编辑")>=0)
             {
                $scope.currentCursor =A1;
                var lineContent =   gApp.getDocLine(doc,A1) ;

            //    doc.getLine(A1.line-1);


                  $scope.addTransaction = false;

                  var id = g.lineProperty(lineContent,"id");

                  $scope.currentId = id;
                  $scope.currentIndex = g.lineProperty(lineContent,"index");


                  var name =  g.lineProperty(lineContent,"name");
                  var namespace =  g.lineProperty(lineContent,"namespace");


                  var lsc =[ {patternId: 241, val1: name, pTypeId: 5, operation: 1},
                  {patternId: 254, val1: namespace, pTypeId: 5, operation: 1}];


                  var  etor ={"companyId":1000,"cid":19,"id":137,"lsc":lsc,"iindex":1,"isize": 1,
                   url : "https://center.mvcx.net/list/ajxlist2"   }   ;

                   g.show_ajax();
                   $.when(rest.remote_data(etor,"proxy")).done(function(retx){


                        var rex = new RegExp("\\/\\/\\/<transaction\\s*\?id\\s*\?=\\s*\?\""+id+"[\\S\\s]*\?\\/\\/\\/<\\/transaction>");

                        if ($scope.currentIndex){
                          console.log($scope.currentIndex);
                          rex = new RegExp("\\/\\/\\/<transaction\\s*\?id\\s*\?=\\s*\?\""+id+"\"\\s*\?index=\""+$scope.currentIndex+"\"[\\S\\s]*\?\\/\\/\\/<\\/transaction>");
                        }

                        var f =rex.exec($scope.code);
                        var rargs=[];
                        if (f[0]){
                          var rb = g.angleBrackets(f[0],"content");
                            if (rb)    rargs = JSON.parse(rb);

                        }

                        var dx = JSON.parse(retx.data);
                        if (dx.data.length>0){
                           $scope.selectTransaction(dx.data[0], rargs);
                        }
                   });





             }
             else  if (lineContent1.indexOf("\/\/\/点击此行重复")>=0){

               console.log(A1);


               $scope.currentCursor =A1;
               var lineContent =  gApp.getDocLine(doc,A1);




               var id = g.lineProperty(lineContent,"id");
               var name =  g.lineProperty(lineContent,"name");
               var namespace =  g.lineProperty(lineContent,"namespace");

               var repReg = new RegExp('\/\/\/\\s*?<transaction\\s*?id=\"' + id  ,'ig');

               var nid =g.guid();



               $scope.code = $scope.code.replace(repReg,'///<transaction  id="'+nid+'"  name="'+name+'" namespace="'+namespace+'"   > \r\n///点击此行编辑事务\r\n///点击此行删除事务 \r\n  ///</transaction>\r\n\r\n///<transaction id="'+id);

               $timeout(function() {
               $scope.lineTest();
               }, 300);


                $scope.$$phase || $scope.$apply();



             }
             else{
                    // if (A1.line!=0 ){
                    //    if (!$scope.addTransaction)
                    //     {
                    //        $scope.addTransaction = true;
                    //        $scope.currentCursor = {};
                    //        $scope.transaction ={};
                    //        $scope.transactionProperties =[];
                    //        $scope.$$phase || $scope.$apply();
                    //      }
                    // }
             }

          });
    };

    $scope.pageId= $stateParams.pageId;
    $scope.transaction ={};

    $scope.code = "";
    $scope.eventRow = {};
    $scope.eName ='';
    $scope.eventType =4;
    $scope.addTransaction =true;
    $scope.pageEventFlag = true;
    $scope.compileMode = false;
    $scope.compileCode = '';
    $scope.compileCheck = true;
    $scope.log= "此处显示日志信息";
    g.init_global();







   $scope.renderList =function(){

      console.log($scope.pageId);


      var pg =_.find(cooConfig.allpage,function(n){ return n.ID == $scope.pageId });
      var etor ={"key":"event","categoryId": pg.categoryId};



      console.log(pg);

      $.when(rest.adminList(etor)).done(function (result) {
          console.log(result);
          console.log($scope);

          $scope.eventRows = result;

          var rx = _.find(result,function(n){ return n.pageId==$scope.pageId && n.eventType== $scope.eventType });

          if (rx){

            $scope.eventRow = rx;
            $scope.code = rx.eventSource;

          }else{

            $scope.eventRow = {};
            $scope.code = '';

          }

          $scope.$apply();
          $('.app-header-fixed').css('padding-top','10px');


          $scope.lineTest();

      });

   }



  console.log($location.path());
  $scope.renderList();


  $scope.lineTest = function(){
      var k=0;
      var k2=0;
      var k3 =0;
      var args =[];
      var args2=[];
      var descLines =[];




      $scope._editor.getDoc().eachLine(function(row){
          if (row.text.indexOf('<cname>')>=0){
             descLines.push(k3);
          }
          k3++;
      });



      $scope._editor.getDoc().eachLine(function(row){
          if (row.text.indexOf('\/\/\/自定逻辑')>=0){
              args2.push(k2);
          }

          k2++;
      });

      $scope._editor.getDoc().eachLine(function(row){
          if (row.text.indexOf('\/\/\/点击此行')>=0){
              args.push(k);
          }
          k++;
      });
      $(args).each(function(i,j){
        $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'highlight-color' } );
      });

      $(args2).each(function(i,j){
        $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'friendly-color' } );
      });

      $(descLines).each(function(i,j){
        $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'desc-color' } );
      });





        //  $scope._editor.foldCode(CodeMirror.Pos(0, 0));
        //
        // $scope._editor.foldCode(CodeMirror.Pos(4, 0));

  }

  $scope.codex = function(){


    var doc = $scope._editor.getDoc();


    var transactionBlockArray = g.getNestedRegArrayString($scope.code,'<transaction','</transaction>');

    $(transactionBlockArray).each(function(i,currentTransaction){

        var idx =  $scope.code.indexOf(currentTransaction);
        var docPosStart =  doc.posFromIndex(idx);
        var docPosEnd = doc.posFromIndex(idx + currentTransaction.length);
        $scope._editor.foldCodeTransaction(CodeMirror.Pos(docPosStart.line +2, 0),CodeMirror.Pos( docPosEnd.line - 1 ,100) , null, 'fold');

    });







    //console.log(transactionBlockArray);



  }

  $scope.fold = function(){
        var doc = $scope._editor.getDoc();
        var A1 = $scope._editor.getCursor();

        var lineContent = doc.getLine(A1.line);
        var id = g.lineProperty(lineContent,"id");
        var rex = new RegExp("\\/\\/\\/<transaction\\s*\?id\\s*\?=\\s*\?\""+ id +"\"\\s*\?[\\S\\s]*\?$");

        var f= rex.exec($scope.code);
        if (f && f[0]){

          var innerTransactionStr =  f[0].substr(10);
          var transactionBlockArray = g.getNestedRegArrayString(innerTransactionStr,'<transaction','</transaction>');

          $(transactionBlockArray).each(function(i,currentTransaction){

              var idx =  $scope.code.indexOf(currentTransaction);
              var docPosStart =  doc.posFromIndex(idx);
              var docPosEnd = doc.posFromIndex(idx + currentTransaction.length);
              $scope._editor.foldCodeTransaction(CodeMirror.Pos(docPosStart.line +2, 0),CodeMirror.Pos( docPosEnd.line - 1 ,100) , null, 'fold');

          });


        }



    //   $scope._editor.foldCodeTransaction(CodeMirror.Pos(5, 0),CodeMirror.Pos(35,100) , null, 'fold');
  }

  $scope.searchSwitch = function(i){

  }

  $scope.cSwitch = function(){
      $scope.addTransaction =!$scope.addTransaction;

      if ($scope.addTransaction)
      {
         $scope.transaction ={};
         $scope.currentId = null;
         $scope.transactionProperties =[];

      }

     $scope.$$phase || $scope.$apply();

  }

  $scope.back =function(){

    $('.app-header-fixed').css('padding-top','50px');
    $state.go('app.admin.apppage');

  }






  $scope.codePreviewPage = function(preview){
    var insertList =[];
    var updateList =[];

    var k=0;
    for(var l=0;l<$scope.code.length;l++)
    {
        if ($scope.code[l]=='{') k++;
        if ($scope.code[l]=='}') k--;
    }
    console.log(k);
    if (k!=0){
         g.modal1('括号未匹配，请检查!');
         return false;
    }


    if ($scope.eventRow.ID){
      $scope.eventRow.eventSource = $scope.code;
      updateList.push($scope.eventRow);
    }
    else{
      insertList.push({ID:0,eventType:$scope.eventType,pageId:$scope.pageId,eventSource:$scope.code });
    }


      var etor = {
          key: 'event',
          insertList: JSON.stringify(insertList),
          updateList: JSON.stringify(updateList),
          delIds: []
      };



      g.show_ajax();
      $.when(rest.adminAdapter(etor)).done(function(result){
          console.log(result);
           if (!preview) {
              g.hide_ajax();
               g.modal1('已保存!');
               if (!$scope.eventRow.ID){
                   $scope.renderList();
               }
             }



             if (preview){

               if (!$scope.eventRow.ID){


                 var pg =_.find(cooConfig.allpage,function(n){ return n.ID == $scope.pageId });
                 var etor ={"key":"event","categoryId": pg.categoryId};

                 $.when(rest.adminList(etor)).done(function (result) {
                         $scope.eventRows = result;
                         var rx = _.find(result,function(n){ return n.pageId==$scope.pageId && n.eventType== $scope.eventType });
                         if (rx){
                           $scope.eventRow = rx;
                           $scope.code = rx.eventSource;
                         }
                         else{
                           $scope.eventRow = {};
                           $scope.code = '';
                         }

                       if ($scope.eventRow.ID>0){

                         if ($scope.compileCheck){
                           $.when(rest.codeCompileCheck2({  codeType: 1 , itemId: $scope.eventRow.ID }).done(function(r3){
                                g.hide_ajax();
                                $scope.log = r3.message;
                                if (r3.message){
                                    g.modal1("编译有错,查看下面详细信息");

                                }
                                else{
                                    $scope.log = r3.message;
                                     $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                         g.modal1('已保存!');
                                         console.log(r2);
                                     });
                                }
                           }));

                         }
                         else{
                               $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                   g.modal1('已保存!');
                                   console.log(r2);
                               });
                         }
                       }
                 });
               }
               else{



                 if ($scope.eventRow.ID>0){
                    console.log($scope.eventRow.ID);

                     if ($scope.compileCheck){
                           $.when(rest.codeCompileCheck2({  codeType : 1 , itemId: $scope.eventRow.ID }).done(function(r3){

                                 g.hide_ajax();
                                 $scope.log = r3.message;

                                 if (r3.message){
                                     g.modal1("编译有错,查看下面详细信息");

                                 }
                                 else{
                                     console.log(r3);
                                     $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                         g.modal1('已保存!');
                                         console.log(r2);
                                     });

                                 }


                           }));


                     }
                     else {
                             $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                 g.modal1('已保存!');
                                 console.log(r2);
                             });

                     }

                 }
               }


             }









      });
  }


  $scope.codeGenerate = function() {

        gApp.codeGenerate($scope,'transaction',['__c244','__c240','__c241','__c254']) ;

  }


  $scope.remove2 = function(key){

    g.show_ajax();

    $scope.transactionProperties =  _.filter( $scope.transactionProperties  ,function(n){ return n.key!=key });
    $scope.$$phase || $scope.$apply();
    g.hide_ajax();

  }


  $scope.trans2 = function(startkey){

     g.show_ajax();

     var key = startkey.replace(/\d+$/ig,'');

     var ks = _.filter( $scope.transactionProperties  ,function(n){
       return n.keyword.indexOf(key)>-1
     });

     var baseRow = _.find( $scope.transactionProperties  ,function(n){ return n.keyword==startkey });

     console.log(startkey);
     console.log(baseRow);

     var newRow ={};
     newRow.keyword = key  +ks.length.toString();
     newRow.class = baseRow.class;
     newRow.ext = baseRow.ext;
     newRow.type = baseRow.type;
     newRow.source = baseRow.source;
     newRow.order = baseRow.order;
     if (baseRow.list){
           newRow.list = [];
           $(baseRow.list).each(function(i,j){
               newRow.list.push({
                           keyword: j.keyword.replace(/_\d+$/ig,'')  +'_' +ks.length.toString(),
                           type:j.type,
                           variable : j.variable,
                           placeholder:j.placeholder,
                           class :j.class,
                           source : j.source,
                           source1 : j.source1
               });
           });
     }





     $scope.transactionProperties.push(newRow);

     $scope.transactionProperties =  _.sortBy($scope.transactionProperties,'order');
     $scope.transactionProperties =  _.sortBy($scope.transactionProperties,'name');

     console.log($scope.transactionProperties);

     $scope.$$phase || $scope.$apply();

     g.hide_ajax();



  }

  $scope.codeTest = function(){
     console.log($scope.transactionProperties);
  }


  $scope.formulaRow = function(transIndex){

      gApp.formulaExt($scope,transIndex);

  }

  $scope.variableRow = function(transIndex){

     $scope.subPages = _.filter(cooConfig.allpage ,function(n) { return n.parentId == $scope.pageId });



      gApp.variableExt($scope,transIndex,-1);
  }

  $scope.editRow = function(transIndex){

      console.log(transIndex);

      gApp.setExt($scope,transIndex);

  }

  $scope.selectTransaction = function(row,vals){




      $scope.pageIds = [];
      $scope.pageIds.push($scope.pageId);
      gApp.selectCode($scope,'transaction',row,vals,['__c251','__c249','__c248']);

      return false;


  }


  $scope.transaction_modal =function( ){




     console.log($scope);


   var pageId =1;

   var modalInstance = $modal.open({
        templateUrl: 'tpl/admin/transaction_modal.html?'+cooConfig.configObj.version,
        controller: 'admin_transaction_modal_instance_ctrl',
        size: 'lg',
        resolve:
              g.load([],
              function(){},
              {
                pageId: function(){ return pageId},
                modal_lsc: function() { return [] }
              }
             )

      });

      modalInstance.result.then(function (row) {



         $scope.selectTransaction(row,[]);








      }, function () {
       //$log.info('Modal dismissed at: ' + new Date());
      });


  }


  $scope.fullCode =function(){


       var modalInstance = $modal.open({
           templateUrl: 'tpl/admin/full_code.html?'+cooConfig.configObj.version,
           controller: 'admin_full_code_modal_instance_ctrl',
           size: 'lg',
           resolve:
                 g.load([],
                 function(){},
                 {
                   row: function(){ return $scope.code },
                   mode: function(){ return "text/x-csharp" }
                 }
                )

         });



          modalInstance.result.then(function (row) {
             $scope.code =row;
             console.log(row);
           }, function () {
                      //$log.info('Modal dismissed at: ' + new Date());
           });
    }


});











app.controller('adminapptransactiondetail', function ($rootScope,$timeout,$interval,$state, $scope, $location,$stateParams, $sce,$filter, $modal, cooConfig, g, rest ,gApp  ) {


      if (cooConfig.configObj.adminDisabled) {
           $('button').prop('disabled',true);
      }




      $scope.editorOptions = {
        lineNumbers: true,
        matchBrackets: true,
        styleActiveLine: true,
        theme:"ambiance",
        mode:    "text/x-csharp",
        extraKeys: {"Ctrl-Q": function(cm){ cm.foldCode(cm.getCursor()); }},
        foldGutter: true,
        gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"]

    };

    $scope.codemirrorLoaded = function(_editor){
        $scope._editor = _editor;

        _editor.on('cursorActivity', function() {
             var doc =_editor.getDoc();
             var A1 = _editor.getCursor();


             var lineContent1 = doc.getLine(A1.line);
             if (lineContent1.indexOf("\/\/\/点击此行替换")>=0){
                    $scope.addTransaction = false;
             }

             gApp.setTransactionModal($scope);

             if (lineContent1.indexOf("\/\/\/<cname")>=0)
             {
                var transactionRange =   gApp.foldCode($scope);

                console.log(transactionRange);

                $scope._editor.foldCodeTransaction(CodeMirror.Pos(transactionRange.startLine +2, 0),CodeMirror.Pos( transactionRange.endLine -1 ,100) , null, 'fold');

             }




             if (lineContent1.indexOf("\/\/\/点击此行编辑")>=0)
             {
                $scope.currentCursor =A1;
                var lineContent =   gApp.getDocLine(doc,A1) ;

            //    doc.getLine(A1.line-1);


                  $scope.addTransaction = false;

                  var id = g.lineProperty(lineContent,"id");

                  $scope.currentId = id;
                  $scope.currentIndex = g.lineProperty(lineContent,"index");


                  var name =  g.lineProperty(lineContent,"name");
                  var namespace =  g.lineProperty(lineContent,"namespace");


                  var lsc =[ {patternId: 241, val1: name, pTypeId: 5, operation: 1},
                  {patternId: 254, val1: namespace, pTypeId: 5, operation: 1}];


                  var  etor ={"companyId":1000,"cid":19,"id":137,"lsc":lsc,"iindex":1,"isize": 1,
                   url : "https://center.mvcx.net/list/ajxlist2"   }   ;

                   g.show_ajax();
                   $.when(rest.remote_data(etor,"proxy")).done(function(retx){


                        var rex = new RegExp("\\/\\/\\/<transaction\\s*\?id\\s*\?=\\s*\?\""+id+"[\\S\\s]*\?\\/\\/\\/<\\/transaction>");

                        if ($scope.currentIndex){
                          console.log($scope.currentIndex);
                          rex = new RegExp("\\/\\/\\/<transaction\\s*\?id\\s*\?=\\s*\?\""+id+"\"\\s*\?index=\""+$scope.currentIndex+"\"[\\S\\s]*\?\\/\\/\\/<\\/transaction>");
                        }

                        var f =rex.exec($scope.code);
                        var rargs=[];
                        if (f[0]){
                          var rb = g.angleBrackets(f[0],"content");
                            if (rb)    rargs = JSON.parse(rb);

                        }

                        var dx = JSON.parse(retx.data);
                        if (dx.data.length>0){
                           $scope.selectTransaction(dx.data[0], rargs);
                        }
                   });





             }
             else  if (lineContent1.indexOf("\/\/\/点击此行重复")>=0){

               console.log(A1);


               $scope.currentCursor =A1;
               var lineContent =  gApp.getDocLine(doc,A1);




               var id = g.lineProperty(lineContent,"id");
               var name =  g.lineProperty(lineContent,"name");
               var namespace =  g.lineProperty(lineContent,"namespace");

               var repReg = new RegExp('\/\/\/\\s*?<transaction\\s*?id=\"' + id  ,'ig');

               var nid =g.guid();



               $scope.code = $scope.code.replace(repReg,'///<transaction  id="'+nid+'"  name="'+name+'" namespace="'+namespace+'"   > \r\n///点击此行编辑事务\r\n///点击此行删除事务 \r\n  ///</transaction>\r\n\r\n///<transaction id="'+id);

               $timeout(function() {
               $scope.lineTest();
               }, 300);


                $scope.$$phase || $scope.$apply();



             }
             else{
                    // if (A1.line!=0 ){
                    //    if (!$scope.addTransaction)
                    //     {
                    //        $scope.addTransaction = true;
                    //        $scope.currentCursor = {};
                    //        $scope.transaction ={};
                    //        $scope.transactionProperties =[];
                    //        $scope.$$phase || $scope.$apply();
                    //      }
                    // }
             }

          });
    };

    $scope.pageId= $stateParams.pageId;
    $scope.transaction ={};

    $scope.code = "";
    $scope.eventRow = {};
    $scope.eName ='';
    $scope.eventType =2;
    $scope.addTransaction =true;
    $scope.pageEventFlag = true;
    $scope.compileMode = false;
    $scope.compileCode = '';
    $scope.compileCheck = true;
    $scope.log= "此处显示日志信息";
    g.init_global();


    $scope.eventTypeToggle = function(evt){



        var rx = _.find($scope.eventRows,function(n){ return n.pageId==$scope.pageId && n.eventType== evt });
        if (rx){
          $scope.eventRow = rx;
          $scope.code = rx.eventSource;
        }
        else{
          $scope.eventRow = {};
          $scope.code = '';
        }

         $scope.eventType = evt;

         $timeout(function() {
         $scope.lineTest();
         }, 300);

         $scope.$$phase || $scope.$apply();

    }

  $scope.renderSystemEvent = function(){
            var etor ={"key":"auth",itemId: $stateParams.itemId };
            $.when(rest.adminDetail(etor)).done(function (result ) {


               $scope.eventRow =result ;
               $scope.code  =  result.eventSource;
               $scope.eventType= result.eventType;
               $scope.eName = result.eName;

               $scope.pageEventFlag=false;






                $scope.$apply();
                 $('.app-header-fixed').css('padding-top','10px');
                 $scope.lineTest();


            });

  }



  $scope.renderListRowAuth = function(){

          var etor ={"key":"auth","categoryId": $stateParams.categoryId };
          $.when(rest.adminList2(etor)).done(function (result ) {


            $(result.data).each(function (i, o) {
                if (o.eventType == 2 ) {
                  $scope.eventRow = o ;
                  $scope.code  =  o.eventSource;
                };
            });

              $scope.$apply();
              $('.app-header-fixed').css('padding-top','10px');
              $scope.lineTest();


          });

  }



   $scope.renderList =function(){

      console.log($scope.pageId);


      var pg =_.find(cooConfig.allpage,function(n){ return n.ID == $scope.pageId });
      var etor ={"key":"event","categoryId": pg.categoryId};



      console.log(pg);

      $.when(rest.adminList(etor)).done(function (result) {
          console.log(result);
          console.log($scope);

          $scope.eventRows = result;

          var rx = _.find(result,function(n){ return n.pageId==$scope.pageId && n.eventType== $scope.eventType });

          if (rx){

            $scope.eventRow = rx;
            $scope.code = rx.eventSource;

          }else{

            $scope.eventRow = {};
            $scope.code = '';

          }



          $scope.$apply();
          $('.app-header-fixed').css('padding-top','10px');


          $scope.lineTest();

      });

   }

  $scope.renderWrap = function(){
      var rt = $location.path();
      console.log(rt);
      if (rt.indexOf('transaction')>0){
          $scope.renderList();
      }
      else if (rt.indexOf('rowauth')>0){
          $scope.renderListRowAuth();
      }
      else if (rt.indexOf('systemevent')>0){
        $scope.renderSystemEvent();
      }


  }

  console.log($location.path());
  $scope.renderWrap();


  $scope.lineTest = function(){
      var k=0;
      var k2=0;
      var k3 =0;
      var args =[];
      var args2=[];
      var descLines =[];




      $scope._editor.getDoc().eachLine(function(row){
          if (row.text.indexOf('<cname>')>=0){
             descLines.push(k3);
          }
          k3++;
      });



      $scope._editor.getDoc().eachLine(function(row){
          if (row.text.indexOf('\/\/\/自定逻辑')>=0){
              args2.push(k2);
          }

          k2++;
      });

      $scope._editor.getDoc().eachLine(function(row){
          if (row.text.indexOf('\/\/\/点击此行')>=0){
              args.push(k);
          }
          k++;
      });
      $(args).each(function(i,j){
        $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'highlight-color' } );
      });

      $(args2).each(function(i,j){
        $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'friendly-color' } );
      });

      $(descLines).each(function(i,j){
        $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'desc-color' } );
      });





        //  $scope._editor.foldCode(CodeMirror.Pos(0, 0));
        //
        // $scope._editor.foldCode(CodeMirror.Pos(4, 0));

  }

  $scope.codex = function(){


    var doc = $scope._editor.getDoc();


    var transactionBlockArray = g.getNestedRegArrayString($scope.code,'<transaction','</transaction>');

    $(transactionBlockArray).each(function(i,currentTransaction){

        var idx =  $scope.code.indexOf(currentTransaction);
        var docPosStart =  doc.posFromIndex(idx);
        var docPosEnd = doc.posFromIndex(idx + currentTransaction.length);
        $scope._editor.foldCodeTransaction(CodeMirror.Pos(docPosStart.line +2, 0),CodeMirror.Pos( docPosEnd.line - 1 ,100) , null, 'fold');

    });







    //console.log(transactionBlockArray);



  }

  $scope.fold = function(){
        var doc = $scope._editor.getDoc();
        var A1 = $scope._editor.getCursor();

        var lineContent = doc.getLine(A1.line);
        var id = g.lineProperty(lineContent,"id");
        var rex = new RegExp("\\/\\/\\/<transaction\\s*\?id\\s*\?=\\s*\?\""+ id +"\"\\s*\?[\\S\\s]*\?$");

        var f= rex.exec($scope.code);
        if (f && f[0]){

          var innerTransactionStr =  f[0].substr(10);
          var transactionBlockArray = g.getNestedRegArrayString(innerTransactionStr,'<transaction','</transaction>');

          $(transactionBlockArray).each(function(i,currentTransaction){

              var idx =  $scope.code.indexOf(currentTransaction);
              var docPosStart =  doc.posFromIndex(idx);
              var docPosEnd = doc.posFromIndex(idx + currentTransaction.length);
              $scope._editor.foldCodeTransaction(CodeMirror.Pos(docPosStart.line +2, 0),CodeMirror.Pos( docPosEnd.line - 1 ,100) , null, 'fold');

          });


        }



    //   $scope._editor.foldCodeTransaction(CodeMirror.Pos(5, 0),CodeMirror.Pos(35,100) , null, 'fold');
  }

  $scope.searchSwitch = function(i){

  }

  $scope.cSwitch = function(){
      $scope.addTransaction =!$scope.addTransaction;

      if ($scope.addTransaction)
      {
         $scope.transaction ={};
         $scope.currentId = null;
         $scope.transactionProperties =[];

      }

     $scope.$$phase || $scope.$apply();

  }

  $scope.back =function(){

    $('.app-header-fixed').css('padding-top','50px');
    $state.go('app.admin.apppage');

  }


  $scope.codePreviewWrap = function(preview){
      var rt = $location.path();
      console.log(rt);
      if (rt.indexOf('transaction')>0){
          $scope.codePreviewPage(preview);
      }
      else if (rt.indexOf('rowauth')>0){
        $scope.codePreviewRowAuth(preview);
      }
      else if (rt.indexOf('systemevent')>0){
        $scope.codePreviewSystemEvent(preview);
      }


  }

  $scope.codePreviewSystemEvent = function(preview){

    var insertList =[];
    var updateList =[];

    var k=0;
    for(var l=0;l<$scope.code.length;l++)
    {
        if ($scope.code[l]=='{') k++;
        if ($scope.code[l]=='}') k--;
    }
    console.log(k);
    if (k!=0){
         g.modal1('括号未匹配，请检查!');
         return false;
    }





    if ($scope.eventRow.ID){
      $scope.eventRow.eventSource = $scope.code;
      updateList.push($scope.eventRow);
    }

      var etor = {
          key: 'auth',
          insertList: JSON.stringify(insertList),
          updateList: JSON.stringify(updateList),
          delIds: []
      };



      g.show_ajax();
      $.when(rest.adminAdapter(etor)).done(function(result){
          console.log(result);
           if (!preview) {
              g.hide_ajax();
               g.modal1('已保存!');
             }
           if (preview){


               if ($scope.eventRow.ID>0){
                  console.log($scope.eventRow.ID);
                   if ($scope.compileCheck){
                         $.when(rest.codeCompileCheck2({  codeType : 1 , itemId: $scope.eventRow.ID }).done(function(r3){

                               g.hide_ajax();
                               $scope.log = r3.message;

                               if (r3.message){
                                   g.modal1("编译有错,查看下面详细信息");

                               }
                               else{
                                   console.log(r3);
                                   $.when(rest.testGlobalEvent({eventId:$scope.eventRow.ID})).done(function(r2){

                                       g.modal1('已保存!');
                                   });

                               }


                         }));


                   }
                   else {
                         $.when(rest.testGlobalEvent({eventId:$scope.eventRow.ID})).done(function(r2){
                              g.hide_ajax();
                              console.log("nocheck");
                             g.modal1('已保存!');
                         });

                   }

               }

           }

      });

  }



  $scope.codePreviewRowAuth = function(preview){

    var insertList =[];
    var updateList =[];

    var k=0;
    for(var l=0;l<$scope.code.length;l++)
    {
        if ($scope.code[l]=='{') k++;
        if ($scope.code[l]=='}') k--;
    }
    console.log(k);
    if (k!=0){
         g.modal1('括号未匹配，请检查!');
         return false;
    }


    if ($scope.eventRow.ID){
      $scope.eventRow.eventSource = $scope.code;
      updateList.push($scope.eventRow);
    }
    else{
      insertList.push({
        ID:0,
        eventType:2,
        pName : '行权限'+$stateParams.categoryId,
        eName :'rowauth' + $stateParams.categoryId,
        eDesc:  '行权限'+$stateParams.categoryId,
        categoryId :$stateParams.categoryId,
        eventSource:$scope.code
      });
    }


      var etor = {
          key: 'auth',
          insertList: JSON.stringify(insertList),
          updateList: JSON.stringify(updateList),
          delIds: []
      };



      g.show_ajax();
      $.when(rest.adminAdapter(etor)).done(function(result){
          console.log(result);
           if (!preview) {
              g.hide_ajax();
               g.modal1('已保存!');
               if (!$scope.eventRow.ID){
                   $scope.renderWrap();
               }
             }
           if (preview){

             if (!$scope.eventRow.ID){

               var etor ={"key":"auth","categoryId": $stateParams.categoryId };
               $.when(rest.adminList2(etor)).done(function (result) {

                     var rx = _.find(result,function(n){ return n.pageId==$scope.pageId && n.eventType== $scope.eventType });
                     if (rx){
                       $scope.eventRow = rx;
                       $scope.code = rx.eventSource;
                     }
                     else{
                       $scope.eventRow = {};
                       $scope.code = '';
                     }

                     $(result.data).each(function (i, o) {
                         if (o.eventType == 2 ) {
                           $scope.eventRow=o;
                         };
                     });

                     if ($scope.eventRow.ID>0){

                       if ($scope.compileCheck){
                         $.when(rest.codeCompileCheck2({  codeType: 2 , itemId: $scope.eventRow.ID }).done(function(r3){
                              g.hide_ajax();
                              $scope.log = r3.message;
                              if (r3.message){
                                  g.modal1("编译有错,查看下面详细信息");

                              }
                              else{
                                  $scope.log = r3.message;
                                  $.when(rest.testGlobalEvent({eventId:$scope.eventRow.ID})).done(function(r2){

                                      g.modal1('已保存!');
                                  });
                              }
                         }));

                       }
                       else{
                             $.when(rest.testGlobalEvent({eventId:$scope.eventRow.ID})).done(function(r2){
                                  g.hide_ajax();
                                  console.log("nocheck");
                                 g.modal1('已保存!');
                             });
                       }
                     }
               });
             }
             else{



               if ($scope.eventRow.ID>0){
                  console.log($scope.eventRow.ID);
                   console.log('xx332111');
                   if ($scope.compileCheck){
                         $.when(rest.codeCompileCheck2({  codeType : 2 , itemId: $scope.eventRow.ID }).done(function(r3){

                               g.hide_ajax();
                               $scope.log = r3.message;

                               if (r3.message){
                                   g.modal1("编译有错,查看下面详细信息");

                               }
                               else{
                                   console.log(r3);
                                   $.when(rest.testGlobalEvent({eventId:$scope.eventRow.ID})).done(function(r2){

                                       g.modal1('已保存!');
                                   });

                               }


                         }));


                   }
                   else {
                         $.when(rest.testGlobalEvent({eventId:$scope.eventRow.ID})).done(function(r2){
                              g.hide_ajax();
                              console.log("nocheck");
                             g.modal1('已保存!');
                         });

                   }

               }
             }


           }

      });

  }


  $scope.codePreviewPage = function(preview){
    var insertList =[];
    var updateList =[];

    var k=0;
    for(var l=0;l<$scope.code.length;l++)
    {
        if ($scope.code[l]=='{') k++;
        if ($scope.code[l]=='}') k--;
    }
    console.log(k);
    if (k!=0){
         g.modal1('括号未匹配，请检查!');
         return false;
    }


    if ($scope.eventRow.ID){
      $scope.eventRow.eventSource = $scope.code;
      updateList.push($scope.eventRow);
    }
    else{
      insertList.push({ID:0,eventType:$scope.eventType,pageId:$scope.pageId,eventSource:$scope.code });
    }


      var etor = {
          key: 'event',
          insertList: JSON.stringify(insertList),
          updateList: JSON.stringify(updateList),
          delIds: []
      };



      g.show_ajax();
      $.when(rest.adminAdapter(etor)).done(function(result){
          console.log(result);
           if (!preview) {
              g.hide_ajax();
               g.modal1('已保存!');
               if (!$scope.eventRow.ID){
                   $scope.renderList();
               }
             }



             if (preview){

               if (!$scope.eventRow.ID){


                 var pg =_.find(cooConfig.allpage,function(n){ return n.ID == $scope.pageId });
                 var etor ={"key":"event","categoryId": pg.categoryId};

                 $.when(rest.adminList(etor)).done(function (result) {
                         $scope.eventRows = result;
                         var rx = _.find(result,function(n){ return n.pageId==$scope.pageId && n.eventType== $scope.eventType });
                         if (rx){
                           $scope.eventRow = rx;
                           $scope.code = rx.eventSource;
                         }
                         else{
                           $scope.eventRow = {};
                           $scope.code = '';
                         }

                       if ($scope.eventRow.ID>0){

                         if ($scope.compileCheck){
                           $.when(rest.codeCompileCheck2({  codeType: 1 , itemId: $scope.eventRow.ID }).done(function(r3){
                                g.hide_ajax();
                                $scope.log = r3.message;
                                if (r3.message){
                                    g.modal1("编译有错,查看下面详细信息");

                                }
                                else{
                                    $scope.log = r3.message;
                                     $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                         g.modal1('已保存!');
                                         console.log(r2);
                                     });
                                }
                           }));

                         }
                         else{
                               $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                   g.modal1('已保存!');
                                   console.log(r2);
                               });
                         }
                       }
                 });
               }
               else{



                 if ($scope.eventRow.ID>0){
                    console.log($scope.eventRow.ID);

                     if ($scope.compileCheck){
                           $.when(rest.codeCompileCheck2({  codeType : 1 , itemId: $scope.eventRow.ID }).done(function(r3){

                                 g.hide_ajax();
                                 $scope.log = r3.message;

                                 if (r3.message){
                                     g.modal1("编译有错,查看下面详细信息");

                                 }
                                 else{
                                     console.log(r3);
                                     $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                         g.modal1('已保存!');
                                         console.log(r2);
                                     });

                                 }


                           }));


                     }
                     else {
                             $.when(rest.testPageEvent({pageId:$scope.pageId,eventType:$scope.eventType})).done(function(r2){
                                 g.modal1('已保存!');
                                 console.log(r2);
                             });

                     }

                 }
               }


             }









      });
  }


  $scope.codeGenerate = function() {

        gApp.codeGenerate($scope,'transaction',['__c244','__c240','__c241','__c254']) ;

  }


  $scope.remove2 = function(key){

    g.show_ajax();

    $scope.transactionProperties =  _.filter( $scope.transactionProperties  ,function(n){ return n.key!=key });
    $scope.$$phase || $scope.$apply();
    g.hide_ajax();

  }


  $scope.trans2 = function(startkey){

     g.show_ajax();

     var key = startkey.replace(/\d+$/ig,'');

     var ks = _.filter( $scope.transactionProperties  ,function(n){
       return n.keyword.indexOf(key)>-1
     });

     var baseRow = _.find( $scope.transactionProperties  ,function(n){ return n.keyword==startkey });

     console.log(startkey);
     console.log(baseRow);

     var newRow ={};
     newRow.keyword = key  +ks.length.toString();
     newRow.class = baseRow.class;
     newRow.ext = baseRow.ext;
     newRow.type = baseRow.type;
     newRow.source = baseRow.source;
     newRow.order = baseRow.order;
     if (baseRow.list){
           newRow.list = [];
           $(baseRow.list).each(function(i,j){
               newRow.list.push({
                           keyword: j.keyword.replace(/_\d+$/ig,'')  +'_' +ks.length.toString(),
                           type:j.type,
                           variable : j.variable,
                           placeholder:j.placeholder,
                           class :j.class,
                           source : j.source,
                           source1 : j.source1
               });
           });
     }





     $scope.transactionProperties.push(newRow);

     $scope.transactionProperties =  _.sortBy($scope.transactionProperties,'order');
     $scope.transactionProperties =  _.sortBy($scope.transactionProperties,'name');

     console.log($scope.transactionProperties);

     $scope.$$phase || $scope.$apply();

     g.hide_ajax();



  }

  $scope.codeTest = function(){
     console.log($scope.transactionProperties);
  }


  $scope.formulaRow = function(transIndex){

      gApp.formulaExt($scope,transIndex);

  }

  $scope.variableRow = function(transIndex){

     $scope.subPages = _.filter(cooConfig.allpage ,function(n) { return n.parentId == $scope.pageId });



      gApp.variableExt($scope,transIndex,-1);
  }

  $scope.editRow = function(transIndex){

      console.log(transIndex);

      gApp.setExt($scope,transIndex);

  }

  $scope.selectTransaction = function(row,vals){




      $scope.pageIds = [];
      $scope.pageIds.push($scope.pageId);
      gApp.selectCode($scope,'transaction',row,vals,['__c251','__c249','__c248']);

      return false;


  }


  $scope.transaction_modal =function( ){




     console.log($scope);


   var pageId =1;

   var modalInstance = $modal.open({
        templateUrl: 'tpl/admin/transaction_modal.html?'+cooConfig.configObj.version,
        controller: 'admin_transaction_modal_instance_ctrl',
        size: 'lg',
        resolve:
              g.load([],
              function(){},
              {
                pageId: function(){ return pageId},
                modal_lsc: function() { return [] }
              }
             )

      });

      modalInstance.result.then(function (row) {



         $scope.selectTransaction(row,[]);








      }, function () {
       //$log.info('Modal dismissed at: ' + new Date());
      });


  }


  $scope.fullCode =function(){


       var modalInstance = $modal.open({
           templateUrl: 'tpl/admin/full_code.html?'+cooConfig.configObj.version,
           controller: 'admin_full_code_modal_instance_ctrl',
           size: 'lg',
           resolve:
                 g.load([],
                 function(){},
                 {
                   row: function(){ return $scope.code },
                   mode: function(){ return "text/x-csharp" }
                 }
                )

         });



          modalInstance.result.then(function (row) {
             $scope.code =row;
             console.log(row);
           }, function () {
                      //$log.info('Modal dismissed at: ' + new Date());
           });
    }


});


app.controller('adminapppagedetail', function ($rootScope,$timeout,$state, $scope, $location,$stateParams, $sce,$filter, $modal, cooConfig, g, rest ,gApp  ) {


      $scope._editor ={};
      $scope.currentCursor = {};
      $scope.highlightText = "";
      $scope.addComponent =true;
      $scope.addFunction =true;
      $scope.activeTab ="component";

      $scope.cSwitch = function(){
           $scope.addComponent =!$scope.addComponent;

           if ($scope.addComponent)
           {
              $scope.component ={};
              $scope.componentProperties =[];

           }
      }

      $scope.cSwitchFunction = function(){
           $scope.addFunction =!$scope.addFunction;

           if ($scope.addFunction)
           {
              $scope.funcx ={};
              $scope.funcxProperties =[];
           }
      }

      $scope.search1 = function(){
         $scope.activeTab = "component";
      }

     $scope.search2 = function(){
        $scope.activeTab = "function";
     }

      $scope.codemirrorLoaded = function(_editor){
          $scope._editor = _editor;

          _editor.on('cursorActivity', function() {

               gApp.setModal($scope);
               gApp.editCode($scope);

               // else{
               //        if (A1.line!=0 && lineContent1.indexOf("\/\/\/点击此行") < 0 ){
               //           if ($scope.activeTab=="component" && !$scope.addComponent)
               //            {
               //               $scope.addComponent = true;
               //               $scope.currentCursor = {};
               //               $scope.component ={};
               //               $scope.componentProperties =[];
               //               $scope.$$phase || $scope.$apply();
               //             }
               //            if ($scope.activeTab=="function" && !$scope.addFunction ){
               //              $scope.addFunction = true;
               //              $scope.currentCursor = {};
               //              $scope.funcx ={};
               //              $scope.funcxProperties =[];
               //              $scope.$$phase || $scope.$apply();
               //            }
               //        }
               // }

            });
      };



      $scope.editorOptions = {
        lineNumbers: true,
        matchBrackets: true,
        styleActiveLine: true,
        theme:"ambiance"
    };


       var pageId= $stateParams.pageId;
       var itemId =  $stateParams.itemId;
       $scope.componentProperties =[];
       $scope.component ={};
       $scope.funcxProperties =[];
       $scope.funcx ={};
       $scope.allPages =[];
       $scope.selectedPages = [];
       $scope.frameUrl = "";
       $scope.currentId ="";
       $scope.importStr ="";
       $scope.functionStr = "";

      $scope.initData = function(){

        var tps =[2,3,8,9,10,15,16,99,100,101];

        $(cooConfig.allcategory).each(function(i,c){
            var orow = { label: c.categoryName, children:[] };
            var subPages = _.filter(cooConfig.allpage,function(n){ return n.categoryId == c.ID && tps.indexOf(n.pageType)>=0 });
            $(subPages).each(function(j,p){
                var tps = _.find(cooConfig.pageTypes,function(n){return n.id==p.pageType});
                if (tps)
                orow.children.push({label:p.UIname + " - " +tps.name,value:p.ID});
            });
            $scope.allPages.push(orow);
        });
        console.log($scope.allPages);


      }

      $scope.back =function(){
        $('.app-header-fixed').css('padding-top','50px');
        $state.go('app.admin.apppage');
      }

      $scope.remove2 = function(key){

        g.show_ajax();

        $scope.componentProperties =  _.filter( $scope.componentProperties  ,function(n){ return n.key!=key });
        $scope.$$phase || $scope.$apply();
        g.hide_ajax();

      }


      $scope.trans2 = function(startkey){

         gApp.trans2($scope,startkey, 'component'  );



      }


      $scope.editRow = function(transIndex){


            gApp.setExt($scope,transIndex);

      }






     $scope.renderList = function(){


       var fileKey = $stateParams.fileKey;
       var fkey = fileKey.replace(/\.[^\.]+\.[a-z]+$/ig,'');
       var name = fileKey.substr(fkey.length+1);
       var path = fkey.replace(/\./ig,'\\') + '\\' + name;

        var etor = {
           fileKey:fkey,
           name :name,
           path: path,
           pathType:3
        };
        console.log(etor);
        $.when(rest.remote_data(etor,'gateway/fileinfo')).done(function(ret){

               $scope.code = ret.data;



               console.log($scope.frameUrl);

               $scope.frameUrl = cooConfig.configObj.url + "Front/Front/front";
               $scope.frameUrl =$sce.trustAsResourceUrl($scope.frameUrl);


               $scope.$$phase || $scope.$apply();


        });

       return false;





       var  etor ={pageId: pageId, itemId: itemId, method: 'ajx2',
        url : "https://center.mvcx.net/detail/ajx2"   }   ;

        g.show_ajax();
        $scope.data= {};

        $.when(rest.remote_data(etor,"gateway/module")).done(function(retx){

            $scope.initData();
            var ex = retx.data[0];
            $scope.data = ex;
            $scope.code = ex.c365;








            $scope.selectedPages =[];
            var pgs =[];
            if (typeof (ex.c373)=='object'){
               pgs = ex.c373;
            }
            else{
              console.log(ex.c373);
              pgs =JSON.parse(ex.c373);
            }
            $scope.currentPages = pgs;
            $scope.currentPagesView = _.pluck(pgs,'UIname');

            $scope.pageIds = _.pluck(pgs,'ID');

            var categoriesFlag = false;


            $(pgs).each(function(i,j){
              if (j.ID)  {
                $scope.selectedPages.push(j.ID.toString());
              }
               else{
                  categoriesFlag = true;
               }
            });



            $scope.frameUrl = cooConfig.configObj.url + cooConfig.configObj.appFolder + "/" ;
            if ($scope.data.c362){
              $scope.frameUrl += $scope.data.c362  ;
            }
            if ($scope.selectedPages.length>0){
               $scope.frameUrl += "?pageId=" + $scope.selectedPages[0];
            }

            console.log($scope.frameUrl);

            $scope.frameUrl = cooConfig.configObj.url + "Front/Front/front";
            $scope.frameUrl =$sce.trustAsResourceUrl($scope.frameUrl);




            g.hide_ajax();
            console.log( retx);
            $scope.$$phase || $scope.$apply();
            $('.app-header-fixed').css('padding-top','10px');
            $('.page-select').trigger('chosen:updated');

            $scope.lineTest();


             if (categoriesFlag){
               $timeout(
                 function(){
                       gApp.setCategories($scope);
                 }, 300
               );
             }

        });

     };

     $scope.setCategories = function(){
         gApp.setCategories($scope);
     }

     $scope.renderList();

     $scope.codePreview = function(preview){

        var pgs = $scope.currentPages;
        var px = [];
        $(pgs).each(function(i,j){
            px.push({ ID:j.ID,pageType:j.pageType,categoryId :j.categoryId,UIname: j.UIname });
        });

        var appcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == "appIdentity" });

        var arr =[
        {"_Key":"__c365","_Value": $scope.code },
        {"_Key":"__c362","_Value": $scope.data.c362},

        {"_Key":"__c373","_Value":JSON.stringify(px)}  ];
        var etor = {
           "jsonStr": JSON.stringify(arr),
           "relatedSTR":"[]",
           "pageId":100037,     //76
           "itemId":$stateParams.itemId ,
           "url":"https://center.mvcx.net/e/createupdate",
           "preview":preview,
           "method":"createUpdate"
        }

      g.show_ajax();

       $.when(rest.remote_data(etor,"gateway/module")).done(function(retx){

             g.hide_ajax();
       });

     }

     $scope.codeGenerateFuncx = function() {
           gApp.codeGenerateFuncx($scope);
     }

     $scope.codeGenerate = function() {
         gApp.codeGenerate($scope,'component',['__c56','__c52','__c53','__c224']);
     }

     $scope.lineTest = function(){
         var k=0;
         var args =[];
         var redLines =[];
         var descLines =[];
         $scope._editor.getDoc().eachLine(function(row){
             if (row.text.indexOf('点击此行')>=0){
                 args.push(k);
             }
            if (row.text.indexOf($scope.gid)>=0){
               redLines.push(k);
            }
            if (row.text.indexOf('<cname>')>=0){
              descLines.push(k);
            }
             k++;
         });
         $(args).each(function(i,j){
           $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'highlight-color' } );
         });
         $(redLines).each(function(i,j){
           $scope._editor.getDoc().markText({line:j,ch:0} , {line:j,ch:100} ,{ className:'red-line-color' } );
         });



         if (redLines.length>0){
              $scope._editor.getDoc().setCursor({
                  line: redLines[0] + 30,
                  ch: 0
              });
         }
     }

     $scope.selectFunction = function(row,vals){
            gApp.selectFunction($scope,row,vals);
     }

     $scope.elementList = function(){

       $scope.elements =[];
        $($scope.selectedPages).each(function(i,c){
             var pgs = _.filter(cooConfig.allpage,function(n){ return n.ID ==parseInt(c) || n.parentId == parseInt(c) });

             $(pgs).each(function(p,q){

               var s1= g.page_pats(parseInt(q.ID));
               var orow = {label:q.UIname,children:[]};
               $(s1).each(function(s,t){
                   var tps = _.find(cooConfig.pTypes,function(n){return n.id==t.pTypeId});
                   if (tps){
                      orow.children.push({label: t.pName + " - " + tps.name,value: "__c" + t.ID.toString() });
                   }

               });
               $scope.elements.push(orow);




             });



        });


     }

     $scope.selectElementChange=function(c){

        var  pat = _.find(cooConfig.allpattern,function(n){ return n.ID.toString()==c.value  });
        console.log(pat);
        if (pat)
         {

             c.formatType = "function.columnFormat." +  pat.pTypeId.toString();
             c.formatValue = "";
             if (c.functionSource){
               var arr = _.find(c.functionSource[0].children ,function(n){  return n.type == c.formatType });
               if (arr) c.formatValue = arr.value;
             }
         }
         console.log(c);

         $scope.$$phase || $scope.$apply();

          $timeout(function(){
             $('.ui-chosen2').trigger("chosen:updated");
          },500);



        //ui-chosen

        console.log($scope.componentProperties);
     }


     $scope.selectComponent = function(row,vals){
           gApp.selectComponent2($scope,row,vals);
     }

     $scope.fullCode =function(){


          var modalInstance = $modal.open({
              templateUrl: 'tpl/admin/full_code.html?'+cooConfig.configObj.version,
              controller: 'admin_full_code_modal_instance_ctrl',
              size: 'lg',
              resolve:
                    g.load([],
                    function(){},
                    {
                      row: function(){ return $scope.code},
                      mode: function(){ return '' }
                    }
                   )

            });



             modalInstance.result.then(function (row) {

                console.log(row);


              }, function () {
                         //$log.info('Modal dismissed at: ' + new Date());
              });
       }


       $scope.css_modal =function(c ){

        var pageId =1;

        var modalInstance = $modal.open({
             templateUrl: 'tpl/admin/css_modal.html?'+cooConfig.configObj.version,
             controller: 'admin_css_modal_instance_ctrl',
             size: 'lg',
             resolve:
                   g.load([],
                   function(){},
                   {
                     pageId: function(){ return pageId}
                   }
                  )

           });

           modalInstance.result.then(function (row) {


               c.value += " " + row.__c80.replace(/^\./ig,'');





           }, function () {
            //$log.info('Modal dismissed at: ' + new Date());
           });


       }


       $scope.function_modal =function( ){

        var pageId =1;
        var modalInstance = $modal.open({
             templateUrl: 'tpl/admin/function_modal.html?'+cooConfig.configObj.version,
             controller: 'admin_function_modal_instance_ctrl',
             size: 'lg',
             resolve:
                   g.load([],
                   function(){},
                   {
                     pageId: function(){ return pageId},
                     modal_lsc : function(){ return [] }
                   }
                  )
           });

           modalInstance.result.then(function (row) {

             $scope.selectFunction(row,[]);

           }, function () {
            //$log.info('Modal dismissed at: ' + new Date());
           });
       }


     $scope.component_modal =function( ){

      var pageId =1;

      var modalInstance = $modal.open({
           templateUrl: 'tpl/admin/component_modal.html?'+cooConfig.configObj.version,
           controller: 'admin_component_modal_instance_ctrl',
           size: 'lg',
           resolve:
                 g.load([],
                 function(){},
                 {
                   pageId: function(){ return pageId},
                   modal_lsc: function() { return []}
                 }
                )

         });

         modalInstance.result.then(function (row) {



           $scope.selectComponent(row,[]);








         }, function () {
          //$log.info('Modal dismissed at: ' + new Date());
         });


     }




});

app.controller('adminapppage', function ($rootScope, $scope, $location, $sce,$filter,  cooConfig, g, rest   ) {

  $scope.lsc =[];
  $scope.startIndex =1;
  $scope.pageSize =12;
  $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];


  $scope.rawData=[];
  $scope.apppages =[];
  $scope.categoryId = 100037;
  $scope.pageId =100037;
  $scope.descPat = "__c369";
  $scope.pageIndex = 1;
  $scope.totalItems  =0;
  $scope.detailPageId = 100037;

  $scope.keywordId = 361;


  $scope.s_pats2_1 = [{"ID":368,"companyId":1000,"categoryId":37,"pName":"单页类型","pTypeId":2,"pOrder":1,"eName":"shanyeleixing","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:25.07","property":{},"element_property":{},"property_264":{},"property_267":{},"s_checked":true,"source":[{"label":"请选择","value":0,"$$hashKey":"object:933"},{"label":"综合首页","value":19,"$$hashKey":"object:934"},{"label":"综合分类","value":20,"$$hashKey":"object:935"},{"label":"列表","value":21,"$$hashKey":"object:936"},{"label":"详情","value":22,"$$hashKey":"object:937"},{"label":"表单","value":23,"$$hashKey":"object:938"},{"label":"固定功能","value":24,"$$hashKey":"object:939"},{"label":"其他","value":25,"$$hashKey":"object:940"}],"v":"0","new_order":0,"checked":true,"$$hashKey":"object:655"},{"ID":362,"companyId":1000,"categoryId":37,"pName":"单页编号","pTypeId":5,"pOrder":1,"eName":"shanyebianhao","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:24.987","property":{},"element_property":{"modal":1},"property_264":{"modal":1},"property_267":{"modal":1},"s_checked":true,"source":[],"new_order":2,"checked":true,"$$hashKey":"object:657"},{"ID":363,"companyId":1000,"categoryId":37,"pName":"单页版本号","pTypeId":3,"pOrder":1,"eName":"shanyebanbenhao","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:24.997","property":{},"element_property":{"modal":1},"property_264":{},"property_267":{"modal":1},"s_checked":true,"source":[],"v":"0","new_order":3,"checked":true,"$$hashKey":"object:658"},{"ID":364,"companyId":1000,"categoryId":37,"pName":"单页引用","pTypeId":5,"pOrder":1,"eName":"shanyeyinyong","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:25.01","property":{},"element_property":{"modal":1},"property_264":{},"property_267":{"modal":1},"s_checked":true,"source":[],"new_order":4,"checked":true,"$$hashKey":"object:659"},{"ID":365,"companyId":1000,"categoryId":37,"pName":"native代码","pTypeId":7,"pOrder":1,"eName":"nativedaima","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-10-21T21:58:05.19","property":{"type":"code"},"element_property":{"modal":1},"property_264":{},"property_267":{"modal":1},"s_checked":true,"source":[],"new_order":5,"checked":true,"$$hashKey":"object:660"},{"ID":366,"companyId":1000,"categoryId":37,"pName":"小程序代码","pTypeId":7,"pOrder":1,"eName":"xiaochengxudaima","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-10-21T21:58:05.193","property":{"type":"code"},"element_property":{"modal":1},"property_264":{},"property_267":{"modal":1},"s_checked":true,"source":[],"new_order":6,"checked":true,"$$hashKey":"object:661"},{"ID":367,"companyId":1000,"categoryId":37,"pName":"样式属性","pTypeId":7,"pOrder":1,"eName":"yangshishuxing","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-10-21T21:58:05.197","property":{"type":"code"},"element_property":{"modal":1},"property_264":{},"property_267":{"modal":1},"s_checked":true,"source":[],"new_order":7,"checked":true,"$$hashKey":"object:662"},{"ID":361,"companyId":1000,"categoryId":37,"pName":"单页名称","pTypeId":5,"pOrder":1,"eName":"shanyemingcheng","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:24.973","property":{},"element_property":{"modal":1},"property_264":{"modal":1},"property_267":{"modal":1},"s_checked":true,"source":[],"new_order":8,"checked":true,"$$hashKey":"object:663"},{"ID":369,"companyId":1000,"categoryId":37,"pName":"单页描述","pTypeId":7,"pOrder":1,"eName":"shanyemiaoshu","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-10-21T21:58:05.2","property":{},"element_property":{},"property_264":{},"property_267":{},"s_checked":true,"source":[],"new_order":9,"checked":true,"$$hashKey":"object:664"},{"ID":373,"companyId":1000,"categoryId":37,"pName":"后台方法","pTypeId":5,"pOrder":1,"eName":"houtaifangfa","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:25.133","property":{},"element_property":{},"property_264":{},"property_267":{},"s_checked":true,"source":[],"new_order":13,"checked":true,"$$hashKey":"object:668"},{"ID":374,"companyId":1000,"categoryId":37,"pName":"英文命名空间","pTypeId":5,"pOrder":1,"eName":"yingwenmingmingkongjian","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:25.147","property":{},"element_property":{},"property_264":{"modal":1},"property_267":{},"s_checked":true,"source":[],"new_order":14,"checked":true,"$$hashKey":"object:669"},{"ID":375,"companyId":1000,"categoryId":37,"pName":"中文命名空间","pTypeId":5,"pOrder":1,"eName":"zhongwenmingmingkongjian","validator":"","required":false,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:30:25.16","property":{},"element_property":{},"property_264":{"modal":1},"property_267":{},"s_checked":true,"source":[],"new_order":15,"checked":true,"$$hashKey":"object:670"},{"ID":403,"companyId":1000,"categoryId":43,"pName":"路由名称","pTypeId":5,"pOrder":1,"eName":"luyoumingcheng","validator":"","required":true,"disabled":false,"isUnique":false,"isSortStatistic":-1,"t":"2018-08-28T17:33:26.47","property":{},"element_property":{},"property_264":{},"property_267":{},"s_checked":true,"source":[],"new_order":16,"checked":true,"$$hashKey":"object:671"}];


  $scope.s_pats2_2 = [{"ID":233,"categoryId":5,"pName":"中文命名空间","pTypeId":5,"pOrder":1,"eName":"zhongwenmingmingkongjian","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"source":[],"new_order":19},{"ID":232,"categoryId":5,"pName":"英文命名空间","pTypeId":5,"pOrder":1,"eName":"yingwenmingmingkongjian","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"source":[],"new_order":18},{"ID":37,"categoryId":5,"pName":"单页名称","pTypeId":5,"pOrder":1,"eName":"danyemingchen","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"source":[],"new_order":10},{"ID":38,"categoryId":5,"pName":"单页编号","pTypeId":5,"pOrder":1,"eName":"danyebianhao","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"source":[],"new_order":2},{"ID":47,"categoryId":5,"pName":"单页类型","pTypeId":2,"pOrder":1,"eName":"danyeleixing","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"source":[{"label":"请选择","value":0},{"label":"综合首页","value":19},{"label":"综合分类","value":20},{"label":"列表","value":21},{"label":"详情","value":22},{"label":"表单","value":23},{"label":"固定功能","value":24},{"label":"其他","value":25}],"v":"0","new_order":11},{"ID":48,"categoryId":5,"pName":"单页描述","pTypeId":7,"pOrder":1,"eName":"danyemiaoshu","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"source":[],"new_order":12}];


  $scope.s_pats2= $scope.s_pats2_1;
  $scope.text_labelx = "361";

  $scope.searchSwitch = function(ix){
     if (ix==1){
       $scope.s_pats2= $scope.s_pats2_1;
       $scope.text_labelx = "361";
       $scope.categoryId = 100037;
       $scope.pageId = 100037;
       $scope.descPat = "__c369";
       $scope.detailPageId = 76;
       $scope.keywordId  =361;
       $scope.lsc =[];
       $scope.startIndex=1;
       $scope.renderList();
     }
     else {
       $scope.s_pats2= $scope.s_pats2_2;
       $scope.text_labelx = "233";
       $scope.categoryId = 5;
       $scope.pageId =35;
       $scope.descPat = "__c48";
       $scope.detailPageId = 34;
       $scope.keywordId  =37;
       $scope.lsc =[];
       $scope.startIndex=1;
       $scope.renderList();

     }
  }

  $scope.select_clear  = function(){
    $scope.lsc =[];
    $scope.startIndex=1;
    $scope.renderList();
  }


  $scope.renderList = function(){


      g.show_ajax();
      $scope.apppages=[];
      $scope.rawData= [];

     var  etor ={"companyId":1000,"cid":$scope.categoryId,"id": $scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
     url : "https://center.mvcx.net/list/ajxlist2" , method:'ajxlist2'  }   ;



     var etorPage = { pageIndex:$scope.startIndex,pageSize:$scope.pageSize,pathType:3 };

      $.when(rest.remote_data(etorPage ,'gateway/myfiles')).done(function(ret){

           console.log(ret);
           $(ret.data).each(function(i,j){
             $scope.rawData.push(j);
               j.url = j.__c216?j.__c216.FilePath:'https://file5.mvcx.net/files/1000/default.png'   ;
               j.url =$sce.trustAsResourceUrl(j.url);

               //$sce.trustAsResourceUrl
               j.name= j.name;
               j.name2 = j.path.replace(/nodeDirectory\\src\\pages\\/ig,'');
               j.namespace = j.path.replace(/\\/ig,'.');
               j.namespace2 = j.namespace.replace(/nodeDirectory.src.pages./ig,'');

               j.itemId =0;
               $scope.apppages.push(j);
           });
           $scope.totalItems  =    ret.cc;
           $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;
           $scope.$$phase || $scope.$apply();
           g.hide_ajax();

      });



     return false;




     var url = "gateway/module";
     if ($scope.categoryId==5){
        url = "proxy";
     }

       $.when(rest.remote_data(etor,url)).done(function(retx2){
             var retx =retx2.listItems;

              if ($scope.categoryId!=5){

                    $(retx).each(function(i,j){
                      $scope.rawData.push(j);
                        j.url = j.c370?j.c370:'https://file5.mvcx.net/files/1000/default.png'   ;
                        j.url =$sce.trustAsResourceUrl(j.url);

                        //$sce.trustAsResourceUrl
                        j.name= j.c361;
                        j.name2 = j.c362;
                        j.namespace = j.c375;
                        j.namespace2 = j.c374;
                        j.itemId = j.ID;
                        $scope.apppages.push(j);
                    });
                    $scope.totalItems  = retx2.itemCount ; //todo
                    $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;
                    $scope.$$phase || $scope.$apply();
                    g.hide_ajax();

              }
              else{
                   var ex = JSON.parse(retx.data);

                    $(ex.data).each(function(i,j){
                      $scope.rawData.push(j);
                        j.url = j.__c216?j.__c216.FilePath:'https://file5.mvcx.net/files/1000/default.png'   ;
                        j.url =$sce.trustAsResourceUrl(j.url);

                        //$sce.trustAsResourceUrl
                        j.name= j.__c37;
                        j.name2 = j.__c38;
                        j.namespace = j.__c233;
                        j.namespace2 = j.__c232;
                        j.itemId = j.__c36;
                        $scope.apppages.push(j);
                    });
                    $scope.totalItems  =     g.list_total(ex);
                    $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;
                    $scope.$$phase || $scope.$apply();
                    g.hide_ajax();



              }




       });






  };


  $scope.renderList();



    $scope.quick_nav2 =function(pat,item)
    {
       pat.v = item.value;
       $scope.search();
    }

    $scope.text_change = function(labelx,labely,vx,vy){
      var pat = _.find($scope.s_pats2,function(n){ return n.ID.toString()== labelx });
      if (pat)
      {
          pat.v = vx;
         $($scope.s_pats2).each(function(i,j){
            if (j.ID!=pat.ID && (j.pTypeId==5||j.pTypeId==7) ) j.v ="";
         });
      }
      $scope.search();
    }



    $scope.selectPage  =function(p)
    {
          if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
          {
            $scope.startIndex = $scope.startIndex+p;
             $scope.renderList();
          }
    };

    $scope.pageSizeChange = function (p) {
        $scope.pageSize = p;
        $scope.startIndex = 1;
        $scope.renderList();
    };

    $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }
      $($scope.s_pats2).each(function(i,j){
          if ((j.pTypeId==5 || j.pTypeId ==7 ) && j.v ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":5,"operation":6})
          }
          if ((j.pTypeId==2 || j.pTypeId ==3 ) && j.v && j.v !=="0" ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":j.pTypeId,"operation":1})
          }
      });



      $scope.renderList();
    }




});




app.controller('adminappcomponent', function ($rootScope,$timeout, $scope, $location, $sce,$filter,  cooConfig, g, rest   ) {

  $scope.lsc =[];
  $scope.startIndex =1;
  $scope.pageSize =10;
  $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];


  $scope.rawData=[];
  $scope.apppages =[];
  $scope.categoryId = 6;
  $scope.pageId =42;
  $scope.descPat = "__c62";
  $scope.pageIndex = 1;
  $scope.totalItems  =0;
  $scope.keywordId = 52;
  $scope.detailPageId = 41;

  $scope.s_pats2 = [{"ID":225,"categoryId":6,"pName":"中文命名空间","pTypeId":5,"pOrder":1,"eName":"zhongwenmingmingkongjian","validator":"","required":true,"isUnique":false,"property":{},"element_property":{},"property_41":{"edit_top":1},"source":[],"new_order":15},{"ID":224,"categoryId":6,"pName":"英文命名空间","pTypeId":5,"pOrder":1,"eName":"yingwenmingmingkongjian","validator":"","required":true,"isUnique":false,"property":{},"element_property":{},"property_41":{"edit_top":1,"group":1},"source":[],"new_order":14},{"ID":52,"categoryId":6,"pName":"组件名称","pTypeId":5,"pOrder":1,"eName":"zujianmingchen","validator":"","required":true,"isUnique":false,"property":{},"element_property":{},"property_41":{"edit_top":1},"source":[],"new_order":8},{"ID":53,"categoryId":6,"pName":"组件编号","pTypeId":5,"pOrder":1,"eName":"zujianbianhao","validator":"","required":true,"isUnique":false,"property":{},"element_property":{},"property_41":{"edit_top":1},"source":[],"new_order":2},{"ID":61,"categoryId":6,"pName":"组件类型","pTypeId":2,"pOrder":1,"eName":"zujianleixing","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"property_41":{"edit_top":1},"source":[{"label":"请选择","value":0},{"label":"搜索组件","value":26},{"label":"展示组件","value":27},{"label":"导航组件","value":28},{"label":"按钮组件","value":29},{"label":"其他组件","value":30}],"v":"0","new_order":10},{"ID":62,"categoryId":6,"pName":"组件描述","pTypeId":7,"pOrder":1,"eName":"zujianmiaoshu","validator":"","required":false,"isUnique":false,"property":{},"element_property":{},"property_41":{"edit_bottom":1,"group":1},"source":[],"new_order":11}];

  $scope.text_labelx = "225";



  $scope.quick_nav2 =function(pat,item)
  {
     pat.v = item.value;
     $scope.search();
  }

  $scope.text_change = function(labelx,labely,vx,vy){
    var pat = _.find($scope.s_pats2,function(n){ return n.ID.toString()== labelx });

    if (pat)
    {
        pat.v = vx;
       $($scope.s_pats2).each(function(i,j){
          if (j.ID!=pat.ID && (j.pTypeId==5||j.pTypeId==7) ) j.v ="";
       });
    }

    $scope.search();

  }



  $scope.selectPage  =function(p)
  {
        if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
        {
          $scope.startIndex = $scope.startIndex+p;
           $scope.renderList();
        }
  };

  $scope.pageSizeChange = function (p) {
      $scope.pageSize = p;
      $scope.startIndex = 1;
      $scope.renderList();
  };

  $scope.search=function(){
    $scope.lsc =[];
    $scope.startIndex =1;
    if ($scope.keyword){
      $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
    }
    $($scope.s_pats2).each(function(i,j){
        if ((j.pTypeId==5 || j.pTypeId ==7 ) && j.v ){
            $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":5,"operation":6})
        }
    });
    $scope.renderList();
  }



  $scope.renderList = function(){

    var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
     url : "https://center.mvcx.net/list/ajxlist2"   }   ;

     g.show_ajax();
     $scope.appcomponents=[];
     $scope.rawData= [];
     $.when(rest.remote_data(etor,"proxy")).done(function(retx){

         var ex = JSON.parse(retx.data);
     //    $scope.appfunctions = ex.data;
         $(ex.data).each(function(i,j){
             $scope.rawData.push(j);
             switch ($scope.pageId) {
               case 42:
                  j.url = j.__c236.FilePath ;
                  j.name= j.__c52;
                  j.name2 = j.__c53;
                  j.namespace = j.__c225;
                  j.namespace2 = j.__c224;
                  j.itemId = j.__c51;
                  break;
               default:

             }
          //.replace(/\/100\//ig,'/');
             $scope.appcomponents.push(j);
         });
         g.hide_ajax();

         $scope.totalItems  = g.list_total(ex);

         $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems / $scope.pageSize):  ($scope.totalItems / $scope.pageSize) +1 ;

         // $scope.numPages = parseInt($scope.maxPages);
         // console.log($scope.numPages);

         $scope.$$phase || $scope.$apply();


     });

  };


  $scope.renderList();













});



app.controller('adminappstyleedit', function ($rootScope, $scope, $stateParams, $location, $sce,$filter, $state, cooConfig, g, rest   ) {

   $scope.right_panel =true;
   $('.modal-backdrop').show();
   $('.panel-content').css('height', ($('.right-content-body')[0].scrollHeight ).toString() +'px');
   $scope.data ={};

   $scope.editorOptions = {
       lineNumbers: true,
       matchBrackets: true,
       styleActiveLine: true,
       theme:"ambiance"
   };

   $scope.editPageId = $stateParams.editPageId;
   $scope.itemId = $stateParams.itemId;
   $scope.elements =[];

   $scope.pats =[{"ID":235,"categoryId":13,"pName":"中文命名空间","pTypeId":5,"pOrder":1,"eName":"zhongwenmingmingkongjian","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":234,"categoryId":13,"pName":"英文命名空间","pTypeId":5,"pOrder":1,"eName":"yingwenmingmingkongjian","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":141,"categoryId":13,"pName":"样式名称B","pTypeId":5,"pOrder":1,"eName":"yangshimingchenB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":143,"categoryId":13,"pName":"样式编号B","pTypeId":5,"pOrder":1,"eName":"yangshibianhaoB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":144,"categoryId":13,"pName":"样式版本号B","pTypeId":3,"pOrder":1,"eName":"yangshibanbenhaoB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":146,"categoryId":13,"pName":"native代码B","pTypeId":7,"pOrder":1,"eName":"nativedaimaB","validator":"","required":false,"isUnique":false,"property":{"type":"code"},"element_property":{}},{"ID":150,"categoryId":13,"pName":"样式描述B","pTypeId":7,"pOrder":1,"eName":"yangshimiaoshuB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":140,"categoryId":13,"pName":"indexId","pTypeId":16,"pOrder":1,"eName":"indexId","validator":"^\\d+$","required":false,"disabled":null,"isUnique":null,"isSortStatistic":null,"property":{},"element_property":{}}] ;


   $scope.fetchDetail = function(){
      $scope.elements=[];
      if ($scope.itemId){

        var  etor ={pageId: $scope.editPageId,itemId:$scope.itemId ,
         url : "https://center.mvcx.net/detail/ajx2"   }   ;

         g.show_ajax();
         $scope.data=[];
         $.when(rest.remote_data(etor,"proxy")).done(function(retx){

            var obj = JSON.parse(retx.data);
            $scope.data = obj?obj.data:{};

            $($scope.pats).each(function(i,j){
              var  vv = g.prepareVal($scope.data, j);
              j.placeholder = j.pName;
               $scope.elements.push({
                 p:j,
                 val: vv,
                 v: vv,
               });

            });
          //  console.log($scope.elements);
            $scope.$$phase || $scope.$apply();
            g.hide_ajax();

         });

      }
      else{

          $($scope.pats).each(function(i,j){
            var  vv = g.prepareVal({}, j);
            j.placeholder = j.pName;
             $scope.elements.push({
               p:j,
               val: vv,
               v: vv,
             });
          });
      }


   }

   $scope.fetchDetail();

   $scope.mclick = function(element){
         element['e']  ="e";
    };

   $scope.cancel = function(){
        $('.modal-backdrop').hide();
        $state.go("app.admin.appstyle" );
   };



   $scope.doSubmit = function () {

         var RetArray =[];
         var RArray =[];

          var r_main = _.filter($scope.elements,function(n){ return n.e=='e' || n.p.pTypeId==16 ; });

          console.log(r_main);
          r_main = g.row_date(r_main);
          $(r_main).each(function(i,j){
              var vvv= j.val;
              if (j.p.pTypeId==7)
              {
            //    vvv=$scope.convertToEntities(vvv);
              }
              var o = { _Key: '__c' + j.p.ID , _Value: vvv };
              RetArray.push(o);
          });


           console.log(RetArray);


           var d1 = JSON.stringify(RetArray);
           var d2 = JSON.stringify(RArray);

           var etor = {
               jsonStr: d1,
               relatedSTR: d2,
               pageId: $scope.editPageId,
               itemId: 0,//  $scope.itemId,
               url:"https://center.mvcx.net/e/createupdate"
           };



            $('#submitEdit').prop('disabled',true);
            $.when(rest.remote_data(etor,"proxy")).done(function(data){

               $('#submitEdit').prop('disabled',false);
               $scope.renderList();
               $scope.cancel();

               $scope.$apply();
            });


     };
});


app.controller('adminapppageview', function ($rootScope,$modal, $scope, $stateParams, $location, $sce,$filter, $state, cooConfig, g, rest   ) {

   $scope.right_panel =true;
   $('.modal-backdrop').show();
   // $('.panel-content').css('height', ($('.right-content-body')[0].scrollHeight +50 ).toString() +'px');
   $('.panel-content').css('height',"auto");
   $scope.data = {};
   $scope.rawData =[];

   $scope.cancel = function(){
        $('.modal-backdrop').hide();
        $state.go("app.admin.apppage" );
   };

   $scope.detailPageId = $stateParams.detailPageId;
   $scope.itemId = $stateParams.itemId;

   $scope.fetchDetail = function(){

        var  etor ={pageId: $scope.detailPageId,itemId:$scope.itemId ,
         url : "https://center.mvcx.net/detail/ajx2"   }   ;

         g.show_ajax();
         $scope.data={};
         $scope.rawData ={};
         $.when(rest.remote_data(etor,"proxy")).done(function(retx){

            var obj = JSON.parse(retx.data);
            $scope.rawData =JSON.parse(retx.data).data;

            var  enCod = obj.data.__c41.replace(/</ig,'&lt;');
            enCod = enCod.replace(/>/ig,'&gt;');
            enCod = enCod.replace(/&/ig,'&amp;');

            obj.data.__c41 = obj.data.__c41 ;
            obj.data.__c45 = $sce.trustAsHtml(obj.data.__c45 ) ;
            obj.data.__c48 = $sce.trustAsHtml(obj.data.__c48 ) ;
            obj.data.urls = [] ;

            obj.data.urls.push({
              rawUrl :g.fixImagePath(obj.data.__c216.FilePath),
              url :obj.data.__c216.FilePath
            } );

            $(obj.data.__c217).each(function(i,j){
                  obj.data.urls.push({
                    rawUrl :g.fixImagePath(j.FilePath),
                    url :j.FilePath
                  } );
            });


          //  obj.data.__c216.FilePath = obj.data.__c216.FilePath? obj.data.__c216.FilePath.replace(/\/100\//ig,"\/"):'' ;





            $scope.data = obj.data;







          //  console.log($scope.elements);

            $scope.$$phase || $scope.$apply();
            g.hide_ajax();

         });
    };

    $scope.fetchDetail();

    $scope.import_page_modal =function(c){

     var pageId =1;

     var modalInstance = $modal.open({
          templateUrl: 'tpl/admin/import_page_modal.html?'+cooConfig.configObj.version,
          controller: 'admin_import_page_modal_instance_ctrl',
          size: 'sm',
          resolve:
                g.load([],
                function(){},
                {
                  pageId: function(){ return pageId}
                }
               )

        });

        modalInstance.result.then(function (row) {




                  var appcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == "appIdentity" });
                  if (!appcfg)  {
                    g.modal1("未配置应用编号！");
                    return false   ;
                  } ;

                  var fc = $scope.rawData;

                  console.log(fc);

                 var arr =[
                   {"_Key":"__c361","_Value": fc.__c37 },
                   //{"_Key":"__c111","_Value": appcfg.configuration_value },
                   {"_Key":"__c362","_Value":row},
                   {"_Key":"__c363","_Value":fc.__c39},
                   {"_Key":"__c364","_Value":fc.__c40},
                   {"_Key":"__c365","_Value":fc.__c41},//代码
              //     {"_Key":"__c116","_Value":fc.__c42},
                   {"_Key":"__c366","_Value":fc.__c43},
                //   {"_Key":"__c118","_Value":fc.__c44},//配置 [{"keyword" : "按钮名称14","stype":"string","type":"data","ftype":"input","value":""}  ]
                   {"_Key":"__c367","_Value":fc.__c45},
              //     {"_Key":"__c136","_Value":fc.__c75},
                   {"_Key":"__c368","_Value":fc.__c47.ID},
                   {"_Key":"__c369","_Value":fc.__c48},

                   {"_Key":"__c373","_Value":JSON.stringify(fc.__c228) },
                   {"_Key":"__c374","_Value":fc.__c232},
                   {"_Key":"__c375","_Value":fc.__c233}];




                   var etor ={
                     itemId: 0,
                     jsonStr : JSON.stringify(arr),
                     pageId: 100037,
                     relatedSTR:"[]",
                     url:"https://center.mvcx.net/e/createupdate",
                     method : "createUpdate"
                   };

                   // console.log(etor);
                   // return false;

                   g.show_ajax();

                    $.when(rest.remote_data(etor,"gateway/module")).done(function(retx){
                      console.log(retx);
                      //    console.log(fc);
                          g.modal1("复制成功!");
                          g.hide_ajax();
                          $scope.cancel();
                    });





        }, function () {
         //$log.info('Modal dismissed at: ' + new Date());
        });


    }

 });



app.controller('adminappcomponentview', function ($rootScope, $scope, $stateParams, $location, $sce,$filter, $state, cooConfig, g, rest   ) {

   $scope.right_panel =true;
   $('.modal-backdrop').show();
   // $('.panel-content').css('height', ($('.right-content-body')[0].scrollHeight +50 ).toString() +'px');
   $('.panel-content').css('height',"auto");
   $scope.data = {};

   $scope.cancel = function(){
        $('.modal-backdrop').hide();
        $state.go("app.admin.appcomponent" );
   };

   $scope.detailPageId = $stateParams.detailPageId;
   $scope.itemId = $stateParams.itemId;

   $scope.fetchDetail = function(){

        var  etor ={pageId: $scope.detailPageId,itemId:$scope.itemId ,
         url : "https://center.mvcx.net/detail/ajx2"   }   ;

         g.show_ajax();
         $scope.data=[];
         $.when(rest.remote_data(etor,"proxy")).done(function(retx){

            var obj = JSON.parse(retx.data);

            obj.data.__c56 = $sce.trustAsHtml(obj.data.__c56 ) ;
            obj.data.__c59 = $sce.trustAsHtml(obj.data.__c59 ) ;
            obj.data.__c62 = $sce.trustAsHtml(obj.data.__c62 ) ;
            obj.data.url = obj.data.__c236.FilePath ;
            obj.data.__c236.FilePath = obj.data.__c236.FilePath? obj.data.__c236.FilePath.replace(/\/100\//ig,"\/"):'' ;
            $scope.data = obj.data;

            console.log($scope.data);





          //  console.log($scope.elements);

            $scope.$$phase || $scope.$apply();
            g.hide_ajax();

         });
    };

    $scope.fetchDetail();



 });


app.controller('adminappfunctionedit', function ($rootScope, $scope, $stateParams, $location, $sce,$filter, $state, cooConfig, g, rest   ) {

   $scope.right_panel =true;
   $('.modal-backdrop').show();
   $('.panel-content').css('height', ($('.right-content-body')[0].scrollHeight ).toString() +'px');
   $scope.data ={};

   $scope.editorOptions = {
       lineNumbers: true,
       matchBrackets: true,
       styleActiveLine: true,
       theme:"ambiance"
   };

   $scope.editPageId = $stateParams.editPageId;
   $scope.itemId = $stateParams.itemId;
   $scope.elements =[];

   $scope.pats =[{"ID":221,"categoryId":12,"pName":"中文命名空间","pTypeId":5,"pOrder":1,"eName":"zhongwenmingmingkongjian","validator":"","required":true,"isUnique":false,"property":{},"element_property":{}},{"ID":220,"categoryId":12,"pName":"英文命名空间","pTypeId":5,"pOrder":1,"eName":"yingwenmingmingkongjian","validator":"","required":true,"isUnique":false,"property":{},"element_property":{}},{"ID":126,"categoryId":12,"pName":"函数名称B","pTypeId":5,"pOrder":1,"eName":"hanshumingchenB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":128,"categoryId":12,"pName":"函数编号B","pTypeId":5,"pOrder":1,"eName":"hanshubianhaoB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":129,"categoryId":12,"pName":"函数版本号B","pTypeId":3,"pOrder":1,"eName":"hanshubanbenhaoB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":130,"categoryId":12,"pName":"函数引用B","pTypeId":5,"pOrder":1,"eName":"hanshuyinyongB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}},{"ID":131,"categoryId":12,"pName":"native代码B","pTypeId":7,"pOrder":1,"eName":"nativedaimaB","validator":"","required":false,"isUnique":false,"property":{"type":"code"},"element_property":{}},{"ID":134,"categoryId":12,"pName":"可配置属性B","pTypeId":7,"pOrder":1,"eName":"kepeizhizhuxingB","validator":"","required":false,"isUnique":false,"property":{"type":"code"},"element_property":{}},{"ID":137,"categoryId":12,"pName":"函数描述B","pTypeId":7,"pOrder":1,"eName":"hanshumiaoshuB","validator":"","required":false,"isUnique":false,"property":{},"element_property":{}} ,{"ID":125,"categoryId":12,"pName":"indexId","pTypeId":16,"pOrder":1,"eName":"indexId","validator":"^\\d+$","required":false,"disabled":null,"isUnique":null,"isSortStatistic":null,"property":{},"element_property":{}}] ;






   $scope.fetchDetail = function(){
      $scope.elements=[];
      if ($scope.itemId){

        var  etor ={pageId: $scope.editPageId,itemId:$scope.itemId ,
         url : "https://center.mvcx.net/detail/ajx2"   }   ;

         g.show_ajax();
         $scope.data=[];
         $.when(rest.remote_data(etor,"proxy")).done(function(retx){

            var obj = JSON.parse(retx.data);
            $scope.data = obj?obj.data:{};

            $($scope.pats).each(function(i,j){

              var  vv = g.prepareVal($scope.data, j);
              j.placeholder = j.pName;

               $scope.elements.push({
                 p:j,
                 val: vv,
                 v: vv,
               });



            });

          //  console.log($scope.elements);

            $scope.$$phase || $scope.$apply();
            g.hide_ajax();

         });

      }
      else{

          $($scope.pats).each(function(i,j){
            var  vv = g.prepareVal({}, j);
            j.placeholder = j.pName;
             $scope.elements.push({
               p:j,
               val: vv,
               v: vv,
             });
          });
      }


   }

   $scope.fetchDetail();

   $scope.mclick = function(element){
         element['e']  ="e";
    };

   $scope.cancel = function(){
        $('.modal-backdrop').hide();
        $state.go("app.admin.appfunction" );
   };



   $scope.doSubmit = function () {

         var RetArray =[];
         var RArray =[];

          var r_main = _.filter($scope.elements,function(n){ return n.e=='e' || n.p.pTypeId==16 ; });

          console.log(r_main);
          r_main = g.row_date(r_main);
          $(r_main).each(function(i,j){
              var vvv= j.val;
              if (j.p.pTypeId==7)
              {
            //    vvv=$scope.convertToEntities(vvv);
              }
              var o = { _Key: '__c' + j.p.ID , _Value: vvv };
              RetArray.push(o);
          });


           console.log(RetArray);


           var d1 = JSON.stringify(RetArray);
           var d2 = JSON.stringify(RArray);

           var etor = {
               jsonStr: d1,
               relatedSTR: d2,
               pageId: $scope.editPageId,
               itemId: 0,//  $scope.itemId,
               url:"https://center.mvcx.net/e/createupdate"
           };



            $('#submitEdit').prop('disabled',true);
            $.when(rest.remote_data(etor,"proxy")).done(function(data){

               $('#submitEdit').prop('disabled',false);
               $scope.renderList();
               $scope.cancel();

               $scope.$apply();
            });


     };
});


app.controller('adminappstyle', function ($rootScope, $scope, $location, $sce,$filter,  cooConfig, g, rest   ) {

     $scope.keyword='';
     $scope.lsc =[];
     $scope.startIndex =1;
     $scope.pageSize =10;
     $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];


     $scope.rawData=[];
     $scope.appstyles =[];
     $scope.categoryId = 13;
     $scope.pageId =91;
     $scope.descPat = "__c150";
     $scope.keywordId = 141;
     $scope.pageIndex = 1;
     $scope.totalItems2 =[];
      $scope.totalItems = 0;

     $scope.renderList = function(){

       var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
        url : "https://center.mvcx.net/list/ajxlist2"   }   ;

        g.show_ajax();
        $scope.appstyles=[];
        $.when(rest.remote_data(etor,"proxy")).done(function(retx){

            var ex = JSON.parse(retx.data);
        //    $scope.appfunctions = ex.data;
            $(ex.data).each(function(i,j){
                $scope.rawData.push(j);
                j[$scope.descPat] = j[$scope.descPat];
                $scope.appstyles.push(j);
              //  console.log(j);
            });
            g.hide_ajax();

            $scope.totalItems2[$scope.pageIndex] = g.list_total(ex);
            $scope.totalItems = $scope.totalItems2[$scope.pageIndex];
            $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems/ $scope.pageSize):  ($scope.totalItems/ $scope.pageSize) +1 ;

            $scope.$$phase || $scope.$apply();


        });

     };

     $scope.selectPage  =function(p)
     {
           if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
           {
             $scope.startIndex = $scope.startIndex+p;
              $scope.renderList();
           }
     };
     $scope.pageSizeChange = function (p) {
         $scope.pageSize = p;
         $scope.startIndex = 1;
         $scope.renderList();
     };

     $scope.renderList();

     $scope.search1 = function(){
       $scope.categoryId = 13;
       $scope.pageId =91;
       $scope.descPat = "__c150";
       $scope.keywordId = 141;
       $scope.startIndex =1;
       $scope.pageIndex =1;
       $scope.renderList();

        console.log('search1');
     }

    $scope.search2 = function(){
      $scope.categoryId = 8;
      $scope.pageId =56;
      $scope.descPat = "__c88";
       $scope.keywordId = 80;
      $scope.startIndex =1;
      $scope.pageIndex =2;
      $scope.renderList();
       console.log('search2');
    }




    $scope.importStyle = function(fc){



      var appcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == "appIdentity" });
      if (!appcfg)  { return false      } ;



     var arr =[
       {"_Key":"__c141","_Value":fc.__c80},
       {"_Key":"__c142","_Value": appcfg.configuration_value },
       {"_Key":"__c143","_Value":fc.__c81},
       {"_Key":"__c144","_Value":fc.__c82},
       {"_Key":"__c146","_Value":fc.__c84},
       {"_Key":"__c150","_Value":fc.__c88},//代码

       {"_Key":"__c234","_Value":fc.__c230},
       {"_Key":"__c235","_Value":fc.__c231}];




       var etor ={
         itemId: 0,
         jsonStr : JSON.stringify(arr),
         pageId: 90,
         relatedSTR:"[]",
         url:"https://center.mvcx.net/e/createupdate"
       };

    //    console.log(etor);
    //    return false;

       g.show_ajax();

        $.when(rest.remote_data(etor,"proxy")).done(function(retx){
          //    console.log(fc);
              g.modal1("已引入!");
              g.hide_ajax();
        });


    }


    $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }

      $scope.renderList();

       console.log($scope.keyword);
    }

});






app.controller('adminappmarket', function ($rootScope, $scope, $location, $sce,$filter,  cooConfig, g, rest   ) {

     $scope.keyword='';
     $scope.lsc =[];
     $scope.startIndex =1;
     $scope.pageSize =10;
     $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];


     $scope.rawData=[];
     $scope.appfunctions =[];
     $scope.categoryId = 20;
     $scope.pageId =144;
     $scope.descPat = "__c260";
     $scope.keywordId = 259;
     $scope.pageIndex = 1;
      $scope.totalItems = 0;

     $scope.renderList = function(){

       var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
        url : "https://center.mvcx.net/list/ajxlist2"   }   ;

       var  etor_market ={"companyId":1000,"cid":100020,"id":100020,"lsc":[],"iindex":1,"isize": 100,
         url : "https://center.mvcx.net/list/ajxlist2" ,method :'ajxlist2'  }   ;

        g.show_ajax();
        $scope.appmarkets=[];
        $.when(rest.remote_data(etor,"proxy"),
          rest.remote_data(etor_market,"gateway/module")
      ).done(function(retx,rety){

            var ex = JSON.parse(retx.data);
        //    $scope.appfunctions = ex.data;
            $(ex.data).each(function(i,j){
                $scope.rawData.push(j);
                j[$scope.descPat] = j[$scope.descPat];
                j.expand =false;

                $scope.appmarkets.push(j);
              //  console.log(j);
            });
            g.hide_ajax();

            $scope.totalItems  = g.list_total(ex);

            $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems/ $scope.pageSize):  ($scope.totalItems/ $scope.pageSize) +1 ;

            $scope.$$phase || $scope.$apply();


        });

     };

     $scope.selectPage  =function(p)
     {
           if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
           {
             $scope.startIndex = $scope.startIndex+p;
              $scope.renderList();
           }
     };
     $scope.pageSizeChange = function (p) {
         $scope.pageSize = p;
         $scope.startIndex = 1;
         $scope.renderList();
     };

     $scope.module_expand2 = function(mk,c){

         var msc =[];
         msc.push({patternId: 359, val1: c.b_identity, pTypeId: 23, operation: 1});

         var  etor ={"companyId":1000,"cid":36,"id":256,"lsc": msc ,"iindex":1,"isize": 50,
          url : "https://center.mvcx.net/list/ajxlist2"   }   ;

          g.show_ajax();
          $.when(rest.remote_data(etor,"proxy")).done(function(retx){

             var ex = JSON.parse(retx.data);

             mk.list = ex.data;
             $scope.$$phase || $scope.$apply();
            g.hide_ajax();

          });

     };


     $scope.module_expand = function(mk){

               mk.expand= !mk.expand ;

              if (mk.expand){

                if (mk.__c435.ID==67){


                      var msc =[];
                      msc.push({patternId: 433, val1: mk.server_identity, pTypeId: 23, operation: 1});

                      var  etor ={"companyId":1000,"cid":48,"id":340,"lsc": msc ,"iindex":1,"isize": 50,
                       url : "https://center.mvcx.net/list/ajxlist2"   }   ;

                       g.show_ajax();
                       $.when(rest.remote_data(etor,"proxy")).done(function(retx){

                          var ex = JSON.parse(retx.data);
                          mk.sub = ex.data;
                          $scope.$$phase || $scope.$apply();
                         g.hide_ajax();

                       });
                }
                else{

                  var msc =[];
                  msc.push({patternId: 359, val1: mk.server_identity, pTypeId: 23, operation: 1});

                  var  etor ={"companyId":1000,"cid":36,"id":256,"lsc": msc ,"iindex":1,"isize": 50,
                   url : "https://center.mvcx.net/list/ajxlist2"   }   ;

                   g.show_ajax();
                   $.when(rest.remote_data(etor,"proxy")).done(function(retx){

                      var ex = JSON.parse(retx.data);

                      mk.list = ex.data;
                      $scope.$$phase || $scope.$apply();
                     g.hide_ajax();

                   });



                }



              }


     }


     $scope.renderList();

     $scope.search1 = function(){

     }









    $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }

      $scope.renderList();

       console.log($scope.keyword);
    }

});



app.controller('adminapptransaction', function ($rootScope, $scope, $location, $sce,$filter,  cooConfig, g, rest   ) {

     $scope.keyword='';
     $scope.lsc =[];
     $scope.startIndex =1;
     $scope.pageSize =10;
     $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];


     $scope.rawData=[];
     $scope.appfunctions =[];
     $scope.categoryId = 19;
     $scope.pageId =137;
     $scope.descPat = "__c251";
     $scope.keywordId = 240;
     $scope.pageIndex = 1;
      $scope.totalItems = 0;

     $scope.renderList = function(){

       var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
        url : "https://center.mvcx.net/list/ajxlist2"   }   ;

        g.show_ajax();
        $scope.apptransactions=[];
        $.when(rest.remote_data(etor,"proxy")).done(function(retx){

            var ex = JSON.parse(retx.data);
        //    $scope.appfunctions = ex.data;
            $(ex.data).each(function(i,j){
                $scope.rawData.push(j);
                j[$scope.descPat] = j[$scope.descPat];
                $scope.apptransactions.push(j);
              //  console.log(j);
            });
            g.hide_ajax();

            $scope.totalItems  = g.list_total(ex);

            $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems/ $scope.pageSize):  ($scope.totalItems/ $scope.pageSize) +1 ;

            $scope.$$phase || $scope.$apply();


        });

     };

     $scope.selectPage  =function(p)
     {
           if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
           {
             $scope.startIndex = $scope.startIndex+p;
              $scope.renderList();
           }
     };
     $scope.pageSizeChange = function (p) {
         $scope.pageSize = p;
         $scope.startIndex = 1;
         $scope.renderList();
     };

     $scope.renderList();

     $scope.search1 = function(){

     }









    $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }

      $scope.renderList();

       console.log($scope.keyword);
    }

});



app.controller('adminappfunction', function ($rootScope, $scope, $location, $sce,$filter,  cooConfig, g, rest   ) {

     $scope.keyword='';
     $scope.lsc =[];
     $scope.startIndex =1;
     $scope.pageSize =10;
     $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];


     $scope.rawData=[];
     $scope.appfunctions =[];
     $scope.categoryId = 12;
     $scope.pageId =84;
     $scope.descPat = "__c137";
     $scope.keywordId = 126;
     $scope.pageIndex = 1;
     $scope.totalItems2 =[];
      $scope.totalItems = 0;

     $scope.renderList = function(){

       var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
        url : "https://center.mvcx.net/list/ajxlist2"   }   ;

        g.show_ajax();
        $scope.appfunctions=[];
        $.when(rest.remote_data(etor,"proxy")).done(function(retx){

            var ex = JSON.parse(retx.data);
        //    $scope.appfunctions = ex.data;
            $(ex.data).each(function(i,j){
                $scope.rawData.push(j);
                j[$scope.descPat] = j[$scope.descPat];
                $scope.appfunctions.push(j);
              //  console.log(j);
            });
            g.hide_ajax();

            $scope.totalItems2[$scope.pageIndex] = g.list_total(ex);
            $scope.totalItems = $scope.totalItems2[$scope.pageIndex];
            $scope.maxPages = $scope.totalItems % $scope.pageSize==0?  ($scope.totalItems/ $scope.pageSize):  ($scope.totalItems/ $scope.pageSize) +1 ;

            $scope.$$phase || $scope.$apply();


        });

     };

     $scope.selectPage  =function(p)
     {
           if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
           {
             $scope.startIndex = $scope.startIndex+p;
              $scope.renderList();
           }
     };
     $scope.pageSizeChange = function (p) {
         $scope.pageSize = p;
         $scope.startIndex = 1;
         $scope.renderList();
     };

     $scope.renderList();

     $scope.search1 = function(){
       $scope.categoryId = 12;
       $scope.pageId =84;
       $scope.descPat = "__c137";
       $scope.keywordId = 126;
       $scope.startIndex =1;
       $scope.pageIndex =1;
       $scope.renderList();

        console.log('search1');
     }

    $scope.search2 = function(){
      $scope.categoryId = 7;
      $scope.pageId =49;
      $scope.descPat = "__c76";
       $scope.keywordId = 66;
      $scope.startIndex =1;
      $scope.pageIndex =2;
      $scope.renderList();
       console.log('search2');
    }




    $scope.importFunction = function(fc){



      var appcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == "appIdentity" });
      if (!appcfg)  { return false      } ;



     var arr =[
       {"_Key":"__c126","_Value":fc.__c66},
       {"_Key":"__c127","_Value": appcfg.configuration_value },
       {"_Key":"__c128","_Value":fc.__c67},
       {"_Key":"__c129","_Value":fc.__c68},
       {"_Key":"__c130","_Value":fc.__c69},
       {"_Key":"__c131","_Value":fc.__c70},//代码
       {"_Key":"__c132","_Value":fc.__c71},
       {"_Key":"__c133","_Value":fc.__c72},
       {"_Key":"__c134","_Value":fc.__c73},//配置 [{"keyword" : "按钮名称14","stype":"string","type":"data","ftype":"input","value":""}  ]
       {"_Key":"__c135","_Value":fc.__c74},
  //     {"_Key":"__c136","_Value":fc.__c75},
       {"_Key":"__c137","_Value":fc.__c76},
       {"_Key":"__c220","_Value":fc.__c218},
       {"_Key":"__c221","_Value":fc.__c219}];




       var etor ={
         itemId: 0,
         jsonStr : JSON.stringify(arr),
         pageId: 83,
         relatedSTR:"[]",
         url:"https://center.mvcx.net/e/createupdate"
       };

    //    console.log(etor);
    //    return false;

       g.show_ajax();

        $.when(rest.remote_data(etor,"proxy")).done(function(retx){
          //    console.log(fc);
              g.modal1("已引入!");
              g.hide_ajax();
        });


    }


    $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }

      $scope.renderList();

       console.log($scope.keyword);
    }

});


app.controller('adminapproute', function ($rootScope, $scope, $location, $sce,$filter,  cooConfig, g, rest , editableOptions, editableThemes ) {



  editableThemes.bs3.inputClass = 'input-sm';
  editableThemes.bs3.buttonsClass = 'btn-sm';
  editableOptions.theme = 'bs3';

 $scope.rawData =[];
 $scope.startIndex =1;
 $scope.pageSize = 10;
 $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
 $scope.lsc = [];


$scope.s_pats2 =[
  { ID:100,pName:'路由名称' },
  { ID:101,pName:'路径' },
  { ID:103,pName:'native属性' },
  { ID:104,pName:'web属性' },
  { ID:105,pName:'小程序属性' },
];
$scope.text_labelx = "100";


  $scope.renderList = function(){

     var  etor ={"companyId":1000,"cid":"10","id":"70","lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
      url : "https://center.mvcx.net/list/ajxlist2"   }   ;


      g.show_ajax();

      $.when(rest.remote_data(etor,"proxy")).done(function(retx){

          var ex = JSON.parse(retx.data);
          $scope.appconfigs = ex.data;
          $(ex.data).each(function(i,j){
              $scope.rawData.push(j);
          });
          g.hide_ajax();
          $scope.row = ex.data[0];

          $scope.totalItems = g.list_total(ex);
          $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;

          $scope.$$phase || $scope.$apply();


      });

  }

  $scope.selectPage  =function(p)
  {
        if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
        {
          $scope.startIndex = $scope.startIndex+p;
           $scope.renderList();
        }
  }

  $scope.select_clear =function(){
    $scope.lsc =[];
      $scope.startIndex =1;
     $scope.text_valuex ='';
     $scope.renderList();

  }

  $scope.pageSizeChange = function (p) {
      $scope.pageSize = p;
      $scope.startIndex = 1;
      $scope.renderList();
  };

  $scope.text_change = function(text_labelx,text_valuex){

       $scope.lsc =[];
       $scope.startIndex =1;
      if (text_valuex){
         $scope.lsc.push({"patternId":text_labelx,"val1":text_valuex,"pTypeId":5,"operation":6});
      }
      $scope.renderList();

  }


  $scope.renderList();

  $scope.row = {
  };

  $scope.statuses = [
    {value: 45, text: '普通路由'},
    {value: 46, text: '动态路由'},
    {value: 47, text: '其他路由'},

  ];



  $scope.showStatus = function(cfg) {
    var selected = [];
    if(cfg && cfg.__c102) {
      selected =  _.filter($scope.statuses,function(n){ return n.value == cfg.__c102.ID });
    }
    return selected.length ? selected[0].text : 'Not set';
  };

  $scope.checkName = function(col, data) {
    if ( col=='__c100' && !data  ) {
      return "路由名称必填";
    }
    if ( col=='__c101' && !data  ) {
      return "路径必填";
    }
  };

  $scope.saveRow = function(data) {


     var itemId =0;
     var exRow = _.find($scope.rawData,function(n){ return n.server_identity == data.server_identity});
     if (exRow) itemId = exRow.__c99;  //ptypeId=16;

     var arr =[];
      $(_.keys(data)).each(function(i,key){
        if (key.indexOf('__')>=0){
           arr.push({"_Key":key,"_Value":data[key]});
        }
      });
      var appcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == "appIdentity" });
      if (appcfg){
         arr.push({"_Key":"__c106","_Value": appcfg.configuration_value });
      }

     var etor ={
       itemId: itemId,
       jsonStr : JSON.stringify(arr),
       pageId: 68,
       relatedSTR:"[]",
       url:"https://center.mvcx.net/e/createupdate"
     };



     g.show_ajax();

      $.when(rest.remote_data(etor,"proxy")).done(function(retx){
           console.log(retx);
           $scope.renderList();
      });


    //$scope.user not updated yet

    // return $http.post('api/saveUser', data);
  };

  // remove user
  $scope.removeRow = function(index,identity) {

        g.modal_confirm("确认删除x？",function(){

          $scope.appconfigs = _.filter($scope.appconfigs,function(n){ return n.server_identity!=identity });

          var oldRow = _.find($scope.rawData,function(n){ return n.server_identity == identity });

          if(oldRow){
              var etor ={
                 categoryId:10, del:true,ids:oldRow.__c99,
                 url:"https://center.mvcx.net/list/fakedel"
              }
              g.show_ajax();
              $.when(rest.remote_data(etor,"proxy")).done(function(retx){
                   console.log(retx);
                   $scope.renderList();
              });
          }
        });

  };



  // add user
  $scope.addRow = function() {
    $scope.inserted = {
            __c100:'',
            __c101:'',
            __c102:0,
            __c103:'',
            __c104:'',
            __c105:'',
            server_identity :g.guid()
    };
    $scope.row = $scope.inserted;
    $scope.appconfigs.push($scope.inserted);
  };

});






app.controller('adminfunc', function ($rootScope, $scope, $location, $state,$sce,$filter ,$modal,  cooConfig, g, rest , editableOptions, editableThemes ) {



  editableThemes.bs3.inputClass = 'input-sm';
  editableThemes.bs3.buttonsClass = 'btn-sm';
  editableOptions.theme = 'bs3';

 $scope.rawData =[];
 $scope.startIndex =1;
 $scope.pageSize = 10;
 $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
 $scope.lsc = [];
 $scope.row ={};
 $scope.eventType=1;

 $scope.eventTypeSwitch = function(et){

   $scope.eventType=et;

   $scope.renderList();


 }

  $scope.renderList = function(){

    if ($scope.eventType!=4){

          var etor = {
              key: "auth",
              pageIndex: $scope.startIndex,
              pageSize :$scope.pageSize,
              eventType: $scope.eventType
          };


          if (cooConfig.configObj.configuration_group_id)  etor['joinId'] = 1;


            g.show_ajax();

            $.when(rest.adminList2(etor)).done(function(ret){

                $scope.funcs = ret.data;
                $(ret.data).each(function(i,j){
                    $scope.rawData.push(j);
                });
                $scope.row = ret.data[0];
                g.hide_ajax();


                $scope.totalItems = ret.cc>0?ret.cc:1000;
                $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;
                $scope.numPages =$scope.maxPages;

                $scope.$$phase || $scope.$apply();


            });

    }
    else {

            var etor = {
                key: "event",
                pageIndex: $scope.startIndex,
                pageSize :$scope.pageSize,
            };

            g.show_ajax();

            $.when(rest.adminList2(etor)).done(function(ret){

               console.log(ret);

                $scope.funcs = ret.data;
                $(ret.data).each(function(i,j){
                    $scope.rawData.push(j);
                });
                $scope.row = ret.data[0];
                g.hide_ajax();


                $scope.totalItems = ret.cc>0?ret.cc:1000;
                $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;
                $scope.numPages =$scope.maxPages;

                $scope.$$phase || $scope.$apply();


            });






    }





  }

  $scope.selectPage  =function(p)
  {
        if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
        {
          $scope.startIndex = $scope.startIndex+p;
           $scope.renderList();
        }
  }

  $scope.select_clear =function(){
    $scope.lsc =[];
      $scope.startIndex =1;
     $scope.text_valuex ='';
     $scope.renderList();

  }

  $scope.pageSizeChange = function (p) {
      $scope.pageSize = p;
      $scope.startIndex = 1;
      $scope.renderList();
  };

  $scope.text_change = function(text_labelx,text_valuex){

       $scope.lsc =[];
       $scope.startIndex =1;
      if (text_valuex){
         $scope.lsc.push({"patternId":text_labelx,"val1":text_valuex,"pTypeId":5,"operation":6});
      }
      $scope.renderList();

  }


  $scope.renderList();

  $scope.row = {
  };

  $scope.statuses = [
    {value: 1, text: '系统过程'},
    {value: 2, text: '行权限'},
    {value: 3, text: '用户过程'}

  ];

  $scope.statuses2 = [
    {value: 1, text: '系统过程'},
    {value: 3, text: '用户过程'}
  ];

  $scope.statuses3 = [
    {value: 1, text: '客户端'},
    {value: 2, text: '后端事务'},
    {value: 3, text: '后端事务'}
  ];



  $scope.showStatus = function(cfg) {
    var selected = [];
    if ($scope.eventType!=4){

          if(cfg && cfg.eventType) {
            selected =  _.filter($scope.statuses,function(n){ return n.value == cfg.eventType });
          }

    }
    else {

      if(cfg && cfg.eventType) {
        selected =  _.filter($scope.statuses3,function(n){ return n.value == cfg.eventType });
      }

    }


    return selected.length ? selected[0].text : 'Not set';
  };

  $scope.checkName = function(col, data) {
    if ( col=='pName' && !data  ) {
      return "过程名称必填";
    }
    if ( col=='eName' && !data  ) {
      return "过程英文名必填";
    }
    if ( col=='eventType' && !data  ) {
      return "过程类型必填";
    }
  };

  $scope.saveRow = function(data) {


     var itemId =0;
     var exRow = _.find($scope.rawData,function(n){ return n.ID== data.ID});

     var insertList =[];
     var updateList =[];


     if (exRow){
       exRow.pName =data.pName;
       exRow.eName = data.eName;
       exRow.eDesc = data.eDesc;
       exRow.isEditable =  data.isEditable=="1"?1:0;
       if (data.eventType)        exRow.eventType = data.eventType;
       updateList.push(exRow);
     }else {
       data.eventType = $scope.eventType;
       data.isEditable = data.isEditable=="1"?1:0;
       insertList.push(data);

     }





      var etor = {
          key: 'auth',
          insertList: JSON.stringify(insertList),
          updateList: JSON.stringify(updateList),
          delIds: []
      };

      g.show_ajax();
      console.log(etor);
   //   return false;
      $.when(rest.adminAdapter(etor)).done(function (result) {
         $scope.renderList();
      });






    //$scope.user not updated yet

    // return $http.post('api/saveUser', data);
  };

  // remove user
  $scope.authRow = function(index,ID) {

    var etor = {
        key: "apiAuth",
        joinId: ID
    };

    $.when(rest.adminList2(etor)).done(function(ret){

      var roleIds =  _.pluck(ret.data,'roleId').join(',');

      console.log(roleIds);

      var modalInstance = $modal.open({
           templateUrl: 'tpl/admin/role_modal.html?'+cooConfig.configObj.version,
           controller: 'admin_role_modal_ctrl',
           // size: 'lg',
           resolve:
                 g.load([],
                 function(){},
                 {
                   roleIds: function() { return roleIds }
                 }
                )
         });

         modalInstance.result.then(function (rx) {

             var insertList =[];
             var delIds =[];
             var updateList= [];
             $(rx).each(function(i,j){

                var crole = _.find(ret.data,function(n){ return n.roleId==j});
                if (!crole) insertList.push({ itemAuthId:ID,roleId:j });
             });
             $(ret.data).each(function(i,j){
                var cid = _.find(rx,function(n){return n==j.roleId});
                if (!cid)                delIds.push(j.ID);
             });


            var etor_apiAuth = {
                key: 'apiAuth',
                insertList: JSON.stringify(insertList),
                updateList:JSON.stringify(updateList),
                delIds: delIds
            };

            console.log(etor_apiAuth );
        //    return false;

            $.when(rest.adminAdapter(etor_apiAuth)).done(function(r){
                 console.log(r);


                 $scope.renderList();



            });





         }, function () {
          //$log.info('Modal dismissed at: ' + new Date());
         });



    })




        // g.modal_confirm("确认删除x？",function(){
        //
        //   $scope.funcs = _.filter($scope.funcs,function(n){ return n.ID!=ID });
        //
        //   var oldRow = _.find($scope.rawData,function(n){ return n.ID == ID });
        //
        //   if(oldRow){
        //       var dids =[];
        //       dids.push(ID);
        //
        //       var etor = {
        //           key: 'auth',
        //           insertList: "[]",
        //           updateList: "[]",
        //           delIds:dids
        //       };
        //
        //       g.show_ajax();
        //       console.log(etor);
        //    //   return false;
        //       $.when(rest.adminAdapter(etor)).done(function (result) {
        //          $scope.renderList();
        //       });
        //
        //   }
        // });

  };

  $scope.navCode = function(f){

     if ($scope.eventType!=4){

           if (f.eventType==2){
               $state.go("rowauth",{categoryId:f.categoryId});
           }
           else if (f.eventType==1){
              $state.go("systemevent",{itemId:f.ID});
           }
           else if (f.eventType==3){
             $state.go("customevent",{itemId:f.ID});
           }

     }
     else{

        console.log(f);


        $state.go("transactiondetail",{pageId:f.pageId,itemId:f.ID});

     }



  }


  $scope.systemGroupModal =function( ){



   var modalInstance = $modal.open({
        templateUrl: 'tpl/admin/system_group_modal.html?'+cooConfig.configObj.version,
        controller: 'admin_system_group_modal_instance_ctrl',
        size: 'lg',
        resolve:
              g.load([],
              function(){},
              {

                modal_lsc: function() { return []}
              }
             )

      });

      modalInstance.result.then(function (row) {


        //  var rx = _.find( $scope.appconfigs,function(n){ return n.server_identity == $scope.inserted.server_identity });
        //
        //
        //
        //  $scope.appconfigs = _.filter( $scope.appconfigs,function(n){ return n.server_identity != $scope.inserted.server_identity });
        //
        //  rx.c380 = row.__c380;
        //   rx.c381 = row.__c381;
        // rx.c382 = row.__c382;
        // rx.c470= row.__c470;
        //
        //
        //
        // rx.c471= row.__c471;
        // rx.c472= row.__c472;
        //  rx.c439 =row.__c439?row.__c439.ID:0;
        //  rx.c469 =row.__c469?row.__c469.ID:0;
        //
        //
        //  console.log(rx);
        //
        //  $scope.appconfigs.push(rx);




         $scope.$$phase || $scope.$apply();








      }, function () {
       //$log.info('Modal dismissed at: ' + new Date());
      });


  }



  // add user
  $scope.addRow = function() {
    $scope.inserted = {
            pName:'',
            eName:'',
            eDesc:'',
            eventType:0,
            editStatus:1,
            ID :0
    };
    $scope.row = $scope.inserted;
    $scope.funcs.push($scope.inserted);
  };

});


app.controller('adminappconfig', function ($rootScope, $scope, $location, $sce,$filter, $modal,  cooConfig, g, rest , editableOptions, editableThemes ) {



  editableThemes.bs3.inputClass = 'input-sm';
  editableThemes.bs3.buttonsClass = 'btn-sm';
  editableOptions.theme = 'bs3';

 $scope.rawData =[];
 $scope.startIndex =1;
 $scope.pageSize = 10;
 $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
 $scope.lsc = [];
 $scope.categoryId = 100039;
 $scope.pageId =100039;


$scope.s_pats2 =[
  { ID:380,pName:'配置名称' },
  { ID:381,pName:'配置编号' },
  { ID:470,pName:'配置描述' },
];


$scope.text_labelx = "380";


  $scope.renderList = function(){

     var  etor ={"companyId":1000,"cid":$scope.categoryId,"id":$scope.pageId,"lsc":$scope.lsc,"iindex":$scope.startIndex,"isize": $scope.pageSize,
      url : "https://center.mvcx.net/list/ajxlist2"  ,method: "ajxlist2" }   ;


      g.show_ajax();
      $scope.appconfigs=[];

      $.when(rest.remote_data(etor,"gateway/module")).done(function(retx){

          $(retx.listItems).each(function(i,j){
              j.c470= j.c470?j.c470.replace(/<[^>]+>/ig,''):'';
              j.c470 = j.c470.replace(/\&nbsp;/ig,' ');
              $scope.appconfigs.push(j);
          });


          $scope.appconfigs = retx.listItems;
          $(retx.listItems).each(function(i,j){
              $scope.rawData.push(j);
          });
          g.hide_ajax();
          $scope.row = retx.listItems[0];
          $scope.totalItems = retx.itemCount;
          $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;
          $scope.$$phase || $scope.$apply();


      });

  }

  $scope.selectPage  =function(p)
  {
        if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
        {
          $scope.startIndex = $scope.startIndex+p;
           $scope.renderList();
        }
  }

  $scope.select_clear =function(){
    $scope.lsc =[];
      $scope.startIndex =1;
     $scope.text_valuex ='';
     $scope.renderList();

  }

  $scope.pageSizeChange = function (p) {
      $scope.pageSize = p;
      $scope.startIndex = 1;
      $scope.renderList();
  };

  $scope.text_change = function(text_labelx,text_valuex){

       $scope.lsc =[];
       $scope.startIndex =1;
      if (text_valuex){
         $scope.lsc.push({"patternId":text_labelx,"val1":text_valuex,"pTypeId":5,"operation":6});
      }
      if ($scope.scene){
         $scope.lsc.push({"patternId": 469,"val1":$scope.scene,"pTypeId":2,"operation":1});
      }

      $scope.renderList();

  }


  $scope.restart = function(){

        var  etor  = {
           command : 'restart',
           json : { key:'restart'      }
        }

        $.when(rest.server(etor)).done(function(r){

            g.modal1("进程已重启,等待30秒后刷新，或重新登陆");

            $scope.$$phase || $scope.$apply();
        })


  }


  $scope.upload = function (files, rx) {

        if (files.length>0){

            g.show_ajax();

            $.when(g.upload_file(files[0])).done(function(ret){

            var i = -1;
            i = $scope.appconfigs.indexOf(rx);



        //    $scope.appconfigs = _.filter( $scope.appconfigs,function(n){ return n.server_identity != rx.server_identity });
            rx.c382 = JSON.stringify(ret);

        //    $scope.appconfigs.push(rx);

            $scope.appconfigs.splice(i,1,rx);

            g.hide_ajax();

            });
        }


  };

  $scope.config_modal =function( ){

   var pageId =1;

   var modalInstance = $modal.open({
        templateUrl: 'tpl/admin/config_modal.html?'+cooConfig.configObj.version,
        controller: 'admin_config_modal_instance_ctrl',
        size: 'lg',
        resolve:
              g.load([],
              function(){},
              {
                pageId: function(){ return pageId},
                modal_lsc: function() { return []}
              }
             )

      });

      modalInstance.result.then(function (row) {


         var rx = _.find( $scope.appconfigs,function(n){ return n.server_identity == $scope.inserted.server_identity });



         $scope.appconfigs = _.filter( $scope.appconfigs,function(n){ return n.server_identity != $scope.inserted.server_identity });

         rx.c380 = row.__c380;
          rx.c381 = row.__c381;
        rx.c382 = row.__c382;
        rx.c470= row.__c470;



        rx.c471= row.__c471;
        rx.c472= row.__c472;
         rx.c439 =row.__c439?row.__c439.ID:0;
         rx.c469 =row.__c469?row.__c469.ID:0;


         console.log(rx);

         $scope.appconfigs.push(rx);




         $scope.$$phase || $scope.$apply();








      }, function () {
       //$log.info('Modal dismissed at: ' + new Date());
      });


  }

  $scope.cancelRow = function(){
    if ($scope.inserted){
          $scope.appconfigs = _.filter( $scope.appconfigs,function(n){ return n.server_identity != $scope.inserted.server_identity });
        console.log($scope.appconfigs);
         $scope.$$phase || $scope.$apply();
    }

  }

  $scope.search=function(){
      $scope.lsc =[];
      $scope.startIndex =1;
      if ($scope.keyword){
        $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
      }
      $($scope.s_pats2).each(function(i,j){
          if ((j.pTypeId==5 || j.pTypeId ==7 ) && j.v ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":5,"operation":6})
          }
          if ((j.pTypeId==2 || j.pTypeId ==3 ) && j.v && j.v !=="0" ){
              $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":j.pTypeId,"operation":1})
          }
      });



      $scope.renderList();
    }



  $scope.renderList();

  $scope.row = {
  };

  $scope.statuses = [
    {value: 41, text: '是否'},
    {value: 42, text: '数值'},
    {value: 43, text: '字符'},
    {value: 44, text: '数组'},
    {value: 133, text: '------文件------'},
  ];

  $scope.scenes = [
    {value: 0, text: '请选择'},
    {value: 129, text: '服务端后台'},
    {value: 130, text: '服务端web'},
    {value: 131, text: 'APP基础配置'},
    {value: 132, text: 'APP扩展配置'},
    {value: 134, text: 'APP资源文件'}
  ];



  $scope.showStatus = function(cfg) {
    var selected = [];
    if(cfg && cfg.c439) {
      selected =  _.filter($scope.statuses,function(n){ return n.value == cfg.c439 });
    }
    return selected.length ? selected[0].text : 'Not set';
  };

  $scope.showScenes = function(cfg) {
    var selected = [];
    if(cfg && cfg.c469) {
      selected =  _.filter($scope.scenes,function(n){ return n.value == cfg.c469 });
    }
    return selected.length ? selected[0].text : 'Not set';
  };

  $scope.checkName = function(col, data) {
    if ( col=='c380' && !data  ) {
      return "配置名称必填";
    }
    if ( col=='c381' && !data  ) {
      return "配置编号必填";
    }
    if ( col=='c382' && !data  ) {
      return "配置内容必填";
    }
    if ( col=='c439' && !data  ) {
      return "配置类型必填";
    }
    if ( col=='c469' && !data  ) {
      return "配置场景必填";
    }
  };

  $scope.saveRow = function(data) {

        console.log(data);
        console.log($scope.rawData);


         var itemId =0;
         var exRow = _.find($scope.rawData,function(n){ return n.server_identity == data.server_identity});
         if (exRow) itemId = exRow.ID;  //ptypeId=16;

         var arr =[];
         var regx = /^c\d+$/ig;
          $(_.keys(data)).each(function(i,key){

             if (key!="server_identity"){
                   arr.push({"_Key": '__'+key,"_Value":data[key]});
             }
          });
          // var appcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == "appIdentity" });
          // if (appcfg){
          //    arr.push({"_Key":"__c106","_Value": appcfg.configuration_value });
          // }

         var etor ={
           itemId: itemId,
           jsonStr : JSON.stringify(arr),
           pageId: 100039,
           relatedSTR:"[]",
           method :"createUpdate"
         };

         console.log(etor);



         g.show_ajax();

         $.when(rest.remote_data(etor,"gateway/module")).done(function(retx){

               console.log(retx);
               $scope.renderList();

          });




  };

  // remove user
  $scope.removeRow = function(index,identity) {

        g.modal_confirm("确认删除x？",function(){

          $scope.appconfigs = _.filter($scope.appconfigs,function(n){ return n.server_identity!=identity });

          var oldRow = _.find($scope.rawData,function(n){ return n.server_identity == identity });

          if(oldRow){
              var etor ={
                 pageId:100039, itemId :oldRow.ID,
                 method : "fakedel",
                 url:"https://center.mvcx.net/list/fakedel"
              }
              g.show_ajax();
              $.when(rest.remote_data(etor,"gateway/module")).done(function(retx){

                    console.log(retx);
                    $scope.renderList();

               });
          }
        });

  };



  // add user
  $scope.addRow = function() {
    $scope.inserted = {
            c380:'',
            c381:'',
            c382:'',
             c439:0,
               c469:0,
                c470:'',
            server_identity :g.guid()
    };
    $scope.row = $scope.inserted;
    $scope.appconfigs.push($scope.inserted);
  };

});


app.controller('admindefine', function ($rootScope, $scope, $location, $sce,  cooConfig, g, rest ) {

      var getEName = function(s){

        var ret = makePy(s)[0] + Math.random().toString().substring(2,6);

        return ret;

      }

     $scope.definePages =[];
     $scope.page={};
     $scope.addBtn =true;

     $scope.current_page  = {ID:0, UIname:'--请选择--' };

     $scope.init_page = function(){

       $scope.definePages =[];
       $scope.definePages.push({ID:0, UIname:'--请选择--' });



           $.when(rest.adminList({key:'page'  })).done(function (result) {



             $(result).each(function(i,j){
                   if (j.pageProperty && j.pageProperty.length>2)
                   {
                      var obj =  JSON.parse(j.pageProperty);
                      if (obj.define) $scope.definePages.push(j);
                   }

             });

              $scope.current_page =  $scope.definePages[0];



             $scope.$$phase || $scope.$apply();
           });
     }
     $scope.init_page();

     $scope.replacePage = function(s)
     {
        return s.replace(/DEFINE.+$/ig,'');
     }

    $scope.page_change=function(){

       console.log('page_change');



      $('.simple_with_drop').html('');
      if (!$scope.current_page  || $scope.current_page.ID == 0 )
      {
        $scope.addBtn = true;
        $scope.c_eles =[];
         return false;
      }
         $scope.addBtn = false;


      $scope.c_eles =[];



          var pg = _.find($scope.definePages,function(n){ return n.ID == $scope.current_page.ID});
          $scope.page = pg;

          $scope.control_page =  $scope.replacePage(pg.UIname) ;


          var pgc = _.find(cooConfig.allpage,function(n) {return n.categoryId==pg.categoryId && n.pageType==14});
          console.log(pgc);

          $.when(g.page_update(pgc.ID))
          .done(function(){

             if (pgc)
             {
                 var pts =  g.page_pats(pgc.ID);


                 $(pts).each(function(x,y){



                   var ptt = _.find($scope.dfPatterns,function(n){ return n.pTypeId == y.pTypeId});

                   if (ptt){

                     var ggid = g.guid();
                     var placeholder='';
                     var sourx = [];
                     if (y.property && y.property.length>2)
                     {
                       placeholder = JSON.parse(y.property).placeholder;
                     }
                     var smp =_.find(cooConfig.allstatusmap,function(n){ return n.patternId == y.ID});
                     if (smp){
                        var sts =_.filter(cooConfig.allstatus,function(n){ return n.groupId==smp.groupId});
                        $(sts).each(function(p,q){
                            sourx.push({ID:q.ID,txt:q.statusName ,groupId:q.groupId});
                        });
                     }
                     $('.simple_with_drop').append('  <li id="'+ggid+'" pTypeId="'+y.pTypeId+'" class="btn m-b-xs btn-sm btn-info1 btn-addon"  >'
                           +'<i class="'+ptt.icon+'"></i>'
                        +'  <span>   '+y.pName+'</span>'
                      +' </li>');

                      $scope.c_eles.push({ patternId: y.ID,  id:ggid , name: y.pName,pTypeId:y.pTypeId,placeholder:placeholder,source:sourx});


                   }



                 });
                 console.log($scope.c_eles);






                 $scope.$$phase || $scope.$apply();


             }



          });




    }

    $scope.edit_table = function(){





           console.log($scope.c_eles);

          var addPatterns=[];
          var updatePatterns=[];
          $($scope.c_eles).each(function(i,j){
              if (j.patternId>0)
              {
                 var pt1 = _.find(cooConfig.allpattern,function(n){ return n.ID==j.patternId});
                 pt1.pName = j.name;
                  console.log(typeof pt1.property);
                  var json ={};
                  if (!pt1.property) pt1.property= "{}";
                  if (typeof pt1.property == 'object'){
                       json = pt1.property;
                  }
                  else {
                     json = JSON.parse(pt1.property);
                  }


                 if (j.placeholder){
                    json.placeholder = j.placeholder;
                    //pt1.property =  JSON.stringify(json);
                 }

                 var upt = {
                       ID: pt1.ID,
                       pName: j.name,
                       pTypeId: pt1.pTypeId,
                       eName: getEName(j.name),
                       validator: '',
                       required: false,
                       disabled: false,
                       isUnique: false,
                       isSortStatistic: -1,
                       property:'{ "placeholder":"'+j.placeholder+'"}',
                       categoryId: pt1.categoryId
                 };

                 updatePatterns.push(upt);
              }
              else {
                 addPatterns.push({
                       ID: 0,
                       pName: j.name,
                       pTypeId: j.pTypeId,
                       eName: getEName(j.name),
                       validator: '',
                       required: false,
                       disabled: false,
                       isUnique: false,
                       isSortStatistic: -1,
                       property:'{ "placeholder":"'+j.placeholder+'"}',
                       categoryId: $scope.page.categoryId
                 });
              }


          });

           var etor_pattern = {
               key: 'pattern',
               insertList: JSON.stringify(addPatterns),
               updateList:JSON.stringify(updatePatterns),
               delIds: []
           };
           g.show_ajax();
          $.when(rest.adminAdapter(etor_pattern)).done(function(ry){
               $.when(rest.adminList({key:'pattern', categoryId:$scope.page.categoryId})).done(function (r2) {



                 var addElement=[];
                 var pg15 = _.find(cooConfig.allpage,function(n) {return n.categoryId==$scope.page.categoryId && n.pageType==15});
                 var pg2 = _.find(cooConfig.allpage,function(n) {return n.categoryId==$scope.page.categoryId && n.pageType==2});
                 var pg14 = _.find(cooConfig.allpage,function(n) {return n.categoryId==$scope.page.categoryId && n.pageType==14});
                 var pg8 = _.find(cooConfig.allpage,function(n) {return n.categoryId==$scope.page.categoryId && n.pageType==8});


                 var columnAuth =[];
                 var rid ='0000b99e-0b37-4324-b2ce-5eab9a00754a';
                 var rcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key=='user_role_id' });
                 if (rcfg) rid = rcfg.configuration_value;
                 $(addPatterns).each(function(z1,z){
                     var c_pt = _.find(r2,function(n){ return n.eName == z.eName});
                     if (c_pt)
                     {
                          addElement.push({
                               ID: 0,
                               categoryId: $scope.page.categoryId,
                               patternId: c_pt.ID,
                               pageId: pg15.ID,
                               isRelated:false,
                               eorder:0,
                               property:''
                           });
                           addElement.push({
                                ID: 0,
                                categoryId: $scope.page.categoryId,
                                patternId: c_pt.ID,
                                pageId: pg2.ID,
                                isRelated:false,
                                eorder:0,
                                property:''
                            });
                            addElement.push({
                                 ID: 0,
                                 categoryId: $scope.page.categoryId,
                                 patternId: c_pt.ID,
                                 pageId: pg14.ID,
                                 isRelated:false,
                                 eorder:0,
                                 property:''
                             });

                             addElement.push({
                                  ID: 0,
                                  categoryId: $scope.page.categoryId,
                                  patternId: c_pt.ID,
                                  pageId: pg8.ID,
                                  isRelated:false,
                                  eorder:0,
                                  property:''
                              });




                          columnAuth.push(
                            {
                                ID: 0,
                                patternId:c_pt.ID,
                                categoryId: $scope.page.categoryId,
                                roleId: rid,
                                isReadable: false,
                                isEditable: false
                            }
                          );
                     }
                 });
                 var etor_columnAuth = {
                     key: 'columnAuth',
                     insertList: JSON.stringify(columnAuth),
                     updateList: '[]',
                     delIds: []
                 };
                 var etor_element = {
                     key: 'element',
                     insertList: JSON.stringify(addElement),
                     updateList: '[]',
                     delIds: []
                 };

                 $.when(rest.adminAdapter(etor_columnAuth),rest.adminAdapter(etor_element)).done(function(ry1,ry2){

                 });






                 var addGroups =[];
                 $($scope.c_eles).each(function(i,j){
                     if (j.source.length>1 && !j.patternId) {
                          addGroups.push({ ID:0,name:j.name + 'DEFINE'});
                      }
                 });
                 var etor_statusGroup = {
                   key: 'statusGroup',
                   insertList: JSON.stringify(addGroups),
                   updateList:"[]",
                   delIds: []
                 }

                 $.when(rest.adminAdapter(etor_statusGroup)).done(function(rz){
                      $.when(rest.adminList({key:'statusGroup' })).done(function (r3) {



                        var addStatus =[];
                        var addStatusMap =[];
                        var updateStatus =[];


                         $($scope.c_eles).each(function(i,j){
                             if (j.source.length>0 && !j.patternId) {

                                var gp = _.find(r3,function(n){ return n.name== j.name+"DEFINE" });
                                if (gp)
                                {
                                       var pt= _.find(r2,function(n){ return n.pName== j.name  });
                                       if (pt) {
                                         addStatusMap.push(
                                                       {
                                                         ID: 0,
                                                         categoryId: $scope.page.categoryId,
                                                         patternId: pt.ID,
                                                         groupId: gp.ID,
                                                         depth:0,
                                                         init:true
                                                     }
                                               )
                                       }


                                      $(j.source).each(function(s,t) {
                                            addStatus.push({
                                              ID: 0,
                                              statusName: t.txt,
                                              groupId: gp.ID,
                                              parentId: 0,
                                              data1: '',
                                              data2:'',
                                              statusOrder:0
                                            });
                                        });

                                    }
                                  }
                                  else  if (j.source.length>0 &&  j.patternId>0)
                                  {
                                      var c_group  = _.find(j.source,function(n){ return n.groupId>0});
                                      if (c_group){

                                          $(j.source).each(function(s,t) {

                                               if (t.groupId>0)
                                               {
                                                   var n_sts =_.find(cooConfig.allstatus,function(n){ return n.ID==t.ID });
                                                   if (n_sts){
                                                     n_sts.statusName = t.txt;
                                                   }
                                                   updateStatus.push(n_sts);
                                               }
                                               else {
                                                     addStatus.push({
                                                       ID: 0,
                                                       statusName: t.txt,
                                                       groupId: c_group.groupId,
                                                       parentId: 0,
                                                       data1: '',
                                                       data2:'',
                                                       statusOrder:0
                                                     });
                                               }

                                          });
                                      }


                                  }
                             });
                             var etor_status = {
                                 key: 'status',
                                 insertList: JSON.stringify(addStatus),
                                 updateList:JSON.stringify(updateStatus),
                                 delIds: []
                             };

                             var etor_statusMap = {
                                key : 'statusMap',
                                insertList: JSON.stringify(addStatusMap),
                                updateList:"[]",
                                delIds: []
                             }

                             $.when(rest.adminAdapter(etor_status),rest.adminAdapter(etor_statusMap)).done(function(rw,rw1){

                                 g.hide_ajax();
                                 g.modal1('已更新');

                             });





                      });
                    });




               });
          });





    }



     $scope.save_table = function(){

           if (!$scope.control_page || $scope.control_page.length<2)
           {
              g.modal1('名称至少2个字');
              return false;
           }

           //创建表单
           var addCategories = [{ID:0,categoryName:$scope.control_page + "DEFINE",cOrder:1,status:true,eName:getEName($scope.control_page),property:"{}"}];
           var etor_category = {
              delIds:[],
              insertList: JSON.stringify(addCategories),
              key:"category",
              updateList:"[]"
           };

        //   console.log(addCategories);








           g.show_ajax();
           $('#save').prop('disabled',true);

      //     return false;

           $.when(rest.adminAdapter(etor_category)).done(function (rx) {

                 $.when(rest.adminList({key:'category'})).done(function (r1) {

                       var ct = _.find(r1,function(n){ return n.categoryName == $scope.control_page +"DEFINE" });
                       if (!ct) { console.log('ct missing'); return false;}
                       var addPatterns = [];
                       $($scope.c_eles).each(function(i,j){
                           addPatterns.push({
                               ID: 0,
                               pName: j.name,
                               pTypeId: j.pTypeId,
                               eName: getEName(j.name),
                               validator: '',
                               required: false,
                               disabled: false,
                               isUnique: false,
                               isSortStatistic: -1,
                               property:'{ "placeholder":"'+j.placeholder+'"}',
                               categoryId: ct.ID
                           });
                       });
                       var etor_pattern = {
                           key: 'pattern',
                           insertList: JSON.stringify(addPatterns),
                           updateList:"[]",
                           delIds: [],
                           dic: ["base","create","edit","list","view"]
                       };
                      $.when(rest.adminAdapterPattern(etor_pattern)).done(function(ry){
                           $.when(rest.adminList({key:'pattern', categoryId:ct.ID})).done(function (r2) {



                                 var addGroups =[];
                                 $($scope.c_eles).each(function(i,j){
                                     if (j.source.length>1) {
                                          addGroups.push({ ID:0,name:j.name + 'DEFINE'});
                                      }
                                 });
                                 var etor_statusGroup = {
                                   key: 'statusGroup',
                                   insertList: JSON.stringify(addGroups),
                                   updateList:"[]",
                                   delIds: []
                                 }

                                 $.when(rest.adminAdapter(etor_statusGroup)).done(function(rz){

                                      $.when(rest.adminList({key:'statusGroup' })).done(function (r3) {

                                         var addStatus =[];
                                         var addStatusMap =[];

                                      $($scope.c_eles).each(function(i,j){
                                          if (j.source.length>0) {

                                             var gp = _.find(r3,function(n){ return n.name== j.name+"DEFINE" });
                                             if (gp)
                                             {
                                                var pt= _.find(r2,function(n){ return n.pName== j.name  });
                                                if (pt) {
                                                  addStatusMap.push(
                                                                {
                                                                  ID: 0,
                                                                  categoryId: ct.ID,
                                                                  patternId: pt.ID,
                                                                  groupId: gp.ID,
                                                                  depth:0,
                                                                  init:true
                                                              }
                                                        )
                                                }





                                               $(j.source).each(function(s,t) {
                                                     addStatus.push({
                                                       ID: 0,
                                                       statusName: t.txt,
                                                       groupId: gp.ID,
                                                       parentId: 0,
                                                       data1: '',
                                                       data2:'',
                                                       statusOrder:0
                                                     });
                                                 });

                                             }
                                           }
                                      });
                                      var etor_status = {
                                          key: 'status',
                                          insertList: JSON.stringify(addStatus),
                                          updateList:"[]",
                                          delIds: []
                                      };

                                      var etor_statusMap = {
                                         key : 'statusMap',
                                         insertList: JSON.stringify(addStatusMap),
                                         updateList:"[]",
                                         delIds: []
                                      }

                                      $.when(rest.adminAdapter(etor_status),rest.adminAdapter(etor_statusMap)).done(function(rw,rw1){

                                      });


                                        $.when(rest.adminList({key:'page' ,categoryId:ct.ID})).done(function (r4) {


                                          var updatePages =[];

                                          var pgx = _.find(r4,function(n){ return n.pageType==10});

                                        $(r4).each(function(p1,p2){
                                            p2.dif =5;
                                            if (p2.pageType==10)
                                            {
                                               p2.pageProperty ='{"icon":"user","type":"list-kehu","iconClass":"text-xlg text-red","define":1}';
                                               p2.UIname =$scope.control_page;

                                            }
                                            updatePages.push(p2);

                                        })



                                         var etor_page = {
                                             key: 'page',
                                             insertList: "[]",
                                             updateList: JSON.stringify(updatePages),
                                             delIds:  []
                                         };
                                           $.when(rest.adminAdapter(etor_page)).done(function(rw){

                                           });


                                          var parent_menu_id = null;
                                           var mcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key=='parent_menu_id' });
                                           if (mcfg) parent_menu_id  = mcfg.configuration_value;



                                          var addMenu=[{
                                              ID: 0,
                                              pName:$scope.control_page,
                                              eName:getEName($scope.control_page),
                                              url:'/app/pagex/list',
                                              icon:'fa fa-tags',
                                              parentId:parent_menu_id ,
                                              isMobile:false,
                                              morder: 0,
                                              property:'{"position":"left","name":"app.pagex.list({categoryId:'+ct.ID+',pageId:'+pgx.ID+'})","url":"/{categoryId}/list/{pageId}","templateUrl":"tpl/list.html","controller":"pagex_list_ctrl","resolve":"js/controllers/list.js"}'
                                          }];

                                            var etor_menu = {
                                                key: 'menu',
                                                insertList: JSON.stringify(addMenu),
                                                updateList:"[]",
                                                delIds: []
                                            };
                                            $.when(rest.adminAdapter(etor_menu)).done(function(rt){

                                                 $.when(rest.adminList({key:'menu' })).done(function (r5) {

                                                     var mn = _.find(r5,function(n){ return n.pName==$scope.control_page });
                                                     var rid ='0000b99e-0b37-4324-b2ce-5eab9a00754a'; //mock
                                                     var rcfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key=='user_role_id' });
                                                     if (rcfg) rid = rcfg.configuration_value;

                                                     if (mn){
                                                         var addMenuAuth = [{
                                                           ID: 0,
                                                           menuId:mn.ID,
                                                           roleId:rid
                                                         }];
                                                         var etor_menuAuth  = {
                                                            key: 'menuAuth',
                                                            insertList: JSON.stringify(addMenuAuth),
                                                            updateList:"[]",
                                                            delIds: []
                                                         };
                                                         $.when(rest.adminAdapter(etor_menuAuth)).done(function(rt){
                                                                g.hide_ajax();
                                                                g.modal1('已更新');

                                                         });
                                                     }

                                                 })
                                               });

                                        });







                                   });
                                 });









                          });
                       });







                 });

               // console.log(result);
           });




           //创建字段



     }


     $scope.source =[];

     $scope.dfPatterns =[
         { name:'是否型(bool)',pTypeId:1 ,icon:'fa fa-check-square-o'  },
         { name:'单选项',pTypeId:2 ,icon:'fa fa-tag'  },
         { name:'整数型',pTypeId:3 ,icon:'fa fa-sort-numeric-asc'  },
         { name:'小数型',pTypeId:4 ,icon:'fa fa-money' },
         { name:'单行文字',pTypeId:5  ,icon:'fa fa-edit' },
         { name:'日期型',pTypeId:6 ,icon:'fa fa-calendar'  },
         { name:'多行文字',pTypeId:7 ,icon:'fa fa-pencil'  },
         { name:'多附件',pTypeId:10 ,icon:'fa fa-paperclip'  },
         { name:'单图片附件',pTypeId:11 ,icon:'fa fa-camera'  },
         { name:'内部用户',pTypeId:12 ,icon:'fa fa-user'  },
         { name:'流程控制',pTypeId:13 ,icon:'fa fa-sitemap' },
         { name:'多用户',pTypeId:19 ,icon:'fa fa-users'  },
         { name:'多状态',pTypeId:20 ,icon:'fa fa-tags'  },
         { name:'关联项',pTypeId:23  ,icon:'icon-cursor-move' },
         { name:'地理位置',pTypeId:24 ,icon:'fa fa-map-marker'  },
         { name:'部门',pTypeId:26  ,icon:'fa  fa-shield' }
     ];

     $scope.update = function(){
         $('#'+$scope.control_id).find('span').text($scope.control_name);
         var item = _.find($scope.c_eles,function(n){ return n.id == $scope.control_id });
         item.placeholder = $scope.control_placeholder;
         item.name = $scope.control_name;
         item.source  = $scope.source;

         console.log($scope.c_eles);


     }


     $scope.addSource = function(){

            $scope.source.push({ txt:' '});
            $scope.$$phase || $scope.$apply();
     }

     $scope.edit_attr = function($event){
            var target ='';
           if ($($event.target).is('span'))
           {
                target = $($event.target).parent().attr('id');
           }
           else {
              target = $($event.target).attr('id');
           }
           $scope.currentElements();

           var item = _.find($scope.c_eles,function(n){ return n.id == target });

           if (item){
               $scope.control_name = item.name;
               $scope.control_placeholder = item.placeholder;
               $scope.control_id =item.id;
               $scope.control_type = item.pTypeId;
               $scope.source = item.source;

               console.log(item);



               if ($scope.source.length==0)
               {
                  $scope.source.push({ txt:''});
               }
           }




     }

     $scope.currentElements = function(){

           if (!$scope.c_eles)  $scope.c_eles =[];
            $('.simple_with_drop li').each(function(i,j){

                  var item = _.find($scope.c_eles,function(n){ return n.id == $(j).attr('id') });
                  if (!item)
                  $scope.c_eles.push({ id:$(j).attr('id') , name: $.trim($(j).text()),pTypeId:$(j).attr('pTypeId'),placeholder:'',source:[]});

            });

            console.log($scope.c_eles);



     };








});








app.controller('admindepartment', function ($rootScope, $scope, $location, $sce,  cooConfig, g, rest ) {

      $rootScope.settingMode = true;
    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
    }


    $scope.result = [];
    $scope.departments = [];
    $scope.departments.push({ID:0,departmentName:'请选择'});

    var etor = {
        key: "department"
    };

    $scope.sync_id = function()
    {
       $('.hide .index').prop("disabled",false);
    }


    $.when(rest.adminList(etor)).done(function (result) {





               $(result).each(function (j,p) {

                   $scope.departments.push(p);
                   $scope.result.push(p);

                 // body...
               })



              //  $scope.result = result;
                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);
  });




  $scope.pgSetting=function()
  {


    var json = {};
    $('.pgpt table tr.addrow').each(function(i,j){
         var key =   $(j).find('input.key').val();
         var value  =  $(j).find('input.value').val();
         if (key&&key!='') json[key] = value;
    });
    $('.pgpt').parent('div').find('input.admin_text').val(JSON.stringify(json)).attr('v','e');
    $('.pgpt').hide();
    $scope.$$phase || $scope.$apply();
  };

  $scope.pgClear=function()
  {
     $('.pgpt').hide();
  };

   $scope.popv =function($event)
   {
    var s = $($event.target).parent('div').find('input.admin_text').val();
    var attlist =[];
    var o ={};
    if (s) {
         o= JSON.parse(s);
    }
    var keys = _.keys(o);
    $('.addrow').remove();
    var $div = $('.pgpt');
    var div = '';
    var k=0;
     _.each(keys,function(n){
        k++;
        div+= '<tr class="addrow"><td><input class="key" name="json_k'+k+'" value="'+ n +'" /> </td><td><input class="value" name="json_v'+k+'" value="'+o[n]+'" /></td></tr>';
     });
     k++;
     div+='<tr class="addrow"><td><input  class="key" name="json_k'+k+'" value="" /> </td><td><input class="value" name="json_v'+k+'" value="" /></td></tr>' ;
     $div.find('table').append(div);
     $($event.target).parent('div').append($div);
     $div.show();


   };



    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            departmentName: '',
                            departmentDesc: '',
                            parentId:null
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                           var  erow1 = _.find($scope.result,function(n){ return n.ID == parseInt(tid)})   ;
                           if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 && !erow['new'] ) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'department',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('部门名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                         g.modal1('已更新');

                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist1 = [];
        var checklist2 = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='departmentName']").val();

                checklist1.push(c);

            }
        });
        var flag1 = [];

        $(checklist1).each(function (i, o) {
                if (!flag1[o]) {
                    flag1[o] = true;
                }
                else {
                    chk = false;
                      console.log(o);
                }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});










app.controller('adminpageauth', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    $rootScope.settingMode = true;
    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
         $('#updateBtn').prop('disabled',true);
    }

    $scope.result = [];
    $scope.cates = [];
    $scope.roles = [];
    $scope.pages = [];
    $scope.roles.push({ RoleId: '00000000-0000-0000-0000-000000000000', RoleName: '请选择' });

    var categoryId = $stateParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;


    var etor = {
        key: "pageAuth",
        categoryId: categoryId
    };

    var etorRole = {
        key: "roles"
    };

    var etorCate = {
        key: "category"
    };

    var etorPage = {
        key: "page",
        categoryId: categoryId
    };


    $.when(rest.adminList(etorCate)).done(function (cates) {

        $scope.cates = cates;
        $scope.category = _.find(cates ,function(n) { return n.ID== categoryId });

        if (categoryId != 0) {
            $.when(rest.adminList(etor), rest.adminList(etorRole), rest.adminList(etorPage)).done(function (result, roles, pages) {

                $(roles).each(function (i, o) {
                    o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                    $scope.roles.push(o);
                });
                $scope.pages = pages;
                $scope.result = result;
                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);
            });
        }

        $scope.$apply();
    });

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            pageId: 0,
                            categoryId: categoryId,
                            roleId: '00000000-0000-0000-0000-000000000000',
                            isReadable: false,
                            isEditable: false
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result , function(n) { return n.ID ==  parseInt(tid) });
                         }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'pageAuth',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('页面+角色重复设置');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='pageId']").val();
                var d = $(tr).find("[name='roleId']").val();
                checklist.push(JSON.stringify({ c: c, d: d }));
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });
        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});




app.controller('admincommon', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };


      $rootScope.settingMode = true;
    $scope.page ={};


    var pageId = $stateParams.pageId;
    if (pageId == undefined) pageId = 0;
    $scope.pageId = pageId;



      $scope.pgClear =function()
      {
          $('.pgpt').hide();
      };


       $scope.pgSetting = function()
       {
          g.codeSetting();

       };

       $scope.popv =function($event)
       {
            g.popv($event);
       };



    var etor = {
        key: "abstract"
    };



    var etorProcedure = {
        key: "procedure"
    };



    $.when(rest.adminList(etor), rest.adminList(etorProcedure)).done(function (abst,prcd) {

        $scope.abstracts = abst;
        $scope.procedures =  prcd ;
        cooConfig.allpage = g.fetch2(cooConfig.PAGETABLENAME);

        $scope.page = _.find(cooConfig.allpage ,function(n){ return n.ID == pageId });

        if (typeof ($scope.page.pageProperty) != 'object')
        {
          $scope.page.pageProperty = JSON.parse($scope.page.pageProperty);
          if ($scope.page.pageProperty.url) $scope.url = $scope.page.pageProperty.url;
          if ($scope.page.pageProperty.templateUrl) $scope.templateUrl = $scope.page.pageProperty.templateUrl;
          if ($scope.page.pageProperty.resolve) $scope.resolve = $scope.page.pageProperty.resolve;
          if ($scope.page.pageProperty.route) $scope.route = $scope.page.pageProperty.route;

          if ($scope.page.pageProperty.file1) $scope.file1 = $scope.page.pageProperty.file1;
          if ($scope.page.pageProperty.file2) $scope.file2 = $scope.page.pageProperty.file2;
          if ($scope.page.pageProperty.file3) $scope.file3 = $scope.page.pageProperty.file3;
          if ($scope.page.pageProperty.file4) $scope.file4 = $scope.page.pageProperty.file4;
          if ($scope.page.pageProperty.file5) $scope.file5 = $scope.page.pageProperty.file5;
          if ($scope.page.pageProperty.file6) $scope.file6 = $scope.page.pageProperty.file6;
        }

        $scope.$apply();
    });


    $scope.createRoute = function(){

      if (!$scope.url || !$scope.templateUrl || !$scope.route || !$scope.resolve)
      {
         g.modal1('路由必填项未填!');
         return false;
      }


      var route_obj = {
        "url": $scope.url,
        "templateUrl":$scope.templateUrl,
        "resolve": $scope.resolve
      };

      var erow = [{       ID: 0,
                          panelName: $scope.route,
                          panelproperty: JSON.stringify(route_obj),
                          vorder: 0
                      }];

      var etor =    {
                          key: 'route',
                          insertList: JSON.stringify(erow),
                          updateList: '[]',
                          delIds: []
                      };

        console.log(etor);
      //  return false;

        $.when(rest.adminAdapter(etor)).done(function (result) {
            console.log(result);
            g.modal1('路由创建成功');
        });




    }



    $scope.createFile = function()
    {
       var etor ={
         filename: $scope[$scope.currentFile],
         content : $scope.code
       }



       $.when(rest.admin_procedure(etor)).done(function(ret){

            console.log(ret);
            g.modal1('生成成功!');
       });


    }

    $scope.updatePage = function()
    {

        console.log($scope.page);

      if (typeof ($scope.page.pageProperty) == 'string')
      {
        $scope.page.pageProperty = JSON.parse($scope.page.pageProperty);
      }
      if ($scope.url) $scope.page.pageProperty.url=$scope.url;
      if ($scope.templateUrl) $scope.page.pageProperty.templateUrl=$scope.templateUrl;
      if ($scope.resolve) $scope.page.pageProperty.resolve=$scope.resolve;
      if ($scope.route) $scope.page.pageProperty.route=$scope.route;

      if ($scope.file1) $scope.page.pageProperty.file1=$scope.file1;
      if ($scope.file2) $scope.page.pageProperty.file2=$scope.file2;
      if ($scope.file3) $scope.page.pageProperty.file3=$scope.file3;
      if ($scope.file4) $scope.page.pageProperty.file4=$scope.file4;
      if ($scope.file5) $scope.page.pageProperty.file5=$scope.file5;
      if ($scope.file6) $scope.page.pageProperty.file6=$scope.file6;




      var erow = [{
          ID: $scope.page.ID,
          categoryId: $scope.page.categoryId,
          pageName: $scope.page.pageName,
          pageType: $scope.page.pageType,
          pageProperty: JSON.stringify($scope.page.pageProperty) ,
          UIname: $scope.page.UIname,
          parentId: $scope.page.parentId,
          pageOrder: $scope.page.pageOrder,
          template: $scope.page.template,
          dif:$scope.page.dif
      }];

      console.log(erow);



      var etor = {
          key: 'page',
          insertList: '[]',
          updateList: JSON.stringify(erow),
          delIds: []
      };

      $.when(rest.adminAdapter(etor)).done(function (result) {
          console.log(result);
          g.modal1('页面已更新');
      });
    }

    $scope.pick = function(prcd,index)
    {
        $scope.code = prcd.procedure_code;
        var file = prcd.procedure_id;
        var ext = '';
        switch (prcd.procedure_category) {
          case 'js':
            file+='.js';
            break;
          case 'html':
            file+='.html';
            break;
          default:

        }

        if (!$scope['file'+(index+1)])
        {
          $scope['file'+(index+1)] =file;
        }

      //  $scope['file'+(index+1)] = file;
        $scope.currentFile = 'file'+(index+1);


    }

    $scope.routex = function (abst) {
       var route_obj = JSON.parse(abst.abstract_route);
       $scope.url = route_obj.url;
       $scope.route = route_obj.route;
       $scope.templateUrl = route_obj.templateUrl.replace(/\{companyId\}/ig,cooConfig.configObj.companyId);
       $scope.resolve = route_obj.resolve.replace(/\{companyId\}/ig,cooConfig.configObj.companyId);


    }

    $scope.expd = function(abst)
    {
        var list = abst.procedure_list.split(';');
        console.log($scope.procedures);
        $scope.currentProcedures =  _.filter($scope.procedures,function(n) { return  list.indexOf(n.procedure_id) >=0  });
        console.log($scope.currentProcedures);
         $scope.$$phase || $scope.$apply();
    }

    $scope.setpages = function(c){
       $scope.currentpages = c.pages;
       $scope.$$phase || $scope.$apply();
    };

    $scope.bulkadd=function(){

      var $table = $(".excelTable");
      var c1 =$('#column').val();
      _.each(c1,function(p,q){
              var $row = $table.find("tr:nth-child(2)").clone();
              $row.removeClass("hide");
              $row.find('[name="patternId"]').val(p).attr('v','e');
              $table.append($row);
      });
    };


    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            patternId: 0,
                            pageId: pageId,
                            isRelated:false,
                            eorder:0,
                            property:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result, function(n) { return n.ID == parseInt(tid) });
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'element',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('元素名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable>tr') ;
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='patternId']").val();
                checklist.push(c);
            }
        });
        var flag= [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                console.log(o);
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});


app.controller('adminelement', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };


    $rootScope.settingMode = true;
    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
         $('#updateBtn').prop('disabled',true);
    }



    $scope.result = [];
    $scope.cates = [];
    $scope.pages = [];
    $scope.catepages = [];
    $scope.patterns = [];

    var categoryId = $stateParams.categoryId;
    var pageId = $stateParams.pageId;
    if (categoryId == undefined) categoryId = 0;
    if (pageId == undefined) pageId = 0;
    $scope.categoryId = categoryId;
    $scope.pageId = pageId;


      $scope.pgClear =function()
      {
          $('.pgpt').hide();
      };


       $scope.pgSetting = function()
       {
          g.codeSetting();

       };

       $scope.popv =function($event)
       {
            g.popv($event);
       };



    var etor = {
        key: "element",
        categoryId:categoryId
    };

    var etorCate = {
        key: "category"
    };

    var etorPage = {
        key: "page"
    };

    var etorPattern = {
        key: "pattern"
    };

    var etorJoin = {
        key: "join"
        //,categoryId:categoryId
    };

    console.log('ff');

    $.when(rest.adminList(etorCate), rest.adminList(etorPage)).done(function (cates,pages) {

        $scope.cates = cates;
        $scope.category = _.find(cates,function(n) { return n.ID== categoryId });

        $scope.pages = pages;
        $scope.page = _.find(pages,function(n) { return n.ID== pageId });

        $(cates).each(function (i,c) {
            var subpages = _.filter(pages,function(n) { return n.categoryId == c.ID });
            $scope.catepages.push({category:c,pages:subpages});
        });



        if (categoryId != 0 && pageId != 0) {
            $scope.currentpages =  _.filter(pages,function(n) { return n.categoryId == categoryId });
            $.when(rest.adminList(etor),rest.adminList(etorPattern),rest.adminList(etorJoin)).done(function (result,patterns,joins) {
                $(result).each(function (i, o) {
                    if (o.pageId == pageId) { $scope.result.push(o); };
                });


                var j2 = [];
                var j3=  [];
                var allC = [];
                allC.push(parseInt(categoryId));
                j2.push(categoryId);

                console.log(joins);
                var limitLevel =0;
                while(limitLevel++<5)
                {

                    $(j2).each(function(p,q){

                          $(joins).each(function (i, o) {
                              if (o.categoryId == q || o.joinCategoryId == q) {

                                    var jid = o.categoryId == q ? o.joinCategoryId : o.categoryId;

                                    var pp = _.filter(j3, function (n) { return n == jid });
                                    var pp2 = _.filter(allC, function (n) { return n == jid });
                                    if (pp.length == 0) {
                                      j3.push(jid);
                                    }
                                    if (pp2.length==0){
                                      allC.push(jid);
                                    }
                                }
                        })
                    });

                    j2 = j3;
                    j3 =[];
               }

               console.log(allC);



               $(allC).each(function(i,o){
                       var cps = _.filter(patterns, function (n) { return n.categoryId == o; });
                       var cate = _.find(cates, function (n) { return n.ID == o });


                       $scope.patterns.push({ c: cate, p: cps });


               })







                 console.log($scope.patterns);




                //
                // $(j2).each(function(f,g)
                // {
                //     $(joins).each(function (i, o) {
                //
                //         if (o.categoryId == g || o.joinCategoryId == g) {
                //             var jid = o.categoryId == g ? o.joinCategoryId : o.categoryId;
                //             var cps = _.filter(patterns, function (n) { return n.categoryId == jid; });
                //             var cate = _.find(cates, function (n) { return n.ID == jid });
                //
                //             j3.push(jid);
                //
                //
                //          //   console.log(allC);
                //
                //             var pp = _.filter(allC, function (n) { return n == jid });
                //
                //            // console.log(pp);
                //
                //             if (pp.length == 0) {
                //                 $scope.patterns.push({ c: cate, p: cps });
                //             }
                //         }
                //     });
                //
                // });
                //
                //
                // console.log($scope.patterns);
                //
                //
                // $(j3).each(function(f,g)
                // {
                //     $(joins).each(function (i, o) {
                //
                //         if (o.categoryId == g || o.joinCategoryId == g) {
                //             var jid = o.categoryId == g ? o.joinCategoryId : o.categoryId;
                //             var cps = _.filter(patterns, function (n) { return n.categoryId == jid; });
                //             var cate = _.find(cates, function (n) { return n.ID == jid });
                //
                //
                //
                //
                //          //   console.log(allC);
                //
                //             var pp = _.filter(allC, function (n) { return n == jid });
                //
                //            // console.log(pp);
                //
                //             if (pp.length == 0) {
                //                 $scope.patterns.push({ c: cate, p: cps });
                //             }
                //         }
                //     });
                //
                // });




                var catep = _.find(cates, function (n) { return n.ID == categoryId });
                var cpp = _.filter(patterns, function (n) { return n.categoryId == categoryId; });
                $scope.patterns.push({ c: catep, p: cpp });




                var mypats = [];
                _.each($scope.patterns,function(i,j){
                      var row ={ label:i.c.categoryName,children:[] };
                      _.each(i.p,function( x,y ){
                            row.children.push({label:x.pName,value:x.ID});
                      });

                      mypats.push(row);

                });
                $("#column").multiselect({
                    enableClickableOptGroups: true,
                    enableCaseInsensitiveFiltering: true,
                    includeSelectAllOption: true,
                    maxHeight: 400,
                    dropUp: true
                  });
                var opts={ enableClickableOptGroups: true};
                if (mypats.length>0)   $("#column").multiselect('dataprovider',mypats);

                console.log($scope.patterns);
                console.log(mypats);




               // $scope.patterns = patterns;
                $("#rowcount").val($scope.result);
                $scope.$apply();
                g.jqueryInit('', 0);

            });
        }
        $scope.$apply();
    });

    $scope.setpages = function(c){
       $scope.currentpages = c.pages;
       $scope.$$phase || $scope.$apply();
    };

    $scope.bulkadd=function(){

      var $table = $(".excelTable");


      var c1 =$('#column').val();


      _.each(c1,function(p,q){
              var $row = $table.find("tr:nth-child(2)").clone();
              $row.removeClass("hide");
              $row.find('[name="patternId"]').val(p).attr('v','e');
              $table.append($row);
      });

    };


    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            patternId: 0,
                            pageId: pageId,
                            isRelated:false,
                            eorder:0,
                            property:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result, function(n) { return n.ID == parseInt(tid) });
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'element',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('元素名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable>tr') ;
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='patternId']").val();
                checklist.push(c);
            }
        });
        var flag= [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                console.log(o);
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});


app.controller('admininterface', function ($rootScope, $scope, $location, $sce, $routeParams, cooConfig, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };
    $rootScope.settingMode = true;

    $scope.result = [];
    $scope.interfaceTypes = cooConfig.interfaceTypes;

    $scope.test =function (id) {

        var etor ={ id:id};

         $.when(rest.testInterface(etor)).done(function(ret){
              console.log(ret);
         });

      // body...
    }



    $scope.pgClear =function()
    {
      $('.pgpt').hide();
    };


   $scope.pgSetting = function()
   {
    g.codeSetting2();

   };

   $scope.popv =function($event)
   {
        g.popCode($event);
   };

    var etor = {
        key: "interface"
    };


              $.when(rest.adminList(etor)).done(function (result) {

                  $scope.result = result;
                  $("#rowcount").val($scope.result.length);
                  $scope.$apply();
                  g.jqueryInit('', 0);

              });







    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            interfaceType: 0,
                            interfaceName: '',
                            interfaceDesc:'',
                            interfaceSource:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'interface',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('接口名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='interfaceName']").val();
                checklist.push(c);
            }
        });



        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});








app.controller('adminevent', function ($rootScope, $scope, $location, $sce, $routeParams, cooConfig, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };


    $scope.sync_id = function()
    {
       $('.hide .index').prop("disabled",false);
    }

         $rootScope.settingMode = true;

    $scope.result = [];
    $scope.cates = [];
    $scope.pages = [];
    $scope.catepages = [];

    var categoryId = $routeParams.categoryId;
    var pageId = $routeParams.pageId;
    if (categoryId == undefined) categoryId = 0;
    if (pageId == undefined) pageId = 0;
    $scope.categoryId = categoryId;
    $scope.pageId = pageId;
    $scope.eventTypes = cooConfig.eventTypes;

    $scope.test =function (id) {

        var etor ={ id:id};

         $.when(rest.testEvent(etor)).done(function(ret){
              g.modal1(ret);
         });

      // body...
    }

    $scope.pgClear =function()
    {
      $('.pgpt').hide();
    };


   $scope.pgSetting = function()
   {
    g.codeSetting2();

   };

   $scope.popv =function($event)
   {
        g.popCode($event);
   };




    var etor = {
        key: "event",
        categoryId: categoryId
    };

    var etorCate = {
        key: "category"
    };

    var etorPage = {
        key: "page"
    };



    $.when(rest.adminList(etorCate), rest.adminList(etorPage)).done(function (cates, pages) {

        $scope.cates = cates;
        $scope.category = g.filterListById(cates, categoryId)[0];
        $scope.pages = pages;
        $scope.page = g.filterListById(pages, pageId)[0];

        $(cates).each(function (i, c) {
            var subpages = g.filterPageByCategoryId(pages, c.ID);
            $scope.catepages.push({ category: c, pages: subpages });
        });


        if (categoryId != 0 && pageId != 0) {
            $.when(rest.adminList(etor)).done(function (result) {
                $(result).each(function (i, o) {
                    if (o.pageId == pageId) { $scope.result.push(o); };
                });
                $("#rowcount").val($scope.result.length);
                $scope.$apply();
                g.jqueryInit('', 0);

            });
        }
        $scope.$apply();
    });





    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            pageId: pageId,
                            eventType: 0,
                            eventSource:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {

                            var  erow1 = g.filterListById($scope.result, parseInt(tid))[0];
                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 && !erow['new']) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'event',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('事件类型重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable>tr');
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='eventType']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});


app.controller('adminstatus', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    $scope.sync_id = function()
    {
       $('.hide .index').prop("disabled",false);
    }

    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
    }


    $rootScope.settingMode = true;
    var p= 1;
    var size =30;
    if ($stateParams.p)  p= $stateParams.p;
    if ($stateParams.size) size = $stateParams.size;
    $scope.size =size;
    $scope.pages=[];

    $scope.result = [];
    $scope.cates = [];
    $scope.patterns = [];
    $scope.catepatterns = [];
    $scope.roles = [];

    var categoryId = $stateParams.categoryId;
    var groupId = $stateParams.groupId;
    var patternId = $stateParams.patternId;
    var parentId = $stateParams.parentId;
    var pageIndex = $stateParams.p;
    if (categoryId == undefined) categoryId = 0;
    if (patternId == undefined) patternId = 0;
    $scope.categoryId = categoryId;
    $scope.patternId = patternId;
    $scope.parentId = parentId;
    $scope.parentStatus = [];
    $scope.userPatterns = [];
    $scope.pn = [];
    $scope.v = '';
    $scope.v2 = 0;
    $scope.groupId = groupId;
    $scope.parentStatus = {};
    $scope.parentgroup = $stateParams.parentgroup;
    $scope.categoryStep = cooConfig.configObj.categoryStep;





    var etor = {
        key: "status",
        categoryId: groupId
    };

    var etorGroup =
        {
            key: "statusGroup"
        };

    var etorParent =
        {
            key: "status",
            categoryId: $scope.parentgroup

        };



    $scope.optionChange = function (v, rowId) {

        $('input[data-role="' + rowId + '"]').val(v).attr('v','e');

        console.log(v);

    };




    $scope.optionChange2 = function (groupId,v2, rowId) {


        $location.path('/admin/status/' + v2 + '/index/0/parent/' + rowId + '/parentgroup/' + groupId);




    };



    var etorCate = {
        key: "category"
    };

    var etorPattern = {
        key: "pattern"

    };

    var etorRole =
        {
            key: "roles"
        };


    var filterByPatternId = function (status,patternId) {
        return status.filter(function (v) {
            return v.patternId == patternId;
        });
    };


    $.when(rest.adminList(etorGroup)).done(function (groups) {

        $scope.groups = groups;

        if (groupId != 0) {

            $scope.group = _.find(groups, function (n) { return n.ID == groupId; });

            $.when(rest.adminList(etor), rest.adminList(etorRole)).done(function (result, roles) {

              var l = (result.length%size==0)?parseInt(result.length/size) +1:parseInt(result.length/size) +2;
              for(var i=1; i<l;i++){
                 var v = (i==(parseInt(pageIndex)+1))?"active":"";
                $scope.pages.push({active: v ,page:i-1});
              }



                if (parentId > 0 && $scope.parentgroup>0)
                {

                    $.when(rest.adminList(etorParent)).done(function (result2) {


                        $scope.parentStatus = _.find(result2, function (n) { return n.ID == $scope.parentId;});

                        result = _.filter(result, function (n) { return n.parentId == parentId; });

                       $scope.pages=[];
                        var l = (result.length%size==0)?parseInt(result.length/size) +1:parseInt(result.length/size) +2;
                        for(var i=1; i<l;i++){
                           var v = (i==(parseInt(pageIndex)+1))?"active":"";
                          $scope.pages.push({active: v ,page:i-1});
                        }





                        if (pageIndex == undefined) pageIndex = 0;

                        var pp = (result.length %  $scope.size == 0) ? result.length / $scope.size : result.length / $scope.size + 1;

                        for (var ii = 0; ii < pp; ii++) {
                            $scope.pn.push(ii);
                        }



                        var p1 = pageIndex * $scope.size;
                        var p2 = pageIndex * $scope.size + $scope.size;
                        result = result.slice(p1, p2);



                        $scope.result = result;


                        $scope.roles.push({ RoleName: '不选', RoleId: '' });

                        $(roles).each(function (i, o) {
                            o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                            $scope.roles.push(o);
                        });


                        $("#rowcount").val($scope.result.length);
                        $scope.$apply();
                        g.jqueryInit('', 0);

                    });
                }
                else
                {
                   console.log($scope.size);


                    var pp = (result.length % $scope.size == 0) ? result.length / $scope.size : result.length / $scope.size + 1;

                    for (var ii = 0; ii < pp; ii++) {
                        $scope.pn.push(ii);
                    }

                    var p1 = pageIndex * $scope.size;
                    var p2 = pageIndex * $scope.size + $scope.size;
                    result = result.slice(p1, p2);

                     console.log(result);

                    $scope.result = result;


                    $scope.roles.push({ RoleName: '不选', RoleId: '' });

                    $(roles).each(function (i, o) {
                        o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                        $scope.roles.push(o);
                    });


                    $("#rowcount").val($scope.result.length);
                    $scope.$apply();
                    g.jqueryInit('', 0);


                }


            });
        }
    //    $scope.$apply();





    });



    //$.when(rest.adminList(etorCate), rest.adminList(etorPattern)).done(function (cates, patterns) {

    //    $scope.cates = cates;
    //    $scope.category = g.filterListById(cates, categoryId)[0];
    //    $scope.patterns = patterns;
    //    $scope.pattern = g.filterListById(patterns, patternId)[0];

    //    $($scope.patterns).each(function (i,o) {
    //        if (o.pTypeId ==12 || o.pTypeId==19)
    //        {
    //            $scope.userPatterns.push(o.ID);
    //        }
    //    });

    //    $(cates).each(function (i, c) {
    //       // var subpatterns = g.filterPattenByCategoryIdSelect(patterns, c.ID);

    //        var subpatterns = _.filter(patterns, function (n) { return n.categoryId == c.ID; });
    //        $scope.catepatterns.push({ category: c, patterns: subpatterns });
    //    });


    //    if (categoryId != 0 && patternId != 0) {
    //        $.when(rest.adminList(etor), rest.adminList(etorRole)).done(function (result, roles) {
    //            var selectP = []; flagp = []; selectS = [];
    //            $(result).each(function (i, o) {
    //                if (o.patternId == patternId) { $scope.result.push(o); }
    //                else
    //                {
    //                //    var subPattern = g.filterListById($scope.patterns, o.patternId)[0];
    //                    if (!flagp[o.patternId] && jQuery.inArray(o.patternId, $scope.userPatterns) == -1)
    //                    {
    //                        flagp[o.patternId] = true;
    //                        selectP.push(o.patternId);
    //                    }
    //                    selectS.push(o);
    //                    //o.statusName = o.patternId + ':' + o.statusName;
    //                    //$scope.parentStatus.push(o);
    //                }
    //            });
    //            $(selectP).each(function (i, o) {
    //                var subs = filterByPatternId(selectS, o);
    //                var p = g.filterListById($scope.patterns, o)[0];
    //                $scope.parentStatus.push({ p: p, s: subs });

    //            });

    //            console.log(selectP);
    //            console.log(flagp);
    //            console.log($scope.parentStatus);


    //            $(roles).each(function (i, o) {
    //                o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
    //                $scope.roles.push(o);
    //            });


    //            $("#rowcount").val($scope.result);
    //            $scope.$apply();
    //            g.jqueryInit('', 0);

    //        });
    //    }
    //    $scope.$apply();
    //});

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).closest('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            statusName: '',
                            groupId: groupId,
                            parentId: parentId,
                            data1: '',
                            data2:'',
                            statusOrder:0
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {

                            var  erow1 = _.find($scope.result,function(n){ return n.ID == parseInt(tid) });
                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 && !erow['new']) {
                                updateList.push(erow);
                            } else {
                              if ($scope.categoryStep && $scope.categoryStep>0){
                                   erow.stype = $scope.categoryStep;
                                }
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'status',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            console.log(etor);
      //    return false;

            $('#updateBtn').prop('disabled',true);

            if (!checkdupe()) {
                g.modal1('名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='statusName']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});



app.controller('adminprocedure', function ($rootScope, $scope, $location,$state, $sce,$stateParams,  cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };




    $rootScope.settingMode = true;
    var p= 1;
    var size =12;
    if ($stateParams.p)  p= $stateParams.p;
    if ($stateParams.size) size = $stateParams.size;
    $scope.size =size;
    $scope.pages =[];

    $scope.result = [];
    $scope.result1 = [];

    var etor = {
        key: "procedure"
    };

    $.when(rest.adminList(etor)).done(function (result) {
        $scope.result1 = result;
        var l = (result.length%size==0)?parseInt(result.length/size) +1:parseInt(result.length/size) +2;
        for(var i=1; i<l;i++){
           var v = (i==p)?"active":"";
          $scope.pages.push({active: v ,page:i});
        }


        $(result).each(function (i,o) {
            if ((p-1)*size<=i && i<p*size)
            {
              $scope.result.push(o);
            }
        });




        $("#rowcount").val($scope.result.length);
        $scope.$apply();
        g.jqueryInit('', 0);

    });





    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).closest('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            procedure_name:'',
                            procedure_id:'',
                            procedure_desc:'',
                            procedure_code:'',
                            procedure_version:'',
                            procedure_input:'',
                            procedure_reference:'',
                            procedure_category:'',
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            // erow = g.filterListById($scope.result, parseInt(tid))[0];
                            var  erow1 = _.find($scope.result,function(n){ return n.ID== parseInt(tid) });

                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 &&　!erow['new']) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'procedure',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {

                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        $state.reload();
                      //  window.location.href =window.location.href+'/';
                      //  g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='procedure_id']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };

});





app.controller('adminabstract', function ($rootScope, $scope, $location,$state, $sce,$stateParams,  cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };




    $rootScope.settingMode = true;
    var p= 1;
    var size =12;
    if ($stateParams.p)  p= $stateParams.p;
    if ($stateParams.size) size = $stateParams.size;
    $scope.size =size;
    $scope.pages =[];

    $scope.result = [];
    $scope.result1 = [];

    var etor = {
        key: "abstract"
    };

    $.when(rest.adminList(etor)).done(function (result) {
        $scope.result1 = result;
        var l = (result.length%size==0)?parseInt(result.length/size) +1:parseInt(result.length/size) +2;
        for(var i=1; i<l;i++){
           var v = (i==p)?"active":"";
          $scope.pages.push({active: v ,page:i});
        }


        $(result).each(function (i,o) {
            if ((p-1)*size<=i && i<p*size)
            {
              $scope.result.push(o);
            }
        });




        $("#rowcount").val($scope.result.length);
        $scope.$apply();
        g.jqueryInit('', 0);

    });





    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).closest('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            abstract_name:'',
                            abstract_id:'',
                            abstract_route:'',
                            abstract_desc:'',
                            abstract_version:'',
                            abstract_reference:'',
                            procedure_list:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            // erow = g.filterListById($scope.result, parseInt(tid))[0];
                            var  erow1 = _.find($scope.result,function(n){ return n.ID== parseInt(tid) });

                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 &&　!erow['new']) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'abstract',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {

                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        $state.reload();
                      //  window.location.href =window.location.href+'/';
                      //  g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='abstract_id']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };

});





app.controller('adminstatusgroup', function ($rootScope, $scope, $location, $sce,$stateParams,  cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
    }



    $scope.sync_id = function()
    {
       $('.hide .index').prop("disabled",false);
    }


    $rootScope.settingMode = true;
    var p= 1;
    var size =12;
    if ($stateParams.p)  p= $stateParams.p;
    if ($stateParams.size) size = $stateParams.size;
    $scope.size =size;
    $scope.pages =[];

    $scope.result = [];
    $scope.result1 = [];

    var etor = {
        key: "statusGroup"
    };

    $.when(rest.adminList(etor)).done(function (result) {
        $scope.result1 = result;
        var l = (result.length%size==0)?parseInt(result.length/size) +1:parseInt(result.length/size) +2;
        for(var i=1; i<l;i++){
           var v = (i==p)?"active":"";
          $scope.pages.push({active: v ,page:i});
        }


        $(result).each(function (i,o) {
            if ((p-1)*size<=i && i<p*size)
            {
              $scope.result.push(o);
            }
        });




        $("#rowcount").val($scope.result.length);
        $scope.$apply();
        g.jqueryInit('', 0);

    });





    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).closest('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            name: ''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            // erow = g.filterListById($scope.result, parseInt(tid))[0];
                            var  erow1 = _.find($scope.result,function(n){ return n.ID== parseInt(tid) });

                            if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0 &&　!erow['new']) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'statusGroup',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        window.location.href =window.location.href+'/';
                      //  g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='name']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
//lllllllllllllllllllll
    $scope.findMenu2 = function () {
        var name = $('#menuName').val();
        $scope.result=_.filter($scope.result1,function (n) {
          return n.name.indexOf(name)>=0;
        });
        $scope.$$phase || $scope.$apply();
    }
    //llllllllllllllllllllllllllllllllll
});
















app.controller('adminstatusmap', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
    }

    $rootScope.settingMode = true;
    $scope.result = [];
    $scope.cates = [];
    $scope.patterns = [];
    $scope.catepatterns = [];


    var categoryId = $stateParams.categoryId;
    var patternId = $stateParams.patternId;
    if (categoryId == undefined) categoryId = 0;
    if (patternId == undefined) patternId = 0;
    $scope.categoryId = categoryId;
    $scope.patternId = patternId;



    var etor = {
        key: "statusMap",
        categoryId: categoryId
    };

    var etorCate = {
        key: "category"
    };

    var etorPattern = {
        key: "pattern"

    };


    var etorGroup = {
        key: "statusGroup"
    };

    $.when(rest.adminList(etorCate), rest.adminList(etorPattern), rest.adminList(etorGroup)).done(function (cates, patterns,groups) {

        $scope.cates = cates;
        $scope.category =  _.find(cates,function(n){ return n.ID== categoryId})   ;
        $scope.patterns = patterns;
        $scope.pattern =  _.find(patterns,function(n){ return n.ID== patternId})   ;
        $scope.groups = groups;

        $(cates).each(function (i, c) {
            var subpatterns = _.filter(patterns, function (n) { return n.categoryId ==c.ID });    // g.filterPattenByCategoryIdSelect2(patterns, c.ID);
            console.log(subpatterns);
            $scope.catepatterns.push({ category: c, patterns: subpatterns });
        });


        if (categoryId != 0 && patternId != 0) {
            $.when(rest.adminList(etor)).done(function (result) {

               $scope.currentpatterns =_.filter(patterns,function(n) { return n.categoryId == categoryId });


                $(result).each(function (i, o) {
                    if (o.patternId == patternId) { $scope.result.push(o); }

                });

                $("#rowcount").val($scope.result.length);
                $scope.$apply();
                g.jqueryInit('', 0);

            });
        }
        $scope.$apply();
    });


    var statsIdFilter = function (list,id) {
        return list.filter(function (v) {
            return v.cstatusId == id;
        });
    };

    $scope.setpatterns = function(c){
       $scope.currentpatterns = c.patterns;
       $scope.$$phase || $scope.$apply();
    };


    $scope.submit = function () {

        var selectedPatternId = $('#s').val();
        var selectedPattern = g.filterListById($scope.patterns, selectedPatternId)[0];
        var cateName = '';
        var category1 = _.filter(cooConfig.allcategory, function (n) { return n.ID == selectedPattern.categoryId });
        if (category1.length > 0) cateName = category1[0].categoryName;

        $scope.addChild();
        var j = 3  + parseInt($('#rowcount').val());
        $("[tag ='table_admin'] tr:nth-child(" + j + ") input[name='cstatusId']").val(selectedPatternId);
        $("[tag ='table_admin'] tr:nth-child(" + j + ") input[name='cstatusId']").attr('v', 'e');
        $("[tag ='table_admin'] tr:nth-child(" + j + ") input[name='cstatusId']").parent('div').append(cateName +' -> ' +selectedPattern.pName);
        $('#rowcount').val(parseInt($('#rowcount').val()) + 1);
        $scope.$$phase || $scope.$apply();





    };


    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).closest('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            patternId: patternId,
                            groupId: '',
                            depth:0,
                            init:true
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result ,function(n){ return n.ID== parseInt(tid) });
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'statusMap',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {

        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='groupId']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});



app.controller('admintag', function ($timeout,$rootScope, $scope, $location, $sce, $routeParams, cooConfig, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    $rootScope.settingMode = true;
    $scope.result = [];
    $scope.cates = [];
    $scope.tags = [];
    $scope.tags.push({ ID: 0, UIname: '请选择' });

    $scope.rowColor = '#a4bdfc';
    $scope.currentRowIndex = 0;

    var categoryId = $routeParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;

    var etor = {
        key: "tag",
        categoryId: categoryId
    };

    var etorCate = {
        key: "category"
    };



    //$scope.$on('$viewContentLoaded', function (event) {
    //    $timeout(function () {

    //        $('select[name="my_color"]').simplecolorpicker({ picker: true });
    //        console.log('afaha');

    //    }, 0);
    //});



    // $('select[name="my_color"]').simplecolorpicker({ picker: true });



    $.when(rest.adminList(etorCate)).done(function (cates) {

        $scope.cates = cates;
        $scope.category = g.filterListById(cates, categoryId)[0];

        if (categoryId != 0) {
            $.when(rest.adminList(etor)).done(function (result) {

                $(result).each(function (m, n) {

                    n['color'] = n.color;
                    n['name'] = n.tagName;
                    $scope.result.push(n);
                });



                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);
            });
        }

        $scope.$$phase || $scope.$apply();
    });



    $scope.colorChange = function () {


    };





    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            tagName: '',
                            name:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        var colorTxt = $(tr).find('[name="my_color"][v="e"]');


                        if (rowFlag)
                        {
                            if (colorTxt.length != 0) {
                                erow['tagName'] =  erow['name'];
                                erow['color']  = colorTxt.val() ;
                            }
                            else {
                                var vv = $(tr).find('[name="color"]').val();
                                erow['tagName'] =  erow['name'];
                                erow['color'] = (vv == undefined ? 'white' : vv);
                            }
                        }
                        else {
                            if (colorTxt.length != 0) {
                                rowFlag = true;
                                erow['tagName'] =  $(tr).find('[name="name"]').val();
                                erow['color']  = colorTxt.val() ;
                            }
                        }


                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                     //   erow['tagName'] = erow['tagName'].replace(/^#[0-9a-zA-Z]{6}/ig, '');
                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'tag',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('标签名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='name']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});


app.controller('adminrole', function ($rootScope, $scope, $location, $sce, cooConfig, g, rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    $rootScope.settingMode = true;

    if (cooConfig.configObj.adminDisabled) {
        $('button').prop('disabled',true);
    }

    var etor = {
        key: "roles"
    };

    $scope.result = [];


    $.when(rest.adminList(etor)).done(function (result) {


        result =_.sortBy(result,'categoryId');

        console.log(result);

        $(result).each(function (i,o) {
            o.RoleName = o.RoleName.replace(/^\d+:/ig,'');
            $scope.result.push(o);
        });

        $("#rowcount").val(result.length);
        $scope.$apply();
        g.jqueryInit('', 0);
    });

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            RoleId: '00000000-0000-0000-0000-000000000000',
                            RoleName: '',
                            Description: '',
                            categoryId :0
                        };
                        var tid = $.trim($(this).find('[name="RoleId"]').val());
                        if (tid != '') {
                            erow = _.find($scope.result,function(n){ return n.RoleId.toLowerCase()== tid.toLowerCase() });

                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(o);
                });
            }

            var etor = {
                key: 'roles',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                dels: delist
            };

            if (!checkdupe()) {
                g.modal1('角色名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapterString(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='RoleName']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});





app.controller('adminuser', function ($rootScope, $stateParams, $scope, $location, $sce, cooConfig, g, rest, $timeout) {



     if (cooConfig.configObj.adminDisabled) {
        $('button').prop('disabled',true);
     }




    $scope.startIndex =1;
    $scope.pageSize = 10;
    $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];





    var etor = {
        key: "users"
    };



    var etorDepartment =
    {
       key:"department"
    }

    var etorRole = {
        key:"roles"
    };

    $scope.result = [];
    $scope.allResult=[];
    $scope.roles = [];
    $scope.departments=[];
    $scope.departments.push({ID:0,departmentName:'请选择'});

    var sls = [];
    var roles = [];

    $scope.selectPage  =function(p)
    {
          if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
          {
            $scope.startIndex = $scope.startIndex+p;
             $scope.renderList();
          }
    }

    $scope.select_clear =function(){
      $scope.lsc =[];
        $scope.startIndex =1;
       $scope.text_valuex ='';
       $scope.renderList();

    }

    $scope.pageSizeChange = function (p) {
        $scope.pageSize = p;
        $scope.startIndex = 1;
        $scope.renderList();
    };

   $scope.initData = function(){

       if ($stateParams.UserId){
         $scope.name =$stateParams.UserId;
       }

         var dtd = $.Deferred();

       $.when(rest.adminList(etorRole),rest.adminList(etorDepartment)).done(function (roles,department) {
             $(department).each(function(i,o){
                  $scope.departments.push(o);
             });

             $(roles).each(function (i, o) {
                   o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                   if (o.RoleName.indexOf('admin2') >=0)
                   {
                       if (cooConfig.configObj.isAdmin2)
                       {
                         $scope.roles.push(o);
                       }
                   }
                   else {
                       $scope.roles.push(o);
                   }
               });
               dtd.resolve();
         });

         return dtd.promise();

   }

  $.when($scope.initData()).done(function(){
      $scope.renderList();
  });



   $scope.renderList = function(){

     var  etor2 ={
        pageIndex : $scope.startIndex ,
        pageSize : $scope.pageSize
     };

     if ($scope.selectedRole && $scope.selectedRole.length>0){
       etor2['roleId']= $scope.selectedRole[0].toUpperCase();
     }



     if ($scope.name) {
       etor2['name']= $scope.name;
     }



     console.log($scope.selectedRole);

     g.show_ajax();

     $.when(rest.remote_data(etor2,"cache/users") ).done(function (result) {

        g.hide_ajax();

        $scope.result =[];
        $scope.totalItems = result.cc;
        $scope.maxPages = $scope.totalItems % $scope.pageSize==0? ($scope.totalItems/ $scope.pageSize): ($scope.totalItems/ $scope.pageSize) +1 ;


        $( result.data).each(function(i,j){
           j.UserName  = j.UserName.replace(/^\d+:/ig,'');
           j.PassWord = '***';
           $scope.result.push(j);
        });



         $("#rowcount").val(result.data.length);
         $scope.$apply();
         g.jqueryInit();



         $("#RoleIds").multiselect({
                 enableClickableOptGroups: true,
                 enableCaseInsensitiveFiltering: true,
                 includeSelectAllOption: true,
                 maxHeight: 400,
                 dropUp: true
               });
         $("#RoleIds").multiselect('select',$scope.roles);

         $('.script').replaceWith('<div class=\"script\"><script > ' +
             '$(document).ready(function () {' +
            '$(\'.role\').each(function (i,element) {' +
              ' var ele =$(this);'+
                '$(this).multiselect({' +
                    'enableCaseInsensitiveFiltering: true,' +
                    'includeSelectAllOption: true,' +
                    ' onChange: function(option, checked) { ele.attr(\'v\',\'e\'); }' +
                '});' +
                'var val = $(this).attr(\'val\');' +
                'if (val!=undefined) {var vv = val.toString().toLowerCase().split(\',\'); ' +
                   '$(this).multiselect(\'select\', vv); }' +
            '}); });  </script></div>');

     });


   }




    $scope.adapter = function () {
  $('button').prop("disabled",true);

        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                console.log(regx);
                console.log($.trim($(this).val()));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            UserId: '00000000-0000-0000-0000-000000000000',
                            UserName: '',
                            xingming: '',
                            Password: '',
                            IsApproved: false,
                            roles: '',
                            roleNames:'',
                            departmentId: null
                        };
                        var tid = $.trim($(this).find('[name="UserId"]').val());
                        if (tid != '') {
                            erow = _.find($scope.result,function(n){ return n.UserId.toLowerCase() == tid.toLowerCase() });// g.userFilterByUserId($scope.result, tid)[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            var ename = $(this).attr('name');
                            var val= $.trim($(this).val());
                            switch(ename)
                            {
                                case 'UserId':
                                    erow.UserId = val;
                                    break;
                                case 'UserName':
                                    erow.UserName = val;
                                    break;
                                case 'Password':
                                    erow.Password = val;
                                    break;
                                case 'PassWord':
                                    erow.Password =val;
                                    break;
                                case 'RoleIds':
                                    var tempV = $(this).val();
                                    if (tempV != undefined && tempV.length > 0) {
                                        var tempStr = tempV.join(',');
                                        erow.roles = tempStr;

                                        var names = _.filter($scope.roles,function(n){ return tempStr.toLowerCase().indexOf(n.RoleId.toLowerCase())>=0});
                                        erow.roleNames = $.map(names, function (obj) {
                                            return obj.RoleName
                                        }).join(',');
                                    }

                                    break;
                                case 'XingMing':
                                    erow.xingming = val;
                                    break;
                                case 'departmentId':
                                    erow.departmentId = val;
                                    break;
                                case '':
                                    erow.IsApproved = $(this).is(":checked");
                                    break;


                            }

                        });

                        if (rowFlag) {
                            var tempV = $(tr).find("[tag='edit'][name='RoleIds']").val();
                            if (tempV != undefined && tempV.length > 0) {
                                var tempStr = tempV.join(',');
                                erow.roles = tempStr;

                                var names = _.filter($scope.roles,function(n){ return tempStr.toLowerCase().indexOf(n.RoleId.toLowerCase())>=0});

                          //       g.roleFilterByRoleIds($scope.roles, tempStr);


                                erow.roleNames = $.map(names, function (obj) {
                                    return obj.RoleName
                                }).join(',');
                            }


                            if (tid != '') {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(o);
                });
            }

            var etor = {
                key: 'users',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                dels: delist
            };



            if (!checkdupe()) {
                g.modal1('角色名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapterString(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='UserName']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };






 //sdfsdfsdf 0109


    $scope.findUser = function () {

       $scope.renderList();

       return false;

      var res = $scope.allResult;
      var res1 = [];
      var res2 = [];
      var tempV = $("[name='__c18494']").val();
      var userID = $('#RoleIds').val();






      if (userID == null && tempV !==null) {
        res1 = _.filter(res,function (n) {
          n.UserName = n.UserName.replace(/^\d+:/ig,'');
          n.Password="***";
          return _.any(tempV,function (m) {
            return n.UserId.toLowerCase()==m.toLowerCase();
          });
        });

      }

      if (userID !==null && tempV == null) {
        res1 = _.filter(res,function (n) {
          n.UserName = n.UserName.replace(/^\d+:/ig,'');
          n.Password="***";
          return _.any(userID,function (m) {
            return (n.RoleIds.toLowerCase()).indexOf(m.toLowerCase())>=0;
          });
        });

      }
      if(userID !==null && tempV !==null){
        res1 = _.filter(res,function (n) {
          n.UserName = n.UserName.replace(/^\d+:/ig,'');
          n.Password="***";
          return _.any(tempV,function (m) {
            return _.any(userID,function (o) {
              return n.UserId.toLowerCase() == m.toLowerCase() && (n.RoleIds.toLowerCase()).indexOf(o.toLowerCase())>=0;
            });
          });
        });

      }



      if (!tempV&&!userID)
      {
          $scope.result =   $scope.allResult;
      }
      else {
          $scope.result =res1;
      }





      $scope.$$phase || $scope.$apply();


       $timeout(function(){
        $($('.role')).each(function(i,j){
            var vv = $(j).attr('val').toLowerCase().split(',');
            $(j).multiselect('select', vv);

        });
      },100);

  //    console.log(res1);
   };

   //sdfsdfsdf  0109


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);

        $row.find('[multiple="multiple"]').multiselect({
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true
        });
        $row.find('[multiple="multiple"]').attr('v', 'e');

        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});






app.controller('adminusersautogroup', function ($rootScope, $routeParams, $scope, $location, $sce, cooConfig, g, rest, ngDialog) {


    $rootScope.settingMode = true;

    var etor = {
        key: "usersAutoGroup"
    };


    var etorGroup =
    {
       key: "group"
    };

    $scope.result = [];
    $scope.result1 = [];
    $scope.users =  cooConfig.alluser;
    $scope.groups =[];
    $scope.cates =[];

    $scope.cates.push({ID:'',categoryName:"请选择"});

    $(cooConfig.allcategory).each(function(i,j){
        $scope.cates.push(j);
    });





    var sls = [];

    $.when(rest.adminList(etor),rest.adminList(etorGroup)).done(function (result,resultGroup) {


        $scope.groups = resultGroup;
        $scope.result =result;
        $scope.result1 =result;
        $("#rowcount").val(result.length);
        $scope.$apply();
        console.log("autogroup");
        g.jqueryInit('', 0);
        var users = $scope.users;
        var groups = $scope.groups;
        var cates = $scope.cates;
        $("[name='users']").multiselect({
            enableClickableOptGroups: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            dropUp: true
          });
          $("[name='groups']").multiselect({
              enableClickableOptGroups: true,
              enableCaseInsensitiveFiltering: true,
              includeSelectAllOption: true,
              maxHeight: 400,
              dropUp: true
            });
            $("[name='categorys']").multiselect({
                enableClickableOptGroups: true,
                enableCaseInsensitiveFiltering: true,
                includeSelectAllOption: true,
                maxHeight: 400,
                dropUp: true
              });
          $("[name='users']").multiselect('select',users);
          $("[name='groups']").multiselect('select',groups);
          $("[name='categorys']").multiselect('select',cates);


    });

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            userId:'00000000-0000-0000-0000-000000000000',
                            groupId: '00000000-0000-0000-0000-000000000000',
                            categoryId: null
                        };
                        var tid = $.trim($(this).find('[name="ID"]').val());
                        if (tid != '') {
                            erow = _.find($scope.result,function(n){ return n.ID.toString() == tid });
                        }


                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            var ename = $(this).attr('name');
                            var val= $.trim($(this).val());
                            switch(ename)
                            {
                                case 'groupId':
                                    erow.groupId = val;
                                    break;
                                case 'userId':
                                    erow.userId = val;
                                    break;
                                case 'categoryId':
                                        erow.categoryId = val==""?null:val;
                                        break;

                            }

                        });

                        if (rowFlag) {
                            if (tid != '') {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(o);
                });
            }

            var etor = {
                key: 'usersAutoGroup',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            //!checkdupe()
            if (2==1) {
                  g.modal1('分组名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='groupName']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);

        $row.find('[multiple="multiple"]').multiselect({
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true
        });
        $row.find('[multiple="multiple"]').attr('v', 'e');

        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
    $scope.findMenu = function () {
      var user = $("[name='users']").val();
      var group = $("[name='groups']").val();
      var categorys = $("[name='categorys']").val();
      res = $scope.result1;
      if (user!==null && group==null && categorys==null) {
        res1 = _.filter(res,function (n) {
          return _.any(user,function (m) {
            return m.toLowerCase()==n.userId.toLowerCase();
          });
        });
      }
      if (user==null && group!==null && categorys==null) {
        res1 = _.filter(res,function (n) {
          return _.any(group,function (m) {
            return m.toLowerCase()==n.groupId.toLowerCase();
          });
        });
      }
      if (user==null && group==null && categorys!==null) {
        res1 = _.filter(res,function (n) {
          return _.any(categorys,function (m) {
            return n.categoryId==categorys;
          });
        });
      }
      if (user!==null && group!==null && categorys==null) {
        res1 = _.filter(res,function (n) {
          return _.any(user,function (m) {
            return _.any(group,function (o) {
              return m.toLowerCase()==n.userId.toLowerCase() && o.toLowerCase()==n.groupId.toLowerCase();
            });
          });
        });
      }
      $scope.result = res1;

      $scope.$$phase || $scope.$apply();

    }
});




app.controller('adminusersingroups', function ($rootScope, $routeParams, $scope, $location, $sce, cooConfig, g, rest, ngDialog) {


    $rootScope.settingMode = true;

    var etor = {
        key: "usersInGroups"
    };


    var etorGroup =
    {
       key: "group"
    };

    $scope.result = [];
    $scope.result1 = [];
    $scope.users =  cooConfig.alluser;
    $scope.groups =[];






    var sls = [];

    $.when(rest.adminList(etor),rest.adminList(etorGroup)).done(function (result,resultGroup) {


        $scope.groups = resultGroup;
        $scope.result =result;
        $scope.result1 =result;
        $("#rowcount").val(result.length);
        $scope.$apply();
        g.jqueryInit('', 0);
        var users = $scope.users;
        var groups = $scope.groups;
        //llllllllllllllllllllll
        $("[name='user']").multiselect({
            enableClickableOptGroups: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            dropUp: true
          });
          $("[name='group']").multiselect({
              enableClickableOptGroups: true,
              enableCaseInsensitiveFiltering: true,
              includeSelectAllOption: true,
              maxHeight: 400,
              dropUp: true
            });

          $("[name='user']").multiselect('select',users);
          $("[name='group']").multiselect('select',groups);
          //lllllllllllllllllllllll

    });

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            userId:'00000000-0000-0000-0000-000000000000',
                            groupId: '00000000-0000-0000-0000-000000000000',
                        };
                        var tid = $.trim($(this).find('[name="ID"]').val());
                        if (tid != '') {
                            erow = _.find($scope.result,function(n){ return n.ID.toString() == tid });
                        }


                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            var ename = $(this).attr('name');
                            var val= $.trim($(this).val());
                            switch(ename)
                            {
                                case 'groupId':
                                    erow.groupId = val;
                                    break;
                                case 'userId':
                                    erow.userId = val;
                                    break;

                            }

                        });

                        if (rowFlag) {
                            if (tid != '') {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(o);
                });
            }

            var etor = {
                key: 'usersInGroups',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            //!checkdupe()
            if (2==1) {
                  g.modal1('分组名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='groupName']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);

        $row.find('[multiple="multiple"]').multiselect({
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true
        });
        $row.find('[multiple="multiple"]').attr('v', 'e');

        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
    //llllllllllllll
    $scope.findMenu5 = function () {
      var group = $("[name='group']").val();
      var user = $("[name='user']").val();
      res = $scope.result1;
      var res1 = [];
      if (user!==null && group == null) {
        res1=_.filter(res,function (n) {
          return _.any(user,function (m) {
            return n.userId.toLowerCase() == m.toLowerCase();
          });
        });
      }
      if (user == null && group !== null) {
        res1=_.filter(res,function (n) {
          return _.any(group,function (m) {
            return n.groupId.toLowerCase() == m.toLowerCase();
          });
        });
      }
      if (user !== null && group !== null) {
        res1=_.filter(res,function (n) {
          return _.any(user,function (m) {
            return _.any(group,function (o) {
              return n.userId.toLowerCase() == m.toLowerCase() && n.groupId.toLowerCase() == o.toLowerCase();
            });
          });
        });
      }

      console.log(res1);
      $scope.result = res1;
      $scope.$$phase || $scope.$apply();
    };
    //llllllllllllll
});






app.controller('adminusergroup', function ($rootScope, $routeParams, $scope, $location, $sce, cooConfig, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    $rootScope.settingMode = true;

    var etor = {
        key: "group"
    };




    $scope.result = [];
    $scope.roles = [];

    var sls = [];

    $.when(rest.adminList(etor)).done(function (result) {



        $scope.result =result;
        $("#rowcount").val(result.length);
        $scope.$apply();
        g.jqueryInit('', 0);


    });

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            groupId: '00000000-0000-0000-0000-000000000000',
                            groupName: '',
                            description: '',
                            parentId: null
                        };
                        var tid = $.trim($(this).find('[name="groupId"]').val());
                        if (tid != '') {
                            erow = _.find($scope.result,function(n){ return n.groupId.toLowerCase()==tid.toLowerCase() });
                        }



                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            var ename = $(this).attr('name');
                            var val= $.trim($(this).val());
                            switch(ename)
                            {
                                case 'groupId':
                                    erow.groupId = val;
                                    break;
                                case 'groupName':
                                    erow.groupName = val;
                                    break;
                                case 'description':
                                        erow.description = val;
                                        break;
                                case 'parentId':
                                        erow.parentId = val;
                                        break;

                            }

                        });

                        if (rowFlag) {
                            if (tid != '') {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(o);
                });
            }

            var etor = {
                key: 'group',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                dels: delist
            };

            if (!checkdupe()) {
                g.modal1('分组名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapterString(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='groupName']").val();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);

        $row.find('[multiple="multiple"]').multiselect({
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true
        });
        $row.find('[multiple="multiple"]').attr('v', 'e');

        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});




app.controller('admintemplate', function ($rootScope, $scope, $location, $sce, $routeParams, cooConfig, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };
      $rootScope.settingMode = true;


 //   var fs = require("fs");
//    var path = require("path");
    $scope.result = [];

    var etor = {
        key: "template"
    };



    var fileFilter = function (f) {
        return $scope.result.filter(function (v) {
            return v.filename.toLowerCase() == f.toLowerCase();
        });
    };


    //$.when(rest.adminList(etor)).done(function (result) {

    //    var p = "custom/" + cooConfig.configObj.companyId + "/";
    //    fs.readdir(p, function (err, files) {
    //        if (err) {
    //            throw err;
    //        }

    //        $scope.result = result;

    //        $(files).each(function (i, f) {
    //            var tf = { filename: f, checkSum: '', ContentSize: 0 };
    //            if (fileFilter(f).length==0)   $scope.result.push(tf);
    //        });




    //        $("#rowcount").val($scope.result.length);
    //        $scope.$apply();
    //        g.jqueryInit('', 0);
    //    });



    //});

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        return;
        //todo

        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 0) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            filename: '',
                            checkSum: '',
                            ContentSize:''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }


                        $(tr).find('input:checked').each(function (i) {
                            rowFlag = true;
                            erow.ID = tid==''?0:parseInt(tid);
                            erow.filename = $(tr).find('[name="filename"]').html();
                        });



                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'template',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('文件名称重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);

                        $(insertList).each(function (i,o) {
                            g.updateTemplate(o.ID,o.filename);
                        });
                        $(updateList).each(function (i, o) {
                            g.updateTemplate(o.ID, o.filename);
                        });
                        $('#rowdel').val('');
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c = $(tr).find("[name='filename']").html();
                checklist.push(c);
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
});



//adminnavigate
app.controller('adminnavigate', function ($rootScope, $scope, $location, $sce, $routeParams, cooConfig, _, g, rest, ngDialog) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

      $rootScope.settingMode = true;
    $scope.result = [];
    $scope.cates = [];
    $scope.pages = [];
    $scope.navs = [];

    var categoryId = $routeParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;

    var etor = {
        key: "navigate",
        categoryId: categoryId
    };

    var etorCate = {
        key: "category"
    };

    var etorPage = {
        key: "page"
    };







    $.when(rest.adminList(etorCate)).done(function (cates) {

        $scope.cates = cates;
        $scope.category = g.filterListById(cates, categoryId)[0];

        if (categoryId != 0) {
            $.when(rest.adminList(etor), rest.adminList(etorPage)).done(function (result, pages) {



                $scope.pages = _.filter(pages,function(n){ return n.categoryId==categoryId});
                $scope.result = result;

                $scope.navs.push({ ID: 0, navigateName: '请选择' });
                $(result).each(function (i,j) {
                    $scope.navs.push(j);
                });


                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);
            });
        }

        $scope.$apply();
    });

    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            pageId: 0,
                            MetaData: '',
                            vorder: 0,
                            navigateName: ''
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = g.filterListById($scope.result, parseInt(tid))[0];
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'navigate',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            if (!checkdupe()) {
                g.modal1('关联有重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c1 = $(tr).find("[name='navigateName']").val();
                var c2 = $(tr).find("[name='navigateName']").val();
                checklist.push(JSON.stringify({ c1: c1, c2: c2 }));
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };




});





app.controller('adminjoin', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig,   g, rest, $timeout) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

    if (cooConfig.configObj.adminDisabled) {
         $('button').prop('disabled',true);
         $('#updateBtn').prop('disabled',true);
    }


      $rootScope.settingMode = true;

    $scope.result = [];
    $scope.cates = [];
    $scope.patterns = [];
    $scope.patterns2 = [];
    $scope.basePatterns = [];
    $scope.relation =[];

    $scope.relation.push({name:"1:1",value:1});
    $scope.relation.push({name:"N:1",value:3});


    var categoryId = $stateParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;

    var etor = {
        key: "join",
        categoryId: categoryId
    };

    var etorCate = {
        key: "category"
    };

    var etorPattern = {
        key:"pattern"
    };







    $.when(rest.adminList(etorCate)).done(function (cates) {

        $scope.cates = cates;
        $scope.category = _.find(cates,function(n){ return n.ID == categoryId });


        if (categoryId != 0) {
            $.when(rest.adminList(etor),rest.adminList(etorPattern)).done(function (result,patterns) {

              $scope.pats = patterns;



                $(cates).each(function (i, o) {
                    var subpats = _.filter(patterns, function (n) { return n.categoryId == o.ID; });

                    var subpats2 = _.filter(patterns, function (n) { return n.categoryId == o.ID && (n.pTypeId == 5 || n.pTypeId == 16) });

                    if (o.ID != categoryId) {
                        $scope.patterns.push({ c: o, p: subpats });
                        $scope.patterns2.push({ c: o, p: subpats2 });


                    } else {
                        $scope.basePatterns.push({ c: o, p: subpats });

                    };


                });

          //      console.log($scope.patterns);



                $scope.result = result;
                $("#rowcount").val(result.length);
                $scope.$apply();
                g.jqueryInit('', 0);
            });
        }

        $scope.$apply();
    });

    $scope.adapter = function () {
  $('#updateBtn').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });



        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            baseId: 0,
                            viewPatternId:0,
                            nRelation: 0,
                            joinCategoryId: 0,
                            joinPatternId:0
                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result,function(n){ return n.ID == parseInt(tid) });


                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                erow[$(this).attr('name')] = v;
                                if ($(this).attr('name')=='joinPatternId'){

                                    console.log(erow['joinPatternId']);



                                    var pt = _.find($scope.pats,function(n){ return n.ID==erow['joinPatternId']});


                                     erow['joinCategoryId']= pt.categoryId;




                                }
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'join',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };

            console.log(etor);

          //  return false;

            if (!checkdupe()) {
                g.modal1('关联有重复');
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        return true;
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c1 = $(tr).find("[name='categoryId']").val();
                var c2 = $(tr).find("[name='joinCategoryId']").val();
                checklist.push(JSON.stringify({ c1: c1, c2: c2 }));
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");


        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });



    };
});




app.controller('adminworkflow', function ($rootScope, $scope, $location, $sce, $stateParams, cooConfig, g , rest ) {
    var openAlert = function (msg) {
        $scope.message = msg;
        $scope.cDlgId = ngDialog.open({
            template: 'tmpl/alert.html',
            className: 'ngdialog-theme-default-dialog',
            controller: 'dialogController',
            overlay: false,
            scope: $scope
        });
    };

      $rootScope.settingMode = true;
    $scope.result = [];
    $scope.cates = [];
    $scope.roles = [];
    $scope.status = [];
    var roles = [];
    var categoryId = $stateParams.categoryId;
    if (categoryId == undefined) categoryId = 0;
    $scope.categoryId = categoryId;

    var etor = {
        key: "workFlow"
    };
    //,    categoryId: categoryId
    var etorCate = {
        key: "category"
    };

    var etorStatus = {
        key: "rawStatus",
        categoryId:categoryId

    };

    var etorStatusMap = {
        key: "statusMap"
    };

    var etorGroup =
        {
            key: "statusGroup"
        };


    var etorPattern = {
        key: "pattern",
        categoryId: categoryId
    };


    var etorRoles =
        {
            key: "roles"
        };

    $scope.categories = [];
    $scope.defineGroups = [];
    $scope.status =[];
    $scope.createUserPat = null;
    $scope.groupId=0;
    $scope.rp =function(s){
         if (!s) return '';
         return s.replace(/DEFINE/ig,'');

    }


   var workflow_init = function(){

     $.when(rest.adminList(etorCate),rest.adminList(etorGroup) ).done(function (cates,gps ) {

        $scope.categories =[];


         var pgs = _.filter(cooConfig.allpage,function(n){ return n.pageType ==14});
         $(pgs).each(function(i,j){

            var ct = _.find(cates,function( y){   return y.ID ==j.categoryId && (y.categoryName.indexOf('DEFINE')>0 || y.property.indexOf('define')>0  ) ;   });
            if (ct )
            {
              var chk_ct = _.find($scope.categories,function(n){ return n.ID==ct.ID });
              if (!chk_ct)   $scope.categories.push(ct);

            }

         });
         console.log($scope.categories);

         $(gps).each(function(i,j){
               if (j.name.indexOf('DEFINE')>0){
                  $scope.defineGroups.push(j);
               }
         });

         if (categoryId != 0 && pgs.length>0) {
             var px = _.find(pgs,function(n){  return n.categoryId == $scope.categoryId});
            $.when(g.page_update(px.ID)).done(function(){

              $.when(rest.adminList(etor),rest.adminList(etorPattern),rest.adminList(etorRoles)).done(function (result,patterns,roles) {

                 $scope.patterns = _.filter(patterns,function(n){
                   return n.pTypeId == 3|| n.pTypeId == 4 || n.pTypeId == 5 || n.pTypeId == 6 || n.pTypeId == 7
                 });

                 $scope.patterns2 = _.filter(patterns,function(n){
                   return n.pTypeId == 12
                 });


                  var p13 = _.filter(patterns, function (n) { return n.pTypeId == 13; });
                  if (p13.length > 0)
                  {
                      var gp = _.find(cooConfig.allstatusmap,function(n){ return n.patternId ==p13[0].ID });

                        $scope.groupId = gp.groupId;


                      if (gp){

                         $.when(rest.adminList({
                             key: "status",
                             categoryId: gp.groupId
                         })).done(function(rs){
                            $scope.status= _.sortBy(rs,'statusOrder');
                             $scope.$apply();
                              console.log($scope.status);

                         });

                        //  $scope.status =   _.filter(cooConfig.allstatus, function (s) { return s.groupId == gp.groupId });

                      }




                  }
                   $scope.roles=[];
                  $(roles).each(function (i, o) {
                      o.RoleName = o.RoleName.replace(/^\d+:/ig, '');
                      $scope.roles.push(o);

                  });
                  var roles = $scope.roles;




                  $scope.users= cooConfig.alluser;
                  var px1 = _.find(patterns,function(n){ return n.property.indexOf("createUserPat")>=0 });
                  if (px1)  $scope.createUserPat = px1.ID;

                  console.log($scope.createUserPat);






                  $scope.result = _.filter(result, function (r) { return r.categoryId == categoryId });
                  $("#rowcount").val(result.length);
                  $scope.$apply();
                  $(".chs").trigger("chosen:updated");
                  g.jqueryInit('', 0);
                  $(".contentPats").multiselect({
                          enableClickableOptGroups: true,
                          enableCaseInsensitiveFiltering: true,
                          includeSelectAllOption: true,
                          maxHeight: 400,
                          dropUp: true
                        });
                   $(".ccUsers").multiselect({
                                enableClickableOptGroups: true,
                                enableCaseInsensitiveFiltering: true,
                                includeSelectAllOption: true,
                                maxHeight: 400,
                                dropUp: true
                              });
                    $(".ccUserPats").multiselect({
                                      enableClickableOptGroups: true,
                                      enableCaseInsensitiveFiltering: true,
                                      includeSelectAllOption: true,
                                      maxHeight: 400,
                                      dropUp: true
                                    });

                  $(".contentPats").multiselect('select',$scope.patterns);
                  $(".ccUsers").multiselect('select',$scope.users);
                  $(".ccUserPats").multiselect('select',$scope.patterns2);

                  $('.script').replaceWith('<div class=\"script\"><script > ' +
                      '$(document).ready(function () {' +
                     '$(\'.contentPats\').each(function (i,element) {' +
                       ' var ele =$(this);'+
                         '$(this).multiselect({' +
                             'enableCaseInsensitiveFiltering: true,' +
                             'includeSelectAllOption: true,' +
                             ' onChange: function(option, checked) { ele.attr(\'v\',\'e\'); }' +
                         '});' +
                         'var val = $(this).attr(\'val\');' +
                         'if (val!=undefined) {var vv = val.toString().toLowerCase().split(\',\'); ' +
                            '$(this).multiselect(\'select\', vv); }' +
                     '}); ' +
                     '$(\'.ccUsers\').each(function (i,element) {' +
                       ' var ele =$(this);'+
                         '$(this).multiselect({' +
                             'enableCaseInsensitiveFiltering: true,' +
                             'includeSelectAllOption: true,' +
                             ' onChange: function(option, checked) { ele.attr(\'v\',\'e\'); }' +
                         '});' +
                         'var val = $(this).attr(\'val\');' +
                         'if (val!=undefined) {var vv = val.toString().toLowerCase().split(\',\'); ' +
                            '$(this).multiselect(\'select\', vv); }' +
                     '}); ' +
                     '$(\'.ccUserPats\').each(function (i,element) {' +
                       ' var ele =$(this);'+
                         '$(this).multiselect({' +
                             'enableCaseInsensitiveFiltering: true,' +
                             'includeSelectAllOption: true,' +
                             ' onChange: function(option, checked) { ele.attr(\'v\',\'e\'); }' +
                         '});' +
                         'var val = $(this).attr(\'val\');' +
                         'if (val!=undefined) {var vv = val.toString().toLowerCase().split(\',\'); ' +
                            '$(this).multiselect(\'select\', vv); }' +
                     '}); ' +
                     ' }); </script></div>');
              });




            });


         }

         $scope.$apply();
     });




   }

   workflow_init();



       $scope.adapter2 = function () {
     $('button').prop("disabled",true);
           var insertList = [];
           var updateList = [];
           var delIds = [];

           var check = true;
           var reqCheck = true;
           $("[tag='edit']").each(function (i) {
               if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                   var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                   if (!regx.test($.trim($(this).val()))) {
                       $(this).addClass("fieldInvalid");
                       g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                       check = false;
                       return false;
                   }
               }
           });

           $("[req='true']").each(function () {
               if ($(this).val() == '' && !$(this).closest('tr').hasClass('hide')) {
                   reqCheck = false;
                   g.modal1("必填项未填!" + $(this).attr('name'));
                   //    window.external.MessageBox("必填项未填!");
                   return false;
               }
           });



           if (check && reqCheck) {
               var RArray = [];
               $(".childTable2").each(function (i, t) {
                   $rows = $(t).find("tr");
                   $rows.each(function (j, tr) {
                       if (j > 1) {
                           var rowFlag = false;
                           var erow = {
                               ID: 0,
                               statusName: '',
                               groupId: $scope.groupId,
                               parentId: null,
                               data1: '',
                               data2:'',
                               statusOrder:0
                           };
                           var tid = $(this).find('[name="ID"]').val();
                           if (tid != '' && parseInt(tid) > 0) {

                               var  erow1 = _.find($scope.status,function(n){ return n.ID == parseInt(tid) });
                               if (erow1)     { erow = erow1;  } else { erow['new']=true; }
                           }
                           $(tr).find("[tag='edit'][v='e']").each(function (i) {
                               rowFlag = true;
                               if (erow.hasOwnProperty($(this).attr('name'))) {
                                   var v = $(this).val();
                                   if ($(this).is(':checkbox'))
                                       v = $(this).is(":checked");
                                   erow[$(this).attr('name')] = v;
                               }
                           });

                           if (rowFlag) {
                               if (tid != '' && parseInt(tid) > 0 && !erow['new']) {
                                   updateList.push(erow);
                               } else {
                                   insertList.push(erow);
                               }
                           }

                       }
                   });
               });


               var d2 = JSON.stringify(RArray);

               var delv = $('#rowdel2').val();
               var delist = [];
               if (delv != undefined && delv != '') {
                   delv = delv.toString().substring(1);
                   var args = delv.split(',');
                   $(args).each(function (i, o) {
                       delist.push(parseInt(o));
                   });
               }

               var etor = {
                   key: 'status',
                   insertList: JSON.stringify(insertList),
                   updateList: JSON.stringify(updateList),
                   delIds: delist
               };

               if (!checkdupe()) {
                   g.modal1('名称重复');
               }
               else {
                   console.log(etor);

                   if (insertList.length + updateList.length + delist.length == 0) {
                       g.modal1('无变化！');

                   }
                   else {
                       console.log(etor);


                       $.when(rest.adminAdapter(etor)).done(function (result) {
                           console.log(result);
                           g.modal1('已更新');
                           workflow_init();
                              $('button').prop("disabled",false);



                              var s = 'table_admin2';
                              var $table = $("[tag='" + s + "'] tr:last").remove();


                       });
                   }
               }
           }
       };



    $scope.adapter = function () {
  $('button').prop("disabled",true);
        var insertList = [];
        var updateList = [];
        var delIds = [];

        var check = true;
        var reqCheck = true;
        $("[tag='edit']").each(function (i) {
            if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                if (!regx.test($.trim($(this).val()))) {
                    $(this).addClass("fieldInvalid");
                    g.modal1($(this).parent('div').find('span').text() + " 格式不对");
                    check = false;
                    return false;
                }
            }
        });

        $("[req='true']").each(function () {
            if ($(this).val() == '' && !$(this).parent('div').parent('td').parent('tr').hasClass('hide')) {
                reqCheck = false;
                g.modal1("必填项未填!" + $(this).attr('name'));
                //    window.external.MessageBox("必填项未填!");
                return false;
            }
        });

        console.log($scope.createUserPat);

        if (check && reqCheck) {
            var RArray = [];
            $(".childTable").each(function (i, t) {
                $rows = $(t).find("tr");
                $rows.each(function (j, tr) {
                    if (j > 1) {
                        var rowFlag = false;
                        var erow = {
                            ID: 0,
                            categoryId: categoryId,
                            tagId1: 0,
                            tagId2: 0,
                            roleId: '00000000-0000-0000-0000-000000000000',
                            userId:'00000000-0000-0000-0000-000000000000',
                            departmentInherit : false,
                            createUserPat: $scope.createUserPat,
                            contentPats:'',
                            ccUsers:'',
                            ccUserPats:'',
                            notifyFlag :false


                        };
                        var tid = $(this).find('[name="ID"]').val();
                        if (tid != '' && parseInt(tid) > 0) {
                            erow = _.find($scope.result,function(n){ return n.ID == parseInt(tid) }) ;
                            erow.createUserPat = $scope.createUserPat ;
                        }
                        $(tr).find("[tag='edit'][v='e']").each(function (i) {
                            rowFlag = true;
                            if (erow.hasOwnProperty($(this).attr('name'))) {
                                var v = $(this).val();
                                if ($(this).is(':checkbox'))
                                    v = $(this).is(":checked");
                                if ($(this).hasClass("contentPats"))
                                     v = $(this).val()?$(this).val().join(","):'';
                                if ($(this).hasClass("ccUsers"))
                                     v = $(this).val()?$(this).val().join(","):'';
                                if ($(this).hasClass("ccUserPats"))
                                      v = $(this).val()?$(this).val().join(","):'';
                                erow[$(this).attr('name')] = v;
                            }
                        });

                        if (rowFlag) {
                            if (tid != '' && parseInt(tid) > 0) {
                                updateList.push(erow);
                            } else {
                                insertList.push(erow);
                            }
                        }

                    }
                });
            });


            var d2 = JSON.stringify(RArray);

            var delv = $('#rowdel').val();
            var delist = [];
            if (delv != undefined && delv != '') {
                delv = delv.toString().substring(1);
                var args = delv.split(',');
                $(args).each(function (i, o) {
                    delist.push(parseInt(o));
                });
            }

            var etor = {
                key: 'workFlow',
                insertList: JSON.stringify(insertList),
                updateList: JSON.stringify(updateList),
                delIds: delist
            };


            console.log(etor);
          //  return false;

            if (!checkdupe()) {
                g.modal1('关联有重复');
                 $('button').prop("disabled",false);
            }
            else {
                console.log(etor);

                if (insertList.length + updateList.length + delist.length == 0) {
                    g.modal1('无变化！');
                     $('button').prop("disabled",false);

                }
                else {
                    $.when(rest.adminAdapter(etor)).done(function (result) {
                        console.log(result);
                        g.modal1('已更新');

                        workflow_init();
                        $('.new_row').remove();
                        $('button').prop("disabled",false);
                        // console.log(result);
                    });
                }
            }
        }
    };

    var checkdupe = function () {
        var checklist = [];
        var chk = true;
        $rows = $('.childTable').find("tr");
        $rows.each(function (j, tr) {
            if (j > 1) {
                var c1 = $(tr).find("[name='tagId1']").val();
                var c2 = $(tr).find("[name='tagId2']").val();
                var c3 = $(tr).find("[name='roleId']").val();
                checklist.push(JSON.stringify({ c1: c1, c2: c2 ,c3:c3}));
            }
        });
        var flag = [];
        $(checklist).each(function (i, o) {
            if (!flag[o]) {
                flag[o] = true;
            }
            else {
                chk = false;
            }
        });

        return chk;
    };


    $scope.addChild = function () {

        var s = 'table_admin';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.addClass("new_row").removeClass("hide");
        $row.find(".contentPats1").addClass("contentPats").removeClass("contentPats1");
        $row.find(".ccUsers1").addClass("ccUsers").removeClass("ccUsers1");
        $row.find(".ccUserPats1").addClass("ccUserPats").removeClass("ccUserPats1");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount").val(parseInt($("#rowCount").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

        $(".contentPats").multiselect({
                enableClickableOptGroups: true,
                enableCaseInsensitiveFiltering: true,
                includeSelectAllOption: true,
                maxHeight: 400,
                dropUp: true
              });

        $(".ccUsers").multiselect({
                     enableClickableOptGroups: true,
                     enableCaseInsensitiveFiltering: true,
                     includeSelectAllOption: true,
                     maxHeight: 400,
                     dropUp: true
                   });

         $(".ccUserPats").multiselect({
                           enableClickableOptGroups: true,
                           enableCaseInsensitiveFiltering: true,
                           includeSelectAllOption: true,
                           maxHeight: 400,
                           dropUp: true
                         });

       $(".contentPats").multiselect('select',$scope.patterns);
       $(".ccUsers").multiselect('select',$scope.users);
       $(".ccUserPats").multiselect('select',$scope.patterns2);

    };

    $scope.addChild2 = function () {

        var s = 'table_admin2';
        var $table = $("[tag='" + s + "']");
        var $row = $table.find("tr:nth-child(2)").clone();
        $row.removeClass("hide");
        $table.append($row);
        $row.find('select').attr('v', 'e');
        $("#rowCount2").val(parseInt($("#rowCount2").val()) + 1);
        $('.date-pick').datePicker({ startDate: '1996-01-01' });

    };
    //llllllllllllll
    $scope.findMenu4 = function () {
        var name = $('#pat').val();
      res = _.filter(cooConfig.allworkflow,function (n) {

          return _.any(name,function (m) {
            return n.roleId.toLowerCase() == m.toLowerCase();
          });
        });
      var tag = [];
      var status = [];
      var statu = cooConfig.allstatus;
      for (var i = 0; i < res.length; i++) {
        tag.push(res[i].tagId1);
        tag.push(res[i].tagId2);
      }
      tag1 = _.uniq(tag);
      for (var i = 0; i < statu.length; i++) {
          for (var j = 0; j < tag1.length; j++) {
            if (statu[i].ID==tag1[j]) {
              status.push(statu[i]);
            }
          }
      }
      $scope.status = status;
      $scope.result = res;
      $scope.$$phase || $scope.$apply();
    }
    //llllllllllllllllllllllll
});
