angular.module('app')
.factory('gApp',[ 'cooConfig','rest','$timeout','$sce','$state','$stateParams','$upload','$modal','g','$q' , function (cooConfig,rest,$timeout,$sce,$state,$stateParams,$upload,$modal,g,$q) {

    var gApp ={};

   ///组件编辑时，保护自定义函数
    gApp.protectSectionFunction = function(s,currentId, id ,componentProperties , functionStr ){

      var rex = new RegExp("\\/\\/\\/<section\\s*\?id\\s*\?=\\s*\?\""+currentId+"[\\S\\s]*\?\\/\\/\\/<\\/section>");
      var m1 =rex.exec(s);
      if (m1 && m1.length>0){
        var funcxs = [];
        var sectionStr = m1[0];
        var rfuncx = new RegExp("\\/\\/\\/<function[^<>]*?>[\\S\\s]*\?\\/\\/\\/<\\/function>");
        var mfuncx =  rfuncx.exec(sectionStr);
        $(mfuncx).each(function(i,j){
              var mid = g.lineProperty(j,'id');
              funcxs.push({key:mid,value:j});
        });

        $(componentProperties).each(function(i, j) {
            $(j.children).each(function(p, q) {
               var rgx = new RegExp('<<' + q.keyword + '>>','ig');
               functionStr = functionStr.replace(rgx, q.val);
            });
        });
        var k=0;
        functionStr = functionStr.replace(rfuncx,function(match, contents, ss, offset){
             return funcxs[k++].value;
        });

        s = s.replace(rex,function(m,c,s,f){
           return "\/\/\/<section id=\"" + id + "\" >" +  functionStr + '\/\/\/<\/section>\r\n \/\/\/<\/functions>';
        });
        return s;

      }else {
         s = s.replace(/\/\/\/<\/functions>/ig,
           "\/\/\/<section id=\"" + id + "\" >" +  functionStr + '\/\/\/<\/section>\r\n \/\/\/<\/functions>');
         return s;
      }
    }

    gApp.checkRepeat = function(str){
      var  lines = str.split(/\r\n|\r|\n/);
      for(var i=0;i<5;i++){

        if (lines[i] && lines[i].indexOf('点击此行重复')>=0) return true;
      }
      return false;
    }

    gApp.getSect = function(str){

      var  lines = str.split(/\r\n|\r|\n/);
      for(var i=0;i<10;i++){
        if (lines[i] && lines[i].indexOf('<sect')>=0) return lines[i];
      }
      return '';

    }


    gApp.subRowChange = function(c){



             if (c.value1 =='当前表')
             {
                    c.value='x.'+c.value2;
             }
             else {

                   if (c.stringFormat){
                      c.value =   c.stringFormat.replace(/\{0\}/ig, c.value1 ).replace(/\{1\}/ig, c.value2 );
                   }
                   else{

                     c.value  = c.value2;
                   }


             }

             console.log(c.value);
    }


    gApp.underRowPattern = function(scope,name,c)
    {

          var sData = gApp.getTableStructure(scope.code, name);

          console.log(sData);
          var sObj = JSON.parse(sData);
          var sKeys =  _.keys(sObj);
          var patIds =[];
          var categoryIds =[];
          $(sKeys).each(function(i,j){
               if (sObj[j] == '*')
               {
                 categoryIds.push(j);
               }
               else {
                 $(sObj[j]).each(function(p,q){
                         patIds.push(q);
                 });

               }


          });


          if (categoryIds.length==0) categoryIds.push('0');
          $.when(g.allpattern()).done(function(rx){

               var subx = _.filter(cooConfig.allpattern,function(n) {
                    return       patIds.indexOf(n.ID)>=0  || categoryIds.indexOf(n.categoryId.toString())>=0   ;
               });



                var tableSource = [];
                $(subx).each(function(i,j){
                   tableSource.push({label:j.pName , value: 'c'+j.ID});
                });
                c.source =  tableSource;
                c.stringFormat="{1}";

                $timeout(function(){
                    $(".ui-chosen").trigger("chosen:updated");
                },300);
          });


    }

    gApp.indexStringFormat = function(t){
      var ret = '{0}.{1}';
      switch (t) {
        case 1:
          ret = '(bool?)' + ret;
          break;
        case 2:
        case 3:
          ret = '(int?)' + ret;
          break;
        case 4:
            ret = '(decimal?)' + ret;
            break;
        case 5:
        case 7:
              ret = '(string)' + ret;
        break;
        case 6:
                ret = '(DateTime?)' + ret;
        break;
        case 12:
                ret = '(Guid?)' + ret;
        break;

        default:

      }
      return ret;
    }

      gApp.getTransactionDesc = function(s, paramName){
        var doc = s.split(/\r\n|\r|\n/);
        var k =0;
        $(doc).each(function(i,row){
             var re = new RegExp('(var|decimal\\?|Guid\\?|int\\?|DateTime\\?)\\s*\?'+paramName ,'ig');
             if (re.test(row)){
                return false;
             }
             k++;
        });

        var lineContent = '';
        for(var i=1; i<10;i++){
          lineContent =   doc[k-i];

          if (lineContent.indexOf('<cname')>0) break;
        }


          return g.angleBrackets(lineContent,'cname') ;



      }


    gApp.getInheritStructure = function(s,paramName){

           var stru = gApp.getTableStructure(s,paramName);
           if (!stru) return '{}';
           var rNum = /^\d+$/ig;

           for(var i=0;i<10;i++){
             var struObj = JSON.parse(stru);
             var struKeys = _.keys(struObj);
             if (struKeys.length>0 && !rNum.test(struKeys[0]) )
             {
                if (struKeys[0]=='list' || struKeys[0]=='relatedList' || struKeys[0]=='*')
                {
                   return  stru;
                }
                else{
                   stru = gApp.getTableStructure(s,struKeys[0]);
                }
             }
             else{
               break;
             }

        }

         return stru;
    }



    gApp.getTableStructure = function(s, paramName){

       console.log(paramName);

        var doc = s.split(/\r\n|\r|\n/);
        var k =0;
        $(doc).each(function(i,row){
             var re = new RegExp('(var|decimal\\?|Guid\\?|int\\?|DateTime\\?)\\s*\?'+paramName ,'ig');
             if (re.test(row)){
                return false;
             }
             k++;
        });


        var lineContent = '';
        for(var i=1; i<10;i++){
          lineContent =   doc[k-i];
          if (lineContent.indexOf('<structure')>0) break;
        }


        return g.angleBrackets(lineContent,'structure') ;

    }


     // $scope._editor.getDoc().eachLine(function(row){
     //          if (row.text.indexOf('\/\/\/点击此行')>=0){
     //              args.push(k);
     //          }
     //          k++;
     //      });


    ///获取前N行中的id
    gApp.getDocLine = function(doc,cursor){
        var lineContent = '';
        for(var i=1; i<10;i++){
          lineContent =   doc.getLine(cursor.line-i);
          if (lineContent.indexOf('id=')>0) break;
        }
        return lineContent;
    }


    gApp.variableExt = function(scope, transIndex ,listIndex ){

         console.log('variable');



         var modalInstance = $modal.open({
              templateUrl: 'tpl/admin/variable_modal.html?'+cooConfig.configObj.version,
              controller: 'admin_variable_modal_ctrl',
              size: 'lg',
              resolve:
                    g.load([],
                    function(){},
                    {
                      subPats : function() { return scope.subPats },
                      transactionProperties : function() { return scope.transactionProperties },
                      transIndex : function() { return transIndex },
                      listIndex : function() { return listIndex },
                      code: function() { return scope.code },
                    })
            });





            modalInstance.result.then(function (row){

              console.log(scope);

               console.log(row);
               console.log(transIndex);
            }, function (){
             //$log.info('Modal dismissed at: ' + new Date());
            });


    }





    gApp.formulaExt = function(scope, transIndex ){

         console.log('formula');



         var modalInstance = $modal.open({
              templateUrl: 'tpl/admin/formula_modal.html?'+cooConfig.configObj.version,
              controller: 'admin_formula_modal_ctrl',
              size: 'lg',
              resolve:
                    g.load([],
                    function(){},
                    {
                      subPats : function() { return scope.subPats },
                      transactionProperties : function() { return scope.transactionProperties },
                      transIndex : function() { return transIndex },
                      code: function() { return scope.code },
                    })
            });





            modalInstance.result.then(function (row){
               console.log(row);
               console.log(transIndex);
            }, function (){
             //$log.info('Modal dismissed at: ' + new Date());
            });


    }

   ///编辑扩展
   gApp.setExt  =function(scope,transIndex){




     //      scope.currentPages = [{ ID:18 ,pageType:2},{ ID:19,pageType:10}];

     var prps =[];
     if (scope.transactionProperties ) prps = scope.transactionProperties ;
     if (scope.componentProperties)  prps = scope.componentProperties;

           var modalInstance = $modal.open({
                templateUrl: 'tpl/admin/ext_modal.html?'+cooConfig.configObj.version,
                controller: 'admin_ext_modal_ctrl',
                size: 'lg',
                resolve:
                      g.load([],
                      function(){},
                      {
                        subPats : function() { return scope.subPats },
                        transactionProperties : function() { return prps },
                        transIndex : function() { return transIndex },
                        code : function() { return scope.code },
                        pageElements : function() { return scope.pageElements },
                        subPageElements : function() { return scope.subPageElements }

                      }
                     )
              });

              modalInstance.result.then(function (row) {
                 console.log(row.value);
                 console.log(transIndex);
              }, function () {
               //$log.info('Modal dismissed at: ' + new Date());
              });

   }


    ///限定分类
    gApp.setCategories = function(scope){

      console.log('xxdr3');

//      scope.currentPages = [{ ID:18 ,pageType:2},{ ID:19,pageType:10}];

      var modalInstance = $modal.open({
           templateUrl: 'tpl/admin/apppagestart.html?'+cooConfig.configObj.version,
           controller: 'admin_page_start_instance_ctrl',
           size: 'lg',
           resolve:
                 g.load([],
                 function(){},
                 {
                   currentPages : function() { return scope.currentPages },
                   pageId: function(){ return 1},
                 }
                )
         });

         modalInstance.result.then(function (row) {
            console.log(row);
            scope.currentPages = row;
            scope.currentPagesView =  _.pluck(row,'UIname');

         }, function () {
          //$log.info('Modal dismissed at: ' + new Date());
         });


    }

   //重复元素
    gApp.trans2 =function(scope,startkey,codeType){

      var cProperties = codeType + 'Properties';


      g.show_ajax();
      var key = startkey.replace(/\d+$/ig,'');

      var ks = _.filter( scope[cProperties]  ,function(n){
        return n.keyword.indexOf(key)>-1
      });

      var baseRow = _.find( scope[cProperties]  ,function(n){ return n.keyword==startkey });

      console.log(startkey);
      console.log(baseRow);

      var newRow ={};
      newRow.keyword = key  +ks.length.toString();
      newRow.class = baseRow.class;
      newRow.ext = baseRow.ext;
      newRow.type = baseRow.type;
      newRow.source = baseRow.source;
      newRow.order = baseRow.order;
      if (baseRow.list){
       newRow.list = [];
        $(baseRow.list).each(function(i,j){
            newRow.list.push({
                        keyword: j.keyword.replace(/_\d+$/ig,'')  +'_' +ks.length.toString(),
                        type:j.type,
                        variable : j.variable,
                        placeholder:j.placeholder,
                        class :j.class,
                        source : j.source,
                        source1 : j.source1
            });
        });
      }





       scope[cProperties] .push(newRow);

       scope[cProperties]  =  _.sortBy( scope[cProperties] ,'order');
       scope[cProperties]  =  _.sortBy( scope[cProperties] ,'name');

      console.log( scope[cProperties] );

      scope.$$phase || scope.$apply();

      g.hide_ajax();


    }

   //获取块代码protected数据
   gApp.getProtectedData = function(currentCode,id){




      if (!currentCode)  currentCode = '<>';
      currentCode = currentCode.toString();

      var ret ={};
      var rex =  new RegExp("\\/\\/\\/<protected\\s*\?id\\s*\?=\""+id+"\"\\s*\?index\\s*\?=\\s*\?(\\d+)\\s*\?>([\\S\\s]*\?)<\\/protected>",'ig');
     var rex2 =  new RegExp("\\/\\/\\/<protected\\s*\?id\\s*\?=\""+id+"\"\\s*\?index\\s*\?=\\s*\?(\\d+)\\s*\?>([\\S\\s]*\?)<\\/protected>" );




      var mc = currentCode.match(rex);
      if (mc){
        for(var i =0 ;i<mc.length;i++){
             var mc2 = mc[i].match(rex2);
             ret[mc2[1]] = mc2[2];
        }
      }
      return ret;
   }




    //匹配块代码
    gApp.nestRegMatch =function(s,codeType,id){

        var rex = new RegExp("\\/\\/\\/<" + codeType + "\\s*\?id\\s*\?=\\s*\?\""+ id +"[\\S\\s]*\?$");
        var f =rex.exec(s);

        if (f && f.length>0){
        //   tranIndex = f.index;
           var   currentTransaction = f[0];
           currentTransaction = g.getNestedRegString(currentTransaction,'<'+codeType+'' ,'<\/'+codeType+'>',true);
        }

        return currentTransaction;
    }



    //选择代码
    gApp.selectCode = function(scope, codeType , row,vals ,pats){

      //  g.show_ajax();
       var desc = pats[0];    //代码描述字段
       var gFunc = pats[1];   //生成函数字段
       var cProp = pats[2] ; //可配置属性字段

       console.log(row);



       var cProperties = codeType + 'Properties';   // 可配置属性JSON对象



        scope[codeType]  = row ;
        scope[codeType][desc] = $sce.trustAsHtml(scope[codeType][desc]);

        if (scope[codeType][gFunc]){

          $('.script').replaceWith("<div class=\"script\"><script type=\"text/javascript\">"+ scope[codeType][gFunc] +"</script></div>"   );

        }

        var objx  = {};


        if ( typeof(row[cProp]) == 'object')
        {
           objx =row[cProp];
        }
        else {
           objx = JSON.parse(row[cProp]);
        }



    //   console.log(scope.currentPages);


        var pg = scope.currentPages;// _.find(cooConfig.allpage,function(n){ return   scope.pageIds.indexOf(n.ID)>=0   } );
        var args = [];
        var promises = [];


        var objList =[];
        $(objx).each(function(i,j){


             if (j.source) {
                objList.push(j);
             }
             else if (j.list){


                $(j.list).each(function(p,q){
                    if (q.source)  objList.push(q);
                });
             }
        });





                var objSource1 = _.find(objList,function(n){ return n.source
                  && n.source !='pats' && n.source !='pageElements'  && n.source !='categories'
                });
                var objPattern = _.find(objList,function(n){ return n.source=='pats' });
                var objElement =  _.find(objList,function(n){ return n.source=='pageElements' });
                var objCategory = _.find(objList,function(n){ return n.source=='categories' });
                var objSubElement = _.find(objList,function(n){ return n.source=='subPageElements' });
                var objRole  = _.find(objList,function(n){ return n.source == "roles" });

                if (objSource1){
                      var etor = {
                      "companyId": 1000,
                      "cid": 3,
                      "id": 21,
                      "lsc": [{
                       patternId: 22,
                       val1: codeType,
                       pTypeId: 5,
                       operation: 6
                      }],
                      "iindex": 1,
                      "isize": 300,
                      url: "https://center.mvcx.net/list/ajxlist2"
                      };
                      promises.push(rest.remote_data(etor, "proxy"));
                }

                if (objPattern){
                     promises.push(g.allpattern());
                     scope.filterPats =[];
                }
                if (objElement){
                    $(scope.pageIds).each(function(i,j){
                        promises.push(g.page_update(j));
                    });
                }




                $.when.apply($, promises).done(function() {



                var transactionList = objSource1?JSON.parse(arguments[0].data).data:[];

                var transGroup = _.groupBy(transactionList,function(n){ return n.__c256 });



                var groupSource ={};

                $(_.keys(transGroup)).each(function(i,j){
                    var row ={ label: j,children:[]};
                    $(transGroup[j]).each(function(p,q){
                        row.children.push({ label: q.__c21, value: q.__c226  , stringFormat: q.__c474});
                    });
                    groupSource[j]= [];
                    groupSource[j].push(row);
                });

                console.log(groupSource);


                if (objPattern){
                  groupSource['pats'] = [];// arguments[0];
                  groupSource['pats']['source1'] = 'pats';
                }
                if (objElement){
                  groupSource['pageElements']=  g.pageElements3(scope.pageIds);

                  scope.pageElements = groupSource['pageElements'];

                  console.log(scope.pageIds);

                  console.log(scope.pageElements);
                }
                if (objRole){
                  console.log('rolerole');
                  groupSource["roles"] = cooConfig.allrole;
                }
                if (objSubElement){
                    var subPageIds =[];
                   $(scope.pageIds).each(function(i,j){
                        var subpx = _.filter(cooConfig.allpage,function(n){ return n.parentId == j });
                        $(subpx).each(function(p,q){
                            subPageIds.push(q.ID);
                        });
                   });


                   groupSource['subPageElements'] = g.pageElements2(subPageIds);

                   scope.subPageElements = groupSource['subPageElements'];
                }



                // $scope.elementList();


                $(objx).each(function(i, j) {
                   if (j.source) {
                      j.source1 = j.source;
                      j.source = groupSource[j.source];

                   }else if (j.list){

                       $(j.list).each(function(p,q){
                         if (q.source) {
                           q.source1 = q.source;
                           q.source = groupSource[q.source];
                         }
                       })
                   }
                 });

                scope[cProperties] = [];



               $(objx).each(function(i,j){

                    if (!j.repeat) {
                        j.order = i;
                        scope[cProperties].push(j);
                    }
                    else{
                      j.order = i;
                      j.keyword = j.keyword + '_0';
                      if (j.list){
                           $(j.list).each(function(p,q){
                                q.keyword  = q.keyword + '_0';
                           });
                      }
                      scope[cProperties].push(j);
                    }

               });


               scope[cProperties].push({ keyword:'备注',value:'备注变量内容，过程描述等信息'})


                console.log(scope[cProperties]);
                console.log(vals);
                var protectedData ;
                if (vals.length > 0 ) {

                  var currentCode  = gApp.nestRegMatch(scope.code,codeType,scope.currentId);



                 protectedData =   gApp.getProtectedData(currentCode,scope.currentId);


                 $(vals).each(function(v, w) {
                     var tx = _.find(scope[cProperties], function(n) {
                         return n.keyword == w.key
                     });

                     if (tx ) {
                         tx.value = w.value;
                         if (tx.class=='categories') {
                               scope.filterCategories =  tx.value;
                         }
                         if (tx.class=='pats'){
                               scope.filterPats = tx.value;
                         }
                         if (tx.class == 'roles' && !tx.ext){
                            console.log(tx.value);
                            scope.filterRoles = tx.value;
                         }
                         if (tx.list){
                              if (w.value){

                                $(tx.list).each(function(i,j){
                                   j.value = w.value[i];
                                })

                              };

                         }
                     } else {

                         var ty = _.find(scope[cProperties], function(n) {
                             return n.keyword == w.key.replace(/\d+$/ig, '0')
                         });
                         if (!ty) return false;





                         var tn = {
                             keyword: ty.keyword.replace(/0$/ig,w.key.replace(/\D/ig, '')),
                             class :ty.class,
                             repeat: ty.repeat,
                             ext:ty.ext,
                             list :[],
                             value: w.value ,
                             order: ty.order,
                             variable: ty.variable

                         };
                         $(ty.list).each(function(i, j) {
                             tn.list.push({
                                 keyword :  j.keyword.replace(/0$/ig,w.key.replace(/\D/ig, '')) ,
                                 source: j.source,
                                 type: j.type,
                                 class: j.class,
                                 value: w.value[i],
                                 variable: j.variable

                             });
                         });
                         scope[cProperties].push(tn);
                     }
                 });
                }
                scope[cProperties] =  _.sortBy(scope[cProperties],'order');
                scope[cProperties] =  _.sortBy(scope[cProperties],'name');

               if (protectedData)
               {
                   $(scope[cProperties]).each(function(i,j){

                     j.protected =    protectedData[i];

                   });
               }

               console.log(scope[cProperties]);








                $timeout(function(){

                    var source =[];
                     $(cooConfig.allcategory).each(function(i,j){
                        source.push({label:j.categoryName,value: j.ID });
                     });
                    var roles =[];
                    $(cooConfig.allrole).each(function(i,j){
                        roles.push({label:j.RoleName.replace(/^\d+:/ig,''),value: j.RoleId });
                    });

                    console.log(roles);

                     $(scope[cProperties]).each(function(i,j){
                         if (j.source=='categories' || j.source1=='categories'){
                              j.source = source;
                              j.source1 = 'categories';
                         }
                     });

                     $('.multi-pats').multiselect({
                         enableClickableOptGroups: true,
                         enableCaseInsensitiveFiltering: true,
                         includeSelectAllOption: true,
                         maxHeight: 400,
                         buttonWidth: '100%',
                         dropUp: true
                       });
                     $('.multi-roles').multiselect({
                         enableClickableOptGroups: true,
                         enableCaseInsensitiveFiltering: true,
                         includeSelectAllOption: true,
                         maxHeight: 400,
                         buttonWidth: '100%',
                         dropUp: true
                       });

                     $('.multi-roles').multiselect('dataprovider',roles);
                     $('.multi-roles').multiselect('select', scope.filterRoles );


                     $('.multi-categories').multiselect({
                         enableClickableOptGroups: true,
                         enableCaseInsensitiveFiltering: true,
                         includeSelectAllOption: true,
                         maxHeight: 400,
                         buttonWidth: '100%',
                         dropUp: true,
                         onChange: function(option, checked) {
                               var t =    $('.multi-categories').val();

                               if (!t) {
                                 $('.multi-pats').multiselect('dataprovider',[]);
                                 return false;
                               }

                              $.when(g.allpattern()).done(function(rx){
                                   var subRx = _.filter(rx,function(n){ return  t.indexOf(n.c.toString())>=0  });


                                   scope.subPats = subRx;
                                   $('.multi-pats').multiselect('dataprovider',subRx);


                                 });
                         }
                       });


                     $('.multi-categories').multiselect('dataprovider',source);
                     $('.multi-categories').multiselect('select', scope.filterCategories );
                     console.log(scope.filterCategories);


                     if (scope.filterPats && scope.filterCategories){
                       $.when(g.allpattern()).done(function(rx){
                            var subRx = _.filter(rx,function(n){ return  scope.filterCategories.indexOf(n.c.toString())>=0  });

                            scope.subPats = subRx;
                            $('.multi-pats').multiselect('dataprovider',subRx);
                            $('.multi-pats').multiselect('select', scope.filterPats );

                          });
                     }

                    scope.$$phase || scope.$apply();
                    $(".ui-chosen").trigger("chosen:updated");
                    console.log(scope[cProperties]);


                },300);





                scope.$$phase || scope.$apply();
                g.hide_ajax();


            });

    }


  gApp.getVariableTable = function(scope){

        var retSource =[];
        var ret  ={ label: '可用表',children:[]};




        var rRow = /var\s+(t_[a-zA-Z0-9_]{1,20})/ig;
        var rRowMatches = scope.code.match(rRow);
        if (rRowMatches){
          for(var i=0;i<rRowMatches.length;i++){

              ret.children.push({ label: rRowMatches[i].replace(/^.+t_/ig,'') , value:rRowMatches[i].replace(/^var\s*?/ig,'') });
             }
        }



        retSource.push(ret);

        return retSource;
  }

  gApp.getVariableAttr = function(level , typeIndex ){

      var rAttr =[];
      var selectedIndex = 0;

      if (level == "table"){

       rAttr.push(  { keyword :'数量' , level : 'cell' , typeIndex: 3 ,  selectedIndex :  selectedIndex++  ,  value :'Count'         });




      }
      if (level == 'row'){
         if (typeIndex==33){

           rAttr.push(  { keyword :'分类编号' , level : 'cell' , typeIndex: 3 ,  selectedIndex :  selectedIndex++  ,  value :'categoryId'         });
           rAttr.push(  { keyword :'行数字编号' , level : 'cell' , typeIndex: 3 ,  selectedIndex :  selectedIndex++  ,  value :'itemId'         });
           rAttr.push(  { keyword :'行唯一编号' , level : 'cell' , typeIndex: 3 ,  selectedIndex :  selectedIndex++  ,  value :'server_identity'         });
           rAttr.push(  { keyword :'关联数据' , level : 'table' , typeIndex: 3 ,  selectedIndex :  selectedIndex++  ,  value :'relatedList'         });


         }
      }
      else if (level == "cell"){
         if (typeIndex == 12){

           rAttr.push(  { keyword :'角色' , level : 'cell' , typeIndex: 5 ,  selectedIndex :  selectedIndex++  ,  value :'RoleIds'         });
           rAttr.push(  { keyword :'用户唯一编号' , level : 'cell' , typeIndex: 12 ,  selectedIndex :  selectedIndex++  ,  value :'UserId'         });
           rAttr.push(  { keyword :'用户名' , level : 'cell' , typeIndex: 5 ,  selectedIndex :  selectedIndex++  ,  value :'UserName'         });
           rAttr.push(  { keyword :'姓名' , level : 'cell' , typeIndex: 5 ,  selectedIndex :  selectedIndex++  ,  value :'XingMing'         });
           rAttr.push(  { keyword :'头像地址' , level : 'cell' , typeIndex: 5 ,  selectedIndex :  selectedIndex++  ,  value :'url'         });



         }
      }

      return rAttr;

  }



  gApp.getVariable = function(scope){

              var ret =[];

              var selectedIndex = 0;



            if (!scope.code)  scope.code ='';

            var dupeName =[];

            var rRow = /var\s+r_[a-zA-Z0-9_]{1,20}_\d+/ig;
            var rRowMatches = scope.code.match(rRow);





            if (rRowMatches){
              for(var i=0;i<rRowMatches.length;i++){

                  var mword = $.trim(rRowMatches[i]);
                    mword = mword.replace(/^[^\s]+\s*?/ig,'');
                  if (dupeName.indexOf(mword)<0){
                      dupeName.push(mword);

                      var v = mword;
                      var tIndex = 0;
                      if (mword.indexOf('_33')>0){
                         tIndex = 33;
                      }
                      else if (mword.indexOf('_35')>0){
                         tIndex = 35;
                         v = mword+ '.row';
                      }


                      ret.push({keyword : mword , value:v, selectedIndex : selectedIndex++ ,  stringFormat:'{0}.{1}' , level : 'row' , typeIndex:tIndex , class:'row' ,source :''   });
                    }
              }
            }

            var rCell = /(var|decimal\?|Guid\?|int\?|DateTime\?)\s+c_[a-zA-Z0-9_]{1,20}_\d+/ig;
            var rCellMatches = scope.code.match(rCell);

            console.log(rCellMatches);

            if (rCellMatches){
              for(var i=0;i<rCellMatches.length;i++){

                  var mword = $.trim(rCellMatches[i]);
                  mword = mword.replace(/^[^\s]+\s*?/ig,'');

                  var desc =  gApp.getTransactionDesc(scope.code,mword);





                  if (dupeName.indexOf(mword)<0){
                      dupeName.push(mword);
                  ret.push({keyword : mword , value:mword , selectedIndex : selectedIndex++ , level : 'cell' , class:'cell' ,source :'' ,desc:desc  });
                }
              }
            }

            var rTable = /\s+t_[a-zA-Z0-9_]{1,20}/ig;
            var rTableMatches = scope.code.match(rTable);
            if (rTableMatches){
              for(var i=0;i<rTableMatches.length;i++){

                var mword = $.trim(rTableMatches[i]);


                if (dupeName.indexOf(mword)<0){
                    dupeName.push(mword);

                    var v = mword;
                    var tIndex = 0;
                    if (mword.indexOf('_33')>0){
                       tIndex = 33;
                    }
                    else if (mword.indexOf('_34')>0){
                       tIndex = 34;
                       v = mword+ '.list';
                    }





                  ret.push({keyword : mword , value: v  , selectedIndex :  selectedIndex++  , level : 'table' , typeIndex : tIndex , class:'table' ,source :''   });
                }
              }
            }

            var rSet = /var\s+s_[a-zA-Z0-9_]{1,20}/ig;
            var rSetMatches = scope.code.match(rSet);
            if (rSetMatches){
              for(var i=0;i<rSetMatches.length;i++){

                var mword = $.trim(rSetMatches[i]);
                  mword = mword.replace(/^[^\s]+\s*?/ig,'');
                if (dupeName.indexOf(mword)<0){
                    dupeName.push(mword);
                    ret.push({keyword : mword , value : mword ,  selectedIndex :  selectedIndex++  , level : 'set' , class:'set' ,source :''   });
                }
              }
            }


            ret.push(
              { keyword :'当前用户' , level : 'cell' , typeIndex: 12 , class:'cUser' , selectedIndex :  selectedIndex++  , stringFormat:'{0}.{1}'  , value :'gd.user',  source:'当前用户'      },
              { keyword :'应用编号' , level : 'cell' , typeIndex: 3 , class:'companyId'  , selectedIndex :  selectedIndex++  ,value : cooConfig.configObj.companyId  },
              { keyword :'当前时间' , level : 'cell' , typeIndex: 6 , class:'DateTime'   ,  selectedIndex :  selectedIndex++  ,value : 'DateTime.Now'  },
              { keyword :'配置参数' , level : 'row' , typeIndex: 31 , class:'CooConfigurationDTO' , selectedIndex :  selectedIndex++  ,value: 'configs' ,stringFormat:'{0}["{1}"]'   , source:'配置参数'  },

               { keyword :'用户输入查询条件' , level : 'table' ,typeIndex: 32 ,  class:'SearchCondition' , selectedIndex :  selectedIndex++  ,source :'' ,value:'gd.lsc'   },
              { keyword :'用户输入主数据'   , level : 'row'   , typeIndex: 33 , class:'ListItemValuePair' , selectedIndex :  selectedIndex++  ,source :'' , value : 'gd.list[0]'   },
              { keyword :'用户输入批量主数据'   , level : 'table'   , typeIndex: 33 , class:'ListItemValuePair' , selectedIndex :  selectedIndex++  ,source :'' , value : 'gd.list'   },
              { keyword :'用户输入子数据'   , level : 'table' , typeIndex: 33 , class:'ListItemValuePair' , selectedIndex :  selectedIndex++  ,source :'gd.list[0].relatedList'    }
//mvcxTable ,34

          );



             return ret;


  }

  gApp.underRowChange = function(scope,c){

            var sRow = _.find(scope.underRowVariable, function(n){ return n.value == c.value1 });
            if (!sRow) return false;

            if (c.value1=='当前表'){

              var rowV = _.find( scope.transactionProperties,function(n){ return n.class=='tableParameter' });
              if (rowV &&rowV.value)
              {
                    var sData = gApp.getTableStructure(scope.code, rowV.value[0]);

                    console.log(sData);
                    var sObj = JSON.parse(sData);
                    var sKeys =  _.keys(sObj);
                    var patIds =[];
                    $(sKeys).each(function(i,j){
                         $(sObj[j]).each(function(p,q){
                                 patIds.push(q);
                         });
                    });
                    $.when(g.allpattern()).done(function(rx){

                         var subx = _.filter(cooConfig.allpattern,function(n) {
                              return       patIds.indexOf(n.ID)>=0;
                         });

                          var tableSource = [];
                          $(subx).each(function(i,j){
                             tableSource.push({label:j.pName , value: 'c'+j.ID});
                          });
                          c.source =  tableSource;
                          c.stringFormat="[]";

                          $timeout(function(){
                              $(".ui-chosen").trigger("chosen:updated");
                          },300);
                    });
              }

            }else{

            //    c.source1 = c.source;

                c.value =  (sRow && sRow.stringFormat) ? sRow.stringFormat.replace(/\{0\}/ig,sRow.value): sRow.value;
                c.stringFormat = sRow.stringFormat;
                if (sRow.class=='row'){

              //    var sData = gApp.getTableStructure(scope.code, 'r_'+sRow.keyword);


                   gApp.underRowPattern(scope,    'r_'+sRow.keyword ,c );



                    console.log(c);
                    console.log(sRow);



                }else {
                    c.source = scope.groupSource[sRow.source];
                }





                $timeout(function(){
                    $(".ui-chosen").trigger("chosen:updated");
                },300);

            }

  }


   gApp.getVariableUnderRow = function(scope){

       return _.filter(gApp.getVariable(scope),function(n) { return n.level=='row' || n.level == 'cell' });


   }

   gApp.foldCode = function(scope){
     var doc =scope._editor.getDoc();
     var A1 = scope._editor.getCursor();
     var lineContent1 = doc.getLine(A1.line);

     var currentTransaction='';
     var halfTransaction ='';

       if (lineContent1.indexOf("<cname")>=0){

         var lineContent =  gApp.getDocLine(doc,A1);
         var id = g.lineProperty(lineContent,"id");

         console.log(lineContent);
         console.log(id);

         scope.currentId = id;
         scope.currentIndex = g.lineProperty(lineContent,"index");

         var rex = new RegExp("\\/\\/\\/<transaction\\s*\?id\\s*\?=\\s*\?\""+scope.currentId+"\"\\s*\?[\\S\\s]*\?$");
         var f =rex.exec(scope.code);


         if (f && f.length>0){
        //    tranIndex = f.index;
            currentTransaction = f[0];
            halfTransaction= f[0];

            currentTransaction = g.getNestedRegString(currentTransaction,'<transaction'  ,'<\/transaction>',true);

          }

          //doc.posFromIndex

          var idx =  scope.code.indexOf(currentTransaction);



          var  docPosStart =  doc.posFromIndex(idx);
          var docPosEnd = doc.posFromIndex(idx + currentTransaction.length);


          return {
             startLine :  docPosStart.line,
             endLine :docPosEnd.line

          };





       }

   }


   gApp.setTransactionModal = function(scope){

     var doc =scope._editor.getDoc();
     var A1 = scope._editor.getCursor();
     var lineContent1 = doc.getLine(A1.line);

     if (lineContent1.indexOf("\/\/\/点击此行替换")>=0){

          scope.addTransaction = false;



          var lineContent =  gApp.getDocLine(doc,A1);
          var id = g.lineProperty(lineContent,"id");
          var set = g.lineProperty(lineContent,"set");
          var namespace =   g.lineProperty(lineContent,"namespace");

          scope.currentId = id;

          if (!set && !namespace) {
            g.modal1('无可用替换!');
            return false;
          }

         if ( set){

           var parentNameSpace = namespace.replace(/\.[^\.]+$/ig,'');

           var namespaceLsc = [{patternId:473, val1: ","+set+",", pTypeId:5, operation:6}];
           var pageId =1;
           var modalInstance = $modal.open({
                templateUrl: 'tpl/admin/transaction_modal.html?'+cooConfig.configObj.version,
                controller: 'admin_transaction_modal_instance_ctrl',
                size: 'lg',
                resolve:
                      g.load([],
                      function(){},
                      {
                        pageId: function(){ return pageId},
                        modal_lsc: function() { return namespaceLsc}
                      }
                     )

              });

              modalInstance.result.then(function (row) {
                  scope.selectTransaction(row,[]);
              }, function () {
               //$log.info('Modal dismissed at: ' + new Date());
              });
         }
         else{


           scope.currentSet =set;

           var lsc =[ {patternId: 22, val1: set , pTypeId: 5, operation: 6 } ];
           var modal_lsc = [];


           var  etor ={"companyId":1000,"cid":3,"id":21,"lsc":lsc,"iindex":1,"isize": 100,
            url : "https://center.mvcx.net/list/ajxlist2"   }   ;

            g.show_ajax();
            $.when(rest.remote_data(etor,"proxy")).done(function(retx){
                   var dx = JSON.parse(retx.data);
                   var k =1;
                   if (dx.data.length>0){


                          if (lineContent.indexOf('component')>0){
                            $(dx.data).each(function(p,q){

                              var md =    q.__c226.split('.');
                              var name = md[md.length-1];
                              var namespace = q.__c226.replace(/\.[^\.]+$/ig,'');

                              var op =1;
                              if (k!=1) op =11;
                               modal_lsc.push({patternId: 224, val1: namespace, pTypeId: 5, operation: op,findex:k});
                               modal_lsc.push({patternId: 53, val1: name, pTypeId: 5, operation: 1,findex: 100*k + 1});
                               k++;
                            });
                            var modalInstance = $modal.open({
                                 templateUrl: 'tpl/admin/component_modal.html?'+cooConfig.configObj.version,
                                 controller: 'admin_component_modal_instance_ctrl',
                                 size: 'lg',
                                 resolve:
                                       g.load([],
                                       function(){},
                                       {
                                         pageId: function(){ return 1},
                                         modal_lsc: function() { return modal_lsc}
                                       }
                                      )
                               });

                               modalInstance.result.then(function (row) {
                                  scope.selectComponent(row,[]);
                               }, function () {
                                //$log.info('Modal dismissed at: ' + new Date());
                               });
                          }

                          if (lineContent.indexOf('function')>0){
                            $(dx.data).each(function(p,q){

                              var md =    q.__c226.split('.');
                              var name = md[md.length-1];
                              var namespace = q.__c226.replace(/\.[^\.]+$/ig,'');

                              var op =1;
                              if (k!=1) op =11;
                               modal_lsc.push({patternId: 218, val1: namespace, pTypeId: 5, operation: op,findex:k});
                               modal_lsc.push({patternId: 67, val1: name, pTypeId: 5, operation: 1,findex: 100*k + 1});
                               k++;
                            });
                            var modalInstance = $modal.open({
                                 templateUrl: 'tpl/admin/function_modal.html?'+cooConfig.configObj.version,
                                 controller: 'admin_function_modal_instance_ctrl',
                                 size: 'lg',
                                 resolve:
                                       g.load([],
                                       function(){},
                                       {
                                         pageId: function(){ return 1},
                                         modal_lsc: function() { return modal_lsc}
                                       }
                                      )
                               });

                               modalInstance.result.then(function (row) {
                                  scope.selectFunction(row,[]);
                               }, function () {
                                //$log.info('Modal dismissed at: ' + new Date());
                               });
                          }
                   }
            });

         }
     }
   }



    /// 组件可选集合， 函数可选集合
    gApp.setModal = function(scope){

      var doc =scope._editor.getDoc();
      var A1 = scope._editor.getCursor();
      var lineContent1 = doc.getLine(A1.line);

      if (lineContent1.indexOf("\/\/\/点击此行替换")>=0){

           scope.addComponent = false;

           var lineContent = doc.getLine(A1.line-2);
           var id = g.lineProperty(lineContent,"id");
           var set = g.lineProperty(lineContent,"set");

           scope.currentId = id;

           if (!set) {
             g.modal1('无可用替换!');
             return false;
           }
           scope.currentSet =set;

           var lsc =[ {patternId: 22, val1: set , pTypeId: 5, operation: 6 } ];
           var modal_lsc = [];


           var  etor ={"companyId":1000,"cid":3,"id":21,"lsc":lsc,"iindex":1,"isize": 100,
            url : "https://center.mvcx.net/list/ajxlist2"   }   ;

            g.show_ajax();
            $.when(rest.remote_data(etor,"proxy")).done(function(retx){
                   var dx = JSON.parse(retx.data);
                   var k =1;
                   if (dx.data.length>0){


                          if (lineContent.indexOf('component')>0){
                            $(dx.data).each(function(p,q){

                              var md =    q.__c226.split('.');
                              var name = md[md.length-1];
                              var namespace = q.__c226.replace(/\.[^\.]+$/ig,'');

                              var op =1;
                              if (k!=1) op =11;
                               modal_lsc.push({patternId: 224, val1: namespace, pTypeId: 5, operation: op,findex:k});
                               modal_lsc.push({patternId: 53, val1: name, pTypeId: 5, operation: 1,findex: 100*k + 1});
                               k++;
                            });
                            var modalInstance = $modal.open({
                                 templateUrl: 'tpl/admin/component_modal.html?'+cooConfig.configObj.version,
                                 controller: 'admin_component_modal_instance_ctrl',
                                 size: 'lg',
                                 resolve:
                                       g.load([],
                                       function(){},
                                       {
                                         pageId: function(){ return 1},
                                         modal_lsc: function() { return modal_lsc}
                                       }
                                      )
                               });

                               modalInstance.result.then(function (row) {
                                  scope.selectComponent(row,[]);
                               }, function () {
                                //$log.info('Modal dismissed at: ' + new Date());
                               });
                          }

                          if (lineContent.indexOf('function')>0){
                            $(dx.data).each(function(p,q){

                              var md =    q.__c226.split('.');
                              var name = md[md.length-1];
                              var namespace = q.__c226.replace(/\.[^\.]+$/ig,'');

                              var op =1;
                              if (k!=1) op =11;
                               modal_lsc.push({patternId: 218, val1: namespace, pTypeId: 5, operation: op,findex:k});
                               modal_lsc.push({patternId: 67, val1: name, pTypeId: 5, operation: 1,findex: 100*k + 1});
                               k++;
                            });
                            var modalInstance = $modal.open({
                                 templateUrl: 'tpl/admin/function_modal.html?'+cooConfig.configObj.version,
                                 controller: 'admin_function_modal_instance_ctrl',
                                 size: 'lg',
                                 resolve:
                                       g.load([],
                                       function(){},
                                       {
                                         pageId: function(){ return 1},
                                         modal_lsc: function() { return modal_lsc}
                                       }
                                      )
                               });

                               modalInstance.result.then(function (row) {
                                  scope.selectFunction(row,[]);
                               }, function () {
                                //$log.info('Modal dismissed at: ' + new Date());
                               });
                          }
                   }
            });
      }
    }


    ///组件编辑时，保护按钮函数
     gApp.protectButtonFunction = function(s,currentId, id ,componentProperties , buttonFunctionStr ){

       var rex = new RegExp("\\/\\/\\/<section\\s*\?id\\s*\?=\\s*\?\""+currentId+"[\\S\\s]*\?\\/\\/\\/<\\/section>");
       var m1 =rex.exec(s);
       if (m1 && m1.length>0 && currentId){
         var funcxs = [];
         var sectionStr = m1[0];
         var rfuncx = new RegExp("\\/\\/\\/<function[^<>]*?>[\\S\\s]*\?\\/\\/\\/<\\/function>");
         var mfuncx =  rfuncx.exec(sectionStr);
         $(mfuncx).each(function(i,j){
               var mid = g.lineProperty(j,'id');
               funcxs.push({key:mid,value:j});
         });

         $(componentProperties).each(function(i, j) {
             $(j.children).each(function(p, q) {
                var rgx = new RegExp('<<' + q.keyword + '>>','ig');
                buttonFunctionStr = buttonFunctionStr.replace(rgx, q.val);
             });
         });
         var k=0;
         buttonFunctionStr = buttonFunctionStr.replace(rfuncx,function(match, contents, ss, offset){
              return funcxs[k++].value;
         });

         s = s.replace(rex,function(m,c,s,f){
            return "\/\/\/<section id=\"" + id + "\" >" +  buttonFunctionStr + '\/\/\/<\/section>';
         });
         return s;

       }else {

          s = s.replace(/\/\/\/<\/buttonFunctions>/ig,
            "\/\/\/<section id=\"" + id + "\" >" +  buttonFunctionStr + '\/\/\/<\/section>\r\n \/\/\/<\/buttonFunctions>');
          return s;
       }
     }

     ///编辑组件，函数，事务
      gApp.editCode = function(scope){

        var doc = scope._editor.getDoc();
        var A1 = scope._editor.getCursor();

        var lineContent1 = doc.getLine(A1.line);

        if (lineContent1.indexOf("点击此行编辑")>=0) {

            // console.log(lineContent1.indexOf("\/\/\/点击此行编辑组件"));
            // console.log(lineContent1 );

           if (lineContent1.indexOf("点击此行编辑组件")>=0){
             console.log('组件');
             gApp.editComponent(scope);
           }
           if (lineContent1.indexOf("点击此行编辑函数")>=0){
             gApp.editFunction(scope);
           }
         }

      }


      ///编辑组件
      gApp.editComponent = function(scope){
          $('.nav-tabs2 a[data-target="#tab_1"]').tab('show');
          var doc = scope._editor.getDoc();
          var A1 = scope._editor.getCursor();

          scope.activeTab="component"
          scope.addComponent = false;
          scope.currentCursor =A1;
          var lineContent = doc.getLine(A1.line-1);

          var id = g.lineProperty(lineContent,"id");
          scope.currentId = id;
          var name =  g.lineProperty(lineContent,"name");
          var namespace =  g.lineProperty(lineContent,"namespace");


          var lsc =[ {patternId: 53, val1: name, pTypeId: 5, operation: 1},
          {patternId: 224, val1: namespace, pTypeId: 5, operation: 1}];


          var  etor ={"companyId":1000,"cid":6,"id":42,"lsc":lsc,"iindex":1,"isize": 1,
           url : "https://center.mvcx.net/list/ajxlist2"   }   ;

           g.show_ajax();
           $.when(rest.remote_data(etor,"proxy")).done(function(retx){


                var rex = new RegExp("<component\\s*\?id\\s*\?=\\s*\?\""+id+"[\\S\\s]*\?<\\/content>");
                var f =rex.exec(scope.code);
                var rargs=[];
                if (f&&f[0]){
                  var rb = g.angleBrackets(f[0],"content");
                    rargs = JSON.parse(rb);
                }
                var dx = JSON.parse(retx.data);
                if (dx.data.length>0){
                   scope.selectComponent(dx.data[0], rargs);
                }
           });
      }

        ///编辑函数
      gApp.editFunction = function(scope){
          $('.nav-tabs2 a[data-target="#tab_2"]').tab('show');

          var doc = scope._editor.getDoc();
          var A1 = scope._editor.getCursor();

          scope.activeTab = "function";
          scope.addFunction = false;
          scope.currentCursor =A1;
          var lineContent = doc.getLine(A1.line-1);

          var id = g.lineProperty(lineContent,"id");
          scope.currentId = id;
          var name =  g.lineProperty(lineContent,"name");
          var namespace =  g.lineProperty(lineContent,"namespace");


          var lsc =[ {patternId: 67, val1: name, pTypeId: 5, operation: 1},
          {patternId: 218, val1: namespace, pTypeId: 5, operation: 1}];


          var  etor ={"companyId":1000,"cid":7,"id":49,"lsc":lsc,"iindex":1,"isize": 1,
           url : "https://center.mvcx.net/list/ajxlist2"   }   ;

           g.show_ajax();
           $.when(rest.remote_data(etor,"proxy")).done(function(retx){

                var rex = new RegExp("\\/\\/\\/<function\\s*\?id\\s*\?=\\s*\?\""+id+"[\\S\\s]*\?\\/\\/\\/<\\/content>");
                var f =rex.exec(scope.code);
                var rargs=[];
                if (f&&f[0]){
                  var rb = g.angleBrackets(f[0],"content");
                     rargs = JSON.parse(rb);
                }
                var dx = JSON.parse(retx.data);
                if (dx.data.length>0){
                   scope.selectFunction(dx.data[0], rargs);
                }
           });
      }


    gApp.selectFunction = function(scope,row,vals){

               console.log(row);

               scope.funcx = row;
               scope.funcx.__c76 = $sce.trustAsHtml(scope.funcx.__c76);
               if (scope.funcx.__c74) {
                  $('.script').replaceWith("<div class=\"script\"><script type=\"text/javascript\">" + scope.funcx.__c74 + "</script></div>");
               }
               var obj = JSON.parse(scope.funcx.__c73);

               var pg = _.find(cooConfig.allpage, function(n) {
                  return n.ID == parseInt(scope.pageId)
               });
               var args = [];
               var promises = [];


               var objSource1 = _.find(obj, function(n) {
                  return n.source && n.source != 'pats' && n.source != 'pageElements'
               });
               var objPattern = _.find(obj, function(n) {
                  return n.source == 'pats'
               });
               var objElement = _.find(obj, function(n) {
                  return n.source == 'pageElements'
               });
               var objCategory = _.find(obj, function(n) {
                  return n.source == 'categories'
               });

              if (objPattern) {
                 promises.push(g.allpattern());
              }


              if (objElement) {
                  promises.push(g.pageElements2(scope.selectedPages));
              }


               var clsc =[{
                   patternId: 22,
                   val1: 'functionBase',
                   pTypeId: 5,
                   operation: 6
               }];

               if (scope.currentGroup){
                  clsc.push({
                      patternId: 22,
                      val1: scope.currentGroup,
                      pTypeId: 5,
                      operation: 16
                  });
               }
               var fg = [];
               $(obj).each(function(i,j){
                    if (j.functionSource){
                        if (fg.indexOf(j.functionSource)<0){
                           fg.push(j.functionSource);
                        }
                    }
               });

               if (fg){
                   $(fg).each(function(i,j){
                       clsc.push({
                           patternId: 22,
                           val1: j,
                           pTypeId: 5,
                           operation: 16
                       });
                   });
               }

            //   if (objSource1 || scope.currentGroup) {
                  var etor = {
                      "companyId": 1000,
                      "cid": 3,
                      "id": 21,
                      "lsc":clsc,
                      "iindex": 1,
                      "isize": 300,
                      url: "https://center.mvcx.net/list/ajxlist2"
                  };
                  promises.push(rest.remote_data(etor, "proxy"));
            //   }

               $.when.apply($, promises).done(function() {


                  var transactionList = JSON.parse(arguments[promises.length - 1].data).data;
                  console.log(transactionList);

                  var transGroup = _.groupBy(transactionList, function(n) {
                      return n.__c256
                  });

                  console.log(transGroup);
                  scope.groupFunctions = transGroup;

                  var groupSource = {};

                  $(_.keys(transGroup)).each(function(i, j) {
                      var row = {
                          label: j,
                          children: []
                      };
                      $(transGroup[j]).each(function(p, q) {
                          row.children.push({
                              label: q.__c21,
                              value: q.__c226,
                              type : q.__c22
                          });
                      });
                      groupSource[j] = [];
                      groupSource[j].push(row);
                  });


                  if (objPattern) {
                      groupSource['pats'] = []; // arguments[0];
                      groupSource['pats']['source1'] = 'pats';
                  }
                  if (objElement) {
                      var ii=0;
                      if (objPattern) ii=1;
                      groupSource['pageElements'] = arguments[ii];
                  }

                  console.log(groupSource);
                  console.log(cooConfig.allpattern);
                  // scope.elementList();

                  $(obj).each(function(i, j) {
                      if (j.source) {
                          j.source = groupSource[j.source];
                          if (j.pTypes)
                          j.pTypes =  j.pTypes.split(',');
                      }
                      if (j.functionSource) {
                          j.functionSource = groupSource[j.functionGroup];
                      }
                  });

                  scope.functionProperties = [];
                  var gobj = _.groupBy(obj, function(n) {
                      return n.group
                  });


                  $(_.keys(gobj)).each(function(i, j) {
                      var k = (j != 'undefined') ? (j + '_0') : '无分组';

                      if (k.indexOf('_') > 0) {
                          $(gobj[j]).each(function(x, y) {
                              //  console.log(y);
                              y.keyword = y.keyword + '_0';
                              console.log(y);
                          });
                      }

                      scope.functionProperties.push({
                          key: k,
                          children: gobj[j],
                          order: i
                      });
                  });



                  console.log(scope.functionProperties);
                  if (vals.length > 0) {
                      $(vals).each(function(v, w) {
                          var tx = _.find(scope.functionProperties, function(n) {
                              return n.key == w.key
                          });
                          if (tx) {
                              for (var c = 0; c < w.value.length; c++) {

                                  if (typeof (w.value[c]) == 'object'){
                                       $(_.keys(w.value[c])).each(function(i,j){
                                         tx.children[c][j]=  w.value[c][j];
                                       });

                                  }else{
                                      tx.children[c].value = w.value[c];
                                  }
                              }
                          } else {
                              var ty = _.find(scope.functionProperties, function(n) {
                                  return n.key == w.key.replace(/\d+$/ig, '0')
                              });
                              var tn = {
                                  key: w.key,
                                  children: [],
                                  order: ty.order
                              };
                              $(ty.children).each(function(i, j) {
                                  tn.children.push({
                                      ftype: j.ftype,
                                      group: j.group,
                                      keyword: j.keyword.replace(/0$/ig, w.key.replace(/\D/ig, '')),
                                      source: j.source,
                                      stype: j.stype,
                                      type: j.type,
                                      value: w.value[i],
                                  });
                              });
                              scope.functionProperties.push(tn);
                          }
                      });
                  }
                  scope.functionProperties = _.sortBy(scope.functionProperties, 'order');
                  scope.functionProperties = _.sortBy(scope.functionProperties, 'name');


                  console.log(scope.functionProperties);

                  $timeout(function() {
                      var g1 = _.find(scope.functionProperties, function(n) {
                          return n.key.indexOf('_') < 0
                      });
                      if (g1) {
                          var c1 = _.find(g1.children, function(n) {
                              return n.keyword == '分类限定'
                          });
                          if (c1){

                              $.when(g.allpattern()).done(function(rx) {
                                  var subRx = _.filter(rx, function(n) {
                                      return c1.value.indexOf(n.c.toString()) >= 0
                                  });
                                  $(scope.functionProperties).each(function(i, j) {
                                      $(j.children).each(function(p, q) {
                                          if (q.source && q.source.source1 == "pats") {
                                              q.source = subRx;
                                              q.source['source1'] = "pats";
                                          }
                                      });
                                  });
                                  $('.multi-element').multiselect('dataprovider', subRx);

                                  $('.multi-element').each(function(i, j) {
                                      var v = $(j).attr('val');
                                      if (!v) v = "[]";
                                      $(j).multiselect('select', JSON.parse(v));

                                  });




                                  scope.$$phase || scope.$apply();
                                  $(".ui-chosen").trigger("chosen:updated");
                              })
                            }
                      }
                  }, 300);




                  scope.$$phase || scope.$apply();
                  g.hide_ajax();




               });

    }


   gApp.addImports = function(scope){

      var rex = new RegExp("\\/\\/\\/<imports>[\\S\\s]*\?\\/\\/\\/<\\/imports>");
      var rline = new RegExp("import\s*?([a-zA-Z0-9_]+)",'ig');
      var lines=[];
      var checks =[];
      scope.importStr.replace(rline,function(match,g1,g2){
          lines.push(match);
          checks.push(g1);
      });


      var f =rex.exec(scope.code);
      if (f&& f.length>0){
         $(checks).each(function(i,j){
              if (f[0].indexOf(' '+j+' ')<0){
               scope.code =scope.code.replace(/\/\/\/<\/imports>/ig, lines[i] + '\r\n \/\/\/<\/imports>');
              }
         });
      }
   }




     gApp.codeGenerate = function(scope,codeType,pats) {

             var rawCode = pats[0];
             var rawName = pats[1];
             var rawNumber = pats[2];
             var rawNamespace = pats[3];

             var addType = 'add' + codeType.charAt(0).toUpperCase() + codeType.slice(1);
             var cProperties = codeType + 'Properties';

             var currentTransaction ='';
             var halfTransaction = '';
             var repeatTransaction = '';

             var tranIndex = 0;

             if (!scope.code)  scope.code ='';

             var repeatIndex = 0;

             console.log(scope.currentIndex);
             console.log(scope.currentId);



             var rex = new RegExp("\\/\\/\\/<"+codeType+"\\s*\?id\\s*\?=\\s*\?\""+scope.currentId+"\"\\s*\?index=\""+ scope.currentIndex+"\"[\\S\\s]*\?$");


            if (scope.currentIndex == undefined || scope.currentIndex==0){
               console.log('undefined');
                rex = new RegExp("\\/\\/\\/<"+codeType+"\\s*\?id\\s*\?=\\s*\?\""+scope.currentId+"\"\\s*\?[\\S\\s]*\?$");
            }

             var f =rex.exec(scope.code);

             var rIndex = new RegExp("\\/\\/\\/<"+codeType+"\\s*\?id\\s*\?=\\s*\?\""+scope.currentId+"[\\S\\s]*\?index=([\\S]*)");
             var findex =rIndex.exec(scope.code);
             //

              if (findex && findex[0] && findex[1]){
                repeatIndex =  parseInt(findex[1].replace(/\D/,''));

              }
              console.log(rex);
              console.log(f);



             if (f && f.length>0){
                tranIndex = f.index;
                currentTransaction = f[0];
                halfTransaction= f[0];
                 console.log(currentTransaction);
                currentTransaction = g.getNestedRegString(currentTransaction,'<'+codeType ,'</'+codeType+'>',true);

                console.log(currentTransaction);
                console.log(codeType);

                if (gApp.checkRepeat(currentTransaction)){
                  repeatTransaction = "\r\n///点击此行重复";
                }
                 console.log(currentTransaction);
             }





             var sections = [];
             var rsection = new RegExp("<section[^<>]*?>[\\S\\s]*\?\\/\\/\\/<\\/section>","mgi");

             var msection = g.getNestedRegArrayString(currentTransaction,'<section','</section>');




             $(msection).each(function(i,j){
                   var mid = g.lineProperty(j,'id');
                   sections.push({key:mid,value:j});
             });

            console.log(msection);

            console.log(sections);


            var sectStr1 = gApp.getSect(currentTransaction);
            var sectS1 = g.angleBrackets(sectStr1,'sect');

            var sect1 = {};
            if (sectS1)  sect1 = JSON.parse(sectS1);

            console.log(sectS1);






              var s = scope[codeType][rawCode] ;//.transaction.__c244;
              console.log(scope[cProperties]);




              $(scope[cProperties]).each(function(i,j){
                  j.val = j.value;
                  if (j.list){
                     $(j.list).each(function(p,q){
                        q.val = q.value;
                     });
                  }
              });




              var content = [];
              var ks = _.filter(scope[cProperties], function(n) {
                   return  n.keyword.indexOf('_0')>0
              });

              console.log(scope[cProperties]);






              $(ks).each(function(i, j) {
                  var ks2 = _.filter(scope[cProperties], function(n) {
                    var v1 = n.keyword;
                    var v2 = j.keyword.replace(/\d+$/ig, '');

                    console.log(v1.indexOf(v2));


                      return v1.indexOf(v2) >=0 ;// n.key.startsWith(j.key.replace(/\d+$/ig, ''));
                  });

                  var rcode = new RegExp("\\/\\/\\/<repeat[^<>]+group=\""+j.keyword.replace(/_\d+$/ig, '')+"\"[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/repeat>", "g");

                  var rid = new RegExp("id=\"[0-9a-zA-Z-]{36}\"(\\s*?index=[\\S]+)?","g");

                   s = s.replace(rcode, function(match, contents, ss, offset) {





                      var blockCode = "\/\/\/<repeat group=\"" + j.keyword.replace(/_\d+$/ig, '') + "\">";
                      console.log(ks2);
                      for (var x = 0; x < ks2.length; x++) {

                            var c2 = contents.replace(rid,function(mmatch,ccontents,sss,ooffset){
                                var spx = ' ';
                                if (mmatch.indexOf('index')>=0) spx='';
                                 return  mmatch.replace(/index=.+$/ig,'') +spx + "index=\""+x+"\"";
                            });
                            blockCode += c2.replace(/>>/ig, '_' + x.toString() + '>>');

                      }


                      console.log(blockCode);



                      return blockCode + "\/\/\/</repeat>";
                  });


              });
              console.log(s);


              if (typeof (scope.codeGenerate1) !='undefined'){
                 scope.codeGenerate1(cooConfig,g,gApp);
              }







              $(scope[cProperties]).each(function(i, j) {

                console.log(j);

                  content.push({
                    key: j.keyword,
                    value: j.value
                  });
                  if (!j.list){
                      s =s.replace(new RegExp('<<' + j.keyword + '>>', 'g'), j.val);
                       console.log(j.notes,'2');
                  }
                  else{

                     $(j.list).each(function(p,q){
                         console.log(q.keyword,q.val);

                         console.log(j.notes);

                         s = s.replace(new RegExp('<<' + q.keyword + '>>', 'g')  , q.val);
                     })
                  }

                  if (j.structure){

                    console.log(j);

                    s = s.replace(new RegExp('\\/\\/\\/<structure\\s*\?name="'+j.keyword+'"\\s*\?>[\\s\\S]*\?<\\/structure>', 'g')  ,
                     '///<structure name="'+j.keyword+'" >'  +  j.structure  +   '</structure>'   );



                  }


              });

    //release protected data
              if (!scope[addType]){

                  s= s.replace(rsection,function(match, contents, ss, offset){
                   //     console.log(match);
                        var blockCode =match;
                        var cid = g.lineProperty(match,'id');
                        if (cid ) {
                     //     console.log(sections);
                     //     console.log(cid);
                          var c2 =_.find(sections,function(n){ return n.key== sect1[cid.toString()];  });
                     //     console.log(c2);
                          if (c2) blockCode = c2.value;
                        }
                   //     console.log(blockCode);
                        return blockCode;

                  });

              }
              console.log(s);

              var sect = null;
              if (scope[addType]){

                 sect ={};

                var xid = new RegExp("[0-9a-zA-Z-]{36}","g");
                 s = s.replace(xid, function(match, contents, ss, offset) {
                        sect[match] =   g.guid();
                       return sect[match];

                 });
              }

              var tDesc = _.find(scope[cProperties],function(n) { return n.keyword=='备注' });
              var textDesc ='';
              if (tDesc){
                textDesc = tDesc.value;
              }




              var gid =  scope.currentId;  // g.guid();  keep gid;
              var cIndex = scope.currentIndex;
              var sectStr ='';
              if (scope[addType] && sect){
                  sectStr = ' \r\n ///<sect>' + JSON.stringify(sect) + '</sect>';
              }
              else{
                 sectStr = ' \r\n ///<sect>' + sectS1 + '</sect>';
              }


              if (!gid) gid = g.guid();
              if (!cIndex) cIndex = 0;

              var d = g.dateFormat(new Date(), {
              property: {
                 type: "datetime"
              }
              });
              var s_start = "///<"+codeType+" id=\"" + gid + "\" index=\"" + cIndex + "\" name=\"" + scope[codeType][rawNumber] + "\" namespace=\"" +  scope[codeType][rawNamespace] + "\"   > \r\n ///<cname>" + textDesc + "</cname>  \r\n  ///点击此行编辑   "+ repeatTransaction +"\r\n  ///点击此行删除 " +
          sectStr +   " \r\n ///<content>" + JSON.stringify(content) + "</content>";
              if (scope.notes) { s_start += "\r\n " + scope.notes }

              s_start += "\r\n ///<datetime>" + d + "</datetime>\r\n";
              var s_end = "\r\n///</"+codeType+">\r\n";

              if (!scope[addType]) {

                  //console.log(halfTransaction);
                 //  console.log( codeType);

                  var endIndex = g.getNestedRegString(halfTransaction,'<'+codeType+'' ,'<\/'+codeType+'>',false);

                //  console.log(endIndex);

                  if (endIndex){
                     scope.code =  scope.code.slice(0,tranIndex) +s_start + s + s_end +   scope.code.slice(tranIndex + endIndex - scope.code.length);
                  }


           //   $scope.code = $scope.code.replace(rex, s_start + s + s_end);
              } else {

                 scope._editor.getDoc().replaceSelection("    \r\n\r\n" + s_start + s + s_end);

              }

              console.log(scope.currentCursor);

              $timeout(function() {
              scope.lineTest();

              if (scope.currentCursor)
                 scope._editor.getDoc().setCursor({
                     line: scope.currentCursor.line + 30,
                     ch: scope.currentCursor.ch
                 });
              }, 300);








     }

   gApp.codeGenerateComponent = function(scope){


               var currentComponent ='';
               var halfComponent = '';
               var comIndex = 0;
               var annotationType =0;

               var rex = new RegExp("(\\/\\/\\/|\\{\\/\\*)<component\\s*\?id\\s*\?=\\s*\?\""+scope.currentId+"[\\S\\s]*\?$");
               var f =rex.exec(scope.code);

               if (f&& f.length>1 && f[1]!="///"){
                   annotationType = 1;
               }



               if (f && f.length>0){
                  comIndex = f.index;
                  currentComponent = f[0];
                  halfComponent= f[0];
                   console.log(currentComponent);
                  currentComponent = g.getNestedRegString(currentComponent,'<component' ,'<\/component>',true);
                    console.log(currentComponent);
               }





               var sections = [];
               var rsection = new RegExp("\\/\\/\\/<section[^<>]*?>[\\S\\s]*\?\\/\\/\\/<\\/section>");
               var msection =  rsection.exec(currentComponent);
               $(msection).each(function(i,j){
                     var mid = g.lineProperty(j,'id');
                     sections.push({key:mid,value:j});
               });
         //      console.log(msection);




         //      console.log(sections);





                var s =scope.component.__c56;







          //      console.log(s);

                if (!scope.addComponent){
                    s= s.replace(rsection,function(match, contents, ss, offset){
                     //     console.log(match);
                          var blockCode =match;
                          var cid = g.lineProperty(match,'id');
                          if (cid ) {
                       //     console.log(sections);
                       //     console.log(cid);
                            var c2 =_.find(sections,function(n){ return n.key==cid.toString();  });
                       //     console.log(c2);
                            if (c2) blockCode = c2.value;
                          }
                     //     console.log(blockCode);
                          return blockCode;
                    });
                }
          //      console.log(s);


                $(scope.componentProperties).each(function(i,j){
                    $(j.children).each(function(p,q){
                         q.val = q.value;
                    });
                });

                var content = [];
                var ks = _.filter(scope.componentProperties, function(n) {
                     return  n.key.indexOf('_0')>0
                });


                $(ks).each(function(i, j) {
                    var ks2 = _.filter(scope.componentProperties, function(n) {
                        return n.key.startsWith(j.key.replace(/\d+$/ig, ''));
                    });
                    var rcode = new RegExp("\\/\\/\\/<repeat[^<>]+group=\""+j.key.replace(/_\d+$/ig, '')+"\"[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/repeat>", "g");
                     s = s.replace(rcode, function(match, contents, ss, offset) {


                        var blockCode = "\/\/\/<repeat group=\"" + j.key.replace(/_\d+$/ig, '') + "\">";
                        for (var x = 0; x < ks2.length; x++) {
                            blockCode += contents.replace(/>>/ig, '_' + x.toString() + '>>');
                        }
                        return blockCode + "\/\/\/</repeat>";
                    });
                });
          //      console.log(s);


                if (typeof (scope.codeGenerate1) !='undefined'){
                   scope.codeGenerate1(cooConfig,g);
                }

                   console.log(scope.componentProperties);




                $(scope.componentProperties).each(function(i, j) {

                    var childContent = [];
                    $(j.children).each(function(p, q) {
                       // console.log(s);
                       // console.log(q);
                       var rgx = new RegExp('<<' + q.keyword + '>>','ig');
                       s = s.replace(rgx, q.val);
                       var pv = q.value;
                       var a1 = _.filter(_.keys(q),function(n){ return n.indexOf('alue')>0 });
                       if (a1.length>1){
                          pv ={};
                          $(a1).each(function(x,y){
                             pv[y] = q[y];
                          });
                       }
                       childContent.push(pv);
                    });
                    content.push({
                       key: j.key,
                       value: childContent
                    });
                });

                console.log(s);



                var rimport = new RegExp("\\/\\/\\/<import[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/import>");
                var rfunction =  new RegExp("\\/\\/\\/<functions[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/functions>");
                var rbuttonfunction =   new RegExp("\\/\\/\\/<buttonFunctions[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/buttonFunctions>");
                var importStr = rimport.exec(s);
                var functionStr = rfunction.exec(s);
                var buttonFunctionStr =  rbuttonfunction.exec(s);
                if (importStr && importStr.length>1) {
                   scope.importStr =  importStr[1];
                }
                if (functionStr && functionStr.length>1) {
                   scope.functionStr = functionStr[1];
                }
                if (buttonFunctionStr && buttonFunctionStr.length>1){
                  scope.buttonFunctionStr = buttonFunctionStr[1];
                }

                s = s.replace(/\/\/\/<import[^<>]*?>([\S\s]*?)\/\/\/<\/import>/ig,'');
                s = s.replace(/\/\/\/<functions[^<>]*?>([\S\s]*?)\/\/\/<\/functions>/ig,'');
                s = s.replace(/\/\/\/<buttonFunctions[^<>]*?>([\S\s]*?)\/\/\/<\/buttonFunctions>/ig,'');





                var gid = g.guid();
                scope.gid =gid;

                var d = g.dateFormat(new Date(), {
                property: {
                   type: "datetime"
                }
                });
                var annotationStart = "///";
                var annotationEnd = "";
                if (annotationType == 1){
                   annotationStart  ="{/*";
                   annotationEnd = "*/}";
                }
                var setString ="";
                if (scope.currentSet){
                 setString = ' set="'+scope.currentSet+'"';
                }

                var s_start = annotationStart + "<component id=\"" + gid + "\"  " + setString  + " name=\"" + scope.component.__c53 + "\" namespace=\"" + scope.component.__c224 + "\"   > "+ annotationEnd +  " \r\n  "+ annotationStart +  "点击此行编辑组件  "+ annotationEnd +  "  \r\n  "+ annotationStart +  "点击此行替换组件 " +
                " "+ annotationEnd +  " \r\n "+ annotationStart +  "<content>" + JSON.stringify(content) + "</content> "+ annotationEnd  ;
                if (scope.notes) { s_start += "\r\n " + scope.notes }
                s_start += "\r\n "+ annotationStart +  "<cname>" + scope.component.__c52 + "</cname> "+ annotationEnd  ;
                s_start += "\r\n "+ annotationStart +  "<datetime>" + d + "</datetime>"+ annotationEnd +  " \r\n";
                var s_end = "\r\n "+ annotationStart +  "</component> "+ annotationEnd +  "\r\n";

                if (!scope.addComponent) {
                  var endIndex = g.getNestedRegString(halfComponent,'<component' ,'<\/component>'+annotationEnd,false);
                  if (endIndex){
                     scope.code =  scope.code.slice(0,comIndex) +s_start + s + s_end +   scope.code.slice(comIndex + endIndex - scope.code.length);
                  }
                } else {

                scope._editor.getDoc().replaceSelection("    \r\n\r\n" + s_start + s + s_end);

                }
                if (scope.importStr){
                   gApp.addImports(scope);
                   // if (scope.code.indexOf(scope.importStr)<0){
                   //    scope.code =scope.code.replace(/\/\/\/<\/imports>/ig, scope.importStr + '\r\n \/\/\/<\/imports>');
                   // }
                }

                if (scope.functionStr){
                  scope.code = gApp.protectSectionFunction(scope.code,scope.currentId,gid,scope.componentProperties,scope.functionStr);
                }

                if (scope.buttonFunctionStr){
                  scope.code = gApp.protectButtonFunction(scope.code,scope.currentId,gid,scope.componentProperties,scope.buttonFunctionStr);
                }


                scope.currentId = scope.gid;






                $timeout(function() {



                if (scope.currentCursor)
                   scope._editor.getDoc().setCursor({
                       line: scope.currentCursor.line + 30,
                       ch: scope.currentCursor.ch
                   });

                scope.lineTest();


                }, 300);







   }


    gApp.codeGenerateFuncx = function(scope){


                  var currentFunction ='';
                  var halfFunction = '';
                  var funIndex = 0;

                  var rex = new RegExp("\\/\\/\\/<function\\s*\?id\\s*\?=\\s*\?\""+scope.currentId+"[\\S\\s]*\?$");
                  var f =rex.exec(scope.code);

                  if (f && f.length>0){
                     funIndex = f.index;
                     currentFunction = f[0];
                     halfFunction = f[0];
                      //console.log(currentComponent);
                     currentFunction = g.getNestedRegString(currentFunction,'<function' ,'<\/function>',true);
                     // console.log(currentComponent);
                  }


                  var sections = [];
                  var rsection = new RegExp("\\/\\/\\/<section[^<>]*?>[\\S\\s]*\?\\/\\/\\/<\\/section>");
                  var msection =  rsection.exec(currentFunction);
                  $(msection).each(function(i,j){
                        var mid = g.lineProperty(j,'id');
                        sections.push({key:mid,value:j});
                  });
            //      console.log(msection);
            //      console.log(sections);

                   var s =scope.funcx.__c70;
             //      console.log(s);

                   if (!scope.addFunction){
                       s= s.replace(rsection,function(match, contents, ss, offset){
                        //     console.log(match);
                             var blockCode =match;
                             var cid = g.lineProperty(match,'id');
                             if (cid ) {
                          //     console.log(sections);
                          //     console.log(cid);
                               var c2 =_.find(sections,function(n){ return n.key==cid.toString();  });
                          //     console.log(c2);
                               if (c2) blockCode = c2.value;
                             }
                        //     console.log(blockCode);
                             return blockCode;
                       });
                   }
             //      console.log(s);


                   $(scope.functionProperties).each(function(i,j){
                       $(j.children).each(function(p,q){
                            q.val = q.value;
                       });
                   });

                   var content = [];
                   var ks = _.filter(scope.functionProperties, function(n) {
                        return  n.key.indexOf('_0')>0
                   });


                   $(ks).each(function(i, j) {
                       var ks2 = _.filter(scope.functionProperties, function(n) {
                           return n.key.startsWith(j.key.replace(/\d+$/ig, ''));
                       });
                       var rcode = new RegExp("\\/\\/\\/<repeat[^<>]+group=\""+j.key.replace(/_\d+$/ig, '')+"\"[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/repeat>", "g");
                        s = s.replace(rcode, function(match, contents, ss, offset) {


                           var blockCode = "\/\/\/<repeat group=\"" + j.key.replace(/_\d+$/ig, '') + "\">";
                           for (var x = 0; x < ks2.length; x++) {
                               blockCode += contents.replace(/>>/ig, '_' + x.toString() + '>>');
                           }
                           return blockCode + "\/\/\/</repeat>";
                       });
                   });
             //      console.log(s);


                   if (typeof (scope.codeGenerate1) !='undefined'){
                      scope.codeGenerate1(cooConfig,g);
                   }

                      console.log(scope.functionProperties);




                   $(scope.functionProperties).each(function(i, j) {

                       var childContent = [];
                       $(j.children).each(function(p, q) {
                          // console.log(s);
                          // console.log(q);
                          var rgx = new RegExp('<<' + q.keyword + '>>','ig');
                          s = s.replace(rgx, q.val);
                          var pv = q.value;
                          var a1 = _.filter(_.keys(q),function(n){ return n.indexOf('alue')>0 });
                          if (a1.length>1){
                             pv ={};
                             $(a1).each(function(x,y){
                                pv[y] = q[y];
                             });
                          }
                          childContent.push(pv);
                       });
                       content.push({
                          key: j.key,
                          value: childContent
                       });
                   });

                   console.log(s);



                   var rimport = new RegExp("\\/\\/\\/<import[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/import>");
                   var rfunction =  new RegExp("\\/\\/\\/<functions[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/functions>");
                   var rbuttonfunction =   new RegExp("\\/\\/\\/<buttonFunctions[^<>]*?>([\\S\\s]*\?)\\/\\/\\/<\\/buttonFunctions>");
                   var importStr = rimport.exec(s);
                   var functionStr = rfunction.exec(s);
                   var buttonFunctionStr =  rbuttonfunction.exec(s);
                   if (importStr && importStr.length>1) {
                      scope.importStr =  importStr[1];
                   }
                   if (functionStr && functionStr.length>1) {
                      scope.functionStr = functionStr[1];
                   }
                   if (buttonFunctionStr && buttonFunctionStr.length>1){
                     scope.buttonFunctionStr = buttonFunctionStr[1];
                   }

                   s = s.replace(/\/\/\/<import[^<>]*?>([\S\s]*?)\/\/\/<\/import>/ig,'');
                   s = s.replace(/\/\/\/<functions[^<>]*?>([\S\s]*?)\/\/\/<\/functions>/ig,'');
                   s = s.replace(/\/\/\/<buttonFunctions[^<>]*?>([\S\s]*?)\/\/\/<\/buttonFunctions>/ig,'');

                   var gid = g.guid();
                   scope.gid = gid;

                   var d = g.dateFormat(new Date(), {  property: {   type: "datetime"  }      });
                   var s_start = "///<function id=\"" + gid + "\" name=\"" + scope.funcx.__c67 + "\" namespace=\"" + scope.funcx.__c218 + "\"   >  \r\n  ///点击此行编辑函数 " + " \r\n  ///点击此行替换函数 " +
                   " \r\n ///<content>" + JSON.stringify(content) + "</content>";
                   if (scope.notes) { s_start += "\r\n " + scope.notes }
                   s_start += "\r\n ///<cname>" + scope.funcx.__c66 + "</cname>";
                   s_start += "\r\n ///<datetime>" + d + "</datetime>\r\n";
                   var s_end = "\r\n///</function>\r\n";

                   if (!scope.addFunction) {
                     var endIndex = g.getNestedRegString(halfFunction,'<function' ,'<\/function>',false);
                     console.log(endIndex);
                     if (endIndex){
                        scope.code =  scope.code.slice(0,funIndex) +s_start + s + s_end +   scope.code.slice(funIndex + endIndex - scope.code.length);
                     }
                   } else {

                   scope._editor.getDoc().replaceSelection("    \r\n\r\n" + s_start + s + s_end);

                   }
                   if (scope.importStr){
                      if (scope.code.indexOf(scope.importStr)<0){
                         scope.code =scope.code.replace(/\/\/\/<\/imports>/ig, scope.importStr + '\r\n \/\/\/<\/imports>');
                      }
                   }






                //   console.log(scope.code);

                   $timeout(function() {
                   // if (scope.currentCursor)
                   //    scope._editor.getDoc().setCursor({
                   //        line: scope.currentCursor.line + 30,
                   //        ch: scope.currentCursor.ch
                   //    });

                   console.log(gid);

                   scope.lineTest();


                 }, 3000);







    }

    gApp.selectComponent2 = function(scope,row,vals){


           gApp.selectCode(scope,'component',row,vals,['__c62','__c60','__c59']);


    }

    gApp.selectComponent = function(scope,row,vals){
               console.log(row);

               scope.currentGroup = "section";
               scope.component = row;
               scope.component.__c62 = $sce.trustAsHtml(scope.component.__c62);
               if (scope.component.__c60) {
                  $('.script').replaceWith("<div class=\"script\"><script type=\"text/javascript\">" + scope.component.__c60 + "</script></div>");
               }
               var obj = JSON.parse(scope.component.__c59);

               var pg = _.find(cooConfig.allpage, function(n) {
                  return n.ID == parseInt(scope.pageId)
               });
               var args = [];
               var promises = [];


               var objSource1 = _.find(obj, function(n) {
                  return n.source && n.source != 'pats' && n.source != 'pageElements'
               });
               var objPattern = _.find(obj, function(n) {
                  return n.source == 'pats'
               });
               var objElement = _.find(obj, function(n) {
                  return n.source == 'pageElements'
               });
               var objCategory = _.find(obj, function(n) {
                  return n.source == 'categories'
               });

              if (objPattern) {
                 promises.push(g.allpattern());
              }


              if (objElement) {
                  promises.push(g.pageElements2(scope.selectedPages));
              }


               var clsc =[{
                   patternId: 22,
                   val1: 'component',
                   pTypeId: 5,
                   operation: 6
               }];




               if (scope.currentGroup){
                  clsc.push({
                      patternId: 22,
                      val1: scope.currentGroup,
                      pTypeId: 5,
                      operation: 16
                  });
               }
               var fg = [];
               $(obj).each(function(i,j){
                    if (j.functionSource){
                        if (fg.indexOf(j.functionSource)<0){
                           fg.push(j.functionSource);
                        }
                    }
               });

               if (fg){
                   $(fg).each(function(i,j){
                       clsc.push({
                           patternId: 22,
                           val1: j,
                           pTypeId: 5,
                           operation: 16
                       });
                   });
               }







               if (objSource1 || scope.currentGroup) {
                  var etor = {
                      "companyId": 1000,
                      "cid": 3,
                      "id": 21,
                      "lsc":clsc,
                      "iindex": 1,
                      "isize": 300,
                      url: "https://center.mvcx.net/list/ajxlist2"
                  };
                  promises.push(rest.remote_data(etor, "proxy"));
               }

               $.when.apply($, promises).done(function() {

                  var transactionList = JSON.parse(arguments[promises.length - 1].data).data;
                  console.log(transactionList);

                  var transGroup = _.groupBy(transactionList, function(n) {
                      return n.__c256
                  });

                  console.log(transGroup);
                  scope.groupFunctions = transGroup;

                  var groupSource = {};

                  $(_.keys(transGroup)).each(function(i, j) {
                      var row = {
                          label: j,
                          children: []
                      };
                      $(transGroup[j]).each(function(p, q) {
                          row.children.push({
                              label: q.__c21,
                              value: q.__c226,
                              type : q.__c22
                          });
                      });
                      groupSource[j] = [];
                      groupSource[j].push(row);
                  });


                  if (objPattern) {
                      groupSource['pats'] = []; // arguments[0];
                      groupSource['pats']['source1'] = 'pats';
                  }
                  if (objElement) {
                      var ii=0;
                      if (objPattern) ii=1;
                      groupSource['pageElements'] = arguments[ii];
                  }

                  console.log(groupSource);
                  console.log(cooConfig.allpattern);
                  // scope.elementList();

                  $(obj).each(function(i, j) {
                      if (j.source) {
                          j.source = groupSource[j.source];
                          if (j.pTypes)
                          j.pTypes =  j.pTypes.split(',');
                      }
                      if (j.functionSource) {
                          j.functionSource = groupSource[j.functionGroup];
                      }
                  });

                  scope.componentProperties = [];
                  var gobj = _.groupBy(obj, function(n) {
                      return n.group
                  });


                  $(_.keys(gobj)).each(function(i, j) {
                      var k = (j != 'undefined') ? (j + '_0') : '无分组';

                      if (k.indexOf('_') > 0) {
                          $(gobj[j]).each(function(x, y) {
                              //  console.log(y);
                              y.keyword = y.keyword + '_0';
                              console.log(y);
                          });
                      }

                      scope.componentProperties.push({
                          key: k,
                          children: gobj[j],
                          order: i
                      });
                  });



                  console.log(scope.componentProperties);
                  if (vals.length > 0) {
                      $(vals).each(function(v, w) {
                          var tx = _.find(scope.componentProperties, function(n) {
                              return n.key == w.key
                          });
                          if (tx) {
                              for (var c = 0; c < w.value.length; c++) {

                                  if (typeof (w.value[c]) == 'object'){
                                       $(_.keys(w.value[c])).each(function(i,j){
                                         tx.children[c][j]=  w.value[c][j];
                                       });

                                  }else{
                                      tx.children[c].value = w.value[c];
                                  }
                              }
                          } else {
                              var ty = _.find(scope.componentProperties, function(n) {
                                  return n.key == w.key.replace(/\d+$/ig, '0')
                              });
                              var tn = {
                                  key: w.key,
                                  children: [],
                                  order: ty.order
                              };
                              $(ty.children).each(function(i, j) {
                                  tn.children.push({
                                      fType: j.fType,
                                      group: j.group,
                                      keyword: j.keyword.replace(/0$/ig, w.key.replace(/\D/ig, '')),
                                      source: j.source,
                                      sType: j.sType,
                                      type: j.type,
                                      value: w.value[i],
                                  });
                              });
                              scope.componentProperties.push(tn);
                          }
                      });
                  }
                  scope.componentProperties = _.sortBy(scope.componentProperties, 'order');
                  scope.componentProperties = _.sortBy(scope.componentProperties, 'name');


                  console.log(scope.componentProperties);

                  $timeout(function() {
                      var g1 = _.find(scope.componentProperties, function(n) {
                          return n.key.indexOf('_') < 0
                      });
                      if (g1) {
                          var c1 = _.find(g1.children, function(n) {
                              return n.keyword == '分类限定'
                          });
                          if (c1){

                              $.when(g.allpattern()).done(function(rx) {
                                  var subRx = _.filter(rx, function(n) {
                                      return c1.value.indexOf(n.c.toString()) >= 0
                                  });
                                  $(scope.componentProperties).each(function(i, j) {
                                      $(j.children).each(function(p, q) {
                                          if (q.source && q.source.source1 == "pats") {
                                              q.source = subRx;
                                              q.source['source1'] = "pats";
                                          }
                                      });
                                  });
                                  $('.multi-element').multiselect('dataprovider', subRx);

                                  $('.multi-element').each(function(i, j) {
                                      var v = $(j).attr('val');
                                      if (!v) v = "[]";
                                      $(j).multiselect('select', JSON.parse(v));

                                  });




                                  scope.$$phase || scope.$apply();
                                  $(".ui-chosen").trigger("chosen:updated");
                              })
                            }
                      }
                  }, 300);




                  scope.$$phase || scope.$apply();
                  g.hide_ajax();




               });

    }







    return gApp;

}]);
