angular.module('app')
.factory('g',[ 'cooConfig','rest','$sce','$state','$stateParams','$upload','$modal' ,'$timeout','JQ_CONFIG','MODULE_CONFIG' , function (cooConfig,rest,$sce,$state,$stateParams,$upload,$modal ,$timeout,JQ_CONFIG,MODULE_CONFIG) {

       var g = {};

       g.fixImagePath = function(path){
          if (!path) return path;

          return path.replace(/\/100\//ig,"\/");

       }

       g.tryParse = function(s){

           s= s.replace(/([a-z0-9]+\s*?):/ig,'"$1":');
           s= s.replace(/'/ig,'"');
           return JSON.parse(s);
       }

       function load(srcs, callback,ref_obj) {
         var ret = {
             deps: ['$ocLazyLoad', '$q',
               function( $ocLazyLoad, $q ){
                 var deferred = $q.defer();
                 var promise  = false;
                 srcs = angular.isArray(srcs) ? srcs : srcs.split(/\s+/);
                 if(!promise){
                   promise = deferred.promise;
                 }
                 angular.forEach(srcs, function(src) {
                   promise = promise.then( function(){
                     if(JQ_CONFIG[src]){
                       return $ocLazyLoad.load(JQ_CONFIG[src]);
                     }
                     angular.forEach(MODULE_CONFIG, function(module) {
                       if( module.name == src){
                         name = module.name;
                       }else{
                         name = src;
                       }
                     });
                     return $ocLazyLoad.load(name);
                   } );
                 });
                 deferred.resolve();
                 return callback ? promise.then(function(){ return callback(); }) : promise;
             }]
         }

         if (ref_obj)
         {
           var keys = _.keys(ref_obj);
           $(keys).each(function(i,j){
                 ret[j] = ref_obj[j];
           });
         }

         return ret;
       }

       g.load = function(srcs, callback,ref_obj) {
         var ret = {
             deps: ['$ocLazyLoad', '$q',
               function( $ocLazyLoad, $q ){
                 var deferred = $q.defer();
                 var promise  = false;
                 srcs = angular.isArray(srcs) ? srcs : srcs.split(/\s+/);
                 if(!promise){
                   promise = deferred.promise;
                 }
                 angular.forEach(srcs, function(src) {
                   promise = promise.then( function(){
                     if(JQ_CONFIG[src]){
                       return $ocLazyLoad.load(JQ_CONFIG[src]);
                     }
                     angular.forEach(MODULE_CONFIG, function(module) {
                       if( module.name == src){
                         name = module.name;
                       }else{
                         name = src;
                       }
                     });
                     return $ocLazyLoad.load(name);
                   } );
                 });
                 deferred.resolve();
                 return callback ? promise.then(function(){ return callback(); }) : promise;
             }]
         }

         if (ref_obj)
         {
           var keys = _.keys(ref_obj);
           $(keys).each(function(i,j){
                 ret[j] = ref_obj[j];
           });
         }

         return ret;
       }

      g.console = function(s){
          if (cooConfig.configObj.debug){
            console.log(s);
          }
      }


      g.wrapProperty = function(prop){

        // console.log(prop);
        // return false;


         if (!prop) return {};
         if (typeof(prop)==="string"){

            prop = prop.replace(/([a-z0-9]+)\s*?:(?=^\[)/ig,'"$1":').replace(/'/ig,'"');

            prop = JSON.parse(prop);
         }
         return prop;
      }

      g.cfgJson = function(key){
         var cfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key==key});
         if (!cfg) return {};
         var v = cfg.configuration_value;
         v = v.replace(/([a-z0-9]+)\s*?:/ig,'"$1":').replace(/'/ig,'"');
         return JSON.parse(v);
      }

      g.cfgTxt = function(key){
         var cfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key==key});
         if (!cfg) return '';
         var v = cfg.configuration_value;
         v = v.replace(/([a-z0-9]+)\s*?:/ig,'"$1":').replace(/'/ig,'"');
         return v;
      }



       g.fmoney=function(s, n) {
                  n = n > 0 && n <= 20 ? n : 2;
                  s = parseFloat((s + "").replace(/[^\d\.-]/g, "")).toFixed(n) + "";
                  var l = s.split(".")[0].split("").reverse(), r = s.split(".")[1];
                  t = "";
                  for (i = 0; i < l.length; i++) {
                  t += l[i] + ((i + 1) % 3 == 0 && (i + 1) != l.length ? "," : "");
                  }
                  return t.split("").reverse().join("") + "." + r;
      };

      g.humanFileSize = function(bytes, si) {
           var thresh = si ? 1000 : 1024;
           if(Math.abs(bytes) < thresh) {
               return bytes + ' B';
           }
           var units = si
               ? ['kB','MB','GB','TB','PB','EB','ZB','YB']
               : ['KiB','MiB','GiB','TiB','PiB','EiB','ZiB','YiB'];
           var u = -1;
           do {
               bytes /= thresh;
               ++u;
           } while(Math.abs(bytes) >= thresh && u < units.length - 1);
           return bytes.toFixed(1)+' '+units[u];
       }

       g.shortDate1 = function(dayd)
        {
          var y = dayd.getFullYear();
          var m = dayd.getMonth() + 1;
          var m1 = m<10? "0"+m.toString():m.toString();

          var d = dayd.getDate();
          var d1 = d<10? "0"+ d.toString():d.toString();
          return  y+'-' +m1 +'-' +d1;
        }



      g.multiSelect = function(ele,source){
          $(ele).multiselect({
              enableClickableOptGroups: true,
              enableCaseInsensitiveFiltering: true,
              includeSelectAllOption: true,
              maxHeight: 400,
              dropUp: true
            });
           $(ele).multiselect('dataprovider',source);
      }


      ///分组下拉,当前页面元素
      g.pageElements3 = function(pids){



          var ret =[];

          $(pids).each(function(i,j){
                var eles = g.pageElements(parseInt(j));
                console.log(eles);
                console.log(j);
                $(eles).each(function(p,q){
                   ret.push(q);
                });
            });

            return ret;





      }



      ///分组下拉,当前页面元素
      g.pageElements2 = function(pids){


         var dtd = $.Deferred();
          var ret =[];
          var promises =[];
          $(pids).each(function(i,j){
             promises.push(g.page_update(parseInt(j)));
          })
          $.when.apply($, promises).done(function() {

              $(pids).each(function(i,j){
                var eles = g.pageElements(parseInt(j));
                $(eles).each(function(p,q){
                   ret.push(q);
                });
            });
            console.log('xxxx1');
             console.log(ret);
              dtd.resolve(ret);
          });



          return dtd.promise();
      }

      ///分组下拉，当前页元素
      g.pageElements = function(pageId){
          var eles =[];
          console.log(pageId);
          var pgs = _.filter(cooConfig.allpage,function(n){ return n.ID ==parseInt(pageId) || n.parentId == parseInt(pageId) });
          console.log(pgs);

          $(pgs).each(function(p,q){

            var s1= g.page_pats(parseInt(q.ID));
            console.log(s1);

            var orow = {label:q.UIname,children:[]};
            orow.children =[];
            var ux=[];
            $(s1).each(function(s,t){


                orow.children.push({label: t.pName + " - " + t.pTypeId.toString(), pTypeId:t.pTypeId.toString()  ,  value:  t.ID.toString()    });


            });


            eles.push(orow);
          });
           return eles;
      }


      g.allpage = function(){

          var ret =[];


           g.init_global();


            $(cooConfig.allcategory).each(function(i,j){
               var row ={ label:j.categoryName,children:[] ,c:j.ID};
               var cpp = _.filter(cooConfig.allpage, function (n) { return n.categoryId == j.ID; });
               $(cpp).each(function(y,x){
                   row.children.push({label: "("+x.pageType+")" + x.UIname,value:x.ID,c:j.ID ,pageId:x.ID});
               })
               ret.push(row);

               //
            });
           return ret;
      }

      g.allpattern = function(){
          var dtd = $.Deferred();
          var ret =[];
          if (cooConfig.configObj.patsLoaded){
             $(cooConfig.allcategory).each(function(i,j){
                var row ={ label:j.categoryName,children:[],c:j.ID };
                var cpp = _.filter(cooConfig.allpattern, function (n) { return n.categoryId == j.ID; });
                $(cpp).each(function(y,x){
                    row.children.push({label:x.pName + '-' + x.pTypeId ,value:x.ID,c:j.ID});
                })
                ret.push(row);
                dtd.resolve(ret);
                //
             });
          }
          else {
             g.init_global();
             $.when(rest.adminList({key: "pattern"})).done(function(r){
                  cooConfig.allpattern = r;
                  cooConfig.configObj.patsLoaded =true;
                  $(cooConfig.allcategory).each(function(i,j){
                     var row ={ label:j.categoryName,children:[] ,c:j.ID};
                     var cpp = _.filter(cooConfig.allpattern, function (n) { return n.categoryId == j.ID; });
                     $(cpp).each(function(y,x){
                         row.children.push({label:x.pName + '-' + x.pTypeId,value:x.ID,c:j.ID});
                     })
                     ret.push(row);
                     dtd.resolve(ret);
                     //
                  });
             });

          }
          return dtd.promise();
      }

      g.relatedElements = function(pageId,categoryId){

            console.log(categoryId);

            var dtd = $.Deferred();
            var etor = {
                key: "element",
                categoryId:categoryId
            };
            var etorPattern = {
                key: "pattern"
            };
            var etorJoin = {
                key: "join"
                //,categoryId:categoryId
            };

            var resultx=[];
            var retPatterns =[];
            g.init_global();

            $.when(rest.adminList(etor),rest.adminList(etorPattern),rest.adminList(etorJoin)).done(function (result,patterns,joins) {
                $(result).each(function (i, o) {
                    if (o.pageId == pageId) {  resultx.push(o); };
                });

                cooConfig.allpattern = patterns;


                var j2 = [];
                var allC = [];
                allC.push(parseInt(categoryId));


                $(joins).each(function (i, o) {
                    if (o.categoryId == categoryId || o.joinCategoryId == categoryId) {
                        var jid = o.categoryId == categoryId ? o.joinCategoryId : o.categoryId;
                        j2.push(jid);

                        var cps = _.filter(patterns, function (n) { return n.categoryId == jid; });
                        var cate = _.find(cooConfig.allcategory, function (n) { return n.ID == jid });
                        retPatterns.push({ c: cate, p: cps });
                        allC.push(jid);
                    }
                });





                $(j2).each(function(f,g)
                {
                    $(joins).each(function (i, o) {

                        if (o.categoryId == g || o.joinCategoryId == g) {
                            var jid = o.categoryId == g ? o.joinCategoryId : o.categoryId;
                            var cps = _.filter(patterns, function (n) { return n.categoryId == jid; });
                            var cate = _.find(cooConfig.allcategory, function (n) { return n.ID == jid });
                            var pp = _.filter(allC, function (n) { return n == jid });

                           // console.log(pp);

                            if (pp.length == 0) {
                                retPatterns.push({ c: cate, p: cps });
                            }
                        }
                    });
                });




                var catep = _.find(cooConfig.allcategory, function (n) { return n.ID == categoryId });
                var cpp = _.filter(patterns, function (n) { return n.categoryId == categoryId; });
                retPatterns.push({ c: catep, p: cpp });

                console.log(retPatterns);

                var mypats = [];
                _.each(retPatterns,function(i,j){
                      var row ={ label:i.c.categoryName,children:[] };
                      _.each(i.p,function( x,y ){
                            row.children.push({label:x.pName,value:x.ID,c:i.c.ID});
                      });
                      mypats.push(row);
                });

                dtd.resolve(mypats);

                console.log(mypats);

            });
           return dtd.promise();
      }

      g.check_event = function(scope, funcName, data){

        var refEventId =0;
        var pe = _.find(cooConfig.allpage,function(n) { return n.ID ==scope.pageId});
        pe.pageProperty =g.wrapProperty(pe.pageProperty);
        if (pe.pageProperty.refScriptEventId){
             refEventId = pe.pageProperty.refScriptEventId;
        }





        var evt1 = _.find(cooConfig.allevent, function (n) { return n.pageId ==  scope.pageId });
        var refEvt =   _.find(cooConfig.allevent, function (n) { return n.ID==  refEventId });
        var evt ={};

        var insName = funcName + "_" + scope.pageId;


        if (evt1 && evt1.eventSource.indexOf(funcName)>=0)
        {
            return true;
        } else if (refEvt && refEvt.eventSource.indexOf(funcName)>=0){
            return true;
        }else if (window[insName]){
            return true;
        } else {
           return false;
        }

        return true;


      }


      g.init_event_ref = function(scope,refEventId ,funcName, data){

       //console.log(refEventId);
       //console.log(funcName);

       //console.log(cooConfig.allevent);

        var evt1 = _.find(cooConfig.allevent, function (n) { return n.pageId ==  scope.pageId });
        var refEvt =   _.find(cooConfig.allevent, function (n) { return n.ID==  refEventId });
        var evt ={};

        //console.log(evt1);
      //  console.log(refEvt);

        if (evt1 && evt1.eventSource.indexOf(funcName)>=0)
        {
           evt = evt1;
        } else if (refEvt && refEvt.eventSource.indexOf(funcName)>=0){
           evt =refEvt;
        }

        console.log(evt);





        if (evt&& evt.eventSource &&  evt.eventSource.indexOf(funcName)>=0)
        {
          var r1 = new RegExp( funcName + "[\\s\\S]*?return\\s*?result;");
           //var r1 =/udf_before_list_apply[\s\S]*?return\s*?result;/  ;

           //console.log(r1);
          // console.log(evt.eventSource);

           var rmatch =evt.eventSource.match(r1);

          // console.log(rmatch);
            if (rmatch && rmatch.length>0)
            {
              var r2= new RegExp( funcName + "[^\{]+\{");
              var udf_str  = rmatch[0].replace(r2,'');
              var udf_result = new Function("scope","data",udf_str);
              return  udf_result(scope,data);

            }
        }
        return '';



      }


      g.init_event = function(scope ,funcName,data){

          console.log(funcName);

          var pe = _.find(cooConfig.allpage,function(n) { return n.ID ==scope.pageId});
          pe.pageProperty =g.wrapProperty(pe.pageProperty);

          console.log(pe.pageProperty);


          if (pe.pageProperty.refScriptEventId){
             console.log('xxx1');
             return g.init_event_ref(scope,pe.pageProperty.refScriptEventId,funcName,data);
          }




          var evt = _.find(cooConfig.allevent, function (n) { return n.pageId ==  scope.pageId });

          console.log(evt);


          if (evt&& evt.eventSource.indexOf(funcName)>=0)
          {
            var r1 = new RegExp( funcName + "[\\s\\S]*?return\\s*?result;");
             //var r1 =/udf_before_list_apply[\s\S]*?return\s*?result;/  ;
             //console.log(r1);
            // console.log(evt.eventSource);

             var rmatch =evt.eventSource.match(r1);

            // console.log(rmatch);
              if (rmatch && rmatch.length>0)
              {
                var r2= new RegExp( funcName + "[^\{]+\{");
                var udf_str  = rmatch[0].replace(r2,'');
                var udf_result = new Function("scope","data",udf_str);
                return  udf_result(scope,data);

              }
          }else{
             var insName = funcName + "_" + scope.pageId;
             console.log(insName);
             if (window[insName]){
               console.log(insName);
               window[insName](scope,data);
             }
          }
          return '';
      }



       g.write_file= function(tablename, str) {

             var dtd = $.Deferred();
             var filename = cooConfig.configObj.companyId + "." + tablename;
             amplify.store(filename, str);
             dtd.resolve();
             return dtd.promise();
         };


         g.intToChinese = function( str ) {
              str = str+'';
              var len = str.length-1;
              var idxs = ['','十','百','千','万','十','百','千','亿','十','百','千','万','十','百','千','亿'];
              var num = ['零','壹','贰','叁','肆','伍','陆','柒','捌','玖'];
              return str.replace(/([1-9]|0+)/g,function( $, $1, idx, full) {
               var pos = 0;
               if( $1[0] != '0' ){
                pos = len-idx;
                if( idx == 0 && $1[0] == 1 && idxs[len-idx] == '十'){
                 return idxs[len-idx];
                }
                return num[$1[0]] + idxs[len-idx];
               } else {
                var left = len - idx;
                var right = len - idx + $1.length;
                if( Math.floor(right/4) - Math.floor(left/4) > 0 ){
                 pos = left - left%4;
                }
                if( pos ){
                 return idxs[pos] + num[$1[0]];
                } else if( idx + $1.length >= len ){
                 return '';
                }else {
                 return num[$1[0]]
                }
               }
              });
             }

        g.read_file=   function (tablename) {
              var dtd = $.Deferred();

              var filename = cooConfig.configObj.companyId + "." + tablename;

          //    console.log(cooConfig.configObj );
              var ret = amplify.store(filename);
              dtd.resolve(ret);
              return dtd.promise();
        };


       g.fetch2 = function(osTableName){
           var ret = [];
           var filename = cooConfig.configObj.companyId + "." + osTableName;
           var str = amplify.store(filename);
           if (str != undefined && str != "") {
               ret = JSON.parse(str);
           }
           return ret;

       };


        g.fetch=function(osTableName) {
            var dtd = $.Deferred();
            var ret = [];
            $.when(g.read_file(osTableName)).done(function (str) {
                if (str != undefined && str != "" && str.indexOf('[')==0) {
                    ret = JSON.parse(str);
                }
                dtd.resolve(ret);
            });
            return dtd.promise();
        }

        g.remote_cache = function(key,time){
            var dtd = $.Deferred();
            var etor = {
                cachekey: key,
                ttt: time
            };
            var t = '?t=' + Math.random();
            $.when(rest.remote_data(etor,'cache/list'+t)).done(function(ret){
                 dtd.resolve(ret);
            });
            return dtd.promise();
       };

       g.check_schema = function(osTableName, local, remote) {

        var dtd = $.Deferred();
        var c1 = g.cacheNameCompare(local, osTableName);
        var c2 = g.cacheNameCompare(remote, osTableName);
        var t = '2013-01-01';
        var updateFlag = false;

        if (osTableName == cooConfig.STATUSMAPTABLENAME) {
            c1 = g.cacheNameCompare(local, cooConfig.STATUSTABLENAME);
            c2 = g.cacheNameCompare(remote, cooConfig.STATUSTABLENAME);
        }

        if (c1.length == 0) { updateFlag = true; }
        else { if (c2.length > 0 && Date.parse(c1[0].cacheTime) != Date.parse(c2[0].cacheTime)) { updateFlag = true; } }

        if (updateFlag) {
            $.when(g.remote_cache(osTableName, t)).done(function (data) {
                  if (data.add.length > 0) {
                         $.when(g.write_file(osTableName, JSON.stringify(data.add))).done(function () {
                          dtd.resolve(true);
                      });
                } else {
                    dtd.resolve(false);
                }
            });
        }
        else {
            dtd.resolve(false);
        }

        return dtd.promise();
    };

    g.cacheNameCompare= function($list, $name) {
        if (!$list) return false;
        return $list.filter(function (v) {
            return v.cacheName.toLowerCase() == $name.toLowerCase();
        });
    }





   g.global_cache_check=function(r_cache,user,force){
         var key="page";
         var dtd = $.Deferred();

          if (force){
             dtd.resolve(true);
             return dtd.promise();
          }

         $.when(g.fetch(cooConfig.CACHETABLENAME)).done(function(l_cache){
                 var  c1 = g.cacheNameCompare(r_cache, key);
                 var  c2 = g.cacheNameCompare(l_cache, key);
                 var last_user = g.fetch2("last_login_user");

                 if (last_user.RoleIds!=user.RoleIds)
                 {
                       dtd.resolve(true);
                 }


                 if (c2.length == 0) {
                     dtd.resolve(true);
                  }
                 else {
                     if (!c1||!c1[0])
                     {
                       dtd.resolve(false);
                     }
                     else {
                       if (c2.length > 0 && Date.parse(c1[0].cacheTime) != Date.parse(c2[0].cacheTime)) { dtd.resolve(true); }
                     }
                 }
                 dtd.resolve(false);
         });
         return dtd.promise();
   };

     g.global_cache_update = function(r_cache,user){
       var dtd = $.Deferred();
        $.when(g.global_cache_update2(r_cache,user,false)).done(function(){
                dtd.resolve();
        });
        return dtd.promise();
     };

     g.global_cache_update1 = function(r_cache,user){
         var dtd = $.Deferred();
          $.when(g.global_cache_update2(r_cache,user,true)).done(function(){
                  dtd.resolve();
          });
          return dtd.promise();
     };

     g.global_cache_update2 = function(r_cache,user,force){
          var dtd = $.Deferred();
          $.when(g.global_cache_check(r_cache,user,force)).done(function(ret){
                if (ret){
                    $.when(rest.global_cache()).done(function(gb){




                         g.write_file(cooConfig.EVENTTABLENAME,JSON.stringify(gb._event));
                         g.write_file(cooConfig.CATEGORYTABLENAME,JSON.stringify(gb.category));
                         g.write_file(cooConfig.CONFIGURATIONTABLENAME,JSON.stringify(gb.configuration));
                         g.write_file(cooConfig.CUSERTABLENAME,JSON.stringify(gb.cuser));
                         g.write_file(cooConfig.DEPARTMENTTABLENAME,JSON.stringify(gb.department));
                         g.write_file(cooConfig.GROUPTABLENAME,JSON.stringify(gb.group));
                         g.write_file(cooConfig.JOINTABLENAME,JSON.stringify(gb.join));
                         g.write_file(cooConfig.MENUTABLENAME,JSON.stringify(gb.menu));
                         g.write_file(cooConfig.PAGETABLENAME,JSON.stringify(gb.page));
                         g.write_file(cooConfig.ROUTETABLENAME,JSON.stringify(gb.route));
                         g.write_file(cooConfig.STATUSMAPTABLENAME,JSON.stringify(gb.statusmap));
                         g.write_file(cooConfig.TAGTABLENAME,JSON.stringify(gb.tag));
                         g.write_file(cooConfig.WORKFLOWTABLENAME,JSON.stringify(gb.workflow));

                         g.write_file(cooConfig.ROLETABLENAME,JSON.stringify(gb.role));

                         g.write_file(cooConfig.CACHETABLENAME,JSON.stringify(r_cache));
                         g.write_file("last_login_user",JSON.stringify(user) );
                         cooConfig.configObj.isUpdate =true;

                         g.init_global();
                         dtd.resolve();


                          console.log(r_cache);
                       //   g.write_file(cooConfig.CACHETABLENAME,JSON.stringify(r_cache));
                    });
                }
                else {
                     g.init_global();
                     cooConfig.configObj.isUpdate =true;
                     dtd.resolve();
                }
          });
           return dtd.promise();
     };


  g.init_global = function() {

      if (!cooConfig.menu || cooConfig.menu.length==0)  {
          cooConfig.allevent = g.fetch2(cooConfig.EVENTTABLENAME);
          cooConfig.allcategory=g.fetch2(cooConfig.CATEGORYTABLENAME);
          cooConfig.allconfiguration =g.fetch2(cooConfig.CONFIGURATIONTABLENAME);
          cooConfig.alluser = g.fetch2(cooConfig.CUSERTABLENAME);
          cooConfig.alldepartment = g.fetch2(cooConfig.DEPARTMENTTABLENAME);
          cooConfig.allgroup =g.fetch2(cooConfig.GROUPTABLENAME);
          cooConfig.alljoin = g.fetch2(cooConfig.JOINTABLENAME) ;
          cooConfig.allmenu = g.fetch2(cooConfig.MENUTABLENAME);
          cooConfig.allpage = g.fetch2(cooConfig.PAGETABLENAME);
          cooConfig.allroute = g.fetch2(cooConfig.ROUTETABLENAME) ;
          cooConfig.allstatusmap =g.fetch2(cooConfig.STATUSMAPTABLENAME);
          cooConfig.alltag = g.fetch2(cooConfig.TAGTABLENAME);
          cooConfig.allworkflow = g.fetch2(cooConfig.WORKFLOWTABLENAME);
          cooConfig.allrole  =   g.fetch2(cooConfig.ROLETABLENAME);


          var css= _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key=='css'});
          if (css){
              $('#css').html(
                '<style type="text/css" >'+css.configuration_value+' </style>'
              );
            }
        }
  };

  g.init_page = function(pageId){

     g.init_global();
     if (cooConfig.allpattern.length==0)  {
       cooConfig.allpattern = g.fetch2(cooConfig.COOITEMPATTERNTABLENAME);
       $(cooConfig.allpattern).each(function(i,j){

           if (!j.property)  j.property ={};
           if ( typeof j.property ==='string' )
           {
              if (   j.property.length>2){
                   j.property = JSON.parse(j.property);
              }
              else {
                  j.property ={};
              }
           }

       });
     }
     if (cooConfig.allstatus.length==0)  {

       cooConfig.allstatus  = g.fetch2(cooConfig.STATUSTABLENAME);

       var promises=[];
       if (cooConfig.configObj.localGroups){
             $(cooConfig.configObj.localGroups).each(function(p,q){
              promises.push(rest.remote_data2({}, "status"+ q + ".json"));
          });

             $.when.apply($, promises).done(function() {

                var arx = arguments;
                 $(cooConfig.configObj.localGroups).each(function(x,y){
                     cooConfig.allstatus =_.filter(cooConfig.allstatus,function(n){return n.groupId!= y });
                     $(arx[x]).each(function(i,j){
                         cooConfig.allstatus.push(j);
                     });
                 });

             });

       }




     }




     var sub_pages = _.filter(cooConfig.allpage,function(n){ return n.parentId==pageId  });
     var pageIds =[];
     $(sub_pages).each(function(i,j){
        pageIds.push(j.ID);
     });
     pageIds.push(pageId);
     var pes = _.filter(cooConfig.allelement,function(n){ return  pageIds.indexOf(n.pageId)>=0 });


     if (pes.length==0)
     {
      //   cooConfig.allelement = _.filter(cooConfig.allelement,function(n){ return  pageIds.indexOf(n.ID)<0 });
         $(pageIds).each(function(i,j){
              var sub_elements = g.fetch2(cooConfig.ELEMENTTABLENAME+":"+pageId);
              $(sub_elements).each(function(p,q){
                 cooConfig.allelement.push(q);
              });
         });
     }

  };

   g.page_pats = function(pageId) {

    //    console.log(pageId);

        var elements2 = _.filter(cooConfig.allelement,function(n){ return n.pageId==pageId});

      //  console.log(cooConfig.allelement);
       var elements=[];
       var eleids =[];
       $(elements2).each(function(i,j){
          if (eleids.indexOf(j.ID)<0){
              elements.push(j);
              eleids.push(j.ID);
          }
       });

    //  console.log(elements);

         var eles = [];
         var eleOrder = [];

         $(elements).each(function (i, item) {
             eles.push(item.patternId);
             eleOrder[item.ID] = item.eorder;
         });

         var pats = _.filter(cooConfig.allpattern,function(n){  return  eles.indexOf(n.ID) > -1; });

         var pats2 =[];
         $(elements).each(function(i,j){
             var p = _.find(pats,function(n){  return n.ID==j.patternId  }) ;
             var pat={};
             pat.ID= p.ID;
             pat.categoryId = p.categoryId;
             pat.checked = p.checked;
             pat.companyId = p.companyId;
             pat.isUnique = p.isUnique;
             pat.pName = p.pName;
             pat.pTypeId = p.pTypeId;
             pat.property = p.property;
             pat.required= p.required;




             pat['property_' + pageId] = $.trim(j.property)?JSON.parse(j.property):{};
             pat.level = pat['property_' + pageId].level;
             pat.alias = pat['property_' + pageId].alias;
             pat.elementId = j.ID;
             if (typeof(pat.property)=='object' && pat.property.placeholder){
               pat.placeholder = pat.property.placeholder;
             }

             pat.element_property =  $.trim(j.property)?JSON.parse(j.property):{};
             pats2.push(pat);
         });

         // $(pats).each(function(i,j){
         //     var ele =_.find(elements,function(n){return n.patternId==j.ID});
         //
         //     if (typeof(j.property)=='object' && j.property.placeholder){
         //       j.placeholder = j.property.placeholder;
         //     }
         //
         //     j.element_property =  $.trim(ele.property)?JSON.parse(ele.property):{};
         //     j['property_' + pageId] = $.trim(ele.property)?JSON.parse(ele.property):{};
         // });


         pats2.sort(function (a, b) {
              if (eleOrder[a.elementId] < eleOrder[b.elementId]) return -1;
              if (eleOrder[a.elementId] > eleOrder[b.elementId]) return 1;
              return 0;
          });

        //  console.log(pats2);

          return pats2;

   }

   g.page_update =function(pageId){
        var dtd = $.Deferred();

        $.when(g.page_check(pageId),g.init_page(pageId)).done(function(ret){

             if (ret){
                  $.when(rest.page_cache(pageId)).done(function(pg){

                    var pageCollection =  _.filter(cooConfig.allpage,function(n){ return n.ID==pageId || n.parentId==pageId});
                    var pageIds =[];
                    var groupIds =[];
                    var pids=[];
                    var eids=[];
                    var sids=[];
                    pageIds = _.pluck(pageCollection,"ID");
                    $(pg.pattern).each(function(i,j){
                           pids.push(j.ID);
                    });
                    $(pg.element).each(function(i,j){
                          eids.push(j.ID);
                    });
                    $(pg.status).each(function(i,j){
                               sids.push(j.ID);
                               groupIds.push(j.groupId);
                    });
                    cooConfig.allpattern =_.filter(cooConfig.allpattern,function(n){ return pids.indexOf(n.ID)<0});
                    $(pg.pattern).each(function(i,j){
                         if (j.property && j.property.length>2)
                         {
                           j.property =JSON.parse(j.property);
                         }
                         else {
                            j.property ={};
                         }
                         cooConfig.allpattern.push(j);
                    });

                    cooConfig.allelement=_.filter(cooConfig.allelement,function(n){return pageIds.indexOf(n.pageId)<0});
                    $(pg.element).each(function(i,j){
                        cooConfig.allelement.push(j);
                    });

                    cooConfig.allstatus =_.filter(cooConfig.allstatus,function(n){return groupIds.indexOf(n.groupId)<0});
                    $(pg.status).each(function(i,j){
                        cooConfig.allstatus.push(j);
                    });

                    if (cooConfig.configObj.localGroups){
                        var promises = [];
                        var groupIds =[];
                       $(pg.pattern).each(function(i,j){
                            var smp = _.find(cooConfig.allstatusmap,function(n){ return n.patternId ==j.ID });
                             if (smp)
                             {
                                if (cooConfig.configObj.localGroups.indexOf(smp.groupId)>=0)
                                {
                                     if (groupIds.indexOf(smp.groupId)<0)
                                     {
                                       if( !_.any(cooConfig.allstatus,function(n){ return n.groupId == smp.groupId }))
                                       {
                                         promises.push(rest.remote_data2({}, "status"+smp.groupId + ".json"));
                                         groupIds.push(smp.groupId);
                                       }


                                     }
                                }
                             }
                       });

                       if (groupIds){


                         $.when.apply($, promises).done(function() {

                            var arx = arguments;

                             g.write_file(cooConfig.COOITEMPATTERNTABLENAME,JSON.stringify(cooConfig.allpattern));
                             g.write_file(cooConfig.STATUSTABLENAME,JSON.stringify(cooConfig.allstatus));
                             g.write_file(cooConfig.ELEMENTTABLENAME+":"+pageId,JSON.stringify(pg.element));

                             var sub_pages = _.filter(cooConfig.allpage,function(n){ return n.parentId==pageId ||n.ID==pageId});
                              $(sub_pages).each(function(i,j){
                                     amplify.store(cooConfig.configObj.companyId+".c_element:"+j.ID,null);
                             });

                             if (!cooConfig.allstatus)  cooConfig.allstatus =[];
                             $(groupIds).each(function(x,y){
                                 cooConfig.allstatus =_.filter(cooConfig.allstatus,function(n){return n.groupId!= y });
                                 $(arx[x]).each(function(i,j){
                                     cooConfig.allstatus.push(j);
                                 });
                             });

                              dtd.resolve();

                         });

                       }
                       else{



                           g.write_file(cooConfig.COOITEMPATTERNTABLENAME,JSON.stringify(cooConfig.allpattern));
                           g.write_file(cooConfig.STATUSTABLENAME,JSON.stringify(cooConfig.allstatus));
                           g.write_file(cooConfig.ELEMENTTABLENAME+":"+pageId,JSON.stringify(pg.element));

                           var sub_pages = _.filter(cooConfig.allpage,function(n){ return n.parentId==pageId ||n.ID==pageId});
                            $(sub_pages).each(function(i,j){
                                   amplify.store(cooConfig.configObj.companyId+".c_element:"+j.ID,null);
                           });
                                console.log(cooConfig.allstatus.length);
                            dtd.resolve();


                       }





                    }
                    else {


                          g.write_file(cooConfig.COOITEMPATTERNTABLENAME,JSON.stringify(cooConfig.allpattern));
                          g.write_file(cooConfig.STATUSTABLENAME,JSON.stringify(cooConfig.allstatus));
                          g.write_file(cooConfig.ELEMENTTABLENAME+":"+pageId,JSON.stringify(pg.element));

                          var sub_pages = _.filter(cooConfig.allpage,function(n){ return n.parentId==pageId ||n.ID==pageId});
                           $(sub_pages).each(function(i,j){
                                  amplify.store(cooConfig.configObj.companyId+".c_element:"+j.ID,null);
                          });
                               console.log(cooConfig.allstatus.length);
                           dtd.resolve();

                    }





                  });
             }else {
                 dtd.resolve();
             }
        });
        return dtd.promise();
   };


    g.menu2 = function (){

        if (cooConfig.menu &&cooConfig.menu.length>0){
            return;
        }



       cooConfig.menu=[];


       cooConfig.allmenu = _.sortBy(cooConfig.allmenu,'morder');

       $(cooConfig.allmenu).each(function(i,j){
             var prop = {};
             if (j.property&& j.property.length>0)
             {
                prop = JSON.parse(j.property);
             }
             j.prop = prop;
             if (prop.parameters){
                prop.parameters = JSON.parse(prop.parameters);
             }
             if (!j.parentId || j.parentId==0 )
             {
               j.subMenu=[];
               cooConfig.menu.push(j);
             }
       });

      cooConfig.menu = _.sortBy(cooConfig.menu, 'morder');

      var mm = _.find(cooConfig.allmenu,function(n){ return n.ID ==350});
      console.log(mm);


      $(cooConfig.allmenu).each(function (i,j) {
            if (j.parentId>0)
            {
              var p =_.find(cooConfig.menu,function(n) { return n.ID ==j.parentId });
              if (p){
                  if (!p.subMenu) p.subMenu =[];
                  if (j.url.indexOf('/app')==0||j.url.indexOf('/design')==0||j.url.indexOf('#')==0)
                  {
                    //console.log(j.pName);
                    j.subMenu=[];
                    p.subMenu.push(j);
                  }
              }
            }
        // body...
      });

      $(cooConfig.allmenu).each(function (i,j) {
            if (j.parentId>0)
            {
              var p =_.find(cooConfig.menu,function(n) { return n.ID ==j.parentId });
              if (!p){

                   $(cooConfig.menu).each(function( x,y ){
                       var pp = _.find(y.subMenu,function(n) { return n.ID == j.parentId } );
                       if (pp)
                       {
                           if (!pp.subMenu){
                              pp.subMenu=[];
                           }

                           if (j.url.indexOf('/access')==0||j.url.indexOf('/app')==0||j.url.indexOf('/design')==0||j.url.indexOf('#')==0)
                           pp.subMenu.push(j);

                       }
                   });
               }
            }
        // body...
      });

      $(cooConfig.menu).each(function(a1,b1){
          $(b1.subMenu).each(function(c1,d1){

              d1.subGroup=[];
              var row = { name:'未分组' , list:[] };
              $(d1.subMenu).each(function(e1,f1){
                   if (f1.prop.group){
                      if (row.list.length>0) {
                        d1.subGroup.push(row);
                      }
                      row = { name : f1.prop.group  ,list :[] };
                   }
                   row.list.push(f1);

                   if (f1.icon=='yonyou'){
                      f1.url2 = cooConfig.configObj.yonyou + '?menu=' + f1.eName + '&&t='+ Math.random();
                   }



              })
              d1.subGroup.push(row);

        //      console.log(d1.subGroup);


          });
      });









    };


    g.page_check = function(pageId){
        var dtd = $.Deferred();

        var last_user = g.fetch2("last_login_user");
        if (cooConfig.configObj.RoleIds && last_user.RoleIds!= cooConfig.configObj.RoleIds   )
        {
            // console.log(last_user.RoleIds);
          //   console.log(cooConfig.configObj.RoleIds);
              dtd.resolve(true);
              return dtd.promise();
        }


        $.when(g.fetch(cooConfig.CACHETABLENAME),g.fetch(cooConfig.CACHETABLENAME+":"+pageId))
        .done(function(caches,c2){
            var  c1 = g.cacheNameCompare(caches, "page");
            if (!c2||c2.length==0) {
                var ar1 =[];
                ar1.push(c1[0].cacheTime);
                g.write_file(cooConfig.CACHETABLENAME+":"+pageId,JSON.stringify(ar1));
                dtd.resolve(true);
             }
            else {
              if (Date.parse(c1[0].cacheTime) != Date.parse(c2[0])) {

                 var ar2 =[];
                 ar2.push(c1[0].cacheTime);
                 g.write_file(cooConfig.CACHETABLENAME+":"+pageId,JSON.stringify(ar2));
                 dtd.resolve(true);
                }
            }
            dtd.resolve(false);
        });
        return dtd.promise();
    };


    g.remote_check=function(key){
        var dtd = $.Deferred();
        $.when(g.fetch(cooConfig.CACHETABLENAME),g.fetch(cooConfig.CACHETABLENAME+":local"))
        .done(function (caches,caches_local) {

            var  c1 = g.cacheNameCompare(caches, key);
            var  c2 = g.cacheNameCompare(caches_local, key);
            if (c2.length == 0) {
                dtd.resolve(true);
             }
            else {
              console.log(c1);
              console.log(c2);
              if (c2.length > 0 && Date.parse(c1[0].cacheTime) != Date.parse(c2[0].cacheTime)) { dtd.resolve(true); }
            }
            dtd.resolve(false);
        });
        return dtd.promise();
    };

    g.update_key_cache_time=function(key){
        var dtd = $.Deferred();
        $.when(g.fetch(cooConfig.CACHETABLENAME),g.fetch(cooConfig.CACHETABLENAME+":local"))
        .done(function (caches,caches_local) {
            var k1 = _.find(caches,function(n){ return n.cacheName.toLowerCase()==key.toLowerCase()});
            caches_local = _.filter(caches_local,function(n){ return n.cacheName.toLowerCase()!=key.toLowerCase() });
            caches_local.push(k1);
            g.write_file(cooConfig.CACHETABLENAME+":local",JSON.stringify(caches_local));
            dtd.resolve();
        });
        return dtd.promise();
    };

   g.prepare_raw = function(row,pats){

       $(pats).each(function(i,j){

         var v = row["__c" + j.ID];
         if (v == null || v == 'null') v = '';

             switch (j.pTypeId) {
                 case 4:
                    v = v;//g.decimal_format(v,pattern);
                 break;
                 case 6:
                     v =   g.dateFormat(v,j);
                     break;
                 case 1:
                 case 21:
                     v = v ? "是" : "";
                     break;
                 case 10:
                     $(v).each(function (i, t) {
                         if (t.FilePath) t['RawFilePath'] = t.FilePath.replace('/100', '');
                         if (t.FilePath && t.FilePath.match(/(jpg|jpeg|png|bmp|gif)$/ig)) t.isImage=true;
                     });
                     break;
                 case 11:
                     if (v.FilePath == undefined || v.FilePath == null || v.FilePath == '') v.FilePath = 'images/default.png';
                     if (v.FilePath) {
                         v['RawFilePath'] = v.FilePath.replace('/100', '');
                     }
                     break;
                 case 7:
                     v = v;//  $sce.trustAsHtml(v);

                     break;
                 case 17:
                     break;
                case 12:
                    if (!v) v= {UserName:'未设置',UserId:'00000000-0000-0000-0000-000000000000'};
                    break;
                 case 22:
                     break;
                 case 2:
                 case 13:
                     var vlist = [];
                     vlist.push(parseInt(v));
                     var plist = _.filter(cooConfig.allstatus, function (n) { return jQuery.inArray(n.ID, vlist) != -1; });
                     if (plist.length > 0) v = plist[0];
                     break;
                 case 19:
                 case 20:

                     break;
                 default: break;
             }
             row["__c" + j.ID] =v;
       });
       return row;
   }


   g.prepare_raw2 = function(row,pats){

       $(pats).each(function(i,j){

         var v = row["__c" + j.ID];
         if (v == null || v == 'null') v = '';

             switch (j.pTypeId) {
                 case 4:
                    v = v;//g.decimal_format(v,pattern);
                 break;
                 case 6:
                     if (v)
                     {
                        v =  new Date(v) ;
                     }
                     else{
                       v="";
                     }

                     break;
                 case 1:
                 case 21:
                     v = v ? "是" : "";
                     break;
                 case 10:
                     $(v).each(function (i, t) {
                         if (t.FilePath) t['RawFilePath'] = t.FilePath.replace('/100/', '/');
                         if (t.FilePath && t.FilePath.match(/(jpg|jpeg|png|bmp|gif)$/ig)) t.isImage=true;
                     });

                     var newLink ='';
                     $(v).each(function(p,q){
                         q.ext = q.Filename? q.Filename.replace(/^.+\./ig,''):'';
                         newLink += ' '+q.ID + '.' +q.ext+ '  , ';
                     })

                       row["__c" + j.ID]  = newLink;
                       row["__c" + j.ID+"__atts"] =v;




                     break;
                 case 11:
                     if (typeof v == 'object')
                     {
                        row["__c" + j.ID] = v.Filename?v.Filename:(v.ID?v.ID.toString():'');
                        row["__c" + j.ID+"__att"] = v;
                        row["__c" + j.ID+"__src"] = v.FilePath;


                     }
                     // if (v.FilePath == undefined || v.FilePath == null || v.FilePath == '') v.FilePath = 'images/default.png';
                     // if (v.FilePath) {
                     //     v['RawFilePath'] = v.FilePath.replace('/100', '');
                     // }
                     break;
                 case 7:
                     v = v;//  $sce.trustAsHtml(v);

                     break;
                 case 17:
                     break;
                case 12:
                     if (!v) v='';
                     if (typeof v == 'object')
                     {
                       row["__c" + j.ID +'_value']=v.UserId;
                       v = v.XingMing;
                        //v = v.UserId;
                        //console.log(row);
                     }
                  //  if (!v) v= {UserName:'未设置',UserId:'00000000-0000-0000-0000-000000000000'};
                    break;
                 case 22:
                     break;
                 case 2:
                 case 13:

                     if (!v) v=0;
                     break;
                 case 19:
                 case 20:

                     break;
                 default: break;
             }
              if (j.pTypeId!=11 && j.pTypeId!=10 ){
                row["__c" + j.ID] =v;
              }

       });
       return row;
   }

   g.prepareDisplay = function (val, pat) {
                      var displayV ='';
                      switch (pat.pTypeId)
                      {
                          case 1:
                            displayV = val?'是':'否';
                            break;
                          case 2:
                          case 13:
                            displayV =  val.statusName;
                                break;
                          case 7:
                            displayV = val.replace(/<[^>]+>/ig,'');
                                break;
                          case 4:
                            displayV = val?g.fmoney(val,2):val;
                             break;
                          case 10:
                          case 11:
                             displayV =val;

                             break;
                          case 5:
                          case 6:
                          case 16:
                               displayV = val;
                                 break;
                          case 12:
                              displayV = val.XingMing;
                              break;
                          case 19:
                              displayV = _.pluck(val,'XingMing').join(',');
                              break;
                          case 20:
                                  displayV = _.pluck(val,'statusName').join(',');
                                  break;
                            default:

                        }

                        return displayV;

   }


    g.prepareVal = function (row, pattern) {



       var cfg_preview =  _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key=='preview'});


       var v = row["__c" + pattern.ID];

       if (v == null || v == 'null') v = '';

       switch (pattern.pTypeId) {
           case 4:
           case 3:
              v = v;//g.decimal_format(v,pattern);
           break;
           case 6:

               if (pattern.property.type=='timepicker')
               {
                  if (v)
                  {
                      v= v.replace('T', ' ');
                      v = new Date(v.replace(/-/g, '/'));
                  }
               }
               else {
                     v =   g.dateFormat(v,pattern);
               }


               break;
           case 1:
           case 21:
               v = v ? "是" : "";
               break;
           case 10:


               $(v).each(function (i, t) {
                   if (t.FilePath) t['RawFilePath'] = t.FilePath.replace('/100/', '/');
                   if (t.FilePath && t.FilePath.match(/(jpg|jpeg|png|bmp|gif)$/ig)) t.isImage=true;
                   if (t.FilePath && t.FilePath.match(/(doc|docx)$/ig) && cfg_preview) t.preview = true;


               });
               break;
           case 11:
               if (v.FilePath == undefined || v.FilePath == null || v.FilePath == '') v.FilePath = 'images/default.png';
               if (v.FilePath) {
                   v['RawFilePath'] = v.FilePath.replace('/100/', '/');
               }
               break;
           case 7:
               v = v;//  $sce.trustAsHtml(v);


               break;
           case 17:
               if (v && !_.isObject(v)){
                    v= JSON.parse(v);
               }
               break;
           case 24:
               if (!v) v= { address:''};
                if (typeof v =='string') v = JSON.parse(v);
              break;
          case 12:
              if (!v) v= {UserName:'未设置',UserId:'00000000-0000-0000-0000-000000000000'};
              break;
           case 22:
               break;
           case 23:
              if (pattern.property.type=='role' && v)
              {
                   if (!_.isObject(v)){


                     var plistx = _.find(cooConfig.allrole, function (n) { return  n.RoleId==v });



                     if (plistx )  {
                       v ={ RoleName:plistx.RoleName.replace(/^\d+:/ig,''), RoleId:plistx.RoleId} ;
                     }
                     else {
                       v ={ RoleName:'请选择', RoleId:'00000000-0000-0000-0000-000000000000'};
                     }
                   }

              }

               break;
           case 26:
                 if (!_.isObject(v)){
                      var vlist = [];
                      vlist.push(parseInt(v));

                      var plist = _.filter(cooConfig.alldepartment, function (n) { return jQuery.inArray(n.ID, vlist) != -1; });
                      if (plist.length > 0)  {
                        v = plist[0];
                      }
                      else {
                        v ={ departmentName:'请选择', ID:0};
                      }
                  }

           break;
           case 2:
           case 13:
              if (!_.isObject(v)){
                   var vlist = [];
                   vlist.push(parseInt(v));

                   var plist = _.filter(cooConfig.allstatus, function (n) { return jQuery.inArray(n.ID, vlist) != -1; });
                   if (plist.length > 0)  {
                     v = plist[0];
                   }
                   else {
                     v ={ statusName:'请选择', ID:0};
                   }
               }
               break;
           case 19:
                if (_.isObject(v)){
                  v = v.length>3? (v.length.toString()+'个'):_.pluck(v,'XingMing').join(',');
                }

              break;
           case 20:
               if (!_.isObject(v)){
                    var vlist = [];
                    vlist = v.split(',');

                    var plist = _.filter(cooConfig.allstatus, function (n) { return jQuery.inArray(n.ID.toString(), vlist) != -1; });
                    if (plist.length > 0)  {
                      v = plist;
                    }
                    else {
                      v =[];
                    }
                }

               break;
           default: break;
       }

       return v;

    };



    g.getPaging = function (total, current) {

        var paging = {};

        paging.first = { txt: '前一页', n: 0 };
        paging.last = { txt: total , n: total };
        paging.next = { txt: '后一页', n: 0 };
        paging.list = [];


        if (current > 1) paging.first.n = current - 1;

        for (var m = 1; m < total ; m++) {

            if (total > 6)
            {
                if (m < current - 4 && m != 1) continue;
                if (m > current + 4 ) continue;
            }
            var pp = { txt: m, n: m };
            paging.list.push(pp);
        }

        if (current < total &&total!=1) paging.next.n = current + 1;
        return paging;

    };

    g.show_ajax = function()
    {
     //  $("#ajax").html("<img src='css/ajax1.gif'  />");
       $("#ajax").css('z-index', '1201');
       $("#ajax").show();
   //     $("#ajax").css('top', '30%');
    }

     g.hide_ajax = function()
     {
         console.log('hide_ajax');
             $("#ajax").css('z-index', '-1000');;
             $("#ajax").hide();
     }

     g.config = function(key){
       var v ='';
       var cfg =  _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key== key });
       if (cfg) v = cfg.configuration_value;
       return v;
     }

     g.users = function(){
       var users = cooConfig.alluser;
       var s_function = g.config('user_filter');
       if (s_function)  {
         var user_filter = new Function('users','user',s_function);
         users = user_filter(users,cooConfig.user);
       }
       return users;
     }

     g.groupUsers = function(){

             var sls =[];
             var users = cooConfig.alluser;

             var s_function = g.config('user_filter');
             if (s_function)  {
               var user_filter = new Function('users','user',s_function);
               users = user_filter(users,cooConfig.user);
             }


              var otherusers = _.filter(users,function(n){ return n.departmentId==null || n.departmentId==0; });

              var orow = { label:"未分部门",children:[]  };
        //      orow.children.push({label:'未选择',value:'00000000-0000-0000-0000-000000000000'});
              $(otherusers).each(function(i,f){
                var p1 = makePy(f.XingMing);
                if (p1 && p1[0] && p1[0][0]){
                     orow.children.push({label: p1[0][0].toLowerCase() + '-'+f.XingMing,value:f.UserId});
                } else{
                   orow.children.push({label:f.XingMing,value:f.UserId});
                }

              });
              $(cooConfig.alldepartment).each(function(i,d){


                          var row ={ label:d.departmentName,children:[] };
                          var subusers = _.filter(users,function(n){ return n.departmentId==d.ID; });
                          $(subusers).each(function(i,f){
                             var p1 = makePy(f.XingMing);
                            row.children.push({label:p1[0][0].toLowerCase()   +'-' +f.XingMing,value:f.UserId});
                          });

                 sls.push(row);
              });
              sls.push(orow);

              return sls;


     }


     g.makeSource2 = function (pattern,data) {


        var source = [];
        var sls = [];
        switch (pattern.pTypeId) {
          case 3:
          case 4:
              var smap34 = _.find(cooConfig.allstatusmap, function (n) { return pattern.ID == n.patternId }); //  g.statusFilterByPattern(pattern.ID);
              if (smap34)
              {
                var ss = _.filter(cooConfig.allstatus, function (n) { return n.groupId == smap34.groupId });
                sls =  _.map(ss,function(n){ return  { label: n.statusName, value: n.ID } ; });
                sls.splice(0,0,{ label: '请选择', value: 0 });
              }

              break;
          case 18:
              sls = [{ label: '请选择', value: 0 }];
              sls.push({ label: '根节点', value: 1 });
              sls.push({ label: '一层', value: 2 });
              sls.push({ label: '二层', value: 3 });
              sls.push({ label: '三层', value: 4 });
              sls.push({ label: '四层', value: 5 });
              sls.push({ label: '五层', value: 6 });

              break;
          case 6:
               sls = [{ label: '请选择', value: 0 }];
               sls.push({ label: '今天', value: 1 });
               sls.push({ label: '三天内', value: 2 });
               sls.push({ label: '本周内', value: 3 });
               sls.push({ label: '7天内', value: 4 });
               sls.push({ label: '本月内', value: 5 });
               sls.push({ label: '30天内', value: 6 });

            break;
           case 12:
                var users = cooConfig.alluser;



                var s_function = g.property(pattern.property,'user_filter');

                console.log(s_function);

               if (s_function)  {
                 var user_filter = new Function('users','user',s_function);
                 users = user_filter(users,cooConfig.user);
               }




               var otherusers = _.filter(users,function(n){ return n.departmentId==null || n.departmentId==0; });

               var orow = { label:"未分部门",children:[]  };
         //      orow.children.push({label:'未选择',value:'00000000-0000-0000-0000-000000000000'});
               $(otherusers).each(function(i,f){
                    var p1 = makePy(f.XingMing);
                    if (p1 && p1[0] && p1[0][0]){
                         orow.children.push({label: p1[0][0].toLowerCase() + '-'+f.XingMing,value:f.UserId});
                    } else{
                       orow.children.push({label:f.XingMing,value:f.UserId});
                    }

               });
               $(cooConfig.alldepartment).each(function(i,d){



                             var row ={ label:d.departmentName,children:[] };
                             var subusers = _.filter(users,function(n){ return n.departmentId==d.ID; });
                             $(subusers).each(function(i,f){
                               var p1 = makePy(f.XingMing);
                               row.children.push({label:p1[0][0].toLowerCase() + '-'+f.XingMing,value:f.UserId});
                             });

                            sls.push(row);

               });
               sls.push(orow);






               // var smap = _.find(cooConfig.allstatusmap,function(n){ return n.patternId == pattern.ID});
               // var users = cooConfig.alluser;
               // if ( smap &&  smap.length > 0) {
               //       var  stat = _.find(cooConfig.allstatus,function(n){ return n.groupId== smap.groupId});
               //       if (stat)
               //       {
               //          users = _.filter(cooConfig.alluser,function(n){ return n.RoleIds.toLowerCase().indexOf(stat.statusName.toLowerCase())>=0 });
               //       }
               //  }
               //
               //    sls.splice(0,0,{ label: '请选择', value: '00000000-0000-0000-0000-000000000000' });
               //    $(users).each(function(i,f){
               //         sls.push({label:f.XingMing,value:f.UserId});
               //     });

            break;
            case 26:

              sls =  _.map(cooConfig.alldepartment,function(n){ return  { label: n.departmentName, value: n.ID } ; });
              sls.splice(0,0,{ label: '请选择', value: 0 });

            break;
            case 23:
               if (pattern.property.type=='role'){
                  sls = _.map(cooConfig.allrole,function(n){ return  { label: n.RoleName.replace(/^\d+:/ig,''), value: n.RoleId } ; });
                  sls.splice(0,0,{ label: '请选择', value: 0 });
               }
               break;
            case 2:
            case 13:
            case 20:

                var smap = _.filter(cooConfig.allstatusmap, function (n) { return pattern.ID == n.patternId }); //  g.statusFilterByPattern(pattern.ID);
                // if (pattern.ID==46)
                // {
                //   var sub_status=_.filter(cooConfig.allstatus, function (n) { return n.groupId ==3 });
                //     console.log(sub_status);
                //     console.log(smap);
                // }


                if (smap[0] && smap[0].init) {
                    var ss = _.filter(cooConfig.allstatus, function (n) { return n.groupId == smap[0].groupId });
                    ss= _.sortBy(ss,'statusOrder');
                    sls =  _.map(ss,function(n){ return  { label: n.statusName, value: n.ID } ; });
                    sls.splice(0,0,{ label: '请选择', value: 0 });
                }
                else
                {
                    if (smap[0] && smap[0].depth && data['__c' + smap[0].depth] )
                    {
                        var v = data['__c' + smap[0].depth];

                        var ss2 = _.filter(cooConfig.allstatus, function (n) { return n.parentId == v });
                        sls =  _.map(ss2,function(n){ return  { label: n.statusName, value: n.ID } ; });
                        sls.splice(0,0,{ label: '请选择', value: 0 });
                    }
                    else {
                        sls = [{ label: '请选择', value: 0 }];
                    }
                }

                break;
        }



        return sls;
    }

    g.property= function(obj,name)
    {
        if (!obj) return '';
        if (typeof obj === 'string')
        {
            obj = JSON.parse(obj);
        }
        return obj[name];
    }

    g.row_date =function(dt){

      $(dt).each(function(x,y){
          if (y.pTypeId==6) y.val = g.date_str(y.val);
      });

      return dt;

    };


    g.date_str2 = function(dayd){
      if (!dayd) return '';
  //  dayd =new Date(dayd);
      var y = dayd.getFullYear();
      var m = dayd.getMonth() + 1;
      var d = dayd.getDate();
      var hh = dayd.getHours();
      var mm = dayd.getMinutes();
      var ss = dayd.getSeconds();
      if (m<10) m = '0' +m.toString();
      if (d<10) d = '0' +d.toString();
      return y + '-' + m + '-' + d  ; //+ ' ' + hh + ':' + mm + ':' + ss;

    };


    g.date_str = function(dayd){
      if (!dayd) return '';
      dayd =new Date(dayd);
      var y = dayd.getFullYear();
      var m = dayd.getMonth() + 1;
      var d = dayd.getDate();
      var hh = dayd.getHours();
      var mm = dayd.getMinutes();
      var ss = dayd.getSeconds();
      if (m<10) m = '0' +m.toString();
      if (d<10) d = '0' +d.toString();
      return y + '-' + m + '-' + d  ; //+ ' ' + hh + ':' + mm + ':' + ss;

    };


    g.dateFormat2 = function (vv, o) {
          if (vv == undefined || vv == '') return '';

          var type = 'date';

          if (o.property &&  o.property.type ) {
              type =  o.property.type;
          }
          var dayd = new Date();
          if (typeof vv.getMonth === 'function')
          {
             dayd = vv;
          }
          else {
            vv = vv.replace('T', ' ');
            dayd = new Date(vv.replace(/-/g, '/'));
          }




          var y = dayd.getFullYear();
          var m = dayd.getMonth() + 1;
          var d = dayd.getDate();
          var hh = dayd.getHours();
          var mm = dayd.getMinutes();
          var ss = dayd.getSeconds();

          var mstr = m<10 ? ('0' + m.toString()):  m.toString();
          var dstr = d<10 ? ('0' + d.toString()):  d.toString();



          if (type == 'date') {
            //    vv = vv.replace(/\s[\S]+$/ig, '');
                 return y + '-' + mstr + '-' + dstr;
          }
          return   y + '-' + mstr + '-' + dstr + ' ' + hh + ':' + mm + ':' + ss;
      };




    g.dateFormat = function (vv, o) {
          if (vv == undefined || vv == '') return '';

          var type = 'date';

          if (o.property &&  o.property.type ) {
              type =  o.property.type;
          }
          var dayd = new Date();
          if (typeof vv.getMonth === 'function')
          {
             dayd = vv;
          }
          else {
            vv = vv.replace('T', ' ');
            dayd = new Date(vv.replace(/-/g, '/'));
          }




          var y = dayd.getFullYear();
          var m = dayd.getMonth() + 1;
          var d = dayd.getDate();
          var hh = dayd.getHours();
          var mm = dayd.getMinutes();
          var ss = dayd.getSeconds();



          if (type == 'date') {
            //    vv = vv.replace(/\s[\S]+$/ig, '');
                 return y + '-' + m + '-' + d;
          }
          return   y + '-' + m + '-' + d + ' ' + hh + ':' + mm + ':' + ss;
      };


      g.init_list_scope= function($scope,$rootScope){


           $scope.s_pats=[];
           $scope.s_pats2=[];
           $scope.l_pats=[];
           $scope.tags = _.filter(cooConfig.alltag,function(n){ return n.categoryId == $scope.categoryId });

           $scope.startIndex = 1;
           if (!$scope.pageSize)    $scope.pageSize = 10;
           $scope.s="";
           $scope.search_open =false;
           $scope.list_open =false;
           $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
           $scope.search_pTypeIds=[1,2,3,4,6,13,16];
           $scope.first_user_pat ={};


           $scope.top_setting ={
                   search:true,
                  list_view:true,
                  del : true,

           };



           $scope.quick_nav18 =function(pat,item)
           {
              console.log(item);
              pat.v3= item.value;

              if (item.value==0)
              {
                  pat.v3='';
              }
              $scope.dosearch();
              //      $scope.dosearch();
           }


           $scope.quick_nav34 =function(pat,item)
           {
              pat.v = item.value;
              if (item.value==0)
              {
                  pat.v1='';
                  pat.v2='';
                   $scope.dosearch();
              }

            var item = _.find(cooConfig.allstatus,function(n){ return n.ID == item.value});

            if (item)
            {
               if (item.data1.indexOf('{')>=0)
               {
                  var stats_obj = JSON.parse(item.data1);
                   pat.v1 = stats_obj.min;
                   pat.v2 = stats_obj.max;
                   $scope.dosearch();
               }
            }








        //      $scope.dosearch();
           }

           $scope.quick_nav2 =function(pat,item)
           {





             if (item.value || item.value==0)  pat.v = item.value;

              var initPat = _.find(cooConfig.allstatusmap,function(n){ return n.depth==pat.ID });

              if (initPat){
                  console.log(initPat);
                  var pt = _.find($scope.s_pats2,function(n){ return n.ID == initPat.patternId });
                  var ptSource= _.filter(cooConfig.allstatus,function(n){ return n.groupId == initPat.groupId && n.parentId==pat.v });
                  var ptS =[{label:'全部',value:0}];
                  $(ptSource).each(function(i,j){
                     ptS.push({label:j.statusName ,value:j.ID});
                  });
                  pt.source =ptS;
              }



              $scope.dosearch();
           }

           $scope.text_change = function(labelx,labely,vx,vy){

        //    console.log(vx);
        //    console.log(vy);

        //    console.log($scope.text_valuey);


             var pat = _.find($scope.s_pats2,function(n){ return n.idlevel == labelx });
             var pat_12 =  _.find($scope.s_pats2,function(n){ return n.ID.toString()== labely });

        //     console.log($scope.text_labely);
        //     console.log($('#__c'+labely).val());


             if (!vy && $('#__c'+labely).val() && typeof(vy) !="string")
                vy = $('#__c'+labely).val().join(',');


            //    console.log(  $('#__c'+ e.first_user_pat.ID).val().join(',')  )

            // var tx=$('#__c'+ $scope.first_user_pat.ID).val();
            // if (tx)  vy = tx.join(',');

      //         console.log(pat_12,vy);

             if (pat || pat_12 )
             {
               if (pat)
               {
                   pat.v = vx;
                  $($scope.s_pats2).each(function(i,j){
                     if (j.idlevel!= pat.idlevel && (j.pTypeId==5||j.pTypeId==7) ) j.v ="";
                  });
               }

               if (pat_12 && vy)
               {
                  if (typeof(vy) =="string"){
                    pat_12.v  =vy;
                  }
                  else {
                    pat_12.v = vy.join(',');
                  }


                  $($scope.s_pats2).each(function(i,j){
                     if (j.ID!=pat_12.ID && (j.pTypeId==12||j.pTypeId==19) ) j.v ="";
                  });
               }

               $scope.dosearch();
             }
           }

           $scope.quick_nav6 =function(pat,item)
           {
              var today = new Date();
              pat.v =item.value;

              switch (item.value) {
                case 0:
                  pat.v1='';
                  pat.v2='';
                 break;
                case 1:
                  pat.v1 = g.date_str2(today);
                  pat.v2 = g.date_str2(today);
                  break;
                case 2:

                    today.setDate(today.getDate() - 2);
                    pat.v1 = g.date_str2(today);
                    today.setDate(today.getDate() + 2);
                    pat.v2 = g.date_str2(today);
                    break;
                case 3:
                    var weekd = today.getDay();
                    today.setDate(today.getDate() - weekd + 1);
                    pat.v1 = g.date_str2(today);
                    today.setDate(today.getDate() + weekd -1);
                    pat.v2 = g.date_str2(today);
                    break;
                case 4:
                    today.setDate(today.getDate() - 6);
                    pat.v1 = g.date_str2(today);
                    today.setDate(today.getDate() + 6);
                    pat.v2 = g.date_str2(today);
                    break;
                case 5:
                    var monthd = today.getDate();
                    today.setDate(today.getDate() - monthd + 1);
                    pat.v1 = g.date_str2(today);
                    today.setDate(today.getDate() + monthd -1 );
                    pat.v2 = g.date_str2(today);

                    break;
                case 6:
                    today.setDate(today.getDate() - 29);
                    pat.v1 = g.date_str2(today);
                    today.setDate(today.getDate() + 29);
                    pat.v2 = g.date_str2(today);
                    break;
                default:

              }





              $scope.dosearch();
           }




           $scope.open_search_setting =function()
           {
             $scope.search_open=!$scope.search_open;

             console.log($scope.search_open);

             if (!$scope.search_open)
             {
                var new_s_pats=[];
                 $($scope.s_pats).each(function(x,y){
                     new_s_pats.push({id:y.ID ,val: y.s_checked});
                 });
                 $scope.s_pats2 =   _.filter($scope.s_pats,function(n){return n.s_checked==true });
                 //console.log(JSON.stringify($scope.s_pats2));
                 g.write_file("c_element:"+ $scope.page_s ,JSON.stringify(new_s_pats));

             }

             $scope.remoteSelect();


           };

           $scope.open_list_setting =function()
           {
             $scope.list_open=!$scope.list_open;
             if (!$scope.list_open)
             {
                var new_l_pats=[];
                 $('.list-group input').each(function(x,y){
                     new_l_pats.push({id:parseInt($(y).val()) ,val: $(y).prop('checked')});
                 });
                 var old_elements =g.fetch2("c_element:"+ $scope.page_l);



                 $(new_l_pats).each(function(i,j){
                    var old_e = _.find(old_elements,function(n){ return n.id==j.id });
                    if (old_e && old_e.width)
                    j.width = old_e.width;
                 });


                 g.write_file("c_element:"+ $scope.page_l ,JSON.stringify(new_l_pats));
                 var c_ids=[];
                 $(new_l_pats).each(function(i,j){
                     c_ids.push(j.id);
                 });
                 $($scope.l_pats).each(function(i,j){
                      j.new_order = $.inArray(j.ID,c_ids);
                 });
                 $scope.l_pats =_.sortBy($scope.l_pats,'new_order');
                 $scope.renderList();


             }

           };

           $scope.selectAll = function () {

               if ($scope.selectAll_2){
                 $scope.selectAll_2();
               }
               else {
                 if ($("#selectAll").prop("checked") != true) {
                     $(".table tr td").find('input[type=checkbox]').prop("checked", false);
                 } else {
                     $(".table tr td").find('input[type=checkbox]').prop("checked", true);
                 }
               }
           };

           $scope.sort_action = function(s){

                  $scope.sort_element.orderBy = s;
                  $scope.sort_search();
           }



           $scope.sort_search = function(){

               var checks = _.filter($scope.sort_source,function(n){ return n.s_checked});
               var v= _.pluck(checks,'value');
               var vstr = v.join(',');
               console.log(vstr);

               $scope.sort_element.sort = false;


               var sc = _.find($scope.lsc ,function(n){ return n.patternId == $scope.sort_element.ID });
               if (sc){
                   sc.orderBy =$scope.sort_element.orderBy;
               } else{
                  $scope.lsc.push({ orderBy: $scope.sort_element.orderBy , patternId:$scope.sort_element.ID,val1:vstr,pTypeId:$scope.sort_element.pTypeId,operation:5 });
               }





               $scope.startIndex = 1;
               $scope.renderList();

           }

           $scope.search_cancel = function(){
              console.log('xxx2');
               $scope.sort_element.sort = !$scope.sort_element.sort;
           }




           $scope.sort  = function(pat,event)
           {



              if (pat.pTypeId==16) return false;
             var check_clk=$(event.target).attr('data-clk');
             if (!check_clk) {
                console.log($('.table-responsive').css('height') );
               return false;
             }

             console.log(check_clk);


             var page = _.find(cooConfig.allpage,function(n){ return n.ID == $scope.pageId });


             var prt ;

             if (typeof(page.pageProperty) =='object'){
                 prt = page.pageProperty;
             }else{
                prt = JSON.parse(page.pageProperty);
             }





               if (check_clk =='btn_span')
               {
                 $($scope.l_pats).each(function(i,j){
                     if (j.ID!=pat.ID)  j.sort=false;
                 });

                 if ($scope.sort_source && $scope.sort_element && $scope.sort_element.ID ==pat.ID )
                 {
                     $scope.sort_element.sort = !$scope.sort_element.sort;
                     $scope.$$phase || $scope.$apply();
                     return false;
                 }

                 $scope.sort_element =pat;







                   var check_pat = _.find($scope.s_pats, function(j){
                      return j.ID == pat.ID
                   });
                   if (!check_pat)
                   {
                      pat.sort = !pat.sort;
                      $scope.sort_source =[];
                      $('.sort-panel').appendTo(event.target);
                      $('.sort-panel').css('left', (event.pageX-50)+'px');
                      $('.sort-panel').css('top', (event.pageY + 20)+'px');
                      $scope.$$phase || $scope.$apply();
                      return false;
                   }



                 if (!pat.sort && prt && prt.sort_page   &&  pat.pTypeId!=2 && pat.pTypeId!=13 && pat.pTypeId!=12 && pat.pTypeId!=19 && pat.pTypeId!=20 )
                 {
                    g.show_ajax();
                   var etor ={"pageId":prt.sort_page,"lscStr":"[{'_Key':'__c"+prt.sort_pat+"','_Value':"+ pat.ID +"}]"};
                    $.when(rest.bi(etor)).done(function(ret){
                      $scope.sort_source =[];

                       $.each(ret.data[0],function(i,j){
                         $scope.sort_source.push({
                           label: j['c'+pat.ID],
                           value: j['c'+pat.ID] }
                          );
                       });



                        pat.sort = !pat.sort;
                        $('.sort-panel').appendTo(event.target);

                        $('.sort-panel').css('left', (event.pageX-50)+'px');
                         $('.sort-panel').css('top', (event.pageY + 20)+'px');

                         g.hide_ajax();



                        $scope.$$phase || $scope.$apply();

                    });

                 }
                 else if (!pat.sort && (pat.pTypeId==2 || pat.pTypeId==13 || pat.pTypeId==20))
                 {
                    console.log('p213');
                    $scope.sort_source = pat.source;
                    pat.sort = !pat.sort;
                    $('.sort-panel').appendTo(event.target);
                    $('.sort-panel').css('left', (event.pageX-50)+'px');
                    $('.sort-panel').css('top', (event.pageY + 20)+'px');


                     $scope.$$phase || $scope.$apply();
                 }
                 else {
                     pat.sort = !pat.sort;
                     $scope.$$phase || $scope.$apply();
                 }

               }
               else if (check_clk=="btn_confirm")
               {
                  $scope.sort_search();
               }
               else if (check_clk=="btn_cancel")
               {
                 pat.sort = false;
                 $scope.$$phase || $scope.$apply();
               }


               // if (pat.orderBy==null)
               // {
               //   return false;3
               // }
               //
               // $scope.startIndex = 1;
               // var s_pat = _.find($scope.lsc,function(n){
               //         return n.patternId ==pat.ID;
               // });
               //
               // $($scope.lsc).each(function(i,j){
               //       j.orderBy=0;
               // });
               //
               // var v=1;
               // if (pat.orderBy==1)
               // {
               //     v=2;
               // }
               //
               // if (s_pat){
               //      s_pat.orderBy=v;
               // }
               // else {
               //     $scope.lsc.push({patternId:pat.ID,orderBy:v,pTypeId:pat.pTypeId });
               // }
               // pat.orderBy =v;
               // $scope.renderList();

           }

           $scope.make_lsc = function(){

             $scope.lsc =[];

             console.log($scope.s_pats2);



             $($scope.s_pats2).each(function(i,j){
                  switch (j.pTypeId) {
                   case 18:
                       console.log(j);
                       if (j.v1||j.v2||j.v3){
                         var vvv ="";
                         var vv2 = j.v3>0?(j.v3-1):10;
                         if (j.v2)  {
                            vvv = "1," + vv2.toString() ;
                         } else {
                           vvv = "0,"  + vv2.toString();
                         }

                          $scope.lsc.push({ patternId:j.ID,val1:j.v1 ,val2 :vvv ,pTypeId:j.pTypeId,operation:1 });

                       }

                   break;

                    case 3:
                    case 4:
                    case 6:
                      if (j.v1||j.v2){
                        if (j.v1)
                          $scope.lsc.push({ patternId:j.ID,val1:j.v1,pTypeId:j.pTypeId,operation:7 });
                        if (j.v2)
                         {
                           var j346 =j.v2;
                           if (j.pTypeId==6)
                           {
                             var dd1 = new Date(j.v2);
                             dd1.setDate(dd1.getDate() + 1);
                             j346 = g.date_str2(dd1);
                           }
                          $scope.lsc.push({ patternId:j.ID,val1:j346,pTypeId:j.pTypeId,operation:8 });
                         }
                      }
                      break;
                    case 12:
                    case 19:
                    case 23:

                          if (j.v !="" && j.v!='00000000-0000-0000-0000-000000000000')
                          {
                             $scope.lsc.push({ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:5 });
                              console.log(j.v);
                          }


                          break;
                    case 2:
                    case 13:
                    case 26:
                        if (j.v && j.v!=0 && j.v!="0")
                         $scope.lsc.push({ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:1 });
                      break;
                    case 1:
                         if (j.v!=0){
                             if (j.v ==4){
                               $scope.lsc.push({ patternId:j.ID,val1: 1 ,pTypeId:j.pTypeId,operation:4 });
                             }
                             else {
                               $scope.lsc.push({ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:1 });
                             }
                         }


                        break;
                    case 20:
                    if (j.v && j.v!=0 && j.v!="0")
                        $scope.lsc.push({ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:1 });
                     break;
                     case 5:
                     case 7:

                         if (j.v&&j.v.length>0)
                          {
                            var sc5 ={};
                            if (j.level){
                               sc5 ={ patternId:j.ID,val1:j.v,val2:j.level,pTypeId:j.pTypeId,operation:6};
                            }else{
                                 sc5 ={ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:6};
                            }

                            $scope.lsc.push(sc5);
                          }



                         break;
                    default:
                     break;
                  }
             });






      }




             $scope.dosearch = function () {

                console.log($scope.lsc);

                 $scope.make_lsc();



                 $scope.startIndex = 1;
                 $scope.renderList();
             };



             $scope.pageNumber = function (i) {
                     $scope.startIndex = i;
                     $scope.renderList();
             };


             $scope.pageSizeChange = function (p) {
                 $scope.pageSize = p;
                 $scope.startIndex = 1;
                 $scope.renderList();
             };

             $scope.getChecked = function () {
                   var ids=[];
                    $($('.table input:checked')).each(function(i,j){
                        if ($(j).attr('tag')) ids.push($(j).attr('tag'));
                    });
                     return ids.join(',');
              };
              //end of getChecked


             $scope.fakeDel = function (h) {
                var vals = $scope.getChecked();
                if (vals == "") return g.modal1('未选中！');

                var cfg = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key=='deleteConfirm'});

                if (cfg && cfg.configuration_value!='0' && cfg.configuration_value.toLowerCase()!='false')
                {

                      g.modal_info(function(message){

                            console.log(message);

                         if (!message || message.length<3){
                            g.modal1("必须填写相关信息，3-100字");
                         } else {



                           var etor = {
                               ids: vals,
                               categoryId: $scope.categoryId,
                               del: h,
                               message:message
                           };

                           g.show_ajax();

                           $.when(rest.fakeDel(etor)).done(function (f) {
                               if (f) { $scope.renderList(); } else { g.modal1('删除失败！'); };
                           });

                         }



                      });

                }else {

                  var etor = {
                      ids: vals,
                      categoryId: $scope.categoryId,
                      del: h
                  };


                  var ctn =0;
                  if (typeof udf_fakedel != 'undefined') {
                        var ctn =  udf_fakedel(etor);

                   }

                   if (ctn==0)
                   {
                        g.show_ajax();

                        $.when(rest.fakeDel(etor)).done(function (f) {
                            if (f) { $scope.renderList(); } else { g.modal1('删除失败！'); };
                        });
                   }

                }







            };
            //end of fakeDel


            $scope.update_status = function (pid, sid) {



                   var vals = $scope.getChecked();
                   if (vals == "") return g.modal1('未选中！');


                   if (sid.toString().length<10){
                       var ele = g.page_pats(pid);

                       var etor = {
                           ids: vals,
                           cateId: $scope.categoryId,
                           listPageId: $scope.pageId,
                           pageId: pid,
                           patternId: ele[0].ID,
                           statusId: sid
                       };

                       $.when(rest.updateStatus(etor)).done(function (f) {


                         //   console.log(f.resp.respCode);
                         //   console.log(f);
                           if (f.resp.respCode=="000000")
                           { $scope.renderList(); } else { g.modal1(f.resp.message); };
                       });
                   }
                   else{
                     var vPage = _.find(cooConfig.allpage,function(n){ return n.parentId ==$scope.pageId && n.pageType ==14  });

                     var args = vals.split(',');
                     var RetArray = [];
                     var indexPat = _.find(cooConfig.allpattern,function(n){return n.categoryId==$scope.categoryId && n.pTypeId ==16 });


                      $(args).each(function(i,j){
                          var row =[];
                          row.push({ _Key: '__c' + pid , _Value: sid });
                          row.push({ _Key: '__c' + indexPat.ID , _Value: j });
                          RetArray.push(row);
                      });

                      var etor ={
                         jsonStr: JSON.stringify(RetArray),
                         pageId: vPage.ID

                      }


                 //      console.log(etor);
                 //     return false;

                      $.when(rest.bulkCreate(etor)).done(function(ret){


                       $scope.renderList();

                      });


                   }





                };
            //end of update_status

            $scope.adminDel = function(){

              g.modal_confirm("确认删除?",function(){

                      var vals = $scope.getChecked();
                      if (vals == "") return g.modal1('未选中！');

                      var etor = {
                          ids: vals,
                          categoryId: $scope.categoryId,
                      };

                      $.when(rest.adminDel(etor)).done(function (f) {
                          if (f) { $scope.renderList(); } else { g.modal1('删除失败！'); };
                      });



              });
            }
              //end of adminDel;

            $scope.datalog = function(){
                  var ids = $scope.getChecked();
                  if (!ids) return ;
                  var id = ids.replace(/,.+$/ig,'');
                  g.datalog_modal($scope.categoryId,id);
            }

            //newTab
            $scope.newTab = function(row,column){

                  var lk = column.link;


                  var v1 = lk.route.replace(/\(.+$/ig,'');
                  var s = lk.route.replace(/^.+\(/ig,'').replace(/\)/ig,'');

                  var rCol = _.find(row,function(n){ return n.ID ==lk.patternId });
                  var rex = new RegExp('<<c\\d+>>', 'g');
                  var f = s.match(rex);

                  for(var i=0;i<f.length;i++)
                  {
                        var pid = f[i].replace(/\D/ig,'');
                        var cell = _.find(row,function(n){ return n.ID.toString()== pid });
                        if (cell) {
                           s = s.replace(f[i],cell.val);
                        }
                  }

                   s= s.replace(/([a-z0-9]+)\s*?:/ig,'"$1":').replace(/'/ig,'"');


                  var url = $state.href(v1, JSON.parse(s), {absolute: true});
                  var url = 'index.html' + url.replace(/^.+#/ig,'#');
                  url = window.location.href.replace(/index.html#.+$/ig,url);
                  window.open(url,'_blank');


              }






             $scope.renderList = function () {

                //接受url参数
                var urlParams = g.getURLParameter(window.location.href,'lsc');
                if (urlParams){
                  var url_lsc = JSON.parse(urlParams);

                //  console.log(url_lsc);


                  $(url_lsc).each(function(i,j){
                    if (j.pTypeId == 23){
                        $scope.text_valuex = j.v;
                        var vj  =  _.find(cooConfig.alljoin ,function(n) { return n.baseId == j.patternId } );
                        if (vj) {
                           $scope.text_labelx = vj.viewPatternId.toString();
                        }
                    }

                //    $scope.lsc= _.filter($scope.lsc,function(n){ return n.patternId!=j.patternId});
                    $scope.lsc.push(j);

                  })
                }
                  //接受url参数


                if ($scope.base_lsc)
                {
                   $($scope.base_lsc).each(function(i,j){
                       if (j.pTypeId == 23){
                           $scope.text_valuex = j.v;
                           var vj  =  _.find(cooConfig.alljoin ,function(n) { return n.baseId == j.patternId } );
                           if (vj) {
                              $scope.text_labelx = vj.viewPatternId.toString();
                           }
                       }

                       $scope.lsc= _.filter($scope.lsc,function(n){ return n.patternId!=j.patternId});
                       $scope.lsc.push(j);
                   });
                }





                  var nv =_.find($rootScope.breadcrumb,function(n){ return n.url=='#/list/'+categoryId +'/page/'+pageId });

                  if (nv)
                  {
                    nv['lsc']=$scope.lsc;
                    nv['startIndex']=$scope.startIndex;
                    nv['pageSize'] = $scope.pageSize;
                  }



                  g.show_ajax();
                  $.when(rest.search2($scope.categoryId, $scope.pageId, $scope.lsc, $scope.startIndex, $scope.pageSize)).done(function (result) {

                      //todo server
                      var r = /pageNumber\((\d+)\)/ig;
                      var r2 = /strong>(\d+)/ig;
                      var r_total =/\d+$/ig;
                      var matches = [], found;
                      while (found = r.exec(result.p)) {
                          matches.push(parseInt(found[1]));
                      }
                      var m = r2.exec(result.p);
                      var m_total =r_total.exec(result.s);
                      if (m&&m.length>0)
                      {
                        matches.push(parseInt(m[1]));
                      }
                      var total = 1;
                      if (matches.length > 0) total = Math.max.apply(Math, matches);

                      //todo

                      $scope.paging = g.getPaging(total, $scope.startIndex);



                      //paging
                       $scope.totalItems = m_total? parseInt(m_total[0]):0;









                      //paging


                      if (result.s != undefined) $scope.s = result.s.replace(/<[^>]+>/ig, '');
                       $scope.s = $scope.s.replace(/(\.\d\d)(\d+)/ig,  '$1' );
                       $scope.s = $scope.s.replace(/(\d+(\.\d+)*)/ig,  '[$1]' );
                       var matches = [], found;
                       var rdata =/\d+(\.\d+)*/ig;
                       var z=0;
                       while (found = rdata.exec($scope.s) ) {
                           if ((z++)>10) break;
                             matches.push(found[0]);
                       };
                       $(matches).each(function(x,y){
                            $scope.s= $scope.s.replace('['+y+']',g.fmoney(y,2));
                       });





                      var vdata = [];
                      var vdata2=[];
                      var cids =[];

                      var pg14= _.find(cooConfig.allpage,function(n){ return n.pageType==14 && n.parentId == $scope.pageId });
                      var pgMain = _.find(cooConfig.allpage,function(n){ return n.pageType==10 && n.ID == $scope.pageId });

                      var pgProp = g.wrapProperty(pgMain.pageProperty);
                      var pgElements = pgProp.elements?pgProp.elements:[];




                      $(result.data).each(function (j, val) {

                         if (val['__c'+ $scope.p_index_id])  cids.push(val['__c'+ $scope.p_index_id]);

                          var row = [];



                          var rec = _.filter($scope.l_pats,function(n){return n.checked==true});

                          var row2= g.prepare_raw(val,rec)

                          for (var k = 0; k < rec.length; k++) {

                              var v = g.prepareVal(val, rec[k]);

                              var displayV = g.prepareDisplay(v,rec[k]);





                              if (rec[k].pTypeId==7 )
                              {
                                v = val["__c" + rec[k].ID];
                                if (v && v.length>0)
                                {
                                  v= v.replace(/<[^<>]+>/ig,'');
                                  if (v.length>50) v= v.substr(0,50) +"...";
                                  v = $sce.trustAsHtml(v);
                                }
                              }
                              if (rec[k].pTypeId == 17 && v.length>0)
                              {
                                  row['tag'] =  v[0];
                              }




                              var cprop = g.wrapProperty(rec[k].property);
                              var link ="";
                              if (cprop.link) link = cprop.link;

                              var linkElement = _.find(pgElements,function(n){ return n.patternId == rec[k].ID  });
                              if (linkElement){
                                link = linkElement;
                              }



                              var ctor = { ID: rec[k].ID, link:link,  property: rec[k].property, pTypeId: rec[k].pTypeId, val: v ,v:displayV };

                              if (rec[k].level){
                                ctor.val = val['c'+rec[k].ID + '_'+rec[k].level];
                              }
                              row.push(ctor);

                              if (pg14){

                                var wrapProperty =g.wrapProperty(rec[k]['property_'+pg14.ID]);
                                var keys = _.keys(wrapProperty);
                                $(keys).each(function(x,y){

                                    if (y.indexOf('Text')>0){
                                      row[y]=    displayV;

                                    }
                                });

                              }


                          };







                          row['index'] = val['__c' + $scope.p_index_id];
                          row['server_identity'] =val.server_identity;
                          row['treeText'] =val.treeText;

                          row2['index'] = val['__c' + $scope.p_index_id];
                          row2['server_identity'] =val.server_identity;
                          row2['treeText'] =val.treeText;
                          var tablex =[];
                          var tablex_raw =[];

                        //  console.log($scope.l_sub_pats);


                          if (result.relatedData&&result.relatedData.length>0)
                           {
                              var rx = _.find(result.relatedData,function(n){ return ( n.itemId==row.index || n.itemId == row.ID )});
                              //  console.log($scope.l_sub_pats);
                               // console.log(val);
                              //   console.log(rx);
                              if (rx)
                              {

                                 $(rx.list).each(function(u,v){
                                     tablex_raw.push(g.prepare_raw(v,$scope.l_sub_pats));
                                     var sub_row=[];
                                     for (var k = 0; k < $scope.l_sub_pats.length; k++) {
                                         var vv = g.prepareVal(v, $scope.l_sub_pats[k]);
                                         var ctor = { ID: $scope.l_sub_pats[k].ID , pTypeId: $scope.l_sub_pats[k].pTypeId, val: vv };
                                          sub_row.push(ctor);
                                     };

                                     sub_row['server_identity'] = v.server_identity;

                                      tablex.push(sub_row);

                                 });


                              }

                           }



                          row['tablex'] = tablex;
                          row['tablex_raw'] = tablex_raw;

                          row2['tablex'] = tablex;
                          row2['tablex_raw'] = tablex_raw;
                          row['depth'] = val.depth;

                          if (val.color)   row['color'] = val.color;
                          vdata.push(row);
                          vdata2.push(row2);
                      });


                        $scope.vdata = vdata;
                        $scope.vdata2 =vdata2;



                        $scope.resultData = result.data;



                        var qlink = '<div class="qlink"></div>';  //todo

                        if (_.some($scope.lsc,function(n){ return n.pTypeId==15 }))
                        {
                          $scope.recycle_color="green";
                        }
                        else {
                            $scope.recycle_color="blue";
                        }

                        g.hide_ajax();

                        if ($scope.udf_before_list_apply){
                            $scope.udf_before_list_apply();
                        }

                        if (result.g.error){
                           g.modal1(result.g.error);
                        }



                        $scope.$apply();

                        $timeout(function(){


                          console.log($scope);




                        },3000);





                  });
              };






                $scope.select_change = function(s)
                {
                   $scope.dosearch();
                   console.log(s);
                }


                $scope.select_clear = function()
                {
                   $($scope.s_pats).each(function(i,j){
                     switch (j.pTypeId) {

                       case 2:
                       case 13:
                         j.v='0';
                         break;

                       default:
                         j.v='';
                         j.v1='';
                         j.v2='';
                         j.v3 ='';
                         break;
                     }

                   });

                   $scope.text_vy='';

                   if ($scope.first_user_pat){
                        $('#__c'+$scope.first_user_pat.ID).val('');
                   }



                   $scope.text_valuey ='';

                   $scope.dosearch();

                }


                $scope.status_change_ids =function(ids,s)
                {


                   if (ids.length==0) return false;


                   if (typeof udf_workflow != 'undefined') {
                          console.log('udf_workflow');
                          var ctn =  udf_workflow(etor);

                     }

                     if (ctn==0)
                     {

                              var etor = {
                                  ids:  ids.join(',').replace(/^,|,$/ig,''),
                                  cateId: $scope.categoryId,
                                  listPageId: $scope.pageId,
                                  pageId: $scope.status_page_id,
                                  statusId: s.ID
                              };


                              g.show_ajax();
                               $.when(rest.updateWorkFlow(etor)).done(function (f) {
                                   console.log(f);

                                   if (f.returnCode=='000000') {
                                      var msg ="ok";
                                      if (f.message!='') msg =f.message;

                                    $scope.renderList();


                                     } else {

                                         g.modal1(f.message);


                                      };
                               });
                                console.log(s);

                             }


                };

                $scope.status_change =function(s)
                {

                         var ids=[];
                          $($('.table input:checked')).each(function(i,j){
                               ids.push($(j).attr('tag'));
                          });

                         if (ids.length==0)
                         {
                            g.modal1('未选中');
                           return false;
                         }

                         var etor = {
                             ids:  ids.join(',').replace(/^,|,$/ig,''),
                             cateId: $scope.categoryId,
                             listPageId: $scope.pageId,
                             pageId: $scope.status_page_id,
                             statusId: s.ID
                         };

                        var ctn = 0 ;
                        if (typeof udf_workflow != 'undefined') {
                               console.log('udf_workflow');
                                ctn =  udf_workflow(etor);

                          }

                          console.log(etor);

                        if (ctn==0)
                        {




                            g.show_ajax();
                             $.when(rest.updateWorkFlow(etor)).done(function (f) {

                               console.log(f);

                               if (f.returnCode=='000000' || !f.returnCode) {
                                    var msg ="ok";
                                    if (f.message && f.message!='') msg =f.message;

                                  $scope.renderList();


                                   } else {

                                         g.modal1(f.message);


                                    };
                             });

                           console.log(s);
                         }
                };



                $scope.init_elements =function(p1,p2,c_p1,c_p2)
                {
                  if (c_p1.length==0){
                  //  var kc=0;
                    $(p1).each(function(i,j){
                        if (j.pTypeId==1||
                        j.pTypeId==2||
                        j.pTypeId==3||
                        j.pTypeId==4||
                        j.pTypeId==5||
                        j.pTypeId==6||
                        j.pTypeId==7||
                        j.pTypeId==12||
                        j.pTypeId==18||
                        j.pTypeId==19||
                        j.pTypeId==13||
                        j.pTypeId==20||
                        j.pTypeId==23||
                        j.pTypeId==26
                      )
                        {
                          //  kc++;
                          // if (kc>5) return false;
                          c_p1.push({id:j.ID,val:true});
                        }
                    });
                    console.log(c_p1);

                    g.write_file("c_element:"+$scope.page_s,JSON.stringify(c_p1));
                  }

                   $(p1).each(function(i,j){
                        var v_check = _.find(c_p1,function(n){ return n.id==j.ID});
                        if (v_check)  j.s_checked =v_check.val;
                        j.source = g.makeSource2(j,{});
                        if (j.pTypeId==2||j.pTypeId==13||j.pTypeId==26||j.pTypeId==20||j.pTypeId==3||j.pTypeId==4||j.pTypeId==6) j.v ="0";
                        if (j.pTypeId == 18) j.v3="0";
                   });
                   console.log(p1);
                   $scope.s_pats=p1;
                   $scope.s_pats2 =   _.filter($scope.s_pats,function(n){return n.s_checked==true });


            //       console.log(JSON.stringify($scope.s_pats2 ));
                  $($scope.s_pats2).each(function(i,j){
                        if (!j.idlevel){
                             if (j.level){
                                j.idlevel = j.ID.toString()+ '_'+ j.level.toString() ;
                             }else{
                                 j.idlevel = j.ID.toString();
                             }
                        }
                  });

                   var txt =   _.find($scope.s_pats2,function(n){return n.pTypeId==5 || n.pTypeId==7 });


                   if (txt){
                     $scope.text_labelx =  txt.idlevel;
                   }
                   var txt2 =   _.find($scope.s_pats2,function(n){return n.pTypeId==12 || n.pTypeId==19 });
                   if (txt2){
                     $scope.text_labely = txt2.ID.toString();
                   }


                   if (c_p2.length==0)
                   {
                     $(p2).each(function(i,j){
                        //  if (i>8) return false;
                           c_p2.push({id:j.ID,val:true});
                     });
                     g.write_file("c_element:"+$scope.page_l,JSON.stringify(c_p2));
                   }

                   var c_ids=[];
                   $(c_p2).each(function(i,j){
                       c_ids.push(j.id);
                   });
                   $(p2).each(function(i,j){
                        var ord =  $.inArray(j.ID,c_ids);
                        if (ord<0) ord = 100;
                        j.new_order = ord;

                        var ele = _.find(c_p2,function(n){
                             return n.id==j.ID
                        });
                        if (ele&&ele.width) j.width=ele.width;

                        var v_check = _.find(c_p2,function(n){ return n.id==j.ID});
                        if (v_check) j.checked =v_check.val;
                   });
                   $scope.l_pats =_.sortBy(p2,'new_order');

                   if ($scope.order_pats.length>0)
                   {



                      $($scope.l_pats).each(function(i,j){

                             var pt = _.find($scope.order_pats,function(n){ return n.ID==j.ID  });
                             if (pt){
                               j.orderBy = 0;

                             }
                      });
                   }

                };


                $scope.remoteUserSelect = function(){





                }


                $scope.remoteSelect = function(){

                  var groupIds=[];
                  var patternId =0;
                  var vj ={};

                  $($scope.s_pats2).each(function(i,j){
                     if (j.pTypeId ==23 && j.property && j.property.type=='select'){

                         var groupId = j.property.groupId;
                         var filterPatternId = j.property.patternId;
                         vj = _.find( cooConfig.alljoin,function(n){
                            return  n.baseId == j.ID;
                         });
                         if (groupId){
                           groupIds.push(groupId);
                           patternId =  filterPatternId;
                         }
                       //  console.log(vj);
                     }
                  });



                   if (groupIds.length>0 && patternId>0 && vj){
                       var selectPages = _.filter(cooConfig.allpage,function(n){ return n.categoryId==vj.joinCategoryId && n.pageType ==10 });

                       if (selectPages.length>0){
                          selectPages = _.sortBy(selectPages,function(n){ return n.pageOrder });
                          var lsc =[{operation:5,pTypeId:5,patternId:patternId,val1:groupIds.join() }];
                          $.when(rest.search2(vj.joinCategoryId,selectPages[0].ID,lsc,0,300)).done(function(ret2){



                            $($scope.s_pats2).each(function(i,j){
                               if (j.pTypeId ==23 && j.property && j.property.type=='select'){

                                 vj = _.find( cooConfig.alljoin,function(n){  return  n.baseId == j.ID;    });
                                 var ms = [{ label: '请选择', value: '00000000-0000-0000-0000-000000000000' }];
                                 var r2 = _.filter(ret2.data,function(n){ return n['__c'+patternId] == j.property.groupId  });
                                 r2 = _.sortBy(r2,'ID');
                                 var ms2=[];

                                 console.log(r2);
                                 console.log(j);

                                 $(r2).each(function(x,y){
                                   ms.push({label: y['__c'+vj.viewPatternId]  ,value:y.server_identity });
                                   ms2.push({statusName:y['__c'+vj.viewPatternId],ID: y.server_identity });
                                 });
                                 j.source = ms;

                                 var pg = _.find($scope.status_pages ,function(n){ return n.UIname == j.pName });
                                 if (!pg){
                                    $scope.status_pages.push({ UIname:j.pName ,ID:j.ID ,source: ms2});
                                 }

                               }
                             });


                             console.log($scope.status_pages);


                             $timeout(function(){
                                 $scope.$$phase || $scope.$apply();
                              //   $(".ui-chosen").trigger("chosen:updated");
                             },300);
                          });
                       }
                   }



                }



                $scope.action_tag = function(row){
                    console.log(row.current_tag_display);
                    row.current_tag_display = !row.current_tag_display;
                }

                $scope.filterTag = function(tagId)
                {
                   var tagPat = _.find($scope.l_pats,function(n){return n.pTypeId==17});
                   $scope.lsc = _.filter($scope.lsc,function(n) {return n.pTypeId!=17});
                   $scope.lsc.push({ patternId:tagPat.ID,val1:tagId,pTypeId:17,operation:1 });
                   $scope.startIndex = 1;
                   $scope.renderList();

                }


                $scope.addtag = function(row,tag)
                {
                   var pg = _.find(cooConfig.allpage,function(n){ return n.pageType ==2 && n.categoryId == $scope.categoryId});
                   var tagPat = _.find(cooConfig.allpattern,function(n){ return n.pTypeId == 17 && n.categoryId == $scope.categoryId});
                   if (pg &&tagPat){
                       var update_json = [ { _Key: '__c' + tagPat.ID , _Value: tag.ID } ];

                       var etor = {
                           jsonStr: JSON.stringify(update_json),
                           relatedSTR: '[]',
                           pageId: pg.ID,
                           itemId: row.index
                       };

                      $.when(rest.create(etor)).done(function(ret){
                            row.current_tag_display = !row.current_tag_display;

                            $scope.renderList();
                      });
                   }

                }


                $scope.action_menu = function(row){
                   row.current_row_display = !row.current_row_display;
                };

                $scope.edit =function(row){



                  if ($scope.edit2)
                  {
                    $scope.edit2(row);
                  }
                  else {
                    var route_name ='app.pagex.edit';
                    if ($scope.edit_pages[0].pageProperty && $scope.edit_pages[0].pageProperty!='null')
                    {
                      var pageProperty = JSON.parse($scope.edit_pages[0].pageProperty);
                      if (pageProperty.route) route_name = pageProperty.route;
                    }
                    $state.go(route_name,{pageId:$scope.edit_pages[0].ID,categoryId:$scope.categoryId,itemId:row.index});
                     console.log(row);
                  }




                };

                $scope.menu_action1 = function(row){
                    row.current_row_display = !row.current_row_display;
                }


                $scope.show_sub =function(row)
                {
                   row.sub_show= !row.sub_show;
                }

                $scope.expand_search = function()
                {
                   $scope.search_expand = !$scope.search_expand;
                }


                $.when(
                    g.page_update($scope.pageId)
                  ).done(function(){

                      $scope.page = _.find(cooConfig.allpage,function(n){
                          return n.ID==$scope.pageId
                      });



                      if ($scope.page){
                        $scope.page.pageProperty = g.wrapProperty($scope.page.pageProperty);
                      }else{
                        $scope.page={};
                      }

                      $scope.leftColumns =3;

                     if ($scope.page.pageProperty.leftColumns){
                         $scope.leftColumns =$scope.page.pageProperty.leftColumns;
                     }




                     var filterPages = cooConfig.allpage;
                     if ($scope.page.pageProperty && $scope.page.pageProperty.filterPageIds){
                          filterPages = _.filter(cooConfig.allpage,function(n){
                             return (',' + $scope.page.pageProperty.filterPageIds+',').indexOf(','+ n.ID.toString()+',')>=0  });

                     }





                     $scope.edit_pages = _.filter(filterPages,function(n){
                        if ($scope.page.pageProperty && $scope.page.pageProperty.filterPageIds){
                            return   (n.pageType==2||n.pageType==100) ;
                        }
                        else{
                          return   (n.pageType==2||n.pageType==100) && n.categoryId==$scope.categoryId;
                        }

                     });

                     $(filterPages).each(function(i,j){
                        j.pageProperty = g.wrapProperty(j.pageProperty);
                     });



                     $scope.create_pages = _.filter(filterPages,function(n){
                         if ($scope.page.pageProperty && $scope.page.pageProperty.filterPageIds){
                             return   (n.pageType==2||n.pageType==100 ||n.pageType==5) && n.pageProperty.topCreate   && n.categoryId==$scope.categoryId ;
                         }
                         else{
                           return   (n.pageType==2||n.pageType==100 ||n.pageType==5)  && n.pageProperty.topCreate && n.categoryId==$scope.categoryId;
                         }
                     });

                     $scope.detail_pages = _.filter(filterPages,function(n){
                         if ($scope.page.pageProperty && $scope.page.pageProperty.filterPageIds){
                             return   (n.pageType==8||n.pageType==101 ) ;
                         }
                         else{
                           return   (n.pageType==8||n.pageType==101 ) && n.categoryId==$scope.categoryId;
                         }
                     });

                     //$scope.top_setting
                     $scope.del_pages =  _.filter(cooConfig.allpage,function(n){
                         return   (n.pageType==1) && n.categoryId==$scope.categoryId;
                     });

                     if (!$scope.del_pages || $scope.del_pages.length==0)  $scope.top_setting.del =false;


                     $scope.import_pages = _.filter(filterPages,function(n){
                         return   (n.pageType==31) && n.categoryId==$scope.categoryId;
                     });

                     $scope.export_pages = _.filter(filterPages,function(n){
                         return   (n.pageType==7 || g.property(n.pageProperty,"pageType")=="7") && n.categoryId==$scope.categoryId;
                     });





                     $scope.status_pages = _.filter(filterPages,function(n){
                        return   (n.pageType==3) && n.categoryId==$scope.categoryId;
                     });


                     $($scope.status_pages).each(function(i,j){

                            var pats = g.page_pats(j.ID);
                            var ws = _.filter(cooConfig.allworkflow,function(n){  return n.categoryId == j.categoryId  });
                            var wids = _.pluck(ws,"tagId2");
                            if (pats.length>0){
                                var group = _.find(cooConfig.allstatusmap,function(n){return n.patternId== pats[0].ID });

                                if (group){
                                  j.source = _.filter(cooConfig.allstatus,function(n) { return n.groupId==group.groupId  });
                                  j.source = _.sortBy(j.source,'statusOrder');
                                  console.log(j.source);
                                }
                            }
                     });




                     //console.log($scope.edit_pages);
                     //
                     //
                    //  if ($scope.edit_pages)
                     $scope.detail_pages= _.sortBy($scope.detail_pages,"pageOrder");

                     $($scope.detail_pages).each(function(i,j){

                           if (!j.pageProperty)
                           {
                                j.pageProperty ={};
                                return ;
                           }

                            if (typeof (j.pageProperty) == 'object') return ;
                           if (j.pageProperty && j.pageProperty!='null'   )
                           {
                              j.pageProperty = JSON.parse(j.pageProperty);
                           }
                           else {
                             j.pageProperty ={};
                           }
                     });




                    $scope.detail_pages = _.filter($scope.detail_pages,function(n){


                        return  !n.pageProperty || !n.pageProperty.custom

                    });



                     if ($scope.create_pages)
                     {
                       $scope.create_pages= _.sortBy($scope.create_pages,"pageOrder");

                     }
                     $($scope.create_pages).each(function(i,j){

                           if (!j.pageProperty)
                           {
                                j.pageProperty ={};
                                return ;
                           }

                            if (typeof (j.pageProperty) == 'object') return ;
                           if (j.pageProperty && j.pageProperty!='null'   )
                           {
                              j.pageProperty = JSON.parse(j.pageProperty);
                           }
                           else {
                             j.pageProperty ={};
                           }
                     });



                     $scope.edit_pages= _.sortBy($scope.edit_pages,"pageOrder");
                     $($scope.edit_pages).each(function(i,j){

                           if (!j.pageProperty)
                           {
                                j.pageProperty ={};
                                return ;
                           }

                            if (typeof (j.pageProperty) == 'object') return ;
                           if (j.pageProperty && j.pageProperty!='null'   )
                           {
                              j.pageProperty = JSON.parse(j.pageProperty);
                           }
                           else {
                             j.pageProperty ={};
                           }
                     });






                     console.log($scope.pageId);

                     console.log($scope.page);





                     var pgProperty ={};
                     if ($scope.page.pageProperty){
                        if (typeof $scope.page.pageProperty =="string" ){
                           pgProperty= JSON.parse($scope.page.pageProperty);
                        }
                        else {
                           pgProperty=$scope.page.pageProperty;
                        }
                     }


                     var allowDelRoleIds_cfg = _.find(cooConfig.allconfiguration,function(n){
                       return n.configuration_key =='allowDelRoleIds';
                     });

                     if (allowDelRoleIds_cfg)
                     {
                         var a1s= allowDelRoleIds_cfg.configuration_value.split(',');
                         var delSetting =false;

                         $(a1s).each(function(i,j){
                             if (cooConfig.configObj.RoleIds.toLowerCase().indexOf(j.toLowerCase())>=0){
                                delSetting =true;
                             }
                         });

                         console.log(delSetting);

                         $scope.top_setting.del = delSetting ;


                     }



                     $scope.order_page = _.find(filterPages,function(n){
                            return n.parentId==$scope.pageId && n.pageType==12
                      });







                     $scope.order_pats =[];
                     if ($scope.order_page){

                        $scope.order_pats =  g.page_pats($scope.order_page.ID);

                     }






                      console.log($scope.pageId);


                      $scope.page_s = _.find(cooConfig.allpage,function(n){
                          return n.parentId==$scope.pageId && n.pageType ==11
                      }).ID ;

                      $scope.page_l = _.find(cooConfig.allpage,function(n){
                          return n.parentId==$scope.pageId && n.pageType ==14
                      }).ID ;



                       console.log($scope.categoryId);
                       var ppp = _.filter(cooConfig.allpattern,function(n){
                          return n.categoryId ==$scope.categoryId
                       }) ;
                       console.log(ppp);

                      $scope.p_index_id =_.find(cooConfig.allpattern,function(n){
                         return n.categoryId ==$scope.categoryId && n.pTypeId==16
                      }).ID;

                      $scope.page_sub_l=0;
                      $scope.status_page_id=0;


                     var page_sub_l =  _.find(cooConfig.allpage,function(n){
                          return n.parentId==$scope.page_l
                      })  ;




                      if (page_sub_l)   $scope.page_sub_l=  page_sub_l.ID;

                      var status_page= _.find(filterPages,function(n){
                          return n.categoryId==$scope.categoryId && n.pageType==9
                      }) ;
                      if (status_page){
                         $scope.status_page =status_page;
                         $scope.status_page_id=  status_page.ID;



                         var status_pat = _.find(cooConfig.allpattern,function(n){return n.pTypeId==13 && n.categoryId==$scope.categoryId});



                         if (!status_pat) return false;

                          var group = _.find(cooConfig.allstatusmap,function(n){return n.patternId==status_pat.ID});

                           console.log(group);

                          var ws = _.filter(cooConfig.allworkflow,function(n){  return n.categoryId == status_pat.categoryId  });
                          console.log(ws);
                          console.log(cooConfig.configObj.isAdmin);
                          var wids = _.pluck(ws,"tagId2");
                          $scope.status_page.source = _.filter(cooConfig.allstatus,function(n) { return n.groupId==group.groupId && wids.indexOf(n.ID)>=0});

                          if (cooConfig.configObj.isAdmin)
                          {
                            $scope.status_page.source = _.filter(cooConfig.allstatus,function(n) { return n.groupId==group.groupId });

                          }



                          $scope.status_page.source = _.sortBy($scope.status_page.source,'statusOrder');


                            console.log($scope.status_page.source);
                       }



                       $scope.l_sub_pats =  g.page_pats($scope.page_sub_l)   ;
                       console.log(page_sub_l);
                       console.log($scope.page_l);
                       console.log($scope.page_sub_l);
                       console.log($scope.l_sub_pats)



                       var p1 = g.page_pats($scope.page_s)   ;
                       var p2 = g.page_pats($scope.page_l)   ;
                       var c_p1= g.fetch2("c_element:"+$scope.page_s);
                       var c_p2= g.fetch2("c_element:"+$scope.page_l);



                       $scope.init_elements(p1,p2,c_p1,c_p2);

                       $scope.remoteSelect();

                       $scope.first_user_pat = _.find($scope.s_pats2,function(n){ return n.pTypeId==12 || n.pTypeId==19});



                       if ($scope.udf_init)
                       {
                         $scope.udf_init();
                       }



                       $scope.renderList();
                    });

    };

    g.clear_search_pats=function(pats)
    {
      $(pats).each(function(i,j){
        switch (j.pTypeId) {
          case 2:
          case 13:
            j.v='0';
            break;
          default:
            j.v='';
            j.v1='';
            j.v2='';
            break;
        }
      });

    };


    g.c_pats =function(page_s,p1,c_p1)
    {

      console.log(c_p1);
      console.log(p1);


      if (c_p1.length==0){
        $(p1).each(function(i,j){
            //  if (i>0) return false;
              c_p1.push({id:j.ID,val:true});
        });
        g.write_file("c_element:"+ page_s,JSON.stringify(c_p1));

      }



       $(p1).each(function(i,j){
            var v_check = _.find(c_p1,function(n){ return n.id==j.ID});
            if (v_check)  j.s_checked =v_check.val;
            j.source = g.makeSource2(j,{});
            if (j.pTypeId==2||j.pTypeId==13||j.pTypeId==20||j.pTypeId==3||j.pTypeId==4||j.pTypeId==6) j.v ="0";
       });
        var  r_p = _.filter(p1,function(n){ return n.s_checked==true});
       return r_p;
    }



        g.init_l_d_scope= function($scope){





          $scope.lsc=[];
          $scope.startIndex =1;
          $scope.pageSize =10;
          $scope.search_open=false;
          $scope.s_pats=[];
          $scope.s_pats2=[];
          $scope.c_p1=[];



         $scope.renderList =function()
         {


           console.log($scope.categoryId);


           $.when(rest.search2($scope.categoryId, $scope.pageId, $scope.lsc, $scope.startIndex, $scope.pageSize))
           .done(function (result) {

                 $scope.vdata =result.data;
                 $($scope.vdata).each(function(x,y){
                    $($scope.l_pats).each(function(i,j){

                        switch (j.pTypeId) {
                          case 5:
                           if (!y.first5) y.first5=y['__c'+j.ID];
                            break;
                          case 6:
                           if (!y.first6) y.first6=g.dateFormat(y['__c'+j.ID],{});

                            break;
                          case 4:
                           if (!y.first4) y.first4=y['__c'+j.ID];
                            break;
                          case 2:
                          case 13:
                            if (!y.first2) y.first2=y['__c'+j.ID]?y['__c'+j.ID].statusName:'';
                            break;
                          default:
                        }

                        if (j.pTypeId==6 && y['__c'+j.ID])  y['__c'+j.ID] = g.dateFormat(y['__c'+j.ID],{});
                        if (j.pTypeId==16)  y['index'] = y['__c'+j.ID];
                    });
                 });
                 var total =parseInt(result.s.replace(/\D/ig,''));
                  $scope.result_s = result.s;
                  $scope.total_pages = Math.ceil(total/ $scope.pageSize) ;

                 $scope.$$phase || $scope.$apply();

           });
         };


            $scope.open_search_setting =function()
            {


              $scope.search_open=!$scope.search_open;

              console.log($scope.search_open);

              if (!$scope.search_open)
              {
                 var new_s_pats=[];
                  $($scope.s_pats).each(function(x,y){
                      new_s_pats.push({id:y.ID ,val: y.s_checked});
                  });
                  $scope.s_pats2 =   _.filter($scope.s_pats,function(n){return n.s_checked==true });
                  console.log($scope.s_pats2);
                  g.write_file("c_element:"+ $scope.page_s ,JSON.stringify(new_s_pats));

              }
              // $scope.search_open=!$scope.search_open;
              // if (!$scope.search_open)
              // {
              //    var new_s_pats=[];
              //     $($scope.s_pats2).each(function(x,y){
              //         new_s_pats.push({id:y.ID ,val: y.s_checked});
              //     });
              //     g.write_file("c_element:"+ $scope.page_s ,JSON.stringify(new_s_pats));
              // }
            };


            $scope.select_change_modal = function(modal_pats)
            {
                 $scope.s_pats2 = modal_pats;
                 $scope.dosearch();

            }

            $scope.select_change = function()
            {
                    console.log('sh');
               $scope.dosearch();
            }

            $scope.make_lsc = function(){

              $scope.lsc =[];

              $($scope.s_pats2).each(function(i,j){
                   switch (j.pTypeId) {
                     case 3:
                     case 4:
                     case 6:
                       if (j.v1||j.v2){
                         if (j.v1)
                           $scope.lsc.push({ patternId:j.ID,val1:j.v1,pTypeId:j.pTypeId,operation:7 });
                         if (j.v2)
                           $scope.lsc.push({ patternId:j.ID,val1:j.v2,pTypeId:j.pTypeId,operation:8 });
                       }
                       break;
                    case 12:
                    case 19:
                        if (j.v && typeof(j.v)==="object")
                        {
                           j.v =  j.v.join(',');
                        }
                        $scope.lsc.push({ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:5 });
                     break;
                     case 2:
                     case 13:
                         if (j.v && j.v!=0 && j.v!="0")
                          $scope.lsc.push({ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:1 });
                       break;
                     case 5:



                         if (j.v   )
                          {
                            var sc5 ={};
                            if (j.level){
                               sc5 ={ patternId:j.ID,val1:j.v,val2:j.level,pTypeId:j.pTypeId,operation:6};
                            }else{
                                 sc5 ={ patternId:j.ID,val1:j.v,pTypeId:j.pTypeId,operation:6};
                            }

                            $scope.lsc.push(sc5);
                          }


                       break;
                     default:
                      break;
                   }
              });





            }

            $scope.dosearch = function () {




                $scope.make_lsc();



                $scope.startIndex = 1;
                $scope.renderList();
            };

             console.log($scope.pageId);

            $.when(g.page_update($scope.pageId))
            .done(function(){


                var pg = _.find(cooConfig.allpage,function(n){ return n.ID==$scope.pageId});
                $scope.pg =pg;
                $scope.page_sx =_.find(cooConfig.allpage,function(n){ return n.parentId==$scope.pageId && n.pageType==11}).ID;
                $scope.page_s = $scope.page_sx;
                $scope.page_l = _.find(cooConfig.allpage,function(n){ return n.parentId==$scope.pageId && n.pageType==14}).ID;
                $scope.categoryId = pg.categoryId;



                $scope.detail_pages = _.filter(cooConfig.allpage,function(n){
                    return   (n.pageType==8||n.pageType==101 || n.pageType==16) && n.categoryId==$scope.categoryId;
                });




                $scope.edit_pages = _.filter(cooConfig.allpage,function(n){
                    return   (n.pageType==2||n.pageType==100) && n.categoryId==$scope.categoryId;
                });

                $scope.create_pages = _.filter(cooConfig.allpage,function(n){
                    return   (n.pageType==15||n.pageType==99) && n.categoryId==$scope.categoryId;
                });







                $scope.s_pats= g.page_pats($scope.page_s)  ;
                $scope.l_pats =g.page_pats($scope.page_l)  ;
                $scope.c_p1 = g.fetch2("c_element:"+$scope.page_s);



                $scope.s_pats2 = g.c_pats($scope.page_s,$scope.s_pats,$scope.c_p1);
                if (!$scope.pagez)
                {
                     $scope.renderList();
                }

              });










        } ;


        g.init_l_d_detail_scope =function($scope )
        {


              $scope.elements=[];
              $scope.elements2={};
              $scope.sub_elements_1=[];
              $scope.l_pats=[];
              $scope.data={};
              $scope.related_pages=[];
              $scope.categoryId=0;



              $scope.renderList = function(){

                      $.when(rest.detail($scope.pageId,$scope.itemId),g.page_update($scope.pageId)
                    ).done(function(  ret ){


                         $scope.pg = _.find(cooConfig.allpage,function(n){ return n.ID==$scope.pageId});
                         $scope.categoryId = $scope.pg.categoryId;


                          $scope.page_s = $scope.pageId;
                          $scope.page_l = _.find(cooConfig.allpage,function(n){ return n.parentId==$scope.pageId  }).ID;

                          $scope.l_pats =g.page_pats($scope.page_l);
                           console.log($scope.page_l);
                          var pats  = g.page_pats($scope.pageId);

                          $scope.data = ret.data;
                          $scope.elements2 = g.prepare_raw(ret.data,pats);

                           $(pats).each(function (i, o) {
                             var source = g.makeSource2(o,ret.data);
                              var val =g.prepareVal(ret.data,o);
                              $scope.elements.push({ p: o, v: val, s: source });
                          });


                          $scope.elementsGroups =[];
                          var egroup ={ group:'-',elements:[]};
                          $(pats).each(function(i, o) {
                              var source=[];

                              var jj=0;
                              if (o.categoryId!=$scope.categoryId && o.pTypeId == 5)
                              {
                                    var join = _.filter(cooConfig.alljoin, function (n) { return n.categoryId == $scope.categoryId && n.joinCategoryId == o.categoryId && n.viewPatternId == o.ID });;// g.joinFilterByAB(categoryId, o.categoryId);

                                    if (join != undefined && join.length>0 ) {
                                        jj = join[0].baseId;
                                    }
                              }
                              source = g.makeSource2(o, ret.data);
                              var vv = g.prepareVal(ret.data, o);
                              if (o.property) {
                                o.placeholder = o.property.placeholder;
                              }
                              var e_val =ret.data['__c'+o.ID];
                              if (o.pTypeId==2||o.pTypeId==13){
                                 if (e_val) e_val =e_val.toString();
                              }

                              if (o.pTypeId==12)
                              {
                                  if (!e_val)
                                  {
                                     e_val ='';
                                  }else {
                                    e_val =  e_val.UserId
                                  }

                              }
                              if (o.pTypeId ==6)
                              {
                                 e_val  =vv;
                              }
                              if (o.pTypeId ==7 ){
                                e_val = $sce.trustAsHtml(vv);

                              }


                              if (o.element_property && o.element_property.group)
                                 {
                                     if (egroup.elements.length>0)   $scope.elementsGroups.push(egroup) ;
                                     egroup ={ group: o.element_property.group ,elements:[]};
                                 }

                                 egroup.elements.push({
                                    p:o,
                                    s:source,
                                    val: e_val,
                                    v: vv,
                                    j:jj
                                  });


                          });
                         $scope.elementsGroups.push(egroup);

                         console.log($scope.elementsGroups);













                          var sub_pages = _.filter(cooConfig.allpage, function(n) {
                              return n.parentId == $scope.pageId
                          });

                          sub_pages = _.sortBy(sub_pages,"pageOrder");


                          $(sub_pages).each(function(j, k) {
                              var sub_pats = g.page_pats(k.ID);
                              var index_pat = _.find(cooConfig.allpattern, function(n) {
                                  return n.categoryId == k.categoryId && n.pTypeId == 16
                              }).ID;

                              $(sub_pats).each(function(x, y) {
                                  if (y.categoryId == k.categoryId) {
                                      var jj = _.find(cooConfig.alljoin, function(n) {
                                          return n.baseId == y.ID
                                      });
                                      if (jj) y['j'] = jj.joinPatternId;
                                  } else {
                                      var jj1 = _.find(cooConfig.alljoin, function(n) {
                                          return n.viewPatternId == y.ID && n.categoryId == k.categoryId
                                      });
                                      if (jj1) y['j'] = jj1.baseId;
                                  }
                              });


                              $scope.related_pages.push({
                                  p: k,
                                  e: sub_pats,
                                  index: index_pat
                              });
                          });

                          $($scope.related_pages).each(function(q, kk) {
                              var r = _.find(ret.related, function(n) {
                                  return n.pageId == kk.p.ID
                              });
                              var sub_list = [];
                              if (r){
                                $(r.list).each(function(i, item) {
                                    var row =[];
                                    $(kk.e).each(function(r,s){
                                      row.push(
                                        {
                                          ID :s.ID,
                                          pTypeId : s.pTypeId,
                                          val:g.prepareVal(item,s)
                                        }
                                        );
                                    });
                                    row.pageId = kk.p.ID;
                                    sub_list.push(row);
                                });

                              }
                              kk.list = sub_list;
                          });
                          console.log($scope.related_pages);



                           var items = _.find(ret.related,function(n){ return n.pageId == $scope.page_l});
                           var list=[];

                           if (items)
                           {
                                 $(items.list).each(function(x,y){
                                        var row =[];
                                       $($scope.l_pats).each(function(s,t){
                                            var v = g.prepareVal(y, t);
                                            row.push( { ID: t.ID, pTypeId:t.pTypeId, val: v });
                                       });
                                       list.push(row);
                                   });
                           }
                            $scope.sub_elements_1 =list;
                            $scope.sub_list_raw = items.list;

                            if ($scope.udf_init){
                               $scope.udf_init();
                            }
                　　　　　　 $scope.$$phase || $scope.$apply();
                      });



              }


              $scope.renderList();








        };



        g.init_l_d_edit_scope = function($scope)
        {





          $scope.message ="todo";
          $scope.elements = [];
          $scope.related_pages=[];
          $scope.elementsTables=[];
          $scope.result ={};


          $scope.indexId = 0;
          var source = [];
          var prefix = '.createTable ';


         $scope.change = function(row,column,$event){



                column.e="e";
                $('.sub_table tr').removeClass('inner-active');
                $('.sub_table input').removeClass('inner-blank');
                $('.sub_table td').removeClass('inner-blank-td');
                if ($event && $event.target)
                {
                  $($event.target).closest('tr').addClass('inner-active');
                  $($event.target).closest('td').addClass('inner-blank-td');
                  $($event.target).addClass('inner-blank');
                }
         };


         $scope.add_child =function(r_page){

           var item={};
           var row =[];
           $(r_page.e).each(function(s, t) {
               var v = g.prepareVal(item, t);
               var sub_s = g.makeSource2(t, item);

               row.push({
                   ID: t.ID,
                   pTypeId: t.pTypeId,
                   categoryId:t.categoryId,
                   j:g.j( r_page.p.categoryId, t),
                   val: v,
                   s: sub_s
               });
           });
           r_page.list.push(row);
           //  $scope.$$phase || $scope.$apply();
         };

         $scope.remove =function(r_page,row,$index){
             r_page.list.splice($index, 1);
         }









          $scope.upload = function (files, element) {
                g.upload_files(files, element, $scope.categoryId,$scope.indexId);
                element.e="e";
                $scope.$$phase || $scope.$apply();
          };

          $scope.mclick = function(element){
              element['e']  ="e";
         };

         $scope.remove_attachment = function(element,att){
           var pp = element;
           $.when(rest.delFile($scope.categoryId, att.ID)).done(function () {
               if (pp.p.pTypeId==11){
                  pp.val="";
                  pp.v = "";
               }
               else {
                  pp.v = _.filter(element.v,function(n){ return n.ID!=att.ID });
                  var t = _.pluck(element.v,'ID');
                  element.val= t.join(',');
               }
                pp.e="e";
                $scope.$$phase || $scope.$apply();
           });


         };


         $scope.optionChange = function (element, v) {
             g.optionChange(element, v);
             element['e'] ="e";
             $scope.$$phase || $scope.$apply();
         };

         $scope.joinSelect = function(pindex,rowIndex,categoryId,ID,baseId,indexId)
         {
            g.joinSelect(pindex,rowIndex,categoryId,ID,baseId,indexId,$scope.elements);
         }

         $scope.joinSelect2 = function(pindex,rowIndex,categoryId,ID,baseId,indexId,pageId)
         {

            g.joinSelect2(pindex,rowIndex,categoryId,ID,baseId,indexId,pageId,$scope.related_pages);
         }

         $scope.checkValid = function (p) {
           g.checkValid('.main_table', p, $scope.indexId);
             //g.modal1(v);
         };







         $.when(
             g.page_update($scope.pageId)
             ).done(function() {

                $scope.edit_page = _.find(cooConfig.allpage,function(n){ return n.ID ==$scope.pageId});
                var pattern =  _.find(cooConfig.allpattern,function(n){return n.categoryId==$scope.categoryId && n.pTypeId==16});

                var main_pats = g.page_pats($scope.pageId);

                $(main_pats).each(function(i, o) {

                   var ms =g.makeSource2(o,{})  ;
                   var mv =g.prepareVal({},o);
                   if (o.pTypeId==2||o.pTypeId==13){
                       mv = "0";
                   }
                   $($scope.elements.push({
                      p:o,
                      s:ms,
                      val:mv
                    }));

               });


                var sub_pages = _.filter(cooConfig.allpage, function(n) {
                    return n.parentId == $scope.pageId
                });


                $(sub_pages).each(function(j, k) {
                    var sub_pats = g.page_pats(k.ID);

                    var index_pat = _.find(cooConfig.allpattern, function(n) {
                        return n.categoryId == $scope.categoryId && n.pTypeId == 16
                    }).ID;

                    $(sub_pats).each(function(x, y) {
                        if (y.categoryId == k.categoryId) {
                            var jj = _.find(cooConfig.alljoin, function(n) {
                                return n.baseId == y.ID
                            });
                            if (jj) y['j'] = jj.joinPatternId;
                        } else {
                            var jj1 = _.find(cooConfig.alljoin, function(n) {
                                return n.viewPatternId == y.ID && n.categoryId == k.categoryId
                            });
                            if (jj1) y['j'] = jj1.baseId;
                        }
                    });


                    $scope.related_pages.push({
                        p: k,
                        e: sub_pats,
                        index: index_pat
                    });
                });



                if ($scope.itemId > 0) {

                    $.when(rest.detail($scope.pageId, $scope.itemId)).done(function(result) {

                            $scope.indexId = result.data['__c' + pattern.ID];
                            $scope.elements=[];
                            $scope.result =result;

                            $(main_pats).each(function(i, o) {

                                var jj;
                                if (o.categoryId != $scope.categoryId) {
                                    var jid = _.filter(result.join, function(q) {
                                        return q.joinCategoryId == o.categoryId && q.categoryId == $scope.categoryId;
                                    });
                                    if (jid.length > 0) {
                                        jj = jid[0].joinId;
                                    }
                                }
                                source = g.makeSource2(o, result.data);
                                vv = g.prepareVal(result.data, o);
                                if (o.property) {
                                  o.placeholder = JSON.parse(o.property).placeholder;
                                }
                                var e_val =result.data['__c'+o.ID];
                                if (o.pTypeId==2||o.pTypeId==13){
                                   if (e_val)
                                   e_val =e_val.toString();
                                }

                                $scope.elements.push({
                                    p: o,
                                    val: e_val,
                                    v: vv,
                                    s: source,
                                    j: g.j($scope.categoryId, o),
                                   //  jelement: g.jElement($scope.categoryId, o),
                                    e: ''
                                });

                            });



                            $scope.elementsTables = [];
                            var k = 0;
                            var elementsGroup = _.groupBy($scope.elements, function(n) {
                                return n.p.eorder / 1000;
                            })
                            $(_.keys(elementsGroup)).each(function(i, j) {
                                var tb = [];
                                var tbrow = [];
                                k = 0;
                                $(elementsGroup[j]).each(function(x, y) {

                                    switch (y.p.pTypeId) {
                                        case 7:
                                        case 10:
                                        case 11:
                                            if (k % 2 == 1) tb.push(tbrow);
                                            k = 0;
                                            tbrow = [];
                                            break;
                                        default:
                                            if (k % 2 == 0) tbrow = [];
                                            k += 1;
                                            break;

                                    }
                                    tbrow.push(y);
                                    if (k % 2 == 0) tb.push(tbrow);
                                });
                                if (k % 2 == 1) tb.push(tbrow);
                                $scope.elementsTables.push(tb);
                            });






                            $($scope.related_pages).each(function(q, kk) {

                                var k = kk.p;

                                var r = _.find(result.related, function(n) {
                                    return n.pageId == k.ID
                                });





                                var sub_list = [];
                               if (r){
                                  $(r.list).each(function(i, item) {

                                      var row = [];
                                      $(kk.e).each(function(s, t) {
                                          var v = g.prepareVal(item, t);
                                          var sub_s = g.makeSource2(t, item);

                                          row.push({
                                              ID: t.ID,
                                              pTypeId: t.pTypeId,
                                              categoryId:t.categoryId,
                                              val: v,
                                              j: g.j(kk.p.categoryId, t),
                                              s: sub_s
                                          });
                                      });
                                      var sub_pattern =_.find(cooConfig.allpattern,function(n){return n.pTypeId==16&&n.categoryId==kk.p.categoryId});
                                      row['index']= item["__c"+sub_pattern.ID];
                                      sub_list.push(row);
                                  });
                                }

                                kk.list = sub_list;
                            });

                            $scope.editable = result.editable;

                            if ($scope.udf_init){
                               $scope.udf_init();
                            }

                            $scope.$apply();
                    });
                }


             });
        //end of when loaded

        $scope.doSubmit = function () {

            var check = true;
            var reqCheck = true;
            var uniCheck = true;
            var invalidMessage = "";


            $(".main_table [tag='edit']").each(function (i) {
                if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '') {
                    var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                    if (!regx.test($.trim($(this).val()))) {
                        $(this).addClass("fieldInvalid");
                        var tid = $(this).attr("id") ;
                        tid = tid.replace(/\D/ig,'');
                        var p =  _.find(cooConfig.allpattern,function(n){ return  n.ID== parseInt(tid); });;
                         if (p) invalidMessage=p.pName + " 格式不对 ";
                        check = false;
                        return false;
                    }
                }
            });

            if (!(check && reqCheck && uniCheck))
            {
               g.modal1(invalidMessage);
               return;
            }

            $(".main_table [req='true']").each(function() {
              if ($(this).val() == ''|| (!$(this).is('input') && $(this).val()=='0')||$(this).val()=='00000000-0000-0000-0000-000000000000'||$(this).val().indexOf('object:')>0) {


                   var tid = $(this).attr("id") ;
                   tid = tid.replace(/\D/ig,'');
                   var p =  _.find(cooConfig.allpattern,function(n){ return  n.ID== parseInt(tid); });
                   if (p) invalidMessage=p.pName + " 未填 ";
                    $(this).addClass("fieldInvalid");
                    reqCheck = false;
                    return false;
                }
            });

            if (!(check && reqCheck && uniCheck))
            {
               g.modal1(invalidMessage);
               return;
            }

            $(".main_table [unq='true']").each(function (i) {

                var $jq = $(this);
                if ($jq.val() != '') {
                    var cid = $scope.indexId;
                    var etor = {
                        val: $jq.val(),
                        name: $jq.attr('id'),
                        itemId: cid
                    };
                    $.when(rest.uniqueCheck(etor)).done(function (data) {
                        var rnum = /\d/;
                        if (rnum.test(data)) {
                            $('.main_table #' + etor.name).addClass("fieldInvalid");
                            var tid = $jq.attr("id") ;
                            tid = tid.replace(/\D/ig,'');
                            var p =  _.find(cooConfig.allpattern,function(n){ return  n.ID== parseInt(tid); });
                            if (p) invalidMessage=p.pName + " 已存在 ";
                            uniCheck = false;
                            return false;
                        }
                    });
                }
            });

            if (!(check && reqCheck && uniCheck))
            {
               g.modal1(invalidMessage);
               return;
            }

            $(".childTable [tag='edit']").each(function (i) {
                if ($(this).is(":visible"))
                {
                    if ($(this).attr("vad") && $(this).attr("vad") != '' && $(this).attr("vad") != 'null' && $(this).val() != '') {
                        var regx = new RegExp(decodeURIComponent($(this).attr("vad")));
                        if (!regx.test($.trim($(this).val()))) {
                            var tid = $(this).attr("name") ;
                            tid = tid.replace(/\D/ig,'');
                            var p =  _.find(cooConfig.allpattern,function(n){ return  n.ID== parseInt(tid); });
                            if (p) invalidMessage=p.pName + " 格式不对 ";
                            $(this).addClass("fieldInvalid");
                            check = false;
                            return false;
                        }
                    }
                }
            });
            $(".childTable [req='true']").each(function () {
                if ($(this).is(":visible"))
                {
                    if ($(this).val() == '') {
                        var tid = $(this).attr("name") ;
                        tid = tid.replace(/\D/ig,'');
                        var p =  _.find(cooConfig.allpattern,function(n){ return  n.ID== parseInt(tid); });
                        if (p) invalidMessage=p.pName + " 未填";
                        $(this).addClass("fieldInvalid");
                        reqCheck = false;
                        return false;
                    }
                }
            });

            if (!(check && reqCheck && uniCheck))
            {
               g.modal1(invalidMessage);
               return;
            }

             var ucheck=true;
             if (typeof udf_check != 'undefined'){
               var invalidMessage= udf_check();
               if (invalidMessage){
                 ucheck=false;
                 g.modal1(invalidMessage);
                 return;
               }
             }


             if (check && reqCheck && uniCheck &&ucheck) {

                 var RetArray =[];
                 var RArray =[];

                  var r_main = _.filter($scope.elements,function(n){ return n.e=='e' || n.pTypeId==16 ; });
                  r_main = g.row_date(r_main);
                  $(r_main).each(function(i,j){
                      var o = { _Key: '__c' + j.p.ID , _Value: j.val };
                      RetArray.push(o);
                  });

                  $($scope.related_pages).each(function(x,y){
                      $(y.list).each(function(i,j){
                           var row = _.filter(j,function(n){  return n.e=='e' || n.pTypeId==16  });
                           row =g.row_date(row);
                           if( row.length>1)  {
                             var erow = [];
                             $(row).each(function(m,n){
                                 var o = { _Key: '__c' + n.ID , _Value: n.val };
                                 erow.push(o);
                             });
                             RArray.push({
                                 key: y.p.ID,
                                 value: erow
                             });
                           }
                      });
                  });




                 if ($scope.related_pages.length==0){

                   var d1 = JSON.stringify(RetArray);
                   var d2 = JSON.stringify(RArray);

                   var etor = {
                       jsonStr: d1,
                       relatedSTR: d2,
                       pageId: $scope.pageId,
                       itemId: $scope.indexId
                   };

                 console.log(etor);

                    $('#submitEdit').prop('disabled',true);
                    $.when(rest.create(etor)).done(function (data) {

                       $('#submitEdit').prop('disabled',false);
                       if (data.returnCode !="000000" )
                       {
                            g.modal11(data.message,function(){
                               //todo ;
                            });
                       }
                       else {
                           g.modal11("ok!",function(){
                             if ($state.current.name=='app.pagex.create'){
                                 $scope.reset_form();
                             }
                           });
                       }
                       $scope.$apply();
                    });
                 }
                 else{

                      var mainData = [];
                      mainData.push({ key: '__p' + $scope.pageId, value: RetArray });


                     var delist = [];


                     $($scope.related_pages).each(function(a,r_page){

                         var items = _.find($scope.result.related,function(n){ return n.pageId ==r_page.p.ID});
                         var sub_pattern =_.find(cooConfig.allpattern,function(n){return n.pTypeId==16&&n.categoryId==r_page.p.categoryId});
                         $(items.list).each(function(i,j){

                             var check_item = _.find(r_page.list,function(n){ return n['index']==j['__c'+sub_pattern.ID] });
                             if (!check_item){
                                delist.push({ _Key: r_page.p.ID, _Value: j['__c'+sub_pattern.ID] });
                             }
                         });
                     });



                     var d1 = JSON.stringify(mainData);
                     var d2 = JSON.stringify(RArray);


                     var etor = {
                         jsonStr: d1,
                         relatedSTR: d2,
                         pageId: $scope.pageId,
                         itemId: $scope.indexId,
                         delSTR: JSON.stringify(delist)
                     };


                     $('#submitEdit').prop('disabled',true);
                     $.when(rest.complexUpdate(etor)).done(function (data) {

                       $('#submitEdit').prop('disabled',false);
                       if (data.returnCode !="000000" )
                       {

                            g.modal11(data.message,function(){


                               //todo ;
                            });
                       }
                       else {
                           g.modal11("已提交！",function(){
                             if ($state.current.name=='app.pagex.create'){
                                 $scope.reset_form();
                             }
                           });
                       }
                       $scope.$apply();

                     });
                 }
              }
          };


        $scope.reset_form = function(){

          $($scope.related_pages).each(function(i,j){
              j.list=[];
          });


          $($scope.elements).each(function(i,j){
              var mv =g.prepareVal({},j.p);
              if (j.p.pTypeId==2||j.p.pTypeId==13){
                  mv = "0";
              }
              j.val=mv;
              j.v="";
          });



        }




        };

        g.upload_file =function(file ){

              var dtd = $.Deferred();

              $upload.upload({
                  url: cooConfig.configObj.url + 'file/jcreate',
                  fields: {
                      key: cooConfig.configObj.uploadKey,
                      itemId: 0,
                      cateId: 0,
                  },
                  file: file
              }).progress(function (evt) {
                  var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
                  console.log('progress: ' + progressPercentage + '% ' + evt.config.file.name);
              }).success(function (data, status, headers, config) {

                   dtd.resolve(data);

               });

               return dtd.promise();


        }


        g.upload_files = function (files,element,categoryId,itemId,w) {
            var id = element.p.ID;
            var p = element.p;

            g.show_ajax();

            if (files && files.length) {
                for (var i = 0; i < files.length; i++) {
                    var file = files[i];

                    $upload.upload({
                        url: cooConfig.configObj.url + 'file/jcreate',
                        fields: {
                            key: cooConfig.configObj.uploadKey,
                            itemId: itemId,
                            cateId: categoryId,
                            w:w
                        },
                        file: file
                    }).progress(function (evt) {
                        var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
                        console.log('progress: ' + progressPercentage + '% ' + evt.config.file.name);
                    }).success(function (data, status, headers, config) {

                       g.hide_ajax();


                        var obj = data;
                        if (p.pTypeId == 11) {
                            element.val=obj.ID;
                            element.v = obj;
                        }
                        else {
                           if (!element.v) element.v=[];
                           var imgReg = /\.(bmp|jpg|jpeg|gif|png)$/ig;
                           if (imgReg.test(obj.FilePath)) {
                              obj.isImage =true;
                           }
                           element.v.push(obj);

                            var t = _.pluck(element.v,'ID');
                            element.val= t.join(',');
                        }
                        //$("#__c" + id).attr("v", "e");

                     });
                 }
             }
        };
        //end of uploadFiles

        g.optionChange2 = function(scope,element,v){

             if (!element.p.init) {

                 var cmap = _.find(cooConfig.allstatusmap, function (n) { return n.depth == element.p.ID && n.patternId != element.p.ID });
                 var childStatus= _.filter(cooConfig.allstatus, function (item) { return item.parentId == v });
                 var children =[];
                 $(childStatus).each(function(i,j){
                        children.push({label:j.statusName,value:j.ID});
                 })



                 if (cmap)
                 {
                    if (scope.elementsGroups){
                       $(scope.elementsGroups).each(function(p,g){
                           $(g.elements).each(function(i,j){
                                  if (j.p.ID == cmap.patternId){
                                     console.log(j);
                                     j.s =children;
                                  }
                           });
                       });
                    }
                    else {
                      var childElement = _.find(scope.elements,function(n){ return n.p.ID==cmap.patternId });
                      childElement.s = children;
                    }


                    //
                    scope.$$phase || scope.$apply();
                     $timeout(function () {
                            $("#__c"+cmap.patternId+"").trigger("chosen:updated");


                            if ($('#__c'+cmap.patternId ).attr('multiple')=='multiple'){

                                   $('#__c'+cmap.patternId ).multiselect('dataprovider', children);

                            }


                     }, 300);



                  //  console.log(children);
                     //
                     // $(  "#__c" + cmap.patternId).find('option').remove().end();
                     // $(  "#__c" + cmap.patternId).append('<option selected="selected" value="">请选择</option>');
                     // $(children).each(function (i, o) {
                     //           $(  "#__c" + cmap.patternId).append('<option value="' + o.ID + '">' + o.statusName + '</option>');
                     // });
                 }
             }

        }


        g.optionChange = function (element, v ) {

             console.log('xx');
             console.log(element);

                if (!element.p.init) {

                    var cmap = _.find(cooConfig.allstatusmap, function (n) { return n.depth == element.p.ID && n.patternId != element.p.ID });
                    var children= _.filter(cooConfig.allstatus, function (item) { return item.parentId == v });



                    if (cmap)
                    {
                       console.log(children);

                        $(  "#__c" + cmap.patternId).find('option').remove().end();
                        $(  "#__c" + cmap.patternId).append('<option selected="selected" value="">请选择</option>');
                        $(children).each(function (i, o) {
                                  $(  "#__c" + cmap.patternId).append('<option value="' + o.ID + '">' + o.statusName + '</option>');
                        });
                    }
                }

            };
            //end of optionChange

        g.checkValid = function (prefix,p,indexId) {
                var $jq = $(prefix+' [name="__c' + p.ID +'"]');
               var v = $.trim($jq.val());

               if (p.validator != null && p.validator != '') {

                   var regStr = p.validator;
                   if (regStr.indexOf('%') > -1) regStr = decodeURIComponent(regStr);
                   if (regStr.indexOf('%') > -1) regStr = decodeURIComponent(regStr);

                   var regx = new RegExp(regStr);
                   if (!regx.test(v) && v!='') {
                       $jq.addClass("fieldInvalid");
                       return false;
                   }
                   else {
                       $jq.removeClass("fieldInvalid");
                   }
               }

               if (p.required && v == '') {
                   $jq.addClass("fieldInvalid");
                   return false;
               }
               else {
                   $jq.removeClass("fieldInvalid");
               }
               var etor = {
                   val: v,
                   name: '__c' + p.ID,
                   itemId: indexId
               };

               if (p.isUnique) {
                   g.checkUQ(prefix, etor);
               }


           };
           //end of checkValid

       g.getNestedRegArrayString  = function(txt,left_match,right_match){

           var k = 0;
           var ret =[];
           var subTxt =txt;

           while (k++ < 100){

               var r1 = g.getNestedRegString(subTxt,left_match,right_match, true);

               if (!r1) break;

               ret.push(r1);
               subTxt = subTxt.substring( subTxt.indexOf(r1) + r1.length);


           }

           return ret;


       }

       //g.captureGroup regex eq
       g.getNestedRegString= function(txt,left_match,right_match,ff){
              var subGroups = 0;
              var endIndex  = 0;

           var startIndex= txt.indexOf(left_match);
           var e1Index = txt.indexOf(right_match);

           // console.log(e1Index);


           var leftLen =   left_match.length ;
           var rightLen = right_match.length;

           for(var i=0;i<txt.length;i++)
           {
              if ( txt.substr(i,leftLen) == left_match) {

                 // console.log(i);
                 // console.log('leftMatch');
                  subGroups++;
                  i+= leftLen-1;
                  continue;
              }

              if (txt.substr(i,rightLen) == right_match && subGroups !=0){
                  // console.log(i);
                  // console.log('rightMatch');
                  // console.log(subGroups);

                  subGroups-- ;

                  if (subGroups == 0){
                    endIndex = i + rightLen;
                    break;
                  }

                  i+= rightLen -1 ;
                  continue;
              }
           }


           // console.log(endIndex);
           //
           // console.log(txt.substring(startIndex,endIndex));

           if (ff){
               return txt.substring(startIndex,endIndex);
           }
           else{
             return  endIndex;
           }



       }



       g.checkUQ= function(prefix , etor)
          {
              var $jq = $(prefix+' [name ="' +etor.name +'" ]');
              $.when(rest.uniqueCheck(etor)).done(function (data) {
                  console.log(etor);

                  var rd = /\d/ig;
                  if (data != '' && rd.test(data)) {
                      $jq.addClass("fieldInvalid3");
                  }
                  else {
                      $jq.removeClass("fieldInvalid3");
                  }
              });
          }
          //end of checkUQ;

     g.modal1 =function(msg){

       console.log(msg);

      var modalInstance =  $modal.open({
          templateUrl: 'tpl/blocks/alert_modal.html',
          controller: 'alert_modal_instance_ctrl',
          size: "sm",
          resolve: {
            message:  function () {
             return msg;
           }
          }
        });

        g.hide_ajax();
     }
     //end of modal1



     g.grid_user  = function(scope,pats,patternId,identity,id1,id2)
     {


        var j_cell =$("[id$='"+id1+"-" +id2 +"-cell']");
        $('.grid_user').css('top',$(j_cell).offset().top);
        $('.grid_user').css('left',$(j_cell).offset().left);



        console.log('grid_user');
        //2-uiGrid-0008-cell


        scope.current_row = identity;
        if (scope.current_row['__c'+patternId])
        {
          $(".grid_user_select").val(scope.current_row['__c'+patternId + '_value' ]);
          $(".grid_user_select").trigger("chosen:updated");
        }

        scope.grid_user_element = _.find(pats,function(n){ return n.ID==patternId });
        scope.grid_user_element.s = g.makeSource2(scope.grid_user_element,{});





        $('.grid_user').show();

        if (!scope.grid_user_set)
        {
          scope.grid_user_set=1;

          $(".grid_user_select").chosen().change(function(i,j){

              if (!j) return false;

              var u = _.find(scope.userList,function(n){ return n.UserId == j.selected });
              scope.current_row['__c'+scope.grid_user_element.ID] = u.XingMing;
              scope.current_row['__c'+scope.grid_user_element.ID + '_value'   ] = u.UserId;
              $('.grid_user').hide();
              $(".grid_user_select").val('');
              $(".grid_user_select").trigger("chosen:updated");
               scope.$$phase || scope.$apply();
          });
        }
        scope.$$phase || scope.$apply();
    }

    //grid_cols_view
    g.grid_cols_view = function(scope,scopeGridOptions,pats,page,uiGridConstants){

      var upFlag =false;
      if (page.pageProperty){
         var prp = page.pageProperty;
         if (typeof(page.pageProperty) == 'string'){
            prp = JSON.parse(prp);
         }
         if (prp.up) upFlag = true;
      }

      scopeGridOptions.columnDefs=[];
       scopeGridOptions.columnDefs.push({
              name :'pageId' ,
              visible:false
       });

      scopeGridOptions.columnDefs.push({
        name:  'seq',
        displayName: '序号',
        enableSorting:false,
        cellTemplate: '<div class="ui-grid-cell-contents">{{grid.renderContainers.body.visibleRowCache.indexOf(row) +1 }}</div>',
        width:60
       } );


         $(pats).each(function(i,j){

           var col ={};
           var col_width =150;
           var col_view =0;
           var eleConfig ;

           var jProp = g.wrapProperty(j['property_'+ page.ID]);

           if (jProp.view){
             col_view = jProp.view;
           }

           if (jProp.config){
              eleConfig = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == jProp.config  });
           }

           if (jProp && jProp.width)
           {
              col_width = jProp.width;
           }

           var rr = j.required?' * ':'';
           var dsName = j.alias?j.alias:j.pName;

           switch (j.pTypeId) {

             case 3:
             case 4:

             if (eleConfig){

               col ={
                      name :'__c'+j.ID,
                      displayName:  rr  +  dsName ,
                      enableCellEdit:true,
                       enableSorting:false,
                       enableCellEditOnFocus: true,
                       cellClass:'ui_grid_input  ' ,
                       width:col_width,
                       editableCellTemplate:
                       '<div  ><form name="inputForm"  > '+
                         '<input ng-focus="grid.appScope.grid_select('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,$event);"  ng-click="grid.appScope.grid_select('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,$event);"    name="__c'+j.ID+'"    tag="{{row.entity.server_identity}}" type="text" ng-class="\'grid-input \' + \'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD" />' +
                          '</form></div>'
                       //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                    };

             }else  if (col_view){
               col ={
                      name :'__c'+j.ID,
                      displayName: rr + dsName  ,
                         enableSorting:false,
                      aggregationType: uiGridConstants.aggregationTypes.sum,
                      cellTemplate: '<div class="read-only-cell-contents ui-grid-cell-contents">{{MODEL_COL_FIELD}}</div>',
                      editableCellTemplate:'<div class="read-only-cell-contents ui-grid-cell-contents">{{MODEL_COL_FIELD}}</div>',
                      // cellClass:'ui_grid_input',
                      width:col_width
                    };
             }else{
               col ={
                      name :'__c'+j.ID,
                      displayName:rr +  dsName  ,
                      aggregationType: uiGridConstants.aggregationTypes.sum,
                      enableCellEditOnFocus: true,
                         enableSorting:false,
                      type: 'string',
                      cellClass:'ui_grid_input',
                      width:col_width
                    };

             }


             scopeGridOptions.columnDefs.push(col);
             break;
             case 11:

            col ={
                   name :'__c'+j.ID,
                   displayName:  dsName ,
                   enableCellEdit:true,
                    enableCellEditOnFocus: true,
                       enableSorting:false,
                    cellTemplate:'<div class="ui-image padder padder-v-sm">{{MODEL_COL_FIELD}}<img class="image-preview" ng-src="{{row.entity.__c'+j.ID+'__src}}" /></div>',
                    cellClass:'ui_grid_input ',
                    width:col_width,
                    editableCellTemplate:   // {{row.entity.__c'+j.ID+' }}
                    '<div class="cellImage">'+
                     ' <form name="inputForm"><span ng-class="\'colt\' + col.uid" ui-grid-editor  ng-model="MODEL_COL_FIELD"> <a  href="{{row.entity.__c'+j.ID+'__src}}" target="_blank"> {{row.entity.__c'+j.ID+' }} </a> </span>  '+
                     ' <span href="javascript:void(0);" ng-click="grid.appScope.remove_attachment_sub1(row.entity,'+j.ID+',row.entity.__c'+j.ID+'__att)" class="del"   > '+
                   '       <i class="glyphicon glyphicon-trash" style="font-size:16px;margin-top:8px;" ></i> '+
                   '   </span>    '+
                   '  <span style="cursor: pointer;"  class="upload-button" ng-file-select ng-file-change="grid.appScope.subUpload($files,'+j.ID+',\'{{row.entity.server_identity}}\' )">'+
                   '  <i class="glyphicon glyphicon-paperclip" style="font-size:16px;margin-top:8px;" ></i>'+
                   '</span>   </form>    '+
                  '</div>'
                    //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
               };
              scopeGridOptions.columnDefs.push(col);

             break;

             case 10:

            col ={
                   name :'__c'+j.ID,
                   displayName:  dsName ,
                   enableCellEdit:true,
                      enableSorting:false,
                    enableCellEditOnFocus: true,
                    cellClass:'ui_grid_input',
                    width:col_width,
                    editableCellTemplate:   // {{row.entity.__c'+j.ID+' }}
                    '<div class="cellImage">'+
                     ' <form name="inputForm"><span ng-class="\'colt\' + col.uid" ui-grid-editor  ng-model="MODEL_COL_FIELD">'+
                     '  </span>  <span ng-repeat="a in row.entity.__c'+j.ID+'__atts"> <a href="{{a.RawFilePath}}" target="_blank"> {{a.ID}}.{{a.ext}}</a>,   '+
                     ' <span href="javascript:void(0);" ng-click="grid.appScope.remove_attachment_sub2(row.entity,'+j.ID+',a)" class="del"   > '+
                   '       <i class="glyphicon glyphicon-trash" style="font-size:16px;margin-top:8px;" ></i> '+
                   '   </span> </span>    '+
                   '  <input style="cursor: pointer;width:30px;" value="上传"  class="upload-button" multiple ng-file-select ng-file-change="grid.appScope.subUpload2($files,'+j.ID+',\'{{row.entity.server_identity}}\' )" />'+
                   '   '+
                   '    </form>    '+
                  '</div>'
                    //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
               };
              scopeGridOptions.columnDefs.push(col);

             break;
             case 18:


             col ={
                     name :'__c'+j.ID,
                     displayName:  dsName +'(选择)',
                     enableCellEdit:true,
                        enableSorting:false,
                     enableCellEditOnFocus: true,
                     cellClass:'ui_grid_input',
                     width:col_width,
                     editableCellTemplate:
                     '<div><form name="inputForm"   > '+
                       '<input   ng-click="grid.appScope.inherit_modal('+page.ID+','+j.ID+',row.entity );" name="__c'+j.ID+'"  tag="{{row.entity.server_identity}}" type="text" ng-class="\'grid-input \' +  \'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD">' +
                        ' </form></div>'
                     //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                  };

             scopeGridOptions.columnDefs.push(col);

             break;
             case 5:
             case 7:

                    col ={
                           name :'__c'+j.ID,
                           displayName: rr +  dsName ,
                           enableCellEditOnFocus: true,
                              enableSorting:false,
                           type: 'string',
                           cellClass:'ui_grid_input',
                           width:col_width
                         };

               scopeGridOptions.columnDefs.push(col);
               break;
             case 1:
                 col = {
                    name :'__c'+j.ID,
                    displayName: dsName,
                    type: 'boolean',
                    enableCellEditOnFocus: true,
                       enableSorting:false,
                    cellFilter: 'true_false',
                          cellClass:'ui_grid_input',
                    width:col_width
                //    cellTemplate: '<input type="checkbox" class="new_checkbox" ng-model="row.entity.__c'+j.ID+'" >'
                      }
                scopeGridOptions.columnDefs.push(col);
              break;
              case 6:
               col = {
                  name :'__c'+j.ID,
                  displayName:  rr +  dsName ,
                  type: 'date',
                  cellFilter: 'date:"yyyy-MM-dd"',
                  enableCellEditOnFocus: true,
                     enableSorting:false,
                  cellClass:'ui_grid_input'                  ,
                  width:col_width
               }
               scopeGridOptions.columnDefs.push(col);
                break;
              case 2:
              case 13:
                    var c_source = g.makeSource2(j,{});
                    var group =_.find(cooConfig.allstatusmap,function(n){ return n.patternId==j.ID });
                    var groupId = group?group.groupId:0;

                   col =      { name:  '__c'+j.ID,
                   enableCellEditOnFocus: true,
                      enableSorting:false,
                   cellClass:'ui_grid_input',
                   displayName: rr +  dsName  ,
                   editableCellTemplate: 'ui-grid/dropdownEditor',
                   cellFilter: 'mapStatus:'+groupId+':'+j.ID,
                   editDropdownIdLabel:'value',
                   editDropdownValueLabel :'label',
                    editDropdownOptionsArray :
                      c_source  ,
                    width:col_width };
                    scopeGridOptions.columnDefs.push(col);
                   break;
             case 26:
                   var c_sourcex = g.makeSource2(j,{});
                  col =      { name:  '__c'+j.ID,
                  enableCellEditOnFocus: true,
                     enableSorting:false,
                  cellClass:'ui_grid_input',
                  displayName: dsName + rr,
                  editableCellTemplate: 'ui-grid/dropdownEditor',
                  cellFilter: 'mapDepartment',
                  editDropdownIdLabel:'value',
                  editDropdownValueLabel :'label',
                   editDropdownOptionsArray :
                     c_sourcex  ,
                   width:col_width };
                   scopeGridOptions.columnDefs.push(col);

                  break;
             case 12:
                   var col_width =150;

                   if (j['property_'+page.ID] && j['property_'+page.ID].width)
                   {
                      col_width = j['property_'+page.ID].width;
                   }

                   var c_source = g.makeSource2(j,{});

                   var group =_.find(cooConfig.allstatusmap,function(n){ return n.patternId==j.ID });
                   var groupId = group?group.groupId:0;




                   col ={
                          name :'__c'+j.ID,
                          displayName: dsName,
                          enableCellEdit:true,
                           enableCellEditOnFocus: true,
                              enableSorting:false,
                           cellClass:'ui_grid_input',
                           width:col_width,
                           editableCellTemplate:
                           '<div><form name="inputForm"> '+
                             '<input ui-focus="grid.appScope.grid_user('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+');" name="__c'+j.ID+'" tag="{{row.entity.server_identity}}"   type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
                           //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                        };

                   scopeGridOptions.columnDefs.push(col);
                  break;
             default:
                 col ={
                        name :'__c'+j.ID,
                        displayName: dsName + rr,
                        enableCellEdit:false,
                           enableSorting:false
                      };
           }









         });


    }


     //grid_cols
     g.grid_cols = function(scope,scopeGridOptions,pats,page,uiGridConstants){

       var upFlag =false;
       if (page.pageProperty){
          var prp = page.pageProperty;
          if (typeof(page.pageProperty) == 'string'){
             prp = JSON.parse(prp);
          }
          if (prp.up) upFlag = true;
       }

       scopeGridOptions.enableColumnResizing = true;

       scopeGridOptions.columnDefs=[];
       if (upFlag)
       {
            scopeGridOptions.columnDefs.push({
                   name :'server_identity2',
                   displayName: '操作',
                   headerCellTemplate: '<div class="cell_operation" >排序</div>',
                       cellClass:'ui_grid_input',
                       width:60,
                   cellTemplate: '<div class="cell_operation"　tag="{{row.entity.server_identity}}" ng-click="grid.appScope.up(row.entity,'+page.ID+');"><i class="fa fa-arrow-circle-up"></i></div>'
                 });

       }



       scopeGridOptions.columnDefs.push({
              name :'server_identity',
              displayName: '操作',
              enableCellEdit:false,
              headerCellTemplate: '<div class="cell_operation row-del"    ng-click="grid.appScope.addrow('+page.ID+');"><button class="btn btn-sm btn-bg btn-default">添加</button></div>',
                  cellClass:'ui_grid_input',
                  width:60,
              cellTemplate: '<div class="cell_operation  row-del open"　tag="{{row.entity.server_identity}}" ng-click="grid.appScope.showContextMenu(row.entity,'+page.ID+',$event);"><i class="fa  fa-indent"></i>'+
               '</div>'
            });

        scopeGridOptions.columnDefs.push({
               name :'pageId' ,
               visible:false
        });

       scopeGridOptions.columnDefs.push({
         name:  'seq',
         displayName: '序号',
         enableSorting:false,
         cellTemplate: '<div class="ui-grid-cell-contents">{{grid.renderContainers.body.visibleRowCache.indexOf(row) +1 }}</div>',
         width:60
        } );








          $(pats).each(function(i,j){

            var col ={};
            var col_width =100;
            var col_view =0;
            var eleConfig ;

            var jProp = g.wrapProperty(j['property_'+ page.ID]);

            if (jProp.view){
              col_view = jProp.view;
            }

            if (jProp.config){
               eleConfig = _.find(cooConfig.allconfiguration,function(n){ return n.configuration_key == jProp.config  });
            }

            if (jProp.h == 1) {
              return true;
            }



            if (jProp && jProp.width)
            {
               col_width = jProp.width;
            }

            var rr = j.required?' * ':'';
            var dsName = j.alias?j.alias:j.pName;

            switch (j.pTypeId) {

              case 3:
              case 4:

              if (eleConfig){

                col ={
                       name :'__c'+j.ID,
                       displayName:  rr  +  dsName ,
                       enableCellEdit:true,
                        enableSorting:false,
                        enableCellEditOnFocus: true,
                        cellClass:'ui_grid_input  ' ,
                        width:col_width,
                        editableCellTemplate:
                        '<div  ><form name="inputForm"  > '+
                          '<input ng-focus="grid.appScope.grid_select('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,$event);"  ng-click="grid.appScope.grid_select('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,$event);"    name="__c'+j.ID+'"    tag="{{row.entity.server_identity}}" type="text" ng-class="\'grid-input \' + \'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD" />' +
                           '</form></div>'
                        //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                     };






              }else  if (col_view){
                col ={
                       name :'__c'+j.ID,
                       displayName: rr + dsName  ,
                          enableSorting:false,
                       aggregationType: uiGridConstants.aggregationTypes.sum,
                       cellTemplate: '<div class="read-only-cell-contents ui-grid-cell-contents">{{MODEL_COL_FIELD}}</div>',
                       editableCellTemplate:'<div class="read-only-cell-contents ui-grid-cell-contents">{{MODEL_COL_FIELD}}</div>',
                       // cellClass:'ui_grid_input',
                       width:col_width
                     };
              }else{
                col ={
                       name :'__c'+j.ID,
                       displayName:rr +  dsName  ,
                       aggregationType: uiGridConstants.aggregationTypes.sum,
                       enableCellEditOnFocus: true,
                          enableSorting:false,
                       type: 'string',
                       cellClass:'ui_grid_input',
                       width:col_width
                     };

              }


              scopeGridOptions.columnDefs.push(col);
              break;
              case 11:

             col ={
                    name :'__c'+j.ID,
                    displayName:  dsName ,
                    enableCellEdit:true,
                     enableCellEditOnFocus: true,
                        enableSorting:false,
                     cellTemplate:'<div class="ui-image padder padder-v-sm">{{MODEL_COL_FIELD}}<img class="image-preview" ng-src="{{row.entity.__c'+j.ID+'__src}}" /></div>',
                     cellClass:'ui_grid_input ',
                     width:col_width,
                     editableCellTemplate:   // {{row.entity.__c'+j.ID+' }}
                     '<div class="cellImage">'+
                      ' <form name="inputForm"><span ng-class="\'colt\' + col.uid" ui-grid-editor  ng-model="MODEL_COL_FIELD"> <a  href="{{row.entity.__c'+j.ID+'__src}}" target="_blank"> {{row.entity.__c'+j.ID+' }} </a> </span>  '+
                      ' <span href="javascript:void(0);" ng-click="grid.appScope.remove_attachment_sub1(row.entity,'+j.ID+',row.entity.__c'+j.ID+'__att)" class="del"   > '+
                    '       <i class="glyphicon glyphicon-trash" style="font-size:16px;margin-top:8px;" ></i> '+
                    '   </span>    '+
                    '  <span style="cursor: pointer;"  class="upload-button" ng-file-select ng-file-change="grid.appScope.subUpload($files,'+j.ID+',\'{{row.entity.server_identity}}\' )">'+
                    '  <i class="glyphicon glyphicon-paperclip" style="font-size:16px;margin-top:8px;" ></i>'+
                    '</span>   </form>    '+
                   '</div>'
                     //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                };
               scopeGridOptions.columnDefs.push(col);

              break;

              case 10:

             col ={
                    name :'__c'+j.ID,
                    displayName:  dsName ,
                    enableCellEdit:true,
                       enableSorting:false,
                     enableCellEditOnFocus: true,
                     cellClass:'ui_grid_input',
                     width:col_width,
                     editableCellTemplate:   // {{row.entity.__c'+j.ID+' }}
                     '<div class="cellImage">'+
                      ' <form name="inputForm"><span ng-class="\'colt\' + col.uid" ui-grid-editor  ng-model="MODEL_COL_FIELD">'+
                      '  </span>  <span ng-repeat="a in row.entity.__c'+j.ID+'__atts"> <a href="{{a.RawFilePath}}" target="_blank"> {{a.ID}}.{{a.ext}}</a>,   '+
                      ' <span href="javascript:void(0);" ng-click="grid.appScope.remove_attachment_sub2(row.entity,'+j.ID+',a)" class="del"   > '+
                    '       <i class="glyphicon glyphicon-trash" style="font-size:16px;margin-top:8px;" ></i> '+
                    '   </span> </span>    '+
                    '  <input style="cursor: pointer;width:30px;" value="上传"  class="upload-button" multiple ng-file-select ng-file-change="grid.appScope.subUpload2($files,'+j.ID+',\'{{row.entity.server_identity}}\' )" />'+
                    '   '+
                    '    </form>    '+
                   '</div>'
                     //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                };
               scopeGridOptions.columnDefs.push(col);

              break;
              case 18:


              col ={
                      name :'__c'+j.ID,
                      displayName:  dsName +'(选择)',
                      enableCellEdit:true,
                         enableSorting:false,
                      enableCellEditOnFocus: true,
                      cellClass:'ui_grid_input',
                      width:col_width,
                      editableCellTemplate:
                      '<div><form name="inputForm"   > '+
                        '<input   ng-click="grid.appScope.inherit_modal('+page.ID+','+j.ID+',row.entity );" name="__c'+j.ID+'"  tag="{{row.entity.server_identity}}" type="text" ng-class="\'grid-input \' +  \'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD">' +
                         ' </form></div>'
                      //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                   };

              scopeGridOptions.columnDefs.push(col);

              break;
              case 5:
              case 7:
                 if (j.categoryId!= page.categoryId)
                   {
                     var jjs =_.filter(cooConfig.alljoin,function(n) { return n.joinCategoryId==j.categoryId && n.categoryId==page.categoryId  });
                     jjs= _.sortBy(jjs, 'ID');
                     var jj= _.find(cooConfig.alljoin,function(n) { return n.joinCategoryId==j.categoryId && n.categoryId==page.categoryId  });
                     jj= jjs[0];







                     // if (scope.categoryId==page.categoryId){
                     //     jj = jjs[jjs.length-1];
                     // }else{
                     //    jj = jjs[0];
                     // }

                     var name ='__c'+j.ID;





                     var levelPats =_.filter(pats ,function(n){ return n.level ==1 });

                     console.log(j);
                     console.log(levelPats);
                     console.log(jjs);


                     if (jjs.length>1 &&  j.level>0)
                     {


                        jj =jjs[1];
                        name += '_1';
                     }
                     console.log(j.level);
                     console.log(name);

                     var jpat = _.find(pats,function(n){ return n.ID == jj.baseId });
                     rr = jpat.required?'*':'';

                     col ={
                            name : name ,
                            displayName:  rr + dsName +'(选择)',
                            enableCellEdit:true,
                               enableSorting:false,
                             enableCellEditOnFocus: true,
                             cellClass:'ui_grid_input  ' ,
                             width:col_width,
                             editableCellTemplate:
                             '<div  ><form name="inputForm"  > '+
                               '<input ng-focus="grid.appScope.grid_keyup('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,'+jj.baseId+',$event);"  ng-keyup="grid.appScope.grid_keyup('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,'+jj.baseId+',$event);"  ng-click="grid.appScope.multi_modal('+page.ID+','+j.ID+','+jj.baseId+' ,row.entity );" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'grid-input \' + \'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD">' +
                                '</form></div>'
                             //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                          };

                          // item="row.entity[col.field]"




                   }
                   else {


                     if (eleConfig){

                       col ={
                              name :'__c'+j.ID,
                              displayName:  rr  +  dsName ,
                              enableCellEdit:true,
                               enableSorting:false,
                               enableCellEditOnFocus: true,
                               cellClass:'ui_grid_input  ' ,
                               width:col_width,
                               editableCellTemplate:
                               '<div  ><form name="inputForm"  > '+
                                 '<input ng-focus="grid.appScope.grid_keyup('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,0,$event);"  ng-keyup="grid.appScope.grid_keyup('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+' ,0,$event);"  ng-click="grid.appScope.multi_modal('+page.ID+','+j.ID+',0 ,row.entity );" name="__c'+j.ID+'"  baseid="0" tag="{{row.entity.server_identity}}" type="text" ng-class="\'grid-input \' + \'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD">'+
                                  '</form></div>'
                               //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
       //
                            };






                     } else
                     {

                           col ={
                                name :'__c'+j.ID,
                                displayName: rr +  dsName ,
                                visible: j.pName=='code'?false:true,
                                enableCellEditOnFocus: true,
                                   enableSorting:false,
                                type: 'string',
                                cellClass:'ui_grid_input',
                                width:col_width
                              };

                     }








                     }
                scopeGridOptions.columnDefs.push(col);
                break;
              case 1:
                  col = {
                     name :'__c'+j.ID,
                     displayName: dsName,
                     type: 'boolean',
                     enableCellEditOnFocus: true,
                        enableSorting:false,
                     cellFilter: 'true_false',
                           cellClass:'ui_grid_input',
                     width:col_width
                 //    cellTemplate: '<input type="checkbox" class="new_checkbox" ng-model="row.entity.__c'+j.ID+'" >'
                       }
                 scopeGridOptions.columnDefs.push(col);
               break;
               case 6:
                col = {
                   name :'__c'+j.ID,
                   displayName:  rr +  dsName ,
                   type: 'date',
                   cellFilter: 'date:"yyyy-MM-dd"',
                   enableCellEditOnFocus: true,
                      enableSorting:false,
                   cellClass:'ui_grid_input'
                   ,
                   width:col_width
                }
                scopeGridOptions.columnDefs.push(col);
                 break;
               case 2:
               case 13:
                     var c_source = g.makeSource2(j,{});
                     var group =_.find(cooConfig.allstatusmap,function(n){ return n.patternId==j.ID });
                     var groupId = group?group.groupId:0;

                    col =      { name:  '__c'+j.ID,
                    enableCellEditOnFocus: true,
                       enableSorting:false,
                    cellClass:'ui_grid_input',
                    displayName: rr +  dsName  ,
                    editableCellTemplate: 'ui-grid/dropdownEditor',
                    cellFilter: 'mapStatus:'+groupId+':'+j.ID,
                    editDropdownIdLabel:'value',
                    editDropdownValueLabel :'label',
                     editDropdownOptionsArray :
                       c_source  ,
                     width:col_width };
                     scopeGridOptions.columnDefs.push(col);
                    break;
              case 26:
                    var c_sourcex = g.makeSource2(j,{});
                   col =      { name:  '__c'+j.ID,
                   enableCellEditOnFocus: true,
                      enableSorting:false,
                   cellClass:'ui_grid_input',
                   displayName: dsName + rr,
                   editableCellTemplate: 'ui-grid/dropdownEditor',
                   cellFilter: 'mapDepartment',
                   editDropdownIdLabel:'value',
                   editDropdownValueLabel :'label',
                    editDropdownOptionsArray :
                      c_sourcex  ,
                    width:col_width };
                    scopeGridOptions.columnDefs.push(col);

                   break;
              case 12:
                    var col_width =150;

                    if (j['property_'+page.ID] && j['property_'+page.ID].width)
                    {
                       col_width = j['property_'+page.ID].width;
                    }

                    var c_source = g.makeSource2(j,{});

                    var group =_.find(cooConfig.allstatusmap,function(n){ return n.patternId==j.ID });
                    var groupId = group?group.groupId:0;




                    col ={
                           name :'__c'+j.ID,
                           displayName: dsName,
                           enableCellEdit:true,
                            enableCellEditOnFocus: true,
                               enableSorting:false,
                            cellClass:'ui_grid_input',
                            width:col_width,
                            editableCellTemplate:
                            '<div><form name="inputForm"> '+
                              '<input ui-focus="grid.appScope.grid_user('+j.ID+',row.entity,rowRenderIndex,col.uid,'+page.ID+');" name="__c'+j.ID+'" tag="{{row.entity.server_identity}}"   type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
                            //'<input my-hint sub="1" name="__c'+j.ID+'"  baseid="'+jj.baseId+'" tag="{{row.entity.server_identity}}" type="text" ng-class="\'colt\' + col.uid" ui-grid-editor ng-model="MODEL_COL_FIELD"></form></div>'
//
                         };

                    scopeGridOptions.columnDefs.push(col);
                   break;
              default:
                  col ={
                         name :'__c'+j.ID,
                         displayName: dsName + rr,
                         enableCellEdit:false,
                            enableSorting:false
                       };
            }









          });


     }



     //end of  grid_cols




     //
     g.import_modal =function($scope){

       var pageId= 0;

       console.log($stateParams);



       if ($stateParams.pageId)
       {
          var pg1 = _.find(cooConfig.allpage,function(n){ return n.parentId == $stateParams.pageId  });
          if (pg1) pageId = pg1.ID;
       }
       else if ($stateParams.writePageId){

         var pg1 = _.find(cooConfig.allpage,function(n){ return n.parentId == $stateParams.writePageId  });
         if (pg1) pageId = pg1.ID;


       }
       else if ($stateParams.createPageId)
       {
        var check_pg2 = _.find(cooConfig.allpage,function(n){ return n.ID == $stateParams.createPageId  });
         var pg2 = _.find(cooConfig.allpage,function(n){ return n.parentId == $stateParams.createPageId  });



         if (pg2 && check_pg2.pageType!=5)  {pageId = pg2.ID; } else { pageId = $stateParams.createPageId ; }
       }
       else if ($stateParams.editPageId)
       {
           var check_pg3 = _.find(cooConfig.allpage,function(n){ return n.ID == $stateParams.editPageId  });


           var pg3 = _.find(cooConfig.allpage,function(n){ return n.parentId == $stateParams.editPageId  });
           if (pg3  && check_pg3.pageType!=5 )  { pageId = pg3.ID; } else {  pageId = $stateParams.editPageId; }
       }

       var pg = _.find(cooConfig.allpage,function(n){ return n.ID ==pageId});







      var modalInstance =  $modal.open({
          templateUrl: 'import_editor.html',
          controller: 'import_modal_instance_ctrl',
          size: "lg",
          resolve:
                load(['textAngular', 'summernote'],
                function(){},
                {
                  pageId: function(){ return pageId}
                }
               )
        });





        modalInstance.result.then(function (txt) {


           console.log(pageId);



            if (!txt)
             return false ;

            txt = txt.replace(/<br[\/]?>/ig,'nnn');
            var tab = $(txt);
            var r = /<\/td>/i;
            var table = [];
            var cols = [];
            var mapping = {};
            var initSource =[];
            var pts = g.page_pats(pageId);
            var startRow = 0;
            var columnCount =0;



             $(tab).find('tr').each(function (j, k) {
                  if ($(k).find('td').size()>3)
                 {
                   startRow = j;
                   columnCount = $(k).find('td').size();
                    return false;
                 }
             });



            $(tab).find('tr').each(function (j, k) {

                  var row = {};
                  var z=0;
                  $(k).find('td').each(function (p, q) {



                      if (j == startRow) {
                        var cname = $(q).text().replace(/<br[^>]+>|\s/ig,'')
                        cname = cname.replace(/&nbsp;/ig,'');
                        cname= cname.replace(/n{2,}/ig,'');

                        if (cname=="" && p==0) return false;
                         cols.push(cname);
                      }
                      else {

                          var pi =$(q).prop('colspan');
                          var vpi =1;
                          if (pi) vpi = parseInt(pi);

                          row[cols[z]] = $.trim($(q).text());

                          if (vpi>1)
                          {
                            z+= vpi-1;
                          }

                      }

                      z++;
                  });
                  if (j != startRow  ) {
                       var k1 =   _.keys(row)[0];
                      if (row[k1] && $.trim(row[k1])!='')
                      table.push(row);
                  }

            });










            if ($scope && $scope.gridOptions && table.length>$scope.gridOptions.data.length)
            {
               var zx = $scope.gridOptions.data.length
               for(var k=0 ;k< table.length - zx ;k++)
               {
                 $scope.gridOptions.data.push({ server_identity:g.guid() });
               }
            }



            var lsc_string ={ };





            for(var i=0;i<table.length;i++ )
            {
                 $(pts).each(function(x,y){

                       if (y.categoryId!=pg.categoryId && table[i][y.pName])
                       {
                           if (!lsc_string['__c'+y.ID]) lsc_string['__c'+y.ID] =  y.pName;
                           if (!lsc_string['__c'+y.ID + '_value']) lsc_string['__c'+y.ID + '_value'] = [];
                           lsc_string['__c'+y.ID + '_value'].push(table[i][y.pName] ) ;
                       }
                  });
            }



             $(pts).each(function(i,o){
                 if (o.pTypeId==2){
                     var gs = _.find(cooConfig.allstatusmap,function(n){ return n.patternId==o.ID && !n.init });
                     if (gs){
                        initSource.push({ p:o ,s:[]});
                     }
                 }

                  mapping[o.eName] = '__c' + o.ID;
                  mapping[o.pName] = '__c' + o.ID;
             });



            if (!$scope.gridOptions){

                 var $table = $(".excelTable");
                   var r= /^\d+$/ig;

                   $(table).each(function (j, row) {
                     var $row = $table.find("tr:nth-child(2)").clone();
                     $row.removeClass("hide");

                     $(cols).each(function (p, q) {

                         var $jq =   $row.find('[name="' + q + '"]');

                         if ($jq.is("select")  )
                         {
                           if (!$.isNumeric(row[q]))
                           {
                             $row.find('[name="' + q + '"] option').filter(function() {
                                return this.text == row[q];
                             }).attr('selected', true);
                             $row.find('[name="' + q + '"]').attr('v','e');
                           }
                           else {
                             $row.find('[name="' + q + '"]').val(row[q]).attr('v', 'e');
                           }
                         }
                         else if ($jq.is(":checkbox"))
                         {

                             if (row[q].toString()==1 || row[q].toString().toLowerCase()=='true')
                             {

                                 $jq.prop('checked', true).attr('v','e');
                             }
                         }
                         else {

                             $row.find('[name="' + q + '"]').val(row[q]).attr('v', 'e');
                         }



                     });
                     $table.append($row);
                   });



            }

            console.log($scope.gridOptions );
            console.log(cols);
            console.log(table);
            console.log(mapping);
            console.log($scope.result);



             $(table).each(function(i,j){
               $(initSource).each(function(p,q){
                   if (j[q.p.pName]){
                      var obj_stat = _.find(cooConfig.allstatus,function(n){ return n.statusName == j[q.p.pName] });
                      if (obj_stat)
                      q.s.push({label:obj_stat.statusName,value:obj_stat.ID });
                   }
               });
             });
             console.log(initSource);

            $(initSource).each(function(x,y){
               var cl = _.find($scope.gridOptions.columnDefs,function(n){ return n.name == '__c'+y.p.ID.toString() });
               cl.editDropdownOptionsArray = y.s;
            });





             g.show_ajax();







             if (JSON.stringify(lsc_string)!="{}")
             {
               var promises =[];
               var pts_ids = _.pluck(pts,'ID');

                  $(pts).each(function(x,y){
                     if (y.pTypeId==5 && y.categoryId!=pg.categoryId){

                       var p1 =_.find(cooConfig.allpage,function(n){ return n.categoryId ==y.categoryId && n.pageType==10});
                       var lsc1 =[];
                       lsc1.push({patternId:y.ID,operation:5,pTypeId : y.pTypeId , val1: _.uniq(lsc_string['__c'+y.ID+'_value']).join(',')  });

                       //联合查询
                       if (_.any(cooConfig.alljoin,function(n){ return n.categoryId==y.categoryId && _.contains(pts_ids ,n.viewPatternId) }))
                       {
                         var cj = _.find(cooConfig.alljoin,function(n){ return n.categoryId==y.categoryId && _.contains(pts_ids ,n.viewPatternId) }) ;
                         var cj_pat = _.find(pts,function(n){ return n.ID==cj.viewPatternId });
                          lsc1.push({patternId:cj.viewPatternId,operation:5,pTypeId :  cj_pat.pTypeId , val1: _.uniq(lsc_string['__c'+cj.viewPatternId+'_value']).join(',')  });
                       }

                       promises.push(rest.search2(p1.categoryId,p1.ID,lsc1,0,300));

                     }
                  });

                  $.when.apply($, promises).done(function() {




                     var data1 =[];
                     var data2 =[];
                     if (arguments.length>0) data1 = arguments[0].data;
                     if (arguments.length>1) data2 = arguments[1].data;




                      for(var i=0;i<table.length;i++ )
                      {
                             var pk =0;
                          $(pts).each(function(x,y){

                                var vv="";
                                var nv="";

                               if (table[i][y.pName])
                               {
                                  vv= table[i][y.pName];
                                  switch (y.pTypeId) {
                                    case 2:
                                      var sts = _.find(cooConfig.allstatus,function(n){ return n.statusName==vv});
                                      if (sts)  vv = sts.ID;
                                      break;
                                    case 12:
                                     var usr = _.find(cooConfig.alluser,function(n){ return n.XingMing==vv});
                                     if (usr) {
                                        nv =usr.XingMing;
                                        vv = usr.UserId;
                                     }
                                      break;
                                    case 5:
                                      if (y.categoryId!=pg.categoryId)
                                      {
                                          var item={};

                                           if (pk==0)
                                            {  item = _.find(data1,function(n){ return n['__c'+y.ID]==vv}); }
                                            else
                                            {  item = _.find(data2,function(n){ return n['__c'+y.ID]==vv}); }


                                            if (item)
                                            {
                                              var vj = _.find(cooConfig.alljoin,function(n){return n.viewPatternId==y.ID && n.categoryId==pg.categoryId   });
                                              if (vj)
                                              {
                                                $scope.gridOptions.data[i]['__c'+vj.baseId] = item.server_identity;
                                                $scope.gridOptions.data[i]['__c'+vj.baseId +'__e'] = 'e';
                                              }
                                              else {
                                                vv="";
                                              }
                                            }
                                            else {
                                              vv="";
                                            }

                                            if (pk==0) pk++;
                                      }
                                      break;
                                    default:
                                  }
                               } ;


                               if (y.pTypeId!=23 && y.pTypeId!=12)
                               {




                                 $scope.gridOptions.data[i]['__c'+y.ID] = vv;
                                 $scope.gridOptions.data[i]['__c'+y.ID +'__e'] = 'e';
                               }
                               if (y.pTypeId==12){
                                 $scope.gridOptions.data[i]['__c'+y.ID] = nv;
                                 $scope.gridOptions.data[i]['__c'+y.ID + '_value'] = vv;
                                 $scope.gridOptions.data[i]['__c'+y.ID +'__e'] = 'e';
                               }
                          });

                          var sub_page = _.find(cooConfig.allpage,function(n){ return n.parentId == pageId});

                          if (sub_page){

                             var sub_pats = g.page_pats(sub_page.ID);

                             var enum_pat = _.find(sub_pats,function(n){ return n.pTypeId==2  });

                             if (enum_pat)
                             {


                                var sub_source =g.makeSource2(enum_pat,{});
                                $(sub_source).each(function(u,v){

                                  if (u==0) return ;


                                  $scope.gridOptions.data[i]['__c'+enum_pat.ID+'_'+v.value] = table[i][v.label];
                                  $scope.gridOptions.data[i]['__c'+enum_pat.ID+'_'+v.value+'__e'] = 'e';
                                })
                             }
                          }



                         // $scope.gridOptions.data[i]
                      }







                       g.hide_ajax();
                       $scope.$$phase || $scope.$apply();

                  // arguments 为默认返回的数组
                  });





             }
             else {



                   for(var i=0;i<table.length;i++ )
                   {
                       $(pts).each(function(x,y){
                            if (table[i][y.pName])
                            {
                               var vv= table[i][y.pName];
                               var nv = table[i][y.pName];

                               switch (y.pTypeId) {
                                 case 26:
                                 var dts = _.find(cooConfig.alldepartment,function(n){ return n.departmentName==vv });
                                   if (dts) vv = dts.ID;
                                   break;
                                 case 2:
                                   var sts = _.find(cooConfig.allstatus,function(n){ return n.statusName==vv});
                                   if (sts)  vv = sts.ID;
                                   break;
                                 case 12:
                                  var usr = _.find(cooConfig.alluser,function(n){ return n.XingMing==vv});
                                  if (usr)
                                  {
                                    vv = usr.UserId;
                                    nv = usr.XingMing;
                                  }
                                  else{
                                    vv = "";
                                    nv = "" ;
                                  }
                                   break;
                                 default:
                               }

                               if (y.pTypeId== 12){
                                  $scope.gridOptions.data[i]['__c'+y.ID] = nv;
                                  $scope.gridOptions.data[i]['__c'+y.ID+'_value'] = vv;

                               }
                               else {
                                     $scope.gridOptions.data[i]['__c'+y.ID] = vv;
                               }


                                $scope.gridOptions.data[i]['__c'+y.ID +'__e'] = 'e';
                            } ;
                       });

                      // $scope.gridOptions.data[i]
                   }
                    g.hide_ajax();
                    $scope.$$phase || $scope.$apply();

             }






           //
        }, function () {
         //$log.info('Modal dismissed at: ' + new Date());
        });
     }
     //end of import_modal


     g.list_modal_inherit =function($scope,pageId,categoryId, patternId ){


      var modalInstance = $modal.open({
           templateUrl: 'tpl/blocks/list_modal.html?'+cooConfig.configObj.version,
           controller: 'list_modal_instance_ctrl',
           size: 'lg',
           resolve:
                 load([],
                 function(){},
                 {
                   pageId: function(){ return pageId},
                   categoryId:function(){ return categoryId},
                   patternId: function() { return patternId },
                   multi:function() { return false },
                   modal_lsc_init: function() { return $scope.modal_lsc_init}
                 }
                )

         });

         modalInstance.result.then(function (row) {
               console.log(patternId);


                   var rowv = _.find(row,function(n){ return n.pTypeId == 5  });
                   var myex= {};


                     if ($scope.elements)
                     {
                        console.log($scope.elements);

                          $($scope.elements).each(function(i,j){
                             if (j.p.ID ==patternId){
                                myex = j;
                             }
                          });
                     }


                   $($scope.elementsGroups).each(function(i,j){
                       $(j.elements).each(function(p,q){
                                  if (q.p.ID==patternId){
                                    myex = q;
                                  }
                         });

                     });


                     console.log(rowv);
                     console.log(row);




                     myex.v = rowv? rowv.val : '未定义显示项';
                     myex.val = row.server_identity ; //rowv.val ;
                     myex.e='e';

                     console.log(myex);

                     if (typeof udf_after_single_select != 'undefined') {
                       udf_after_single_select($scope,row);
                     }


           });

   }


   //modal with two tables
   g.list_modal_double =function($scope,pageId,categoryId,baseId ,patternId , multi ,entity){

     var evt = _.find(cooConfig.allevent, function (n) { return n.pageId ==  $scope.pageId });



    var modalInstance = $modal.open({
         templateUrl: 'tpl/blocks/list_modal_double.html?'+cooConfig.configObj.version,
         controller: 'list_modal_instance_ctrl',
         size: 'lg',
         resolve:
               load(['dataTable'],
               function(){},
               {
                 pageId: function(){ return pageId},
                 categoryId:function(){ return categoryId},
                 patternId: function() { return patternId },
                 multi:function() { return multi },
                 modal_lsc_init: function() { return $scope.modal_lsc_init}
               }
              )

       });

       modalInstance.result.then(function (row) {

         console.log(row);
         row.patternId = patternId;
         row.pageId = pageId;
         selectType= row.selectType;


         console.log(selectType);
         console.log(patternId);
         console.log($scope.elements);



          if ( selectType==1 )
          {
             var rowv = _.find(row,function(n){ return n.ID==patternId  });
             var myex= {};
             var myj ={};

               if ($scope.elements)
               {
                    $($scope.elements).each(function(i,j){
                       if (j.p.ID ==patternId){
                          myex = j;
                       }
                       if (j.p.ID==baseId){
                         myj =j;
                       }
                    });

               }

           $($scope.elementsGroups).each(function(i,j){
               $(j.elements).each(function(p,q){
                    if (q.p.ID==patternId){
                      myex = q;
                    }
                    if (q.p.ID==baseId){
                      myj =q;
                    }
               });
           });
           console.log(myj);


           myex.val = rowv.val;   //原来被注释掉？
           myj.val = row.server_identity;
           myj.v = rowv?rowv.val:'';
           myj.e='e';



            g.init_event($scope,'udf_after_single_select',row);






         }



        if (selectType ==4 && row.server_identity  ){

        //  return false;

      //   console.log(row.server_identity);




          row.patternId = patternId;
          row.entity = entity;

          var currentRow = _.find($scope.gridOptions.data,function(n){ return row.entity && n.server_identity == row.entity.server_identity })
          if (currentRow){
            var displayCol = _.find(row,function(n){ return n.ID ==patternId });

            if (displayCol){
              currentRow['__c'+patternId ]  = displayCol.val;// j['__c'+patternId];
              currentRow['__c'+patternId +'__e'] = 'e';
              currentRow['__c'+baseId  ] = row.server_identity;
              currentRow['__c'+baseId +'__e'] = 'e';
             }
          }

         if (g.check_event($scope,'udf_after_single_edit',row)){
             console.log(row);
             g.init_event($scope,'udf_after_single_edit',row);
         }

          $scope.$$phase || $scope.$apply();
    }


        if (selectType==2)
          {
              row.patternId = patternId;
              row.entity = entity;
              g.init_event($scope,'udf_after_multi_select',row);

              var newData =[];
               $(row).each(function(i,j){
                   var erow= {};
                    erow['__c'+patternId ]  = j['__c'+patternId];
                    erow['__c'+patternId +'__e'] = 'e';

                    erow['__c'+baseId  ] = j.server_identity;
                    erow['__c'+baseId +'__e'] = 'e';
                    newData.push(erow);
               });
               console.log(newData);

               $scope.gridOptions.data = newData;
               $scope.$$phase || $scope.$apply();



         }

         if (selectType==3){

              g.init_event($scope,'udf_after_multi_add',row);



         }

         if (typeof rowHover === 'function' ){
            rowHover();
         }




       }, function () {




        //$log.info('Modal dismissed at: ' + new Date());
       });


   }



     g.list_modal =function($scope,pageId,categoryId,baseId ,patternId , multi ,entity ,callback){

       var evt = _.find(cooConfig.allevent, function (n) { return n.pageId ==  $scope.pageId });

       var pgx = _.find(cooConfig.allpage,function(n){ return n.ID == pageId  });
       var pgProperty = g.wrapProperty(pgx.pageProperty);
       var templateUrl = 'tpl/blocks/list_modal.html';
       var size ='lg';
       if (pgProperty.leftTreeView){
           templateUrl =  'tpl/blocks/list_modal_tree.html';
           size = 'xlg';
       }



      var modalInstance = $modal.open({
           templateUrl: templateUrl + '?' + cooConfig.configObj.version,
           controller: 'list_modal_instance_ctrl',
           size: size,
           resolve:
                 load([],
                 function(){},
                 {
                   pageId: function(){ return pageId},
                   categoryId:function(){ return categoryId},
                   patternId: function() { return patternId },
                   multi:function() { return multi },
                   modal_lsc_init: function() { return $scope.modal_lsc_init}
                 }
                )

         });

         modalInstance.result.then(function (row) {

           console.log(row);
           row.patternId = patternId;
           row.baseId =baseId;
           row.pageId = pageId;
           selectType= row.selectType;


           console.log(selectType);
           console.log(patternId);
           console.log($scope.elements);



            if ( selectType==1 )
            {
               var rowv = _.find(row,function(n){ return n.ID==patternId  });
               var myex= {};
               var myj ={};

                 if ($scope.elements)
                 {
                      $($scope.elements).each(function(i,j){
                         if (j.p.ID ==patternId){
                            myex = j;
                         }
                         if (j.p.ID==baseId){
                           myj =j;
                         }
                      });

                 }

             $($scope.elementsGroups).each(function(i,j){
                 $(j.elements).each(function(p,q){
                      if (q.p.ID==patternId){
                        myex = q;
                      }
                      if (q.p.ID==baseId){
                        myj =q;
                      }
                 });
             });
             console.log(myj);


             myex.val = rowv.val;   //原来被注释掉？
             myj.val = row.server_identity;
             myj.v = rowv?rowv.val:'';
             myj.e='e';



              g.init_event($scope,'udf_after_single_select',row);






           }



          if (selectType ==4 && row.server_identity  ){

          //  return false;

        //   console.log(row.server_identity);




            row.patternId = patternId;
            row.entity = entity;

            var currentRow = _.find($scope.gridOptions.data,function(n){ return row.entity && n.server_identity == row.entity.server_identity })
            if (currentRow){
              var displayCol = _.find(row,function(n){ return n.ID ==patternId });

              if (displayCol){
                currentRow['__c'+patternId ]  = displayCol.val;// j['__c'+patternId];
                currentRow['__c'+patternId +'__e'] = 'e';
                currentRow['__c'+baseId  ] = row.server_identity;
                currentRow['__c'+baseId +'__e'] = 'e';
               }
            }

           if (g.check_event($scope,'udf_after_single_edit',row)){
               console.log(row);
               g.init_event($scope,'udf_after_single_edit',row);
           }

            $scope.$$phase || $scope.$apply();
      }


          if (selectType==2)
            {
                row.patternId = patternId;
                row.entity = entity;
                g.init_event($scope,'udf_after_multi_select',row);

                var newData =[];
                 $(row).each(function(i,j){
                     var erow= {};
                      erow['__c'+patternId ]  = j['__c'+patternId];
                      erow['__c'+patternId +'__e'] = 'e';

                      erow['__c'+baseId  ] = j.server_identity;
                      erow['__c'+baseId +'__e'] = 'e';
                      newData.push(erow);
                 });
                 console.log(newData);

                 $scope.gridOptions.data = newData;
                 $scope.$$phase || $scope.$apply();



           }

           if (selectType==3){

                g.init_event($scope,'udf_after_multi_add',row);



           }

           if (typeof rowHover === 'function' ){
              rowHover();
           }

           console.log(callback);
           if (callback && typeof callback =='function'){
               callback();
           }




         }, function () {




          //$log.info('Modal dismissed at: ' + new Date());
         });


     }

     g.datalog_modal = function(categoryId,itemId)
     {

          var modalInstance = $modal.open({
            templateUrl: 'datalog_modal.html',
            controller: 'datalog_modal_instance_ctrl',
            size: 'lg',
            resolve:
                  load([],
                  function(){},
                  {
                    categoryId:function(){ return categoryId},
                    itemId:function(){ return itemId},
                  }
                 )

          });

     }


     g.userExactModal = function($scope,ele){


             var modalInstance = $modal.open({
               templateUrl: 'tpl/blocks/user_exact_modal.html',
               controller: 'user_exact_modal_instance_ctrl',
               size: 'lg',
               resolve:
                     load([],
                     function(){},
                     {
                       // categoryId:function(){ return categoryId},
                       // itemId:function(){ return itemId},
                     }
                    )

             });

             modalInstance.result.then(function (result) {

                $($scope.elementsGroups).each(function(p,q){
                    $(q.elements).each(function(i,j){
                        if (j.p.ID == ele.p.ID){
                          j.val = result.userGuid.UserId;
                          j.v = {
                            UserId : result.userGuid.UserId,
                            XingMing : result.userUniqueColumn
                          };
                          j.e ="e";
                        }
                    });

                });

                $($scope.elements).each(function(i,j){
                     if (j.p.ID == ele.p.ID){
                         console.log('x2');
                         j.val = result.userGuid.UserId;
                         j.v = {
                           UserId : result.userGuid.UserId,
                           XingMing : result.userUniqueColumn
                         };
                         j.e ="e";
                     }
                })

                //
             }, function () {
              //$log.info('Modal dismissed at: ' + new Date());
             });



     }

     g.userModal2 = function($scope,pat,multi)
     {

       var cfg = _.find( cooConfig.allconfiguration,function(n){ return n.configuration_key=='userCfg'});

       if (!cfg) {
          g.modal1("未配置用户信息");
       } else{

         var cfgObj = JSON.parse(cfg.configuration_value);



         var templateUrl = 'tpl/blocks/user.modal.html?'+cooConfig.configObj.version;
         var controller = 'user_modal_instance_ctrl';
         var jsFile = 'design/js/controllers/basecontroller.js?'+cooConfig.configObj.version;
         if (cfgObj.custom){

             templateUrl = 'design/'+cooConfig.configObj.companyId+'/tmpl/user.modal.html?'+cooConfig.configObj.version;
             controller = 'user_modal_instance_ctrl2';
             jsFile = 'design/'+cooConfig.configObj.companyId+'/js/user.modal.js?'+cooConfig.configObj.version;
         }




         var modalInstance = $modal.open({
           templateUrl: templateUrl,
           controller: controller,
           size: 'sm',
           resolve:
                 load([ 'moment' ,'ngJsTree', jsFile ],
                 function(){},
                 {
                    multi :function() { return multi },
                   // categoryId:function(){ return categoryId},
                   // itemId:function(){ return itemId},
                 })

         });

         modalInstance.result.then(function (result) {

           $scope.text_valuey =   result.id;
           $scope.text_vy = result.name;

            //
         }, function () {
          //$log.info('Modal dismissed at: ' + new Date());
         });



       }



     }


     g.userModal = function($scope,ele,multi)
     {
          var cfg = _.find( cooConfig.allconfiguration,function(n){ return n.configuration_key=='userCfg'});

          if (!cfg) {
             g.modal1("未配置用户信息");
          } else{

            var cfgObj = JSON.parse(cfg.configuration_value);



            var templateUrl = 'tpl/blocks/user.modal.html?'+cooConfig.configObj.version;
            var controller = 'user_modal_instance_ctrl';
            var jsFile = 'design/js/controllers/basecontroller.js?'+cooConfig.configObj.version;
            if (cfgObj.custom){

                templateUrl = 'design/'+cooConfig.configObj.companyId+'/tmpl/user.modal.html?'+cooConfig.configObj.version;
                controller = 'user_modal_instance_ctrl2';
                jsFile = 'design/'+cooConfig.configObj.companyId+'/js/user.modal.js?'+cooConfig.configObj.version;
            }




            var modalInstance = $modal.open({
              templateUrl: templateUrl,
              controller: controller,
              size: 'sm',
              resolve:
                    load([ 'moment' ,'ngJsTree', jsFile ],
                    function(){},
                    {
                       multi :function() { return multi },
                      // categoryId:function(){ return categoryId},
                      // itemId:function(){ return itemId},
                    })

            });

            modalInstance.result.then(function (result) {

               $($scope.elementsGroups).each(function(p,q){
                   $(q.elements).each(function(i,j){
                       if (j.p.ID == ele.p.ID){
                         j.val = result.id;

                         j.e ="e";
                         if (j.p.pTypeId==12){
                            j.v = {
                               UserId : result.id,XingMing:   result.name
                            };
                         }
                         else{
                            j.v = result.name;
                         }
                       }
                   });

               });

               $($scope.elements).each(function(i,j){
                    if (j.p.ID == ele.p.ID){
                        console.log('x2');
                        j.val = result.id;
                        j.e ="e";
                        if (j.p.pTypeId==12){
                           j.v = {
                              UserId : result.id,XingMing:   result.name
                           };
                        }
                        else{
                           j.v = result.name;
                        }
                    }
               })

               //
            }, function () {
             //$log.info('Modal dismissed at: ' + new Date());
            });



          }

     }



     g.formulaTemplate = function($scope,element){
           var modalInstance = $modal.open({


            templateUrl: 'design/'+ cooConfig.configObj.companyId+'/tmpl/formula_modal.html?'+ cooConfig.configObj.version,
            controller: 'FormulaModalCtrl',
             size: "lg",
             resolve:
                   load(['design/'+ cooConfig.configObj.companyId+'/js/formula_modal.js'],
                    function(){},
                    {

                        // modalInstance:function(){
                        //   return modalInstance;
                        // }
                   })
           });

           modalInstance.result.then(function (content) {
               element.val +=  content;
               $scope.$$phase || $scope.$apply();
           }, function () {
             console.log("cancel");
           });

     }

     //column_sort
     g.column_sort = function($scope,page ){


                var modalInstance = $modal.open({
                  templateUrl: 'column_sort.html',
                  controller: 'column_sort_instance_ctrl',
                  size: 'md',
                  resolve:
                        load(['textAngular', 'summernote'],
                        function(){},
                         {
                             page: function(){ return page},
                         }
                       )

                });

                modalInstance.result.then(function (message) {
                    console.log(message);
                    if (message=='modal_return'  )
                    {
                        if ($scope.renderList)
                        {
                         $scope.renderList();
                       }
                       callback();
                       g.modal1('添加成功');
                    }
                   //
                }, function () {
                 //$log.info('Modal dismissed at: ' + new Date());
                });

     }


     //bulk_modal
     g.bulk_modal = function($scope,pageId,categoryId,patternId,ids,pt){


                var modalInstance = $modal.open({
                  templateUrl: 'write_modal.html',
                  controller: 'bulk_modal_instance_ctrl',
                  size: 'md',
                  resolve:
                        load(['textAngular', 'summernote'],
                        function(){},
                        {
                          pageId: function(){ return pageId},
                          categoryId:function(){ return categoryId},
                          patternId:function(){ return patternId},
                          ids:function(){ return ids},
                          pt: function(){ return pt},
                        }
                       )

                });

                modalInstance.result.then(function (message) {
                    console.log(message);
                    if (message=='modal_return'  )
                    {
                        if ($scope.renderList)
                        {
                         $scope.renderList();
                       }
                       g.modal1('修改成功');
                    }
                   //
                }, function () {
                 //$log.info('Modal dismissed at: ' + new Date());
                });

     }


     //bulk_modal



     g.write_modal =function($scope,pageId,categoryId,itemId,cols ,ref_obj ,ref_pat ,callback  ){

         var modalSize = 'lg';
         if (cols==1) {  modalSize = 'sm'       };
         if (cols==2) {  modalSize = 'md'       };



         var modalInstance = $modal.open({
           templateUrl: 'write_modal.html',
           controller: 'write_modal_instance_ctrl',
           size:  modalSize,
           resolve:
                 load(['textAngular', 'summernote' ],
                 function(){},
                 {
                   pageId: function(){ return pageId},
                   categoryId:function(){ return categoryId},
                   itemId:function(){ return itemId},
                   cols:function(){ return cols},
                   ref_obj: function(){return ref_obj },
                   ref_pat: function(){return ref_pat },


                 }
                )

         });

         modalInstance.result.then(function (message) {
             console.log(message);
             if (message=='modal_return'  )
             {
                 if ($scope.renderList)
                 {
                  $scope.renderList();
                }
                callback();
                g.modal1('ok');
             }
            //
         }, function () {
          //$log.info('Modal dismissed at: ' + new Date());
         });


     }
     //end of write_modal
     g.list_total = function(result){

       var r = /pageNumber\((\d+)\)/ig;
       var r2 = /strong>(\d+)/ig;
       var r_total =/\d+$/ig;
       var matches = [], found;
       while (found = r.exec(result.p)) {
           matches.push(parseInt(found[1]));
       }
       var m = r2.exec(result.p);
       var m_total =r_total.exec(result.s);
       if (m&&m.length>0)
       {
         matches.push(parseInt(m[1]));
       }
       var total = 1;
       if (matches.length > 0) total = Math.max.apply(Math, matches);
       //todo
       //paging
        return  m_total? parseInt(m_total[0]):0;


     };


     g.modal_info =function(callback){

       var modalInstance = $modal.open({
         templateUrl: 'info_modal.html',
         controller: 'info_modal_instance_ctrl',
         size: "sm",
         resolve: {
           msg:  function () {
            return '';
          }
         }
       });

       modalInstance.result.then(function (result) {
                console.log(result);
                callback(result);
       }, function () {
         console.log("cancel");
       });
     }//info_modal

     g.modal_confirm =function(msg,callback){

       var modalInstance = $modal.open({
         templateUrl: 'confirm_modal.html',
         controller: 'confirm_modal_instance_ctrl',
         size: "sm",
         resolve: {
           msg:  function () {
            return msg;
          }
         }
       });

       modalInstance.result.then(function () {
                callback();
       }, function () {
         console.log("cancel");
       });
     }
     //end of modal1



     g.j =function(categoryId,o){
            var jj=0;
            var join = _.filter(cooConfig.alljoin, function (n) { return n.categoryId == categoryId && n.joinCategoryId == o.categoryId && n.viewPatternId == o.ID });;// g.joinFilterByAB(categoryId, o.categoryId);
            if (join.length>0) {
                jj = join[0].baseId;
            }
            return jj;
       }
      //end of g.j


      g.joinSelect =function(pindex, baseId, joinId, identity ,elements)
      {

            console.log(baseId);
            console.log(joinId);

              var objStr = $('#obj_'+pindex).attr('data');
              var obj =JSON.parse(objStr);
              var  ele = _.find(elements,function(n){ return  n.p.ID ==  baseId });


             if (baseId==joinId)
             {
               if (ele)
               {
                  var first_5 = _.find(elements,function(n){ return  n.p.pTypeId ==  5 && n.p.categoryId== ele.p.categoryId   });
                  console.log(first_5);
                  $('#view__j'+baseId).val(obj['__c'+first_5.p.ID]).attr('v','e');
                  ele['val'] = obj.server_identity;
                  ele['v'] = obj['__c'+first_5.p.ID];
                  ele['e'] ="e";


                }
             }
             else {

                 $('#view__j'+joinId).val(obj['__c'+joinId]).attr('v','e');
                 if (ele)
                 {
                   ele['val'] = obj.server_identity;
                   ele['v'] = obj.server_identity;
                   ele['e'] ="e";
                 }

             }


              $(".joinPopup").remove();

            //  console.log(elements);
      };


      g.joinSelect2 =function(pindex,baseId,joinId ,identity,scope)
      {

       console.log(scope.gridOptions.data);

        var objStr = $('#obj_'+pindex).attr('data');
        var obj =JSON.parse(objStr);

        var item = _.find(scope.gridOptions.data,function(n){return n.server_identity==identity});




        item['__c'+baseId] = obj.server_identity;
        item['__c'+baseId+'__e'] = "e";

        item['__c'+joinId] = obj['__c'+joinId];
        item['__c'+joinId+'__e'] = "e";

        if (typeof udf_after_row_select != 'undefined') {
          udf_after_row_select(obj,item);
        }

         $(".joinPopup").remove();
         scope.$$phase || scope.$apply();
      };
      //end of g.joinSelect2


      g.contentScript = function (script) {



          $(document).ready(function () {
                console.log('xxx333');

               $('.contentScript').replaceWith("<div class=\"contentScript\"><script type=\"text/javascript\">"+script+"</script></div>"   );

          });
      };
      //end of    g.dfnScript



      g.dfnScript = function (script) {

          $(document).ready(function () {

              $('.script').replaceWith("<div class=\"script\"><script type=\"text/javascript\">"+script+"</script></div>"   );

          });
      };
      //end of    g.dfnScript


          g.modal11 =function(msg,callback){

           var modalInstance =  $modal.open({
               templateUrl: 'alert_modal_content.html',
               controller: 'alert_modal_instance_ctrl',
               size: "sm",
               resolve: {
                 message:  function () {
                  return msg;
                }
               }
             });
             modalInstance.result.then(function () {
                 callback();//
             }, function () {
             });
          }
          //end of modal11

      g.getURLParameter = function(url,name) {
          return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(url) || [null, ''])[1].replace(/\+/g, '%20')) || null;
        }
      //getURLParameter

       g.guid =function() {
           return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
               var r = Math.random()*16|0, v = c == 'x' ? r : (r&0x3|0x8);
               return v.toString(16);
           });
       }
       //guid

       g.randomString =  function(length, chars) {
          var result = '';
          for (var i = length; i > 0; --i) result += chars[Math.floor(Math.random() * chars.length)];
          return result;
      }
      //randomString


        g.randomDate = function (start, end) {
            return new Date(start.getTime() + Math.random() * (end.getTime() - start.getTime()));
        };
        //randomDate

        g.lineProperty = function(s,propertyName){


           var re = new RegExp(propertyName + "\s*?=\s*?\"([^\"]+)\"");
           var f = re.exec(s);
           if (f && f.length>1) return f[1];
           return '';

        }

        g.angleBrackets = function(s,propertyName)
        {
          var re = new RegExp("<"+propertyName+"[^>]*?>([\\s\\S]*?)<\\/"+propertyName+">");
          var f = re.exec(s);
          if (f && f.length>1) return f[1];
          return '';
        }


        //("<block>([\\s\\S]*?)<\\/block>");
        //lineProperty

        g.removeHtml = function(s){
           if (!s) return s;
           s= s.replace(/<[^>]+>/ig,'');
           s = s.replace(/\&nbsp;/ig,' ');
           s = s.replace(/\&gt;/ig,'>');
           s = s.replace(/\&lt;/ig,'<');
          return s;
        }


       g.initPTypes=function(){

             cooConfig.interfaceTypes=[];
             cooConfig.interfaceTypes.push({id:1,name:'linq'});
             cooConfig.interfaceTypes.push({id:2,name:'script'});

              cooConfig.difs = [];
              cooConfig.difs.push({ id: 0, name: '未指定' });
              cooConfig.difs.push({ id: 1, name: '公开' });
              cooConfig.difs.push({ id: 2, name: '私有' });
              cooConfig.difs.push({ id: 3, name: '个人数据' });
              cooConfig.difs.push({ id: 4, name: '无值交互' });
              cooConfig.difs.push({ id: 5, name: '移动端其他' });
              cooConfig.difs.push({ id: 6, name: '关联创建' });
              cooConfig.difs.push({ id: 7, name: 'MN新建' });

              cooConfig.pTypes = [];
              cooConfig.pTypes.push({ id: 1, name: '布尔型' });
              cooConfig.pTypes.push({ id: 2, name: '枚举型' });
              cooConfig.pTypes.push({ id: 3, name: '整数型' });
              cooConfig.pTypes.push({ id: 4, name: '小数型' });
              cooConfig.pTypes.push({ id: 5, name: '字符串' });
              cooConfig.pTypes.push({ id: 6, name: '时间日期' });
              cooConfig.pTypes.push({ id: 7, name: '长文本' });
              cooConfig.pTypes.push({ id: 10, name: '多附件' });
              cooConfig.pTypes.push({ id: 11, name: '单图片附件' });
              cooConfig.pTypes.push({ id: 12, name: '用户权限列' });
              cooConfig.pTypes.push({ id: 13, name: '流程权限列' });
              cooConfig.pTypes.push({ id: 16, name: '自动编号' });
              cooConfig.pTypes.push({ id: 17, name: '多角色标签' });
              cooConfig.pTypes.push({ id: 18, name: '继承列' });
              cooConfig.pTypes.push({ id: 19, name: '多用户列' });
              cooConfig.pTypes.push({ id: 20, name: '多状态列' });
              cooConfig.pTypes.push({ id: 21, name: '权限公开列' });
              cooConfig.pTypes.push({ id: 22, name: '分组' });
              cooConfig.pTypes.push({ id: 23, name: '关联项' });
              cooConfig.pTypes.push({ id: 24, name: '地理位置' });
              cooConfig.pTypes.push({ id: 26, name: '部门' });


              cooConfig.pageTypes = [];
              cooConfig.pageTypes.push({ id: 1, name: '删除页' });
              cooConfig.pageTypes.push({ id: 2, name: '编辑页' });
              cooConfig.pageTypes.push({ id: 3, name: '单列状态编辑' });
              cooConfig.pageTypes.push({ id: 5, name: '批量导入' });
              cooConfig.pageTypes.push({ id: 6, name: '批量编辑' });
              cooConfig.pageTypes.push({ id: 7, name: '数据导出' });
              cooConfig.pageTypes.push({ id: 8, name: '展示页' });
              cooConfig.pageTypes.push({ id: 9, name: '流程控制' });
              cooConfig.pageTypes.push({ id: 10, name: '列表搜索页' });
              cooConfig.pageTypes.push({ id: 11, name: '搜索-列表搜索页' });
              cooConfig.pageTypes.push({ id: 12, name: '排序-列表搜索页' });
              cooConfig.pageTypes.push({ id: 13, name: '统计-列表搜索页' });
              cooConfig.pageTypes.push({ id: 14, name: '列表-列表搜索页' });
              cooConfig.pageTypes.push({ id: 15, name: '新建页' });
              cooConfig.pageTypes.push({ id: 16, name: '通用自定页' });
              cooConfig.pageTypes.push({ id: 17, name: '搜索-通用自定页' });
              cooConfig.pageTypes.push({ id: 18, name: '分组统计-报表页' });
              cooConfig.pageTypes.push({ id: 19, name: '列表创建页' });
              cooConfig.pageTypes.push({ id: 20, name: '列表编辑页' });
              cooConfig.pageTypes.push({ id: 22, name: '列表查看页' });

              cooConfig.pageTypes.push({ id: 31, name: '文件处理' });
              cooConfig.pageTypes.push({ id: 99, name: '组合创建页' });
              cooConfig.pageTypes.push({ id: 100, name: '组合编辑页' });
              cooConfig.pageTypes.push({ id: 101, name: '组合查看页' });
              cooConfig.pageTypes.push({ id: 102, name: '仪表盘' });
              cooConfig.pageTypes.push({ id: 103, name: '机器人事件' });





              cooConfig.eventTypes = [];
              cooConfig.eventTypes.push({ id: 1, name: '加载(client)' });
              cooConfig.eventTypes.push({ id: 2, name: '提交' });
              cooConfig.eventTypes.push({ id: 3, name: '服务端' });


              cooConfig.triggerTypes = [];
              cooConfig.triggerTypes.push({ id: 1, name: 'insert' });
              cooConfig.triggerTypes.push({ id: 2, name: 'update' });
              cooConfig.triggerTypes.push({ id: 3, name: 'insert+update' });
              cooConfig.triggerTypes.push({ id: 4, name: 'delete' });
              cooConfig.triggerTypes.push({ id: 5, name: 'insert+update+delete' });


          }

          g.initPTypes();
            //end of initPTypes;



          g.popv =function($event)
           {
             var s = $($event.target).parent('div').find('input.form-control').val();

             console.log(s);

             var attlist =[];
             var o ={};
             if (s) {
                  o= JSON.parse(s);
             }



             var keys = _.keys(o);
             $('.addrow').remove();
             var $div = $('.pgpt');
             var div = '';
             var k=0;
              _.each(keys,function(n){
                 k++;
                 div+= '<tr class="addrow"><td><input class="key  form-control" name="json_k'+k+'" value="'+ n +'" /> </td><td><input class="value   form-control" name="json_v'+k+'" value="'+o[n]+'" /></td></tr>';
              });
              k++;
              div+='<tr class="addrow"><td><input  class="key form-control" name="json_k'+k+'" value="" /> </td><td><input class="value   form-control" name="json_v'+k+'" value="" /></td></tr>' ;
              $div.find('table').append(div);
              $($event.target).parent('div').append($div);
              $div.show();

           }
             //end of popv;


          g.codeSetting = function()
           {
             var json = {};
             $('.pgpt table tr.addrow').each(function(i,j){
                  var key =   $(j).find('input.key').val();
                  var value  =  $(j).find('input.value').val();
                  if (key&&key!='') json[key] = value;
             });
             $('.pgpt').parent('div').find('input.form-control').val(JSON.stringify(json)).attr('v','e');
             $('.pgpt').hide();

           }
           // end of codeSetting


           g.popTxt =function($event)
            {
              var s = $($event.target).parent('div').find('textarea').val();

              console.log(s);

              var $div = $('.pgpt');
               $div.find('table textarea').val(s);
               $($event.target).parent('div').append($div);
               $div.show();

            }
            //end of popTxt


           g.textSetting = function()
            {

              var content =$('.pgpt textarea').val() ;
              $('.pgpt').parent('div').find('textarea').val(content).attr('v','e');
              $('.pgpt').hide();

            }
            // end of codeSetting




           g.jqueryInit = function(){

             $(document).off('change', "[tag='edit']", function () {
                $(this).attr("v", "e");
            });

             $(document).on('change', "[tag='edit']", function () {
                 $(this).attr("v", "e");
             });

             $(document).off('click', "[tag='edit']", function () {
                 $(this).attr("v", "e");
             });
             $(document).on('click', "[tag='edit']", function () {
                 $(this).attr("v", "e");
             });


             $("body").off("click","#sub .remove", function () {

             });




             $("body").off('click').on("click","#sub .remove", function () {
                 var that = this;
                 g.modal_confirm("确认删除?",function(){

                       var di = $(that).parent('td').parent('tr');
                       var p=  di.find('.index').val();
                       if (p != undefined && p != '')
                       {
                           var ex = $('#rowdel').val();
                           ex += ',' + p;
                           $('#rowdel').val(ex);
                           console.log(ex);
                       }
                       var rows = parseInt($("#rowcount").val());
                       rows = rows - 1;
                       $("#rowcount").val(rows);

                       di.remove();
                 });

             });



           }
           //end of jqueryInit




      return g;

}]);


//函数参考http://wuxiangqian.iteye.com/blog/1426339
// 改动为判定输入数组,产出排名
// 汉字拼音首字母列表 本列表包含了20902个汉字,用于配合 ToChineseSpell
//函数使用,本表收录的字符的Unicode编码范围为19968至40869, XDesigner 整理

const strChineseFirstPY = 'YDYQSXMWZSSXJBYMGCCZQPSSQBYCDSCDQLDYLYBSSJGYZZJJFKCCLZDHWDWZJLJPFYYNWJJTMYHZWZHFLZPPQHGSCYYYNJQYXXGJHHSDSJNKKTMOMLCRXYPSNQSECCQZGGLLYJLMYZZSECYKYYHQWJSSGGYXYZYJWWKDJHYCHMYXJTLXJYQBYXZLDWRDJRWYSRLDZJPCBZJJBRCFTLECZSTZFXXZHTRQHYBDLYCZSSYMMRFMYQZPWWJJYFCRWFDFZQPYDDWYXKYJAWJFFXYPSFTZYHHYZYSWCJYXSCLCXXWZZXNBGNNXBXLZSZSBSGPYSYZDHMDZBQBZCWDZZYYTZHBTSYYBZGNTNXQYWQSKBPHHLXGYBFMJEBJHHGQTJCYSXSTKZHLYCKGLYSMZXYALMELDCCXGZYRJXSDLTYZCQKCNNJWHJTZZCQLJSTSTBNXBTYXCEQXGKWJYFLZQLYHYXSPSFXLMPBYSXXXYDJCZYLLLSJXFHJXPJBTFFYABYXBHZZBJYZLWLCZGGBTSSMDTJZXPTHYQTGLJSCQFZKJZJQNLZWLSLHDZBWJNCJZYZSQQYCQYRZCJJWYBRTWPYFTWEXCSKDZCTBZHYZZYYJXZCFFZZMJYXXSDZZOTTBZLQWFCKSZSXFYRLNYJMBDTHJXSQQCCSBXYYTSYFBXDZTGBCNSLCYZZPSAZYZZSCJCSHZQYDXLBPJLLMQXTYDZXSQJTZPXLCGLQTZWJBHCTSYJSFXYEJJTLBGXSXJMYJQQPFZASYJNTYDJXKJCDJSZCBARTDCLYJQMWNQNCLLLKBYBZZSYHQQLTWLCCXTXLLZNTYLNEWYZYXCZXXGRKRMTCNDNJTSYYSSDQDGHSDBJGHRWRQLYBGLXHLGTGXBQJDZPYJSJYJCTMRNYMGRZJCZGJMZMGXMPRYXKJNYMSGMZJYMKMFXMLDTGFBHCJHKYLPFMDXLQJJSMTQGZSJLQDLDGJYCALCMZCSDJLLNXDJFFFFJCZFMZFFPFKHKGDPSXKTACJDHHZDDCRRCFQYJKQCCWJDXHWJLYLLZGCFCQDSMLZPBJJPLSBCJGGDCKKDEZSQCCKJGCGKDJTJDLZYCXKLQSCGJCLTFPCQCZGWPJDQYZJJBYJHSJDZWGFSJGZKQCCZLLPSPKJGQJHZZLJPLGJGJJTHJJYJZCZMLZLYQBGJWMLJKXZDZNJQSYZMLJLLJKYWXMKJLHSKJGBMCLYYMKXJQLBMLLKMDXXKWYXYSLMLPSJQQJQXYXFJTJDXMXXLLCXQBSYJBGWYMBGGBCYXPJYGPEPFGDJGBHBNSQJYZJKJKHXQFGQZKFHYGKHDKLLSDJQXPQYKYBNQSXQNSZSWHBSXWHXWBZZXDMNSJBSBKBBZKLYLXGWXDRWYQZMYWSJQLCJXXJXKJEQXSCYETLZHLYYYSDZPAQYZCMTLSHTZCFYZYXYLJSDCJQAGYSLCQLYYYSHMRQQKLDXZSCSSSYDYCJYSFSJBFRSSZQSBXXPXJYSDRCKGJLGDKZJZBDKTCSYQPYHSTCLDJDHMXMCGXYZHJDDTMHLTXZXYLYMOHYJCLTYFBQQXPFBDFHHTKSQHZYYWCNXXCRWHOWGYJLEGWDQCWGFJYCSNTMYTOLBYGWQWESJPWNMLRYDZSZTXYQPZGCWXHNGPYXSHMYQJXZTDPPBFYHZHTJYFDZWKGKZBLDNTSXHQEEGZZYLZMMZYJZGXZXKHKSTXNXXWYLYAPSTHXDWHZYMPXAGKYDXBHNHXKDPJNMYHYLPMGOCSLNZHKXXLPZZLBMLSFBHHGYGYYGGBHSCYAQTYWLXTZQCEZYDQDQMMHTKLLSZHLSJZWFYHQSWSCWLQAZYNYTLSXTHAZNKZZSZZLAXXZWWCTGQQTDDYZTCCHYQZFLXPSLZYGPZSZNGLNDQTBDLXGTCTAJDKYWNSYZLJHHZZCWNYYZYWMHYCHHYXHJKZWSXHZYXLYSKQYSPSLYZWMYPPKBYGLKZHTYXAXQSYSHXASMCHKDSCRSWJPWXSGZJLWWSCHSJHSQNHCSEGNDAQTBAALZZMSSTDQJCJKTSCJAXPLGGXHHGXXZCXPDMMHLDGTYBYSJMXHMRCPXXJZCKZXSHMLQXXTTHXWZFKHCCZDYTCJYXQHLXDHYPJQXYLSYYDZOZJNYXQEZYSQYAYXWYPDGXDDXSPPYZNDLTWRHXYDXZZJHTCXMCZLHPYYYYMHZLLHNXMYLLLMDCPPXHMXDKYCYRDLTXJCHHZZXZLCCLYLNZSHZJZZLNNRLWHYQSNJHXYNTTTKYJPYCHHYEGKCTTWLGQRLGGTGTYGYHPYHYLQYQGCWYQKPYYYTTTTLHYHLLTYTTSPLKYZXGZWGPYDSSZZDQXSKCQNMJJZZBXYQMJRTFFBTKHZKBXLJJKDXJTLBWFZPPTKQTZTGPDGNTPJYFALQMKGXBDCLZFHZCLLLLADPMXDJHLCCLGYHDZFGYDDGCYYFGYDXKSSEBDHYKDKDKHNAXXYBPBYYHXZQGAFFQYJXDMLJCSQZLLPCHBSXGJYNDYBYQSPZWJLZKSDDTACTBXZDYZYPJZQSJNKKTKNJDJGYYPGTLFYQKASDNTCYHBLWDZHBBYDWJRYGKZYHEYYFJMSDTYFZJJHGCXPLXHLDWXXJKYTCYKSSSMTWCTTQZLPBSZDZWZXGZAGYKTYWXLHLSPBCLLOQMMZSSLCMBJCSZZKYDCZJGQQDSMCYTZQQLWZQZXSSFPTTFQMDDZDSHDTDWFHTDYZJYQJQKYPBDJYYXTLJHDRQXXXHAYDHRJLKLYTWHLLRLLRCXYLBWSRSZZSYMKZZHHKYHXKSMDSYDYCJPBZBSQLFCXXXNXKXWYWSDZYQOGGQMMYHCDZTTFJYYBGSTTTYBYKJDHKYXBELHTYPJQNFXFDYKZHQKZBYJTZBXHFDXKDASWTAWAJLDYJSFHBLDNNTNQJTJNCHXFJSRFWHZFMDRYJYJWZPDJKZYJYMPCYZNYNXFBYTFYFWYGDBNZZZDNYTXZEMMQBSQEHXFZMBMFLZZSRXYMJGSXWZJSPRYDJSJGXHJJGLJJYNZZJXHGXKYMLPYYYCXYTWQZSWHWLYRJLPXSLSXMFSWWKLCTNXNYNPSJSZHDZEPTXMYYWXYYSYWLXJQZQXZDCLEEELMCPJPCLWBXSQHFWWTFFJTNQJHJQDXHWLBYZNFJLALKYYJLDXHHYCSTYYWNRJYXYWTRMDRQHWQCMFJDYZMHMYYXJWMYZQZXTLMRSPWWCHAQBXYGZYPXYYRRCLMPYMGKSJSZYSRMYJSNXTPLNBAPPYPYLXYYZKYNLDZYJZCZNNLMZHHARQMPGWQTZMXXMLLHGDZXYHXKYXYCJMFFYYHJFSBSSQLXXNDYCANNMTCJCYPRRNYTYQNYYMBMSXNDLYLYSLJRLXYSXQMLLYZLZJJJKYZZCSFBZXXMSTBJGNXYZHLXNMCWSCYZYFZLXBRNNNYLBNRTGZQYSATSWRYHYJZMZDHZGZDWYBSSCSKXSYHYTXXGCQGXZZSHYXJSCRHMKKBXCZJYJYMKQHZJFNBHMQHYSNJNZYBKNQMCLGQHWLZNZSWXKHLJHYYBQLBFCDSXDLDSPFZPSKJYZWZXZDDXJSMMEGJSCSSMGCLXXKYYYLNYPWWWGYDKZJGGGZGGSYCKNJWNJPCXBJJTQTJWDSSPJXZXNZXUMELPXFSXTLLXCLJXJJLJZXCTPSWXLYDHLYQRWHSYCSQYYBYAYWJJJQFWQCQQCJQGXALDBZZYJGKGXPLTZYFXJLTPADKYQHPMATLCPDCKBMTXYBHKLENXDLEEGQDYMSAWHZMLJTWYGXLYQZLJEEYYBQQFFNLYXRDSCTGJGXYYNKLLYQKCCTLHJLQMKKZGCYYGLLLJDZGYDHZWXPYSJBZKDZGYZZHYWYFQYTYZSZYEZZLYMHJJHTSMQWYZLKYYWZCSRKQYTLTDXWCTYJKLWSQZWBDCQYNCJSRSZJLKCDCDTLZZZACQQZZDDXYPLXZBQJYLZLLLQDDZQJYJYJZYXNYYYNYJXKXDAZWYRDLJYYYRJLXLLDYXJCYWYWNQCCLDDNYYYNYCKCZHXXCCLGZQJGKWPPCQQJYSBZZXYJSQPXJPZBSBDSFNSFPZXHDWZTDWPPTFLZZBZDMYYPQJRSDZSQZSQXBDGCPZSWDWCSQZGMDHZXMWWFYBPDGPHTMJTHZSMMBGZMBZJCFZWFZBBZMQCFMBDMCJXLGPNJBBXGYHYYJGPTZGZMQBQTCGYXJXLWZKYDPDYMGCFTPFXYZTZXDZXTGKMTYBBCLBJASKYTSSQYYMSZXFJEWLXLLSZBQJJJAKLYLXLYCCTSXMCWFKKKBSXLLLLJYXTYLTJYYTDPJHNHNNKBYQNFQYYZBYYESSESSGDYHFHWTCJBSDZZTFDMXHCNJZYMQWSRYJDZJQPDQBBSTJGGFBKJBXTGQHNGWJXJGDLLTHZHHYYYYYYSXWTYYYCCBDBPYPZYCCZYJPZYWCBDLFWZCWJDXXHYHLHWZZXJTCZLCDPXUJCZZZLYXJJTXPHFXWPYWXZPTDZZBDZCYHJHMLXBQXSBYLRDTGJRRCTTTHYTCZWMXFYTWWZCWJWXJYWCSKYBZSCCTZQNHXNWXXKHKFHTSWOCCJYBCMPZZYKBNNZPBZHHZDLSYDDYTYFJPXYNGFXBYQXCBHXCPSXTYZDMKYSNXSXLHKMZXLYHDHKWHXXSSKQYHHCJYXGLHZXCSNHEKDTGZXQYPKDHEXTYKCNYMYYYPKQYYYKXZLTHJQTBYQHXBMYHSQCKWWYLLHCYYLNNEQXQWMCFBDCCMLJGGXDQKTLXKGNQCDGZJWYJJLYHHQTTTNWCHMXCXWHWSZJYDJCCDBQCDGDNYXZTHCQRXCBHZTQCBXWGQWYYBXHMBYMYQTYEXMQKYAQYRGYZSLFYKKQHYSSQYSHJGJCNXKZYCXSBXYXHYYLSTYCXQTHYSMGSCPMMGCCCCCMTZTASMGQZJHKLOSQYLSWTMXSYQKDZLJQQYPLSYCZTCQQPBBQJZCLPKHQZYYXXDTDDTSJCXFFLLCHQXMJLWCJCXTSPYCXNDTJSHJWXDQQJSKXYAMYLSJHMLALYKXCYYDMNMDQMXMCZNNCYBZKKYFLMCHCMLHXRCJJHSYLNMTJZGZGYWJXSRXCWJGJQHQZDQJDCJJZKJKGDZQGJJYJYLXZXXCDQHHHEYTMHLFSBDJSYYSHFYSTCZQLPBDRFRZTZYKYWHSZYQKWDQZRKMSYNBCRXQBJYFAZPZZEDZCJYWBCJWHYJBQSZYWRYSZPTDKZPFPBNZTKLQYHBBZPNPPTYZZYBQNYDCPJMMCYCQMCYFZZDCMNLFPBPLNGQJTBTTNJZPZBBZNJKLJQYLNBZQHKSJZNGGQSZZKYXSHPZSNBCGZKDDZQANZHJKDRTLZLSWJLJZLYWTJNDJZJHXYAYNCBGTZCSSQMNJPJYTYSWXZFKWJQTKHTZPLBHSNJZSYZBWZZZZLSYLSBJHDWWQPSLMMFBJDWAQYZTCJTBNNWZXQXCDSLQGDSDPDZHJTQQPSWLYYJZLGYXYZLCTCBJTKTYCZJTQKBSJLGMGZDMCSGPYNJZYQYYKNXRPWSZXMTNCSZZYXYBYHYZAXYWQCJTLLCKJJTJHGDXDXYQYZZBYWDLWQCGLZGJGQRQZCZSSBCRPCSKYDZNXJSQGXSSJMYDNSTZTPBDLTKZWXQWQTZEXNQCZGWEZKSSBYBRTSSSLCCGBPSZQSZLCCGLLLZXHZQTHCZMQGYZQZNMCOCSZJMMZSQPJYGQLJYJPPLDXRGZYXCCSXHSHGTZNLZWZKJCXTCFCJXLBMQBCZZWPQDNHXLJCTHYZLGYLNLSZZPCXDSCQQHJQKSXZPBAJYEMSMJTZDXLCJYRYYNWJBNGZZTMJXLTBSLYRZPYLSSCNXPHLLHYLLQQZQLXYMRSYCXZLMMCZLTZSDWTJJLLNZGGQXPFSKYGYGHBFZPDKMWGHCXMSGDXJMCJZDYCABXJDLNBCDQYGSKYDQTXDJJYXMSZQAZDZFSLQXYJSJZYLBTXXWXQQZBJZUFBBLYLWDSLJHXJYZJWTDJCZFQZQZZDZSXZZQLZCDZFJHYSPYMPQZMLPPLFFXJJNZZYLSJEYQZFPFZKSYWJJJHRDJZZXTXXGLGHYDXCSKYSWMMZCWYBAZBJKSHFHJCXMHFQHYXXYZFTSJYZFXYXPZLCHMZMBXHZZSXYFYMNCWDABAZLXKTCSHHXKXJJZJSTHYGXSXYYHHHJWXKZXSSBZZWHHHCWTZZZPJXSNXQQJGZYZYWLLCWXZFXXYXYHXMKYYSWSQMNLNAYCYSPMJKHWCQHYLAJJMZXHMMCNZHBHXCLXTJPLTXYJHDYYLTTXFSZHYXXSJBJYAYRSMXYPLCKDUYHLXRLNLLSTYZYYQYGYHHSCCSMZCTZQXKYQFPYYRPFFLKQUNTSZLLZMWWTCQQYZWTLLMLMPWMBZSSTZRBPDDTLQJJBXZCSRZQQYGWCSXFWZLXCCRSZDZMCYGGDZQSGTJSWLJMYMMZYHFBJDGYXCCPSHXNZCSBSJYJGJMPPWAFFYFNXHYZXZYLREMZGZCYZSSZDLLJCSQFNXZKPTXZGXJJGFMYYYSNBTYLBNLHPFZDCYFBMGQRRSSSZXYSGTZRNYDZZCDGPJAFJFZKNZBLCZSZPSGCYCJSZLMLRSZBZZLDLSLLYSXSQZQLYXZLSKKBRXBRBZCYCXZZZEEYFGKLZLYYHGZSGZLFJHGTGWKRAAJYZKZQTSSHJJXDCYZUYJLZYRZDQQHGJZXSSZBYKJPBFRTJXLLFQWJHYLQTYMBLPZDXTZYGBDHZZRBGXHWNJTJXLKSCFSMWLSDQYSJTXKZSCFWJLBXFTZLLJZLLQBLSQMQQCGCZFPBPHZCZJLPYYGGDTGWDCFCZQYYYQYSSCLXZSKLZZZGFFCQNWGLHQYZJJCZLQZZYJPJZZBPDCCMHJGXDQDGDLZQMFGPSYTSDYFWWDJZJYSXYYCZCYHZWPBYKXRYLYBHKJKSFXTZJMMCKHLLTNYYMSYXYZPYJQYCSYCWMTJJKQYRHLLQXPSGTLYYCLJSCPXJYZFNMLRGJJTYZBXYZMSJYJHHFZQMSYXRSZCWTLRTQZSSTKXGQKGSPTGCZNJSJCQCXHMXGGZTQYDJKZDLBZSXJLHYQGGGTHQSZPYHJHHGYYGKGGCWJZZYLCZLXQSFTGZSLLLMLJSKCTBLLZZSZMMNYTPZSXQHJCJYQXYZXZQZCPSHKZZYSXCDFGMWQRLLQXRFZTLYSTCTMJCXJJXHJNXTNRZTZFQYHQGLLGCXSZSJDJLJCYDSJTLNYXHSZXCGJZYQPYLFHDJSBPCCZHJJJQZJQDYBSSLLCMYTTMQTBHJQNNYGKYRQYQMZGCJKPDCGMYZHQLLSLLCLMHOLZGDYYFZSLJCQZLYLZQJESHNYLLJXGJXLYSYYYXNBZLJSSZCQQCJYLLZLTJYLLZLLBNYLGQCHXYYXOXCXQKYJXXXYKLXSXXYQXCYKQXQCSGYXXYQXYGYTQOHXHXPYXXXULCYEYCHZZCBWQBBWJQZSCSZSSLZYLKDESJZWMYMCYTSDSXXSCJPQQSQYLYYZYCMDJDZYWCBTJSYDJKCYDDJLBDJJSODZYSYXQQYXDHHGQQYQHDYXWGMMMAJDYBBBPPBCMUUPLJZSMTXERXJMHQNUTPJDCBSSMSSSTKJTSSMMTRCPLZSZMLQDSDMJMQPNQDXCFYNBFSDQXYXHYAYKQYDDLQYYYSSZBYDSLNTFQTZQPZMCHDHCZCWFDXTMYQSPHQYYXSRGJCWTJTZZQMGWJJTJHTQJBBHWZPXXHYQFXXQYWYYHYSCDYDHHQMNMTMWCPBSZPPZZGLMZFOLLCFWHMMSJZTTDHZZYFFYTZZGZYSKYJXQYJZQBHMBZZLYGHGFMSHPZFZSNCLPBQSNJXZSLXXFPMTYJYGBXLLDLXPZJYZJYHHZCYWHJYLSJEXFSZZYWXKZJLUYDTMLYMQJPWXYHXSKTQJEZRPXXZHHMHWQPWQLYJJQJJZSZCPHJLCHHNXJLQWZJHBMZYXBDHHYPZLHLHLGFWLCHYYTLHJXCJMSCPXSTKPNHQXSRTYXXTESYJCTLSSLSTDLLLWWYHDHRJZSFGXTSYCZYNYHTDHWJSLHTZDQDJZXXQHGYLTZPHCSQFCLNJTCLZPFSTPDYNYLGMJLLYCQHYSSHCHYLHQYQTMZYPBYWRFQYKQSYSLZDQJMPXYYSSRHZJNYWTQDFZBWWTWWRXCWHGYHXMKMYYYQMSMZHNGCEPMLQQMTCWCTMMPXJPJJHFXYYZSXZHTYBMSTSYJTTQQQYYLHYNPYQZLCYZHZWSMYLKFJXLWGXYPJYTYSYXYMZCKTTWLKSMZSYLMPWLZWXWQZSSAQSYXYRHSSNTSRAPXCPWCMGDXHXZDZYFJHGZTTSBJHGYZSZYSMYCLLLXBTYXHBBZJKSSDMALXHYCFYGMQYPJYCQXJLLLJGSLZGQLYCJCCZOTYXMTMTTLLWTGPXYMZMKLPSZZZXHKQYSXCTYJZYHXSHYXZKXLZWPSQPYHJWPJPWXQQYLXSDHMRSLZZYZWTTCYXYSZZSHBSCCSTPLWSSCJCHNLCGCHSSPHYLHFHHXJSXYLLNYLSZDHZXYLSXLWZYKCLDYAXZCMDDYSPJTQJZLNWQPSSSWCTSTSZLBLNXSMNYYMJQBQHRZWTYYDCHQLXKPZWBGQYBKFCMZWPZLLYYLSZYDWHXPSBCMLJBSCGBHXLQHYRLJXYSWXWXZSLDFHLSLYNJLZYFLYJYCDRJLFSYZFSLLCQYQFGJYHYXZLYLMSTDJCYHBZLLNWLXXYGYYHSMGDHXXHHLZZJZXCZZZCYQZFNGWPYLCPKPYYPMCLQKDGXZGGWQBDXZZKZFBXXLZXJTPJPTTBYTSZZDWSLCHZHSLTYXHQLHYXXXYYZYSWTXZKHLXZXZPYHGCHKCFSYHUTJRLXFJXPTZTWHPLYXFCRHXSHXKYXXYHZQDXQWULHYHMJTBFLKHTXCWHJFWJCFPQRYQXCYYYQYGRPYWSGSUNGWCHKZDXYFLXXHJJBYZWTSXXNCYJJYMSWZJQRMHXZWFQSYLZJZGBHYNSLBGTTCSYBYXXWXYHXYYXNSQYXMQYWRGYQLXBBZLJSYLPSYTJZYHYZAWLRORJMKSCZJXXXYXCHDYXRYXXJDTSQFXLYLTSFFYXLMTYJMJUYYYXLTZCSXQZQHZXLYYXZHDNBRXXXJCTYHLBRLMBRLLAXKYLLLJLYXXLYCRYLCJTGJCMTLZLLCYZZPZPCYAWHJJFYBDYYZSMPCKZDQYQPBPCJPDCYZMDPBCYYDYCNNPLMTMLRMFMMGWYZBSJGYGSMZQQQZTXMKQWGXLLPJGZBQCDJJJFPKJKCXBLJMSWMDTQJXLDLPPBXCWRCQFBFQJCZAHZGMYKPHYYHZYKNDKZMBPJYXPXYHLFPNYYGXJDBKXNXHJMZJXSTRSTLDXSKZYSYBZXJLXYSLBZYSLHXJPFXPQNBYLLJQKYGZMCYZZYMCCSLCLHZFWFWYXZMWSXTYNXJHPYYMCYSPMHYSMYDYSHQYZCHMJJMZCAAGCFJBBHPLYZYLXXSDJGXDHKXXTXXNBHRMLYJSLTXMRHNLXQJXYZLLYSWQGDLBJHDCGJYQYCMHWFMJYBMBYJYJWYMDPWHXQLDYGPDFXXBCGJSPCKRSSYZJMSLBZZJFLJJJLGXZGYXYXLSZQYXBEXYXHGCXBPLDYHWETTWWCJMBTXCHXYQXLLXFLYXLLJLSSFWDPZSMYJCLMWYTCZPCHQEKCQBWLCQYDPLQPPQZQFJQDJHYMMCXTXDRMJWRHXCJZYLQXDYYNHYYHRSLSRSYWWZJYMTLTLLGTQCJZYABTCKZCJYCCQLJZQXALMZYHYWLWDXZXQDLLQSHGPJFJLJHJABCQZDJGTKHSSTCYJLPSWZLXZXRWGLDLZRLZXTGSLLLLZLYXXWGDZYGBDPHZPBRLWSXQBPFDWOFMWHLYPCBJCCLDMBZPBZZLCYQXLDOMZBLZWPDWYYGDSTTHCSQSCCRSSSYSLFYBFNTYJSZDFNDPDHDZZMBBLSLCMYFFGTJJQWFTMTPJWFNLBZCMMJTGBDZLQLPYFHYYMJYLSDCHDZJWJCCTLJCLDTLJJCPDDSQDSSZYBNDBJLGGJZXSXNLYCYBJXQYCBYLZCFZPPGKCXZDZFZTJJFJSJXZBNZYJQTTYJYHTYCZHYMDJXTTMPXSPLZCDWSLSHXYPZGTFMLCJTYCBPMGDKWYCYZCDSZZYHFLYCTYGWHKJYYLSJCXGYWJCBLLCSNDDBTZBSCLYZCZZSSQDLLMQYYHFSLQLLXFTYHABXGWNYWYYPLLSDLDLLBJCYXJZMLHLJDXYYQYTDLLLBUGBFDFBBQJZZMDPJHGCLGMJJPGAEHHBWCQXAXHHHZCHXYPHJAXHLPHJPGPZJQCQZGJJZZUZDMQYYBZZPHYHYBWHAZYJHYKFGDPFQSDLZMLJXKXGALXZDAGLMDGXMWZQYXXDXXPFDMMSSYMPFMDMMKXKSYZYSHDZKXSYSMMZZZMSYDNZZCZXFPLSTMZDNMXCKJMZTYYMZMZZMSXHHDCZJEMXXKLJSTLWLSQLYJZLLZJSSDPPMHNLZJCZYHMXXHGZCJMDHXTKGRMXFWMCGMWKDTKSXQMMMFZZYDKMSCLCMPCGMHSPXQPZDSSLCXKYXTWLWJYAHZJGZQMCSNXYYMMPMLKJXMHLMLQMXCTKZMJQYSZJSYSZHSYJZJCDAJZYBSDQJZGWZQQXFKDMSDJLFWEHKZQKJPEYPZYSZCDWYJFFMZZYLTTDZZEFMZLBNPPLPLPEPSZALLTYLKCKQZKGENQLWAGYXYDPXLHSXQQWQCQXQCLHYXXMLYCCWLYMQYSKGCHLCJNSZKPYZKCQZQLJPDMDZHLASXLBYDWQLWDNBQCRYDDZTJYBKBWSZDXDTNPJDTCTQDFXQQMGNXECLTTBKPWSLCTYQLPWYZZKLPYGZCQQPLLKCCYLPQMZCZQCLJSLQZDJXLDDHPZQDLJJXZQDXYZQKZLJCYQDYJPPYPQYKJYRMPCBYMCXKLLZLLFQPYLLLMBSGLCYSSLRSYSQTMXYXZQZFDZUYSYZTFFMZZSMZQHZSSCCMLYXWTPZGXZJGZGSJSGKDDHTQGGZLLBJDZLCBCHYXYZHZFYWXYZYMSDBZZYJGTSMTFXQYXQSTDGSLNXDLRYZZLRYYLXQHTXSRTZNGZXBNQQZFMYKMZJBZYMKBPNLYZPBLMCNQYZZZSJZHJCTZKHYZZJRDYZHNPXGLFZTLKGJTCTSSYLLGZRZBBQZZKLPKLCZYSSUYXBJFPNJZZXCDWXZYJXZZDJJKGGRSRJKMSMZJLSJYWQSKYHQJSXPJZZZLSNSHRNYPZTWCHKLPSRZLZXYJQXQKYSJYCZTLQZYBBYBWZPQDWWYZCYTJCJXCKCWDKKZXSGKDZXWWYYJQYYTCYTDLLXWKCZKKLCCLZCQQDZLQLCSFQCHQHSFSMQZZLNBJJZBSJHTSZDYSJQJPDLZCDCWJKJZZLPYCGMZWDJJBSJQZSYZYHHXJPBJYDSSXDZNCGLQMBTSFSBPDZDLZNFGFJGFSMPXJQLMBLGQCYYXBQKDJJQYRFKZTJDHCZKLBSDZCFJTPLLJGXHYXZCSSZZXSTJYGKGCKGYOQXJPLZPBPGTGYJZGHZQZZLBJLSQFZGKQQJZGYCZBZQTLDXRJXBSXXPZXHYZYCLWDXJJHXMFDZPFZHQHQMQGKSLYHTYCGFRZGNQXCLPDLBZCSCZQLLJBLHBZCYPZZPPDYMZZSGYHCKCPZJGSLJLNSCDSLDLXBMSTLDDFJMKDJDHZLZXLSZQPQPGJLLYBDSZGQLBZLSLKYYHZTTNTJYQTZZPSZQZTLLJTYYLLQLLQYZQLBDZLSLYYZYMDFSZSNHLXZNCZQZPBWSKRFBSYZMTHBLGJPMCZZLSTLXSHTCSYZLZBLFEQHLXFLCJLYLJQCBZLZJHHSSTBRMHXZHJZCLXFNBGXGTQJCZTMSFZKJMSSNXLJKBHSJXNTNLZDNTLMSJXGZJYJCZXYJYJWRWWQNZTNFJSZPZSHZJFYRDJSFSZJZBJFZQZZHZLXFYSBZQLZSGYFTZDCSZXZJBQMSZKJRHYJZCKMJKHCHGTXKXQGLXPXFXTRTYLXJXHDTSJXHJZJXZWZLCQSBTXWXGXTXXHXFTSDKFJHZYJFJXRZSDLLLTQSQQZQWZXSYQTWGWBZCGZLLYZBCLMQQTZHZXZXLJFRMYZFLXYSQXXJKXRMQDZDMMYYBSQBHGZMWFWXGMXLZPYYTGZYCCDXYZXYWGSYJYZNBHPZJSQSYXSXRTFYZGRHZTXSZZTHCBFCLSYXZLZQMZLMPLMXZJXSFLBYZMYQHXJSXRXSQZZZSSLYFRCZJRCRXHHZXQYDYHXSJJHZCXZBTYNSYSXJBQLPXZQPYMLXZKYXLXCJLCYSXXZZLXDLLLJJYHZXGYJWKJRWYHCPSGNRZLFZWFZZNSXGXFLZSXZZZBFCSYJDBRJKRDHHGXJLJJTGXJXXSTJTJXLYXQFCSGSWMSBCTLQZZWLZZKXJMLTMJYHSDDBXGZHDLBMYJFRZFSGCLYJBPMLYSMSXLSZJQQHJZFXGFQFQBPXZGYYQXGZTCQWYLTLGWSGWHRLFSFGZJMGMGBGTJFSYZZGZYZAFLSSPMLPFLCWBJZCLJJMZLPJJLYMQDMYYYFBGYGYZMLYZDXQYXRQQQHSYYYQXYLJTYXFSFSLLGNQCYHYCWFHCCCFXPYLYPLLZYXXXXXKQHHXSHJZCFZSCZJXCPZWHHHHHAPYLQALPQAFYHXDYLUKMZQGGGDDESRNNZLTZGCHYPPYSQJJHCLLJTOLNJPZLJLHYMHEYDYDSQYCDDHGZUNDZCLZYZLLZNTNYZGSLHSLPJJBDGWXPCDUTJCKLKCLWKLLCASSTKZZDNQNTTLYYZSSYSSZZRYLJQKCQDHHCRXRZYDGRGCWCGZQFFFPPJFZYNAKRGYWYQPQXXFKJTSZZXSWZDDFBBXTBGTZKZNPZZPZXZPJSZBMQHKCYXYLDKLJNYPKYGHGDZJXXEAHPNZKZTZCMXCXMMJXNKSZQNMNLWBWWXJKYHCPSTMCSQTZJYXTPCTPDTNNPGLLLZSJLSPBLPLQHDTNJNLYYRSZFFJFQWDPHZDWMRZCCLODAXNSSNYZRESTYJWJYJDBCFXNMWTTBYLWSTSZGYBLJPXGLBOCLHPCBJLTMXZLJYLZXCLTPNCLCKXTPZJSWCYXSFYSZDKNTLBYJCYJLLSTGQCBXRYZXBXKLYLHZLQZLNZCXWJZLJZJNCJHXMNZZGJZZXTZJXYCYYCXXJYYXJJXSSSJSTSSTTPPGQTCSXWZDCSYFPTFBFHFBBLZJCLZZDBXGCXLQPXKFZFLSYLTUWBMQJHSZBMDDBCYSCCLDXYCDDQLYJJWMQLLCSGLJJSYFPYYCCYLTJANTJJPWYCMMGQYYSXDXQMZHSZXPFTWWZQSWQRFKJLZJQQYFBRXJHHFWJJZYQAZMYFRHCYYBYQWLPEXCCZSTYRLTTDMQLYKMBBGMYYJPRKZNPBSXYXBHYZDJDNGHPMFSGMWFZMFQMMBCMZZCJJLCNUXYQLMLRYGQZCYXZLWJGCJCGGMCJNFYZZJHYCPRRCMTZQZXHFQGTJXCCJEAQCRJYHPLQLSZDJRBCQHQDYRHYLYXJSYMHZYDWLDFRYHBPYDTSSCNWBXGLPZMLZZTQSSCPJMXXYCSJYTYCGHYCJWYRXXLFEMWJNMKLLSWTXHYYYNCMMCWJDQDJZGLLJWJRKHPZGGFLCCSCZMCBLTBHBQJXQDSPDJZZGKGLFQYWBZYZJLTSTDHQHCTCBCHFLQMPWDSHYYTQWCNZZJTLBYMBPDYYYXSQKXWYYFLXXNCWCXYPMAELYKKJMZZZBRXYYQJFLJPFHHHYTZZXSGQQMHSPGDZQWBWPJHZJDYSCQWZKTXXSQLZYYMYSDZGRXCKKUJLWPYSYSCSYZLRMLQSYLJXBCXTLWDQZPCYCYKPPPNSXFYZJJRCEMHSZMSXLXGLRWGCSTLRSXBZGBZGZTCPLUJLSLYLYMTXMTZPALZXPXJTJWTCYYZLBLXBZLQMYLXPGHDSLSSDMXMBDZZSXWHAMLCZCPJMCNHJYSNSYGCHSKQMZZQDLLKABLWJXSFMOCDXJRRLYQZKJMYBYQLYHETFJZFRFKSRYXFJTWDSXXSYSQJYSLYXWJHSNLXYYXHBHAWHHJZXWMYLJCSSLKYDZTXBZSYFDXGXZJKHSXXYBSSXDPYNZWRPTQZCZENYGCXQFJYKJBZMLJCMQQXUOXSLYXXLYLLJDZBTYMHPFSTTQQWLHOKYBLZZALZXQLHZWRRQHLSTMYPYXJJXMQSJFNBXYXYJXXYQYLTHYLQYFMLKLJTMLLHSZWKZHLJMLHLJKLJSTLQXYLMBHHLNLZXQJHXCFXXLHYHJJGBYZZKBXSCQDJQDSUJZYYHZHHMGSXCSYMXFEBCQWWRBPYYJQTYZCYQYQQZYHMWFFHGZFRJFCDPXNTQYZPDYKHJLFRZXPPXZDBBGZQSTLGDGYLCQMLCHHMFYWLZYXKJLYPQHSYWMQQGQZMLZJNSQXJQSYJYCBEHSXFSZPXZWFLLBCYYJDYTDTHWZSFJMQQYJLMQXXLLDTTKHHYBFPWTYYSQQWNQWLGWDEBZWCMYGCULKJXTMXMYJSXHYBRWFYMWFRXYQMXYSZTZZTFYKMLDHQDXWYYNLCRYJBLPSXCXYWLSPRRJWXHQYPHTYDNXHHMMYWYTZCSQMTSSCCDALWZTCPQPYJLLQZYJSWXMZZMMYLMXCLMXCZMXMZSQTZPPQQBLPGXQZHFLJJHYTJSRXWZXSCCDLXTYJDCQJXSLQYCLZXLZZXMXQRJMHRHZJBHMFLJLMLCLQNLDXZLLLPYPSYJYSXCQQDCMQJZZXHNPNXZMEKMXHYKYQLXSXTXJYYHWDCWDZHQYYBGYBCYSCFGPSJNZDYZZJZXRZRQJJYMCANYRJTLDPPYZBSTJKXXZYPFDWFGZZRPYMTNGXZQBYXNBUFNQKRJQZMJEGRZGYCLKXZDSKKNSXKCLJSPJYYZLQQJYBZSSQLLLKJXTBKTYLCCDDBLSPPFYLGYDTZJYQGGKQTTFZXBDKTYYHYBBFYTYYBCLPDYTGDHRYRNJSPTCSNYJQHKLLLZSLYDXXWBCJQSPXBPJZJCJDZFFXXBRMLAZHCSNDLBJDSZBLPRZTSWSBXBCLLXXLZDJZSJPYLYXXYFTFFFBHJJXGBYXJPMMMPSSJZJMTLYZJXSWXTYLEDQPJMYGQZJGDJLQJWJQLLSJGJGYGMSCLJJXDTYGJQJQJCJZCJGDZZSXQGSJGGCXHQXSNQLZZBXHSGZXCXYLJXYXYYDFQQJHJFXDHCTXJYRXYSQTJXYEFYYSSYYJXNCYZXFXMSYSZXYYSCHSHXZZZGZZZGFJDLTYLNPZGYJYZYYQZPBXQBDZTZCZYXXYHHSQXSHDHGQHJHGYWSZTMZMLHYXGEBTYLZKQWYTJZRCLEKYSTDBCYKQQSAYXCJXWWGSBHJYZYDHCSJKQCXSWXFLTYNYZPZCCZJQTZWJQDZZZQZLJJXLSBHPYXXPSXSHHEZTXFPTLQYZZXHYTXNCFZYYHXGNXMYWXTZSJPTHHGYMXMXQZXTSBCZYJYXXTYYZYPCQLMMSZMJZZLLZXGXZAAJZYXJMZXWDXZSXZDZXLEYJJZQBHZWZZZQTZPSXZTDSXJJJZNYAZPHXYYSRNQDTHZHYYKYJHDZXZLSWCLYBZYECWCYCRYLCXNHZYDZYDYJDFRJJHTRSQTXYXJRJHOJYNXELXSFSFJZGHPZSXZSZDZCQZBYYKLSGSJHCZSHDGQGXYZGXCHXZJWYQWGYHKSSEQZZNDZFKWYSSTCLZSTSYMCDHJXXYWEYXCZAYDMPXMDSXYBSQMJMZJMTZQLPJYQZCGQHXJHHLXXHLHDLDJQCLDWBSXFZZYYSCHTYTYYBHECXHYKGJPXHHYZJFXHWHBDZFYZBCAPNPGNYDMSXHMMMMAMYNBYJTMPXYYMCTHJBZYFCGTYHWPHFTWZZEZSBZEGPFMTSKFTYCMHFLLHGPZJXZJGZJYXZSBBQSCZZLZCCSTPGXMJSFTCCZJZDJXCYBZLFCJSYZFGSZLYBCWZZBYZDZYPSWYJZXZBDSYUXLZZBZFYGCZXBZHZFTPBGZGEJBSTGKDMFHYZZJHZLLZZGJQZLSFDJSSCBZGPDLFZFZSZYZYZSYGCXSNXXCHCZXTZZLJFZGQSQYXZJQDCCZTQCDXZJYQJQCHXZTDLGSCXZSYQJQTZWLQDQZTQCHQQJZYEZZZPBWKDJFCJPZTYPQYQTTYNLMBDKTJZPQZQZZFPZSBNJLGYJDXJDZZKZGQKXDLPZJTCJDQBXDJQJSTCKNXBXZMSLYJCQMTJQWWCJQNJNLLLHJCWQTBZQYDZCZPZZDZYDDCYZZZCCJTTJFZDPRRTZTJDCQTQZDTJNPLZBCLLCTZSXKJZQZPZLBZRBTJDCXFCZDBCCJJLTQQPLDCGZDBBZJCQDCJWYNLLZYZCCDWLLXWZLXRXNTQQCZXKQLSGDFQTDDGLRLAJJTKUYMKQLLTZYTDYYCZGJWYXDXFRSKSTQTENQMRKQZHHQKDLDAZFKYPBGGPZREBZZYKZZSPEGJXGYKQZZZSLYSYYYZWFQZYLZZLZHWCHKYPQGNPGBLPLRRJYXCCSYYHSFZFYBZYYTGZXYLXCZWXXZJZBLFFLGSKHYJZEYJHLPLLLLCZGXDRZELRHGKLZZYHZLYQSZZJZQLJZFLNBHGWLCZCFJYSPYXZLZLXGCCPZBLLCYBBBBUBBCBPCRNNZCZYRBFSRLDCGQYYQXYGMQZWTZYTYJXYFWTEHZZJYWLCCNTZYJJZDEDPZDZTSYQJHDYMBJNYJZLXTSSTPHNDJXXBYXQTZQDDTJTDYYTGWSCSZQFLSHLGLBCZPHDLYZJYCKWTYTYLBNYTSDSYCCTYSZYYEBHEXHQDTWNYGYCLXTSZYSTQMYGZAZCCSZZDSLZCLZRQXYYELJSBYMXSXZTEMBBLLYYLLYTDQYSHYMRQWKFKBFXNXSBYCHXBWJYHTQBPBSBWDZYLKGZSKYHXQZJXHXJXGNLJKZLYYCDXLFYFGHLJGJYBXQLYBXQPQGZTZPLNCYPXDJYQYDYMRBESJYYHKXXSTMXRCZZYWXYQYBMCLLYZHQYZWQXDBXBZWZMSLPDMYSKFMZKLZCYQYCZLQXFZZYDQZPZYGYJYZMZXDZFYFYTTQTZHGSPCZMLCCYTZXJCYTJMKSLPZHYSNZLLYTPZCTZZCKTXDHXXTQCYFKSMQCCYYAZHTJPCYLZLYJBJXTPNYLJYYNRXSYLMMNXJSMYBCSYSYLZYLXJJQYLDZLPQBFZZBLFNDXQKCZFYWHGQMRDSXYCYTXNQQJZYYPFZXDYZFPRXEJDGYQBXRCNFYYQPGHYJDYZXGRHTKYLNWDZNTSMPKLBTHBPYSZBZTJZSZZJTYYXZPHSSZZBZCZPTQFZMYFLYPYBBJQXZMXXDJMTSYSKKBJZXHJCKLPSMKYJZCXTMLJYXRZZQSLXXQPYZXMKYXXXJCLJPRMYYGADYSKQLSNDHYZKQXZYZTCGHZTLMLWZYBWSYCTBHJHJFCWZTXWYTKZLXQSHLYJZJXTMPLPYCGLTBZZTLZJCYJGDTCLKLPLLQPJMZPAPXYZLKKTKDZCZZBNZDYDYQZJYJGMCTXLTGXSZLMLHBGLKFWNWZHDXUHLFMKYSLGXDTWWFRJEJZTZHYDXYKSHWFZCQSHKTMQQHTZHYMJDJSKHXZJZBZZXYMPAGQMSTPXLSKLZYNWRTSQLSZBPSPSGZWYHTLKSSSWHZZLYYTNXJGMJSZSUFWNLSOZTXGXLSAMMLBWLDSZYLAKQCQCTMYCFJBSLXCLZZCLXXKSBZQCLHJPSQPLSXXCKSLNHPSFQQYTXYJZLQLDXZQJZDYYDJNZPTUZDSKJFSLJHYLZSQZLBTXYDGTQFDBYAZXDZHZJNHHQBYKNXJJQCZMLLJZKSPLDYCLBBLXKLELXJLBQYCXJXGCNLCQPLZLZYJTZLJGYZDZPLTQCSXFDMNYCXGBTJDCZNBGBQYQJWGKFHTNPYQZQGBKPBBYZMTJDYTBLSQMPSXTBNPDXKLEMYYCJYNZCTLDYKZZXDDXHQSHDGMZSJYCCTAYRZLPYLTLKXSLZCGGEXCLFXLKJRTLQJAQZNCMBYDKKCXGLCZJZXJHPTDJJMZQYKQSECQZDSHHADMLZFMMZBGNTJNNLGBYJBRBTMLBYJDZXLCJLPLDLPCQDHLXZLYCBLCXZZJADJLNZMMSSSMYBHBSQKBHRSXXJMXSDZNZPXLGBRHWGGFCXGMSKLLTSJYYCQLTSKYWYYHYWXBXQYWPYWYKQLSQPTNTKHQCWDQKTWPXXHCPTHTWUMSSYHBWCRWXHJMKMZNGWTMLKFGHKJYLSYYCXWHYECLQHKQHTTQKHFZLDXQWYZYYDESBPKYRZPJFYYZJCEQDZZDLATZBBFJLLCXDLMJSSXEGYGSJQXCWBXSSZPDYZCXDNYXPPZYDLYJCZPLTXLSXYZYRXCYYYDYLWWNZSAHJSYQYHGYWWAXTJZDAXYSRLTDPSSYYFNEJDXYZHLXLLLZQZSJNYQYQQXYJGHZGZCYJCHZLYCDSHWSHJZYJXCLLNXZJJYYXNFXMWFPYLCYLLABWDDHWDXJMCXZTZPMLQZHSFHZYNZTLLDYWLSLXHYMMYLMBWWKYXYADTXYLLDJPYBPWUXJMWMLLSAFDLLYFLBHHHBQQLTZJCQJLDJTFFKMMMBYTHYGDCQRDDWRQJXNBYSNWZDBYYTBJHPYBYTTJXAAHGQDQTMYSTQXKBTZPKJLZRBEQQSSMJJBDJOTGTBXPGBKTLHQXJJJCTHXQDWJLWRFWQGWSHCKRYSWGFTGYGBXSDWDWRFHWYTJJXXXJYZYSLPYYYPAYXHYDQKXSHXYXGSKQHYWFDDDPPLCJLQQEEWXKSYYKDYPLTJTHKJLTCYYHHJTTPLTZZCDLTHQKZXQYSTEEYWYYZYXXYYSTTJKLLPZMCYHQGXYHSRMBXPLLNQYDQHXSXXWGDQBSHYLLPJJJTHYJKYPPTHYYKTYEZYENMDSHLCRPQFDGFXZPSFTLJXXJBSWYYSKSFLXLPPLBBBLBSFXFYZBSJSSYLPBBFFFFSSCJDSTZSXZRYYSYFFSYZYZBJTBCTSBSDHRTJJBYTCXYJEYLXCBNEBJDSYXYKGSJZBXBYTFZWGENYHHTHZHHXFWGCSTBGXKLSXYWMTMBYXJSTZSCDYQRCYTWXZFHMYMCXLZNSDJTTTXRYCFYJSBSDYERXJLJXBBDEYNJGHXGCKGSCYMBLXJMSZNSKGXFBNBPTHFJAAFXYXFPXMYPQDTZCXZZPXRSYWZDLYBBKTYQPQJPZYPZJZNJPZJLZZFYSBTTSLMPTZRTDXQSJEHBZYLZDHLJSQMLHTXTJECXSLZZSPKTLZKQQYFSYGYWPCPQFHQHYTQXZKRSGTTSQCZLPTXCDYYZXSQZSLXLZMYCPCQBZYXHBSXLZDLTCDXTYLZJYYZPZYZLTXJSJXHLPMYTXCQRBLZSSFJZZTNJYTXMYJHLHPPLCYXQJQQKZZSCPZKSWALQSBLCCZJSXGWWWYGYKTJBBZTDKHXHKGTGPBKQYSLPXPJCKBMLLXDZSTBKLGGQKQLSBKKTFXRMDKBFTPZFRTBBRFERQGXYJPZSSTLBZTPSZQZSJDHLJQLZBPMSMMSXLQQNHKNBLRDDNXXDHDDJCYYGYLXGZLXSYGMQQGKHBPMXYXLYTQWLWGCPBMQXCYZYDRJBHTDJYHQSHTMJSBYPLWHLZFFNYPMHXXHPLTBQPFBJWQDBYGPNZTPFZJGSDDTQSHZEAWZZYLLTYYBWJKXXGHLFKXDJTMSZSQYNZGGSWQSPHTLSSKMCLZXYSZQZXNCJDQGZDLFNYKLJCJLLZLMZZNHYDSSHTHZZLZZBBHQZWWYCRZHLYQQJBEYFXXXWHSRXWQHWPSLMSSKZTTYGYQQWRSLALHMJTQJSMXQBJJZJXZYZKXBYQXBJXSHZTSFJLXMXZXFGHKZSZGGYLCLSARJYHSLLLMZXELGLXYDJYTLFBHBPNLYZFBBHPTGJKWETZHKJJXZXXGLLJLSTGSHJJYQLQZFKCGNNDJSSZFDBCTWWSEQFHQJBSAQTGYPQLBXBMMYWXGSLZHGLZGQYFLZBYFZJFRYSFMBYZHQGFWZSYFYJJPHZBYYZFFWODGRLMFTWLBZGYCQXCDJYGZYYYYTYTYDWEGAZYHXJLZYYHLRMGRXXZCLHNELJJTJTPWJYBJJBXJJTJTEEKHWSLJPLPSFYZPQQBDLQJJTYYQLYZKDKSQJYYQZLDQTGJQYZJSUCMRYQTHTEJMFCTYHYPKMHYZWJDQFHYYXWSHCTXRLJHQXHCCYYYJLTKTTYTMXGTCJTZAYYOCZLYLBSZYWJYTSJYHBYSHFJLYGJXXTMZYYLTXXYPZLXYJZYZYYPNHMYMDYYLBLHLSYYQQLLNJJYMSOYQBZGDLYXYLCQYXTSZEGXHZGLHWBLJHEYXTWQMAKBPQCGYSHHEGQCMWYYWLJYJHYYZLLJJYLHZYHMGSLJLJXCJJYCLYCJPCPZJZJMMYLCQLNQLJQJSXYJMLSZLJQLYCMMHCFMMFPQQMFYLQMCFFQMMMMHMZNFHHJGTTHHKHSLNCHHYQDXTMMQDCYZYXYQMYQYLTDCYYYZAZZCYMZYDLZFFFMMYCQZWZZMABTBYZTDMNZZGGDFTYPCGQYTTSSFFWFDTZQSSYSTWXJHXYTSXXYLBYQHWWKXHZXWZNNZZJZJJQJCCCHYYXBZXZCYZTLLCQXYNJYCYYCYNZZQYYYEWYCZDCJYCCHYJLBTZYYCQWMPWPYMLGKDLDLGKQQBGYCHJXY';
//此处收录了375个多音字,数据来自于http://www.51window.net/page/pinyin
var oMultiDiff = { '19969': 'DZ', '19975': 'WM', '19988': 'QJ', '20048': 'YL', '20056': 'SC', '20060': 'NM', '20094': 'QG', '20127': 'QJ', '20167': 'QC', '20193': 'YG', '20250': 'KH', '20256': 'ZC', '20282': 'SC', '20285': 'QJG', '20291': 'TD', '20314': 'YD', '20340': 'NE', '20375': 'TD', '20389': 'YJ', '20391': 'CZ', '20415': 'PB', '20446': 'YS', '20447': 'SQ', '20504': 'TC', '20608': 'KG', '20854': 'QJ', '20857': 'ZC', '20911': 'PF', '20504': 'TC', '20608': 'KG', '20854': 'QJ', '20857': 'ZC', '20911': 'PF', '20985': 'AW', '21032': 'PB', '21048': 'XQ', '21049': 'SC', '21089': 'YS', '21119': 'JC', '21242': 'SB', '21273': 'SC', '21305': 'YP', '21306': 'QO', '21330': 'ZC', '21333': 'SDC', '21345': 'QK', '21378': 'CA', '21397': 'SC', '21414': 'XS', '21442': 'SC', '21477': 'JG', '21480': 'TD', '21484': 'ZS', '21494': 'YX', '21505': 'YX', '21512': 'HG', '21523': 'XH', '21537': 'PB', '21542': 'PF', '21549': 'KH', '21571': 'E', '21574': 'DA', '21588': 'TD', '21589': 'O', '21618': 'ZC', '21621': 'KHA', '21632': 'ZJ', '21654': 'KG', '21679': 'LKG', '21683': 'KH', '21710': 'A', '21719': 'YH', '21734': 'WOE', '21769': 'A', '21780': 'WN', '21804': 'XH', '21834': 'A', '21899': 'ZD', '21903': 'RN', '21908': 'WO', '21939': 'ZC', '21956': 'SA', '21964': 'YA', '21970': 'TD', '22003': 'A', '22031': 'JG', '22040': 'XS', '22060': 'ZC', '22066': 'ZC', '22079': 'MH', '22129': 'XJ', '22179': 'XA', '22237': 'NJ', '22244': 'TD', '22280': 'JQ', '22300': 'YH', '22313': 'XW', '22331': 'YQ', '22343': 'YJ', '22351': 'PH', '22395': 'DC', '22412': 'TD', '22484': 'PB', '22500': 'PB', '22534': 'ZD', '22549': 'DH', '22561': 'PB', '22612': 'TD', '22771': 'KQ', '22831': 'HB', '22841': 'JG', '22855': 'QJ', '22865': 'XQ', '23013': 'ML', '23081': 'WM', '23487': 'SX', '23558': 'QJ', '23561': 'YW', '23586': 'YW', '23614': 'YW', '23615': 'SN', '23631': 'PB', '23646': 'ZS', '23663': 'ZT', '23673': 'YG', '23762': 'TD', '23769': 'ZS', '23780': 'QJ', '23884': 'QK', '24055': 'XH', '24113': 'DC', '24162': 'ZC', '24191': 'GA', '24273': 'QJ', '24324': 'NL', '24377': 'TD', '24378': 'QJ', '24439': 'PF', '24554': 'ZS', '24683': 'TD', '24694': 'WE', '24733': 'LK', '24925': 'TN', '25094': 'ZG', '25100': 'XQ', '25103': 'XH', '25153': 'PB', '25170': 'PB', '25179': 'KG', '25203': 'PB', '25240': 'ZS', '25282': 'FB', '25303': 'NA', '25324': 'KG', '25341': 'ZY', '25373': 'WZ', '25375': 'XJ', '25384': 'A', '25457': 'A', '25528': 'SD', '25530': 'SC', '25552': 'TD', '25774': 'ZC', '25874': 'ZC', '26044': 'YW', '26080': 'WM', '26292': 'PB', '26333': 'PB', '26355': 'ZY', '26366': 'CZ', '26397': 'ZC', '26399': 'QJ', '26415': 'ZS', '26451': 'SB', '26526': 'ZC', '26552': 'JG', '26561': 'TD', '26588': 'JG', '26597': 'CZ', '26629': 'ZS', '26638': 'YL', '26646': 'XQ', '26653': 'KG', '26657': 'XJ', '26727': 'HG', '26894': 'ZC', '26937': 'ZS', '26946': 'ZC', '26999': 'KJ', '27099': 'KJ', '27449': 'YQ', '27481': 'XS', '27542': 'ZS', '27663': 'ZS', '27748': 'TS', '27784': 'SC', '27788': 'ZD', '27795': 'TD', '27812': 'O', '27850': 'PB', '27852': 'MB', '27895': 'SL', '27898': 'PL', '27973': 'QJ', '27981': 'KH', '27986': 'HX', '27994': 'XJ', '28044': 'YC', '28065': 'WG', '28177': 'SM', '28267': 'QJ', '28291': 'KH', '28337': 'ZQ', '28463': 'TL', '28548': 'DC', '28601': 'TD', '28689': 'PB', '28805': 'JG', '28820': 'QG', '28846': 'PB', '28952': 'TD', '28975': 'ZC', '29100': 'A', '29325': 'QJ', '29575': 'SL', '29602': 'FB', '30010': 'TD', '30044': 'CX', '30058': 'PF', '30091': 'YSP', '30111': 'YN', '30229': 'XJ', '30427': 'SC', '30465': 'SX', '30631': 'YQ', '30655': 'QJ', '30684': 'QJG', '30707': 'SD', '30729': 'XH', '30796': 'LG', '30917': 'PB', '31074': 'NM', '31085': 'JZ', '31109': 'SC', '31181': 'ZC', '31192': 'MLB', '31293': 'JQ', '31400': 'YX', '31584': 'YJ', '31896': 'ZN', '31909': 'ZY', '31995': 'XJ', '32321': 'PF', '32327': 'ZY', '32418': 'HG', '32420': 'XQ', '32421': 'HG', '32438': 'LG', '32473': 'GJ', '32488': 'TD', '32521': 'QJ', '32527': 'PB', '32562': 'ZSQ', '32564': 'JZ', '32735': 'ZD', '32793': 'PB', '33071': 'PF', '33098': 'XL', '33100': 'YA', '33152': 'PB', '33261': 'CX', '33324': 'BP', '33333': 'TD', '33406': 'YA', '33426': 'WM', '33432': 'PB', '33445': 'JG', '33486': 'ZN', '33493': 'TS', '33507': 'QJ', '33540': 'QJ', '33544': 'ZC', '33564': 'XQ', '33617': 'YT', '33632': 'QJ', '33636': 'XH', '33637': 'YX', '33694': 'WG', '33705': 'PF', '33728': 'YW', '33882': 'SR', '34067': 'WM', '34074': 'YW', '34121': 'QJ', '34255': 'ZC', '34259': 'XL', '34425': 'JH', '34430': 'XH', '34485': 'KH', '34503': 'YS', '34532': 'HG', '34552': 'XS', '34558': 'YE', '34593': 'ZL', '34660': 'YQ', '34892': 'XH', '34928': 'SC', '34999': 'QJ', '35048': 'PB', '35059': 'SC', '35098': 'ZC', '35203': 'TQ', '35265': 'JX', '35299': 'JX', '35782': 'SZ', '35828': 'YS', '35830': 'E', '35843': 'TD', '35895': 'YG', '35977': 'MH', '36158': 'JG', '36228': 'QJ', '36426': 'XQ', '36466': 'DC', '36710': 'JC', '36711': 'ZYG', '36767': 'PB', '36866': 'SK', '36951': 'YW', '37034': 'YX', '37063': 'XH', '37218': 'ZC', '37325': 'ZC', '38063': 'PB', '38079': 'TD', '38085': 'QY', '38107': 'DC', '38116': 'TD', '38123': 'YD', '38224': 'HG', '38241': 'XTC', '38271': 'ZC', '38415': 'YE', '38426': 'KH', '38461': 'YD', '38463': 'AE', '38466': 'PB', '38477': 'XJ', '38518': 'YT', '38551': 'WK', '38585': 'ZC', '38704': 'XS', '38739': 'LJ', '38761': 'GJ', '38808': 'SQ', '39048': 'JG', '39049': 'XJ', '39052': 'HG', '39076': 'CZ', '39271': 'XT', '39534': 'TD', '39552': 'TD', '39584': 'PB', '39647': 'SB', '39730': 'LG', '39748': 'TPB', '40109': 'ZQ', '40479': 'ND', '40516': 'HG', '40536': 'HG', '40583': 'QJ', '40765': 'YQ', '40784': 'QJ', '40840': 'YK', '40863': 'QJG' };
//参数,中文字符串
//返回值:拼音首字母串数组
function makePy(str) {
 if (typeof(str) != 'string')
   throw new Error(-1, '函数makePy需要字符串类型参数!');
 var arrResult = new Array(); //保存中间结果的数组
 for (var i = 0, len = str.length; i < len; i++) {
   //获得unicode码
   var ch = str.charAt(i);
   //检查该unicode码是否在处理范围之内,在则返回该码对映汉字的拼音首字母,不在则调用其它函数处理
   arrResult.push(checkCh(ch));
 }
 //处理arrResult,返回所有可能的拼音首字母串数组
 return mkRslt(arrResult);
}

function checkCh(ch) {
 var uni = ch.charCodeAt(0);
 //如果不在汉字处理范围之内,返回原字符,也可以调用自己的处理函数
 if (uni > 40869 || uni < 19968)
   return ch; //dealWithOthers(ch);
 //检查是否是多音字,是按多音字处理,不是就直接在strChineseFirstPY字符串中找对应的首字母
 return (oMultiDiff[uni] ? oMultiDiff[uni] : (strChineseFirstPY.charAt(uni - 19968)));
}

function mkRslt(arr) {
 var arrRslt = [''];
 for (var i = 0, len = arr.length; i < len; i++) {
   var str = arr[i];
   var strlen = str.length;
   if (strlen == 1) {
     for (var k = 0; k < arrRslt.length; k++) {
       arrRslt[k] += str;
     }
   } else {
     var tmpArr = arrRslt.slice(0);
     arrRslt = [];
     for (k = 0; k < strlen; k++) {
       //复制一个相同的arrRslt
       var tmp = tmpArr.slice(0);
       //把当前字符str[k]添加到每个元素末尾
       for (var j = 0; j < tmp.length; j++) {
         tmp[j] += str.charAt(k);
       }
       //把复制并修改后的数组连接到arrRslt上
       arrRslt = arrRslt.concat(tmp);
     }
   }
 }
 return arrRslt;
}
//两端去空格函数
String.prototype.trim = function() { return this.replace(/(^\s*)|(\s*$)/g, ''); }
 //
function getPosition(obj) {
 var top = 0;
 var left = 0;
 var width = obj.offsetWidth;
 var height = obj.offsetHeight;
 while (obj.offsetParent) {
   top += obj.offsetTop;
   left += obj.offsetLeft;
   obj = obj.offsetParent;
 }
 return { 'top': top, 'left': left, 'width': width, 'height': height };
}
