'use strict';

/* Controllers */

angular.module('app')
  .controller('AppCtrl', ['$rootScope' ,'driver','$log' ,'$timeout','$state','$scope', '$translate', '$localStorage', '$window', 'cooConfig','rest',
   'g', '$location',
    function(   $rootScope, driver , $log ,$timeout ,  $state,       $scope,   $translate,   $localStorage,   $window ,cooConfig,rest ,g,$location) {
      // add 'ie' classes to html
      var isIE = !!navigator.userAgent.match(/MSIE/i);
      if(isIE){ angular.element($window.document.body).addClass('ie');}
      if(isSmartDevice( $window ) ){ angular.element($window.document.body).addClass('smart')};

      var header_template="tpl/blocks/header.html?"+ cooConfig.configObj.version;
      var aside_template = "design/tpl/blocks/nav.html";

      var appVersion = cooConfig.configObj.edition;
      var appThemeID = cooConfig.configObj.themeID;
      var appAsideColor = cooConfig.configObj.asideColor;
      if(appVersion && appVersion.length){
        aside_template = "design/tpl/blocks/nav.v2.html";
      }

      if (cooConfig.configObj.design.header==true)
      {
        header_template="design/"+cooConfig.configObj.companyId+"/tmpl/header.html?"+ cooConfig.configObj.version;
      }

    var app_name = cooConfig.configObj.name;
      if (!$rootScope.appid)
      {
        $rootScope.appid = cooConfig.configObj.name;
        $rootScope.sub_appid = cooConfig.app.short_name;
      }

      $scope.frameList =[
        { name:'我的桌面', active:true , url:'index.html#/pagexlist/1/list/3', sref:'app.pagex.list()',params: {categoryId:46,pageId:428} },
        { name:'使用说明', url:'', sref:'app.pagex.list()',params: {categoryId:46,pageId:428} }
    ];








      // config
      $scope.app = {
        name:    app_name ,
        sub_name: cooConfig.app.sub_name,
        register: cooConfig.app.register,
        short_name: cooConfig.configObj.short_name,
        companyId: cooConfig.configObj.companyId,
        version: '2.2.0',
        // for chart colors
        color: {
          primary: '#7266ba',
          info:    '#23b7e5',
          success: '#27c24c',
          warning: '#fad733',
          danger:  '#f05050',
          light:   '#e8eff0',
          dark:    '#3a3f51',
          black:   '#1c2b36'
        },
        settings: {
          themeID: appThemeID,
          navbarHeaderColor: 'bg-info dker',
          navbarCollapseColor: 'bg-info dk',
          asideColor: appAsideColor, //'bg-light dker b-r',
          headerFixed: true,
          asideFixed: true,
          asideFolded: false,
          asideDock: false,
          container: false,
          header_template: header_template,
          aside_template:aside_template,
          demo: cooConfig.configObj.demo,
          inFrame:false
        }
      }

      var aside = g.getURLParameter(window.location.href,'aside');
      aside = aside?true:false;


      $scope.app.settings.showHeader  = true;
      $scope.app.settings.headerFixed = true;


      $timeout(function(){

         $scope.app.settings.asideDock = aside;
         //   $('.aside-dock').trigger('click');
      },600)


      $scope.ng = function(lang,flag){
          lang.isopen = flag;
      }

      $scope.ng2 = function(lang2,flag){
           if (!lang2) lang2 ={};

          lang2.isopen = flag;
      }








      console.log(cooConfig.configObj);

      var whiteRouterFlag = false;

      $(cooConfig.whiteRoutes).each(function(p,q){
          var rq = new RegExp(q,'ig');
          if (rq.test($location.path())){
             whiteRouterFlag = true;
          }
      });

      $scope.init_header = function(){

            var mm = g.fetch2(cooConfig.MENUTABLENAME);
            $scope.vouchers = _.filter(mm,function(n){ return n.property.indexOf('group":"voucher')>0 });

            $($scope.vouchers).each(function(i,m){
               m.prop ={};
               if (m.property) { m.prop = JSON.parse(m.property)};
            });

           console.log($scope.vouchers);

           $scope.$$phase || $scope.$apply();

      }

      $scope.init_header();


      $scope.loadMenu = function(){

          $scope.toggleFrame =!$scope.toggleFrame;

      }

      $scope.navMenu = function(m){

         $('.yonyou-menu-'+m.ID).attr('href','http://center.mvcx.net:8082/tplus/view/portal/portal.html?t=1616379100291&&menu=GL4020');

         $('.yonyou-menu-'+m.ID).trigger('click');

         console.log('xxxx');

      }









      if (!cooConfig.configObj.isLogin && !whiteRouterFlag)
      {
        $.when(rest.user()).done(function(data){

          console.log(data);


          cooConfig.user = data;
          cooConfig.configObj.key = data.key;
          cooConfig.configObj.uploadKey = data.uploadKey;
          cooConfig.configObj.isAdmin = data.isAdmin;
          cooConfig.configObj.isAdmin2 =  data.isAdmin2;
          cooConfig.configObj.isLogin = true;
          cooConfig.configObj.xingMing = data.XingMing;
          cooConfig.configObj.RoleIds = data.RoleIds;

          cooConfig.menu=[];
          $rootScope.isAdmin = data.isAdmin;
          $rootScope.isAdmin2 = data.isAdmin2;
          //console.log(data.isAdmin);
          //console.log(data.XingMing.indexOf('匿名') );


         //&& location.href.indexOf('dashboard-v3')<0
          if (data.XingMing && data.XingMing.indexOf('匿名')>=0 &&  location.href.indexOf('workflow')<0  )
          {
            console.log(location.href);
             $state.go('access.signin',{version: '000000'}); //Math.random()
          }
          else {

            $.when(g.global_cache_update(data.cachetime,data)).done(function(){

                   g.menu2();
                   $rootScope.menu = cooConfig.menu;
                   $rootScope.allmenu = cooConfig.allmenu;
                   $rootScope.account_name =cooConfig.configObj.xingMing;



              });

          }



        });
      }






      // save settings to local storage
      // if ( angular.isDefined($localStorage.settings) ) {
      //   $scope.app.settings = $localStorage.settings;
      //   $scope.app.settings.header_template=  header_template ;
      //   $scope.app.settings.aside_template = aside_template;
      //   $scope.app.settings.showNav = true;
      //
      //
      //   var inFrame =window.location !== window.parent.location;
      //
      //
      //
      //   $scope.app.settings.showHeader = cooConfig.configObj.design.showHeader > 0 && inFrame ?false :true;
      //   $scope.app.settings.headerFixed = cooConfig.configObj.design.showHeader > 0 && inFrame ?false :true;
      //
      //     $scope.app.settings.showHeader  = true;
      //       $scope.app.settings.headerFixed = true;
      //
      // } else {
      //   $localStorage.settings = $scope.app.settings;
      // }
      // $scope.$watch('app.settings', function(){
      //   if( $scope.app.settings.asideDock  &&  $scope.app.settings.asideFixed ){
      //     // aside dock and fixed must set the header fixed.
      //     $scope.app.settings.headerFixed = true;
      //   }
      //   // for box layout, add background image
      //   $scope.app.settings.container ? angular.element('html').addClass('bg') : angular.element('html').removeClass('bg');
      //   // save to local storage
      //
      //   console.log($scope.app.settings);
      //
      //   $localStorage.settings = $scope.app.settings;
      // }, true);

      // angular translate
      $scope.lang = { isopen: false };
      $rootScope.configObj = cooConfig.configObj;
      $rootScope.version  =  cooConfig.configObj.version;
      $scope.langs = {cn:'中文'}; //en:'English', de_DE:'German', it_IT:'Italian',
      $scope.selectLang = $scope.langs[$translate.proposedLanguage()] || "中文";

      $scope.setLang = function(langKey, $event) {
        // set the current lang
        $scope.selectLang = $scope.langs[langKey];
        // You can change the language during runtime
        $translate.use(langKey);
        $scope.lang.isopen = !$scope.lang.isopen;
      };

      //  localStorage.clear();
      //console.log('clearLocal');

     $scope.switchContainer = function(){

        if ($scope.app.settings.showHeader){
          $scope.app.settings.showHeader = false;
        //  $scope.app.settings.showNav = false;
      //    $scope.app.settings.asideDock = true;
          $scope.app.settings.headerFixed =false;

        } else{
          $scope.app.settings.showHeader = true;
      //    $scope.app.settings.showNav = true;
      //    $scope.app.settings.asideDock = false;
          $scope.app.settings.headerFixed =true;
        }

         console.log($scope.app.settings);

          $scope.$$phase || $scope.$apply();




     }


     $scope.fixBody = function(){

          $scope.bodyFix = !$scope.bodyFix;
          if ($scope.bodyFix){
             $('body').css('overflow-y','hidden');
          }else{
            $('body').css('overflow-y','auto');
          }
     }


      $rootScope.$on("$locationChangeStart", function (event, next, current) {

      });
      $rootScope.$on("$routeChangeStart", function (event, next, current) {

      });
      $rootScope.$on("$locationChangeSuccess", function (event, next, current) {


        $timeout(function(){

          var name = event.targetScope.$state.current.name;
          var tfName = name.replace(/\./ig,'_');
          var urlWrap = window.location.href;
          urlWrap = urlWrap.replace(/^.+#\//ig,'').replace(/\//ig,'_');
          var driverObj =[];
          if (driver[tfName] && driver[tfName].length>0){
             driverObj = driver[tfName];
          }
          if (driver[urlWrap]&& driver[urlWrap].length>0){
             driverObj =driver[urlWrap] ;
          }

          if (driverObj.length>0){

            var dver = new Driver({
              doneBtnText: '完成',              // Text on the final button
              closeBtnText: '关闭',            // Text on the close button for this step
          //    stageBackground: '#ffffff',       // Background color for the staged behind highlighted element
              nextBtnText: '下一步',              // Next button text for this step
              prevBtnText: '上一步',          // Previous button text for this step
              showButtons: true,               // Do not show control buttons in footer
              keyboardControl: true,

            });
            // Define the steps for introduction
            dver.defineSteps(
                driverObj
            );

            if ($scope.app.settings.demo){
                 dver.start();
            }

          }











             console.log(tfName);
             console.log(urlWrap);
             console.log(driver);






        },1200);








      });
      $rootScope.$on("$routeChangeSuccess", function (event, next, current) {

      });


      $scope.clear_local_storage = function(){

           localStorage.clear();
           $state.go('access.signin');

      }

      $scope.sign_out = function(){



           amplify.store(cooConfig.configObj.companyId.toString()  + ".cacheVersion","0000");
           $.when(rest.logOff()).done(function(){



                 $.when(rest.user()).done(function(data){
                     console.log(data);

                 });

                 $state.go('access.signin',{version:Math.random()});


           });


      }


      $scope.write_modal=function(pageId,categoryId,itemId,cols)
      {
         g.write_modal($scope,pageId,categoryId,itemId,cols );
      }



      $scope.import = function(){

          var scp =angular.element('#pagex').scope();
          if (!scp) scp = angular.element('#pagey_edit').scope();
          if (!scp) scp =  angular.element('#page-wrapper').scope();

          g.import_modal(scp);
      }


      $scope.logOff = function(){

         $.when(rest.logOff()).done(function(ret){

             $state.go('access.signin');
         });

      }


      $scope.refresh=function()
      {

        window.location.reload();
       //  $state.reload();
        // window.location.href=   window.location.href +"?sfs"  ;
      }


     $scope.supplier =[];
    //  $.when(rest.search(3,8,[],0,5)).done(function(ret){
     //
    //         $scope.supplier = ret.data;
    //         $scope.$$phase || $scope.$apply();
     //
    //  });
     //
    //  $.when(g.remote_check('pattern')).done(function(f){
    //     console.log(f);
    //  });



      function isSmartDevice( $window )
      {
          // Adapted from http://www.detectmobilebrowsers.com
          var ua = $window['navigator']['userAgent'] || $window['navigator']['vendor'] || $window['opera'];
          // Checks for iOs, Android, Blackberry, Opera Mini, and Windows mobile devices
          return (/iPhone|iPod|iPad|Silk|Android|BlackBerry|Opera Mini|IEMobile/).test(ua);
      }

  }]);
