angular.module('app')
.factory('g_configs',[ 'cooConfig','rest','$sce','$state','$stateParams','$upload','$modal' ,'$timeout','JQ_CONFIG','MODULE_CONFIG' , function (cooConfig,rest,$sce,$state,$stateParams,$upload,$modal ,$timeout,JQ_CONFIG,MODULE_CONFIG) {

  var g_configs ={};


  function load(srcs, callback,ref_obj) {
    var ret = {
        deps: ['$ocLazyLoad', '$q',
          function( $ocLazyLoad, $q ){
            var deferred = $q.defer();
            var promise  = false;
            srcs = angular.isArray(srcs) ? srcs : srcs.split(/\s+/);
            if(!promise){
              promise = deferred.promise;
            }
            angular.forEach(srcs, function(src) {
              promise = promise.then( function(){
                if(JQ_CONFIG[src]){
                  return $ocLazyLoad.load(JQ_CONFIG[src]);
                }
                angular.forEach(MODULE_CONFIG, function(module) {
                  if( module.name == src){
                    name = module.name;
                  }else{
                    name = src;
                  }
                });
                return $ocLazyLoad.load(name);
              } );
            });
            deferred.resolve();
            return callback ? promise.then(function(){ return callback(); }) : promise;
        }]
    }

    if (ref_obj)
    {
      var keys = _.keys(ref_obj);
      $(keys).each(function(i,j){
            ret[j] = ref_obj[j];
      });
    }

    return ret;
  }

   g_configs.write_config_modal = function($scope,cols,row,p ,callback){


       var modalInstance = $modal.open({
         templateUrl: 'write_config_modal.html',
         controller: 'write_config_modal_instance_ctrl',
         size:  p.modalSize,
         resolve:
               load(['textAngular', 'summernote'],
               function(){},
               {
                 cols:function(){ return cols},
                 row: function(){return row },
                 p: function()  { return p }
               }
              )

       });

       modalInstance.result.then(function (message) {
           console.log(message);
           if (callback)   callback(message);
           if (message=='modal_return'  )
           {
               if ($scope.renderList)
               {
                $scope.renderList();
              }


            //  g.modal1('添加成功');
           }
          //
       }, function () {
        //$log.info('Modal dismissed at: ' + new Date());
       });


   }


  g_configs.init_config = function($scope){
        $scope.configActionbarTemplate =  'components/tpl/config.actionbar.html?'+cooConfig.configObj.version;
        $scope.leftTreeTemplate =  'components/tpl/left_tree.html?'+cooConfig.configObj.version;
        $scope.leftTreeView =true;
        $scope.hideTreeView = function(){
          $scope.leftTreeView=!$scope.leftTreeView
        }

        $scope.rawData =[];
        $scope.startIndex =1;
        $scope.pageSize = 10;
        $scope.pages = [{ ID: 1, Title: '1' },{ ID: 6, Title: '6' }, { ID: 10, Title: '10' }, { ID: 12, Title: '12' }, { ID: 15, Title: '15' }, { ID: 18, Title: '18' }, { ID: 20, Title: '20' }, { ID: 30, Title: '30' }, { ID: 100, Title: '100' }];
        $scope.lsc = [];



         $scope.selectPage  =function(p)
         {
               if (($scope.startIndex+p)>0 &&  ($scope.startIndex+p)< $scope.maxPages)
               {
                 $scope.startIndex = $scope.startIndex+p;
                  $scope.renderList();
               }
         }

         $scope.select_clear =function(){
           $scope.lsc =[];
             $scope.startIndex =1;
            $scope.text_valuex ='';
            $scope.renderList();
         }

         $scope.pageSizeChange = function (p) {
             $scope.pageSize = p;
             $scope.startIndex = 1;
             $scope.renderList();
         };

         $scope.text_change = function(text_labelx,text_valuex){

              $scope.lsc =[];
              $scope.startIndex =1;
             if (text_valuex){
                $scope.lsc.push({"patternId":text_labelx,"val1":text_valuex,"pTypeId":5,"operation":6});
             }
             if ($scope.scene){
                $scope.lsc.push({"patternId": 469,"val1":$scope.scene,"pTypeId":2,"operation":1});
             }

             $scope.renderList();

         }



         $scope.search=function(){
             $scope.lsc =[];
             $scope.startIndex =1;
             if ($scope.keyword){
               $scope.lsc.push({"patternId":$scope.keywordId,"val1":$scope.keyword,"pTypeId":5,"operation":6})
             }
             $($scope.s_pats2).each(function(i,j){
                 if ((j.pTypeId==5 || j.pTypeId ==7 ) && j.v ){
                     $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":5,"operation":6})
                 }
                 if ((j.pTypeId==2 || j.pTypeId ==3 ) && j.v && j.v !=="0" ){
                     $scope.lsc.push({"patternId":j.ID,"val1":j.v,"pTypeId":j.pTypeId,"operation":1})
                 }
             });
             $scope.renderList();
         }

       //  $scope.renderList();





         $scope.checkName = function(col, data) {
           if ( col=='c380' && !data  ) {
             return "配置名称必填";
           }
           if ( col=='c381' && !data  ) {
             return "配置编号必填";
           }
           if ( col=='c382' && !data  ) {
             return "配置内容必填";
           }
           if ( col=='c439' && !data  ) {
             return "配置类型必填";
           }
           if ( col=='c469' && !data  ) {
             return "配置场景必填";
           }
         };



  }


   //column_sort
   g_configs.enumConfig = function($scope,pageId ){


              var modalInstance = $modal.open({
                templateUrl: 'tpl/admin/enum.v2.html',
                controller: 'enum_config_instance_ctrl',
                size: 'lg',
                resolve:
                      load(['textAngular', 'summernote','ngJsTree'],
                      function(){},
                       {
                           pageId: function(){ return pageId},
                       }
                     )

              });

              modalInstance.result.then(function (message) {
                  console.log(message);
                  if (message=='modal_return'  )
                  {
                      if ($scope.renderList)
                      {
                       $scope.renderList();
                     }
                     callback();
                     g.modal1('添加成功');
                  }
                 //
              }, function () {
               //$log.info('Modal dismissed at: ' + new Date());
              });

   }




   return g_configs;



}]);
