﻿using UnityEngine;
using Verse;
using RimWorld;

namespace Markers
{
    class Designator_MarkCapture : Designator_Marker
    {

        // Constructor
        public Designator_MarkCapture()
        {
            this.defaultLabel = "DesignatorMarkCapture".Translate();
            this.defaultDesc = "DesignatorMarkCaptureDesc".Translate();
            this.icon = ContentFinder<Texture2D>.Get("UI/Designators/Markers/Capture", true);
            this.useMouseIcon = true;
            this.soundDragSustain = SoundDefOf.DesignateDragStandard;
            this.soundDragChanged = SoundDefOf.DesignateDragStandardChanged;
            this.soundSucceeded = SoundDefOf.DesignateHunt;
        }

        protected override Designation getCurrentDesignation(Thing t)
        {
            return new Designation(t, DesignationDefOfLocal.MarkCapture);
        }

        protected override bool CellHasNoMarkerDesignation(IntVec3 c)
        {
            return null == base.Map.designationManager.DesignationAt(c, DesignationDefOfLocal.MarkCapture);
        }
    }
    
}