﻿using UnityEngine;
using Verse;
using RimWorld;

namespace Markers
{
    class Designator_MarkDangerous : Designator_Marker
    {

        // Constructor
        public Designator_MarkDangerous()
        {
            this.defaultLabel = "DesignatorMarkDangerous".Translate();
            this.defaultDesc = "DesignatorMarkDangerousDesc".Translate();
            this.icon = ContentFinder<Texture2D>.Get("UI/Designators/Markers/Dangerous", true);
            this.useMouseIcon = true;
            this.soundDragSustain = SoundDefOf.DesignateDragStandard;
            this.soundDragChanged = SoundDefOf.DesignateDragStandardChanged;
            this.soundSucceeded = SoundDefOf.DesignateHunt;
        }

        protected override Designation getCurrentDesignation(Thing t)
        {
            return new Designation(t, DesignationDefOfLocal.MarkDangerous);
        }

        protected override bool CellHasNoMarkerDesignation(IntVec3 c)
        {
            return null == base.Map.designationManager.DesignationAt(c, DesignationDefOfLocal.MarkDangerous);
        }
    }
    
}