﻿using UnityEngine;
using Verse;
using RimWorld;

namespace Markers
{
    class Designator_MarkSapper : Designator_Marker
    {

        // Constructor
        public Designator_MarkSapper()
        {
            this.defaultLabel = "DesignatorMarkSapper".Translate();
            this.defaultDesc = "DesignatorMarkSapperDesc".Translate();
            this.icon = ContentFinder<Texture2D>.Get("UI/Designators/Markers/Sapper", true);
            this.useMouseIcon = true;
            this.soundDragSustain = SoundDefOf.DesignateDragStandard;
            this.soundDragChanged = SoundDefOf.DesignateDragStandardChanged;
            this.soundSucceeded = SoundDefOf.DesignateHunt;
        }

        protected override Designation getCurrentDesignation(Thing t)
        {
            return new Designation(t, DesignationDefOfLocal.MarkSapper);
        }

        protected override bool CellHasNoMarkerDesignation(IntVec3 c)
        {
            return null == base.Map.designationManager.DesignationAt(c, DesignationDefOfLocal.MarkSapper);
        }
    }
    
}