﻿using UnityEngine;
using Verse;
using RimWorld;

namespace Markers
{
    class Designator_MarkShinyWeapon : Designator_Marker
    {

        // Constructor
        public Designator_MarkShinyWeapon()
        {
            this.defaultLabel = "DesignatorMarkShinyWeapon".Translate();
            this.defaultDesc = "DesignatorMarkShinyWeaponDesc".Translate();
            this.icon = ContentFinder<Texture2D>.Get("UI/Designators/Markers/ShinyWeapon", true);
            this.useMouseIcon = true;
            this.soundDragSustain = SoundDefOf.DesignateDragStandard;
            this.soundDragChanged = SoundDefOf.DesignateDragStandardChanged;
            this.soundSucceeded = SoundDefOf.DesignateHunt;
        }

        protected override Designation getCurrentDesignation(Thing t)
        {
            return new Designation(t, DesignationDefOfLocal.MarkShinyWeapon);
        }

        protected override bool CellHasNoMarkerDesignation(IntVec3 c)
        {
            return null == base.Map.designationManager.DesignationAt(c, DesignationDefOfLocal.MarkShinyWeapon);
        }
    }
    
}