/*
 * Decompiled with CFR 0.152.
 */
package icbm.common.jiqi;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import icbm.common.ZhuYao;
import icbm.common.daodan.DaoDanGuanLi;
import icbm.common.daodan.EDaoDan;
import icbm.common.jiqi.LeiDaGuanLi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.vector.Vector2;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.implement.IRedstoneProvider;
import universalelectricity.prefab.multiblock.IMultiBlock;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.tile.TileEntityElectricityReceiver;

public class TLeiDaTai
extends TileEntityElectricityReceiver
implements IPacketReceiver,
IRedstoneProvider,
IMultiBlock,
IPeripheral {
    public static final int YAO_DIAN = 15;
    public static final int MAX_BIAN_JING = 500;
    public double dian;
    public double prevDian = 0.0;
    public float xuanZhuan = 0.0f;
    public int alarmBanJing = 100;
    public int safetyBanJing = 20;
    public List detectedMissiles = new ArrayList();
    public List detectedRadarStations = new ArrayList();
    private boolean missileAlert = false;
    private int yongZhe = 0;
    private ForgeChunkManager.Ticket ticket;

    public TLeiDaTai() {
        LeiDaGuanLi.addRadarStation(this);
    }

    @Override
    public void initiate() {
        if (this.k != null) {
            this.k.h(this.l, this.m, this.n, this.q().cm);
        }
        if (this.ticket == null) {
            this.ticket = ForgeChunkManager.requestTicket((Object)ZhuYao.instance, (yc)this.k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            this.ticket.getModData();
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (xv)new xv(this.l >> 4, this.n >> 4));
    }

    @Override
    public void g() {
        super.g();
        try {
            this.prevDian = this.dian;
            if (!this.k.I) {
                for (int i = 0; i < 6; ++i) {
                    Vector3 diDian = new Vector3(this);
                    diDian.modifyPositionFromSide(ForgeDirection.getOrientation((int)i));
                    any tileEntity = diDian.getTileEntity((ym)this.k);
                    ElectricityNetwork network = ElectricityNetwork.getNetworkFromTileEntity(tileEntity, ForgeDirection.getOrientation((int)i));
                    if (network == null) continue;
                    if (!this.isDisabled()) {
                        network.startRequesting(this, (double)(15 * 2) / this.getVoltage(), this.getVoltage());
                        this.dian = Math.ceil(this.dian + network.consumeElectricity(this).getWatts());
                        continue;
                    }
                    network.stopRequesting(this);
                }
                if (this.ticks % 40L == 0L) {
                    PacketManager.sendPacketToClients(this.l(), this.k, new Vector3(this), 35.0);
                } else if (this.ticks % 3L == 0L && this.yongZhe > 0) {
                    PacketManager.sendPacketToClients(this.getDescriptionPacket2(), this.k, new Vector3(this), 12.0);
                }
            }
            if (!this.isDisabled()) {
                if (this.dian >= 15.0) {
                    this.xuanZhuan += 0.05f;
                    if (this.xuanZhuan > 360.0f) {
                        this.xuanZhuan = 0.0f;
                    }
                    if (!this.k.I) {
                        this.dian -= 15.0;
                    }
                    boolean previousMissileDetection = this.detectedMissiles.size() > 0;
                    this.doScan();
                    if (previousMissileDetection != this.detectedMissiles.size() > 0) {
                        this.k.h(this.l, this.m, this.n, this.q().cm);
                    }
                } else {
                    if (this.detectedMissiles.size() > 0) {
                        this.k.h(this.l, this.m, this.n, this.q().cm);
                    }
                    this.detectedMissiles.clear();
                    this.detectedRadarStations.clear();
                    this.dian = 0.0;
                }
            }
            if (this.ticks % 40L == 0L) {
                this.k.h(this.l, this.m, this.n, this.q().cm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean doScan() {
        this.missileAlert = false;
        this.detectedMissiles.clear();
        this.detectedRadarStations.clear();
        List missilesNearby = DaoDanGuanLi.getMissileInArea(new Vector3(this).toVector2(), this.alarmBanJing);
        for (EDaoDan missile : missilesNearby) {
            if (missile.feiXingTick <= -1) continue;
            if (!this.detectedMissiles.contains(missile)) {
                this.detectedMissiles.add(missile);
            }
            Vector2 vector2 = new Vector2(this.l, this.n);
            if (!(Vector2.distance(missile.muBiao.toVector2(), vector2) < (double)this.safetyBanJing)) continue;
            this.missileAlert = true;
        }
        for (TLeiDaTai radarStation : LeiDaGuanLi.getRadarStationsInArea(new Vector2(this.l - 500, this.n - 500), new Vector2(this.l + 500, this.n + 500))) {
            if (radarStation.isDisabled() || !(radarStation.prevDian > 0.0)) continue;
            this.detectedRadarStations.add(radarStation);
        }
        return this.missileAlert;
    }

    private ef getDescriptionPacket2() {
        return PacketManager.getPacket("ICBM", this, new Object[]{1, this.alarmBanJing, this.safetyBanJing});
    }

    public ef l() {
        double sendDian = this.dian;
        if (sendDian > 0.0) {
            sendDian = 15.0;
        }
        return PacketManager.getPacket("ICBM", this, new Object[]{4, sendDian, this.disabledTicks});
    }

    @Override
    public void handlePacketData(ce network, int packetType, di packet, qx player, ByteArrayDataInput dataStream) {
        try {
            int ID = dataStream.readInt();
            if (ID == -1) {
                if (dataStream.readBoolean()) {
                    PacketManager.sendPacketToClients(this.getDescriptionPacket2(), this.k, new Vector3(this), 15.0);
                    ++this.yongZhe;
                } else {
                    --this.yongZhe;
                }
            } else if (this.k.I) {
                if (ID == 1) {
                    this.alarmBanJing = dataStream.readInt();
                    this.safetyBanJing = dataStream.readInt();
                } else if (ID == 4) {
                    this.dian = dataStream.readDouble();
                    this.disabledTicks = dataStream.readInt();
                }
            } else if (!this.k.I) {
                if (ID == 2) {
                    this.safetyBanJing = dataStream.readInt();
                } else if (ID == 3) {
                    this.alarmBanJing = dataStream.readInt();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public double getVoltage() {
        return 120.0;
    }

    @Override
    public boolean isPoweringTo(ForgeDirection side) {
        if (this.prevDian <= 0.0 && this.dian <= 0.0) {
            return false;
        }
        return this.doScan() && this.detectedMissiles.size() > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(ForgeDirection side) {
        return this.isPoweringTo(side);
    }

    public void a(bq par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.safetyBanJing = par1NBTTagCompound.e("safetyRadius");
        this.alarmBanJing = par1NBTTagCompound.e("alarmRadius");
    }

    public void b(bq par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("safetyRadius", this.safetyBanJing);
        par1NBTTagCompound.a("alarmRadius", this.alarmBanJing);
    }

    @Override
    public void onDestroy(any callingBlock) {
        this.k.e(this.l, this.m, this.n, 0);
        this.k.e(this.l, this.m + 1, this.n, 0);
        this.k.e(this.l + 1, this.m + 1, this.n, 0);
        this.k.e(this.l - 1, this.m + 1, this.n, 0);
        this.k.e(this.l, this.m + 1, this.n + 1, 0);
        this.k.e(this.l, this.m + 1, this.n - 1, 0);
        this.k.e(this.l + 1, this.m + 1, this.n + 1, 0);
        this.k.e(this.l - 1, this.m + 1, this.n - 1, 0);
        this.k.e(this.l + 1, this.m + 1, this.n - 1, 0);
        this.k.e(this.l - 1, this.m + 1, this.n + 1, 0);
    }

    @Override
    public boolean onActivated(qx entityPlayer) {
        entityPlayer.openGui((Object)ZhuYao.instance, 3, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public void onCreate(Vector3 position) {
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(0, 1, 0), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(1, 1, 0), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(-1, 1, 0), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(0, 1, 1), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(0, 1, -1), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(1, 1, -1), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(-1, 1, 1), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(1, 1, 1), position), new Vector3(this));
        ZhuYao.bJia.makeFakeBlock(this.k, Vector3.add(new Vector3(-1, 1, -1), position), new Vector3(this));
    }

    @Override
    public String getType() {
        return "ICBMRadar";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getMissiles", "getRadars"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        if (this.prevDian < 15.0) {
            throw new Exception("Radar has insufficient electricity!");
        }
        HashMap<String, Double> returnArray = new HashMap<String, Double>();
        switch (method) {
            case 0: {
                List daoDans = DaoDanGuanLi.getMissileInArea(new Vector3(this).toVector2(), this.alarmBanJing);
                for (EDaoDan daoDan : daoDans) {
                    returnArray.put("x", daoDan.t);
                    returnArray.put("y", daoDan.u);
                    returnArray.put("z", daoDan.v);
                }
                return new Object[]{returnArray};
            }
            case 1: {
                for (TLeiDaTai radarStation : LeiDaGuanLi.getRadarStationsInArea(new Vector2(this.l - 500, this.n - 500), new Vector2(this.l + 500, this.n + 500))) {
                    if (radarStation.isDisabled() || !(radarStation.prevDian > 0.0)) continue;
                    returnArray.put("x", Double.valueOf(radarStation.l));
                    returnArray.put("y", Double.valueOf(radarStation.m));
                    returnArray.put("z", Double.valueOf(radarStation.n));
                }
                return new Object[]{returnArray};
            }
        }
        throw new Exception("Invalid ICBM Radar Function.");
    }

    @Override
    public void w_() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        super.w_();
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer, String computerSide) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }
}

