/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.implement.IConductor;

public class ElectricityNetwork {
    private final HashMap producers = new HashMap();
    private final HashMap consumers = new HashMap();
    public final List conductors = new ArrayList();

    public ElectricityNetwork(IConductor conductor) {
        this.addConductor(conductor);
    }

    public void startProducing(any tileEntity, ElectricityPack electricityPack) {
        if (tileEntity != null && electricityPack.getWatts() > 0.0) {
            this.producers.put(tileEntity, electricityPack);
        }
    }

    public void startProducing(any tileEntity, double amperes, double voltage) {
        this.startProducing(tileEntity, new ElectricityPack(amperes, voltage));
    }

    public boolean isProducing(any tileEntity) {
        return this.producers.containsKey(tileEntity);
    }

    public void stopProducing(any tileEntity) {
        this.producers.remove(tileEntity);
    }

    public void startRequesting(any tileEntity, ElectricityPack electricityPack) {
        if (tileEntity != null && electricityPack.getWatts() > 0.0) {
            this.consumers.put(tileEntity, electricityPack);
        }
    }

    public void startRequesting(any tileEntity, double amperes, double voltage) {
        this.startRequesting(tileEntity, new ElectricityPack(amperes, voltage));
    }

    public boolean isRequesting(any tileEntity) {
        return this.consumers.containsKey(tileEntity);
    }

    public void stopRequesting(any tileEntity) {
        this.consumers.remove(tileEntity);
    }

    public ElectricityPack getProduced() {
        ElectricityPack totalElectricity = new ElectricityPack(0.0, 0.0);
        Iterator it = this.producers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            if (pairs == null) continue;
            any tileEntity = (any)pairs.getKey();
            if (tileEntity == null) {
                it.remove();
                continue;
            }
            if (tileEntity.r()) {
                it.remove();
                continue;
            }
            if (tileEntity.k.q(tileEntity.l, tileEntity.m, tileEntity.n) != tileEntity) {
                it.remove();
                continue;
            }
            ElectricityPack pack = (ElectricityPack)pairs.getValue();
            if (pairs.getKey() == null || pairs.getValue() == null || pack == null) continue;
            totalElectricity.amperes += pack.amperes;
            totalElectricity.voltage = Math.max(totalElectricity.voltage, pack.voltage);
        }
        return totalElectricity;
    }

    public ElectricityPack getRequest() {
        ElectricityPack totalElectricity = this.getRequestWithoutReduction();
        totalElectricity.amperes = Math.max(totalElectricity.amperes - this.getProduced().amperes, 0.0);
        return totalElectricity;
    }

    public ElectricityPack getRequestWithoutReduction() {
        ElectricityPack totalElectricity = new ElectricityPack(0.0, 0.0);
        Iterator it = this.consumers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            if (pairs == null) continue;
            any tileEntity = (any)pairs.getKey();
            if (tileEntity == null) {
                it.remove();
                continue;
            }
            if (tileEntity.r()) {
                it.remove();
                continue;
            }
            if (tileEntity.k.q(tileEntity.l, tileEntity.m, tileEntity.n) != tileEntity) {
                it.remove();
                continue;
            }
            ElectricityPack pack = (ElectricityPack)pairs.getValue();
            if (pack == null) continue;
            totalElectricity.amperes += pack.amperes;
            totalElectricity.voltage = Math.max(totalElectricity.voltage, pack.voltage);
        }
        return totalElectricity;
    }

    public ElectricityPack consumeElectricity(any tileEntity) {
        ElectricityPack totalElectricity = new ElectricityPack(0.0, 0.0);
        try {
            ElectricityPack tileRequest = (ElectricityPack)this.consumers.get(tileEntity);
            if (this.consumers.containsKey(tileEntity) && tileRequest != null && (totalElectricity = this.getProduced()).getWatts() > 0.0) {
                ElectricityPack totalRequest = this.getRequestWithoutReduction();
                totalElectricity.amperes *= tileRequest.amperes / totalRequest.amperes;
                int distance = this.conductors.size();
                double ampsReceived = totalElectricity.amperes - totalElectricity.amperes * totalElectricity.amperes * this.getResistance() * (double)distance / totalElectricity.voltage;
                double voltsReceived = totalElectricity.voltage - totalElectricity.amperes * this.getResistance() * (double)distance;
                totalElectricity.amperes = ampsReceived;
                totalElectricity.voltage = voltsReceived;
                return totalElectricity;
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to consume electricity!", (Object[])new Object[0]);
            e.printStackTrace();
        }
        return totalElectricity;
    }

    public HashMap getProducers() {
        return this.producers;
    }

    public HashMap getConsumers() {
        return this.consumers;
    }

    public void addConductor(IConductor newConductor) {
        this.cleanConductors();
        if (!this.conductors.contains(newConductor)) {
            this.conductors.add(newConductor);
            newConductor.setNetwork(this);
        }
    }

    public List getReceivers() {
        ArrayList<any> receivers = new ArrayList<any>();
        for (Map.Entry pairs : this.consumers.entrySet()) {
            if (pairs == null) continue;
            receivers.add((any)pairs.getKey());
        }
        return receivers;
    }

    public void cleanConductors() {
        for (int i = 0; i < this.conductors.size(); ++i) {
            if (this.conductors.get(i) == null) {
                this.conductors.remove(i);
                continue;
            }
            if (!((any)this.conductors.get(i)).r()) continue;
            this.conductors.remove(i);
        }
    }

    public void resetConductors() {
        for (int i = 0; i < this.conductors.size(); ++i) {
            ((IConductor)this.conductors.get(i)).reset();
        }
    }

    public void setNetwork() {
        this.cleanConductors();
        for (IConductor conductor : this.conductors) {
            conductor.setNetwork(this);
        }
    }

    public void onOverCharge() {
        this.cleanConductors();
        for (int i = 0; i < this.conductors.size(); ++i) {
            ((IConductor)this.conductors.get(i)).onOverCharge();
        }
    }

    public double getResistance() {
        double resistance = 0.0;
        for (int i = 0; i < this.conductors.size(); ++i) {
            resistance = Math.max(resistance, ((IConductor)this.conductors.get(i)).getResistance());
        }
        return resistance;
    }

    public double getLowestAmpTolerance() {
        double lowestAmp = 0.0;
        for (IConductor conductor : this.conductors) {
            if (lowestAmp != 0.0 && !(conductor.getMaxAmps() < lowestAmp)) continue;
            lowestAmp = conductor.getMaxAmps();
        }
        return lowestAmp;
    }

    public void refreshConductors() {
        for (int j = 0; j < this.conductors.size(); ++j) {
            IConductor conductor = (IConductor)this.conductors.get(j);
            conductor.refreshConnectedBlocks();
        }
    }

    public static ElectricityNetwork getNetworkFromTileEntity(any tileEntity, ForgeDirection approachDirection) {
        if (tileEntity != null && tileEntity instanceof IConductor && ElectricityConnections.isConnector(tileEntity) && ElectricityConnections.canConnect(tileEntity, approachDirection.getOpposite())) {
            return ((IConductor)tileEntity).getNetwork();
        }
        return null;
    }
}

