/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.entity.ai.EntityAIStun;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StunManager {
    static final String FreezeTimeout = "FreezeTimeout";
    static final long freezeLimit = 200L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityLiving entity = (EntityLiving)event.getEntity();
        entity.field_70714_bg.func_75776_a(-1, (EntityAIBase)new EntityAIStun((EntityLivingBase)entity));
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (target == null) {
            return;
        }
        if (target.field_70170_p == null) {
            return;
        }
        long timeout = target.getEntityData().func_74763_f("StunTimeout");
        if (timeout == 0L) {
            return;
        }
        if ((timeout -= target.field_70170_p.func_82737_E()) <= 0L || 200L < timeout) {
            target.getEntityData().func_82580_o("StunTimeout");
            return;
        }
        if (target.field_70181_x < 0.0) {
            target.field_70181_x *= 0.5;
        }
    }

    public static void setStun(EntityLivingBase target, long duration) {
        if (target.field_70170_p == null) {
            return;
        }
        if (!(target instanceof EntityLiving)) {
            return;
        }
        if (duration <= 0L) {
            return;
        }
        duration = Math.min(duration, 200L);
        target.getEntityData().func_74772_a("StunTimeout", target.field_70170_p.func_82737_E() + duration);
    }

    @SubscribeEvent
    public void onEntityCanUpdate(EntityEvent.CanUpdate event) {
        if (event.isCanceled()) {
            return;
        }
        Entity target = event.getEntity();
        if (target == null) {
            return;
        }
        if (target.field_70170_p == null) {
            return;
        }
        long timeout = target.getEntityData().func_74763_f(FreezeTimeout);
        if (timeout == 0L) {
            return;
        }
        long timeLeft = timeout - target.field_70170_p.func_82737_E();
        if (timeLeft <= 0L || 200L < timeLeft) {
            target.getEntityData().func_82580_o(FreezeTimeout);
            return;
        }
        event.setCanUpdate(false);
    }

    public static void setFreeze(EntityLivingBase target, long duration) {
        if (target.field_70170_p == null) {
            return;
        }
        if (!(target instanceof EntityLiving)) {
            return;
        }
        if (duration <= 0L) {
            return;
        }
        duration = Math.min(duration, 200L);
        target.getEntityData().func_74772_a(FreezeTimeout, target.field_70170_p.func_82737_E() + duration);
    }
}

