/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import javax.vecmath.Matrix4f;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.model.obj.Face;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class BladeModel
implements IPerspectiveAwareModel {
    List<BakedQuad> emptyList = null;
    ItemStack proudsoul = null;
    ItemModelMesher modelMesher = null;
    ItemStack targetStack = null;
    ItemSlashBlade itemBlade = null;
    int renderPath = 0;
    int drawStep = -1;
    ItemCameraTransforms.TransformType type = ItemCameraTransforms.TransformType.NONE;

    List<BakedQuad> getEmptyList() {
        if (this.emptyList == null) {
            this.emptyList = Lists.newArrayList((Object[])new BakedQuad[]{new BakedQuad(new int[28], 0, EnumFacing.UP, this.func_177554_e(), false, DefaultVertexFormats.field_176599_b)});
        }
        return this.emptyList;
    }

    List<BakedQuad> getDefaultQuards() {
        if (this.modelMesher == null) {
            this.modelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            this.proudsoul = SlashBlade.findItemStack("flammpfeil.slashblade", "proudsoul", 1);
        }
        return this.modelMesher.func_178089_a(this.proudsoul).func_188616_a(null, null, 0L);
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)ImmutableList.of()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                if (stack != null && stack.func_77973_b() instanceof ItemSlashBlade) {
                    BladeModel.this.targetStack = stack;
                    BladeModel.this.itemBlade = (ItemSlashBlade)stack.func_77973_b();
                } else {
                    BladeModel.this.targetStack = null;
                    BladeModel.this.itemBlade = null;
                }
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return this.getEmptyList();
        }
        if (this.drawStep == 0) {
            return this.getDefaultQuards();
        }
        if (this.type == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || this.type == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || this.type == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || this.type == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            return this.getEmptyList();
        }
        try {
            Tessellator.func_178181_a().func_78381_a();
        }
        catch (Exception e) {
            return this.getDefaultQuards();
        }
        GL11.glPushAttrib((int)1048575);
        if (this.renderPath++ >= 1) {
            Face.setColor(-8372020);
            GL11.glMatrixMode((int)5890);
            GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
            GL11.glMatrixMode((int)5888);
        } else {
            Face.resetColor();
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)518, (float)0.05f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        float scale = 0.0095f;
        if (this.type == ItemCameraTransforms.TransformType.GUI) {
            scale = 0.008f;
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        EnumSet<ItemSlashBlade.SwordType> types = this.itemBlade.getSwordType(this.targetStack);
        WavefrontObject model = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(this.targetStack));
        String renderTarget = types.contains((Object)ItemSlashBlade.SwordType.Broken) ? "item_damaged" : (!types.contains((Object)ItemSlashBlade.SwordType.NoScabbard) ? "item_blade" : "item_bladens");
        model.renderPart(renderTarget);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        Face.resetColor();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176599_b);
        return this.getEmptyList();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        this.drawStep = 1;
        this.renderPath = 0;
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(this.targetStack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178082_a(SlashBlade.proudSoul);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        this.type = cameraTransformType;
        this.drawStep = 0;
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)ModelRotation.X0_Y0, (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

