/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity.layers;

import java.util.EnumSet;
import mods.flammpfeil.slashblade.client.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.model.obj.Face;
import mods.flammpfeil.slashblade.client.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LayerSlashBlade
implements LayerRenderer<EntityLivingBase> {
    private static final ResourceLocation armoredCreeperTextures = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private final RenderLivingBase<?> render;

    public LayerSlashBlade(RenderLivingBase<?> livingEntityRendererIn) {
        this.render = livingEntityRendererIn;
    }

    float lerp(float start, float end, float percent) {
        return start + percent * (end - start);
    }

    float lerpDegrees(float start, float end, float percent) {
        float diff;
        for (diff = end - start; diff < -180.0f; diff += 360.0f) {
        }
        while (diff >= 180.0f) {
            diff -= 360.0f;
        }
        return start + percent * diff;
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ticksExisted, float yawDiff, float rotationPitch, float scale) {
        GlStateManager.func_179094_E();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        float f5 = 0.0625f;
        this.render(entitylivingbaseIn, partialTicks);
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return true;
    }

    void renderBack(ItemStack item, EntityLivingBase player) {
        float f9;
        float f8;
        float f7;
        NBTTagCompound tag;
        ItemSlashBlade iSlashBlade = (ItemSlashBlade)item.func_77973_b();
        WavefrontObject model = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(item));
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(item);
        EnumSet<ItemSlashBlade.SwordType> swordType = iSlashBlade.getSwordType(item);
        boolean isNoScabbard = swordType.contains((Object)ItemSlashBlade.SwordType.NoScabbard);
        float ax = 0.0f;
        float ay = 0.0f;
        float az = 0.0f;
        boolean isBroken = swordType.contains((Object)ItemSlashBlade.SwordType.Broken);
        int renderType = 0;
        if (item.func_77942_o()) {
            tag = item.func_77978_p();
            ay = -tag.func_74760_g("adjustY") / 10.0f;
            renderType = ItemSlashBlade.StandbyRenderType.get(tag);
            if (isNoScabbard) {
                renderType = 0;
            }
        }
        if (renderType == 0) {
            return;
        }
        if (item.func_77942_o()) {
            tag = item.func_77978_p();
            ax = tag.func_74760_g("adjustX") / 10.0f;
            ay = -tag.func_74760_g("adjustY") / 10.0f;
            az = -tag.func_74760_g("adjustZ") / 10.0f;
        }
        if (renderType != 1) {
            ax = 0.0f;
            az = 0.0f;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        if (this.render.func_177087_b().field_78091_s) {
            float f = 0.5f;
            GlStateManager.func_179109_b((float)0.0f, (float)0.625f, (float)0.0f);
            GlStateManager.func_179114_b((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        }
        ((ModelBiped)this.render.func_177087_b()).field_78115_e.func_78794_c(0.0625f);
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.203125f, (float)0.0f);
        }
        GL11.glShadeModel((int)7425);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)ax, (float)ay, (float)az);
        switch (renderType) {
            case 2: {
                GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.25f);
                float scale = 0.075f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)83.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-12.5f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glTranslatef((float)0.0f, (float)0.4f, (float)0.25f);
                float scale = 0.075f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-12.5f, (float)0.0f);
                break;
            }
            default: {
                GL11.glTranslatef((float)0.25f, (float)0.4f, (float)-0.5f);
                float scale = 0.075f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glPushMatrix();
        String renderTarget = isBroken ? "blade_damaged" : "blade";
        float scaleLocal = 0.095f;
        GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.render.func_110776_a(resourceTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)518, (float)0.05f);
        model.renderPart(renderTarget);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glEnable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (item.func_77962_s()) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            this.render.func_110776_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            f7 = 0.76f;
            Face.setColor(-8372020);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            Face.resetColor();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
        if (!isNoScabbard) {
            GL11.glPushMatrix();
            scaleLocal = 0.095f;
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.render.func_110776_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            renderTarget = "sheath";
            model.renderPart(renderTarget);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            lastx = OpenGlHelper.lastBrightnessX;
            lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            model.renderPart(renderTarget + "_luminous");
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            if (item.func_77962_s()) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                this.render.func_110776_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                f7 = 0.76f;
                Face.setColor(-8372020);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                Face.resetColor();
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glPopMatrix();
        }
        GL11.glShadeModel((int)7424);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    void render(EntityLivingBase entity, float partialTicks) {
        float f9;
        float f8;
        float f7;
        boolean adjust = true;
        if (entity == null) {
            return;
        }
        ItemStack stack = entity.func_184586_b(EnumHand.MAIN_HAND);
        if (stack == null || !(stack.func_77973_b() instanceof ItemSlashBlade)) {
            if (entity instanceof EntityPlayer) {
                ItemStack firstItem = ((EntityPlayer)entity).field_71071_by.func_70301_a(0);
                if (adjust && firstItem != null && firstItem.func_77973_b() instanceof ItemSlashBlade) {
                    this.renderBack(firstItem, (EntityLivingBase)((EntityPlayer)entity));
                }
            }
            return;
        }
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        ItemSlashBlade itemBlade = (ItemSlashBlade)stack.func_77973_b();
        WavefrontObject model = BladeModelManager.getInstance().getModel(ItemSlashBlade.getModelLocation(stack));
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(stack);
        EnumSet<ItemSlashBlade.SwordType> swordType = itemBlade.getSwordType(stack);
        if (swordType.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
            this.doHeldItemRenderLayer(entity, swordType, model);
            return;
        }
        ((ModelBiped)this.render.func_177087_b()).field_78115_e.func_78794_c(0.0625f);
        boolean isEnchanted = swordType.contains((Object)ItemSlashBlade.SwordType.Enchanted);
        boolean isBewitched = swordType.contains((Object)ItemSlashBlade.SwordType.Bewitched);
        int charge = entity instanceof EntityPlayer ? entity.func_184612_cw() : 0;
        float ax = 0.0f;
        float ay = 0.0f;
        float az = 0.0f;
        boolean isBroken = swordType.contains((Object)ItemSlashBlade.SwordType.Broken);
        ItemSlashBlade.ComboSequence combo = ItemSlashBlade.ComboSequence.None;
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            combo = ItemSlashBlade.getComboSequence(tag);
            if (adjust) {
                ax = tag.func_74760_g("adjustX") / 10.0f;
                ay = -tag.func_74760_g("adjustY") / 10.0f;
                az = -tag.func_74760_g("adjustZ") / 10.0f;
            }
        }
        float progress = entity.func_70678_g(partialTicks);
        if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None) && entity.field_70733_aJ == 0.0f) {
            progress = 1.0f;
        }
        if (1.0f < (progress = (float)((double)progress * 1.2))) {
            progress = 1.0f;
        }
        switch (combo) {
            case SIai: 
            case Iai: {
                progress = 1.0f - Math.abs(progress - 0.5f) * 2.0f;
                break;
            }
            case HiraTuki: {
                progress = 1.0f;
                break;
            }
            default: {
                progress = 1.0f - progress;
                progress = 1.0f - (float)Math.pow(progress, 2.0);
            }
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)ax, (float)ay, (float)az);
        GL11.glTranslatef((float)0.25f, (float)0.4f, (float)-0.5f);
        float scale = 0.075f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float xoffset = 10.0f;
        float yoffset = 8.0f;
        GL11.glPushMatrix();
        if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None)) {
            float tmp = progress;
            if (combo.swingAmplitude < 0.0f) {
                progress = 1.0f - progress;
            }
            if (combo.equals((Object)ItemSlashBlade.ComboSequence.HiraTuki)) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-26.0f);
            }
            if (combo.equals((Object)ItemSlashBlade.ComboSequence.Kiriorosi)) {
                GL11.glRotatef((float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-8.0f);
                GL11.glRotatef((float)(90.0f - combo.swingDirection), (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glRotatef((float)((1.0f - progress) * -90.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTranslatef((float)0.0f, (float)((1.0f - progress) * -5.0f), (float)0.0f);
                GL11.glTranslatef((float)((1.0f - progress) * 10.0f), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                progress = 1.0f;
                if (0.0f < combo.swingAmplitude) {
                    GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                } else {
                    GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else if (combo.swingDirection < 0.0f) {
                GL11.glRotatef((float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-12.0f);
                GL11.glRotatef((float)(90.0f + combo.swingDirection), (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glRotatef((float)((1.0f - progress) * -240.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                progress = 1.0f;
                if (0.0f < combo.swingAmplitude) {
                    GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                } else {
                    GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)(progress * 20.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(progress * -30.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glRotatef((float)(progress * (90.0f - combo.swingDirection)), (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                if (0.0f < combo.swingAmplitude) {
                    GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                } else {
                    GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
            }
            progress = tmp;
        }
        String renderTarget = isBroken ? "blade_damaged" : "blade";
        float scaleLocal = 0.095f;
        GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.render.func_110776_a(resourceTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)518, (float)0.05f);
        model.renderPart(renderTarget);
        if (!combo.useScabbard) {
            model.renderPart(renderTarget + "_unsheathe");
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        if (!combo.useScabbard) {
            model.renderPart(renderTarget + "_unsheathe_luminous");
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glEnable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (stack.func_77962_s()) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            this.render.func_110776_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            f7 = 0.76f;
            Face.setColor(-8372020);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            Face.resetColor();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None) && combo.useScabbard) {
            if (combo.swingAmplitude < 0.0f) {
                progress = 1.0f - progress;
            }
            GL11.glRotatef((float)(progress * 20.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(progress * -30.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glRotatef((float)(progress * (90.0f - combo.swingDirection)), (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
            if (0.0f < combo.swingAmplitude) {
                GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
            } else {
                GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
            GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        scaleLocal = 0.095f;
        GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.render.func_110776_a(resourceTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)518, (float)0.05f);
        renderTarget = "sheath";
        model.renderPart(renderTarget);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        lastx = OpenGlHelper.lastBrightnessX;
        lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glEnable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (stack.func_77962_s()) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            this.render.func_110776_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            f7 = 0.76f;
            Face.setColor(-8372020);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            Face.resetColor();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
        if (!isBroken && isEnchanted && (ItemSlashBlade.RequiredChargeTick < charge || combo.isCharged)) {
            GL11.glPushMatrix();
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            float f4 = 3.0f;
            GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)3.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glPushMatrix();
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart("sheath");
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            float ff1 = (float)entity.field_70173_aa + partialTicks;
            this.render.func_110776_a(armoredCreeperTextures);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            float f2 = ff1 * 0.03f;
            float f3 = ff1 * 0.02f;
            GL11.glTranslatef((float)f2, (float)(-f3), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)3042);
            f4 = 1.0f;
            GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glPushMatrix();
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart("effect");
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void doHeldItemRenderLayer(EntityLivingBase entitylivingbaseIn, EnumSet<ItemSlashBlade.SwordType> types, WavefrontObject model) {
        if (!(this.render.func_177087_b() instanceof ModelBiped)) {
            return;
        }
        ItemStack itemstack = entitylivingbaseIn.func_184586_b(EnumHand.MAIN_HAND);
        if (itemstack != null) {
            GlStateManager.func_179094_E();
            if (this.render.func_177087_b().field_78091_s) {
                float f = 0.5f;
                GlStateManager.func_179109_b((float)0.0f, (float)0.625f, (float)0.0f);
                GlStateManager.func_179114_b((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)f, (float)f, (float)f);
            }
            ((ModelBiped)this.render.func_177087_b()).func_187073_a(0.0625f, entitylivingbaseIn.func_184591_cq());
            GlStateManager.func_179109_b((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            Item item = itemstack.func_77973_b();
            Minecraft minecraft = Minecraft.func_71410_x();
            if (entitylivingbaseIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.203125f, (float)0.0f);
            }
            ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(itemstack);
            this.render.func_110776_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            GL11.glTranslatef((float)0.0f, (float)0.15f, (float)0.0f);
            float scale = 0.008f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            String[] renderTargets = types.contains((Object)ItemSlashBlade.SwordType.NoScabbard) ? (types.contains((Object)ItemSlashBlade.SwordType.Broken) ? new String[]{"blade_damaged"} : new String[]{"blade"}) : new String[]{"sheath", "blade"};
            model.renderOnly(renderTargets);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float lastx = OpenGlHelper.lastBrightnessX;
            float lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            for (String renderTarget : renderTargets) {
                model.renderPart(renderTarget + "_luminous");
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179121_F();
        }
    }
}

