/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import com.google.common.collect.Queues;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ScheduleEntitySpawner {
    private Queue<Entity> targetQueue = Queues.newConcurrentLinkedQueue();

    public static ScheduleEntitySpawner getInstance() {
        return SingletonHolder.instance;
    }

    private ScheduleEntitySpawner() {
    }

    public boolean offer(Entity entity) {
        return this.targetQueue.offer(entity);
    }

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        Entity entity = this.targetQueue.poll();
        while (entity != null) {
            if (entity.field_70170_p != null) {
                entity.field_70170_p.func_72838_d(entity);
            }
            entity = this.targetQueue.poll();
        }
    }

    private static final class SingletonHolder {
        private static final ScheduleEntitySpawner instance = new ScheduleEntitySpawner();

        private SingletonHolder() {
        }
    }
}

