/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialattack;

import java.util.List;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntityWitherSword;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialattack.SpecialAttackBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlisteringWitherSwords
extends SpecialAttackBase {
    @Override
    public String toString() {
        return "BlisteringWitherSwords";
    }

    @Override
    public void doSpacialAttack(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!world.field_72995_K) {
            Entity tmp;
            ItemSlashBlade blade = (ItemSlashBlade)stack.func_77973_b();
            Entity target = null;
            int entityId = ItemSlashBlade.TargetEntityId.get(tag);
            if (entityId != 0 && (tmp = world.func_73045_a(entityId)) != null && tmp.func_70032_d((Entity)player) < 30.0f) {
                target = tmp;
            }
            if (target == null) {
                target = this.getEntityToWatch(player);
            }
            if (target != null) {
                ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.SlashDim);
                int cost = -40;
                if (!ItemSlashBlade.ProudSoul.tryAdd(tag, -40, false)) {
                    stack.func_77972_a(10, (EntityLivingBase)player);
                }
                StylishRankManager.setNextAttackType((Entity)player, StylishRankManager.AttackTypes.PhantomSword);
                blade.attackTargetEntity(stack, target, player, true);
                player.func_71009_b(target);
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                if (target instanceof EntityLivingBase) {
                    blade.setDaunting((EntityLivingBase)target);
                    ((EntityLivingBase)target).field_70737_aN = 0;
                    ((EntityLivingBase)target).field_70172_ad = 0;
                }
                int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
                float magicDamage = 1.0f + ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * ((float)level / 5.0f);
                int count = 1 + StylishRankManager.getStylishRank((Entity)player);
                for (int i = 0; i < count; ++i) {
                    if (world.field_72995_K) continue;
                    boolean isBurst = i % 2 == 0;
                    EntityWitherSword entityDrive = new EntityWitherSword(world, (EntityLivingBase)player, magicDamage, 90.0f);
                    if (entityDrive == null) continue;
                    entityDrive.setInterval(7 + i * 2);
                    entityDrive.setLifeTime(30);
                    int color = isBurst ? -6854348 : -1842204;
                    entityDrive.setColor(color);
                    entityDrive.setBurst(isBurst);
                    entityDrive.setTargetEntityId(target.func_145782_y());
                    world.func_72838_d((Entity)entityDrive);
                }
            }
        }
        ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.Kiriorosi);
    }

    private Entity getEntityToWatch(EntityPlayer player) {
        World world = player.field_70170_p;
        Entity target = null;
        for (int dist = 2; dist < 20; dist += 2) {
            AxisAlignedBB bb = player.func_174813_aQ();
            Vec3d vec = player.func_70040_Z();
            vec = vec.func_72432_b();
            bb = bb.func_72314_b(2.0, 0.25, 2.0);
            bb = bb.func_72317_d(vec.field_72450_a * (double)dist, vec.field_72448_b * (double)dist, vec.field_72449_c * (double)dist);
            List list = world.func_175674_a((Entity)player, bb, EntitySelectorAttackable.getInstance());
            float distance = 30.0f;
            for (Entity curEntity : list) {
                float curDist = curEntity.func_70032_d((Entity)player);
                if (!(curDist < distance)) continue;
                target = curEntity;
                distance = curDist;
            }
            if (target != null) break;
        }
        return target;
    }
}

