/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialeffect;

import com.google.common.collect.Sets;
import java.util.Set;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.CrystalHealing;
import mods.flammpfeil.slashblade.specialeffect.ISpecialEffect;
import mods.flammpfeil.slashblade.specialeffect.WitherEdge;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SpecialEffects {
    private static Set<ISpecialEffect> effects = Sets.newHashSet();
    public static ISpecialEffect WitherEdge = SpecialEffects.register(new WitherEdge());
    public static ISpecialEffect CrystalHealing = SpecialEffects.register(new CrystalHealing());

    public static ISpecialEffect register(ISpecialEffect effect) {
        effects.add(effect);
        return effect;
    }

    public static void init() {
        for (ISpecialEffect effect : effects) {
            effect.register();
        }
    }

    public static ItemStack addEffect(ItemStack blade, ISpecialEffect effect) {
        return SpecialEffects.addEffect(blade, effect.getEffectKey(), effect.getDefaultRequiredLevel());
    }

    public static ItemStack addEffect(ItemStack blade, String key, int requiredLevel) {
        NBTTagCompound etag = ItemSlashBlade.getSpecialEffect(blade);
        etag.func_74768_a(key, requiredLevel);
        return blade;
    }

    public static boolean isPlayer(Entity target) {
        if (target == null) {
            return false;
        }
        if (target.field_70170_p == null) {
            return false;
        }
        if (target.field_70170_p.field_72995_K) {
            return false;
        }
        return target instanceof EntityPlayer;
    }

    public static boolean isBlade(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemSlashBlade;
    }

    public static State isEffective(EntityPlayer player, ItemStack blade, ISpecialEffect effect) {
        return SpecialEffects.isEffective(player, blade, effect.getEffectKey());
    }

    public static State isEffective(EntityPlayer player, ItemStack blade, String EffectKey) {
        NBTTagCompound tag = ItemSlashBlade.getSpecialEffect(blade);
        int requiredLevel = tag.func_74762_e(EffectKey);
        if (0 == requiredLevel) {
            return State.None;
        }
        if (requiredLevel <= player.field_71068_ca) {
            return State.Effective;
        }
        return State.NonEffective;
    }

    public static enum State {
        None,
        NonEffective,
        Effective;

    }
}

