/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.stats;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.flammpfeil.slashblade.RecipeWrapBlade;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.stats.AchievementEx;
import mods.flammpfeil.slashblade.util.SlashBladeAchievementCreateEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.IStatStringFormat;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AchievementList {
    public static final AchievementList INSTANCE = new AchievementList();
    public static Map<String, String> craftingTrigger = Maps.newHashMap();
    public static Map<String, Achievement> achievements = Maps.newHashMap();
    public static Map<String, Integer> achievementIcons = Maps.newHashMap();
    static int defaultX;
    static int defaultY;
    static int minY;
    public static Pattern PosPattern;
    static boolean isLoaded;
    public static AchievementEx currentMouseOver;

    public static ItemStack getIconStack(String name) {
        ItemStack stack = SlashBlade.getCustomBlade("proudsoul");
        stack.func_77964_b(achievementIcons.get(name).intValue());
        return stack;
    }

    public static void setContent(Achievement achievement, String contentKey) {
        if (!(achievement instanceof AchievementEx)) {
            return;
        }
        if (!SlashBlade.recipeMultimap.containsKey((Object)contentKey)) {
            return;
        }
        ((AchievementEx)achievement).content = Lists.newArrayList((Iterable)SlashBlade.recipeMultimap.get((Object)contentKey));
    }

    public static void init() {
        StatBase stat;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        Stack<Achievement> parent = new Stack<Achievement>();
        parent.push(AchievementList.registerAchievement("slashWoodenSword", AchievementList.getIconStack("slash"), net.minecraft.stats.AchievementList.field_187991_r).func_75966_h());
        parent.push(AchievementList.registerCraftingAchievement("buildWoodenBlade", SlashBlade.getCustomBlade("slashbladeWood"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "slashbladeWood");
        parent.push(AchievementList.registerCraftingAchievement("takemitu", SlashBlade.getCustomBlade("slashbladeBambooLight"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "slashbladeBambooLight");
        parent.push(AchievementList.registerCraftingAchievement("ginsitakemitu", SlashBlade.getCustomBlade("slashbladeSilverBambooLight"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "slashbladeSilverBambooLight");
        parent.push(AchievementList.registerAchievement("saya", SlashBlade.getCustomBlade("slashbladeWrapper"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerCraftingAchievement("bamboo", SlashBlade.getCustomBlade("wrap.BambooMod.katana.sample"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "wrap.BambooMod.katana.sample");
        parent.push(AchievementList.registerCraftingAchievement("foxwhite", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.fox.white"), (Achievement)parent.peek()).func_75987_b());
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.fox.white");
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("foxblack", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.fox.black"), (Achievement)parent.peek()).func_75987_b());
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.fox.black");
        parent.pop();
        parent.pop();
        for (Map.Entry<String, String> entry : RecipeWrapBlade.wrapableTextureNames.entrySet()) {
            String[] modid = entry.getKey().split(":");
            if (modid.length != 2 || modid[0].length() == 0 || !Loader.isModLoaded((String)modid[0])) continue;
            AchievementList.registerCraftingAchievement("wrap." + entry.getValue(), RecipeWrapBlade.getWrapSampleBlade(entry.getKey(), entry.getValue()), (Achievement)parent.peek());
        }
        parent.pop();
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("tagayasan", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.tagayasan"), (Achievement)parent.peek()).func_75987_b());
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.tagayasan");
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("buildWhiteSheath", SlashBlade.getCustomBlade("slashbladeWhite"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "slashbladeWhite");
        parent.push(AchievementList.registerAchievement("brokenWhiteSheath", SlashBlade.getCustomBlade("BrokenBladeWhite"), (Achievement)parent.peek()).func_75987_b());
        parent.push(AchievementList.registerCraftingAchievement("buildSlashBlade", SlashBlade.getCustomBlade("slashblade"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "slashblade");
        ItemStack blade = SlashBlade.getCustomBlade("slashblade");
        blade.func_77966_a(Enchantments.field_77334_n, 1);
        parent.push(AchievementList.registerAchievement("enchanted", blade, (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("bewitched", blade, (Achievement)parent.peek()).func_75987_b());
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("muramasa", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.muramasa"), (Achievement)parent.peek()).func_75987_b());
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.muramasa");
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("tukumo", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.yuzukitukumo"), (Achievement)parent.peek()).func_75987_b());
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.yuzukitukumo");
        parent.pop();
        parent.pop();
        parent.pop();
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("noname", SlashBlade.getCustomBlade("slashbladeNamed"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "slashbladeNamed");
        parent.pop();
        parent.push(AchievementList.registerAchievement("hundredKill", AchievementList.getIconStack("hundredKill"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("thousandKill", AchievementList.getIconStack("thousandKill"), (Achievement)parent.peek()).func_75987_b());
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerAchievement("soulEater", AchievementList.getIconStack("soulEater"), (Achievement)parent.peek()));
        parent.pop();
        parent.push(AchievementList.registerAchievement("proudSoul", SlashBlade.getCustomBlade("proudsoul"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "proudsoul");
        parent.push(AchievementList.registerCraftingAchievement("tinySoul", SlashBlade.getCustomBlade("tiny_bladesoul"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "tiny_bladesoul");
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("soulIngot", SlashBlade.getCustomBlade("ingot_bladesoul"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "ingot_bladesoul");
        parent.push(AchievementList.registerCraftingAchievement("soulSphere", SlashBlade.getCustomBlade("sphere_bladesoul"), (Achievement)parent.peek()).func_75987_b());
        AchievementList.setContent((Achievement)parent.peek(), "sphere_bladesoul");
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerAchievement("enchantmentSoul", SlashBlade.getCustomBlade("tiny_bladesoul"), (Achievement)parent.peek()).func_75987_b());
        parent.pop();
        parent.push(AchievementList.registerAchievement("bladeStand", AchievementList.getIconStack("stand"), (Achievement)parent.peek()));
        parent.pop();
        parent.push(AchievementList.registerAchievement("phantomSword", new ItemStack(Items.field_151048_u), (Achievement)parent.peek()));
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerAchievement("rankD", AchievementList.getIconStack("rankD"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("rankC", AchievementList.getIconStack("rankC"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("rankB", AchievementList.getIconStack("rankB"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("rankA", AchievementList.getIconStack("rankA"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("rankS", AchievementList.getIconStack("rankS"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("rankSS", AchievementList.getIconStack("rankSS"), (Achievement)parent.peek()));
        parent.push(AchievementList.registerAchievement("rankSSS", AchievementList.getIconStack("rankSSS"), (Achievement)parent.peek()).func_75987_b());
        parent.pop();
        parent.pop();
        parent.pop();
        parent.pop();
        parent.pop();
        parent.pop();
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("brokenYamato", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.yamato.broken"), net.minecraft.stats.AchievementList.field_76002_B));
        parent.push(AchievementList.registerCraftingAchievement("yamato", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.yamato"), (Achievement)parent.peek()).func_75987_b());
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.yamato");
        parent.pop();
        parent.pop();
        parent.push(AchievementList.registerCraftingAchievement("sabigatana", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.sabigatana.broken"), net.minecraft.stats.AchievementList.field_187992_s));
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.sabigatana");
        parent.push(AchievementList.registerCraftingAchievement("doutanuki", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.doutanuki"), (Achievement)parent.peek()));
        AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.doutanuki");
        parent.pop();
        parent.pop();
        Achievement startParent = net.minecraft.stats.AchievementList.field_187992_s;
        if (Loader.isModLoaded((String)"TwilightForest")) {
            stat = StatList.func_151177_a((String)"TwilightForest6");
            if (stat != null && stat instanceof Achievement) {
                startParent = (Achievement)stat;
            }
            parent.push(AchievementList.registerCraftingAchievement("agitoRust", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.agito.rust"), startParent));
            parent.push(AchievementList.registerCraftingAchievement("agito", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.agito"), (Achievement)parent.peek()));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.agito");
            parent.pop();
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187992_s;
        if (Loader.isModLoaded((String)"TwilightForest")) {
            stat = StatList.func_151177_a((String)"TwilightForest30");
            if (stat != null && stat instanceof Achievement) {
                startParent = (Achievement)stat;
            }
            parent.push(AchievementList.registerCraftingAchievement("orotiagitoRust", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.orotiagito.rust"), startParent));
            parent.push(AchievementList.registerCraftingAchievement("orotiagitoSealed", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.orotiagito.seald"), (Achievement)parent.peek()));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.orotiagito.seald");
            parent.push(AchievementList.registerCraftingAchievement("orotiagito", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.orotiagito"), (Achievement)parent.peek()).func_75987_b());
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.orotiagito");
            parent.pop();
            parent.pop();
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187992_s;
        if (Loader.isModLoaded((String)"TwilightForest")) {
            stat = StatList.func_151177_a((String)"TwilightForest6");
            if (stat != null && stat instanceof Achievement) {
                startParent = (Achievement)stat;
            }
            parent.push(AchievementList.registerCraftingAchievement("yasha", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.yasha"), startParent));
            parent.pop();
            parent.push(AchievementList.registerCraftingAchievement("yashaTrue", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.yashatrue"), startParent));
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187977_J;
        parent.push(AchievementList.registerCraftingAchievement("sange", SlashBlade.getCustomBlade("flammpfeil.slashblade.named.sange"), startParent));
        parent.pop();
        startParent = net.minecraft.stats.AchievementList.field_187992_s;
        ItemStack blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.darkraven");
        if (blade2 != null) {
            parent.push(AchievementList.registerCraftingAchievement("darkraven", blade2, startParent));
            parent.pop();
        }
        startParent = null;
        blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.fluorescentbar");
        if (blade2 != null) {
            parent.push(AchievementList.registerCraftingAchievement("fluorescentbar", blade2, startParent));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.fluorescentbar");
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187992_s;
        blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.nihil");
        if (blade2 != null) {
            parent.push(AchievementList.registerCraftingAchievement("nihil", blade2, startParent));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.nihil");
            blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.nihilex");
            if (blade2 != null) {
                parent.push(AchievementList.registerCraftingAchievement("nihilex", blade2, (Achievement)parent.peek()));
                AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.nihilex");
                blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.nihilul");
                if (blade2 != null) {
                    parent.push(AchievementList.registerCraftingAchievement("nihilul", blade2, (Achievement)parent.peek()));
                    AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.nihilul");
                    parent.pop();
                }
                if ((blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.crimsoncherry")) != null) {
                    parent.push(AchievementList.registerCraftingAchievement("crimsoncherry", blade2, (Achievement)parent.peek()));
                    AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.crimsoncherry");
                    parent.pop();
                }
                parent.pop();
            }
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187977_J;
        blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.murasamablade");
        if (blade2 != null) {
            parent.push(AchievementList.registerCraftingAchievement("murasama", blade2, startParent));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.murasamablade");
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187992_s;
        blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.wanderer");
        if (blade2 != null) {
            parent.push(AchievementList.registerCraftingAchievement("wanderer", blade2, startParent));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.wanderer");
            blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.wanderer.rfblade");
            if (blade2 != null) {
                parent.push(AchievementList.registerCraftingAchievement("wanderer.rfblade", blade2, (Achievement)parent.peek()));
                AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.wanderer.rfblade");
                parent.pop();
            }
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187972_E;
        blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.frostwolfa");
        if (blade2 != null) {
            parent.push(AchievementList.registerCraftingAchievement("frostwolfa", blade2, startParent));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.frostwolfa");
            parent.pop();
        }
        startParent = net.minecraft.stats.AchievementList.field_187972_E;
        blade2 = SlashBlade.getCustomBlade("flammpfeil.slashblade.named.frostwolfb");
        if (blade2 != null) {
            parent.push(AchievementList.registerCraftingAchievement("frostwolfb", blade2, startParent));
            AchievementList.setContent((Achievement)parent.peek(), "flammpfeil.slashblade.named.frostwolfb");
            parent.pop();
        }
        SlashBlade.InitEventBus.post((Event)new SlashBladeAchievementCreateEvent());
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("SlashBlade", achievements.values().toArray(new Achievement[0])){

            public String getName() {
                return I18n.func_74838_a((String)"flammpfeil.slashblade");
            }
        });
    }

    public static Achievement registerAchievement(String key, ItemStack icon, Achievement parent) {
        String translateKey = AchievementList.getTranslateKey(key);
        int x = defaultX++;
        int y = defaultY;
        String posStr = I18n.func_74838_a((String)("achievement." + translateKey + ".pos"));
        Matcher mat = PosPattern.matcher(posStr.trim());
        if (mat.matches()) {
            x = Integer.parseInt(mat.group(1));
            y = Integer.parseInt(mat.group(2));
            y = Math.max(minY, y);
        }
        Achievement achievement = AchievementList.registerAchievement(key, x, y, icon, parent);
        return achievement;
    }

    public static Achievement registerAchievement(String key, int x, int y, ItemStack icon, Achievement parent) {
        AchievementEx achievement = new AchievementEx(AchievementList.getAchievementKey(key), AchievementList.getTranslateKey(key), x, y, icon, parent);
        achievements.put(achievement.field_75975_e, achievement);
        return achievement.func_75971_g();
    }

    public static Achievement registerCraftingAchievement(Achievement achievement) {
        craftingTrigger.put(achievement.field_75990_d.func_77977_a(), achievement.field_75975_e);
        return achievement;
    }

    public static Achievement registerCraftingAchievement(String key, ItemStack icon, Achievement parent) {
        Achievement achievement = AchievementList.registerAchievement(key, icon, parent);
        return AchievementList.registerCraftingAchievement(achievement);
    }

    public static Achievement registerCraftingAchievement(String key, int x, int y, ItemStack icon, Achievement parent) {
        Achievement achievement = AchievementList.registerAchievement(key, x, y, icon, parent);
        return AchievementList.registerCraftingAchievement(achievement);
    }

    public static Achievement getAchievement(String key) {
        if (key.indexOf(":") < 0) {
            key = AchievementList.getAchievementKey(key);
        }
        Achievement achievement = achievements.get(key);
        return achievement;
    }

    public static void triggerAchievement(EntityPlayer player, String key) {
        Achievement achievement = AchievementList.getAchievement(key);
        if (achievement != null) {
            player.func_71029_a((StatBase)achievement);
        }
    }

    public static void triggerCraftingAchievement(ItemStack stack, EntityPlayer player) {
        if (craftingTrigger.containsKey(stack.func_77977_a())) {
            AchievementList.triggerAchievement(player, craftingTrigger.get(stack.func_77977_a()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (!isLoaded) {
            isLoaded = true;
            IStatStringFormat formatter = new IStatStringFormat(){

                public String func_74535_a(String p_74535_1_) {
                    p_74535_1_ = p_74535_1_.replaceAll("<br>", "\n");
                    return p_74535_1_;
                }
            };
            for (Achievement ach : achievements.values()) {
                ach.func_75988_a(formatter);
            }
        }
    }

    @SubscribeEvent
    public void playerEventItemPickupEvent(PlayerEvent.ItemPickupEvent event) {
        AchievementList.triggerCraftingAchievement(event.pickedUp.func_92059_d(), event.player);
    }

    @SubscribeEvent
    public void livingAttackEvent(LivingAttackEvent event) {
        DamageSource src = event.getSource();
        if (src.func_76355_l() != "player") {
            return;
        }
        Entity e = src.func_76346_g();
        if (e == null) {
            return;
        }
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        ItemStack item = ((EntityPlayer)e).func_184586_b(EnumHand.MAIN_HAND);
        if (item == null) {
            return;
        }
        if (item.func_77973_b() != Items.field_151041_m) {
            return;
        }
        if (item.func_77952_i() != 0) {
            return;
        }
        AchievementList.triggerAchievement((EntityPlayer)e, "slashWoodenSword");
    }

    public static String getAchievementKey(String key) {
        return "flammpfeil.slashblade:achievement." + key;
    }

    public static String getTranslateKey(String key) {
        return "flammpfeil.slashblade." + key;
    }

    static {
        String[] icons = new String[]{"rankA", "rankB", "rankC", "rankD", "rankS", "rankSS", "slash", "soulEater", "hundredKill", "stand"};
        int achievementIconId = 65536;
        for (String s : icons) {
            int id = achievementIconId++;
            achievementIcons.put(s, id);
        }
        String[] effectIcons = new String[]{"rankSSS", "thousandKill"};
        int achievementEffectedIconId = 131072;
        for (String s : effectIcons) {
            int id = achievementEffectedIconId++;
            achievementIcons.put(s, id);
        }
        defaultX = 20;
        defaultY = 5;
        minY = -6;
        PosPattern = Pattern.compile("(-?\\d+)\\s*,\\s*(-?\\d+)");
        isLoaded = false;
        currentMouseOver = null;
    }
}

