
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
		Asset("SOUNDPACKAGE", "sound/tv.fev"),
		Asset("SOUND", "sound/tv.fsb"),
        Asset( "ANIM", "anim/tv.zip" ),
		Asset( "ANIM", "anim/ghost_tv_build.zip" ),
}

local start_inv = {
	"pottedfern_blueprint",
	"trunkvest_winter",
	"slurtle_shellpieces",
	"foliage",
	"foliage",
	"foliage",
	"foliage",
	"foliage"
}

--- Sanity Aura ------------------------------------------------------------------------
local function CalcSanityAura(inst, observer)
    return TUNING.SANITYAURA_SMALL
end

-- Animal Lover --
local function arr2map(data)
	local result = {}
	for k,v in pairs(data) do
		result[v] = true
	end
	return result
end

local innocents = arr2map({
	-- DS
	"bee", "butterfly", "beefalo", "babybeefalo",
	"crow", "robin", "robin_winter",
	"frog", "fireflies", "perd", "koalefant_summer", "koalefant_winter", "penguin",
	"rabbit", "monkey",
	-- RoG
	"catcoon", "mole", "lightninggoat", "buzzard",
})

local function isInnocent(inst, victim)
	if victim.prefab == "rabbit" then
		return not (inst.components.sanity and inst.components.sanity:IsCrazy())
	elseif victim.prefab == "monkey" then
		return not victim:HasTag("nightmare")
	elseif victim.prefab == "lightninggoat" then
		return not victim:HasTag("charged")
	else
		return innocents[victim.prefab]
	end
end
--- Rain Damage ------------------------------------------------------------------------
local function dorainsparks(inst, dt)
    if inst.components.moisture ~= nil and inst.components.moisture:GetMoisture() > 0 then
        local t = GetTime()

        -- Raining, no moisture-giving equipment on head, and moisture is increasing. Pro-rate damage based on waterproofness.
        if inst.components.inventory:GetEquippedMoistureRate(EQUIPSLOTS.HEAD) <= 0 and inst.components.moisture:GetRate() > 0 then
            local waterproofmult =
                (   inst.components.sheltered ~= nil and
                    inst.components.sheltered.sheltered and
                    inst.components.sheltered.waterproofness or 0
                ) +
                (   inst.components.inventory ~= nil and
                    inst.components.inventory:GetWaterproofness() or 0
                )
            if waterproofmult < 1 and t > inst.spark_time + inst.spark_time_offset + waterproofmult * 7 then
                inst.components.health:DoDelta(TUNING.WX78_MAX_MOISTURE_DAMAGE, false, "rain")
                inst.spark_time_offset = 3 + math.random() * 2
                inst.spark_time = t
                local x, y, z = inst.Transform:GetWorldPosition()
                y = y + 1 + math.random() * 1.5
                SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
            end
        elseif t > inst.spark_time + inst.spark_time_offset then -- We have moisture-giving equipment on our head or it is not raining and we are just passively wet (but drying off). Do full damage.
            inst.components.health:DoDelta(
                inst.components.moisture:GetRate() >= 0 and
                TUNING.WX78_MAX_MOISTURE_DAMAGE or
                TUNING.WX78_MOISTURE_DRYING_DAMAGE,
                false, "water")
            inst.spark_time_offset = 3 + math.random() * 2
            inst.spark_time = t
            local x, y, z = inst.Transform:GetWorldPosition()
            y = y + .25 + math.random() * 2
            SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
        end
    end
end

local function onisraining(inst, israining)
    if israining then
        if inst.spark_task == nil then
            inst.spark_task = inst:DoPeriodicTask(.1, dorainsparks, nil, .1)
        end
    elseif inst.spark_task ~= nil then
        inst.spark_task:Cancel()
        inst.spark_task = nil
    end
end

local function onbecametv(inst)
    if not inst.watchingrain then
        inst.watchingrain = true
        inst:WatchWorldState("israining", onisraining)
        onisraining(inst, TheWorld.state.israining)
    end
end

local function onbecameghost(inst)
    if inst.spark_task ~= nil then
        inst.spark_task:Cancel()
        inst.spark_task = nil
    end

    if inst.watchingrain then
        inst.watchingrain = false
        inst:StopWatchingWorldState("israining", onisraining)
    end
end

-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "tv.tex" )
end

-- This initializes for the host only
local master_postinit = function(inst)

	-- choose which sounds this character will play
	inst.soundsname = "tv"
	
	-------- Stats --------
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
	inst.components.health:SetAbsorptionAmount(0.3)
	inst.components.sanity.night_drain_mult = 0
	inst.components.sanity.neg_aura_mult = 2
	inst.components.combat.damagemultiplier = 0.70

	-------- Lights --------
	inst.Light:Enable(true)
	inst.Light:SetRadius(2)
	inst.Light:SetFalloff(.7)
	inst.Light:SetIntensity(.75)
	inst.Light:SetColour(6/255,235/255,164/255)
	
	-------- Robo Code --------
    inst.charged_task = nil
    inst.charge_time = 0
    inst.spark_task = nil
    inst.spark_time = 0
    inst.spark_time_offset = 3
    inst.watchingrain = false
    inst:ListenForEvent("ms_respawnedfromghost", onbecametv)
    inst:ListenForEvent("ms_becameghost", onbecameghost)
    onbecametv(inst)
	
	-------- Sit by the Tv for Comfort --------
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = CalcSanityAura
	inst:AddComponent("insulator")
    inst.components.insulator.insulation = TUNING.INSULATION_SMALL

	------- Love for Animals -------
	inst:ListenForEvent("killed", function(inst, data)
		local victim = data.victim
		if isInnocent(inst, victim) then
			inst.components.sanity:DoDelta(-20)
		end
	end)
	inst:ListenForEvent("onattackother", function(inst, data)
		local target = data.target
		if isInnocent(inst, target) then
			inst.components.sanity:DoDelta(-10)
		end
	end)
end

return MakePlayerCharacter("tv", prefabs, assets, common_postinit, master_postinit, start_inv)