--============================================================
-- YU - BUILDER SCIENCE, PRODUCTION, CULTURE =================
--============================================================
-- Author: Lime
--		With considerable help from Chrisy and LeeS
-- DateCreated: 1/9/2018 20:23:28
--------------------------------------------------------------

--============================================================
-- Includes ==================================================
--============================================================
include("Civ6Common.lua");
include("InstanceManager.lua");
include("SupportFunctions.lua");

--============================================================
-- Builder Gasm ==============================================
--============================================================
-- Builders give science, production, and culture when used up
--		10% boost each time for science and culture
--		20 production (40% initial builder cost) flat
--
--		Production happens in the city working that tile
--------------------------------------------------------------

--------------------------------------------------------------
-- Is Yu Leader
--------------------------------------------------------------
function HasLeaderTrait(LeaderType, traitType)
	for row in GameInfo.LeaderTraits() do
		if (row.LeaderType == LeaderType and row.TraitType == traitType) then return 
			true end
	end
	return false
end

--------------------------------------------------------------
-- Builder gasm --	Edited thoroughly by LeeS because my code
--					is bad
--------------------------------------------------------------
local iBuilder = GameInfo.Units["UNIT_BUILDER"].Index

function LimeYu_BuilderGasm(iPlayer, iUnitID, iNumberChargesRemaining, iPreviousNumberCharges)
	if (iNumberChargesRemaining == 0) then
		print("Unit is out of charges")
		if (iPlayer ~= 63) and (iPlayer ~= -1) -- Just to be safe
		and (HasLeaderTrait(PlayerConfigurations[iPlayer]:GetLeaderTypeName(), "TRAIT_LEADER_LIME_CHINA_YU_GATEWAY")) then
			print("Unit belonged to Yu")

			local pPlayer = Players[iPlayer]
			local pPlayerUnits = pPlayer:GetUnits()
			local pUnit = pPlayerUnits:FindID(iUnitID)	

			if (pUnit:GetType() == iBuilder) then
				print("Unit is a builder")

				ChangeCurrentTechProgress(10, pPlayer, iPlayer)
				print("10% science added")

				ChangeCurrentCivicProgress(10, pPlayer, iPlayer)
				print("10% culture added")

				local city = GetNearestPlayerCity(pUnit:GetX(), pUnit:GetY(), iPlayer)	-- of all the things that won't work
				city:GetBuildQueue():AddProgress(20)									-- this is top of that list
				print("20 production added")
			end
		end
	end
end

Events.UnitChargesChanged.Add(LimeYu_BuilderGasm);

--============================================================
-- LeeS Functions ============================================
--============================================================

--------------------------------------------------------------
-- Get Nearest City -- Made with love by LeeS
--------------------------------------------------------------
function GetNearestPlayerCity(iX, iY, iPlayer)
    local pNearestCity
    local pCities = Players[iPlayer]:GetCities()
    if pCities:GetCount() > 0 then
        local iNearestDistance = 9999
        for i, pCity in pCities:Members() do
            local iCityDistance = Map.GetPlotDistance(iX, iY, pCity:GetX(), pCity:GetY())
            if iCityDistance < iNearestDistance then
                pNearestCity = pCity
                iNearestDistance = iCityDistance
            end
        end
    end
    return pNearestCity
end

--------------------------------------------------------------
-- Change Current Tech Progress -- Made with love by LeeS
--------------------------------------------------------------
function ChangeCurrentTechProgress(iChange, pPlayer, iPlayer)
    local pPlayerTechs = pPlayer:GetTechs()
    if pPlayerTechs ~= nil then
        pPlayerTechs:ChangeCurrentResearchProgress(iChange)
        return true
    else
        print("ChangeCurrentTechProgress: invalid player culture table for player # " .. iPlayer .. ", returning nil")
    end
    return nil
end

--------------------------------------------------------------
-- Change Current Civic Progress -- Made with love by LeeS
--------------------------------------------------------------
function ChangeCurrentCivicProgress(iIntChange, pPlayer, iPlayer)
    local pCulture = pPlayer:GetCulture()
    if pCulture ~= nil then
        pCulture:ChangeCurrentCulturalProgress(iIntChange)
        return true
    else
        print("ChangeCurrentCivicProgress: invalid player culture table for player # " .. iPlayer .. ", returning nil")
    end
    return nil
end