
local initialized = false
local quest_manager = nil
local message_manager = nil

local function initialize()
    if initialized then return end

    quest_manager = sdk.get_managed_singleton("snow.QuestManager")
    if quest_manager == nil then
        return false
    end

    message_manager = sdk.get_managed_singleton("snow.gui.MessageManager")
    if message_manager == nil then
        return false
    end
    
    initialized = true
    return initialized
end

local function on_present()
    if not initialized then
        if not initialize() then
            return
        end
    end

    if imgui.collapsing_header("Side Monster Setter") then
        local quest = quest_manager:call("getActiveQuestData()")
        if quest ~= nil then
            imgui.begin_rect()
            imgui.text("Each Monster has a certain weight (chance) of spawning alongside the main monster.");
            imgui.text("100 Guarantees the monster will spawn, however you should not set more than 2 monsters to 100.");
            imgui.text("In total, the weights should add up to 200.");
            imgui.spacing()

            local param = quest:call("get_RawNormal()")

            local enemy_list = param:get_field("_BossEmType")
            local condition_list = param:get_field("_BossSetCondition")
            local condition_param = param:get_field("_BossSetParam")

            for i = 0, 7 do
                imgui.push_id(i)

                local em_type = enemy_list:call("get_Item", i)
                if em_type ~= 0 then
                    if condition_list:call("get_Item", i) == 14 then
                        local cparam = condition_param:call("get_Item", i)
                        local em_name = message_manager:call("getEnemyNameMessage", em_type)

                        imgui.text(string.format("%s: ", em_name))
                        imgui.same_line()

                        local changed, value = imgui.slider_int("Weight (in %)", cparam, 0, 100)
                        if changed then
                            cparam = value
                        end

                        condition_param:call("set_Item", i, cparam)
                    end
                end

                imgui.pop_id()
            end

            imgui.spacing()
            imgui.end_rect(2)
        else
            imgui.text("Select a Quest first.")
        end
    end
end


re.on_draw_ui(on_present)
