# Embedded file name: deluge\ui\gtkui\aboutdialog.py
import pygtk
pygtk.require('2.0')
import gtk
import pkg_resources
from deluge.ui.client import client
import deluge.common
import common

class AboutDialog:

    def __init__(self):

        def url_hook(dialog, url):
            deluge.common.open_url_in_browser(url)

        gtk.about_dialog_set_url_hook(url_hook)
        self.about = gtk.AboutDialog()
        self.about.set_position(gtk.WIN_POS_CENTER)
        self.about.set_name('Deluge')
        self.about.set_program_name(_('Deluge'))
        version = deluge.common.get_version()
        self.about.set_copyright(_('Copyright %(year_start)s-%(year_end)s Deluge Team') % {'year_start': 2007,
         'year_end': 2017})
        self.about.set_comments(_('A peer-to-peer file sharing program\nutilizing the BitTorrent protocol.') + '\n\n' + _('Client:') + ' %s\n' % version)
        self.about.set_version(version)
        self.about.set_authors([_('Current Developers:'),
         'Andrew Resch',
         'Damien Churchill',
         'John Garland',
         'Calum Lind',
         '',
         'libtorrent (libtorrent.org):',
         'Arvid Norberg',
         '',
         _('Past Developers or Contributors:'),
         'Zach Tibbitts',
         'Alon Zakai',
         'Marcos Mobley',
         'Alex Dedul',
         'Sadrul Habib Chowdhury',
         'Ido Abramovich',
         'Martijn Voncken'])
        self.about.set_artists(['Andrew Wedderburn', 'Andrew Resch'])
        self.about.set_translator_credits('\n'.join(['Aaron Wang Shi',
         'abbigss',
         'ABCdatos',
         'Abcx',
         'Actam',
         'Adam',
         'adaminikisi',
         'adi_oporanu',
         'Adrian Goll',
         'afby',
         'Ahmades',
         'Ahmad Farghal',
         'Ahmad Gharbeia \xd8\xa3\xd8\xad\xd9\x85\xd8\xaf \xd8\xba\xd8\xb1\xd8\xa8\xd9\x8a\xd8\xa9',
         'akira',
         'Aki Sivula',
         'Alan Pepelko',
         'Alberto',
         'Alberto Ferrer',
         'alcatr4z',
         'AlckO',
         'Aleksej Korgenkov',
         'Alessio Treglia',
         'Alexander Ilyashov',
         'Alexander Matveev',
         'Alexander Saltykov',
         'Alexander Taubenkorb',
         'Alexander Telenga',
         'Alexander Yurtsev',
         'Alexandre Martani',
         'Alexandre Rosenfeld',
         'Alexandre Sapata Carbonell',
         'Alexey Osipov',
         'Alin Claudiu Radut',
         'allah',
         'AlSim',
         'Alvaro Carrillanca P.',
         'A.Matveev',
         'Andras Hipsag',
         'Andr\xc3\xa1s K\xc3\xa1r\xc3\xa1sz',
         'Andrea Ratto',
         'Andreas Johansson',
         'Andreas Str',
         'Andr\xc3\xa9 F. Oliveira',
         'AndreiF',
         'andrewh',
         'Angel Guzman Maeso',
         'An\xc3\xadbal Deboni Neto',
         'animarval',
         'Antonio Cono',
         'antoniojreyes',
         'Anton Shestakov',
         'Anton Yakutovich',
         'antou',
         'Arkadiusz Kalinowski',
         'Artin',
         'artir',
         'Astur',
         'Athanasios Lefteris',
         'Athmane MOKRAOUI (ButterflyOfFire)',
         'Augusta Carla Klug',
         'Avoledo Marco',
         'axaard',
         'AxelRafn',
         'Axezium',
         'Ayont',
         'b3rx',
         'Bae Taegil',
         'Bajusz Tam\xc3\xa1s',
         "Balaam's Miracle",
         'Ballestein',
         'Bent Ole Fosse',
         'berto89',
         'bigx',
         'Bjorn Inge Berg',
         'blackbird',
         'Blackeyed',
         'blackmx',
         'BlueSky',
         'Blutheo',
         'bmhm',
         'bob00work',
         'boenki',
         'Bogdan B\xc4\x83dic-Sp\xc4\x83tariu',
         'bonpu',
         'Boone',
         'boss01',
         'Branislav Jovanovi\xc4\x87',
         'bronze',
         'brownie',
         'Brus46',
         'bumper',
         'butely',
         'BXCracer',
         'c0nfidencal',
         'Can Kaya',
         'Carlos Alexandro Becker',
         'cassianoleal',
         'C\xc3\xa9dric.h',
         'C\xc3\xa9sar Rub\xc3\xa9n',
         'chaoswizard',
         'Chen Tao',
         'chicha',
         'Chien Cheng Wei',
         'Christian Kopac',
         'Christian Widell',
         'Christoffer Brodd-Reijer',
         'christooss',
         'CityAceE',
         'Clopy',
         'Clusty',
         'cnu',
         'Commandant',
         'Constantinos Koniaris',
         'Coolmax',
         'cosmix',
         'Costin Chirvasuta',
         'CoVaLiDiTy',
         'cow_2001',
         'Crispin Kirchner',
         'crom',
         'Cruster',
         'Cybolic',
         'Dan Bishop',
         'Danek',
         'Dani',
         'Daniel Demarco',
         'Daniel Ferreira',
         'Daniel Frank',
         'Daniel Holm',
         'Daniel H\xc3\xb8yer Iversen',
         'Daniel Marynicz',
         'Daniel Nylander',
         'Daniel Patriche',
         'Daniel Schildt',
         'Daniil Sorokin',
         'Dante D\xc3\xadaz',
         'Daria Michalska',
         'DarkenCZ',
         'Darren',
         'Daspah',
         'David Eurenius',
         'davidhjelm',
         'David Machakhelidze',
         'Dawid Dziurdzia',
         'Daya Adianto ',
         'dcruz',
         'Deady',
         'Dereck Wonnacott',
         'Devgru',
         'Devid Antonio FiloniDevilDogTG',
         'di0rz`',
         'Dialecti Valsamou',
         'Diego Medeiros',
         'Dkzoffy',
         'Dmitrij D. Czarkoff',
         'Dmitriy Geels',
         'Dmitry Olyenyov',
         'Dominik Kozaczko',
         'Dominik L\xc3\xbcbben',
         'doomster',
         'Dorota Kr\xc3\xb3l',
         'Doyen Philippe',
         'Dread Knight',
         'DreamSonic',
         'duan',
         'Duong Thanh An',
         'DvoglavaZver',
         'dwori',
         'dylansmrjones',
         'Ebuntor',
         'Edgar Alejandro Jarquin Flores',
         'Eetu',
         'ekerazha',
         'Elias Julkunen',
         'elparia',
         'Emberke',
         'Emiliano Goday Caneda',
         'EndelWar',
         'eng.essam',
         'enubuntu',
         'ercangun',
         'Erdal Ronahi',
         'ergin \xc3\xbcresin',
         'Eric',
         '\xc3\x89ric Lassauge',
         'Erlend Finv\xc3\xa5g',
         'Errdil',
         'ethan shalev',
         'Evgeni Spasov',
         'ezekielnin',
         'Fabian Ordelmans',
         'Fabio Mazanatti',
         'F\xc3\xa1bio Nogueira',
         'FaCuZ',
         'Felipe Lerena',
         'Fernando Pereira',
         'fjetland',
         'Florian Sch\xc3\xa4fer',
         'FoBoS',
         'Folke',
         'Force',
         'fosk',
         'fragarray',
         'freddeg',
         'Fr\xc3\xa9d\xc3\xa9ric Perrin',
         'Fredrik Kilegran',
         'FreeAtMind',
         'Fulvio Ciucci',
         'Gabor Kelemen',
         'Galatsanos Panagiotis',
         'Gaussian',
         'gdevitis',
         'Georg Brzyk',
         'George Dumitrescu',
         'Georgi Arabadjiev',
         'Georg Sieber',
         'Gerd Radecke',
         'Germ\xc3\xa1n Heusdens',
         'Gianni Vialetto',
         'Gigih Aji Ibrahim',
         'Giorgio Wicklein',
         'Giovanni Rapagnani',
         'Giuseppe',
         'gl',
         'glen',
         'granjerox',
         'Green Fish',
         'greentea',
         'Greyhound',
         'G. U.',
         'Guillaume BENOIT',
         'Guillaume Pelletier',
         'Gustavo Henrique Klug',
         'gutocarvalho',
         'Guybrush88',
         'Hans R\xc3\xb8dtang',
         'HardDisk',
         'Hargas G\xc3\xa1bor',
         'Heitor Thury Barreiros Barbosa',
         'helios91940',
         'helix84',
         'Helton Rodrigues',
         'Hendrik Luup',
         'Henrique Ferreiro',
         'Henry Goury-Laffont',
         'Hezy Amiel',
         'hidro',
         'hoball',
         'hokten',
         'Holmsss',
         'hristo.num',
         'Hubert \xc5\xbbyci\xc5\x84ski',
         'Hyo',
         'Iarwain',
         'ibe',
         'ibear',
         'Id2ndR',
         'Igor Zubarev',
         'IKON (Ion)',
         'imen',
         'Ionu\xc8\x9b Jula',
         'Isabelle STEVANT',
         'Istv\xc3\xa1n Nyitrai',
         'Ivan Petrovic',
         'Ivan Prignano',
         'IvaSerge',
         'jackmc',
         'Jacks0nxD',
         'Jack Shen',
         'Jacky Yeung',
         'Jacques Stadler',
         'Janek Thomaschewski',
         'Jan Kal\xc3\xa1b',
         'Jan Niklas Hasse',
         'Jasper Groenewegen',
         'Javi Rodr\xc3\xadguez',
         'Jayasimha (\xe0\xb2\x9c\xe0\xb2\xaf\xe0\xb2\xb8\xe0\xb2\xbf\xe0\xb2\x82\xe0\xb2\xb9)',
         'jeannich',
         'Jeff Bailes',
         'Jesse Zilstorff',
         'Joan Duran',
         'Jo\xc3\xa3o Santos',
         'Joar Bagge',
         'Joe Anderson',
         'Joel Calado',
         'Johan Linde',
         'John Garland',
         'Jojan',
         'jollyr0ger',
         'Jonas Bo Grimsgaard',
         'Jonas Granqvist',
         'Jonas Slivka',
         'Jonathan Zeppettini',
         'J\xc3\xb8rgen',
         'J\xc3\xb8rgen Tellnes',
         'jos\xc3\xa9',
         'Jos\xc3\xa9 Geraldo Gouv\xc3\xaaa',
         'Jos\xc3\xa9 Iv\xc3\xa1n Le\xc3\xb3n Islas',
         'Jos\xc3\xa9 Lou C.',
         'Jose Sun',
         'Jr.',
         'Jukka Kauppinen',
         'Juli\xc3\xa1n Alarc\xc3\xb3n',
         'julietgolf',
         'Jusic',
         'Justzupi',
         'Kaarel',
         'Kai Thomsen',
         'Kalman Tarnay',
         'Kamil P\xc3\xa1ral',
         'Kane_F',
         'kaotiks@gmail.com',
         'Kateikyoushii',
         'kaxhinaz',
         'Kazuhiro NISHIYAMA',
         'Kerberos',
         'Keresztes \xc3\x81kos',
         'kevintyk',
         'kiersie',
         'Kimbo^',
         'Kim L\xc3\xbcbbe',
         'kitzOgen',
         'Kjetil Rydland',
         'kluon',
         'kmikz',
         'Knedlyk',
         'koleoptero',
         'K\xc5\x91r\xc3\xb6si Kriszti\xc3\xa1n',
         'Kouta',
         'Krakatos',
         'Kre\xc5\xa1o Kunjas',
         'kripken',
         'Kristaps',
         'Kristian \xc3\x98llegaard',
         'Kristoffer Egil Bonarjee',
         'Krzysztof Janowski',
         'Krzysztof Zawada',
         'Larry Wei Liu',
         'laughterwym',
         'Laur M\xc3\xb5tus',
         'lazka',
         'leandrud',
         'l\xc3\xaa b\xc3\xacnh',
         'Le Coz Florent',
         'Leo',
         'liorda',
         'LKRaider',
         'LoLo_SaG',
         'Long Tran',
         'Lorenz',
         'Low Kian Seong',
         'Luca Andrea Rossi',
         'Luca Ferretti',
         'Lucky LIX',
         'Luis Gomes',
         'Luis Reis',
         '\xc5\x81ukasz Wyszy\xc5\x84ski',
         'luojie-dune',
         'maaark',
         'Maciej Chojnacki',
         'Maciej Meller',
         'Mads Peter Rommedahl',
         'Major Kong',
         'Malaki',
         'malde',
         'Malte Lenz',
         'Mantas Kriau\xc4\x8di\xc5\xabnas',
         'Mara Sorella',
         'Marcin',
         'Marcin Falkiewicz',
         'marcobra',
         'Marco da Silva',
         'Marco de Moulin',
         'Marco Rodrigues',
         'Marcos',
         'Marcos Escalier',
         'Marcos Mobley',
         'Marcus Ekstrom',
         'Marek D\xc4\x99bowski',
         'M\xc3\xa1rio Bu\xc4\x8di',
         'Mario Munda',
         'Marius Andersen',
         'Marius Hudea',
         'Marius Mihai',
         'Mariusz Cielecki',
         'Mark Krapivner',
         'marko-markovic',
         'Markus Brummer',
         'Markus Sutter',
         'Martin',
         'Martin Dybdal',
         'Martin Iglesias',
         'Martin Lettner',
         'Martin Pihl',
         'Masoud Kalali',
         'mat02',
         'Matej Urban\xc4\x8di\xc4\x8d',
         'Mathias-K',
         'Mathieu Ar\xc3\xa8s',
         'Mathieu D. (MatToufoutu)',
         'Mathijs',
         'Matrik',
         'Matteo Renzulli',
         'Matteo Settenvini',
         'Matthew Gadd',
         'Matthias Benkard',
         'Matthias Mail\xc3\xa4nder',
         'Mattias Ohlsson',
         'Mauro de Carvalho',
         'Max Molchanov',
         'Me',
         'MercuryCC',
         'Mert Bozkurt',
         'Mert Dirik',
         'MFX',
         'mhietar',
         'mibtha',
         'Michael Budde',
         'Michael Kaliszka',
         'Michalis Makaronides',
         'Micha\xc5\x82 Tokarczyk',
         'Miguel Pires da Rosa',
         'Mihai Capot\xc4\x83',
         'Miika Mets\xc3\xa4l\xc3\xa4',
         'Mikael Fernblad',
         'Mike Sierra',
         'mikhalek',
         'Milan Prvulovi\xc4\x87',
         'Milo Casagrande',
         'Mindaugas',
         'Miroslav Mateja\xc5\xa1',
         'misel',
         'mithras',
         'Mitja Pagon',
         'M.Kitchen',
         'Mohamed Magdy',
         'moonkey',
         'MrBlonde',
         'muczy',
         'M\xc3\xbcnir Ekinci',
         'Mustafa Temizel',
         'mvoncken',
         'Mytonn',
         'NagyMarton',
         'neaion',
         'Neil Lin',
         'Nemo',
         'Nerijus Arlauskas',
         'Nicklas Larsson',
         'Nicolaj Wyke',
         'Nicola Piovesan',
         'Nicolas Sabatier',
         'Nicolas Velin',
         'Nightfall',
         'NiKoB',
         'Nikolai M. Riabov',
         'Niko_Thien',
         'niska',
         'Nithir',
         'noisemonkey',
         'nomemohes',
         'nosense',
         'null',
         'Nuno Est\xc3\xaav\xc3\xa3o',
         'Nuno Santos',
         'nxxs',
         'nyo',
         'obo',
         'Ojan',
         'Olav Andreas Lindekleiv',
         'oldbeggar',
         'Olivier FAURAX',
         'orphe',
         'osantana',
         'Osman Tosun',
         'OssiR',
         'otypoks',
         'ounn',
         'Oz123',
         '\xc3\x96zg\xc3\xbcr BASKIN',
         'Pablo Carmona A.',
         'Pablo Ledesma',
         'Pablo Navarro Castillo',
         'Paco Molinero',
         'P\xc3\xa5l-Eivind Johnsen',
         'pano',
         'Paolo Naldini',
         'Paracelsus',
         'Patryk13_03',
         'Patryk Skorupa',
         'PattogoTehen',
         'Paul Lange',
         'Pavcio',
         'Pawe\xc5\x82 Wysocki',
         'Pedro Brites Moita',
         'Pedro Clemente Pereira Neto',
         'Pekka "PEXI" Niemist\xc3\xb6',
         'Penegal',
         'Penzo',
         'perdido',
         'Peter Kotrcka',
         'Peter Skov',
         'Peter Van den Bosch',
         'Petter Eklund',
         'Petter Viklund',
         'phatsphere',
         'Phenomen',
         'Philipi',
         'Philippides Homer',
         'phoenix',
         'pidi',
         'Pierre Quillery',
         'Pierre Rudloff',
         'Pierre Slamich',
         'Pietrao',
         'Piotr Str\xc4\x99bski',
         'Piotr Wicijowski',
         'Pittmann Tam\xc3\xa1s',
         'Playmolas',
         'Prescott',
         'Prescott_SK',
         'pronull',
         'Przemys\xc5\x82aw Kulczycki',
         'Pumy',
         'pushpika',
         'PY',
         'qubicllj',
         'r21vo',
         'Rafa\xc5\x82 Bara\xc5\x84ski',
         'rainofchaos',
         'Rajbir',
         'ras0ir',
         'Rat',
         'rd1381',
         'Renato',
         'Rene Hennig',
         'Rene P\xc3\xa4rts',
         'Ricardo Duarte',
         'Richard',
         'Robert Hrovat',
         'Roberth Sjon\xc3\xb8y',
         'Robert Lundmark',
         'Robin Jakobsson',
         'Robin K\xc3\xa5veland',
         'Rodrigo Donado',
         'Roel Groeneveld',
         'rohmaru',
         'Rolf Christensen',
         'Rolf Leggewie',
         'Roni Kantis',
         'Ronmi',
         'Rostislav Raykov',
         'royto',
         'RuiAmaro',
         'Rui Ara\xc3\xbajo',
         'Rui Moura',
         'Rune Svendsen',
         'Rusna',
         'Rytis',
         'Sabirov Mikhail',
         'salseeg',
         'Sami Koskinen',
         'Samir van de Sand',
         'Samuel Arroyo Acu\xc3\xb1a',
         'Samuel R. C. Vale',
         'Sanel',
         'Santi',
         'Santi Mart\xc3\xadnez Cantelli',
         'Sardan',
         'Sargate Kanogan',
         'Sarmad Jari',
         'Sa\xc5\xa1a Bodiro\xc5\xbea',
         'sat0shi',
         'Saulius Pranckevi\xc4\x8dius',
         'Savvas Radevic',
         'Sebastian Krau\xc3\x9f',
         'Sebasti\xc3\xa1n Porta',
         'Sedir',
         'Sefa Denizo\xc4\x9flu',
         'sekolands',
         'Selim Suerkan',
         'semsomi',
         'Sergii Golovatiuk',
         'setarcos',
         'Sheki',
         'Shironeko',
         'Shlomil',
         'silfiriel',
         'Simone Tolotti',
         'Simone Vendemia',
         'sirkubador',
         'S\xc5\x82awomir Wi\xc4\x99ch',
         'slip',
         'slyon',
         'smoke',
         'Sonja',
         'spectral',
         'spin_555',
         'spitf1r3',
         'Spiziuz',
         'Spyros Theodoritsis',
         'SqUe',
         'Squigly',
         'srtck',
         'Stefan Horning',
         'Stefano Maggiolo',
         'Stefano Roberto Soleti',
         'steinberger',
         'St\xc3\xa9phane Travostino',
         'Stephan Klein',
         'Steven De Winter',
         'Stevie',
         'Stian24',
         'stylius',
         'Sukarn Maini',
         'Sunjae Park',
         'Susana Pereira',
         'szymon siglowy',
         'takercena',
         'TAS',
         'Taygeto',
         'temy4',
         'texxxxxx',
         'thamood',
         'Thanos Chatziathanassiou',
         'Tharawut Paripaiboon',
         'Theodoor',
         'Th\xc3\xa9ophane Anestis',
         'Thor Marius K. H\xc3\xb8g\xc3\xa5s',
         'Tiago Silva',
         'Tiago Sousa',
         'Tikkel',
         'tim__b',
         'Tim Bordemann',
         'Tim Fuchs',
         'Tim Kornhammar',
         'Timo',
         'Timo Jyrinki',
         'Timothy Babych',
         'TitkosRejtozo',
         'Tom',
         'Tomas Gustavsson',
         'Tomas Valentukevi\xc4\x8dius',
         'Tomasz Dominikowski',
         'Tomislav Plav\xc4\x8di\xc4\x87',
         'Tom Mannerhagen',
         'Tommy Mikkelsen',
         'Tom Verdaat',
         'Tony Manco',
         'Tor Erling H. Opsahl',
         'Toudi',
         'tqm_z',
         'Trapanator',
         'Tribaal',
         'Triton',
         'TuniX12',
         'Tuomo Sipola',
         'turbojugend_gr',
         'Turtle.net',
         'twilight',
         'tymmej',
         'Ulrik',
         'Umarzuki Mochlis',
         'unikob',
         'Vadim Gusev',
         'Vagi',
         'Valentin Bora',
         'Valmantas Palik\xc5\xa1a',
         'VASKITTU',
         'Vassilis Skoullis',
         'vetal17',
         'vicedo',
         'viki',
         'villads hamann',
         'Vincent Garibal',
         'Vincent Ortalda',
         'vinchi007',
         'Vin\xc3\xadcius de Figueiredo Silva',
         'Vinzenz Vietzke',
         'virtoo',
         'virtual_spirit',
         'Vitor Caike',
         'Vitor Lamas Gatti',
         'Vladimir Lazic',
         'Vladimir Sharshov',
         'Wanderlust',
         'Wander Nauta',
         'Ward De Ridder',
         'WebCrusader',
         'webdr',
         'Wentao Tang',
         'wilana',
         'Wilfredo Ernesto Guerrero Campos',
         'Wim Champagne',
         'World Sucks',
         'Xabi Ezpeleta',
         'Xavi de Moner',
         'XavierToo',
         'XChesser',
         'Xiaodong Xu',
         'xyb',
         'Yaron',
         'Yasen Pramatarov',
         'YesPoX',
         'Yuren Ju',
         'Yves MATHIEU',
         'zekopeko',
         'zhuqin',
         'Zissan',
         '\xce\x93\xce\xb9\xce\xac\xce\xbd\xce\xbd\xce\xb7\xcf\x82 \xce\x9a\xce\xb1\xcf\x84\xcf\x83\xce\xb1\xce\xbc\xcf\x80\xce\xaf\xcf\x81\xce\xb7\xcf\x82',
         '\xd0\x90\xd1\x80\xd1\x82\xd1\x91\xd0\xbc \xd0\x9f\xd0\xbe\xd0\xbf\xd0\xbe\xd0\xb2',
         '\xd0\x9c\xd0\xb8\xd1\x88\xd0\xb0',
         '\xd0\xa8\xd0\xb0\xd0\xb9\xd0\xbc\xd0\xb0\xd1\x80\xd0\xb4\xd0\xb0\xd0\xbd\xd0\xbe\xd0\xb2 \xd0\x9c\xd0\xb0\xd0\xba\xd1\x81\xd0\xb8\xd0\xbc',
         '\xe8\x94\xa1\xe6\x9f\xa5\xe7\x90\x86']))
        self.about.set_wrap_license(True)
        self.about.set_license(_('This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version. \n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. \n\nYou should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses>. \n\nIn addition, as a special exception, the copyright holders give permission to link the code of portions of this program with the OpenSSL library. You must obey the GNU General Public License in all respects for all of the code used other than OpenSSL. \n\nIf you modify file(s) with this exception, you may extend this exception to your version of the file(s), but you are not obligated to do so. If you do not wish to do so, delete this exception statement from your version. If you delete this exception statement from all source files in the program, then also delete it here.'))
        self.about.set_website('http://deluge-torrent.org')
        self.about.set_website_label('deluge-torrent.org')
        self.about.set_icon(common.get_deluge_icon())
        self.about.set_logo(gtk.gdk.pixbuf_new_from_file(deluge.common.get_pixmap('deluge-about.png')))
        if client.connected():
            if not client.is_classicmode():
                self.about.set_comments(self.about.get_comments() + _('Server:') + ' %coreversion%\n')
            self.about.set_comments(self.about.get_comments() + '\n' + _('libtorrent:') + ' %ltversion%\n')

            def on_lt_version(result):
                c = self.about.get_comments()
                c = c.replace('%ltversion%', result)
                self.about.set_comments(c)

            def on_info(result):
                c = self.about.get_comments()
                c = c.replace('%coreversion%', result)
                self.about.set_comments(c)
                client.core.get_libtorrent_version().addCallback(on_lt_version)

            if not client.is_classicmode():
                client.daemon.info().addCallback(on_info)
            else:
                client.core.get_libtorrent_version().addCallback(on_lt_version)

    def run(self):
        self.about.show_all()
        self.about.run()
        self.about.destroy()