# Embedded file name: deluge\ui\gtkui\details_tab.py
import gtk, gtk.glade
from xml.sax.saxutils import escape as xml_escape
from deluge.ui.client import client
import deluge.component as component
from deluge.common import fsize, is_url
from deluge.ui.gtkui.torrentdetails import Tab
from deluge.log import LOG as log

class DetailsTab(Tab):

    def __init__(self):
        Tab.__init__(self)
        glade = component.get('MainWindow').main_glade
        self._name = 'Details'
        self._child_widget = glade.get_widget('details_tab')
        self._tab_label = glade.get_widget('details_tab_label')
        self.label_widgets = [(glade.get_widget('summary_name'), None, ('name',)),
         (glade.get_widget('summary_total_size'), fsize, ('total_size',)),
         (glade.get_widget('summary_num_files'), str, ('num_files',)),
         (glade.get_widget('summary_tracker'), None, ('tracker',)),
         (glade.get_widget('summary_torrent_path'), None, ('save_path',)),
         (glade.get_widget('summary_message'), str, ('message',)),
         (glade.get_widget('summary_hash'), str, ('hash',)),
         (glade.get_widget('summary_comments'), str, ('comment',))]
        return

    def update(self):
        selected = component.get('TorrentView').get_selected_torrents()
        if len(selected) != 0:
            selected = selected[0]
        else:
            self.clear()
            return
        status_keys = ['name',
         'total_size',
         'num_files',
         'tracker',
         'save_path',
         'message',
         'hash',
         'comment']
        session = component.get('SessionProxy')
        session.get_torrent_status(selected, status_keys).addCallback(self._on_get_torrent_status)

    def _on_get_torrent_status(self, status):
        if status is None:
            return
        else:
            for widget in self.label_widgets:
                if widget[1] != None:
                    args = []
                    try:
                        for key in widget[2]:
                            args.append(status[key])

                    except Exception as e:
                        log.debug('Unable to get status value: %s', e)
                        continue

                    txt = widget[1](*args)
                else:
                    txt = status[widget[2][0]]
                txt = xml_escape(txt)
                if widget[0].get_text() != txt:
                    if widget[2][0] == 'comment' and is_url(txt):
                        widget[0].set_markup('<a href="%s">%s</a>' % (txt, txt))
                    else:
                        widget[0].set_markup(txt)

            return

    def clear(self):
        for widget in self.label_widgets:
            widget[0].set_text('')