# -*- coding: UTF-8 -*-
#Remix by lexlong 沙鸥<804381256@qq.com>2020-12-05
# Embedded file name: deluge\ui\gtkui\filtertreeview.py
import gtk
import gtk.glade
import pkg_resources
import warnings
from gobject import GError
import deluge.component as component
import deluge.common
from deluge.log import LOG as log
from deluge.ui.client import client
from deluge.configmanager import ConfigManager
STATE_PIX = {'All': 'all',
 'Downloading': 'downloading',
 'Seeding': 'seeding',
 'Paused': 'inactive',
 'Checking': 'checking',
 'Queued': 'queued',
 'Error': 'alert',
 'Active': 'active'}
TRACKER_PIX = {'All': 'tracker_all',
 'Error': 'tracker_warning'}

def _(message):
    return message


TRANSLATE = {'state': _('状态'),
 'tracker_host': _('Tracker 服务器'),
 'label': _('标签'),
 'All': _('所有'),
 'Downloading': _('下载中'),
 'Seeding': _('做种'),
 'Paused': _('暂停'),
 'Checking': _('校验中'),
 'Queued': _('列队'),
 'Error': _('错误'),
 'Active': _('活动'),
 'none': _('空'),
 'no_label': _('无标签')}
del _

def _t(text):
    if text in TRANSLATE:
        text = TRANSLATE[text]
    return _(text)


FILTER_COLUMN = 5

class FilterTreeView(component.Component):

    def __init__(self):
        component.Component.__init__(self, 'FilterTreeView', interval=2)
        self.window = component.get('MainWindow')
        glade = self.window.main_glade
        self.hpaned = glade.get_widget('hpaned')
        self.scrolled = glade.get_widget('scrolledwindow_sidebar')
        self.sidebar = component.get('SideBar')
        self.config = ConfigManager('gtkui.conf')
        self.tracker_icons = component.get('TrackerIcons')
        self.label_view = gtk.TreeView()
        self.sidebar.add_tab(self.label_view, 'filters', 'Filters')
        self.sidebar.notebook.connect('hide', self._on_hide)
        glade_menu = gtk.glade.XML(pkg_resources.resource_filename('deluge.ui.gtkui', 'glade/filtertree_menu.glade'))
        self.menu = glade_menu.get_widget('filtertree_menu')
        glade_menu.signal_autoconnect({'select_all': self.on_select_all,
         'pause_all': self.on_pause_all,
         'resume_all': self.on_resume_all})
        self.default_menu_items = self.menu.get_children()
        self.treestore = gtk.TreeStore(str, str, str, int, gtk.gdk.Pixbuf, bool)
        column = gtk.TreeViewColumn('Filters')
        column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
        render = gtk.CellRendererPixbuf()
        self.renderpix = render
        column.pack_start(render, expand=False)
        column.add_attribute(render, 'pixbuf', 4)
        render = gtk.CellRendererText()
        column.pack_start(render, expand=False)
        column.set_cell_data_func(render, self.render_cell_data, None)
        self.label_view.append_column(column)
        self.label_view.set_show_expanders(True)
        self.label_view.set_headers_visible(False)
        self.label_view.set_level_indentation(-35)
        gtk.rc_parse_string('style "treeview-style" { GtkTreeView::expander-size = 15 } class "GtkTreeView" style "treeview-style"')
        self.label_view.set_model(self.treestore)
        self.label_view.get_selection().connect('changed', self.on_selection_changed)
        self.create_model_filter()
        self.label_view.connect('button-press-event', self.on_button_press_event)
        style = self.window.window.get_style()
        self.colour_background = style.bg[gtk.STATE_NORMAL]
        self.colour_foreground = style.fg[gtk.STATE_NORMAL]
        return

    def start(self):
        self.cat_nodes = {}
        self.filters = {}
        self.cat_nodes['state'] = self.treestore.append(None, ['cat',
         'state',
         _t('state'),
         0,
         None,
         False])
        self.update_row('state', 'All', 0)
        self.update_row('state', 'Downloading', 0)
        self.update_row('state', 'Seeding', 0)
        self.update_row('state', 'Active', 0)
        self.update_row('state', 'Paused', 0)
        self.update_row('state', 'Queued', 0)
        self.cat_nodes['tracker_host'] = self.treestore.append(None, ['cat',
         'tracker_host',
         _t('tracker_host'),
         0,
         None,
         False])
        self.update_row('tracker_host', 'All', 0)
        self.update_row('tracker_host', 'Error', 0)
        self.update_row('tracker_host', '', 0)
        self.expand_rows = True
        self.selected_path = None
        return

    def stop(self):
        self.treestore.clear()

    def create_model_filter(self):
        self.model_filter = self.treestore.filter_new()
        self.model_filter.set_visible_column(FILTER_COLUMN)
        self.label_view.set_model(self.model_filter)

    def cb_update_filter_tree(self, filter_items):
        for cat in filter_items:
            if cat not in self.cat_nodes:
                self.cat_nodes[cat] = self.treestore.append(None, ['cat',
                 cat,
                 _t(cat),
                 0,
                 None,
                 False])

        visible_filters = []
        for cat, filters in filter_items.iteritems():
            for value, count in filters:
                self.update_row(cat, value, count)
                visible_filters.append((cat, value))

        for cat in self.cat_nodes:
            if cat in filter_items:
                self.treestore.set_value(self.cat_nodes[cat], FILTER_COLUMN, True)
            else:
                self.treestore.set_value(self.cat_nodes[cat], FILTER_COLUMN, False)

        for f in self.filters:
            if f not in visible_filters:
                self.treestore.set_value(self.filters[f], FILTER_COLUMN, False)

        if self.expand_rows:
            self.label_view.expand_all()
            self.expand_rows = False
        if not self.selected_path:
            self.select_default_filter()
        return

    def update_row(self, cat, value, count):

        def on_get_icon(icon):
            if icon:
                self.set_row_image(cat, value, icon.get_filename())

        if (cat, value) in self.filters:
            row = self.filters[cat, value]
            self.treestore.set_value(row, 3, count)
        else:
            pix = self.get_pixmap(cat, value)
            label = value
            if label == '':
                if cat == 'tracker_host':
                    label = _t('none')
                elif cat == 'label':
                    label = _t('no_label')
            elif cat in ('state', 'tracker_host', 'label'):
                label = _t(value)
            row = self.treestore.append(self.cat_nodes[cat], [cat,
             value,
             label,
             count,
             pix,
             True])
            self.filters[cat, value] = row
            if cat == 'tracker_host' and value not in ('All', 'Error') and value:
                d = self.tracker_icons.get(value)
                d.addCallback(on_get_icon)
        self.treestore.set_value(row, FILTER_COLUMN, True)
        return row

    def render_cell_data(self, column, cell, model, row, data):
        """cell renderer"""
        cat = model.get_value(row, 0)
        value = model.get_value(row, 1)
        label = model.get_value(row, 2)
        count = model.get_value(row, 3)
        original_filters = warnings.filters[:]
        warnings.simplefilter('ignore')
        try:
            pix = model.get_value(row, 4)
        finally:
            warnings.filters = original_filters

        if pix:
            self.renderpix.set_property('visible', True)
        else:
            self.renderpix.set_property('visible', False)
        if cat == 'cat':
            txt = label
            cell.set_property('cell-background-gdk', self.colour_background)
            cell.set_property('foreground-gdk', self.colour_foreground)
        else:
            txt = '%s (%s)' % (label, count)
            cell.set_property('cell-background', None)
            cell.set_property('foreground', None)
        cell.set_property('text', txt)
        return

    def get_pixmap(self, cat, value):
        pix = None
        if cat == 'state':
            pix = STATE_PIX.get(value, None)
        elif cat == 'tracker_host':
            pix = TRACKER_PIX.get(value, None)
        if pix:
            try:
                return gtk.gdk.pixbuf_new_from_file(deluge.common.get_pixmap('%s16.png' % pix))
            except GError as e:
                log.warning(e)

        return self.get_transparent_pix(16, 16)

    def get_transparent_pix(self, width, height):
        pix = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, width, height)
        pix.fill(0)
        return pix

    def set_row_image(self, cat, value, filename):
        pix = None
        try:
            pix = gtk.gdk.pixbuf_new_from_file_at_size(filename, 16, 16)
        except Exception as e:
            log.debug(e)

        if not pix:
            pix = self.get_transparent_pix(16, 16)
        row = self.filters[cat, value]
        self.treestore.set_value(row, 4, pix)
        return False

    def on_selection_changed(self, selection):
        try:
            model, row = self.label_view.get_selection().get_selected()
            if not row:
                log.debug('nothing selected')
                return None
            cat = model.get_value(row, 0)
            value = model.get_value(row, 1)
            filter_dict = {cat: [value]}
            if value == 'All' or cat == 'cat':
                filter_dict = {}
            component.get('TorrentView').set_filter(filter_dict)
            self.selected_path = model.get_path(row)
        except Exception as e:
            log.debug(e)
            return None

        return None

    def update(self):
        try:
            hide_cat = []
            if not self.config['sidebar_show_trackers']:
                hide_cat = ['tracker_host']
            client.core.get_filter_tree(self.config['sidebar_show_zero'], hide_cat).addCallback(self.cb_update_filter_tree)
        except Exception as e:
            log.debug(e)

    def on_button_press_event(self, widget, event):
        """This is a callback for showing the right-click context menu.
        NOT YET!
        """
        x, y = event.get_coords()
        path = self.label_view.get_path_at_pos(int(x), int(y))
        if not path:
            return
        else:
            path = path[0]
            cat = self.model_filter[path][0]
            if event.button == 1:
                if cat == 'cat':
                    if self.label_view.row_expanded(path):
                        self.label_view.collapse_row(path)
                    else:
                        self.label_view.expand_row(path, False)
                        if not self.selected_path:
                            self.select_default_filter()
                        else:
                            self.label_view.get_selection().select_path(self.selected_path)
                    return True
            elif event.button == 3:
                x, y = event.get_coords()
                path = self.label_view.get_path_at_pos(int(x), int(y))
                if not path:
                    return
                row = self.model_filter.get_iter(path[0])
                self.cat = self.model_filter.get_value(row, 0)
                self.value = self.model_filter.get_value(row, 1)
                self.count = self.model_filter.get_value(row, 3)
                self.set_menu_sensitivity()
                self.menu.hide()
                self.menu.popup(None, None, None, event.button, event.time)
                self.menu.show()
                if cat == 'cat':
                    return True
            return

    def set_menu_sensitivity(self):
        sensitive = self.cat != 'cat' and self.count != 0
        for item in self.default_menu_items:
            item.set_sensitive(sensitive)

    def select_all(self):
        """for use in popup menu"""
        component.get('TorrentView').treeview.get_selection().select_all()

    def on_select_all(self, event):
        self.select_all()

    def on_pause_all(self, event):
        self.select_all()
        func = getattr(component.get('MenuBar'), 'on_menuitem_%s_activate' % 'pause')
        func(event)

    def on_resume_all(self, event):
        self.select_all()
        func = getattr(component.get('MenuBar'), 'on_menuitem_%s_activate' % 'resume')
        func(event)

    def _on_hide(self, *args):
        self.select_default_filter()

    def select_default_filter(self):
        row = self.filters[('state', 'All')]
        path = self.treestore.get_path(row)
        self.label_view.get_selection().select_path(path)