# Embedded file name: deluge\ui\gtkui\sidebar.py
import gtk
import gtk.glade
import deluge.component as component
import deluge.common
from deluge.configmanager import ConfigManager
from deluge.log import LOG as log

class SideBar(component.Component):
    """
    manages the sidebar-tabs.
    purpose : plugins
    """

    def __init__(self):
        component.Component.__init__(self, 'SideBar')
        self.window = component.get('MainWindow')
        glade = self.window.main_glade
        self.notebook = glade.get_widget('sidebar_notebook')
        self.hpaned = glade.get_widget('hpaned')
        self.config = ConfigManager('gtkui.conf')
        self.tabs = {}
        self.visible(self.config['show_sidebar'])

    def shutdown(self):
        log.debug('hpaned.position: %s', self.hpaned.get_position())
        self.config['sidebar_position'] = self.hpaned.get_position()

    def visible(self, visible):
        if visible:
            if self.config['sidebar_position']:
                self.hpaned.set_position(self.config['sidebar_position'])
            self.notebook.show()
        else:
            self.notebook.hide()
            self.config['sidebar_position'] = self.hpaned.get_position()
            self.hpaned.set_position(-1)
        self.config['show_sidebar'] = visible

    def add_tab(self, widget, tab_name, label):
        """Adds a tab object to the notebook."""
        log.debug('add tab:%s' % tab_name)
        self.tabs[tab_name] = widget
        scrolled = gtk.ScrolledWindow()
        scrolled.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        scrolled.add(widget)
        pos = self.notebook.insert_page(scrolled, gtk.Label(label), -1)
        scrolled.show_all()
        self.after_update()

    def remove_tab(self, tab_name):
        """Removes a tab by name."""
        self.notebook.remove_page(self.notebook.page_num(self.tabs[tab_name]))
        del self.tabs[tab_name]
        self.after_update()

    def after_update(self):
        if len(self.tabs) == 0:
            self.visible(False)
        if len(self.tabs) == 1:
            self.notebook.set_show_tabs(False)
        else:
            self.notebook.set_show_tabs(True)